/*
 * Decompiled with CFR 0.152.
 */
package android.media.soundtrigger;

import android.hardware.soundtrigger.IRecognitionStatusCallback;
import android.hardware.soundtrigger.SoundTrigger;
import android.media.AudioFormat;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.app.ISoundTriggerService;
import com.google.errorprone.annotations.DoNotMock;
import java.io.PrintWriter;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class SoundTriggerDetector
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DBG = false;
    private static String TAG = "SoundTriggerDetector";
    private static int MSG_AVAILABILITY_CHANGED = 1;
    private static int MSG_SOUND_TRIGGER_DETECTED = 2;
    private static int MSG_DETECTION_ERROR = 3;
    private static int MSG_DETECTION_PAUSE = 4;
    private static int MSG_DETECTION_RESUME = 5;
    private Object mLock;
    private ISoundTriggerService mSoundTriggerService;
    private UUID mSoundModelId;
    private Callback mCallback;
    private Handler mHandler;
    private RecognitionCallback mRecognitionCallback;
    public static int RECOGNITION_FLAG_NONE = 0;
    public static int RECOGNITION_FLAG_CAPTURE_TRIGGER_AUDIO = 1;
    public static int RECOGNITION_FLAG_ALLOW_MULTIPLE_TRIGGERS = 2;

    private void $$robo$$android_media_soundtrigger_SoundTriggerDetector$__constructor__(ISoundTriggerService soundTriggerService, UUID soundModelId, Callback callback, Handler handler) {
        this.mLock = new Object();
        this.mSoundTriggerService = soundTriggerService;
        this.mSoundModelId = soundModelId;
        this.mCallback = callback;
        this.mHandler = handler == null ? new MyHandler(this) : new MyHandler(this, handler.getLooper());
        this.mRecognitionCallback = new RecognitionCallback(this);
    }

    private final boolean $$robo$$android_media_soundtrigger_SoundTriggerDetector$startRecognition(int recognitionFlags) {
        boolean captureTriggerAudio = (recognitionFlags & 1) != 0;
        boolean allowMultipleTriggers = (recognitionFlags & 2) != 0;
        try {
            this.mSoundTriggerService.startRecognition(new ParcelUuid(this.mSoundModelId), this.mRecognitionCallback, new SoundTrigger.RecognitionConfig(captureTriggerAudio, allowMultipleTriggers, null, null));
        }
        catch (RemoteException e) {
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_media_soundtrigger_SoundTriggerDetector$stopRecognition() {
        try {
            this.mSoundTriggerService.stopRecognition(new ParcelUuid(this.mSoundModelId), this.mRecognitionCallback);
        }
        catch (RemoteException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_soundtrigger_SoundTriggerDetector$dump(String prefix, PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
        }
    }

    private void __constructor__(ISoundTriggerService iSoundTriggerService, UUID uUID, Callback callback, Handler handler) {
        this.$$robo$$android_media_soundtrigger_SoundTriggerDetector$__constructor__(iSoundTriggerService, uUID, callback, handler);
    }

    SoundTriggerDetector(ISoundTriggerService iSoundTriggerService, UUID uUID, Callback callback, Handler handler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_soundtrigger_SoundTriggerDetector$__constructor__(com.android.internal.app.ISoundTriggerService java.util.UUID android.media.soundtrigger.SoundTriggerDetector$Callback android.os.Handler ), 0, this, iSoundTriggerService, uUID, callback, handler);
    }

    public boolean startRecognition(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("startRecognition", $$robo$$android_media_soundtrigger_SoundTriggerDetector$startRecognition(int ), 0, this, n);
    }

    public boolean stopRecognition() {
        return (boolean)InvokeDynamicSupport.bootstrap("stopRecognition", $$robo$$android_media_soundtrigger_SoundTriggerDetector$stopRecognition(), 0, this);
    }

    public void dump(String string2, PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_media_soundtrigger_SoundTriggerDetector$dump(java.lang.String java.io.PrintWriter ), 0, this, string2, printWriter);
    }

    public /* synthetic */ SoundTriggerDetector() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SoundTriggerDetector)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class MyHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ SoundTriggerDetector this$0;

        private void $$robo$$android_media_soundtrigger_SoundTriggerDetector_MyHandler$__constructor__(SoundTriggerDetector soundTriggerDetector) {
        }

        private void $$robo$$android_media_soundtrigger_SoundTriggerDetector_MyHandler$__constructor__(SoundTriggerDetector soundTriggerDetector, Looper looper) {
        }

        private final void $$robo$$android_media_soundtrigger_SoundTriggerDetector_MyHandler$handleMessage(Message msg) {
            if (this.this$0.mCallback == null) {
                Slog.w("SoundTriggerDetector", "Received message: " + msg.what + " for NULL callback.");
                return;
            }
            switch (msg.what) {
                case 2: {
                    this.this$0.mCallback.onDetected((EventPayload)msg.obj);
                    break;
                }
                case 3: {
                    this.this$0.mCallback.onError();
                    break;
                }
                case 4: {
                    this.this$0.mCallback.onRecognitionPaused();
                    break;
                }
                case 5: {
                    this.this$0.mCallback.onRecognitionResumed();
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }

        private void __constructor__(SoundTriggerDetector soundTriggerDetector) {
            this.$$robo$$android_media_soundtrigger_SoundTriggerDetector_MyHandler$__constructor__(soundTriggerDetector);
        }

        MyHandler(SoundTriggerDetector soundTriggerDetector) {
            this.this$0 = soundTriggerDetector;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_soundtrigger_SoundTriggerDetector_MyHandler$__constructor__(android.media.soundtrigger.SoundTriggerDetector ), 0, this, soundTriggerDetector);
        }

        private void __constructor__(SoundTriggerDetector soundTriggerDetector, Looper looper) {
            this.$$robo$$android_media_soundtrigger_SoundTriggerDetector_MyHandler$__constructor__(soundTriggerDetector, looper);
        }

        MyHandler(SoundTriggerDetector soundTriggerDetector, Looper looper) {
            this.this$0 = soundTriggerDetector;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_soundtrigger_SoundTriggerDetector_MyHandler$__constructor__(android.media.soundtrigger.SoundTriggerDetector android.os.Looper ), 0, this, soundTriggerDetector, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_soundtrigger_SoundTriggerDetector_MyHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ MyHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class RecognitionCallback
    extends IRecognitionStatusCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ SoundTriggerDetector this$0;

        private void $$robo$$android_media_soundtrigger_SoundTriggerDetector_RecognitionCallback$__constructor__(SoundTriggerDetector soundTriggerDetector) {
        }

        private final void $$robo$$android_media_soundtrigger_SoundTriggerDetector_RecognitionCallback$onGenericSoundTriggerDetected(SoundTrigger.GenericRecognitionEvent event) {
            Slog.d("SoundTriggerDetector", "onGenericSoundTriggerDetected()" + event);
            Message.obtain(this.this$0.mHandler, 2, new EventPayload(event.triggerInData, event.captureAvailable, event.captureFormat, event.captureSession, event.data)).sendToTarget();
        }

        private final void $$robo$$android_media_soundtrigger_SoundTriggerDetector_RecognitionCallback$onKeyphraseDetected(SoundTrigger.KeyphraseRecognitionEvent event) {
            Slog.e("SoundTriggerDetector", "Ignoring onKeyphraseDetected() called for " + event);
        }

        private final void $$robo$$android_media_soundtrigger_SoundTriggerDetector_RecognitionCallback$onError(int status) {
            Slog.d("SoundTriggerDetector", "onError()" + status);
            this.this$0.mHandler.sendEmptyMessage(3);
        }

        private final void $$robo$$android_media_soundtrigger_SoundTriggerDetector_RecognitionCallback$onRecognitionPaused() {
            Slog.d("SoundTriggerDetector", "onRecognitionPaused()");
            this.this$0.mHandler.sendEmptyMessage(4);
        }

        private final void $$robo$$android_media_soundtrigger_SoundTriggerDetector_RecognitionCallback$onRecognitionResumed() {
            Slog.d("SoundTriggerDetector", "onRecognitionResumed()");
            this.this$0.mHandler.sendEmptyMessage(5);
        }

        private /* synthetic */ void $$robo$$android_media_soundtrigger_SoundTriggerDetector_RecognitionCallback$__constructor__(SoundTriggerDetector x0, 1 x1) {
        }

        private void __constructor__(SoundTriggerDetector soundTriggerDetector) {
            this.$$robo$$android_media_soundtrigger_SoundTriggerDetector_RecognitionCallback$__constructor__(soundTriggerDetector);
        }

        private RecognitionCallback(SoundTriggerDetector soundTriggerDetector) {
            this.this$0 = soundTriggerDetector;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_soundtrigger_SoundTriggerDetector_RecognitionCallback$__constructor__(android.media.soundtrigger.SoundTriggerDetector ), 0, this, soundTriggerDetector);
        }

        @Override
        public void onGenericSoundTriggerDetected(SoundTrigger.GenericRecognitionEvent genericRecognitionEvent) {
            InvokeDynamicSupport.bootstrap("onGenericSoundTriggerDetected", $$robo$$android_media_soundtrigger_SoundTriggerDetector_RecognitionCallback$onGenericSoundTriggerDetected(android.hardware.soundtrigger.SoundTrigger$GenericRecognitionEvent ), 0, this, genericRecognitionEvent);
        }

        @Override
        public void onKeyphraseDetected(SoundTrigger.KeyphraseRecognitionEvent keyphraseRecognitionEvent) {
            InvokeDynamicSupport.bootstrap("onKeyphraseDetected", $$robo$$android_media_soundtrigger_SoundTriggerDetector_RecognitionCallback$onKeyphraseDetected(android.hardware.soundtrigger.SoundTrigger$KeyphraseRecognitionEvent ), 0, this, keyphraseRecognitionEvent);
        }

        @Override
        public void onError(int n) {
            InvokeDynamicSupport.bootstrap("onError", $$robo$$android_media_soundtrigger_SoundTriggerDetector_RecognitionCallback$onError(int ), 0, this, n);
        }

        @Override
        public void onRecognitionPaused() {
            InvokeDynamicSupport.bootstrap("onRecognitionPaused", $$robo$$android_media_soundtrigger_SoundTriggerDetector_RecognitionCallback$onRecognitionPaused(), 0, this);
        }

        @Override
        public void onRecognitionResumed() {
            InvokeDynamicSupport.bootstrap("onRecognitionResumed", $$robo$$android_media_soundtrigger_SoundTriggerDetector_RecognitionCallback$onRecognitionResumed(), 0, this);
        }

        private /* synthetic */ void __constructor__(SoundTriggerDetector soundTriggerDetector, 1 var2_2) {
            this.$$robo$$android_media_soundtrigger_SoundTriggerDetector_RecognitionCallback$__constructor__(soundTriggerDetector, var2_2);
        }

        public /* synthetic */ RecognitionCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecognitionCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_soundtrigger_SoundTriggerDetector_Callback$__constructor__() {
        }

        public abstract void onAvailabilityChanged(int var1);

        public abstract void onDetected(EventPayload var1);

        public abstract void onError();

        public abstract void onRecognitionPaused();

        public abstract void onRecognitionResumed();

        private void __constructor__() {
            this.$$robo$$android_media_soundtrigger_SoundTriggerDetector_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_soundtrigger_SoundTriggerDetector_Callback$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class EventPayload
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private boolean mTriggerAvailable;
        private boolean mCaptureAvailable;
        private int mCaptureSession;
        private AudioFormat mAudioFormat;
        private byte[] mData;

        private void $$robo$$android_media_soundtrigger_SoundTriggerDetector_EventPayload$__constructor__(boolean triggerAvailable, boolean captureAvailable, AudioFormat audioFormat, int captureSession, byte[] data) {
            this.mTriggerAvailable = triggerAvailable;
            this.mCaptureAvailable = captureAvailable;
            this.mCaptureSession = captureSession;
            this.mAudioFormat = audioFormat;
            this.mData = data;
        }

        private final AudioFormat $$robo$$android_media_soundtrigger_SoundTriggerDetector_EventPayload$getCaptureAudioFormat() {
            return this.mAudioFormat;
        }

        private final byte[] $$robo$$android_media_soundtrigger_SoundTriggerDetector_EventPayload$getTriggerAudio() {
            if (this.mTriggerAvailable) {
                return this.mData;
            }
            return null;
        }

        private final Integer $$robo$$android_media_soundtrigger_SoundTriggerDetector_EventPayload$getCaptureSession() {
            if (this.mCaptureAvailable) {
                return this.mCaptureSession;
            }
            return null;
        }

        private /* synthetic */ void $$robo$$android_media_soundtrigger_SoundTriggerDetector_EventPayload$__constructor__(boolean x0, boolean x1, AudioFormat x2, int x3, byte[] x4, 1 x5) {
        }

        private void __constructor__(boolean bl, boolean bl2, AudioFormat audioFormat, int n, byte[] byArray) {
            this.$$robo$$android_media_soundtrigger_SoundTriggerDetector_EventPayload$__constructor__(bl, bl2, audioFormat, n, byArray);
        }

        private EventPayload(boolean bl, boolean bl2, AudioFormat audioFormat, int n, byte[] byArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_soundtrigger_SoundTriggerDetector_EventPayload$__constructor__(boolean boolean android.media.AudioFormat int byte[] ), 0, this, bl, bl2, audioFormat, n, byArray);
        }

        public AudioFormat getCaptureAudioFormat() {
            return InvokeDynamicSupport.bootstrap("getCaptureAudioFormat", $$robo$$android_media_soundtrigger_SoundTriggerDetector_EventPayload$getCaptureAudioFormat(), 0, this);
        }

        public byte[] getTriggerAudio() {
            return InvokeDynamicSupport.bootstrap("getTriggerAudio", $$robo$$android_media_soundtrigger_SoundTriggerDetector_EventPayload$getTriggerAudio(), 0, this);
        }

        public Integer getCaptureSession() {
            return InvokeDynamicSupport.bootstrap("getCaptureSession", $$robo$$android_media_soundtrigger_SoundTriggerDetector_EventPayload$getCaptureSession(), 0, this);
        }

        private /* synthetic */ void __constructor__(boolean bl, boolean bl2, AudioFormat audioFormat, int n, byte[] byArray, 1 var6_6) {
            this.$$robo$$android_media_soundtrigger_SoundTriggerDetector_EventPayload$__constructor__(bl, bl2, audioFormat, n, byArray, var6_6);
        }

        public /* synthetic */ EventPayload() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventPayload)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

