/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.media.PlaybackParams;
import android.media.tv.TvContentRating;
import android.media.tv.TvInputManager;
import android.media.tv.TvTrackInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pair;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TvView
extends ViewGroup
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "TvView";
    private static boolean DEBUG = false;
    private static int ZORDER_MEDIA = 0;
    private static int ZORDER_MEDIA_OVERLAY = 1;
    private static int ZORDER_ON_TOP = 2;
    private static WeakReference<TvView> NULL_TV_VIEW;
    private static Object sMainTvViewLock;
    private static WeakReference<TvView> sMainTvView;
    private Handler mHandler;
    private TvInputManager.Session mSession;
    private SurfaceView mSurfaceView;
    private Surface mSurface;
    private boolean mOverlayViewCreated;
    private Rect mOverlayViewFrame;
    private TvInputManager mTvInputManager;
    private MySessionCallback mSessionCallback;
    private TvInputCallback mCallback;
    private OnUnhandledInputEventListener mOnUnhandledInputEventListener;
    private Float mStreamVolume;
    private Boolean mCaptionEnabled;
    private Queue<Pair<String, Bundle>> mPendingAppPrivateCommands;
    private boolean mSurfaceChanged;
    private int mSurfaceFormat;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private AttributeSet mAttrs;
    private int mDefStyleAttr;
    private int mWindowZOrder;
    private boolean mUseRequestedSurfaceLayout;
    private int mSurfaceViewLeft;
    private int mSurfaceViewRight;
    private int mSurfaceViewTop;
    private int mSurfaceViewBottom;
    private TimeShiftPositionCallback mTimeShiftPositionCallback;
    private SurfaceHolder.Callback mSurfaceHolderCallback;
    private TvInputManager.Session.FinishedInputEventCallback mFinishedInputEventCallback;

    private void $$robo$$android_media_tv_TvView$__constructor__(Context context) {
    }

    private void $$robo$$android_media_tv_TvView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_media_tv_TvView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mHandler = new Handler();
        this.mPendingAppPrivateCommands = new ArrayDeque<Pair<String, Bundle>>();
        this.mSurfaceHolderCallback = new SurfaceHolder.Callback(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TvView this$0;

            private void $$robo$$android_media_tv_TvView_1$__constructor__(TvView this$0) {
            }

            private final void $$robo$$android_media_tv_TvView_1$surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                this.this$0.mSurfaceFormat = format;
                this.this$0.mSurfaceWidth = width;
                this.this$0.mSurfaceHeight = height;
                this.this$0.mSurfaceChanged = true;
                this.this$0.dispatchSurfaceChanged(this.this$0.mSurfaceFormat, this.this$0.mSurfaceWidth, this.this$0.mSurfaceHeight);
            }

            private final void $$robo$$android_media_tv_TvView_1$surfaceCreated(SurfaceHolder holder) {
                this.this$0.mSurface = holder.getSurface();
                this.this$0.setSessionSurface(this.this$0.mSurface);
            }

            private final void $$robo$$android_media_tv_TvView_1$surfaceDestroyed(SurfaceHolder holder) {
                this.this$0.mSurface = null;
                this.this$0.mSurfaceChanged = false;
                this.this$0.setSessionSurface(null);
            }

            private void __constructor__(TvView tvView) {
                this.$$robo$$android_media_tv_TvView_1$__constructor__(tvView);
            }
            {
                this.this$0 = tvView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvView_1$__constructor__(android.media.tv.TvView ), 0, this, tvView);
            }

            @Override
            public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
                InvokeDynamicSupport.bootstrap("surfaceChanged", $$robo$$android_media_tv_TvView_1$surfaceChanged(android.view.SurfaceHolder int int int ), 0, this, surfaceHolder, n, n2, n3);
            }

            @Override
            public void surfaceCreated(SurfaceHolder surfaceHolder) {
                InvokeDynamicSupport.bootstrap("surfaceCreated", $$robo$$android_media_tv_TvView_1$surfaceCreated(android.view.SurfaceHolder ), 0, this, surfaceHolder);
            }

            @Override
            public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
                InvokeDynamicSupport.bootstrap("surfaceDestroyed", $$robo$$android_media_tv_TvView_1$surfaceDestroyed(android.view.SurfaceHolder ), 0, this, surfaceHolder);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mFinishedInputEventCallback = new TvInputManager.Session.FinishedInputEventCallback(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TvView this$0;

            private void $$robo$$android_media_tv_TvView_2$__constructor__(TvView this$0) {
            }

            private final void $$robo$$android_media_tv_TvView_2$onFinishedInputEvent(Object token, boolean handled) {
                if (handled) {
                    return;
                }
                InputEvent event = (InputEvent)token;
                if (this.this$0.dispatchUnhandledInputEvent(event)) {
                    return;
                }
                ViewRootImpl viewRootImpl = this.this$0.getViewRootImpl();
                if (viewRootImpl != null) {
                    viewRootImpl.dispatchUnhandledInputEvent(event);
                }
            }

            private void __constructor__(TvView tvView) {
                this.$$robo$$android_media_tv_TvView_2$__constructor__(tvView);
            }
            {
                this.this$0 = tvView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvView_2$__constructor__(android.media.tv.TvView ), 0, this, tvView);
            }

            @Override
            public void onFinishedInputEvent(Object object, boolean bl) {
                InvokeDynamicSupport.bootstrap("onFinishedInputEvent", $$robo$$android_media_tv_TvView_2$onFinishedInputEvent(java.lang.Object boolean ), 0, this, object, bl);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mAttrs = attrs;
        this.mDefStyleAttr = defStyleAttr;
        this.resetSurfaceView();
        this.mTvInputManager = (TvInputManager)this.getContext().getSystemService("tv_input");
    }

    private final void $$robo$$android_media_tv_TvView$setCallback(TvInputCallback callback) {
        this.mCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_tv_TvView$setMain() {
        Object object = sMainTvViewLock;
        synchronized (object) {
            sMainTvView = new WeakReference<TvView>(this);
            if (this.hasWindowFocus() && this.mSession != null) {
                this.mSession.setMain();
            }
        }
    }

    private final void $$robo$$android_media_tv_TvView$setZOrderMediaOverlay(boolean isMediaOverlay) {
        if (isMediaOverlay) {
            this.mWindowZOrder = 1;
            this.removeSessionOverlayView();
        } else {
            this.mWindowZOrder = 0;
            this.createSessionOverlayView();
        }
        if (this.mSurfaceView != null) {
            this.mSurfaceView.setZOrderOnTop(false);
            this.mSurfaceView.setZOrderMediaOverlay(isMediaOverlay);
        }
    }

    private final void $$robo$$android_media_tv_TvView$setZOrderOnTop(boolean onTop) {
        if (onTop) {
            this.mWindowZOrder = 2;
            this.removeSessionOverlayView();
        } else {
            this.mWindowZOrder = 0;
            this.createSessionOverlayView();
        }
        if (this.mSurfaceView != null) {
            this.mSurfaceView.setZOrderMediaOverlay(false);
            this.mSurfaceView.setZOrderOnTop(onTop);
        }
    }

    private final void $$robo$$android_media_tv_TvView$setStreamVolume(float volume) {
        this.mStreamVolume = Float.valueOf(volume);
        if (this.mSession == null) {
            return;
        }
        this.mSession.setStreamVolume(volume);
    }

    private final void $$robo$$android_media_tv_TvView$tune(String inputId, Uri channelUri) {
        this.tune(inputId, channelUri, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_tv_TvView$tune(String inputId, Uri channelUri, Bundle params) {
        if (TextUtils.isEmpty(inputId)) {
            throw new IllegalArgumentException("inputId cannot be null or an empty string");
        }
        Object object = sMainTvViewLock;
        synchronized (object) {
            if (sMainTvView.get() == null) {
                sMainTvView = new WeakReference<TvView>(this);
            }
        }
        if (this.mSessionCallback != null && TextUtils.equals(this.mSessionCallback.mInputId, inputId)) {
            if (this.mSession != null) {
                this.mSession.tune(channelUri, params);
            } else {
                this.mSessionCallback.mChannelUri = channelUri;
                this.mSessionCallback.mTuneParams = params;
            }
        } else {
            this.resetInternal();
            this.mSessionCallback = new MySessionCallback(this, inputId, channelUri, params);
            if (this.mTvInputManager != null) {
                this.mTvInputManager.createSession(inputId, this.mSessionCallback, this.mHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_tv_TvView$reset() {
        Object object = sMainTvViewLock;
        synchronized (object) {
            if (this == sMainTvView.get()) {
                sMainTvView = NULL_TV_VIEW;
            }
        }
        this.resetInternal();
    }

    private final void $$robo$$android_media_tv_TvView$resetInternal() {
        this.mSessionCallback = null;
        this.mPendingAppPrivateCommands.clear();
        if (this.mSession != null) {
            this.setSessionSurface(null);
            this.removeSessionOverlayView();
            this.mUseRequestedSurfaceLayout = false;
            this.mSession.release();
            this.mSession = null;
            this.resetSurfaceView();
        }
    }

    private final void $$robo$$android_media_tv_TvView$requestUnblockContent(TvContentRating unblockedRating) {
        this.unblockContent(unblockedRating);
    }

    private final void $$robo$$android_media_tv_TvView$unblockContent(TvContentRating unblockedRating) {
        if (this.mSession != null) {
            this.mSession.unblockContent(unblockedRating);
        }
    }

    private final void $$robo$$android_media_tv_TvView$setCaptionEnabled(boolean enabled) {
        this.mCaptionEnabled = enabled;
        if (this.mSession != null) {
            this.mSession.setCaptionEnabled(enabled);
        }
    }

    private final void $$robo$$android_media_tv_TvView$selectTrack(int type, String trackId) {
        if (this.mSession != null) {
            this.mSession.selectTrack(type, trackId);
        }
    }

    private final List<TvTrackInfo> $$robo$$android_media_tv_TvView$getTracks(int type) {
        if (this.mSession == null) {
            return null;
        }
        return this.mSession.getTracks(type);
    }

    private final String $$robo$$android_media_tv_TvView$getSelectedTrack(int type) {
        if (this.mSession == null) {
            return null;
        }
        return this.mSession.getSelectedTrack(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_tv_TvView$timeShiftPlay(String inputId, Uri recordedProgramUri) {
        if (TextUtils.isEmpty(inputId)) {
            throw new IllegalArgumentException("inputId cannot be null or an empty string");
        }
        Object object = sMainTvViewLock;
        synchronized (object) {
            if (sMainTvView.get() == null) {
                sMainTvView = new WeakReference<TvView>(this);
            }
        }
        if (this.mSessionCallback != null && TextUtils.equals(this.mSessionCallback.mInputId, inputId)) {
            if (this.mSession != null) {
                this.mSession.timeShiftPlay(recordedProgramUri);
            } else {
                this.mSessionCallback.mRecordedProgramUri = recordedProgramUri;
            }
        } else {
            this.resetInternal();
            this.mSessionCallback = new MySessionCallback(this, inputId, recordedProgramUri);
            if (this.mTvInputManager != null) {
                this.mTvInputManager.createSession(inputId, this.mSessionCallback, this.mHandler);
            }
        }
    }

    private final void $$robo$$android_media_tv_TvView$timeShiftPause() {
        if (this.mSession != null) {
            this.mSession.timeShiftPause();
        }
    }

    private final void $$robo$$android_media_tv_TvView$timeShiftResume() {
        if (this.mSession != null) {
            this.mSession.timeShiftResume();
        }
    }

    private final void $$robo$$android_media_tv_TvView$timeShiftSeekTo(long timeMs) {
        if (this.mSession != null) {
            this.mSession.timeShiftSeekTo(timeMs);
        }
    }

    private final void $$robo$$android_media_tv_TvView$timeShiftSetPlaybackParams(PlaybackParams params) {
        if (this.mSession != null) {
            this.mSession.timeShiftSetPlaybackParams(params);
        }
    }

    private final void $$robo$$android_media_tv_TvView$setTimeShiftPositionCallback(TimeShiftPositionCallback callback) {
        this.mTimeShiftPositionCallback = callback;
        this.ensurePositionTracking();
    }

    private final void $$robo$$android_media_tv_TvView$ensurePositionTracking() {
        if (this.mSession == null) {
            return;
        }
        this.mSession.timeShiftEnablePositionTracking(this.mTimeShiftPositionCallback != null);
    }

    private final void $$robo$$android_media_tv_TvView$sendAppPrivateCommand(String action, Bundle data) {
        if (TextUtils.isEmpty(action)) {
            throw new IllegalArgumentException("action cannot be null or an empty string");
        }
        if (this.mSession != null) {
            this.mSession.sendAppPrivateCommand(action, data);
        } else {
            Log.w("TvView", "sendAppPrivateCommand - session not yet created (action \"" + action + "\" pending)");
            this.mPendingAppPrivateCommands.add(Pair.create(action, data));
        }
    }

    private final boolean $$robo$$android_media_tv_TvView$dispatchUnhandledInputEvent(InputEvent event) {
        if (this.mOnUnhandledInputEventListener != null && this.mOnUnhandledInputEventListener.onUnhandledInputEvent(event)) {
            return true;
        }
        return this.onUnhandledInputEvent(event);
    }

    private final boolean $$robo$$android_media_tv_TvView$onUnhandledInputEvent(InputEvent event) {
        return false;
    }

    private final void $$robo$$android_media_tv_TvView$setOnUnhandledInputEventListener(OnUnhandledInputEventListener listener) {
        this.mOnUnhandledInputEventListener = listener;
    }

    private final boolean $$robo$$android_media_tv_TvView$dispatchKeyEvent(KeyEvent event) {
        if (super.dispatchKeyEvent(event)) {
            return true;
        }
        if (this.mSession == null) {
            return false;
        }
        InputEvent copiedEvent = event.copy();
        int ret = this.mSession.dispatchInputEvent(copiedEvent, copiedEvent, this.mFinishedInputEventCallback, this.mHandler);
        return ret != 0;
    }

    private final boolean $$robo$$android_media_tv_TvView$dispatchTouchEvent(MotionEvent event) {
        if (super.dispatchTouchEvent(event)) {
            return true;
        }
        if (this.mSession == null) {
            return false;
        }
        InputEvent copiedEvent = event.copy();
        int ret = this.mSession.dispatchInputEvent(copiedEvent, copiedEvent, this.mFinishedInputEventCallback, this.mHandler);
        return ret != 0;
    }

    private final boolean $$robo$$android_media_tv_TvView$dispatchTrackballEvent(MotionEvent event) {
        if (super.dispatchTrackballEvent(event)) {
            return true;
        }
        if (this.mSession == null) {
            return false;
        }
        InputEvent copiedEvent = event.copy();
        int ret = this.mSession.dispatchInputEvent(copiedEvent, copiedEvent, this.mFinishedInputEventCallback, this.mHandler);
        return ret != 0;
    }

    private final boolean $$robo$$android_media_tv_TvView$dispatchGenericMotionEvent(MotionEvent event) {
        if (super.dispatchGenericMotionEvent(event)) {
            return true;
        }
        if (this.mSession == null) {
            return false;
        }
        InputEvent copiedEvent = event.copy();
        int ret = this.mSession.dispatchInputEvent(copiedEvent, copiedEvent, this.mFinishedInputEventCallback, this.mHandler);
        return ret != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_tv_TvView$dispatchWindowFocusChanged(boolean hasFocus) {
        super.dispatchWindowFocusChanged(hasFocus);
        Object object = sMainTvViewLock;
        synchronized (object) {
            if (hasFocus && this == sMainTvView.get() && this.mSession != null) {
                this.mSession.setMain();
            }
        }
    }

    private final void $$robo$$android_media_tv_TvView$onAttachedToWindow() {
        super.onAttachedToWindow();
        this.createSessionOverlayView();
    }

    private final void $$robo$$android_media_tv_TvView$onDetachedFromWindow() {
        this.removeSessionOverlayView();
        super.onDetachedFromWindow();
    }

    private final void $$robo$$android_media_tv_TvView$onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.mUseRequestedSurfaceLayout) {
            this.mSurfaceView.layout(this.mSurfaceViewLeft, this.mSurfaceViewTop, this.mSurfaceViewRight, this.mSurfaceViewBottom);
        } else {
            this.mSurfaceView.layout(0, 0, right - left, bottom - top);
        }
    }

    private final void $$robo$$android_media_tv_TvView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mSurfaceView.measure(widthMeasureSpec, heightMeasureSpec);
        int width = this.mSurfaceView.getMeasuredWidth();
        int height = this.mSurfaceView.getMeasuredHeight();
        int childState = this.mSurfaceView.getMeasuredState();
        this.setMeasuredDimension(TvView.resolveSizeAndState(width, widthMeasureSpec, childState), TvView.resolveSizeAndState(height, heightMeasureSpec, childState << 16));
    }

    private final boolean $$robo$$android_media_tv_TvView$gatherTransparentRegion(Region region) {
        if (this.mWindowZOrder != 2 && region != null) {
            int width = this.getWidth();
            int height = this.getHeight();
            if (width > 0 && height > 0) {
                int[] location = new int[2];
                this.getLocationInWindow(location);
                int left = location[0];
                int top = location[1];
                region.op(left, top, left + width, top + height, Region.Op.UNION);
            }
        }
        return super.gatherTransparentRegion(region);
    }

    private final void $$robo$$android_media_tv_TvView$draw(Canvas canvas) {
        if (this.mWindowZOrder != 2) {
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        super.draw(canvas);
    }

    private final void $$robo$$android_media_tv_TvView$dispatchDraw(Canvas canvas) {
        if (this.mWindowZOrder != 2) {
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        super.dispatchDraw(canvas);
    }

    private final void $$robo$$android_media_tv_TvView$onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.mSurfaceView.setVisibility(visibility);
        if (visibility == 0) {
            this.createSessionOverlayView();
        } else {
            this.removeSessionOverlayView();
        }
    }

    private final void $$robo$$android_media_tv_TvView$resetSurfaceView() {
        if (this.mSurfaceView != null) {
            this.mSurfaceView.getHolder().removeCallback(this.mSurfaceHolderCallback);
            this.removeView(this.mSurfaceView);
        }
        this.mSurface = null;
        this.mSurfaceView = new ShadowedObject(this, this.getContext(), this.mAttrs, this.mDefStyleAttr){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TvView this$0;

            private void $$robo$$android_media_tv_TvView_3$__constructor__(TvView this$0, Context context, AttributeSet attrs, int defStyleAttr) {
            }

            private final void $$robo$$android_media_tv_TvView_3$updateWindow(boolean force, boolean redrawNeeded) {
                super.updateWindow(force, redrawNeeded);
                this.this$0.relayoutSessionOverlayView();
            }

            private void __constructor__(TvView tvView, Context context, AttributeSet attributeSet, int n) {
                this.$$robo$$android_media_tv_TvView_3$__constructor__(tvView, context, attributeSet, n);
            }
            {
                this.this$0 = tvView;
                super(context, attributeSet, n);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvView_3$__constructor__(android.media.tv.TvView android.content.Context android.util.AttributeSet int ), 0, this, tvView, context, attributeSet, n);
            }

            @Override
            protected void updateWindow(boolean bl, boolean bl2) {
                InvokeDynamicSupport.bootstrap("updateWindow", $$robo$$android_media_tv_TvView_3$updateWindow(boolean boolean ), 0, this, bl, bl2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mSurfaceView.setSecure(true);
        this.mSurfaceView.getHolder().addCallback(this.mSurfaceHolderCallback);
        if (this.mWindowZOrder == 1) {
            this.mSurfaceView.setZOrderMediaOverlay(true);
        } else if (this.mWindowZOrder == 2) {
            this.mSurfaceView.setZOrderOnTop(true);
        }
        this.addView(this.mSurfaceView);
    }

    private final void $$robo$$android_media_tv_TvView$setSessionSurface(Surface surface) {
        if (this.mSession == null) {
            return;
        }
        this.mSession.setSurface(surface);
    }

    private final void $$robo$$android_media_tv_TvView$dispatchSurfaceChanged(int format, int width, int height) {
        if (this.mSession == null) {
            return;
        }
        this.mSession.dispatchSurfaceChanged(format, width, height);
    }

    private final void $$robo$$android_media_tv_TvView$createSessionOverlayView() {
        if (this.mSession == null || !this.isAttachedToWindow() || this.mOverlayViewCreated || this.mWindowZOrder != 0) {
            return;
        }
        this.mOverlayViewFrame = this.getViewFrameOnScreen();
        this.mSession.createOverlayView(this, this.mOverlayViewFrame);
        this.mOverlayViewCreated = true;
    }

    private final void $$robo$$android_media_tv_TvView$removeSessionOverlayView() {
        if (this.mSession == null || !this.mOverlayViewCreated) {
            return;
        }
        this.mSession.removeOverlayView();
        this.mOverlayViewCreated = false;
        this.mOverlayViewFrame = null;
    }

    private final void $$robo$$android_media_tv_TvView$relayoutSessionOverlayView() {
        if (this.mSession == null || !this.isAttachedToWindow() || !this.mOverlayViewCreated || this.mWindowZOrder != 0) {
            return;
        }
        Rect viewFrame = this.getViewFrameOnScreen();
        if (viewFrame.equals(this.mOverlayViewFrame)) {
            return;
        }
        this.mSession.relayoutOverlayView(viewFrame);
        this.mOverlayViewFrame = viewFrame;
    }

    private final Rect $$robo$$android_media_tv_TvView$getViewFrameOnScreen() {
        int[] location = new int[2];
        this.getLocationOnScreen(location);
        return new Rect(location[0], location[1], location[0] + this.getWidth(), location[1] + this.getHeight());
    }

    static void __staticInitializer__() {
        NULL_TV_VIEW = new WeakReference<Object>(null);
        sMainTvViewLock = new Object();
        sMainTvView = NULL_TV_VIEW;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_media_tv_TvView$__constructor__(context);
    }

    public TvView(Context context) {
        this(context, null, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_media_tv_TvView$__constructor__(context, attributeSet);
    }

    public TvView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_media_tv_TvView$__constructor__(context, attributeSet, n);
    }

    public TvView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    public void setCallback(TvInputCallback tvInputCallback) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$android_media_tv_TvView$setCallback(android.media.tv.TvView$TvInputCallback ), 0, this, tvInputCallback);
    }

    public void setMain() {
        InvokeDynamicSupport.bootstrap("setMain", $$robo$$android_media_tv_TvView$setMain(), 0, this);
    }

    public void setZOrderMediaOverlay(boolean bl) {
        InvokeDynamicSupport.bootstrap("setZOrderMediaOverlay", $$robo$$android_media_tv_TvView$setZOrderMediaOverlay(boolean ), 0, this, bl);
    }

    public void setZOrderOnTop(boolean bl) {
        InvokeDynamicSupport.bootstrap("setZOrderOnTop", $$robo$$android_media_tv_TvView$setZOrderOnTop(boolean ), 0, this, bl);
    }

    public void setStreamVolume(float f) {
        InvokeDynamicSupport.bootstrap("setStreamVolume", $$robo$$android_media_tv_TvView$setStreamVolume(float ), 0, this, f);
    }

    public void tune(String string2, Uri uri) {
        InvokeDynamicSupport.bootstrap("tune", $$robo$$android_media_tv_TvView$tune(java.lang.String android.net.Uri ), 0, this, string2, uri);
    }

    public void tune(String string2, Uri uri, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("tune", $$robo$$android_media_tv_TvView$tune(java.lang.String android.net.Uri android.os.Bundle ), 0, this, string2, uri, bundle);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_media_tv_TvView$reset(), 0, this);
    }

    private void resetInternal() {
        InvokeDynamicSupport.bootstrap("resetInternal", $$robo$$android_media_tv_TvView$resetInternal(), 0, this);
    }

    public void requestUnblockContent(TvContentRating tvContentRating) {
        InvokeDynamicSupport.bootstrap("requestUnblockContent", $$robo$$android_media_tv_TvView$requestUnblockContent(android.media.tv.TvContentRating ), 0, this, tvContentRating);
    }

    public void unblockContent(TvContentRating tvContentRating) {
        InvokeDynamicSupport.bootstrap("unblockContent", $$robo$$android_media_tv_TvView$unblockContent(android.media.tv.TvContentRating ), 0, this, tvContentRating);
    }

    public void setCaptionEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCaptionEnabled", $$robo$$android_media_tv_TvView$setCaptionEnabled(boolean ), 0, this, bl);
    }

    public void selectTrack(int n, String string2) {
        InvokeDynamicSupport.bootstrap("selectTrack", $$robo$$android_media_tv_TvView$selectTrack(int java.lang.String ), 0, this, n, string2);
    }

    public List<TvTrackInfo> getTracks(int n) {
        return InvokeDynamicSupport.bootstrap("getTracks", $$robo$$android_media_tv_TvView$getTracks(int ), 0, this, n);
    }

    public String getSelectedTrack(int n) {
        return InvokeDynamicSupport.bootstrap("getSelectedTrack", $$robo$$android_media_tv_TvView$getSelectedTrack(int ), 0, this, n);
    }

    public void timeShiftPlay(String string2, Uri uri) {
        InvokeDynamicSupport.bootstrap("timeShiftPlay", $$robo$$android_media_tv_TvView$timeShiftPlay(java.lang.String android.net.Uri ), 0, this, string2, uri);
    }

    public void timeShiftPause() {
        InvokeDynamicSupport.bootstrap("timeShiftPause", $$robo$$android_media_tv_TvView$timeShiftPause(), 0, this);
    }

    public void timeShiftResume() {
        InvokeDynamicSupport.bootstrap("timeShiftResume", $$robo$$android_media_tv_TvView$timeShiftResume(), 0, this);
    }

    public void timeShiftSeekTo(long l) {
        InvokeDynamicSupport.bootstrap("timeShiftSeekTo", $$robo$$android_media_tv_TvView$timeShiftSeekTo(long ), 0, this, l);
    }

    public void timeShiftSetPlaybackParams(PlaybackParams playbackParams) {
        InvokeDynamicSupport.bootstrap("timeShiftSetPlaybackParams", $$robo$$android_media_tv_TvView$timeShiftSetPlaybackParams(android.media.PlaybackParams ), 0, this, playbackParams);
    }

    public void setTimeShiftPositionCallback(TimeShiftPositionCallback timeShiftPositionCallback) {
        InvokeDynamicSupport.bootstrap("setTimeShiftPositionCallback", $$robo$$android_media_tv_TvView$setTimeShiftPositionCallback(android.media.tv.TvView$TimeShiftPositionCallback ), 0, this, timeShiftPositionCallback);
    }

    private void ensurePositionTracking() {
        InvokeDynamicSupport.bootstrap("ensurePositionTracking", $$robo$$android_media_tv_TvView$ensurePositionTracking(), 0, this);
    }

    public void sendAppPrivateCommand(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("sendAppPrivateCommand", $$robo$$android_media_tv_TvView$sendAppPrivateCommand(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    public boolean dispatchUnhandledInputEvent(InputEvent inputEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchUnhandledInputEvent", $$robo$$android_media_tv_TvView$dispatchUnhandledInputEvent(android.view.InputEvent ), 0, this, inputEvent);
    }

    public boolean onUnhandledInputEvent(InputEvent inputEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onUnhandledInputEvent", $$robo$$android_media_tv_TvView$onUnhandledInputEvent(android.view.InputEvent ), 0, this, inputEvent);
    }

    public void setOnUnhandledInputEventListener(OnUnhandledInputEventListener onUnhandledInputEventListener) {
        InvokeDynamicSupport.bootstrap("setOnUnhandledInputEventListener", $$robo$$android_media_tv_TvView$setOnUnhandledInputEventListener(android.media.tv.TvView$OnUnhandledInputEventListener ), 0, this, onUnhandledInputEventListener);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyEvent", $$robo$$android_media_tv_TvView$dispatchKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchTouchEvent", $$robo$$android_media_tv_TvView$dispatchTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean dispatchTrackballEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchTrackballEvent", $$robo$$android_media_tv_TvView$dispatchTrackballEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean dispatchGenericMotionEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchGenericMotionEvent", $$robo$$android_media_tv_TvView$dispatchGenericMotionEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public void dispatchWindowFocusChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("dispatchWindowFocusChanged", $$robo$$android_media_tv_TvView$dispatchWindowFocusChanged(boolean ), 0, this, bl);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_media_tv_TvView$onAttachedToWindow(), 0, this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_media_tv_TvView$onDetachedFromWindow(), 0, this);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_media_tv_TvView$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_media_tv_TvView$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    public boolean gatherTransparentRegion(Region region) {
        return (boolean)InvokeDynamicSupport.bootstrap("gatherTransparentRegion", $$robo$$android_media_tv_TvView$gatherTransparentRegion(android.graphics.Region ), 0, this, region);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_media_tv_TvView$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("dispatchDraw", $$robo$$android_media_tv_TvView$dispatchDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    protected void onVisibilityChanged(View view, int n) {
        InvokeDynamicSupport.bootstrap("onVisibilityChanged", $$robo$$android_media_tv_TvView$onVisibilityChanged(android.view.View int ), 0, this, view, n);
    }

    private void resetSurfaceView() {
        InvokeDynamicSupport.bootstrap("resetSurfaceView", $$robo$$android_media_tv_TvView$resetSurfaceView(), 0, this);
    }

    private void setSessionSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("setSessionSurface", $$robo$$android_media_tv_TvView$setSessionSurface(android.view.Surface ), 0, this, surface);
    }

    private void dispatchSurfaceChanged(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("dispatchSurfaceChanged", $$robo$$android_media_tv_TvView$dispatchSurfaceChanged(int int int ), 0, this, n, n2, n3);
    }

    private void createSessionOverlayView() {
        InvokeDynamicSupport.bootstrap("createSessionOverlayView", $$robo$$android_media_tv_TvView$createSessionOverlayView(), 0, this);
    }

    private void removeSessionOverlayView() {
        InvokeDynamicSupport.bootstrap("removeSessionOverlayView", $$robo$$android_media_tv_TvView$removeSessionOverlayView(), 0, this);
    }

    private void relayoutSessionOverlayView() {
        InvokeDynamicSupport.bootstrap("relayoutSessionOverlayView", $$robo$$android_media_tv_TvView$relayoutSessionOverlayView(), 0, this);
    }

    private Rect getViewFrameOnScreen() {
        return InvokeDynamicSupport.bootstrap("getViewFrameOnScreen", $$robo$$android_media_tv_TvView$getViewFrameOnScreen(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(TvView.class);
    }

    public /* synthetic */ TvView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TvView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class MySessionCallback
    extends TvInputManager.SessionCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String mInputId;
        Uri mChannelUri;
        Bundle mTuneParams;
        Uri mRecordedProgramUri;
        /* synthetic */ TvView this$0;

        private void $$robo$$android_media_tv_TvView_MySessionCallback$__constructor__(TvView tvView, String inputId, Uri channelUri, Bundle tuneParams) {
            this.mInputId = inputId;
            this.mChannelUri = channelUri;
            this.mTuneParams = tuneParams;
        }

        private void $$robo$$android_media_tv_TvView_MySessionCallback$__constructor__(TvView tvView, String inputId, Uri recordedProgramUri) {
            this.mInputId = inputId;
            this.mRecordedProgramUri = recordedProgramUri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_tv_TvView_MySessionCallback$onSessionCreated(TvInputManager.Session session) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvView", "onSessionCreated - session already created");
                if (session != null) {
                    session.release();
                }
                return;
            }
            this.this$0.mSession = session;
            if (session != null) {
                for (Pair command : this.this$0.mPendingAppPrivateCommands) {
                    this.this$0.mSession.sendAppPrivateCommand((String)command.first, (Bundle)command.second);
                }
                this.this$0.mPendingAppPrivateCommands.clear();
                Object object = sMainTvViewLock;
                synchronized (object) {
                    if (this.this$0.hasWindowFocus() && this.this$0 == sMainTvView.get()) {
                        this.this$0.mSession.setMain();
                    }
                }
                if (this.this$0.mSurface != null) {
                    this.this$0.setSessionSurface(this.this$0.mSurface);
                    if (this.this$0.mSurfaceChanged) {
                        this.this$0.dispatchSurfaceChanged(this.this$0.mSurfaceFormat, this.this$0.mSurfaceWidth, this.this$0.mSurfaceHeight);
                    }
                }
                this.this$0.createSessionOverlayView();
                if (this.this$0.mStreamVolume != null) {
                    this.this$0.mSession.setStreamVolume(this.this$0.mStreamVolume.floatValue());
                }
                if (this.this$0.mCaptionEnabled != null) {
                    this.this$0.mSession.setCaptionEnabled(this.this$0.mCaptionEnabled);
                }
                if (this.mChannelUri != null) {
                    this.this$0.mSession.tune(this.mChannelUri, this.mTuneParams);
                } else {
                    this.this$0.mSession.timeShiftPlay(this.mRecordedProgramUri);
                }
                this.this$0.ensurePositionTracking();
            } else {
                this.this$0.mSessionCallback = null;
                if (this.this$0.mCallback != null) {
                    this.this$0.mCallback.onConnectionFailed(this.mInputId);
                }
            }
        }

        private final void $$robo$$android_media_tv_TvView_MySessionCallback$onSessionReleased(TvInputManager.Session session) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvView", "onSessionReleased - session not created");
                return;
            }
            this.this$0.mOverlayViewCreated = false;
            this.this$0.mOverlayViewFrame = null;
            this.this$0.mSessionCallback = null;
            this.this$0.mSession = null;
            if (this.this$0.mCallback != null) {
                this.this$0.mCallback.onDisconnected(this.mInputId);
            }
        }

        private final void $$robo$$android_media_tv_TvView_MySessionCallback$onChannelRetuned(TvInputManager.Session session, Uri channelUri) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvView", "onChannelRetuned - session not created");
                return;
            }
            if (this.this$0.mCallback != null) {
                this.this$0.mCallback.onChannelRetuned(this.mInputId, channelUri);
            }
        }

        private final void $$robo$$android_media_tv_TvView_MySessionCallback$onTracksChanged(TvInputManager.Session session, List<TvTrackInfo> tracks) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvView", "onTracksChanged - session not created");
                return;
            }
            if (this.this$0.mCallback != null) {
                this.this$0.mCallback.onTracksChanged(this.mInputId, tracks);
            }
        }

        private final void $$robo$$android_media_tv_TvView_MySessionCallback$onTrackSelected(TvInputManager.Session session, int type, String trackId) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvView", "onTrackSelected - session not created");
                return;
            }
            if (this.this$0.mCallback != null) {
                this.this$0.mCallback.onTrackSelected(this.mInputId, type, trackId);
            }
        }

        private final void $$robo$$android_media_tv_TvView_MySessionCallback$onVideoSizeChanged(TvInputManager.Session session, int width, int height) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvView", "onVideoSizeChanged - session not created");
                return;
            }
            if (this.this$0.mCallback != null) {
                this.this$0.mCallback.onVideoSizeChanged(this.mInputId, width, height);
            }
        }

        private final void $$robo$$android_media_tv_TvView_MySessionCallback$onVideoAvailable(TvInputManager.Session session) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvView", "onVideoAvailable - session not created");
                return;
            }
            if (this.this$0.mCallback != null) {
                this.this$0.mCallback.onVideoAvailable(this.mInputId);
            }
        }

        private final void $$robo$$android_media_tv_TvView_MySessionCallback$onVideoUnavailable(TvInputManager.Session session, int reason) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvView", "onVideoUnavailable - session not created");
                return;
            }
            if (this.this$0.mCallback != null) {
                this.this$0.mCallback.onVideoUnavailable(this.mInputId, reason);
            }
        }

        private final void $$robo$$android_media_tv_TvView_MySessionCallback$onContentAllowed(TvInputManager.Session session) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvView", "onContentAllowed - session not created");
                return;
            }
            if (this.this$0.mCallback != null) {
                this.this$0.mCallback.onContentAllowed(this.mInputId);
            }
        }

        private final void $$robo$$android_media_tv_TvView_MySessionCallback$onContentBlocked(TvInputManager.Session session, TvContentRating rating) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvView", "onContentBlocked - session not created");
                return;
            }
            if (this.this$0.mCallback != null) {
                this.this$0.mCallback.onContentBlocked(this.mInputId, rating);
            }
        }

        private final void $$robo$$android_media_tv_TvView_MySessionCallback$onLayoutSurface(TvInputManager.Session session, int left, int top, int right, int bottom) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvView", "onLayoutSurface - session not created");
                return;
            }
            this.this$0.mSurfaceViewLeft = left;
            this.this$0.mSurfaceViewTop = top;
            this.this$0.mSurfaceViewRight = right;
            this.this$0.mSurfaceViewBottom = bottom;
            this.this$0.mUseRequestedSurfaceLayout = true;
            this.this$0.requestLayout();
        }

        private final void $$robo$$android_media_tv_TvView_MySessionCallback$onSessionEvent(TvInputManager.Session session, String eventType, Bundle eventArgs) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvView", "onSessionEvent - session not created");
                return;
            }
            if (this.this$0.mCallback != null) {
                this.this$0.mCallback.onEvent(this.mInputId, eventType, eventArgs);
            }
        }

        private final void $$robo$$android_media_tv_TvView_MySessionCallback$onTimeShiftStatusChanged(TvInputManager.Session session, int status) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvView", "onTimeShiftStatusChanged - session not created");
                return;
            }
            if (this.this$0.mCallback != null) {
                this.this$0.mCallback.onTimeShiftStatusChanged(this.mInputId, status);
            }
        }

        private final void $$robo$$android_media_tv_TvView_MySessionCallback$onTimeShiftStartPositionChanged(TvInputManager.Session session, long timeMs) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvView", "onTimeShiftStartPositionChanged - session not created");
                return;
            }
            if (this.this$0.mTimeShiftPositionCallback != null) {
                this.this$0.mTimeShiftPositionCallback.onTimeShiftStartPositionChanged(this.mInputId, timeMs);
            }
        }

        private final void $$robo$$android_media_tv_TvView_MySessionCallback$onTimeShiftCurrentPositionChanged(TvInputManager.Session session, long timeMs) {
            if (this != this.this$0.mSessionCallback) {
                Log.w("TvView", "onTimeShiftCurrentPositionChanged - session not created");
                return;
            }
            if (this.this$0.mTimeShiftPositionCallback != null) {
                this.this$0.mTimeShiftPositionCallback.onTimeShiftCurrentPositionChanged(this.mInputId, timeMs);
            }
        }

        private void __constructor__(TvView tvView, String string2, Uri uri, Bundle bundle) {
            this.$$robo$$android_media_tv_TvView_MySessionCallback$__constructor__(tvView, string2, uri, bundle);
        }

        MySessionCallback(TvView tvView, String string2, Uri uri, Bundle bundle) {
            this.this$0 = tvView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvView_MySessionCallback$__constructor__(android.media.tv.TvView java.lang.String android.net.Uri android.os.Bundle ), 0, this, tvView, string2, uri, bundle);
        }

        private void __constructor__(TvView tvView, String string2, Uri uri) {
            this.$$robo$$android_media_tv_TvView_MySessionCallback$__constructor__(tvView, string2, uri);
        }

        MySessionCallback(TvView tvView, String string2, Uri uri) {
            this.this$0 = tvView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvView_MySessionCallback$__constructor__(android.media.tv.TvView java.lang.String android.net.Uri ), 0, this, tvView, string2, uri);
        }

        @Override
        public void onSessionCreated(TvInputManager.Session session) {
            InvokeDynamicSupport.bootstrap("onSessionCreated", $$robo$$android_media_tv_TvView_MySessionCallback$onSessionCreated(android.media.tv.TvInputManager$Session ), 0, this, session);
        }

        @Override
        public void onSessionReleased(TvInputManager.Session session) {
            InvokeDynamicSupport.bootstrap("onSessionReleased", $$robo$$android_media_tv_TvView_MySessionCallback$onSessionReleased(android.media.tv.TvInputManager$Session ), 0, this, session);
        }

        @Override
        public void onChannelRetuned(TvInputManager.Session session, Uri uri) {
            InvokeDynamicSupport.bootstrap("onChannelRetuned", $$robo$$android_media_tv_TvView_MySessionCallback$onChannelRetuned(android.media.tv.TvInputManager$Session android.net.Uri ), 0, this, session, uri);
        }

        @Override
        public void onTracksChanged(TvInputManager.Session session, List<TvTrackInfo> list) {
            InvokeDynamicSupport.bootstrap("onTracksChanged", $$robo$$android_media_tv_TvView_MySessionCallback$onTracksChanged(android.media.tv.TvInputManager$Session java.util.List<android.media.tv.TvTrackInfo> ), 0, this, session, list);
        }

        @Override
        public void onTrackSelected(TvInputManager.Session session, int n, String string2) {
            InvokeDynamicSupport.bootstrap("onTrackSelected", $$robo$$android_media_tv_TvView_MySessionCallback$onTrackSelected(android.media.tv.TvInputManager$Session int java.lang.String ), 0, this, session, n, string2);
        }

        @Override
        public void onVideoSizeChanged(TvInputManager.Session session, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onVideoSizeChanged", $$robo$$android_media_tv_TvView_MySessionCallback$onVideoSizeChanged(android.media.tv.TvInputManager$Session int int ), 0, this, session, n, n2);
        }

        @Override
        public void onVideoAvailable(TvInputManager.Session session) {
            InvokeDynamicSupport.bootstrap("onVideoAvailable", $$robo$$android_media_tv_TvView_MySessionCallback$onVideoAvailable(android.media.tv.TvInputManager$Session ), 0, this, session);
        }

        @Override
        public void onVideoUnavailable(TvInputManager.Session session, int n) {
            InvokeDynamicSupport.bootstrap("onVideoUnavailable", $$robo$$android_media_tv_TvView_MySessionCallback$onVideoUnavailable(android.media.tv.TvInputManager$Session int ), 0, this, session, n);
        }

        @Override
        public void onContentAllowed(TvInputManager.Session session) {
            InvokeDynamicSupport.bootstrap("onContentAllowed", $$robo$$android_media_tv_TvView_MySessionCallback$onContentAllowed(android.media.tv.TvInputManager$Session ), 0, this, session);
        }

        @Override
        public void onContentBlocked(TvInputManager.Session session, TvContentRating tvContentRating) {
            InvokeDynamicSupport.bootstrap("onContentBlocked", $$robo$$android_media_tv_TvView_MySessionCallback$onContentBlocked(android.media.tv.TvInputManager$Session android.media.tv.TvContentRating ), 0, this, session, tvContentRating);
        }

        @Override
        public void onLayoutSurface(TvInputManager.Session session, int n, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("onLayoutSurface", $$robo$$android_media_tv_TvView_MySessionCallback$onLayoutSurface(android.media.tv.TvInputManager$Session int int int int ), 0, this, session, n, n2, n3, n4);
        }

        @Override
        public void onSessionEvent(TvInputManager.Session session, String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onSessionEvent", $$robo$$android_media_tv_TvView_MySessionCallback$onSessionEvent(android.media.tv.TvInputManager$Session java.lang.String android.os.Bundle ), 0, this, session, string2, bundle);
        }

        @Override
        public void onTimeShiftStatusChanged(TvInputManager.Session session, int n) {
            InvokeDynamicSupport.bootstrap("onTimeShiftStatusChanged", $$robo$$android_media_tv_TvView_MySessionCallback$onTimeShiftStatusChanged(android.media.tv.TvInputManager$Session int ), 0, this, session, n);
        }

        @Override
        public void onTimeShiftStartPositionChanged(TvInputManager.Session session, long l) {
            InvokeDynamicSupport.bootstrap("onTimeShiftStartPositionChanged", $$robo$$android_media_tv_TvView_MySessionCallback$onTimeShiftStartPositionChanged(android.media.tv.TvInputManager$Session long ), 0, this, session, l);
        }

        @Override
        public void onTimeShiftCurrentPositionChanged(TvInputManager.Session session, long l) {
            InvokeDynamicSupport.bootstrap("onTimeShiftCurrentPositionChanged", $$robo$$android_media_tv_TvView_MySessionCallback$onTimeShiftCurrentPositionChanged(android.media.tv.TvInputManager$Session long ), 0, this, session, l);
        }

        public /* synthetic */ MySessionCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MySessionCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnUnhandledInputEventListener
    extends InstrumentedInterface {
        public boolean onUnhandledInputEvent(InputEvent var1);
    }

    public static abstract class TvInputCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_tv_TvView_TvInputCallback$__constructor__() {
        }

        private final void $$robo$$android_media_tv_TvView_TvInputCallback$onConnectionFailed(String inputId) {
        }

        private final void $$robo$$android_media_tv_TvView_TvInputCallback$onDisconnected(String inputId) {
        }

        private final void $$robo$$android_media_tv_TvView_TvInputCallback$onChannelRetuned(String inputId, Uri channelUri) {
        }

        private final void $$robo$$android_media_tv_TvView_TvInputCallback$onTracksChanged(String inputId, List<TvTrackInfo> tracks) {
        }

        private final void $$robo$$android_media_tv_TvView_TvInputCallback$onTrackSelected(String inputId, int type, String trackId) {
        }

        private final void $$robo$$android_media_tv_TvView_TvInputCallback$onVideoSizeChanged(String inputId, int width, int height) {
        }

        private final void $$robo$$android_media_tv_TvView_TvInputCallback$onVideoAvailable(String inputId) {
        }

        private final void $$robo$$android_media_tv_TvView_TvInputCallback$onVideoUnavailable(String inputId, int reason) {
        }

        private final void $$robo$$android_media_tv_TvView_TvInputCallback$onContentAllowed(String inputId) {
        }

        private final void $$robo$$android_media_tv_TvView_TvInputCallback$onContentBlocked(String inputId, TvContentRating rating) {
        }

        private final void $$robo$$android_media_tv_TvView_TvInputCallback$onEvent(String inputId, String eventType, Bundle eventArgs) {
        }

        private final void $$robo$$android_media_tv_TvView_TvInputCallback$onTimeShiftStatusChanged(String inputId, int status) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_tv_TvView_TvInputCallback$__constructor__();
        }

        public TvInputCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvView_TvInputCallback$__constructor__(), 0, this);
        }

        public void onConnectionFailed(String string2) {
            InvokeDynamicSupport.bootstrap("onConnectionFailed", $$robo$$android_media_tv_TvView_TvInputCallback$onConnectionFailed(java.lang.String ), 0, this, string2);
        }

        public void onDisconnected(String string2) {
            InvokeDynamicSupport.bootstrap("onDisconnected", $$robo$$android_media_tv_TvView_TvInputCallback$onDisconnected(java.lang.String ), 0, this, string2);
        }

        public void onChannelRetuned(String string2, Uri uri) {
            InvokeDynamicSupport.bootstrap("onChannelRetuned", $$robo$$android_media_tv_TvView_TvInputCallback$onChannelRetuned(java.lang.String android.net.Uri ), 0, this, string2, uri);
        }

        public void onTracksChanged(String string2, List<TvTrackInfo> list) {
            InvokeDynamicSupport.bootstrap("onTracksChanged", $$robo$$android_media_tv_TvView_TvInputCallback$onTracksChanged(java.lang.String java.util.List<android.media.tv.TvTrackInfo> ), 0, this, string2, list);
        }

        public void onTrackSelected(String string2, int n, String string3) {
            InvokeDynamicSupport.bootstrap("onTrackSelected", $$robo$$android_media_tv_TvView_TvInputCallback$onTrackSelected(java.lang.String int java.lang.String ), 0, this, string2, n, string3);
        }

        public void onVideoSizeChanged(String string2, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onVideoSizeChanged", $$robo$$android_media_tv_TvView_TvInputCallback$onVideoSizeChanged(java.lang.String int int ), 0, this, string2, n, n2);
        }

        public void onVideoAvailable(String string2) {
            InvokeDynamicSupport.bootstrap("onVideoAvailable", $$robo$$android_media_tv_TvView_TvInputCallback$onVideoAvailable(java.lang.String ), 0, this, string2);
        }

        public void onVideoUnavailable(String string2, int n) {
            InvokeDynamicSupport.bootstrap("onVideoUnavailable", $$robo$$android_media_tv_TvView_TvInputCallback$onVideoUnavailable(java.lang.String int ), 0, this, string2, n);
        }

        public void onContentAllowed(String string2) {
            InvokeDynamicSupport.bootstrap("onContentAllowed", $$robo$$android_media_tv_TvView_TvInputCallback$onContentAllowed(java.lang.String ), 0, this, string2);
        }

        public void onContentBlocked(String string2, TvContentRating tvContentRating) {
            InvokeDynamicSupport.bootstrap("onContentBlocked", $$robo$$android_media_tv_TvView_TvInputCallback$onContentBlocked(java.lang.String android.media.tv.TvContentRating ), 0, this, string2, tvContentRating);
        }

        public void onEvent(String string2, String string3, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onEvent", $$robo$$android_media_tv_TvView_TvInputCallback$onEvent(java.lang.String java.lang.String android.os.Bundle ), 0, this, string2, string3, bundle);
        }

        public void onTimeShiftStatusChanged(String string2, int n) {
            InvokeDynamicSupport.bootstrap("onTimeShiftStatusChanged", $$robo$$android_media_tv_TvView_TvInputCallback$onTimeShiftStatusChanged(java.lang.String int ), 0, this, string2, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TvInputCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class TimeShiftPositionCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_tv_TvView_TimeShiftPositionCallback$__constructor__() {
        }

        private final void $$robo$$android_media_tv_TvView_TimeShiftPositionCallback$onTimeShiftStartPositionChanged(String inputId, long timeMs) {
        }

        private final void $$robo$$android_media_tv_TvView_TimeShiftPositionCallback$onTimeShiftCurrentPositionChanged(String inputId, long timeMs) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_tv_TvView_TimeShiftPositionCallback$__constructor__();
        }

        public TimeShiftPositionCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvView_TimeShiftPositionCallback$__constructor__(), 0, this);
        }

        public void onTimeShiftStartPositionChanged(String string2, long l) {
            InvokeDynamicSupport.bootstrap("onTimeShiftStartPositionChanged", $$robo$$android_media_tv_TvView_TimeShiftPositionCallback$onTimeShiftStartPositionChanged(java.lang.String long ), 0, this, string2, l);
        }

        public void onTimeShiftCurrentPositionChanged(String string2, long l) {
            InvokeDynamicSupport.bootstrap("onTimeShiftCurrentPositionChanged", $$robo$$android_media_tv_TvView_TimeShiftPositionCallback$onTimeShiftCurrentPositionChanged(java.lang.String long ), 0, this, string2, l);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeShiftPositionCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

