/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.Credentials;
import android.net.LocalSocketAddress;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructLinger;
import android.system.StructTimeval;
import android.util.MutableInt;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LocalSocketImpl
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private SocketInputStream fis;
    private SocketOutputStream fos;
    private Object readMonitor;
    private Object writeMonitor;
    private FileDescriptor fd;
    private boolean mFdCreatedInternally;
    FileDescriptor[] inboundFileDescriptors;
    FileDescriptor[] outboundFileDescriptors;

    private final int $$robo$$android_net_LocalSocketImpl$read_native(FileDescriptor fileDescriptor) throws IOException {
        return 0;
    }

    private final int $$robo$$android_net_LocalSocketImpl$readba_native(byte[] byArray, int n, int n2, FileDescriptor fileDescriptor) throws IOException {
        return 0;
    }

    private final void $$robo$$android_net_LocalSocketImpl$writeba_native(byte[] byArray, int n, int n2, FileDescriptor fileDescriptor) throws IOException {
    }

    private final void $$robo$$android_net_LocalSocketImpl$write_native(int n, FileDescriptor fileDescriptor) throws IOException {
    }

    private final void $$robo$$android_net_LocalSocketImpl$connectLocal(FileDescriptor fileDescriptor, String string2, int n) throws IOException {
    }

    private final void $$robo$$android_net_LocalSocketImpl$bindLocal(FileDescriptor fileDescriptor, String string2, int n) throws IOException {
    }

    private final Credentials $$robo$$android_net_LocalSocketImpl$getPeerCredentials_native(FileDescriptor fileDescriptor) throws IOException {
        return null;
    }

    private void $$robo$$android_net_LocalSocketImpl$__constructor__() {
        this.readMonitor = new Object();
        this.writeMonitor = new Object();
    }

    private void $$robo$$android_net_LocalSocketImpl$__constructor__(FileDescriptor fd) throws IOException {
        this.readMonitor = new Object();
        this.writeMonitor = new Object();
        this.fd = fd;
    }

    private final String $$robo$$android_net_LocalSocketImpl$toString() {
        return super.toString() + " fd:" + this.fd;
    }

    private final void $$robo$$android_net_LocalSocketImpl$create(int sockType) throws IOException {
        if (this.fd == null) {
            int osType;
            switch (sockType) {
                case 1: {
                    osType = OsConstants.SOCK_DGRAM;
                    break;
                }
                case 2: {
                    osType = OsConstants.SOCK_STREAM;
                    break;
                }
                case 3: {
                    osType = OsConstants.SOCK_SEQPACKET;
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown sockType");
                }
            }
            try {
                this.fd = Os.socket(OsConstants.AF_UNIX, osType, 0);
                this.mFdCreatedInternally = true;
            }
            catch (ErrnoException e) {
                e.rethrowAsIOException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_LocalSocketImpl$close() throws IOException {
        LocalSocketImpl localSocketImpl = this;
        synchronized (localSocketImpl) {
            if (this.fd == null || !this.mFdCreatedInternally) {
                this.fd = null;
                return;
            }
            try {
                Os.close(this.fd);
            }
            catch (ErrnoException e) {
                e.rethrowAsIOException();
            }
            this.fd = null;
        }
    }

    private final void $$robo$$android_net_LocalSocketImpl$connect(LocalSocketAddress address, int timeout) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        this.connectLocal(this.fd, address.getName(), address.getNamespace().getId());
    }

    private final void $$robo$$android_net_LocalSocketImpl$bind(LocalSocketAddress endpoint) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        this.bindLocal(this.fd, endpoint.getName(), endpoint.getNamespace().getId());
    }

    private final void $$robo$$android_net_LocalSocketImpl$listen(int backlog) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        try {
            Os.listen(this.fd, backlog);
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    private final void $$robo$$android_net_LocalSocketImpl$accept(LocalSocketImpl s) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        try {
            s.fd = Os.accept(this.fd, null);
            s.mFdCreatedInternally = true;
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InputStream $$robo$$android_net_LocalSocketImpl$getInputStream() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        LocalSocketImpl localSocketImpl = this;
        synchronized (localSocketImpl) {
            if (this.fis == null) {
                this.fis = new SocketInputStream(this);
            }
            return this.fis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final OutputStream $$robo$$android_net_LocalSocketImpl$getOutputStream() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        LocalSocketImpl localSocketImpl = this;
        synchronized (localSocketImpl) {
            if (this.fos == null) {
                this.fos = new SocketOutputStream(this);
            }
            return this.fos;
        }
    }

    private final int $$robo$$android_net_LocalSocketImpl$available() throws IOException {
        return this.getInputStream().available();
    }

    private final void $$robo$$android_net_LocalSocketImpl$shutdownInput() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        try {
            Os.shutdown(this.fd, OsConstants.SHUT_RD);
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    private final void $$robo$$android_net_LocalSocketImpl$shutdownOutput() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        try {
            Os.shutdown(this.fd, OsConstants.SHUT_WR);
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    private final FileDescriptor $$robo$$android_net_LocalSocketImpl$getFileDescriptor() {
        return this.fd;
    }

    private final boolean $$robo$$android_net_LocalSocketImpl$supportsUrgentData() {
        return false;
    }

    private final void $$robo$$android_net_LocalSocketImpl$sendUrgentData(int data) throws IOException {
        throw new RuntimeException("not impled");
    }

    private final Object $$robo$$android_net_LocalSocketImpl$getOption(int optID) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        try {
            Integer toReturn;
            switch (optID) {
                case 4102: {
                    StructTimeval timeval = Os.getsockoptTimeval(this.fd, OsConstants.SOL_SOCKET, OsConstants.SO_SNDTIMEO);
                    toReturn = (int)timeval.toMillis();
                    break;
                }
                case 4: 
                case 4097: 
                case 4098: {
                    int osOpt = LocalSocketImpl.javaSoToOsOpt(optID);
                    toReturn = Os.getsockoptInt(this.fd, OsConstants.SOL_SOCKET, osOpt);
                    break;
                }
                case 128: {
                    StructLinger linger = Os.getsockoptLinger(this.fd, OsConstants.SOL_SOCKET, OsConstants.SO_LINGER);
                    if (!linger.isOn()) {
                        toReturn = -1;
                        break;
                    }
                    toReturn = linger.l_linger;
                    break;
                }
                case 1: {
                    toReturn = Os.getsockoptInt(this.fd, OsConstants.IPPROTO_TCP, OsConstants.TCP_NODELAY);
                    break;
                }
                default: {
                    throw new IOException("Unknown option: " + optID);
                }
            }
            return toReturn;
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    private final void $$robo$$android_net_LocalSocketImpl$setOption(int optID, Object value) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        int boolValue = -1;
        int intValue = 0;
        if (value instanceof Integer) {
            intValue = (Integer)value;
        } else if (value instanceof Boolean) {
            boolValue = (Boolean)value != false ? 1 : 0;
        } else {
            throw new IOException("bad value: " + value);
        }
        try {
            switch (optID) {
                case 128: {
                    StructLinger linger = new StructLinger(boolValue, intValue);
                    Os.setsockoptLinger(this.fd, OsConstants.SOL_SOCKET, OsConstants.SO_LINGER, linger);
                    break;
                }
                case 4102: {
                    StructTimeval timeval = StructTimeval.fromMillis(intValue);
                    Os.setsockoptTimeval(this.fd, OsConstants.SOL_SOCKET, OsConstants.SO_SNDTIMEO, timeval);
                    break;
                }
                case 4: 
                case 4097: 
                case 4098: {
                    int osOpt = LocalSocketImpl.javaSoToOsOpt(optID);
                    Os.setsockoptInt(this.fd, OsConstants.SOL_SOCKET, osOpt, intValue);
                    break;
                }
                case 1: {
                    Os.setsockoptInt(this.fd, OsConstants.IPPROTO_TCP, OsConstants.TCP_NODELAY, intValue);
                    break;
                }
                default: {
                    throw new IOException("Unknown option: " + optID);
                }
            }
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_LocalSocketImpl$setFileDescriptorsForSend(FileDescriptor[] fds) {
        Object object = this.writeMonitor;
        synchronized (object) {
            this.outboundFileDescriptors = fds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final FileDescriptor[] $$robo$$android_net_LocalSocketImpl$getAncillaryFileDescriptors() throws IOException {
        Object object = this.readMonitor;
        synchronized (object) {
            FileDescriptor[] result = this.inboundFileDescriptors;
            this.inboundFileDescriptors = null;
            return result;
        }
    }

    private final Credentials $$robo$$android_net_LocalSocketImpl$getPeerCredentials() throws IOException {
        return this.getPeerCredentials_native(this.fd);
    }

    private final LocalSocketAddress $$robo$$android_net_LocalSocketImpl$getSockAddress() throws IOException {
        return null;
    }

    private final void $$robo$$android_net_LocalSocketImpl$finalize() throws IOException {
        this.close();
    }

    private static final int $$robo$$android_net_LocalSocketImpl$javaSoToOsOpt(int optID) {
        switch (optID) {
            case 4097: {
                return OsConstants.SO_SNDBUF;
            }
            case 4098: {
                return OsConstants.SO_RCVBUF;
            }
            case 4: {
                return OsConstants.SO_REUSEADDR;
            }
        }
        throw new UnsupportedOperationException("Unknown option: " + optID);
    }

    private final native /* synthetic */ int $$robo$$read_native$nativeBinding(FileDescriptor var1) throws IOException;

    private int read_native(FileDescriptor fileDescriptor) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("read_native", $$robo$$android_net_LocalSocketImpl$read_native(java.io.FileDescriptor ), 1, this, fileDescriptor);
    }

    private final native /* synthetic */ int $$robo$$readba_native$nativeBinding(byte[] var1, int var2, int var3, FileDescriptor var4) throws IOException;

    private int readba_native(byte[] byArray, int n, int n2, FileDescriptor fileDescriptor) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("readba_native", $$robo$$android_net_LocalSocketImpl$readba_native(byte[] int int java.io.FileDescriptor ), 1, this, byArray, n, n2, fileDescriptor);
    }

    private final native /* synthetic */ void $$robo$$writeba_native$nativeBinding(byte[] var1, int var2, int var3, FileDescriptor var4) throws IOException;

    private void writeba_native(byte[] byArray, int n, int n2, FileDescriptor fileDescriptor) throws IOException {
        InvokeDynamicSupport.bootstrap("writeba_native", $$robo$$android_net_LocalSocketImpl$writeba_native(byte[] int int java.io.FileDescriptor ), 1, this, byArray, n, n2, fileDescriptor);
    }

    private final native /* synthetic */ void $$robo$$write_native$nativeBinding(int var1, FileDescriptor var2) throws IOException;

    private void write_native(int n, FileDescriptor fileDescriptor) throws IOException {
        InvokeDynamicSupport.bootstrap("write_native", $$robo$$android_net_LocalSocketImpl$write_native(int java.io.FileDescriptor ), 1, this, n, fileDescriptor);
    }

    private final native /* synthetic */ void $$robo$$connectLocal$nativeBinding(FileDescriptor var1, String var2, int var3) throws IOException;

    private void connectLocal(FileDescriptor fileDescriptor, String string2, int n) throws IOException {
        InvokeDynamicSupport.bootstrap("connectLocal", $$robo$$android_net_LocalSocketImpl$connectLocal(java.io.FileDescriptor java.lang.String int ), 1, this, fileDescriptor, string2, n);
    }

    private final native /* synthetic */ void $$robo$$bindLocal$nativeBinding(FileDescriptor var1, String var2, int var3) throws IOException;

    private void bindLocal(FileDescriptor fileDescriptor, String string2, int n) throws IOException {
        InvokeDynamicSupport.bootstrap("bindLocal", $$robo$$android_net_LocalSocketImpl$bindLocal(java.io.FileDescriptor java.lang.String int ), 1, this, fileDescriptor, string2, n);
    }

    private final native /* synthetic */ Credentials $$robo$$getPeerCredentials_native$nativeBinding(FileDescriptor var1) throws IOException;

    private Credentials getPeerCredentials_native(FileDescriptor fileDescriptor) throws IOException {
        return InvokeDynamicSupport.bootstrap("getPeerCredentials_native", $$robo$$android_net_LocalSocketImpl$getPeerCredentials_native(java.io.FileDescriptor ), 1, this, fileDescriptor);
    }

    private void __constructor__() {
        this.$$robo$$android_net_LocalSocketImpl$__constructor__();
    }

    LocalSocketImpl() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_LocalSocketImpl$__constructor__(), 0, this);
    }

    private void __constructor__(FileDescriptor fileDescriptor) throws IOException {
        this.$$robo$$android_net_LocalSocketImpl$__constructor__(fileDescriptor);
    }

    LocalSocketImpl(FileDescriptor fileDescriptor) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_LocalSocketImpl$__constructor__(java.io.FileDescriptor ), 0, this, fileDescriptor);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_LocalSocketImpl$toString(), 0, this);
    }

    public void create(int n) throws IOException {
        InvokeDynamicSupport.bootstrap("create", $$robo$$android_net_LocalSocketImpl$create(int ), 0, this, n);
    }

    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_net_LocalSocketImpl$close(), 0, this);
    }

    protected void connect(LocalSocketAddress localSocketAddress, int n) throws IOException {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$android_net_LocalSocketImpl$connect(android.net.LocalSocketAddress int ), 0, this, localSocketAddress, n);
    }

    public void bind(LocalSocketAddress localSocketAddress) throws IOException {
        InvokeDynamicSupport.bootstrap("bind", $$robo$$android_net_LocalSocketImpl$bind(android.net.LocalSocketAddress ), 0, this, localSocketAddress);
    }

    protected void listen(int n) throws IOException {
        InvokeDynamicSupport.bootstrap("listen", $$robo$$android_net_LocalSocketImpl$listen(int ), 0, this, n);
    }

    protected void accept(LocalSocketImpl localSocketImpl) throws IOException {
        InvokeDynamicSupport.bootstrap("accept", $$robo$$android_net_LocalSocketImpl$accept(android.net.LocalSocketImpl ), 0, this, localSocketImpl);
    }

    protected InputStream getInputStream() throws IOException {
        return InvokeDynamicSupport.bootstrap("getInputStream", $$robo$$android_net_LocalSocketImpl$getInputStream(), 0, this);
    }

    protected OutputStream getOutputStream() throws IOException {
        return InvokeDynamicSupport.bootstrap("getOutputStream", $$robo$$android_net_LocalSocketImpl$getOutputStream(), 0, this);
    }

    protected int available() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("available", $$robo$$android_net_LocalSocketImpl$available(), 0, this);
    }

    protected void shutdownInput() throws IOException {
        InvokeDynamicSupport.bootstrap("shutdownInput", $$robo$$android_net_LocalSocketImpl$shutdownInput(), 0, this);
    }

    protected void shutdownOutput() throws IOException {
        InvokeDynamicSupport.bootstrap("shutdownOutput", $$robo$$android_net_LocalSocketImpl$shutdownOutput(), 0, this);
    }

    protected FileDescriptor getFileDescriptor() {
        return InvokeDynamicSupport.bootstrap("getFileDescriptor", $$robo$$android_net_LocalSocketImpl$getFileDescriptor(), 0, this);
    }

    protected boolean supportsUrgentData() {
        return (boolean)InvokeDynamicSupport.bootstrap("supportsUrgentData", $$robo$$android_net_LocalSocketImpl$supportsUrgentData(), 0, this);
    }

    protected void sendUrgentData(int n) throws IOException {
        InvokeDynamicSupport.bootstrap("sendUrgentData", $$robo$$android_net_LocalSocketImpl$sendUrgentData(int ), 0, this, n);
    }

    public Object getOption(int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("getOption", $$robo$$android_net_LocalSocketImpl$getOption(int ), 0, this, n);
    }

    public void setOption(int n, Object object) throws IOException {
        InvokeDynamicSupport.bootstrap("setOption", $$robo$$android_net_LocalSocketImpl$setOption(int java.lang.Object ), 0, this, n, object);
    }

    public void setFileDescriptorsForSend(FileDescriptor[] fileDescriptorArray) {
        InvokeDynamicSupport.bootstrap("setFileDescriptorsForSend", $$robo$$android_net_LocalSocketImpl$setFileDescriptorsForSend(java.io.FileDescriptor[] ), 0, this, fileDescriptorArray);
    }

    public FileDescriptor[] getAncillaryFileDescriptors() throws IOException {
        return InvokeDynamicSupport.bootstrap("getAncillaryFileDescriptors", $$robo$$android_net_LocalSocketImpl$getAncillaryFileDescriptors(), 0, this);
    }

    public Credentials getPeerCredentials() throws IOException {
        return InvokeDynamicSupport.bootstrap("getPeerCredentials", $$robo$$android_net_LocalSocketImpl$getPeerCredentials(), 0, this);
    }

    public LocalSocketAddress getSockAddress() throws IOException {
        return InvokeDynamicSupport.bootstrap("getSockAddress", $$robo$$android_net_LocalSocketImpl$getSockAddress(), 0, this);
    }

    protected void finalize() throws IOException {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_net_LocalSocketImpl$finalize(), 0, this);
    }

    private static int javaSoToOsOpt(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("javaSoToOsOpt", $$robo$$android_net_LocalSocketImpl$javaSoToOsOpt(int ), 0, (int)n);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocalSocketImpl)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class SocketOutputStream
    extends OutputStream
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ LocalSocketImpl this$0;

        private void $$robo$$android_net_LocalSocketImpl_SocketOutputStream$__constructor__(LocalSocketImpl this$0) {
        }

        private final void $$robo$$android_net_LocalSocketImpl_SocketOutputStream$close() throws IOException {
            this.this$0.close();
        }

        private final void $$robo$$android_net_LocalSocketImpl_SocketOutputStream$write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_net_LocalSocketImpl_SocketOutputStream$write(byte[] b, int off, int len) throws IOException {
            Object object = this.this$0.writeMonitor;
            synchronized (object) {
                FileDescriptor myFd = this.this$0.fd;
                if (myFd == null) {
                    throw new IOException("socket closed");
                }
                if (off < 0 || len < 0 || off + len > b.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                this.this$0.writeba_native(b, off, len, myFd);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_net_LocalSocketImpl_SocketOutputStream$write(int b) throws IOException {
            Object object = this.this$0.writeMonitor;
            synchronized (object) {
                FileDescriptor myFd = this.this$0.fd;
                if (myFd == null) {
                    throw new IOException("socket closed");
                }
                this.this$0.write_native(b, myFd);
            }
        }

        private final void $$robo$$android_net_LocalSocketImpl_SocketOutputStream$flush() throws IOException {
            FileDescriptor myFd = this.this$0.fd;
            if (myFd == null) {
                throw new IOException("socket closed");
            }
            MutableInt pending = new MutableInt(0);
            while (true) {
                try {
                    Os.ioctlInt(myFd, OsConstants.TIOCOUTQ, pending);
                }
                catch (ErrnoException e) {
                    throw e.rethrowAsIOException();
                }
                if (pending.value <= 0) break;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ie) {
                    break;
                }
            }
        }

        private void __constructor__(LocalSocketImpl localSocketImpl) {
            this.$$robo$$android_net_LocalSocketImpl_SocketOutputStream$__constructor__(localSocketImpl);
        }

        SocketOutputStream(LocalSocketImpl localSocketImpl) {
            this.this$0 = localSocketImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_LocalSocketImpl_SocketOutputStream$__constructor__(android.net.LocalSocketImpl ), 0, this, localSocketImpl);
        }

        @Override
        public void close() throws IOException {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_net_LocalSocketImpl_SocketOutputStream$close(), 0, this);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_net_LocalSocketImpl_SocketOutputStream$write(byte[] ), 0, this, byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_net_LocalSocketImpl_SocketOutputStream$write(byte[] int int ), 0, this, byArray, n, n2);
        }

        @Override
        public void write(int n) throws IOException {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_net_LocalSocketImpl_SocketOutputStream$write(int ), 0, this, n);
        }

        @Override
        public void flush() throws IOException {
            InvokeDynamicSupport.bootstrap("flush", $$robo$$android_net_LocalSocketImpl_SocketOutputStream$flush(), 0, this);
        }

        public /* synthetic */ SocketOutputStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SocketOutputStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class SocketInputStream
    extends InputStream
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ LocalSocketImpl this$0;

        private void $$robo$$android_net_LocalSocketImpl_SocketInputStream$__constructor__(LocalSocketImpl this$0) {
        }

        private final int $$robo$$android_net_LocalSocketImpl_SocketInputStream$available() throws IOException {
            FileDescriptor myFd = this.this$0.fd;
            if (myFd == null) {
                throw new IOException("socket closed");
            }
            MutableInt avail = new MutableInt(0);
            try {
                Os.ioctlInt(myFd, OsConstants.FIONREAD, avail);
            }
            catch (ErrnoException e) {
                throw e.rethrowAsIOException();
            }
            return avail.value;
        }

        private final void $$robo$$android_net_LocalSocketImpl_SocketInputStream$close() throws IOException {
            this.this$0.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_net_LocalSocketImpl_SocketInputStream$read() throws IOException {
            Object object = this.this$0.readMonitor;
            synchronized (object) {
                FileDescriptor myFd = this.this$0.fd;
                if (myFd == null) {
                    throw new IOException("socket closed");
                }
                int ret = this.this$0.read_native(myFd);
                return ret;
            }
        }

        private final int $$robo$$android_net_LocalSocketImpl_SocketInputStream$read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_net_LocalSocketImpl_SocketInputStream$read(byte[] b, int off, int len) throws IOException {
            Object object = this.this$0.readMonitor;
            synchronized (object) {
                FileDescriptor myFd = this.this$0.fd;
                if (myFd == null) {
                    throw new IOException("socket closed");
                }
                if (off < 0 || len < 0 || off + len > b.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                int ret = this.this$0.readba_native(b, off, len, myFd);
                return ret;
            }
        }

        private void __constructor__(LocalSocketImpl localSocketImpl) {
            this.$$robo$$android_net_LocalSocketImpl_SocketInputStream$__constructor__(localSocketImpl);
        }

        SocketInputStream(LocalSocketImpl localSocketImpl) {
            this.this$0 = localSocketImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_LocalSocketImpl_SocketInputStream$__constructor__(android.net.LocalSocketImpl ), 0, this, localSocketImpl);
        }

        @Override
        public int available() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("available", $$robo$$android_net_LocalSocketImpl_SocketInputStream$available(), 0, this);
        }

        @Override
        public void close() throws IOException {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_net_LocalSocketImpl_SocketInputStream$close(), 0, this);
        }

        @Override
        public int read() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_net_LocalSocketImpl_SocketInputStream$read(), 0, this);
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_net_LocalSocketImpl_SocketInputStream$read(byte[] ), 0, this, byArray);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_net_LocalSocketImpl_SocketInputStream$read(byte[] int int ), 0, this, byArray, n, n2);
        }

        public /* synthetic */ SocketInputStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SocketInputStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

