/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiEnterpriseConfig
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String EMPTY_VALUE = "NULL";
    public static String EAP_KEY = "eap";
    public static String PHASE2_KEY = "phase2";
    public static String IDENTITY_KEY = "identity";
    public static String ANON_IDENTITY_KEY = "anonymous_identity";
    public static String PASSWORD_KEY = "password";
    public static String SUBJECT_MATCH_KEY = "subject_match";
    public static String ALTSUBJECT_MATCH_KEY = "altsubject_match";
    public static String DOM_SUFFIX_MATCH_KEY = "domain_suffix_match";
    public static String OPP_KEY_CACHING = "proactive_key_caching";
    public static String ENGINE_ID_KEYSTORE = "keystore";
    public static String KEYSTORE_URI = "keystore://";
    public static String KEYSTORES_URI = "keystores://";
    public static String ENGINE_ENABLE = "1";
    public static String ENGINE_DISABLE = "0";
    public static String CA_CERT_PREFIX = "keystore://CACERT_";
    public static String CLIENT_CERT_PREFIX = "keystore://USRCERT_";
    public static String CLIENT_CERT_KEY = "client_cert";
    public static String CA_CERT_KEY = "ca_cert";
    public static String CA_PATH_KEY = "ca_path";
    public static String ENGINE_KEY = "engine";
    public static String ENGINE_ID_KEY = "engine_id";
    public static String PRIVATE_KEY_ID_KEY = "key_id";
    public static String REALM_KEY = "realm";
    public static String PLMN_KEY = "plmn";
    public static String CA_CERT_ALIAS_DELIMITER = " ";
    private static String[] SUPPLICANT_CONFIG_KEYS;
    private HashMap<String, String> mFields;
    private X509Certificate[] mCaCerts;
    private PrivateKey mClientPrivateKey;
    private X509Certificate mClientCertificate;
    private int mEapMethod;
    private int mPhase2Method;
    private static String TAG = "WifiEnterpriseConfig";
    public static Parcelable.Creator<WifiEnterpriseConfig> CREATOR;

    private void $$robo$$android_net_wifi_WifiEnterpriseConfig$__constructor__() {
        this.mFields = new HashMap();
        this.mEapMethod = -1;
        this.mPhase2Method = 0;
    }

    private void $$robo$$android_net_wifi_WifiEnterpriseConfig$__constructor__(WifiEnterpriseConfig source) {
        this.mFields = new HashMap();
        this.mEapMethod = -1;
        this.mPhase2Method = 0;
        for (String key : source.mFields.keySet()) {
            this.mFields.put(key, source.mFields.get(key));
        }
        this.mEapMethod = source.mEapMethod;
        this.mPhase2Method = source.mPhase2Method;
    }

    private final int $$robo$$android_net_wifi_WifiEnterpriseConfig$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mFields.size());
        for (Map.Entry<String, String> entry : this.mFields.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeString(entry.getValue());
        }
        dest.writeInt(this.mEapMethod);
        dest.writeInt(this.mPhase2Method);
        this.writeCertificates(dest, this.mCaCerts);
        if (this.mClientPrivateKey != null) {
            String algorithm = this.mClientPrivateKey.getAlgorithm();
            byte[] userKeyBytes = this.mClientPrivateKey.getEncoded();
            dest.writeInt(userKeyBytes.length);
            dest.writeByteArray(userKeyBytes);
            dest.writeString(algorithm);
        } else {
            dest.writeInt(0);
        }
        this.writeCertificate(dest, this.mClientCertificate);
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$writeCertificates(Parcel dest, X509Certificate[] cert) {
        if (cert != null && cert.length != 0) {
            dest.writeInt(cert.length);
            for (int i = 0; i < cert.length; ++i) {
                this.writeCertificate(dest, cert[i]);
            }
        } else {
            dest.writeInt(0);
        }
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$writeCertificate(Parcel dest, X509Certificate cert) {
        if (cert != null) {
            try {
                byte[] certBytes = cert.getEncoded();
                dest.writeInt(certBytes.length);
                dest.writeByteArray(certBytes);
            }
            catch (CertificateEncodingException e) {
                dest.writeInt(0);
            }
        } else {
            dest.writeInt(0);
        }
    }

    private final boolean $$robo$$android_net_wifi_WifiEnterpriseConfig$saveToSupplicant(SupplicantSaver saver) {
        if (!this.isEapMethodValid()) {
            return false;
        }
        for (String key : this.mFields.keySet()) {
            if (saver.saveValue(key, this.mFields.get(key))) continue;
            return false;
        }
        if (!saver.saveValue("eap", Eap.strings[this.mEapMethod])) {
            return false;
        }
        if (this.mEapMethod != 1 && this.mPhase2Method != 0) {
            boolean is_autheap = this.mEapMethod == 2 && this.mPhase2Method == 4;
            String prefix = is_autheap ? "autheap=" : "auth=";
            String value = this.convertToQuotedString(prefix + Phase2.strings[this.mPhase2Method]);
            return saver.saveValue("phase2", value);
        }
        if (this.mPhase2Method == 0) {
            return saver.saveValue("phase2", null);
        }
        Log.e("WifiEnterpriseConfig", "WiFi enterprise configuration is invalid as it supplies a phase 2 method but the phase1 method does not support it.");
        return false;
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$loadFromSupplicant(SupplicantLoader loader) {
        for (String key : SUPPLICANT_CONFIG_KEYS) {
            String value = loader.loadValue(key);
            if (value == null) {
                this.mFields.put(key, "NULL");
                continue;
            }
            this.mFields.put(key, value);
        }
        String eapMethod = loader.loadValue("eap");
        this.mEapMethod = this.getStringIndex(Eap.strings, eapMethod, -1);
        String phase2Method = this.removeDoubleQuotes(loader.loadValue("phase2"));
        if (phase2Method.startsWith("auth=")) {
            phase2Method = phase2Method.substring("auth=".length());
        } else if (phase2Method.startsWith("autheap=")) {
            phase2Method = phase2Method.substring("autheap=".length());
        }
        this.mPhase2Method = this.getStringIndex(Phase2.strings, phase2Method, 0);
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setEapMethod(int eapMethod) {
        switch (eapMethod) {
            case 1: 
            case 7: {
                this.setPhase2Method(0);
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.mEapMethod = eapMethod;
                this.mFields.put("proactive_key_caching", "1");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown EAP method");
            }
        }
    }

    private final int $$robo$$android_net_wifi_WifiEnterpriseConfig$getEapMethod() {
        return this.mEapMethod;
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setPhase2Method(int phase2Method) {
        switch (phase2Method) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.mPhase2Method = phase2Method;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Phase 2 method");
            }
        }
    }

    private final int $$robo$$android_net_wifi_WifiEnterpriseConfig$getPhase2Method() {
        return this.mPhase2Method;
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setIdentity(String identity) {
        this.setFieldValue("identity", identity, "");
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getIdentity() {
        return this.getFieldValue("identity", "");
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setAnonymousIdentity(String anonymousIdentity) {
        this.setFieldValue("anonymous_identity", anonymousIdentity, "");
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getAnonymousIdentity() {
        return this.getFieldValue("anonymous_identity", "");
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setPassword(String password) {
        this.setFieldValue("password", password, "");
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getPassword() {
        return this.getFieldValue("password", "");
    }

    private static final String $$robo$$android_net_wifi_WifiEnterpriseConfig$encodeCaCertificateAlias(String alias) {
        byte[] bytes = alias.getBytes(StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte o : bytes) {
            sb.append(String.format("%02x", o & 0xFF));
        }
        return sb.toString();
    }

    private static final String $$robo$$android_net_wifi_WifiEnterpriseConfig$decodeCaCertificateAlias(String alias) {
        byte[] data = new byte[alias.length() >> 1];
        int n = 0;
        int position = 0;
        while (n < alias.length()) {
            data[position] = (byte)Integer.parseInt(alias.substring(n, n + 2), 16);
            n += 2;
            ++position;
        }
        try {
            return new String(data, StandardCharsets.UTF_8);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return alias;
        }
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setCaCertificateAlias(String alias) {
        this.setFieldValue("ca_cert", alias, "keystore://CACERT_");
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setCaCertificateAliases(String[] aliases) {
        if (aliases == null) {
            this.setFieldValue("ca_cert", null, "keystore://CACERT_");
        } else if (aliases.length == 1) {
            this.setCaCertificateAlias(aliases[0]);
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < aliases.length; ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(WifiEnterpriseConfig.encodeCaCertificateAlias("CACERT_" + aliases[i]));
            }
            this.setFieldValue("ca_cert", sb.toString(), "keystores://");
        }
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getCaCertificateAlias() {
        return this.getFieldValue("ca_cert", "keystore://CACERT_");
    }

    private final String[] $$robo$$android_net_wifi_WifiEnterpriseConfig$getCaCertificateAliases() {
        String[] stringArray;
        String value = this.getFieldValue("ca_cert", "");
        if (value.startsWith("keystore://CACERT_")) {
            return new String[]{this.getFieldValue("ca_cert", "keystore://CACERT_")};
        }
        if (value.startsWith("keystores://")) {
            String values = value.substring("keystores://".length());
            String[] aliases = TextUtils.split(values, " ");
            for (int i = 0; i < aliases.length; ++i) {
                aliases[i] = WifiEnterpriseConfig.decodeCaCertificateAlias(aliases[i]);
                if (!aliases[i].startsWith("CACERT_")) continue;
                aliases[i] = aliases[i].substring("CACERT_".length());
            }
            return aliases.length != 0 ? aliases : null;
        }
        if (TextUtils.isEmpty(value)) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        }
        return stringArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setCaCertificate(X509Certificate cert) {
        if (cert != null) {
            if (cert.getBasicConstraints() < 0) throw new IllegalArgumentException("Not a CA certificate");
            this.mCaCerts = new X509Certificate[]{cert};
            return;
        } else {
            this.mCaCerts = null;
        }
    }

    private final X509Certificate $$robo$$android_net_wifi_WifiEnterpriseConfig$getCaCertificate() {
        if (this.mCaCerts != null && this.mCaCerts.length > 0) {
            return this.mCaCerts[0];
        }
        return null;
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setCaCertificates(X509Certificate[] certs) {
        if (certs != null) {
            X509Certificate[] newCerts = new X509Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                if (certs[i].getBasicConstraints() < 0) {
                    throw new IllegalArgumentException("Not a CA certificate");
                }
                newCerts[i] = certs[i];
            }
            this.mCaCerts = newCerts;
        } else {
            this.mCaCerts = null;
        }
    }

    private final X509Certificate[] $$robo$$android_net_wifi_WifiEnterpriseConfig$getCaCertificates() {
        if (this.mCaCerts != null && this.mCaCerts.length > 0) {
            return this.mCaCerts;
        }
        return null;
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$resetCaCertificate() {
        this.mCaCerts = null;
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setCaPath(String path) {
        this.setFieldValue("ca_path", path);
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getCaPath() {
        return this.getFieldValue("ca_path", "");
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setClientCertificateAlias(String alias) {
        this.setFieldValue("client_cert", alias, "keystore://USRCERT_");
        this.setFieldValue("key_id", alias, "USRPKEY_");
        if (TextUtils.isEmpty(alias)) {
            this.mFields.put("engine", "0");
            this.mFields.put("engine_id", "NULL");
        } else {
            this.mFields.put("engine", "1");
            this.mFields.put("engine_id", this.convertToQuotedString("keystore"));
        }
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getClientCertificateAlias() {
        return this.getFieldValue("client_cert", "keystore://USRCERT_");
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setClientKeyEntry(PrivateKey privateKey, X509Certificate clientCertificate) {
        if (clientCertificate != null) {
            if (clientCertificate.getBasicConstraints() != -1) {
                throw new IllegalArgumentException("Cannot be a CA certificate");
            }
            if (privateKey == null) {
                throw new IllegalArgumentException("Client cert without a private key");
            }
            if (privateKey.getEncoded() == null) {
                throw new IllegalArgumentException("Private key cannot be encoded");
            }
        }
        this.mClientPrivateKey = privateKey;
        this.mClientCertificate = clientCertificate;
    }

    private final X509Certificate $$robo$$android_net_wifi_WifiEnterpriseConfig$getClientCertificate() {
        return this.mClientCertificate;
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$resetClientKeyEntry() {
        this.mClientPrivateKey = null;
        this.mClientCertificate = null;
    }

    private final PrivateKey $$robo$$android_net_wifi_WifiEnterpriseConfig$getClientPrivateKey() {
        return this.mClientPrivateKey;
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setSubjectMatch(String subjectMatch) {
        this.setFieldValue("subject_match", subjectMatch, "");
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getSubjectMatch() {
        return this.getFieldValue("subject_match", "");
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setAltSubjectMatch(String altSubjectMatch) {
        this.setFieldValue("altsubject_match", altSubjectMatch, "");
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getAltSubjectMatch() {
        return this.getFieldValue("altsubject_match", "");
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setDomainSuffixMatch(String domain) {
        this.setFieldValue("domain_suffix_match", domain);
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getDomainSuffixMatch() {
        return this.getFieldValue("domain_suffix_match", "");
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setRealm(String realm) {
        this.setFieldValue("realm", realm, "");
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getRealm() {
        return this.getFieldValue("realm", "");
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setPlmn(String plmn) {
        this.setFieldValue("plmn", plmn, "");
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getPlmn() {
        return this.getFieldValue("plmn", "");
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getKeyId(WifiEnterpriseConfig current) {
        if (this.mEapMethod == -1) {
            return current != null ? current.getKeyId(null) : "NULL";
        }
        if (!this.isEapMethodValid()) {
            return "NULL";
        }
        return Eap.strings[this.mEapMethod] + "_" + Phase2.strings[this.mPhase2Method];
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$removeDoubleQuotes(String string2) {
        if (TextUtils.isEmpty(string2)) {
            return "";
        }
        int length = string2.length();
        if (length > 1 && string2.charAt(0) == '\"' && string2.charAt(length - 1) == '\"') {
            return string2.substring(1, length - 1);
        }
        return string2;
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$convertToQuotedString(String string2) {
        return "\"" + string2 + "\"";
    }

    private final int $$robo$$android_net_wifi_WifiEnterpriseConfig$getStringIndex(String[] arr, String toBeFound, int defaultIndex) {
        if (TextUtils.isEmpty(toBeFound)) {
            return defaultIndex;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (!toBeFound.equals(arr[i])) continue;
            return i;
        }
        return defaultIndex;
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getFieldValue(String key, String prefix) {
        String value = this.mFields.get(key);
        if (TextUtils.isEmpty(value) || "NULL".equals(value)) {
            return "";
        }
        if ((value = this.removeDoubleQuotes(value)).startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setFieldValue(String key, String value, String prefix) {
        if (TextUtils.isEmpty(value)) {
            this.mFields.put(key, "NULL");
        } else {
            this.mFields.put(key, this.convertToQuotedString(prefix + value));
        }
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setFieldValue(String key, String value) {
        if (TextUtils.isEmpty(value)) {
            this.mFields.put(key, "NULL");
        } else {
            this.mFields.put(key, this.convertToQuotedString(value));
        }
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$toString() {
        StringBuffer sb = new StringBuffer();
        for (String key : this.mFields.keySet()) {
            String value = "password".equals(key) ? "<removed>" : this.mFields.get(key);
            sb.append(key).append(" ").append(value).append("\n");
        }
        return sb.toString();
    }

    private final boolean $$robo$$android_net_wifi_WifiEnterpriseConfig$isEapMethodValid() {
        if (this.mEapMethod == -1) {
            Log.e("WifiEnterpriseConfig", "WiFi enterprise configuration is invalid as it supplies no EAP method.");
            return false;
        }
        if (this.mEapMethod < 0 || this.mEapMethod >= Eap.strings.length) {
            Log.e("WifiEnterpriseConfig", "mEapMethod is invald for WiFi enterprise configuration: " + this.mEapMethod);
            return false;
        }
        if (this.mPhase2Method < 0 || this.mPhase2Method >= Phase2.strings.length) {
            Log.e("WifiEnterpriseConfig", "mPhase2Method is invald for WiFi enterprise configuration: " + this.mPhase2Method);
            return false;
        }
        return true;
    }

    static /* synthetic */ X509Certificate[] access$302(WifiEnterpriseConfig x0, X509Certificate[] x1) {
        x0.mCaCerts = x1;
        return x1;
    }

    static void __staticInitializer__() {
        SUPPLICANT_CONFIG_KEYS = new String[]{"identity", "anonymous_identity", "password", "client_cert", "ca_cert", "subject_match", "engine", "engine_id", "key_id", "altsubject_match", "domain_suffix_match", "ca_path"};
        CREATOR = new Parcelable.Creator<WifiEnterpriseConfig>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_WifiEnterpriseConfig_1$__constructor__() {
            }

            private final WifiEnterpriseConfig $$robo$$android_net_wifi_WifiEnterpriseConfig_1$createFromParcel(Parcel in) {
                WifiEnterpriseConfig enterpriseConfig = new WifiEnterpriseConfig();
                int count = in.readInt();
                for (int i = 0; i < count; ++i) {
                    String key = in.readString();
                    String value = in.readString();
                    enterpriseConfig.mFields.put(key, value);
                }
                enterpriseConfig.mEapMethod = in.readInt();
                enterpriseConfig.mPhase2Method = in.readInt();
                WifiEnterpriseConfig.access$302(enterpriseConfig, this.readCertificates(in));
                PrivateKey userKey = null;
                int len = in.readInt();
                if (len > 0) {
                    try {
                        byte[] bytes = new byte[len];
                        in.readByteArray(bytes);
                        String algorithm = in.readString();
                        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
                        userKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(bytes));
                    }
                    catch (NoSuchAlgorithmException e) {
                        userKey = null;
                    }
                    catch (InvalidKeySpecException e) {
                        userKey = null;
                    }
                }
                enterpriseConfig.mClientPrivateKey = userKey;
                enterpriseConfig.mClientCertificate = this.readCertificate(in);
                return enterpriseConfig;
            }

            private final X509Certificate[] $$robo$$android_net_wifi_WifiEnterpriseConfig_1$readCertificates(Parcel in) {
                X509Certificate[] certs = null;
                int len = in.readInt();
                if (len > 0) {
                    certs = new X509Certificate[len];
                    for (int i = 0; i < len; ++i) {
                        certs[i] = this.readCertificate(in);
                    }
                }
                return certs;
            }

            private final X509Certificate $$robo$$android_net_wifi_WifiEnterpriseConfig_1$readCertificate(Parcel in) {
                X509Certificate cert = null;
                int len = in.readInt();
                if (len > 0) {
                    try {
                        byte[] bytes = new byte[len];
                        in.readByteArray(bytes);
                        CertificateFactory cFactory = CertificateFactory.getInstance("X.509");
                        cert = (X509Certificate)cFactory.generateCertificate(new ByteArrayInputStream(bytes));
                    }
                    catch (CertificateException e) {
                        cert = null;
                    }
                }
                return cert;
            }

            private final WifiEnterpriseConfig[] $$robo$$android_net_wifi_WifiEnterpriseConfig_1$newArray(int size) {
                return new WifiEnterpriseConfig[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_WifiEnterpriseConfig_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiEnterpriseConfig_1$__constructor__(), 0, this);
            }

            @Override
            public WifiEnterpriseConfig createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_WifiEnterpriseConfig_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            private X509Certificate[] readCertificates(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("readCertificates", $$robo$$android_net_wifi_WifiEnterpriseConfig_1$readCertificates(android.os.Parcel ), 0, this, parcel);
            }

            private X509Certificate readCertificate(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("readCertificate", $$robo$$android_net_wifi_WifiEnterpriseConfig_1$readCertificate(android.os.Parcel ), 0, this, parcel);
            }

            public WifiEnterpriseConfig[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_WifiEnterpriseConfig_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_net_wifi_WifiEnterpriseConfig$__constructor__();
    }

    public WifiEnterpriseConfig() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiEnterpriseConfig$__constructor__(), 0, this);
    }

    private void __constructor__(WifiEnterpriseConfig wifiEnterpriseConfig) {
        this.$$robo$$android_net_wifi_WifiEnterpriseConfig$__constructor__(wifiEnterpriseConfig);
    }

    public WifiEnterpriseConfig(WifiEnterpriseConfig wifiEnterpriseConfig) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiEnterpriseConfig$__constructor__(android.net.wifi.WifiEnterpriseConfig ), 0, this, wifiEnterpriseConfig);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_WifiEnterpriseConfig$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiEnterpriseConfig$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void writeCertificates(Parcel parcel, X509Certificate[] x509CertificateArray) {
        InvokeDynamicSupport.bootstrap("writeCertificates", $$robo$$android_net_wifi_WifiEnterpriseConfig$writeCertificates(android.os.Parcel java.security.cert.X509Certificate[] ), 0, this, parcel, x509CertificateArray);
    }

    private void writeCertificate(Parcel parcel, X509Certificate x509Certificate) {
        InvokeDynamicSupport.bootstrap("writeCertificate", $$robo$$android_net_wifi_WifiEnterpriseConfig$writeCertificate(android.os.Parcel java.security.cert.X509Certificate ), 0, this, parcel, x509Certificate);
    }

    public boolean saveToSupplicant(SupplicantSaver supplicantSaver) {
        return (boolean)InvokeDynamicSupport.bootstrap("saveToSupplicant", $$robo$$android_net_wifi_WifiEnterpriseConfig$saveToSupplicant(android.net.wifi.WifiEnterpriseConfig$SupplicantSaver ), 0, this, supplicantSaver);
    }

    public void loadFromSupplicant(SupplicantLoader supplicantLoader) {
        InvokeDynamicSupport.bootstrap("loadFromSupplicant", $$robo$$android_net_wifi_WifiEnterpriseConfig$loadFromSupplicant(android.net.wifi.WifiEnterpriseConfig$SupplicantLoader ), 0, this, supplicantLoader);
    }

    public void setEapMethod(int n) {
        InvokeDynamicSupport.bootstrap("setEapMethod", $$robo$$android_net_wifi_WifiEnterpriseConfig$setEapMethod(int ), 0, this, n);
    }

    public int getEapMethod() {
        return (int)InvokeDynamicSupport.bootstrap("getEapMethod", $$robo$$android_net_wifi_WifiEnterpriseConfig$getEapMethod(), 0, this);
    }

    public void setPhase2Method(int n) {
        InvokeDynamicSupport.bootstrap("setPhase2Method", $$robo$$android_net_wifi_WifiEnterpriseConfig$setPhase2Method(int ), 0, this, n);
    }

    public int getPhase2Method() {
        return (int)InvokeDynamicSupport.bootstrap("getPhase2Method", $$robo$$android_net_wifi_WifiEnterpriseConfig$getPhase2Method(), 0, this);
    }

    public void setIdentity(String string2) {
        InvokeDynamicSupport.bootstrap("setIdentity", $$robo$$android_net_wifi_WifiEnterpriseConfig$setIdentity(java.lang.String ), 0, this, string2);
    }

    public String getIdentity() {
        return InvokeDynamicSupport.bootstrap("getIdentity", $$robo$$android_net_wifi_WifiEnterpriseConfig$getIdentity(), 0, this);
    }

    public void setAnonymousIdentity(String string2) {
        InvokeDynamicSupport.bootstrap("setAnonymousIdentity", $$robo$$android_net_wifi_WifiEnterpriseConfig$setAnonymousIdentity(java.lang.String ), 0, this, string2);
    }

    public String getAnonymousIdentity() {
        return InvokeDynamicSupport.bootstrap("getAnonymousIdentity", $$robo$$android_net_wifi_WifiEnterpriseConfig$getAnonymousIdentity(), 0, this);
    }

    public void setPassword(String string2) {
        InvokeDynamicSupport.bootstrap("setPassword", $$robo$$android_net_wifi_WifiEnterpriseConfig$setPassword(java.lang.String ), 0, this, string2);
    }

    public String getPassword() {
        return InvokeDynamicSupport.bootstrap("getPassword", $$robo$$android_net_wifi_WifiEnterpriseConfig$getPassword(), 0, this);
    }

    public static String encodeCaCertificateAlias(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("encodeCaCertificateAlias", $$robo$$android_net_wifi_WifiEnterpriseConfig$encodeCaCertificateAlias(java.lang.String ), 0, (String)string2);
    }

    public static String decodeCaCertificateAlias(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("decodeCaCertificateAlias", $$robo$$android_net_wifi_WifiEnterpriseConfig$decodeCaCertificateAlias(java.lang.String ), 0, (String)string2);
    }

    public void setCaCertificateAlias(String string2) {
        InvokeDynamicSupport.bootstrap("setCaCertificateAlias", $$robo$$android_net_wifi_WifiEnterpriseConfig$setCaCertificateAlias(java.lang.String ), 0, this, string2);
    }

    public void setCaCertificateAliases(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setCaCertificateAliases", $$robo$$android_net_wifi_WifiEnterpriseConfig$setCaCertificateAliases(java.lang.String[] ), 0, this, stringArray);
    }

    public String getCaCertificateAlias() {
        return InvokeDynamicSupport.bootstrap("getCaCertificateAlias", $$robo$$android_net_wifi_WifiEnterpriseConfig$getCaCertificateAlias(), 0, this);
    }

    public String[] getCaCertificateAliases() {
        return InvokeDynamicSupport.bootstrap("getCaCertificateAliases", $$robo$$android_net_wifi_WifiEnterpriseConfig$getCaCertificateAliases(), 0, this);
    }

    public void setCaCertificate(X509Certificate x509Certificate) {
        InvokeDynamicSupport.bootstrap("setCaCertificate", $$robo$$android_net_wifi_WifiEnterpriseConfig$setCaCertificate(java.security.cert.X509Certificate ), 0, this, x509Certificate);
    }

    public X509Certificate getCaCertificate() {
        return InvokeDynamicSupport.bootstrap("getCaCertificate", $$robo$$android_net_wifi_WifiEnterpriseConfig$getCaCertificate(), 0, this);
    }

    public void setCaCertificates(X509Certificate[] x509CertificateArray) {
        InvokeDynamicSupport.bootstrap("setCaCertificates", $$robo$$android_net_wifi_WifiEnterpriseConfig$setCaCertificates(java.security.cert.X509Certificate[] ), 0, this, x509CertificateArray);
    }

    public X509Certificate[] getCaCertificates() {
        return InvokeDynamicSupport.bootstrap("getCaCertificates", $$robo$$android_net_wifi_WifiEnterpriseConfig$getCaCertificates(), 0, this);
    }

    public void resetCaCertificate() {
        InvokeDynamicSupport.bootstrap("resetCaCertificate", $$robo$$android_net_wifi_WifiEnterpriseConfig$resetCaCertificate(), 0, this);
    }

    public void setCaPath(String string2) {
        InvokeDynamicSupport.bootstrap("setCaPath", $$robo$$android_net_wifi_WifiEnterpriseConfig$setCaPath(java.lang.String ), 0, this, string2);
    }

    public String getCaPath() {
        return InvokeDynamicSupport.bootstrap("getCaPath", $$robo$$android_net_wifi_WifiEnterpriseConfig$getCaPath(), 0, this);
    }

    public void setClientCertificateAlias(String string2) {
        InvokeDynamicSupport.bootstrap("setClientCertificateAlias", $$robo$$android_net_wifi_WifiEnterpriseConfig$setClientCertificateAlias(java.lang.String ), 0, this, string2);
    }

    public String getClientCertificateAlias() {
        return InvokeDynamicSupport.bootstrap("getClientCertificateAlias", $$robo$$android_net_wifi_WifiEnterpriseConfig$getClientCertificateAlias(), 0, this);
    }

    public void setClientKeyEntry(PrivateKey privateKey, X509Certificate x509Certificate) {
        InvokeDynamicSupport.bootstrap("setClientKeyEntry", $$robo$$android_net_wifi_WifiEnterpriseConfig$setClientKeyEntry(java.security.PrivateKey java.security.cert.X509Certificate ), 0, this, privateKey, x509Certificate);
    }

    public X509Certificate getClientCertificate() {
        return InvokeDynamicSupport.bootstrap("getClientCertificate", $$robo$$android_net_wifi_WifiEnterpriseConfig$getClientCertificate(), 0, this);
    }

    public void resetClientKeyEntry() {
        InvokeDynamicSupport.bootstrap("resetClientKeyEntry", $$robo$$android_net_wifi_WifiEnterpriseConfig$resetClientKeyEntry(), 0, this);
    }

    public PrivateKey getClientPrivateKey() {
        return InvokeDynamicSupport.bootstrap("getClientPrivateKey", $$robo$$android_net_wifi_WifiEnterpriseConfig$getClientPrivateKey(), 0, this);
    }

    public void setSubjectMatch(String string2) {
        InvokeDynamicSupport.bootstrap("setSubjectMatch", $$robo$$android_net_wifi_WifiEnterpriseConfig$setSubjectMatch(java.lang.String ), 0, this, string2);
    }

    public String getSubjectMatch() {
        return InvokeDynamicSupport.bootstrap("getSubjectMatch", $$robo$$android_net_wifi_WifiEnterpriseConfig$getSubjectMatch(), 0, this);
    }

    public void setAltSubjectMatch(String string2) {
        InvokeDynamicSupport.bootstrap("setAltSubjectMatch", $$robo$$android_net_wifi_WifiEnterpriseConfig$setAltSubjectMatch(java.lang.String ), 0, this, string2);
    }

    public String getAltSubjectMatch() {
        return InvokeDynamicSupport.bootstrap("getAltSubjectMatch", $$robo$$android_net_wifi_WifiEnterpriseConfig$getAltSubjectMatch(), 0, this);
    }

    public void setDomainSuffixMatch(String string2) {
        InvokeDynamicSupport.bootstrap("setDomainSuffixMatch", $$robo$$android_net_wifi_WifiEnterpriseConfig$setDomainSuffixMatch(java.lang.String ), 0, this, string2);
    }

    public String getDomainSuffixMatch() {
        return InvokeDynamicSupport.bootstrap("getDomainSuffixMatch", $$robo$$android_net_wifi_WifiEnterpriseConfig$getDomainSuffixMatch(), 0, this);
    }

    public void setRealm(String string2) {
        InvokeDynamicSupport.bootstrap("setRealm", $$robo$$android_net_wifi_WifiEnterpriseConfig$setRealm(java.lang.String ), 0, this, string2);
    }

    public String getRealm() {
        return InvokeDynamicSupport.bootstrap("getRealm", $$robo$$android_net_wifi_WifiEnterpriseConfig$getRealm(), 0, this);
    }

    public void setPlmn(String string2) {
        InvokeDynamicSupport.bootstrap("setPlmn", $$robo$$android_net_wifi_WifiEnterpriseConfig$setPlmn(java.lang.String ), 0, this, string2);
    }

    public String getPlmn() {
        return InvokeDynamicSupport.bootstrap("getPlmn", $$robo$$android_net_wifi_WifiEnterpriseConfig$getPlmn(), 0, this);
    }

    public String getKeyId(WifiEnterpriseConfig wifiEnterpriseConfig) {
        return InvokeDynamicSupport.bootstrap("getKeyId", $$robo$$android_net_wifi_WifiEnterpriseConfig$getKeyId(android.net.wifi.WifiEnterpriseConfig ), 0, this, wifiEnterpriseConfig);
    }

    private String removeDoubleQuotes(String string2) {
        return InvokeDynamicSupport.bootstrap("removeDoubleQuotes", $$robo$$android_net_wifi_WifiEnterpriseConfig$removeDoubleQuotes(java.lang.String ), 0, this, string2);
    }

    private String convertToQuotedString(String string2) {
        return InvokeDynamicSupport.bootstrap("convertToQuotedString", $$robo$$android_net_wifi_WifiEnterpriseConfig$convertToQuotedString(java.lang.String ), 0, this, string2);
    }

    private int getStringIndex(String[] stringArray, String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getStringIndex", $$robo$$android_net_wifi_WifiEnterpriseConfig$getStringIndex(java.lang.String[] java.lang.String int ), 0, this, stringArray, string2, n);
    }

    public String getFieldValue(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getFieldValue", $$robo$$android_net_wifi_WifiEnterpriseConfig$getFieldValue(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void setFieldValue(String string2, String string3, String string4) {
        InvokeDynamicSupport.bootstrap("setFieldValue", $$robo$$android_net_wifi_WifiEnterpriseConfig$setFieldValue(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
    }

    public void setFieldValue(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setFieldValue", $$robo$$android_net_wifi_WifiEnterpriseConfig$setFieldValue(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_WifiEnterpriseConfig$toString(), 0, this);
    }

    private boolean isEapMethodValid() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEapMethodValid", $$robo$$android_net_wifi_WifiEnterpriseConfig$isEapMethodValid(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(WifiEnterpriseConfig.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiEnterpriseConfig)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface SupplicantLoader
    extends InstrumentedInterface {
        public String loadValue(String var1);
    }

    public static interface SupplicantSaver
    extends InstrumentedInterface {
        public boolean saveValue(String var1, String var2);
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Phase2
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int NONE = 0;
        public static int PAP = 1;
        public static int MSCHAP = 2;
        public static int MSCHAPV2 = 3;
        public static int GTC = 4;
        private static String AUTH_PREFIX = "auth=";
        private static String AUTHEAP_PREFIX = "autheap=";
        public static String[] strings;

        private void $$robo$$android_net_wifi_WifiEnterpriseConfig_Phase2$__constructor__() {
        }

        static void __staticInitializer__() {
            strings = new String[]{"NULL", "PAP", "MSCHAP", "MSCHAPV2", "GTC"};
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiEnterpriseConfig_Phase2$__constructor__();
        }

        private Phase2() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiEnterpriseConfig_Phase2$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(Phase2.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Phase2)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Eap
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int NONE = -1;
        public static int PEAP = 0;
        public static int TLS = 1;
        public static int TTLS = 2;
        public static int PWD = 3;
        public static int SIM = 4;
        public static int AKA = 5;
        public static int AKA_PRIME = 6;
        public static int UNAUTH_TLS = 7;
        public static String[] strings;

        private void $$robo$$android_net_wifi_WifiEnterpriseConfig_Eap$__constructor__() {
        }

        static void __staticInitializer__() {
            strings = new String[]{"PEAP", "TLS", "TTLS", "PWD", "SIM", "AKA", "AKA'", "WFA-UNAUTH-TLS"};
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiEnterpriseConfig_Eap$__constructor__();
        }

        private Eap() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiEnterpriseConfig_Eap$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(Eap.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Eap)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

