/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.nan;

import android.net.wifi.nan.ConfigRequest;
import android.net.wifi.nan.IWifiNanManager;
import android.net.wifi.nan.PublishData;
import android.net.wifi.nan.PublishSettings;
import android.net.wifi.nan.SubscribeData;
import android.net.wifi.nan.SubscribeSettings;
import android.net.wifi.nan.WifiNanEventListener;
import android.net.wifi.nan.WifiNanPublishSession;
import android.net.wifi.nan.WifiNanSessionListener;
import android.net.wifi.nan.WifiNanSubscribeSession;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiNanManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "WifiNanManager";
    private static boolean DBG = false;
    private static boolean VDBG = false;
    private IBinder mBinder;
    private IWifiNanManager mService;

    private void $$robo$$android_net_wifi_nan_WifiNanManager$__constructor__(IWifiNanManager service) {
        this.mService = service;
    }

    private final void $$robo$$android_net_wifi_nan_WifiNanManager$connect(WifiNanEventListener listener, int events) {
        try {
            if (listener == null) {
                throw new IllegalArgumentException("Invalid listener - must not be null");
            }
            if (this.mBinder == null) {
                this.mBinder = new Binder();
            }
            this.mService.connect(this.mBinder, listener.callback, events);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_nan_WifiNanManager$disconnect() {
        try {
            this.mService.disconnect(this.mBinder);
            this.mBinder = null;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_nan_WifiNanManager$requestConfig(ConfigRequest configRequest) {
        try {
            this.mService.requestConfig(configRequest);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final WifiNanPublishSession $$robo$$android_net_wifi_nan_WifiNanManager$publish(PublishData publishData, PublishSettings publishSettings, WifiNanSessionListener listener, int events) {
        return this.publishRaw(publishData, publishSettings, listener, events | 0xF5);
    }

    private final WifiNanPublishSession $$robo$$android_net_wifi_nan_WifiNanManager$publishRaw(PublishData publishData, PublishSettings publishSettings, WifiNanSessionListener listener, int events) {
        int sessionId;
        if (publishSettings.mPublishType == 0 && publishData.mRxFilterLength != 0) {
            throw new IllegalArgumentException("Invalid publish data & settings: UNSOLICITED publishes (active) can't have an Rx filter");
        }
        if (publishSettings.mPublishType == 1 && publishData.mTxFilterLength != 0) {
            throw new IllegalArgumentException("Invalid publish data & settings: SOLICITED publishes (passive) can't have a Tx filter");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Invalid listener - must not be null");
        }
        try {
            sessionId = this.mService.createSession(listener.callback, events);
            this.mService.publish(sessionId, publishData, publishSettings);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return new WifiNanPublishSession(this, sessionId);
    }

    private final void $$robo$$android_net_wifi_nan_WifiNanManager$publish(int sessionId, PublishData publishData, PublishSettings publishSettings) {
        if (publishSettings.mPublishType == 0 && publishData.mRxFilterLength != 0) {
            throw new IllegalArgumentException("Invalid publish data & settings: UNSOLICITED publishes (active) can't have an Rx filter");
        }
        if (publishSettings.mPublishType == 1 && publishData.mTxFilterLength != 0) {
            throw new IllegalArgumentException("Invalid publish data & settings: SOLICITED publishes (passive) can't have a Tx filter");
        }
        try {
            this.mService.publish(sessionId, publishData, publishSettings);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final WifiNanSubscribeSession $$robo$$android_net_wifi_nan_WifiNanManager$subscribe(SubscribeData subscribeData, SubscribeSettings subscribeSettings, WifiNanSessionListener listener, int events) {
        return this.subscribeRaw(subscribeData, subscribeSettings, listener, events | 0xF5);
    }

    private final WifiNanSubscribeSession $$robo$$android_net_wifi_nan_WifiNanManager$subscribeRaw(SubscribeData subscribeData, SubscribeSettings subscribeSettings, WifiNanSessionListener listener, int events) {
        int sessionId;
        if (subscribeSettings.mSubscribeType == 1 && subscribeData.mRxFilterLength != 0) {
            throw new IllegalArgumentException("Invalid subscribe data & settings: ACTIVE subscribes can't have an Rx filter");
        }
        if (subscribeSettings.mSubscribeType == 0 && subscribeData.mTxFilterLength != 0) {
            throw new IllegalArgumentException("Invalid subscribe data & settings: PASSIVE subscribes can't have a Tx filter");
        }
        try {
            sessionId = this.mService.createSession(listener.callback, events);
            this.mService.subscribe(sessionId, subscribeData, subscribeSettings);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return new WifiNanSubscribeSession(this, sessionId);
    }

    private final void $$robo$$android_net_wifi_nan_WifiNanManager$subscribe(int sessionId, SubscribeData subscribeData, SubscribeSettings subscribeSettings) {
        if (subscribeSettings.mSubscribeType == 1 && subscribeData.mRxFilterLength != 0) {
            throw new IllegalArgumentException("Invalid subscribe data & settings: ACTIVE subscribes can't have an Rx filter");
        }
        if (subscribeSettings.mSubscribeType == 0 && subscribeData.mTxFilterLength != 0) {
            throw new IllegalArgumentException("Invalid subscribe data & settings: PASSIVE subscribes can't have a Tx filter");
        }
        try {
            this.mService.subscribe(sessionId, subscribeData, subscribeSettings);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_nan_WifiNanManager$stopSession(int sessionId) {
        try {
            this.mService.stopSession(sessionId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_nan_WifiNanManager$destroySession(int sessionId) {
        try {
            this.mService.destroySession(sessionId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_nan_WifiNanManager$sendMessage(int sessionId, int peerId, byte[] message, int messageLength, int messageId) {
        try {
            this.mService.sendMessage(sessionId, peerId, message, messageLength, messageId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void __constructor__(IWifiNanManager iWifiNanManager) {
        this.$$robo$$android_net_wifi_nan_WifiNanManager$__constructor__(iWifiNanManager);
    }

    public WifiNanManager(IWifiNanManager iWifiNanManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_nan_WifiNanManager$__constructor__(android.net.wifi.nan.IWifiNanManager ), 0, this, iWifiNanManager);
    }

    public void connect(WifiNanEventListener wifiNanEventListener, int n) {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$android_net_wifi_nan_WifiNanManager$connect(android.net.wifi.nan.WifiNanEventListener int ), 0, this, wifiNanEventListener, n);
    }

    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_net_wifi_nan_WifiNanManager$disconnect(), 0, this);
    }

    public void requestConfig(ConfigRequest configRequest) {
        InvokeDynamicSupport.bootstrap("requestConfig", $$robo$$android_net_wifi_nan_WifiNanManager$requestConfig(android.net.wifi.nan.ConfigRequest ), 0, this, configRequest);
    }

    public WifiNanPublishSession publish(PublishData publishData, PublishSettings publishSettings, WifiNanSessionListener wifiNanSessionListener, int n) {
        return InvokeDynamicSupport.bootstrap("publish", $$robo$$android_net_wifi_nan_WifiNanManager$publish(android.net.wifi.nan.PublishData android.net.wifi.nan.PublishSettings android.net.wifi.nan.WifiNanSessionListener int ), 0, this, publishData, publishSettings, wifiNanSessionListener, n);
    }

    public WifiNanPublishSession publishRaw(PublishData publishData, PublishSettings publishSettings, WifiNanSessionListener wifiNanSessionListener, int n) {
        return InvokeDynamicSupport.bootstrap("publishRaw", $$robo$$android_net_wifi_nan_WifiNanManager$publishRaw(android.net.wifi.nan.PublishData android.net.wifi.nan.PublishSettings android.net.wifi.nan.WifiNanSessionListener int ), 0, this, publishData, publishSettings, wifiNanSessionListener, n);
    }

    public void publish(int n, PublishData publishData, PublishSettings publishSettings) {
        InvokeDynamicSupport.bootstrap("publish", $$robo$$android_net_wifi_nan_WifiNanManager$publish(int android.net.wifi.nan.PublishData android.net.wifi.nan.PublishSettings ), 0, this, n, publishData, publishSettings);
    }

    public WifiNanSubscribeSession subscribe(SubscribeData subscribeData, SubscribeSettings subscribeSettings, WifiNanSessionListener wifiNanSessionListener, int n) {
        return InvokeDynamicSupport.bootstrap("subscribe", $$robo$$android_net_wifi_nan_WifiNanManager$subscribe(android.net.wifi.nan.SubscribeData android.net.wifi.nan.SubscribeSettings android.net.wifi.nan.WifiNanSessionListener int ), 0, this, subscribeData, subscribeSettings, wifiNanSessionListener, n);
    }

    public WifiNanSubscribeSession subscribeRaw(SubscribeData subscribeData, SubscribeSettings subscribeSettings, WifiNanSessionListener wifiNanSessionListener, int n) {
        return InvokeDynamicSupport.bootstrap("subscribeRaw", $$robo$$android_net_wifi_nan_WifiNanManager$subscribeRaw(android.net.wifi.nan.SubscribeData android.net.wifi.nan.SubscribeSettings android.net.wifi.nan.WifiNanSessionListener int ), 0, this, subscribeData, subscribeSettings, wifiNanSessionListener, n);
    }

    public void subscribe(int n, SubscribeData subscribeData, SubscribeSettings subscribeSettings) {
        InvokeDynamicSupport.bootstrap("subscribe", $$robo$$android_net_wifi_nan_WifiNanManager$subscribe(int android.net.wifi.nan.SubscribeData android.net.wifi.nan.SubscribeSettings ), 0, this, n, subscribeData, subscribeSettings);
    }

    public void stopSession(int n) {
        InvokeDynamicSupport.bootstrap("stopSession", $$robo$$android_net_wifi_nan_WifiNanManager$stopSession(int ), 0, this, n);
    }

    public void destroySession(int n) {
        InvokeDynamicSupport.bootstrap("destroySession", $$robo$$android_net_wifi_nan_WifiNanManager$destroySession(int ), 0, this, n);
    }

    public void sendMessage(int n, int n2, byte[] byArray, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$android_net_wifi_nan_WifiNanManager$sendMessage(int int byte[] int int ), 0, this, n, n2, byArray, n3, n4);
    }

    public /* synthetic */ WifiNanManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiNanManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

