/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.net.wifi.p2p.WifiP2pDevice;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiP2pGroup
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int TEMPORARY_NET_ID = -1;
    public static int PERSISTENT_NET_ID = -2;
    private String mNetworkName;
    private WifiP2pDevice mOwner;
    private boolean mIsGroupOwner;
    private List<WifiP2pDevice> mClients;
    private String mPassphrase;
    private String mInterface;
    private int mNetId;
    private static Pattern groupStartedPattern;
    public static Parcelable.Creator<WifiP2pGroup> CREATOR;

    private void $$robo$$android_net_wifi_p2p_WifiP2pGroup$__constructor__() {
        this.mClients = new ArrayList<WifiP2pDevice>();
    }

    private void $$robo$$android_net_wifi_p2p_WifiP2pGroup$__constructor__(String supplicantEvent) throws IllegalArgumentException {
        this.mClients = new ArrayList<WifiP2pDevice>();
        String[] tokens = supplicantEvent.split(" ");
        if (tokens.length < 3) {
            throw new IllegalArgumentException("Malformed supplicant event");
        }
        if (tokens[0].startsWith("P2P-GROUP")) {
            this.mInterface = tokens[1];
            this.mIsGroupOwner = tokens[2].equals("GO");
            Matcher match = groupStartedPattern.matcher(supplicantEvent);
            if (!match.find()) {
                return;
            }
            this.mNetworkName = match.group(1);
            this.mPassphrase = match.group(4);
            this.mOwner = new WifiP2pDevice(match.group(5));
            this.mNetId = match.group(6) != null ? -2 : -1;
        } else if (tokens[0].equals("P2P-INVITATION-RECEIVED")) {
            String sa = null;
            this.mNetId = -2;
            for (String token : tokens) {
                String[] nameValue = token.split("=");
                if (nameValue.length != 2) continue;
                if (nameValue[0].equals("sa")) {
                    sa = nameValue[1];
                    WifiP2pDevice dev = new WifiP2pDevice();
                    dev.deviceAddress = nameValue[1];
                    this.mClients.add(dev);
                    continue;
                }
                if (nameValue[0].equals("go_dev_addr")) {
                    this.mOwner = new WifiP2pDevice(nameValue[1]);
                    continue;
                }
                if (!nameValue[0].equals("persistent")) continue;
                this.mOwner = new WifiP2pDevice(sa);
                this.mNetId = Integer.parseInt(nameValue[1]);
            }
        } else {
            throw new IllegalArgumentException("Malformed supplicant event");
        }
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pGroup$setNetworkName(String networkName) {
        this.mNetworkName = networkName;
    }

    private final String $$robo$$android_net_wifi_p2p_WifiP2pGroup$getNetworkName() {
        return this.mNetworkName;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pGroup$setIsGroupOwner(boolean isGo) {
        this.mIsGroupOwner = isGo;
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pGroup$isGroupOwner() {
        return this.mIsGroupOwner;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pGroup$setOwner(WifiP2pDevice device) {
        this.mOwner = device;
    }

    private final WifiP2pDevice $$robo$$android_net_wifi_p2p_WifiP2pGroup$getOwner() {
        return this.mOwner;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pGroup$addClient(String address) {
        this.addClient(new WifiP2pDevice(address));
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pGroup$addClient(WifiP2pDevice device) {
        for (WifiP2pDevice client : this.mClients) {
            if (!client.equals(device)) continue;
            return;
        }
        this.mClients.add(device);
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pGroup$removeClient(String address) {
        return this.mClients.remove(new WifiP2pDevice(address));
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pGroup$removeClient(WifiP2pDevice device) {
        return this.mClients.remove(device);
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pGroup$isClientListEmpty() {
        return this.mClients.size() == 0;
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pGroup$contains(WifiP2pDevice device) {
        return this.mOwner.equals(device) || this.mClients.contains(device);
    }

    private final Collection<WifiP2pDevice> $$robo$$android_net_wifi_p2p_WifiP2pGroup$getClientList() {
        return Collections.unmodifiableCollection(this.mClients);
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pGroup$setPassphrase(String passphrase) {
        this.mPassphrase = passphrase;
    }

    private final String $$robo$$android_net_wifi_p2p_WifiP2pGroup$getPassphrase() {
        return this.mPassphrase;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pGroup$setInterface(String intf) {
        this.mInterface = intf;
    }

    private final String $$robo$$android_net_wifi_p2p_WifiP2pGroup$getInterface() {
        return this.mInterface;
    }

    private final int $$robo$$android_net_wifi_p2p_WifiP2pGroup$getNetworkId() {
        return this.mNetId;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pGroup$setNetworkId(int netId) {
        this.mNetId = netId;
    }

    private final String $$robo$$android_net_wifi_p2p_WifiP2pGroup$toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("network: ").append(this.mNetworkName);
        sbuf.append("\n isGO: ").append(this.mIsGroupOwner);
        sbuf.append("\n GO: ").append(this.mOwner);
        for (WifiP2pDevice client : this.mClients) {
            sbuf.append("\n Client: ").append(client);
        }
        sbuf.append("\n interface: ").append(this.mInterface);
        sbuf.append("\n networkId: ").append(this.mNetId);
        return sbuf.toString();
    }

    private final int $$robo$$android_net_wifi_p2p_WifiP2pGroup$describeContents() {
        return 0;
    }

    private void $$robo$$android_net_wifi_p2p_WifiP2pGroup$__constructor__(WifiP2pGroup source) {
        this.mClients = new ArrayList<WifiP2pDevice>();
        if (source != null) {
            this.mNetworkName = source.getNetworkName();
            this.mOwner = new WifiP2pDevice(source.getOwner());
            this.mIsGroupOwner = source.mIsGroupOwner;
            for (WifiP2pDevice d : source.getClientList()) {
                this.mClients.add(d);
            }
            this.mPassphrase = source.getPassphrase();
            this.mInterface = source.getInterface();
            this.mNetId = source.getNetworkId();
        }
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pGroup$writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mNetworkName);
        dest.writeParcelable(this.mOwner, flags);
        dest.writeByte(this.mIsGroupOwner ? (byte)1 : 0);
        dest.writeInt(this.mClients.size());
        for (WifiP2pDevice client : this.mClients) {
            dest.writeParcelable(client, flags);
        }
        dest.writeString(this.mPassphrase);
        dest.writeString(this.mInterface);
        dest.writeInt(this.mNetId);
    }

    static void __staticInitializer__() {
        groupStartedPattern = Pattern.compile("ssid=\"(.+)\" freq=(\\d+) (?:psk=)?([0-9a-fA-F]{64})?(?:passphrase=)?(?:\"(.{0,63})\")? go_dev_addr=((?:[0-9a-f]{2}:){5}[0-9a-f]{2}) ?(\\[PERSISTENT\\])?");
        CREATOR = new Parcelable.Creator<WifiP2pGroup>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_p2p_WifiP2pGroup_1$__constructor__() {
            }

            private final WifiP2pGroup $$robo$$android_net_wifi_p2p_WifiP2pGroup_1$createFromParcel(Parcel in) {
                WifiP2pGroup group = new WifiP2pGroup();
                group.setNetworkName(in.readString());
                group.setOwner((WifiP2pDevice)in.readParcelable(null));
                group.setIsGroupOwner(in.readByte() == 1);
                int clientCount = in.readInt();
                for (int i = 0; i < clientCount; ++i) {
                    group.addClient((WifiP2pDevice)in.readParcelable(null));
                }
                group.setPassphrase(in.readString());
                group.setInterface(in.readString());
                group.setNetworkId(in.readInt());
                return group;
            }

            private final WifiP2pGroup[] $$robo$$android_net_wifi_p2p_WifiP2pGroup_1$newArray(int size) {
                return new WifiP2pGroup[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_p2p_WifiP2pGroup_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pGroup_1$__constructor__(), 0, this);
            }

            @Override
            public WifiP2pGroup createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_p2p_WifiP2pGroup_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public WifiP2pGroup[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_p2p_WifiP2pGroup_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_net_wifi_p2p_WifiP2pGroup$__constructor__();
    }

    public WifiP2pGroup() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pGroup$__constructor__(), 0, this);
    }

    private void __constructor__(String string2) throws IllegalArgumentException {
        this.$$robo$$android_net_wifi_p2p_WifiP2pGroup$__constructor__(string2);
    }

    public WifiP2pGroup(String string2) throws IllegalArgumentException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pGroup$__constructor__(java.lang.String ), 0, this, string2);
    }

    public void setNetworkName(String string2) {
        InvokeDynamicSupport.bootstrap("setNetworkName", $$robo$$android_net_wifi_p2p_WifiP2pGroup$setNetworkName(java.lang.String ), 0, this, string2);
    }

    public String getNetworkName() {
        return InvokeDynamicSupport.bootstrap("getNetworkName", $$robo$$android_net_wifi_p2p_WifiP2pGroup$getNetworkName(), 0, this);
    }

    public void setIsGroupOwner(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsGroupOwner", $$robo$$android_net_wifi_p2p_WifiP2pGroup$setIsGroupOwner(boolean ), 0, this, bl);
    }

    public boolean isGroupOwner() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGroupOwner", $$robo$$android_net_wifi_p2p_WifiP2pGroup$isGroupOwner(), 0, this);
    }

    public void setOwner(WifiP2pDevice wifiP2pDevice) {
        InvokeDynamicSupport.bootstrap("setOwner", $$robo$$android_net_wifi_p2p_WifiP2pGroup$setOwner(android.net.wifi.p2p.WifiP2pDevice ), 0, this, wifiP2pDevice);
    }

    public WifiP2pDevice getOwner() {
        return InvokeDynamicSupport.bootstrap("getOwner", $$robo$$android_net_wifi_p2p_WifiP2pGroup$getOwner(), 0, this);
    }

    public void addClient(String string2) {
        InvokeDynamicSupport.bootstrap("addClient", $$robo$$android_net_wifi_p2p_WifiP2pGroup$addClient(java.lang.String ), 0, this, string2);
    }

    public void addClient(WifiP2pDevice wifiP2pDevice) {
        InvokeDynamicSupport.bootstrap("addClient", $$robo$$android_net_wifi_p2p_WifiP2pGroup$addClient(android.net.wifi.p2p.WifiP2pDevice ), 0, this, wifiP2pDevice);
    }

    public boolean removeClient(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeClient", $$robo$$android_net_wifi_p2p_WifiP2pGroup$removeClient(java.lang.String ), 0, this, string2);
    }

    public boolean removeClient(WifiP2pDevice wifiP2pDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeClient", $$robo$$android_net_wifi_p2p_WifiP2pGroup$removeClient(android.net.wifi.p2p.WifiP2pDevice ), 0, this, wifiP2pDevice);
    }

    public boolean isClientListEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isClientListEmpty", $$robo$$android_net_wifi_p2p_WifiP2pGroup$isClientListEmpty(), 0, this);
    }

    public boolean contains(WifiP2pDevice wifiP2pDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_net_wifi_p2p_WifiP2pGroup$contains(android.net.wifi.p2p.WifiP2pDevice ), 0, this, wifiP2pDevice);
    }

    public Collection<WifiP2pDevice> getClientList() {
        return InvokeDynamicSupport.bootstrap("getClientList", $$robo$$android_net_wifi_p2p_WifiP2pGroup$getClientList(), 0, this);
    }

    public void setPassphrase(String string2) {
        InvokeDynamicSupport.bootstrap("setPassphrase", $$robo$$android_net_wifi_p2p_WifiP2pGroup$setPassphrase(java.lang.String ), 0, this, string2);
    }

    public String getPassphrase() {
        return InvokeDynamicSupport.bootstrap("getPassphrase", $$robo$$android_net_wifi_p2p_WifiP2pGroup$getPassphrase(), 0, this);
    }

    public void setInterface(String string2) {
        InvokeDynamicSupport.bootstrap("setInterface", $$robo$$android_net_wifi_p2p_WifiP2pGroup$setInterface(java.lang.String ), 0, this, string2);
    }

    public String getInterface() {
        return InvokeDynamicSupport.bootstrap("getInterface", $$robo$$android_net_wifi_p2p_WifiP2pGroup$getInterface(), 0, this);
    }

    public int getNetworkId() {
        return (int)InvokeDynamicSupport.bootstrap("getNetworkId", $$robo$$android_net_wifi_p2p_WifiP2pGroup$getNetworkId(), 0, this);
    }

    public void setNetworkId(int n) {
        InvokeDynamicSupport.bootstrap("setNetworkId", $$robo$$android_net_wifi_p2p_WifiP2pGroup$setNetworkId(int ), 0, this, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_p2p_WifiP2pGroup$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_p2p_WifiP2pGroup$describeContents(), 0, this);
    }

    private void __constructor__(WifiP2pGroup wifiP2pGroup) {
        this.$$robo$$android_net_wifi_p2p_WifiP2pGroup$__constructor__(wifiP2pGroup);
    }

    public WifiP2pGroup(WifiP2pGroup wifiP2pGroup) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pGroup$__constructor__(android.net.wifi.p2p.WifiP2pGroup ), 0, this, wifiP2pGroup);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_p2p_WifiP2pGroup$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(WifiP2pGroup.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiP2pGroup)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

