/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Slog;
import dalvik.system.VMRuntime;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Build
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Build";
    public static String UNKNOWN = "unknown";
    public static String ID;
    public static String DISPLAY;
    public static String PRODUCT;
    public static String DEVICE;
    public static String BOARD;
    @Deprecated
    public static String CPU_ABI;
    @Deprecated
    public static String CPU_ABI2;
    public static String MANUFACTURER;
    public static String BRAND;
    public static String MODEL;
    public static String BOOTLOADER;
    @Deprecated
    public static String RADIO;
    public static String HARDWARE;
    public static boolean IS_EMULATOR;
    public static String SERIAL;
    public static String[] SUPPORTED_ABIS;
    public static String[] SUPPORTED_32_BIT_ABIS;
    public static String[] SUPPORTED_64_BIT_ABIS;
    public static String TYPE;
    public static String TAGS;
    public static String FINGERPRINT;
    public static long TIME;
    public static String USER;
    public static String HOST;
    public static boolean IS_DEBUGGABLE;
    public static boolean PERMISSIONS_REVIEW_REQUIRED;

    private void $$robo$$android_os_Build$__constructor__() {
    }

    private static final String $$robo$$android_os_Build$deriveFingerprint() {
        String finger = SystemProperties.get("ro.build.fingerprint");
        if (TextUtils.isEmpty(finger)) {
            finger = Build.getString("ro.product.brand") + '/' + Build.getString("ro.product.name") + '/' + Build.getString("ro.product.device") + ':' + Build.getString("ro.build.version.release") + '/' + Build.getString("ro.build.id") + '/' + Build.getString("ro.build.version.incremental") + ':' + Build.getString("ro.build.type") + '/' + Build.getString("ro.build.tags");
        }
        return finger;
    }

    private static final void $$robo$$android_os_Build$ensureFingerprintProperty() {
        if (TextUtils.isEmpty(SystemProperties.get("ro.build.fingerprint"))) {
            try {
                SystemProperties.set("ro.build.fingerprint", FINGERPRINT);
            }
            catch (IllegalArgumentException e) {
                Slog.e("Build", "Failed to set fingerprint property", e);
            }
        }
    }

    private static final boolean $$robo$$android_os_Build$isBuildConsistent() {
        if ("eng".equals(TYPE)) {
            return true;
        }
        String system = SystemProperties.get("ro.build.fingerprint");
        String vendor = SystemProperties.get("ro.vendor.build.fingerprint");
        String bootimage = SystemProperties.get("ro.bootimage.build.fingerprint");
        String requiredBootloader = SystemProperties.get("ro.build.expect.bootloader");
        String currentBootloader = SystemProperties.get("ro.bootloader");
        String requiredRadio = SystemProperties.get("ro.build.expect.baseband");
        String currentRadio = SystemProperties.get("gsm.version.baseband");
        if (TextUtils.isEmpty(system)) {
            Slog.e("Build", "Required ro.build.fingerprint is empty!");
            return false;
        }
        if (!TextUtils.isEmpty(vendor) && !Objects.equals(system, vendor)) {
            Slog.e("Build", "Mismatched fingerprints; system reported " + system + " but vendor reported " + vendor);
            return false;
        }
        return true;
    }

    private static final String $$robo$$android_os_Build$getRadioVersion() {
        return SystemProperties.get("gsm.version.baseband", null);
    }

    private static final String $$robo$$android_os_Build$getString(String property) {
        return SystemProperties.get(property, "unknown");
    }

    private static final String[] $$robo$$android_os_Build$getStringList(String property, String separator) {
        String value = SystemProperties.get(property);
        if (value.isEmpty()) {
            return new String[0];
        }
        return value.split(separator);
    }

    private static final long $$robo$$android_os_Build$getLong(String property) {
        try {
            return Long.parseLong(SystemProperties.get(property));
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    static void __staticInitializer__() {
        ID = Build.getString("ro.build.id");
        DISPLAY = Build.getString("ro.build.display.id");
        PRODUCT = Build.getString("ro.product.name");
        DEVICE = Build.getString("ro.product.device");
        BOARD = Build.getString("ro.product.board");
        MANUFACTURER = Build.getString("ro.product.manufacturer");
        BRAND = Build.getString("ro.product.brand");
        MODEL = Build.getString("ro.product.model");
        BOOTLOADER = Build.getString("ro.bootloader");
        RADIO = Build.getString("gsm.version.baseband");
        HARDWARE = Build.getString("ro.hardware");
        IS_EMULATOR = Build.getString("ro.kernel.qemu").equals("1");
        SERIAL = Build.getString("ro.serialno");
        SUPPORTED_ABIS = Build.getStringList("ro.product.cpu.abilist", ",");
        SUPPORTED_32_BIT_ABIS = Build.getStringList("ro.product.cpu.abilist32", ",");
        SUPPORTED_64_BIT_ABIS = Build.getStringList("ro.product.cpu.abilist64", ",");
        String[] abiList = VMRuntime.getRuntime().is64Bit() ? SUPPORTED_64_BIT_ABIS : SUPPORTED_32_BIT_ABIS;
        CPU_ABI = abiList[0];
        CPU_ABI2 = abiList.length > 1 ? abiList[1] : "";
        TYPE = Build.getString("ro.build.type");
        TAGS = Build.getString("ro.build.tags");
        FINGERPRINT = Build.deriveFingerprint();
        TIME = Build.getLong("ro.build.date.utc") * 1000L;
        USER = Build.getString("ro.build.user");
        HOST = Build.getString("ro.build.host");
        IS_DEBUGGABLE = SystemProperties.getInt("ro.debuggable", 0) == 1;
        PERMISSIONS_REVIEW_REQUIRED = SystemProperties.getInt("ro.permission_review_required", 0) == 1;
    }

    private void __constructor__() {
        this.$$robo$$android_os_Build$__constructor__();
    }

    public Build() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Build$__constructor__(), 0, this);
    }

    private static String deriveFingerprint() {
        return InvokeDynamicSupport.bootstrapStatic("deriveFingerprint", $$robo$$android_os_Build$deriveFingerprint(), 0);
    }

    public static void ensureFingerprintProperty() {
        InvokeDynamicSupport.bootstrapStatic("ensureFingerprintProperty", $$robo$$android_os_Build$ensureFingerprintProperty(), 0);
    }

    public static boolean isBuildConsistent() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isBuildConsistent", $$robo$$android_os_Build$isBuildConsistent(), 0);
    }

    public static String getRadioVersion() {
        return InvokeDynamicSupport.bootstrapStatic("getRadioVersion", $$robo$$android_os_Build$getRadioVersion(), 0);
    }

    private static String getString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getString", $$robo$$android_os_Build$getString(java.lang.String ), 0, (String)string2);
    }

    private static String[] getStringList(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getStringList", $$robo$$android_os_Build$getStringList(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private static long getLong(String string2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getLong", $$robo$$android_os_Build$getLong(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(Build.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Build)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class VERSION_CODES
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int CUR_DEVELOPMENT = 10000;
        public static int BASE = 1;
        public static int BASE_1_1 = 2;
        public static int CUPCAKE = 3;
        public static int DONUT = 4;
        public static int ECLAIR = 5;
        public static int ECLAIR_0_1 = 6;
        public static int ECLAIR_MR1 = 7;
        public static int FROYO = 8;
        public static int GINGERBREAD = 9;
        public static int GINGERBREAD_MR1 = 10;
        public static int HONEYCOMB = 11;
        public static int HONEYCOMB_MR1 = 12;
        public static int HONEYCOMB_MR2 = 13;
        public static int ICE_CREAM_SANDWICH = 14;
        public static int ICE_CREAM_SANDWICH_MR1 = 15;
        public static int JELLY_BEAN = 16;
        public static int JELLY_BEAN_MR1 = 17;
        public static int JELLY_BEAN_MR2 = 18;
        public static int KITKAT = 19;
        public static int KITKAT_WATCH = 20;
        public static int L = 21;
        public static int LOLLIPOP = 21;
        public static int LOLLIPOP_MR1 = 22;
        public static int M = 23;
        public static int N = 24;

        private void $$robo$$android_os_Build_VERSION_CODES$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_os_Build_VERSION_CODES$__constructor__();
        }

        public VERSION_CODES() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Build_VERSION_CODES$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VERSION_CODES)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class VERSION
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static String INCREMENTAL;
        public static String RELEASE;
        public static String BASE_OS;
        public static String SECURITY_PATCH;
        @Deprecated
        public static String SDK;
        public static int SDK_INT;
        public static int PREVIEW_SDK_INT;
        public static String CODENAME;
        private static String[] ALL_CODENAMES;
        public static String[] ACTIVE_CODENAMES;
        public static int RESOURCES_SDK_INT;

        private void $$robo$$android_os_Build_VERSION$__constructor__() {
        }

        static void __staticInitializer__() {
            INCREMENTAL = Build.getString("ro.build.version.incremental");
            RELEASE = Build.getString("ro.build.version.release");
            BASE_OS = SystemProperties.get("ro.build.version.base_os", "");
            SECURITY_PATCH = SystemProperties.get("ro.build.version.security_patch", "");
            SDK = Build.getString("ro.build.version.sdk");
            SDK_INT = SystemProperties.getInt("ro.build.version.sdk", 0);
            PREVIEW_SDK_INT = SystemProperties.getInt("ro.build.version.preview_sdk", 0);
            CODENAME = Build.getString("ro.build.version.codename");
            ALL_CODENAMES = Build.getStringList("ro.build.version.all_codenames", ",");
            ACTIVE_CODENAMES = "REL".equals(ALL_CODENAMES[0]) ? new String[]{} : ALL_CODENAMES;
            RESOURCES_SDK_INT = SDK_INT + ACTIVE_CODENAMES.length;
        }

        private void __constructor__() {
            this.$$robo$$android_os_Build_VERSION$__constructor__();
        }

        public VERSION() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Build_VERSION$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(VERSION.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VERSION)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

