/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.app.ActivityThread;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.IPackageMoveObserver;
import android.os.Binder;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.storage.DiskInfo;
import android.os.storage.IMountService;
import android.os.storage.IMountServiceListener;
import android.os.storage.IObbActionListener;
import android.os.storage.OnObbStateChangeListener;
import android.os.storage.StorageEventListener;
import android.os.storage.StorageVolume;
import android.os.storage.VolumeInfo;
import android.os.storage.VolumeRecord;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.Preconditions;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class StorageManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "StorageManager";
    public static String PROP_PRIMARY_PHYSICAL = "ro.vold.primary_physical";
    public static String PROP_HAS_ADOPTABLE = "vold.has_adoptable";
    public static String PROP_FORCE_ADOPTABLE = "persist.fw.force_adoptable";
    public static String PROP_EMULATE_FBE = "persist.sys.emulate_fbe";
    public static String PROP_SDCARDFS = "persist.sys.sdcardfs";
    public static String UUID_PRIVATE_INTERNAL;
    public static String UUID_PRIMARY_PHYSICAL = "primary_physical";
    public static int DEBUG_FORCE_ADOPTABLE = 1;
    public static int DEBUG_EMULATE_FBE = 2;
    public static int DEBUG_SDCARDFS_FORCE_ON = 4;
    public static int DEBUG_SDCARDFS_FORCE_OFF = 8;
    public static int FLAG_STORAGE_DE = 1;
    public static int FLAG_STORAGE_CE = 2;
    public static int FLAG_FOR_WRITE = 256;
    public static int FLAG_REAL_STATE = 512;
    public static int FLAG_INCLUDE_INVISIBLE = 1024;
    private static volatile IMountService sMountService;
    private Context mContext;
    private ContentResolver mResolver;
    private IMountService mMountService;
    private Looper mLooper;
    private AtomicInteger mNextNonce;
    private ArrayList<StorageEventListenerDelegate> mDelegates;
    private ObbActionListener mObbActionListener;
    private static int DEFAULT_THRESHOLD_PERCENTAGE = 10;
    private static long DEFAULT_THRESHOLD_MAX_BYTES = 524288000L;
    private static long DEFAULT_FULL_THRESHOLD_BYTES = 0x100000L;
    public static int CRYPT_TYPE_PASSWORD = 0;
    public static int CRYPT_TYPE_DEFAULT = 1;
    public static int CRYPT_TYPE_PATTERN = 2;
    public static int CRYPT_TYPE_PIN = 3;
    public static String SYSTEM_LOCALE_KEY = "SystemLocale";
    public static String OWNER_INFO_KEY = "OwnerInfo";
    public static String PATTERN_VISIBLE_KEY = "PatternVisible";
    public static String PASSWORD_VISIBLE_KEY = "PasswordVisible";

    private final int $$robo$$android_os_storage_StorageManager$getNextNonce() {
        return this.mNextNonce.getAndIncrement();
    }

    @Deprecated
    private static final StorageManager $$robo$$android_os_storage_StorageManager$from(Context context) {
        return context.getSystemService(StorageManager.class);
    }

    private void $$robo$$android_os_storage_StorageManager$__constructor__(Context context, Looper looper) {
        this.mNextNonce = new AtomicInteger(0);
        this.mDelegates = new ArrayList();
        this.mObbActionListener = new ObbActionListener(this);
        this.mContext = context;
        this.mResolver = context.getContentResolver();
        this.mLooper = looper;
        this.mMountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
        if (this.mMountService == null) {
            throw new IllegalStateException("Failed to find running mount service");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_storage_StorageManager$registerListener(StorageEventListener listener) {
        ArrayList<StorageEventListenerDelegate> arrayList = this.mDelegates;
        synchronized (arrayList) {
            StorageEventListenerDelegate delegate = new StorageEventListenerDelegate(listener, this.mLooper);
            try {
                this.mMountService.registerListener(delegate);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mDelegates.add(delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_storage_StorageManager$unregisterListener(StorageEventListener listener) {
        ArrayList<StorageEventListenerDelegate> arrayList = this.mDelegates;
        synchronized (arrayList) {
            Iterator<StorageEventListenerDelegate> i = this.mDelegates.iterator();
            while (i.hasNext()) {
                StorageEventListenerDelegate delegate = i.next();
                if (delegate.mCallback != listener) continue;
                try {
                    this.mMountService.unregisterListener(delegate);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                i.remove();
            }
        }
    }

    @Deprecated
    private final void $$robo$$android_os_storage_StorageManager$enableUsbMassStorage() {
    }

    @Deprecated
    private final void $$robo$$android_os_storage_StorageManager$disableUsbMassStorage() {
    }

    @Deprecated
    private final boolean $$robo$$android_os_storage_StorageManager$isUsbMassStorageConnected() {
        return false;
    }

    @Deprecated
    private final boolean $$robo$$android_os_storage_StorageManager$isUsbMassStorageEnabled() {
        return false;
    }

    private final boolean $$robo$$android_os_storage_StorageManager$mountObb(String rawPath, String key, OnObbStateChangeListener listener) {
        Preconditions.checkNotNull(rawPath, "rawPath cannot be null");
        Preconditions.checkNotNull(listener, "listener cannot be null");
        try {
            String canonicalPath = new File(rawPath).getCanonicalPath();
            int nonce = this.mObbActionListener.addListener(listener);
            this.mMountService.mountObb(rawPath, canonicalPath, key, this.mObbActionListener, nonce);
            return true;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to resolve path: " + rawPath, e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_storage_StorageManager$unmountObb(String rawPath, boolean force, OnObbStateChangeListener listener) {
        Preconditions.checkNotNull(rawPath, "rawPath cannot be null");
        Preconditions.checkNotNull(listener, "listener cannot be null");
        try {
            int nonce = this.mObbActionListener.addListener(listener);
            this.mMountService.unmountObb(rawPath, force, this.mObbActionListener, nonce);
            return true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_storage_StorageManager$isObbMounted(String rawPath) {
        Preconditions.checkNotNull(rawPath, "rawPath cannot be null");
        try {
            return this.mMountService.isObbMounted(rawPath);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_os_storage_StorageManager$getMountedObbPath(String rawPath) {
        Preconditions.checkNotNull(rawPath, "rawPath cannot be null");
        try {
            return this.mMountService.getMountedObbPath(rawPath);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<DiskInfo> $$robo$$android_os_storage_StorageManager$getDisks() {
        try {
            return Arrays.asList(this.mMountService.getDisks());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final DiskInfo $$robo$$android_os_storage_StorageManager$findDiskById(String id2) {
        Preconditions.checkNotNull(id2);
        for (DiskInfo disk : this.getDisks()) {
            if (!Objects.equals(disk.id, id2)) continue;
            return disk;
        }
        return null;
    }

    private final VolumeInfo $$robo$$android_os_storage_StorageManager$findVolumeById(String id2) {
        Preconditions.checkNotNull(id2);
        for (VolumeInfo vol : this.getVolumes()) {
            if (!Objects.equals(vol.id, id2)) continue;
            return vol;
        }
        return null;
    }

    private final VolumeInfo $$robo$$android_os_storage_StorageManager$findVolumeByUuid(String fsUuid) {
        Preconditions.checkNotNull(fsUuid);
        for (VolumeInfo vol : this.getVolumes()) {
            if (!Objects.equals(vol.fsUuid, fsUuid)) continue;
            return vol;
        }
        return null;
    }

    private final VolumeRecord $$robo$$android_os_storage_StorageManager$findRecordByUuid(String fsUuid) {
        Preconditions.checkNotNull(fsUuid);
        for (VolumeRecord rec : this.getVolumeRecords()) {
            if (!Objects.equals(rec.fsUuid, fsUuid)) continue;
            return rec;
        }
        return null;
    }

    private final VolumeInfo $$robo$$android_os_storage_StorageManager$findPrivateForEmulated(VolumeInfo emulatedVol) {
        if (emulatedVol != null) {
            return this.findVolumeById(emulatedVol.getId().replace("emulated", "private"));
        }
        return null;
    }

    private final VolumeInfo $$robo$$android_os_storage_StorageManager$findEmulatedForPrivate(VolumeInfo privateVol) {
        if (privateVol != null) {
            return this.findVolumeById(privateVol.getId().replace("private", "emulated"));
        }
        return null;
    }

    private final VolumeInfo $$robo$$android_os_storage_StorageManager$findVolumeByQualifiedUuid(String volumeUuid) {
        if (Objects.equals(UUID_PRIVATE_INTERNAL, volumeUuid)) {
            return this.findVolumeById("private");
        }
        if (Objects.equals("primary_physical", volumeUuid)) {
            return this.getPrimaryPhysicalVolume();
        }
        return this.findVolumeByUuid(volumeUuid);
    }

    private final List<VolumeInfo> $$robo$$android_os_storage_StorageManager$getVolumes() {
        try {
            return Arrays.asList(this.mMountService.getVolumes(0));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<VolumeInfo> $$robo$$android_os_storage_StorageManager$getWritablePrivateVolumes() {
        try {
            ArrayList<VolumeInfo> res = new ArrayList<VolumeInfo>();
            for (VolumeInfo vol : this.mMountService.getVolumes(0)) {
                if (vol.getType() != 1 || !vol.isMountedWritable()) continue;
                res.add(vol);
            }
            return res;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<VolumeRecord> $$robo$$android_os_storage_StorageManager$getVolumeRecords() {
        try {
            return Arrays.asList(this.mMountService.getVolumeRecords(0));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_os_storage_StorageManager$getBestVolumeDescription(VolumeInfo vol) {
        VolumeRecord rec;
        if (vol == null) {
            return null;
        }
        if (!TextUtils.isEmpty(vol.fsUuid) && (rec = this.findRecordByUuid(vol.fsUuid)) != null && !TextUtils.isEmpty(rec.nickname)) {
            return rec.nickname;
        }
        if (!TextUtils.isEmpty(vol.getDescription())) {
            return vol.getDescription();
        }
        if (vol.disk != null) {
            return vol.disk.getDescription();
        }
        return null;
    }

    private final VolumeInfo $$robo$$android_os_storage_StorageManager$getPrimaryPhysicalVolume() {
        List<VolumeInfo> vols = this.getVolumes();
        for (VolumeInfo vol : vols) {
            if (!vol.isPrimaryPhysical()) continue;
            return vol;
        }
        return null;
    }

    private final void $$robo$$android_os_storage_StorageManager$mount(String volId) {
        try {
            this.mMountService.mount(volId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_storage_StorageManager$unmount(String volId) {
        try {
            this.mMountService.unmount(volId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_storage_StorageManager$format(String volId) {
        try {
            this.mMountService.format(volId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final long $$robo$$android_os_storage_StorageManager$benchmark(String volId) {
        try {
            return this.mMountService.benchmark(volId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_storage_StorageManager$partitionPublic(String diskId) {
        try {
            this.mMountService.partitionPublic(diskId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_storage_StorageManager$partitionPrivate(String diskId) {
        try {
            this.mMountService.partitionPrivate(diskId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_storage_StorageManager$partitionMixed(String diskId, int ratio) {
        try {
            this.mMountService.partitionMixed(diskId, ratio);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_storage_StorageManager$wipeAdoptableDisks() {
        List<DiskInfo> disks = this.getDisks();
        for (DiskInfo disk : disks) {
            String diskId = disk.getId();
            if (disk.isAdoptable()) {
                Slog.d("StorageManager", "Found adoptable " + diskId + "; wiping");
                try {
                    this.mMountService.partitionPublic(diskId);
                }
                catch (Exception e) {
                    Slog.w("StorageManager", "Failed to wipe " + diskId + ", but soldiering onward", e);
                }
                continue;
            }
            Slog.d("StorageManager", "Ignorning non-adoptable disk " + disk.getId());
        }
    }

    private final void $$robo$$android_os_storage_StorageManager$setVolumeNickname(String fsUuid, String nickname) {
        try {
            this.mMountService.setVolumeNickname(fsUuid, nickname);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_storage_StorageManager$setVolumeInited(String fsUuid, boolean inited) {
        try {
            this.mMountService.setVolumeUserFlags(fsUuid, inited ? 1 : 0, 1);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_storage_StorageManager$setVolumeSnoozed(String fsUuid, boolean snoozed) {
        try {
            this.mMountService.setVolumeUserFlags(fsUuid, snoozed ? 2 : 0, 2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_storage_StorageManager$forgetVolume(String fsUuid) {
        try {
            this.mMountService.forgetVolume(fsUuid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_os_storage_StorageManager$getPrimaryStorageUuid() {
        try {
            return this.mMountService.getPrimaryStorageUuid();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_storage_StorageManager$setPrimaryStorageUuid(String volumeUuid, IPackageMoveObserver callback) {
        try {
            this.mMountService.setPrimaryStorageUuid(volumeUuid, callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final StorageVolume $$robo$$android_os_storage_StorageManager$getStorageVolume(File file) {
        return StorageManager.getStorageVolume(this.getVolumeList(), file);
    }

    private static final StorageVolume $$robo$$android_os_storage_StorageManager$getStorageVolume(File file, int userId) {
        return StorageManager.getStorageVolume(StorageManager.getVolumeList(userId, 0), file);
    }

    private static final StorageVolume $$robo$$android_os_storage_StorageManager$getStorageVolume(StorageVolume[] volumes, File file) {
        if (file == null) {
            return null;
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException ignored) {
            Slog.d("StorageManager", "Could not get canonical path for " + file);
            return null;
        }
        for (StorageVolume volume : volumes) {
            File volumeFile = volume.getPathFile();
            try {
                volumeFile = volumeFile.getCanonicalFile();
            }
            catch (IOException ignored) {
                continue;
            }
            if (!FileUtils.contains(volumeFile, file)) continue;
            return volume;
        }
        return null;
    }

    @Deprecated
    private final String $$robo$$android_os_storage_StorageManager$getVolumeState(String mountPoint) {
        StorageVolume vol = this.getStorageVolume(new File(mountPoint));
        if (vol != null) {
            return vol.getState();
        }
        return "unknown";
    }

    private final List<StorageVolume> $$robo$$android_os_storage_StorageManager$getStorageVolumes() {
        ArrayList<StorageVolume> res = new ArrayList<StorageVolume>();
        Collections.addAll(res, StorageManager.getVolumeList(UserHandle.myUserId(), 1536));
        return res;
    }

    private final StorageVolume $$robo$$android_os_storage_StorageManager$getPrimaryStorageVolume() {
        return StorageManager.getVolumeList(UserHandle.myUserId(), 1536)[0];
    }

    private final StorageVolume[] $$robo$$android_os_storage_StorageManager$getVolumeList() {
        return StorageManager.getVolumeList(this.mContext.getUserId(), 0);
    }

    private static final StorageVolume[] $$robo$$android_os_storage_StorageManager$getVolumeList(int userId, int flags) {
        IMountService mountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
        try {
            int uid;
            String packageName = ActivityThread.currentOpPackageName();
            if (packageName == null) {
                String[] packageNames = ActivityThread.getPackageManager().getPackagesForUid(Process.myUid());
                if (packageNames == null || packageNames.length <= 0) {
                    return new StorageVolume[0];
                }
                packageName = packageNames[0];
            }
            if ((uid = ActivityThread.getPackageManager().getPackageUid(packageName, 0x10000000, userId)) <= 0) {
                return new StorageVolume[0];
            }
            return mountService.getVolumeList(uid, packageName, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final String[] $$robo$$android_os_storage_StorageManager$getVolumePaths() {
        StorageVolume[] volumes = this.getVolumeList();
        int count = volumes.length;
        String[] paths = new String[count];
        for (int i = 0; i < count; ++i) {
            paths[i] = volumes[i].getPath();
        }
        return paths;
    }

    private final StorageVolume $$robo$$android_os_storage_StorageManager$getPrimaryVolume() {
        return StorageManager.getPrimaryVolume(this.getVolumeList());
    }

    private static final StorageVolume $$robo$$android_os_storage_StorageManager$getPrimaryVolume(StorageVolume[] volumes) {
        for (StorageVolume volume : volumes) {
            if (!volume.isPrimary()) continue;
            return volume;
        }
        throw new IllegalStateException("Missing primary storage");
    }

    private final long $$robo$$android_os_storage_StorageManager$getStorageBytesUntilLow(File path) {
        return path.getUsableSpace() - this.getStorageFullBytes(path);
    }

    private final long $$robo$$android_os_storage_StorageManager$getStorageLowBytes(File path) {
        long lowPercent = Settings.Global.getInt(this.mResolver, "sys_storage_threshold_percentage", 10);
        long lowBytes = path.getTotalSpace() * lowPercent / 100L;
        long maxLowBytes = Settings.Global.getLong(this.mResolver, "sys_storage_threshold_max_bytes", 524288000L);
        return Math.min(lowBytes, maxLowBytes);
    }

    private final long $$robo$$android_os_storage_StorageManager$getStorageFullBytes(File path) {
        return Settings.Global.getLong(this.mResolver, "sys_storage_full_threshold_bytes", 0x100000L);
    }

    private final void $$robo$$android_os_storage_StorageManager$createUserKey(int userId, int serialNumber, boolean ephemeral) {
        try {
            this.mMountService.createUserKey(userId, serialNumber, ephemeral);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_storage_StorageManager$destroyUserKey(int userId) {
        try {
            this.mMountService.destroyUserKey(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_storage_StorageManager$unlockUserKey(int userId, int serialNumber, byte[] token, byte[] secret) {
        try {
            this.mMountService.unlockUserKey(userId, serialNumber, token, secret);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_storage_StorageManager$lockUserKey(int userId) {
        try {
            this.mMountService.lockUserKey(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_storage_StorageManager$prepareUserStorage(String volumeUuid, int userId, int serialNumber, int flags) {
        try {
            this.mMountService.prepareUserStorage(volumeUuid, userId, serialNumber, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_storage_StorageManager$destroyUserStorage(String volumeUuid, int userId, int flags) {
        try {
            this.mMountService.destroyUserStorage(volumeUuid, userId, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final boolean $$robo$$android_os_storage_StorageManager$isUserKeyUnlocked(int userId) {
        if (sMountService == null) {
            sMountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
        }
        if (sMountService == null) {
            Slog.w("StorageManager", "Early during boot, assuming locked");
            return false;
        }
        long token = Binder.clearCallingIdentity();
        try {
            boolean bl = sMountService.isUserKeyUnlocked(userId);
            return bl;
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private final boolean $$robo$$android_os_storage_StorageManager$isEncrypted(File file) {
        if (FileUtils.contains(Environment.getDataDirectory(), file)) {
            return StorageManager.isEncrypted();
        }
        return FileUtils.contains(Environment.getExpandDirectory(), file);
    }

    private static final boolean $$robo$$android_os_storage_StorageManager$isEncryptable() {
        String state = SystemProperties.get("ro.crypto.state", "unsupported");
        return !"unsupported".equalsIgnoreCase(state);
    }

    private static final boolean $$robo$$android_os_storage_StorageManager$isEncrypted() {
        String state = SystemProperties.get("ro.crypto.state", "");
        return "encrypted".equalsIgnoreCase(state);
    }

    private static final boolean $$robo$$android_os_storage_StorageManager$isFileEncryptedNativeOnly() {
        if (!StorageManager.isEncrypted()) {
            return false;
        }
        String status = SystemProperties.get("ro.crypto.type", "");
        return "file".equalsIgnoreCase(status);
    }

    private static final boolean $$robo$$android_os_storage_StorageManager$isBlockEncrypted() {
        if (!StorageManager.isEncrypted()) {
            return false;
        }
        String status = SystemProperties.get("ro.crypto.type", "");
        return "block".equalsIgnoreCase(status);
    }

    private static final boolean $$robo$$android_os_storage_StorageManager$isNonDefaultBlockEncrypted() {
        if (!StorageManager.isBlockEncrypted()) {
            return false;
        }
        try {
            IMountService mountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
            return mountService.getPasswordType() != 1;
        }
        catch (RemoteException e) {
            Log.e("StorageManager", "Error getting encryption type");
            return false;
        }
    }

    private static final boolean $$robo$$android_os_storage_StorageManager$isBlockEncrypting() {
        String state = SystemProperties.get("vold.encrypt_progress", "");
        return !"".equalsIgnoreCase(state);
    }

    private static final boolean $$robo$$android_os_storage_StorageManager$inCryptKeeperBounce() {
        String status = SystemProperties.get("vold.decrypt");
        return "trigger_restart_min_framework".equals(status);
    }

    private static final boolean $$robo$$android_os_storage_StorageManager$isFileEncryptedEmulatedOnly() {
        return SystemProperties.getBoolean("persist.sys.emulate_fbe", false);
    }

    private static final boolean $$robo$$android_os_storage_StorageManager$isFileEncryptedNativeOrEmulated() {
        return StorageManager.isFileEncryptedNativeOnly() || StorageManager.isFileEncryptedEmulatedOnly();
    }

    private static final File $$robo$$android_os_storage_StorageManager$maybeTranslateEmulatedPathToInternal(File path) {
        IMountService mountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
        try {
            VolumeInfo[] vols;
            for (VolumeInfo vol : vols = mountService.getVolumes(0)) {
                File internalPath;
                if (vol.getType() != 2 && vol.getType() != 0 || !vol.isMountedReadable() || (internalPath = FileUtils.rewriteAfterRename(vol.getPath(), vol.getInternalPath(), path)) == null || !internalPath.exists()) continue;
                return internalPath;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return path;
    }

    private final ParcelFileDescriptor $$robo$$android_os_storage_StorageManager$mountAppFuse(String name) {
        try {
            return this.mMountService.mountAppFuse(name);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void __staticInitializer__() {
        UUID_PRIVATE_INTERNAL = null;
        sMountService = null;
    }

    private int getNextNonce() {
        return (int)InvokeDynamicSupport.bootstrap("getNextNonce", $$robo$$android_os_storage_StorageManager$getNextNonce(), 0, this);
    }

    @Deprecated
    public static StorageManager from(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_os_storage_StorageManager$from(android.content.Context ), 0, (Context)context);
    }

    private void __constructor__(Context context, Looper looper) {
        this.$$robo$$android_os_storage_StorageManager$__constructor__(context, looper);
    }

    public StorageManager(Context context, Looper looper) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageManager$__constructor__(android.content.Context android.os.Looper ), 0, this, context, looper);
    }

    public void registerListener(StorageEventListener storageEventListener) {
        InvokeDynamicSupport.bootstrap("registerListener", $$robo$$android_os_storage_StorageManager$registerListener(android.os.storage.StorageEventListener ), 0, this, storageEventListener);
    }

    public void unregisterListener(StorageEventListener storageEventListener) {
        InvokeDynamicSupport.bootstrap("unregisterListener", $$robo$$android_os_storage_StorageManager$unregisterListener(android.os.storage.StorageEventListener ), 0, this, storageEventListener);
    }

    @Deprecated
    public void enableUsbMassStorage() {
        InvokeDynamicSupport.bootstrap("enableUsbMassStorage", $$robo$$android_os_storage_StorageManager$enableUsbMassStorage(), 0, this);
    }

    @Deprecated
    public void disableUsbMassStorage() {
        InvokeDynamicSupport.bootstrap("disableUsbMassStorage", $$robo$$android_os_storage_StorageManager$disableUsbMassStorage(), 0, this);
    }

    @Deprecated
    public boolean isUsbMassStorageConnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUsbMassStorageConnected", $$robo$$android_os_storage_StorageManager$isUsbMassStorageConnected(), 0, this);
    }

    @Deprecated
    public boolean isUsbMassStorageEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUsbMassStorageEnabled", $$robo$$android_os_storage_StorageManager$isUsbMassStorageEnabled(), 0, this);
    }

    public boolean mountObb(String string2, String string3, OnObbStateChangeListener onObbStateChangeListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("mountObb", $$robo$$android_os_storage_StorageManager$mountObb(java.lang.String java.lang.String android.os.storage.OnObbStateChangeListener ), 0, this, string2, string3, onObbStateChangeListener);
    }

    public boolean unmountObb(String string2, boolean bl, OnObbStateChangeListener onObbStateChangeListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("unmountObb", $$robo$$android_os_storage_StorageManager$unmountObb(java.lang.String boolean android.os.storage.OnObbStateChangeListener ), 0, this, string2, bl, onObbStateChangeListener);
    }

    public boolean isObbMounted(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isObbMounted", $$robo$$android_os_storage_StorageManager$isObbMounted(java.lang.String ), 0, this, string2);
    }

    public String getMountedObbPath(String string2) {
        return InvokeDynamicSupport.bootstrap("getMountedObbPath", $$robo$$android_os_storage_StorageManager$getMountedObbPath(java.lang.String ), 0, this, string2);
    }

    public List<DiskInfo> getDisks() {
        return InvokeDynamicSupport.bootstrap("getDisks", $$robo$$android_os_storage_StorageManager$getDisks(), 0, this);
    }

    public DiskInfo findDiskById(String string2) {
        return InvokeDynamicSupport.bootstrap("findDiskById", $$robo$$android_os_storage_StorageManager$findDiskById(java.lang.String ), 0, this, string2);
    }

    public VolumeInfo findVolumeById(String string2) {
        return InvokeDynamicSupport.bootstrap("findVolumeById", $$robo$$android_os_storage_StorageManager$findVolumeById(java.lang.String ), 0, this, string2);
    }

    public VolumeInfo findVolumeByUuid(String string2) {
        return InvokeDynamicSupport.bootstrap("findVolumeByUuid", $$robo$$android_os_storage_StorageManager$findVolumeByUuid(java.lang.String ), 0, this, string2);
    }

    public VolumeRecord findRecordByUuid(String string2) {
        return InvokeDynamicSupport.bootstrap("findRecordByUuid", $$robo$$android_os_storage_StorageManager$findRecordByUuid(java.lang.String ), 0, this, string2);
    }

    public VolumeInfo findPrivateForEmulated(VolumeInfo volumeInfo) {
        return InvokeDynamicSupport.bootstrap("findPrivateForEmulated", $$robo$$android_os_storage_StorageManager$findPrivateForEmulated(android.os.storage.VolumeInfo ), 0, this, volumeInfo);
    }

    public VolumeInfo findEmulatedForPrivate(VolumeInfo volumeInfo) {
        return InvokeDynamicSupport.bootstrap("findEmulatedForPrivate", $$robo$$android_os_storage_StorageManager$findEmulatedForPrivate(android.os.storage.VolumeInfo ), 0, this, volumeInfo);
    }

    public VolumeInfo findVolumeByQualifiedUuid(String string2) {
        return InvokeDynamicSupport.bootstrap("findVolumeByQualifiedUuid", $$robo$$android_os_storage_StorageManager$findVolumeByQualifiedUuid(java.lang.String ), 0, this, string2);
    }

    public List<VolumeInfo> getVolumes() {
        return InvokeDynamicSupport.bootstrap("getVolumes", $$robo$$android_os_storage_StorageManager$getVolumes(), 0, this);
    }

    public List<VolumeInfo> getWritablePrivateVolumes() {
        return InvokeDynamicSupport.bootstrap("getWritablePrivateVolumes", $$robo$$android_os_storage_StorageManager$getWritablePrivateVolumes(), 0, this);
    }

    public List<VolumeRecord> getVolumeRecords() {
        return InvokeDynamicSupport.bootstrap("getVolumeRecords", $$robo$$android_os_storage_StorageManager$getVolumeRecords(), 0, this);
    }

    public String getBestVolumeDescription(VolumeInfo volumeInfo) {
        return InvokeDynamicSupport.bootstrap("getBestVolumeDescription", $$robo$$android_os_storage_StorageManager$getBestVolumeDescription(android.os.storage.VolumeInfo ), 0, this, volumeInfo);
    }

    public VolumeInfo getPrimaryPhysicalVolume() {
        return InvokeDynamicSupport.bootstrap("getPrimaryPhysicalVolume", $$robo$$android_os_storage_StorageManager$getPrimaryPhysicalVolume(), 0, this);
    }

    public void mount(String string2) {
        InvokeDynamicSupport.bootstrap("mount", $$robo$$android_os_storage_StorageManager$mount(java.lang.String ), 0, this, string2);
    }

    public void unmount(String string2) {
        InvokeDynamicSupport.bootstrap("unmount", $$robo$$android_os_storage_StorageManager$unmount(java.lang.String ), 0, this, string2);
    }

    public void format(String string2) {
        InvokeDynamicSupport.bootstrap("format", $$robo$$android_os_storage_StorageManager$format(java.lang.String ), 0, this, string2);
    }

    public long benchmark(String string2) {
        return (long)InvokeDynamicSupport.bootstrap("benchmark", $$robo$$android_os_storage_StorageManager$benchmark(java.lang.String ), 0, this, string2);
    }

    public void partitionPublic(String string2) {
        InvokeDynamicSupport.bootstrap("partitionPublic", $$robo$$android_os_storage_StorageManager$partitionPublic(java.lang.String ), 0, this, string2);
    }

    public void partitionPrivate(String string2) {
        InvokeDynamicSupport.bootstrap("partitionPrivate", $$robo$$android_os_storage_StorageManager$partitionPrivate(java.lang.String ), 0, this, string2);
    }

    public void partitionMixed(String string2, int n) {
        InvokeDynamicSupport.bootstrap("partitionMixed", $$robo$$android_os_storage_StorageManager$partitionMixed(java.lang.String int ), 0, this, string2, n);
    }

    public void wipeAdoptableDisks() {
        InvokeDynamicSupport.bootstrap("wipeAdoptableDisks", $$robo$$android_os_storage_StorageManager$wipeAdoptableDisks(), 0, this);
    }

    public void setVolumeNickname(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setVolumeNickname", $$robo$$android_os_storage_StorageManager$setVolumeNickname(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void setVolumeInited(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setVolumeInited", $$robo$$android_os_storage_StorageManager$setVolumeInited(java.lang.String boolean ), 0, this, string2, bl);
    }

    public void setVolumeSnoozed(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setVolumeSnoozed", $$robo$$android_os_storage_StorageManager$setVolumeSnoozed(java.lang.String boolean ), 0, this, string2, bl);
    }

    public void forgetVolume(String string2) {
        InvokeDynamicSupport.bootstrap("forgetVolume", $$robo$$android_os_storage_StorageManager$forgetVolume(java.lang.String ), 0, this, string2);
    }

    public String getPrimaryStorageUuid() {
        return InvokeDynamicSupport.bootstrap("getPrimaryStorageUuid", $$robo$$android_os_storage_StorageManager$getPrimaryStorageUuid(), 0, this);
    }

    public void setPrimaryStorageUuid(String string2, IPackageMoveObserver iPackageMoveObserver) {
        InvokeDynamicSupport.bootstrap("setPrimaryStorageUuid", $$robo$$android_os_storage_StorageManager$setPrimaryStorageUuid(java.lang.String android.content.pm.IPackageMoveObserver ), 0, this, string2, iPackageMoveObserver);
    }

    public StorageVolume getStorageVolume(File file) {
        return InvokeDynamicSupport.bootstrap("getStorageVolume", $$robo$$android_os_storage_StorageManager$getStorageVolume(java.io.File ), 0, this, file);
    }

    public static StorageVolume getStorageVolume(File file, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getStorageVolume", $$robo$$android_os_storage_StorageManager$getStorageVolume(java.io.File int ), 0, (File)file, (int)n);
    }

    private static StorageVolume getStorageVolume(StorageVolume[] storageVolumeArray, File file) {
        return InvokeDynamicSupport.bootstrapStatic("getStorageVolume", $$robo$$android_os_storage_StorageManager$getStorageVolume(android.os.storage.StorageVolume[] java.io.File ), 0, (StorageVolume[])storageVolumeArray, (File)file);
    }

    @Deprecated
    public String getVolumeState(String string2) {
        return InvokeDynamicSupport.bootstrap("getVolumeState", $$robo$$android_os_storage_StorageManager$getVolumeState(java.lang.String ), 0, this, string2);
    }

    public List<StorageVolume> getStorageVolumes() {
        return InvokeDynamicSupport.bootstrap("getStorageVolumes", $$robo$$android_os_storage_StorageManager$getStorageVolumes(), 0, this);
    }

    public StorageVolume getPrimaryStorageVolume() {
        return InvokeDynamicSupport.bootstrap("getPrimaryStorageVolume", $$robo$$android_os_storage_StorageManager$getPrimaryStorageVolume(), 0, this);
    }

    public StorageVolume[] getVolumeList() {
        return InvokeDynamicSupport.bootstrap("getVolumeList", $$robo$$android_os_storage_StorageManager$getVolumeList(), 0, this);
    }

    public static StorageVolume[] getVolumeList(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getVolumeList", $$robo$$android_os_storage_StorageManager$getVolumeList(int int ), 0, (int)n, (int)n2);
    }

    @Deprecated
    public String[] getVolumePaths() {
        return InvokeDynamicSupport.bootstrap("getVolumePaths", $$robo$$android_os_storage_StorageManager$getVolumePaths(), 0, this);
    }

    public StorageVolume getPrimaryVolume() {
        return InvokeDynamicSupport.bootstrap("getPrimaryVolume", $$robo$$android_os_storage_StorageManager$getPrimaryVolume(), 0, this);
    }

    public static StorageVolume getPrimaryVolume(StorageVolume[] storageVolumeArray) {
        return InvokeDynamicSupport.bootstrapStatic("getPrimaryVolume", $$robo$$android_os_storage_StorageManager$getPrimaryVolume(android.os.storage.StorageVolume[] ), 0, (StorageVolume[])storageVolumeArray);
    }

    public long getStorageBytesUntilLow(File file) {
        return (long)InvokeDynamicSupport.bootstrap("getStorageBytesUntilLow", $$robo$$android_os_storage_StorageManager$getStorageBytesUntilLow(java.io.File ), 0, this, file);
    }

    public long getStorageLowBytes(File file) {
        return (long)InvokeDynamicSupport.bootstrap("getStorageLowBytes", $$robo$$android_os_storage_StorageManager$getStorageLowBytes(java.io.File ), 0, this, file);
    }

    public long getStorageFullBytes(File file) {
        return (long)InvokeDynamicSupport.bootstrap("getStorageFullBytes", $$robo$$android_os_storage_StorageManager$getStorageFullBytes(java.io.File ), 0, this, file);
    }

    public void createUserKey(int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("createUserKey", $$robo$$android_os_storage_StorageManager$createUserKey(int int boolean ), 0, this, n, n2, bl);
    }

    public void destroyUserKey(int n) {
        InvokeDynamicSupport.bootstrap("destroyUserKey", $$robo$$android_os_storage_StorageManager$destroyUserKey(int ), 0, this, n);
    }

    public void unlockUserKey(int n, int n2, byte[] byArray, byte[] byArray2) {
        InvokeDynamicSupport.bootstrap("unlockUserKey", $$robo$$android_os_storage_StorageManager$unlockUserKey(int int byte[] byte[] ), 0, this, n, n2, byArray, byArray2);
    }

    public void lockUserKey(int n) {
        InvokeDynamicSupport.bootstrap("lockUserKey", $$robo$$android_os_storage_StorageManager$lockUserKey(int ), 0, this, n);
    }

    public void prepareUserStorage(String string2, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("prepareUserStorage", $$robo$$android_os_storage_StorageManager$prepareUserStorage(java.lang.String int int int ), 0, this, string2, n, n2, n3);
    }

    public void destroyUserStorage(String string2, int n, int n2) {
        InvokeDynamicSupport.bootstrap("destroyUserStorage", $$robo$$android_os_storage_StorageManager$destroyUserStorage(java.lang.String int int ), 0, this, string2, n, n2);
    }

    public static boolean isUserKeyUnlocked(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isUserKeyUnlocked", $$robo$$android_os_storage_StorageManager$isUserKeyUnlocked(int ), 0, (int)n);
    }

    public boolean isEncrypted(File file) {
        return (boolean)InvokeDynamicSupport.bootstrap("isEncrypted", $$robo$$android_os_storage_StorageManager$isEncrypted(java.io.File ), 0, this, file);
    }

    public static boolean isEncryptable() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEncryptable", $$robo$$android_os_storage_StorageManager$isEncryptable(), 0);
    }

    public static boolean isEncrypted() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEncrypted", $$robo$$android_os_storage_StorageManager$isEncrypted(), 0);
    }

    public static boolean isFileEncryptedNativeOnly() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isFileEncryptedNativeOnly", $$robo$$android_os_storage_StorageManager$isFileEncryptedNativeOnly(), 0);
    }

    public static boolean isBlockEncrypted() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isBlockEncrypted", $$robo$$android_os_storage_StorageManager$isBlockEncrypted(), 0);
    }

    public static boolean isNonDefaultBlockEncrypted() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNonDefaultBlockEncrypted", $$robo$$android_os_storage_StorageManager$isNonDefaultBlockEncrypted(), 0);
    }

    public static boolean isBlockEncrypting() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isBlockEncrypting", $$robo$$android_os_storage_StorageManager$isBlockEncrypting(), 0);
    }

    public static boolean inCryptKeeperBounce() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("inCryptKeeperBounce", $$robo$$android_os_storage_StorageManager$inCryptKeeperBounce(), 0);
    }

    public static boolean isFileEncryptedEmulatedOnly() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isFileEncryptedEmulatedOnly", $$robo$$android_os_storage_StorageManager$isFileEncryptedEmulatedOnly(), 0);
    }

    public static boolean isFileEncryptedNativeOrEmulated() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isFileEncryptedNativeOrEmulated", $$robo$$android_os_storage_StorageManager$isFileEncryptedNativeOrEmulated(), 0);
    }

    public static File maybeTranslateEmulatedPathToInternal(File file) {
        return InvokeDynamicSupport.bootstrapStatic("maybeTranslateEmulatedPathToInternal", $$robo$$android_os_storage_StorageManager$maybeTranslateEmulatedPathToInternal(java.io.File ), 0, (File)file);
    }

    public ParcelFileDescriptor mountAppFuse(String string2) {
        return InvokeDynamicSupport.bootstrap("mountAppFuse", $$robo$$android_os_storage_StorageManager$mountAppFuse(java.lang.String ), 0, this, string2);
    }

    static {
        RobolectricInternals.classInitializing(StorageManager.class);
    }

    public /* synthetic */ StorageManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StorageManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class ObbListenerDelegate
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<OnObbStateChangeListener> mObbEventListenerRef;
        private Handler mHandler;
        private int nonce;
        /* synthetic */ StorageManager this$0;

        private void $$robo$$android_os_storage_StorageManager_ObbListenerDelegate$__constructor__(StorageManager storageManager, OnObbStateChangeListener listener) {
            this.nonce = storageManager.getNextNonce();
            this.mObbEventListenerRef = new WeakReference<OnObbStateChangeListener>(listener);
            this.mHandler = new ShadowedObject(this, storageManager.mLooper, storageManager){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ StorageManager val$this$0;
                /* synthetic */ ObbListenerDelegate this$1;

                private void $$robo$$android_os_storage_StorageManager_ObbListenerDelegate_1$__constructor__(ObbListenerDelegate this$1, Looper looper, StorageManager storageManager) {
                }

                private final void $$robo$$android_os_storage_StorageManager_ObbListenerDelegate_1$handleMessage(Message msg) {
                    OnObbStateChangeListener changeListener = this.this$1.getListener();
                    if (changeListener == null) {
                        return;
                    }
                    changeListener.onObbStateChange((String)msg.obj, msg.arg1);
                }

                private void __constructor__(ObbListenerDelegate obbListenerDelegate, Looper looper, StorageManager storageManager) {
                    this.$$robo$$android_os_storage_StorageManager_ObbListenerDelegate_1$__constructor__(obbListenerDelegate, looper, storageManager);
                }
                {
                    this.this$1 = obbListenerDelegate;
                    this.val$this$0 = storageManager;
                    super(looper);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageManager_ObbListenerDelegate_1$__constructor__(android.os.storage.StorageManager$ObbListenerDelegate android.os.Looper android.os.storage.StorageManager ), 0, this, obbListenerDelegate, looper, storageManager);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_os_storage_StorageManager_ObbListenerDelegate_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private final OnObbStateChangeListener $$robo$$android_os_storage_StorageManager_ObbListenerDelegate$getListener() {
            if (this.mObbEventListenerRef == null) {
                return null;
            }
            return (OnObbStateChangeListener)this.mObbEventListenerRef.get();
        }

        private final void $$robo$$android_os_storage_StorageManager_ObbListenerDelegate$sendObbStateChanged(String path, int state) {
            this.mHandler.obtainMessage(0, state, 0, path).sendToTarget();
        }

        private void __constructor__(StorageManager storageManager, OnObbStateChangeListener onObbStateChangeListener) {
            this.$$robo$$android_os_storage_StorageManager_ObbListenerDelegate$__constructor__(storageManager, onObbStateChangeListener);
        }

        ObbListenerDelegate(StorageManager storageManager, OnObbStateChangeListener onObbStateChangeListener) {
            this.this$0 = storageManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageManager_ObbListenerDelegate$__constructor__(android.os.storage.StorageManager android.os.storage.OnObbStateChangeListener ), 0, this, storageManager, onObbStateChangeListener);
        }

        OnObbStateChangeListener getListener() {
            return InvokeDynamicSupport.bootstrap("getListener", $$robo$$android_os_storage_StorageManager_ObbListenerDelegate$getListener(), 0, this);
        }

        void sendObbStateChanged(String string2, int n) {
            InvokeDynamicSupport.bootstrap("sendObbStateChanged", $$robo$$android_os_storage_StorageManager_ObbListenerDelegate$sendObbStateChanged(java.lang.String int ), 0, this, string2, n);
        }

        public /* synthetic */ ObbListenerDelegate() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ObbListenerDelegate)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ObbActionListener
    extends IObbActionListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SparseArray<ObbListenerDelegate> mListeners;
        /* synthetic */ StorageManager this$0;

        private void $$robo$$android_os_storage_StorageManager_ObbActionListener$__constructor__(StorageManager storageManager) {
            this.mListeners = new SparseArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_storage_StorageManager_ObbActionListener$onObbResult(String filename, int nonce, int status) {
            ObbListenerDelegate delegate;
            SparseArray<ObbListenerDelegate> sparseArray = this.mListeners;
            synchronized (sparseArray) {
                delegate = this.mListeners.get(nonce);
                if (delegate != null) {
                    this.mListeners.remove(nonce);
                }
            }
            if (delegate != null) {
                delegate.sendObbStateChanged(filename, status);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_os_storage_StorageManager_ObbActionListener$addListener(OnObbStateChangeListener listener) {
            ObbListenerDelegate delegate = new ObbListenerDelegate(this.this$0, listener);
            SparseArray<ObbListenerDelegate> sparseArray = this.mListeners;
            synchronized (sparseArray) {
                this.mListeners.put(delegate.nonce, delegate);
            }
            return delegate.nonce;
        }

        private /* synthetic */ void $$robo$$android_os_storage_StorageManager_ObbActionListener$__constructor__(StorageManager x0, 1 x1) {
        }

        private void __constructor__(StorageManager storageManager) {
            this.$$robo$$android_os_storage_StorageManager_ObbActionListener$__constructor__(storageManager);
        }

        private ObbActionListener(StorageManager storageManager) {
            this.this$0 = storageManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageManager_ObbActionListener$__constructor__(android.os.storage.StorageManager ), 0, this, storageManager);
        }

        @Override
        public void onObbResult(String string2, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onObbResult", $$robo$$android_os_storage_StorageManager_ObbActionListener$onObbResult(java.lang.String int int ), 0, this, string2, n, n2);
        }

        public int addListener(OnObbStateChangeListener onObbStateChangeListener) {
            return (int)InvokeDynamicSupport.bootstrap("addListener", $$robo$$android_os_storage_StorageManager_ObbActionListener$addListener(android.os.storage.OnObbStateChangeListener ), 0, this, onObbStateChangeListener);
        }

        private /* synthetic */ void __constructor__(StorageManager storageManager, 1 var2_2) {
            this.$$robo$$android_os_storage_StorageManager_ObbActionListener$__constructor__(storageManager, var2_2);
        }

        public /* synthetic */ ObbActionListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ObbActionListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class StorageEventListenerDelegate
    extends IMountServiceListener.Stub
    implements Handler.Callback,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MSG_STORAGE_STATE_CHANGED = 1;
        private static int MSG_VOLUME_STATE_CHANGED = 2;
        private static int MSG_VOLUME_RECORD_CHANGED = 3;
        private static int MSG_VOLUME_FORGOTTEN = 4;
        private static int MSG_DISK_SCANNED = 5;
        private static int MSG_DISK_DESTROYED = 6;
        StorageEventListener mCallback;
        Handler mHandler;

        private void $$robo$$android_os_storage_StorageManager_StorageEventListenerDelegate$__constructor__(StorageEventListener callback, Looper looper) {
            this.mCallback = callback;
            this.mHandler = new Handler(looper, this);
        }

        private final boolean $$robo$$android_os_storage_StorageManager_StorageEventListenerDelegate$handleMessage(Message msg) {
            SomeArgs args = (SomeArgs)msg.obj;
            switch (msg.what) {
                case 1: {
                    this.mCallback.onStorageStateChanged((String)args.arg1, (String)args.arg2, (String)args.arg3);
                    args.recycle();
                    return true;
                }
                case 2: {
                    this.mCallback.onVolumeStateChanged((VolumeInfo)args.arg1, args.argi2, args.argi3);
                    args.recycle();
                    return true;
                }
                case 3: {
                    this.mCallback.onVolumeRecordChanged((VolumeRecord)args.arg1);
                    args.recycle();
                    return true;
                }
                case 4: {
                    this.mCallback.onVolumeForgotten((String)args.arg1);
                    args.recycle();
                    return true;
                }
                case 5: {
                    this.mCallback.onDiskScanned((DiskInfo)args.arg1, args.argi2);
                    args.recycle();
                    return true;
                }
                case 6: {
                    this.mCallback.onDiskDestroyed((DiskInfo)args.arg1);
                    args.recycle();
                    return true;
                }
            }
            args.recycle();
            return false;
        }

        private final void $$robo$$android_os_storage_StorageManager_StorageEventListenerDelegate$onUsbMassStorageConnectionChanged(boolean connected) throws RemoteException {
        }

        private final void $$robo$$android_os_storage_StorageManager_StorageEventListenerDelegate$onStorageStateChanged(String path, String oldState, String newState) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = path;
            args.arg2 = oldState;
            args.arg3 = newState;
            this.mHandler.obtainMessage(1, args).sendToTarget();
        }

        private final void $$robo$$android_os_storage_StorageManager_StorageEventListenerDelegate$onVolumeStateChanged(VolumeInfo vol, int oldState, int newState) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = vol;
            args.argi2 = oldState;
            args.argi3 = newState;
            this.mHandler.obtainMessage(2, args).sendToTarget();
        }

        private final void $$robo$$android_os_storage_StorageManager_StorageEventListenerDelegate$onVolumeRecordChanged(VolumeRecord rec) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = rec;
            this.mHandler.obtainMessage(3, args).sendToTarget();
        }

        private final void $$robo$$android_os_storage_StorageManager_StorageEventListenerDelegate$onVolumeForgotten(String fsUuid) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = fsUuid;
            this.mHandler.obtainMessage(4, args).sendToTarget();
        }

        private final void $$robo$$android_os_storage_StorageManager_StorageEventListenerDelegate$onDiskScanned(DiskInfo disk, int volumeCount) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = disk;
            args.argi2 = volumeCount;
            this.mHandler.obtainMessage(5, args).sendToTarget();
        }

        private final void $$robo$$android_os_storage_StorageManager_StorageEventListenerDelegate$onDiskDestroyed(DiskInfo disk) throws RemoteException {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = disk;
            this.mHandler.obtainMessage(6, args).sendToTarget();
        }

        private void __constructor__(StorageEventListener storageEventListener, Looper looper) {
            this.$$robo$$android_os_storage_StorageManager_StorageEventListenerDelegate$__constructor__(storageEventListener, looper);
        }

        public StorageEventListenerDelegate(StorageEventListener storageEventListener, Looper looper) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageManager_StorageEventListenerDelegate$__constructor__(android.os.storage.StorageEventListener android.os.Looper ), 0, this, storageEventListener, looper);
        }

        @Override
        public boolean handleMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_os_storage_StorageManager_StorageEventListenerDelegate$handleMessage(android.os.Message ), 0, this, message);
        }

        @Override
        public void onUsbMassStorageConnectionChanged(boolean bl) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onUsbMassStorageConnectionChanged", $$robo$$android_os_storage_StorageManager_StorageEventListenerDelegate$onUsbMassStorageConnectionChanged(boolean ), 0, this, bl);
        }

        @Override
        public void onStorageStateChanged(String string2, String string3, String string4) {
            InvokeDynamicSupport.bootstrap("onStorageStateChanged", $$robo$$android_os_storage_StorageManager_StorageEventListenerDelegate$onStorageStateChanged(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
        }

        @Override
        public void onVolumeStateChanged(VolumeInfo volumeInfo, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onVolumeStateChanged", $$robo$$android_os_storage_StorageManager_StorageEventListenerDelegate$onVolumeStateChanged(android.os.storage.VolumeInfo int int ), 0, this, volumeInfo, n, n2);
        }

        @Override
        public void onVolumeRecordChanged(VolumeRecord volumeRecord) {
            InvokeDynamicSupport.bootstrap("onVolumeRecordChanged", $$robo$$android_os_storage_StorageManager_StorageEventListenerDelegate$onVolumeRecordChanged(android.os.storage.VolumeRecord ), 0, this, volumeRecord);
        }

        @Override
        public void onVolumeForgotten(String string2) {
            InvokeDynamicSupport.bootstrap("onVolumeForgotten", $$robo$$android_os_storage_StorageManager_StorageEventListenerDelegate$onVolumeForgotten(java.lang.String ), 0, this, string2);
        }

        @Override
        public void onDiskScanned(DiskInfo diskInfo, int n) {
            InvokeDynamicSupport.bootstrap("onDiskScanned", $$robo$$android_os_storage_StorageManager_StorageEventListenerDelegate$onDiskScanned(android.os.storage.DiskInfo int ), 0, this, diskInfo, n);
        }

        @Override
        public void onDiskDestroyed(DiskInfo diskInfo) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onDiskDestroyed", $$robo$$android_os_storage_StorageManager_StorageEventListenerDelegate$onDiskDestroyed(android.os.storage.DiskInfo ), 0, this, diskInfo);
        }

        public /* synthetic */ StorageEventListenerDelegate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StorageEventListenerDelegate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

