/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.app.admin.DevicePolicyManager;
import android.content.ActivityNotFoundException;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.content.UriMatcher;
import android.net.Uri;
import android.os.Process;
import android.os.UserHandle;
import android.provider.ContactsContract;
import android.text.TextUtils;
import android.widget.Toast;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ContactsInternal
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static UriMatcher sContactsUriMatcher;
    private static int CONTACTS_URI_LOOKUP_ID = 1000;
    private static int CONTACTS_URI_LOOKUP = 1001;

    private void $$robo$$android_provider_ContactsInternal$__constructor__() {
    }

    private static final void $$robo$$android_provider_ContactsInternal$startQuickContactWithErrorToast(Context context, Intent intent) {
        Uri uri = intent.getData();
        int match = sContactsUriMatcher.match(uri);
        switch (match) {
            case 1000: 
            case 1001: {
                if (!ContactsInternal.maybeStartManagedQuickContact(context, intent)) break;
                return;
            }
        }
        ContactsInternal.startQuickContactWithErrorToastForUser(context, intent, Process.myUserHandle());
    }

    private static final void $$robo$$android_provider_ContactsInternal$startQuickContactWithErrorToastForUser(Context context, Intent intent, UserHandle user) {
        try {
            context.startActivityAsUser(intent, user);
        }
        catch (ActivityNotFoundException e) {
            Toast.makeText(context, 17039997, 0).show();
        }
    }

    private static final boolean $$robo$$android_provider_ContactsInternal$maybeStartManagedQuickContact(Context context, Intent originalIntent) {
        long directoryId;
        Uri uri = originalIntent.getData();
        List<String> pathSegments = uri.getPathSegments();
        boolean isContactIdIgnored = pathSegments.size() < 4;
        long contactId = isContactIdIgnored ? ContactsContract.Contacts.ENTERPRISE_CONTACT_ID_BASE : ContentUris.parseId(uri);
        String lookupKey = pathSegments.get(2);
        String directoryIdStr = uri.getQueryParameter("directory");
        long l = directoryId = directoryIdStr == null ? 1000000000L : Long.parseLong(directoryIdStr);
        if (TextUtils.isEmpty(lookupKey) || !lookupKey.startsWith(ContactsContract.Contacts.ENTERPRISE_CONTACT_LOOKUP_PREFIX)) {
            return false;
        }
        if (!ContactsContract.Contacts.isEnterpriseContactId(contactId)) {
            throw new IllegalArgumentException("Invalid enterprise contact id: " + contactId);
        }
        if (!ContactsContract.Directory.isEnterpriseDirectoryId(directoryId)) {
            throw new IllegalArgumentException("Invalid enterprise directory id: " + directoryId);
        }
        DevicePolicyManager dpm = context.getSystemService(DevicePolicyManager.class);
        String actualLookupKey = lookupKey.substring(ContactsContract.Contacts.ENTERPRISE_CONTACT_LOOKUP_PREFIX.length());
        long actualContactId = contactId - ContactsContract.Contacts.ENTERPRISE_CONTACT_ID_BASE;
        long actualDirectoryId = directoryId - 1000000000L;
        dpm.startManagedQuickContact(actualLookupKey, actualContactId, isContactIdIgnored, actualDirectoryId, originalIntent);
        return true;
    }

    static void __staticInitializer__() {
        UriMatcher matcher = sContactsUriMatcher = new UriMatcher(-1);
        matcher.addURI("com.android.contacts", "contacts/lookup/*", 1001);
        matcher.addURI("com.android.contacts", "contacts/lookup/*/#", 1000);
    }

    private void __constructor__() {
        this.$$robo$$android_provider_ContactsInternal$__constructor__();
    }

    private ContactsInternal() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_ContactsInternal$__constructor__(), 0, this);
    }

    public static void startQuickContactWithErrorToast(Context context, Intent intent) {
        InvokeDynamicSupport.bootstrapStatic("startQuickContactWithErrorToast", $$robo$$android_provider_ContactsInternal$startQuickContactWithErrorToast(android.content.Context android.content.Intent ), 0, (Context)context, (Intent)intent);
    }

    public static void startQuickContactWithErrorToastForUser(Context context, Intent intent, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrapStatic("startQuickContactWithErrorToastForUser", $$robo$$android_provider_ContactsInternal$startQuickContactWithErrorToastForUser(android.content.Context android.content.Intent android.os.UserHandle ), 0, (Context)context, (Intent)intent, (UserHandle)userHandle);
    }

    private static boolean maybeStartManagedQuickContact(Context context, Intent intent) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("maybeStartManagedQuickContact", $$robo$$android_provider_ContactsInternal$maybeStartManagedQuickContact(android.content.Context android.content.Intent ), 0, (Context)context, (Intent)intent);
    }

    static {
        RobolectricInternals.classInitializing(ContactsInternal.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ContactsInternal)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

