/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.security.Credentials;
import android.security.KeyStore;
import android.security.KeyStoreParameter;
import android.security.keymaster.KeyCharacteristics;
import android.security.keymaster.KeymasterArguments;
import android.security.keystore.AndroidKeyStoreKey;
import android.security.keystore.AndroidKeyStoreLoadStoreParameter;
import android.security.keystore.AndroidKeyStorePrivateKey;
import android.security.keystore.AndroidKeyStoreProvider;
import android.security.keystore.AndroidKeyStoreSecretKey;
import android.security.keystore.DelegatingX509Certificate;
import android.security.keystore.KeyProperties;
import android.security.keystore.KeyProtection;
import android.security.keystore.KeymasterUtils;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.crypto.SecretKey;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AndroidKeyStoreSpi
extends KeyStoreSpi
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String NAME = "AndroidKeyStore";
    private KeyStore mKeyStore;
    private int mUid;

    private void $$robo$$android_security_keystore_AndroidKeyStoreSpi$__constructor__() {
        this.mUid = -1;
    }

    private final Key $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (this.isPrivateKeyEntry(alias)) {
            String privateKeyAlias = "USRPKEY_" + alias;
            return AndroidKeyStoreProvider.loadAndroidKeyStorePrivateKeyFromKeystore(this.mKeyStore, privateKeyAlias, this.mUid);
        }
        if (this.isSecretKeyEntry(alias)) {
            String secretKeyAlias = "USRSKEY_" + alias;
            return AndroidKeyStoreProvider.loadAndroidKeyStoreSecretKeyFromKeystore(this.mKeyStore, secretKeyAlias, this.mUid);
        }
        return null;
    }

    private final Certificate[] $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineGetCertificateChain(String alias) {
        Certificate[] caList;
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        X509Certificate leaf = (X509Certificate)this.engineGetCertificate(alias);
        if (leaf == null) {
            return null;
        }
        byte[] caBytes = this.mKeyStore.get("CACERT_" + alias, this.mUid);
        if (caBytes != null) {
            Collection<X509Certificate> caChain = AndroidKeyStoreSpi.toCertificates(caBytes);
            caList = new Certificate[caChain.size() + 1];
            Iterator<X509Certificate> it = caChain.iterator();
            int i = 1;
            while (it.hasNext()) {
                caList[i++] = it.next();
            }
        } else {
            caList = new Certificate[]{leaf};
        }
        return caList;
    }

    private final Certificate $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineGetCertificate(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        byte[] encodedCert = this.mKeyStore.get("USRCERT_" + alias, this.mUid);
        if (encodedCert != null) {
            return this.getCertificateForPrivateKeyEntry(alias, encodedCert);
        }
        encodedCert = this.mKeyStore.get("CACERT_" + alias, this.mUid);
        if (encodedCert != null) {
            return this.getCertificateForTrustedCertificateEntry(encodedCert);
        }
        return null;
    }

    private final Certificate $$robo$$android_security_keystore_AndroidKeyStoreSpi$getCertificateForTrustedCertificateEntry(byte[] encodedCert) {
        return AndroidKeyStoreSpi.toCertificate(encodedCert);
    }

    private final Certificate $$robo$$android_security_keystore_AndroidKeyStoreSpi$getCertificateForPrivateKeyEntry(String alias, byte[] encodedCert) {
        X509Certificate cert = AndroidKeyStoreSpi.toCertificate(encodedCert);
        if (cert == null) {
            return null;
        }
        String privateKeyAlias = "USRPKEY_" + alias;
        if (this.mKeyStore.contains(privateKeyAlias, this.mUid)) {
            return AndroidKeyStoreSpi.wrapIntoKeyStoreCertificate(privateKeyAlias, this.mUid, cert);
        }
        return cert;
    }

    private static final KeyStoreX509Certificate $$robo$$android_security_keystore_AndroidKeyStoreSpi$wrapIntoKeyStoreCertificate(String privateKeyAlias, int uid, X509Certificate certificate) {
        return certificate != null ? new KeyStoreX509Certificate(privateKeyAlias, uid, certificate) : null;
    }

    private static final X509Certificate $$robo$$android_security_keystore_AndroidKeyStoreSpi$toCertificate(byte[] bytes) {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(bytes));
        }
        catch (CertificateException e) {
            Log.w("AndroidKeyStore", "Couldn't parse certificate in keystore", e);
            return null;
        }
    }

    private static final Collection<X509Certificate> $$robo$$android_security_keystore_AndroidKeyStoreSpi$toCertificates(byte[] bytes) {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            return certFactory.generateCertificates(new ByteArrayInputStream(bytes));
        }
        catch (CertificateException e) {
            Log.w("AndroidKeyStore", "Couldn't parse certificates in keystore", e);
            return new ArrayList<X509Certificate>();
        }
    }

    private final Date $$robo$$android_security_keystore_AndroidKeyStoreSpi$getModificationDate(String alias) {
        long epochMillis = this.mKeyStore.getmtime(alias, this.mUid);
        if (epochMillis == -1L) {
            return null;
        }
        return new Date(epochMillis);
    }

    private final Date $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineGetCreationDate(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        Date d = this.getModificationDate("USRPKEY_" + alias);
        if (d != null) {
            return d;
        }
        d = this.getModificationDate("USRSKEY_" + alias);
        if (d != null) {
            return d;
        }
        d = this.getModificationDate("USRCERT_" + alias);
        if (d != null) {
            return d;
        }
        return this.getModificationDate("CACERT_" + alias);
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (password != null && password.length > 0) {
            throw new KeyStoreException("entries cannot be protected with passwords");
        }
        if (key instanceof PrivateKey) {
            this.setPrivateKeyEntry(alias, (PrivateKey)key, chain, null);
        } else if (key instanceof SecretKey) {
            this.setSecretKeyEntry(alias, (SecretKey)key, null);
        } else {
            throw new KeyStoreException("Only PrivateKey and SecretKey are supported");
        }
    }

    private static final KeyProtection $$robo$$android_security_keystore_AndroidKeyStoreSpi$getLegacyKeyProtectionParameter(PrivateKey key) throws KeyStoreException {
        KeyProtection.Builder specBuilder;
        String keyAlgorithm = key.getAlgorithm();
        if ("EC".equalsIgnoreCase(keyAlgorithm)) {
            specBuilder = new KeyProtection.Builder(12);
            specBuilder.setDigests("NONE", "SHA-1", "SHA-224", "SHA-256", "SHA-384", "SHA-512");
        } else if ("RSA".equalsIgnoreCase(keyAlgorithm)) {
            specBuilder = new KeyProtection.Builder(15);
            specBuilder.setDigests("NONE", "MD5", "SHA-1", "SHA-224", "SHA-256", "SHA-384", "SHA-512");
            specBuilder.setEncryptionPaddings("NoPadding", "PKCS1Padding", "OAEPPadding");
            specBuilder.setSignaturePaddings("PKCS1", "PSS");
            specBuilder.setRandomizedEncryptionRequired(false);
        } else {
            throw new KeyStoreException("Unsupported key algorithm: " + keyAlgorithm);
        }
        specBuilder.setUserAuthenticationRequired(false);
        return specBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_security_keystore_AndroidKeyStoreSpi$setPrivateKeyEntry(String alias, PrivateKey key, Certificate[] chain, KeyStore.ProtectionParameter param) throws KeyStoreException {
        byte[] pkcs8EncodedPrivateKeyBytes;
        KeymasterArguments importArgs;
        boolean shouldReplacePrivateKey;
        String pkeyAlias;
        byte[] chainBytes;
        byte[] userCertBytes;
        KeyProtection spec;
        int flags = 0;
        if (param == null) {
            spec = AndroidKeyStoreSpi.getLegacyKeyProtectionParameter(key);
        } else if (param instanceof KeyStoreParameter) {
            spec = AndroidKeyStoreSpi.getLegacyKeyProtectionParameter(key);
            KeyStoreParameter legacySpec = (KeyStoreParameter)param;
            if (legacySpec.isEncryptionRequired()) {
                flags = 1;
            }
        } else if (param instanceof KeyProtection) {
            spec = (KeyProtection)param;
        } else {
            throw new KeyStoreException("Unsupported protection parameter class:" + param.getClass().getName() + ". Supported: " + KeyProtection.class.getName() + ", " + KeyStoreParameter.class.getName());
        }
        if (chain == null || chain.length == 0) {
            throw new KeyStoreException("Must supply at least one Certificate with PrivateKey");
        }
        X509Certificate[] x509chain = new X509Certificate[chain.length];
        for (int i = 0; i < chain.length; ++i) {
            if (!"X.509".equals(chain[i].getType())) {
                throw new KeyStoreException("Certificates must be in X.509 format: invalid cert #" + i);
            }
            if (!(chain[i] instanceof X509Certificate)) {
                throw new KeyStoreException("Certificates must be in X.509 format: invalid cert #" + i);
            }
            x509chain[i] = (X509Certificate)chain[i];
        }
        try {
            userCertBytes = x509chain[0].getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new KeyStoreException("Failed to encode certificate #0", e);
        }
        if (chain.length > 1) {
            byte[][] certsBytes = new byte[x509chain.length - 1][];
            int totalCertLength = 0;
            for (int i = 0; i < certsBytes.length; ++i) {
                try {
                    certsBytes[i] = x509chain[i + 1].getEncoded();
                    totalCertLength += certsBytes[i].length;
                    continue;
                }
                catch (CertificateEncodingException e) {
                    throw new KeyStoreException("Failed to encode certificate #" + i, e);
                }
            }
            chainBytes = new byte[totalCertLength];
            int outputOffset = 0;
            for (int i = 0; i < certsBytes.length; ++i) {
                int certLength = certsBytes[i].length;
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])certsBytes[i], (int)0, (byte[])chainBytes, (int)outputOffset, (int)certLength);
                outputOffset += certLength;
                certsBytes[i] = null;
            }
        } else {
            chainBytes = null;
        }
        if ((pkeyAlias = key instanceof AndroidKeyStorePrivateKey ? ((AndroidKeyStoreKey)((Object)key)).getAlias() : null) != null && pkeyAlias.startsWith("USRPKEY_")) {
            String keySubalias = pkeyAlias.substring("USRPKEY_".length());
            if (!alias.equals(keySubalias)) {
                throw new KeyStoreException("Can only replace keys with same alias: " + alias + " != " + keySubalias);
            }
            shouldReplacePrivateKey = false;
            importArgs = null;
            pkcs8EncodedPrivateKeyBytes = null;
        } else {
            shouldReplacePrivateKey = true;
            String keyFormat = key.getFormat();
            if (keyFormat == null || !"PKCS#8".equals(keyFormat)) {
                throw new KeyStoreException("Unsupported private key export format: " + keyFormat + ". Only private keys which export their key material in PKCS#8 format are supported.");
            }
            pkcs8EncodedPrivateKeyBytes = key.getEncoded();
            if (pkcs8EncodedPrivateKeyBytes == null) {
                throw new KeyStoreException("Private key did not export any key material");
            }
            importArgs = new KeymasterArguments();
            try {
                importArgs.addEnum(0x10000002, KeyProperties.KeyAlgorithm.toKeymasterAsymmetricKeyAlgorithm(key.getAlgorithm()));
                int purposes = spec.getPurposes();
                importArgs.addEnums(0x20000001, KeyProperties.Purpose.allToKeymaster(purposes));
                if (spec.isDigestsSpecified()) {
                    importArgs.addEnums(0x20000005, KeyProperties.Digest.allToKeymaster(spec.getDigests()));
                }
                importArgs.addEnums(0x20000004, KeyProperties.BlockMode.allToKeymaster(spec.getBlockModes()));
                int[] keymasterEncryptionPaddings = KeyProperties.EncryptionPadding.allToKeymaster(spec.getEncryptionPaddings());
                if ((purposes & 1) != 0 && spec.isRandomizedEncryptionRequired()) {
                    for (int keymasterPadding : keymasterEncryptionPaddings) {
                        if (KeymasterUtils.isKeymasterPaddingSchemeIndCpaCompatibleWithAsymmetricCrypto(keymasterPadding)) continue;
                        throw new KeyStoreException("Randomized encryption (IND-CPA) required but is violated by encryption padding mode: " + KeyProperties.EncryptionPadding.fromKeymaster(keymasterPadding) + ". See KeyProtection documentation.");
                    }
                }
                importArgs.addEnums(0x20000006, keymasterEncryptionPaddings);
                importArgs.addEnums(0x20000006, KeyProperties.SignaturePadding.allToKeymaster(spec.getSignaturePaddings()));
                KeymasterUtils.addUserAuthArgs(importArgs, spec.isUserAuthenticationRequired(), spec.getUserAuthenticationValidityDurationSeconds(), spec.isUserAuthenticationValidWhileOnBody(), spec.isInvalidatedByBiometricEnrollment());
                importArgs.addDateIfNotNull(1610613136, spec.getKeyValidityStart());
                importArgs.addDateIfNotNull(1610613137, spec.getKeyValidityForOriginationEnd());
                importArgs.addDateIfNotNull(1610613138, spec.getKeyValidityForConsumptionEnd());
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                throw new KeyStoreException(e);
            }
        }
        boolean success = false;
        try {
            if (shouldReplacePrivateKey) {
                Credentials.deleteAllTypesForAlias(this.mKeyStore, alias, this.mUid);
                KeyCharacteristics resultingKeyCharacteristics = new KeyCharacteristics();
                int errorCode = this.mKeyStore.importKey("USRPKEY_" + alias, importArgs, 1, pkcs8EncodedPrivateKeyBytes, this.mUid, flags, resultingKeyCharacteristics);
                if (errorCode != 1) {
                    throw new KeyStoreException("Failed to store private key", KeyStore.getKeyStoreException(errorCode));
                }
            } else {
                Credentials.deleteCertificateTypesForAlias(this.mKeyStore, alias, this.mUid);
                Credentials.deleteSecretKeyTypeForAlias(this.mKeyStore, alias, this.mUid);
            }
            int errorCode = this.mKeyStore.insert("USRCERT_" + alias, userCertBytes, this.mUid, flags);
            if (errorCode != 1) {
                throw new KeyStoreException("Failed to store certificate #0", KeyStore.getKeyStoreException(errorCode));
            }
            errorCode = this.mKeyStore.insert("CACERT_" + alias, chainBytes, this.mUid, flags);
            if (errorCode != 1) {
                throw new KeyStoreException("Failed to store certificate chain", KeyStore.getKeyStoreException(errorCode));
            }
            success = true;
        }
        finally {
            if (!success) {
                if (shouldReplacePrivateKey) {
                    Credentials.deleteAllTypesForAlias(this.mKeyStore, alias, this.mUid);
                } else {
                    Credentials.deleteCertificateTypesForAlias(this.mKeyStore, alias, this.mUid);
                    Credentials.deleteSecretKeyTypeForAlias(this.mKeyStore, alias, this.mUid);
                }
            }
        }
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreSpi$setSecretKeyEntry(String entryAlias, SecretKey key, KeyStore.ProtectionParameter param) throws KeyStoreException {
        if (param != null && !(param instanceof KeyProtection)) {
            throw new KeyStoreException("Unsupported protection parameter class: " + param.getClass().getName() + ". Supported: " + KeyProtection.class.getName());
        }
        KeyProtection params = (KeyProtection)param;
        if (key instanceof AndroidKeyStoreSecretKey) {
            String keyAliasInKeystore = ((AndroidKeyStoreSecretKey)key).getAlias();
            if (keyAliasInKeystore == null) {
                throw new KeyStoreException("KeyStore-backed secret key does not have an alias");
            }
            if (!keyAliasInKeystore.startsWith("USRSKEY_")) {
                throw new KeyStoreException("KeyStore-backed secret key has invalid alias: " + keyAliasInKeystore);
            }
            String keyEntryAlias = keyAliasInKeystore.substring("USRSKEY_".length());
            if (!entryAlias.equals(keyEntryAlias)) {
                throw new KeyStoreException("Can only replace KeyStore-backed keys with same alias: " + entryAlias + " != " + keyEntryAlias);
            }
            if (params != null) {
                throw new KeyStoreException("Modifying KeyStore-backed key using protection parameters not supported");
            }
            return;
        }
        if (params == null) {
            throw new KeyStoreException("Protection parameters must be specified when importing a symmetric key");
        }
        String keyExportFormat = key.getFormat();
        if (keyExportFormat == null) {
            throw new KeyStoreException("Only secret keys that export their key material are supported");
        }
        if (!"RAW".equals(keyExportFormat)) {
            throw new KeyStoreException("Unsupported secret key material export format: " + keyExportFormat);
        }
        byte[] keyMaterial = key.getEncoded();
        if (keyMaterial == null) {
            throw new KeyStoreException("Key did not export its key material despite supporting RAW format export");
        }
        KeymasterArguments args = new KeymasterArguments();
        try {
            int[] keymasterDigests;
            int keymasterAlgorithm = KeyProperties.KeyAlgorithm.toKeymasterSecretKeyAlgorithm(key.getAlgorithm());
            args.addEnum(0x10000002, keymasterAlgorithm);
            if (keymasterAlgorithm == 128) {
                int[] keymasterDigestsFromParams;
                int keymasterImpliedDigest = KeyProperties.KeyAlgorithm.toKeymasterDigest(key.getAlgorithm());
                if (keymasterImpliedDigest == -1) {
                    throw new ProviderException("HMAC key algorithm digest unknown for key algorithm " + key.getAlgorithm());
                }
                keymasterDigests = new int[]{keymasterImpliedDigest};
                if (params.isDigestsSpecified() && ((keymasterDigestsFromParams = KeyProperties.Digest.allToKeymaster(params.getDigests())).length != 1 || keymasterDigestsFromParams[0] != keymasterImpliedDigest)) {
                    throw new KeyStoreException("Unsupported digests specification: " + Arrays.asList(params.getDigests()) + ". Only " + KeyProperties.Digest.fromKeymaster(keymasterImpliedDigest) + " supported for HMAC key algorithm " + key.getAlgorithm());
                }
            } else {
                keymasterDigests = params.isDigestsSpecified() ? KeyProperties.Digest.allToKeymaster(params.getDigests()) : EmptyArray.INT;
            }
            args.addEnums(0x20000005, keymasterDigests);
            int purposes = params.getPurposes();
            int[] keymasterBlockModes = KeyProperties.BlockMode.allToKeymaster(params.getBlockModes());
            if ((purposes & 1) != 0 && params.isRandomizedEncryptionRequired()) {
                for (int keymasterBlockMode : keymasterBlockModes) {
                    if (KeymasterUtils.isKeymasterBlockModeIndCpaCompatibleWithSymmetricCrypto(keymasterBlockMode)) continue;
                    throw new KeyStoreException("Randomized encryption (IND-CPA) required but may be violated by block mode: " + KeyProperties.BlockMode.fromKeymaster(keymasterBlockMode) + ". See KeyProtection documentation.");
                }
            }
            args.addEnums(0x20000001, KeyProperties.Purpose.allToKeymaster(purposes));
            args.addEnums(0x20000004, keymasterBlockModes);
            if (params.getSignaturePaddings().length > 0) {
                throw new KeyStoreException("Signature paddings not supported for symmetric keys");
            }
            int[] keymasterPaddings = KeyProperties.EncryptionPadding.allToKeymaster(params.getEncryptionPaddings());
            args.addEnums(0x20000006, keymasterPaddings);
            KeymasterUtils.addUserAuthArgs(args, params.isUserAuthenticationRequired(), params.getUserAuthenticationValidityDurationSeconds(), params.isUserAuthenticationValidWhileOnBody(), params.isInvalidatedByBiometricEnrollment());
            KeymasterUtils.addMinMacLengthAuthorizationIfNecessary(args, keymasterAlgorithm, keymasterBlockModes, keymasterDigests);
            args.addDateIfNotNull(1610613136, params.getKeyValidityStart());
            args.addDateIfNotNull(1610613137, params.getKeyValidityForOriginationEnd());
            args.addDateIfNotNull(1610613138, params.getKeyValidityForConsumptionEnd());
            if ((purposes & 1) != 0 && !params.isRandomizedEncryptionRequired()) {
                args.addBoolean(0x70000007);
            }
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new KeyStoreException(e);
        }
        Credentials.deleteAllTypesForAlias(this.mKeyStore, entryAlias, this.mUid);
        String keyAliasInKeystore = "USRSKEY_" + entryAlias;
        int errorCode = this.mKeyStore.importKey(keyAliasInKeystore, args, 3, keyMaterial, this.mUid, 0, new KeyCharacteristics());
        if (errorCode != 1) {
            throw new KeyStoreException("Failed to import secret key. Keystore error code: " + errorCode);
        }
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineSetKeyEntry(String alias, byte[] userKey, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("Operation not supported because key encoding is unknown");
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        byte[] encoded;
        if (this.isKeyEntry(alias)) {
            throw new KeyStoreException("Entry exists and is not a trusted certificate");
        }
        if (cert == null) {
            throw new NullPointerException("cert == null");
        }
        try {
            encoded = cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new KeyStoreException(e);
        }
        if (!this.mKeyStore.put("CACERT_" + alias, encoded, this.mUid, 0)) {
            throw new KeyStoreException("Couldn't insert certificate; is KeyStore initialized?");
        }
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineDeleteEntry(String alias) throws KeyStoreException {
        if (!Credentials.deleteAllTypesForAlias(this.mKeyStore, alias, this.mUid)) {
            throw new KeyStoreException("Failed to delete entry: " + alias);
        }
    }

    private final Set<String> $$robo$$android_security_keystore_AndroidKeyStoreSpi$getUniqueAliases() {
        String[] rawAliases = this.mKeyStore.list("", this.mUid);
        if (rawAliases == null) {
            return new HashSet<String>();
        }
        HashSet<String> aliases = new HashSet<String>(rawAliases.length);
        for (String alias : rawAliases) {
            int idx = alias.indexOf(95);
            if (idx == -1 || alias.length() <= idx) {
                Log.e("AndroidKeyStore", "invalid alias: " + alias);
                continue;
            }
            aliases.add(new String(alias.substring(idx + 1)));
        }
        return aliases;
    }

    private final Enumeration<String> $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineAliases() {
        return Collections.enumeration(this.getUniqueAliases());
    }

    private final boolean $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineContainsAlias(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        return this.mKeyStore.contains("USRPKEY_" + alias, this.mUid) || this.mKeyStore.contains("USRSKEY_" + alias, this.mUid) || this.mKeyStore.contains("USRCERT_" + alias, this.mUid) || this.mKeyStore.contains("CACERT_" + alias, this.mUid);
    }

    private final int $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineSize() {
        return this.getUniqueAliases().size();
    }

    private final boolean $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineIsKeyEntry(String alias) {
        return this.isKeyEntry(alias);
    }

    private final boolean $$robo$$android_security_keystore_AndroidKeyStoreSpi$isKeyEntry(String alias) {
        return this.isPrivateKeyEntry(alias) || this.isSecretKeyEntry(alias);
    }

    private final boolean $$robo$$android_security_keystore_AndroidKeyStoreSpi$isPrivateKeyEntry(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        return this.mKeyStore.contains("USRPKEY_" + alias, this.mUid);
    }

    private final boolean $$robo$$android_security_keystore_AndroidKeyStoreSpi$isSecretKeyEntry(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        return this.mKeyStore.contains("USRSKEY_" + alias, this.mUid);
    }

    private final boolean $$robo$$android_security_keystore_AndroidKeyStoreSpi$isCertificateEntry(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        return this.mKeyStore.contains("CACERT_" + alias, this.mUid);
    }

    private final boolean $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineIsCertificateEntry(String alias) {
        return !this.isKeyEntry(alias) && this.isCertificateEntry(alias);
    }

    private final String $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineGetCertificateAlias(Certificate cert) {
        byte[] targetCertBytes;
        if (cert == null) {
            return null;
        }
        if (!"X.509".equalsIgnoreCase(cert.getType())) {
            return null;
        }
        try {
            targetCertBytes = cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            return null;
        }
        if (targetCertBytes == null) {
            return null;
        }
        HashSet<String> nonCaEntries = new HashSet<String>();
        String[] certAliases = this.mKeyStore.list("USRCERT_", this.mUid);
        if (certAliases != null) {
            for (String alias : certAliases) {
                byte[] certBytes = this.mKeyStore.get("USRCERT_" + alias, this.mUid);
                if (certBytes == null) continue;
                nonCaEntries.add(alias);
                if (!Arrays.equals(certBytes, targetCertBytes)) continue;
                return alias;
            }
        }
        String[] caAliases = this.mKeyStore.list("CACERT_", this.mUid);
        if (certAliases != null) {
            for (String alias : caAliases) {
                byte[] certBytes;
                if (nonCaEntries.contains(alias) || (certBytes = this.mKeyStore.get("CACERT_" + alias, this.mUid)) == null || !Arrays.equals(certBytes, targetCertBytes)) continue;
                return alias;
            }
        }
        return null;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new UnsupportedOperationException("Can not serialize AndroidKeyStore to OutputStream");
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (stream != null) {
            throw new IllegalArgumentException("InputStream not supported");
        }
        if (password != null) {
            throw new IllegalArgumentException("password not supported");
        }
        this.mKeyStore = KeyStore.getInstance();
        this.mUid = -1;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineLoad(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        int uid = -1;
        if (param != null) {
            if (param instanceof AndroidKeyStoreLoadStoreParameter) {
                uid = ((AndroidKeyStoreLoadStoreParameter)param).getUid();
            } else {
                throw new IllegalArgumentException("Unsupported param type: " + param.getClass());
            }
        }
        this.mKeyStore = KeyStore.getInstance();
        this.mUid = uid;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter param) throws KeyStoreException {
        if (entry == null) {
            throw new KeyStoreException("entry == null");
        }
        Credentials.deleteAllTypesForAlias(this.mKeyStore, alias, this.mUid);
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry trE = (KeyStore.TrustedCertificateEntry)entry;
            this.engineSetCertificateEntry(alias, trE.getTrustedCertificate());
            return;
        }
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            KeyStore.PrivateKeyEntry prE = (KeyStore.PrivateKeyEntry)entry;
            this.setPrivateKeyEntry(alias, prE.getPrivateKey(), prE.getCertificateChain(), param);
        } else if (entry instanceof KeyStore.SecretKeyEntry) {
            KeyStore.SecretKeyEntry secE = (KeyStore.SecretKeyEntry)entry;
            this.setSecretKeyEntry(alias, secE.getSecretKey(), param);
        } else {
            throw new KeyStoreException("Entry must be a PrivateKeyEntry, SecretKeyEntry or TrustedCertificateEntry; was " + entry);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_security_keystore_AndroidKeyStoreSpi$__constructor__();
    }

    public AndroidKeyStoreSpi() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreSpi$__constructor__(), 0, this);
    }

    @Override
    public Key engineGetKey(String string2, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        return InvokeDynamicSupport.bootstrap("engineGetKey", $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineGetKey(java.lang.String char[] ), 0, this, string2, cArray);
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string2) {
        return InvokeDynamicSupport.bootstrap("engineGetCertificateChain", $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineGetCertificateChain(java.lang.String ), 0, this, string2);
    }

    @Override
    public Certificate engineGetCertificate(String string2) {
        return InvokeDynamicSupport.bootstrap("engineGetCertificate", $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineGetCertificate(java.lang.String ), 0, this, string2);
    }

    private Certificate getCertificateForTrustedCertificateEntry(byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("getCertificateForTrustedCertificateEntry", $$robo$$android_security_keystore_AndroidKeyStoreSpi$getCertificateForTrustedCertificateEntry(byte[] ), 0, this, byArray);
    }

    private Certificate getCertificateForPrivateKeyEntry(String string2, byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("getCertificateForPrivateKeyEntry", $$robo$$android_security_keystore_AndroidKeyStoreSpi$getCertificateForPrivateKeyEntry(java.lang.String byte[] ), 0, this, string2, byArray);
    }

    private static KeyStoreX509Certificate wrapIntoKeyStoreCertificate(String string2, int n, X509Certificate x509Certificate) {
        return InvokeDynamicSupport.bootstrapStatic("wrapIntoKeyStoreCertificate", $$robo$$android_security_keystore_AndroidKeyStoreSpi$wrapIntoKeyStoreCertificate(java.lang.String int java.security.cert.X509Certificate ), 0, (String)string2, (int)n, (X509Certificate)x509Certificate);
    }

    private static X509Certificate toCertificate(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("toCertificate", $$robo$$android_security_keystore_AndroidKeyStoreSpi$toCertificate(byte[] ), 0, (byte[])byArray);
    }

    private static Collection<X509Certificate> toCertificates(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("toCertificates", $$robo$$android_security_keystore_AndroidKeyStoreSpi$toCertificates(byte[] ), 0, (byte[])byArray);
    }

    private Date getModificationDate(String string2) {
        return InvokeDynamicSupport.bootstrap("getModificationDate", $$robo$$android_security_keystore_AndroidKeyStoreSpi$getModificationDate(java.lang.String ), 0, this, string2);
    }

    @Override
    public Date engineGetCreationDate(String string2) {
        return InvokeDynamicSupport.bootstrap("engineGetCreationDate", $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineGetCreationDate(java.lang.String ), 0, this, string2);
    }

    @Override
    public void engineSetKeyEntry(String string2, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        InvokeDynamicSupport.bootstrap("engineSetKeyEntry", $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineSetKeyEntry(java.lang.String java.security.Key char[] java.security.cert.Certificate[] ), 0, this, string2, key, cArray, certificateArray);
    }

    private static KeyProtection getLegacyKeyProtectionParameter(PrivateKey privateKey) throws KeyStoreException {
        return InvokeDynamicSupport.bootstrapStatic("getLegacyKeyProtectionParameter", $$robo$$android_security_keystore_AndroidKeyStoreSpi$getLegacyKeyProtectionParameter(java.security.PrivateKey ), 0, (PrivateKey)privateKey);
    }

    private void setPrivateKeyEntry(String string2, PrivateKey privateKey, Certificate[] certificateArray, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
        InvokeDynamicSupport.bootstrap("setPrivateKeyEntry", $$robo$$android_security_keystore_AndroidKeyStoreSpi$setPrivateKeyEntry(java.lang.String java.security.PrivateKey java.security.cert.Certificate[] java.security.KeyStore$ProtectionParameter ), 0, this, string2, privateKey, certificateArray, protectionParameter);
    }

    private void setSecretKeyEntry(String string2, SecretKey secretKey, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
        InvokeDynamicSupport.bootstrap("setSecretKeyEntry", $$robo$$android_security_keystore_AndroidKeyStoreSpi$setSecretKeyEntry(java.lang.String javax.crypto.SecretKey java.security.KeyStore$ProtectionParameter ), 0, this, string2, secretKey, protectionParameter);
    }

    @Override
    public void engineSetKeyEntry(String string2, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        InvokeDynamicSupport.bootstrap("engineSetKeyEntry", $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineSetKeyEntry(java.lang.String byte[] java.security.cert.Certificate[] ), 0, this, string2, byArray, certificateArray);
    }

    @Override
    public void engineSetCertificateEntry(String string2, Certificate certificate) throws KeyStoreException {
        InvokeDynamicSupport.bootstrap("engineSetCertificateEntry", $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineSetCertificateEntry(java.lang.String java.security.cert.Certificate ), 0, this, string2, certificate);
    }

    @Override
    public void engineDeleteEntry(String string2) throws KeyStoreException {
        InvokeDynamicSupport.bootstrap("engineDeleteEntry", $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineDeleteEntry(java.lang.String ), 0, this, string2);
    }

    private Set<String> getUniqueAliases() {
        return InvokeDynamicSupport.bootstrap("getUniqueAliases", $$robo$$android_security_keystore_AndroidKeyStoreSpi$getUniqueAliases(), 0, this);
    }

    @Override
    public Enumeration<String> engineAliases() {
        return InvokeDynamicSupport.bootstrap("engineAliases", $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineAliases(), 0, this);
    }

    @Override
    public boolean engineContainsAlias(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("engineContainsAlias", $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineContainsAlias(java.lang.String ), 0, this, string2);
    }

    @Override
    public int engineSize() {
        return (int)InvokeDynamicSupport.bootstrap("engineSize", $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineSize(), 0, this);
    }

    @Override
    public boolean engineIsKeyEntry(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("engineIsKeyEntry", $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineIsKeyEntry(java.lang.String ), 0, this, string2);
    }

    private boolean isKeyEntry(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isKeyEntry", $$robo$$android_security_keystore_AndroidKeyStoreSpi$isKeyEntry(java.lang.String ), 0, this, string2);
    }

    private boolean isPrivateKeyEntry(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPrivateKeyEntry", $$robo$$android_security_keystore_AndroidKeyStoreSpi$isPrivateKeyEntry(java.lang.String ), 0, this, string2);
    }

    private boolean isSecretKeyEntry(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSecretKeyEntry", $$robo$$android_security_keystore_AndroidKeyStoreSpi$isSecretKeyEntry(java.lang.String ), 0, this, string2);
    }

    private boolean isCertificateEntry(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCertificateEntry", $$robo$$android_security_keystore_AndroidKeyStoreSpi$isCertificateEntry(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean engineIsCertificateEntry(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("engineIsCertificateEntry", $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineIsCertificateEntry(java.lang.String ), 0, this, string2);
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        return InvokeDynamicSupport.bootstrap("engineGetCertificateAlias", $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineGetCertificateAlias(java.security.cert.Certificate ), 0, this, certificate);
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        InvokeDynamicSupport.bootstrap("engineStore", $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineStore(java.io.OutputStream char[] ), 0, this, outputStream, cArray);
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        InvokeDynamicSupport.bootstrap("engineLoad", $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineLoad(java.io.InputStream char[] ), 0, this, inputStream, cArray);
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        InvokeDynamicSupport.bootstrap("engineLoad", $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineLoad(java.security.KeyStore$LoadStoreParameter ), 0, this, loadStoreParameter);
    }

    @Override
    public void engineSetEntry(String string2, KeyStore.Entry entry, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
        InvokeDynamicSupport.bootstrap("engineSetEntry", $$robo$$android_security_keystore_AndroidKeyStoreSpi$engineSetEntry(java.lang.String java.security.KeyStore$Entry java.security.KeyStore$ProtectionParameter ), 0, this, string2, entry, protectionParameter);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndroidKeyStoreSpi)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class KeyStoreX509Certificate
    extends DelegatingX509Certificate
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mPrivateKeyAlias;
        private int mPrivateKeyUid;

        private void $$robo$$android_security_keystore_AndroidKeyStoreSpi_KeyStoreX509Certificate$__constructor__(String privateKeyAlias, int privateKeyUid, X509Certificate delegate) {
            this.mPrivateKeyAlias = privateKeyAlias;
            this.mPrivateKeyUid = privateKeyUid;
        }

        private final PublicKey $$robo$$android_security_keystore_AndroidKeyStoreSpi_KeyStoreX509Certificate$getPublicKey() {
            PublicKey original = super.getPublicKey();
            return AndroidKeyStoreProvider.getAndroidKeyStorePublicKey(this.mPrivateKeyAlias, this.mPrivateKeyUid, original.getAlgorithm(), original.getEncoded());
        }

        private void __constructor__(String string2, int n, X509Certificate x509Certificate) {
            this.$$robo$$android_security_keystore_AndroidKeyStoreSpi_KeyStoreX509Certificate$__constructor__(string2, n, x509Certificate);
        }

        KeyStoreX509Certificate(String string2, int n, X509Certificate x509Certificate) {
            super(x509Certificate);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreSpi_KeyStoreX509Certificate$__constructor__(java.lang.String int java.security.cert.X509Certificate ), 0, this, string2, n, x509Certificate);
        }

        @Override
        public PublicKey getPublicKey() {
            return InvokeDynamicSupport.bootstrap("getPublicKey", $$robo$$android_security_keystore_AndroidKeyStoreSpi_KeyStoreX509Certificate$getPublicKey(), 0, this);
        }

        public /* synthetic */ KeyStoreX509Certificate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyStoreX509Certificate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

