/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import java.util.Collection;
import java.util.Locale;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class KeyProperties
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int PURPOSE_ENCRYPT = 1;
    public static int PURPOSE_DECRYPT = 2;
    public static int PURPOSE_SIGN = 4;
    public static int PURPOSE_VERIFY = 8;
    public static String KEY_ALGORITHM_RSA = "RSA";
    public static String KEY_ALGORITHM_EC = "EC";
    public static String KEY_ALGORITHM_AES = "AES";
    public static String KEY_ALGORITHM_HMAC_SHA1 = "HmacSHA1";
    public static String KEY_ALGORITHM_HMAC_SHA224 = "HmacSHA224";
    public static String KEY_ALGORITHM_HMAC_SHA256 = "HmacSHA256";
    public static String KEY_ALGORITHM_HMAC_SHA384 = "HmacSHA384";
    public static String KEY_ALGORITHM_HMAC_SHA512 = "HmacSHA512";
    public static String BLOCK_MODE_ECB = "ECB";
    public static String BLOCK_MODE_CBC = "CBC";
    public static String BLOCK_MODE_CTR = "CTR";
    public static String BLOCK_MODE_GCM = "GCM";
    public static String ENCRYPTION_PADDING_NONE = "NoPadding";
    public static String ENCRYPTION_PADDING_PKCS7 = "PKCS7Padding";
    public static String ENCRYPTION_PADDING_RSA_PKCS1 = "PKCS1Padding";
    public static String ENCRYPTION_PADDING_RSA_OAEP = "OAEPPadding";
    public static String SIGNATURE_PADDING_RSA_PKCS1 = "PKCS1";
    public static String SIGNATURE_PADDING_RSA_PSS = "PSS";
    public static String DIGEST_NONE = "NONE";
    public static String DIGEST_MD5 = "MD5";
    public static String DIGEST_SHA1 = "SHA-1";
    public static String DIGEST_SHA224 = "SHA-224";
    public static String DIGEST_SHA256 = "SHA-256";
    public static String DIGEST_SHA384 = "SHA-384";
    public static String DIGEST_SHA512 = "SHA-512";
    public static int ORIGIN_GENERATED = 1;
    public static int ORIGIN_IMPORTED = 2;
    public static int ORIGIN_UNKNOWN = 4;

    private void $$robo$$android_security_keystore_KeyProperties$__constructor__() {
    }

    private static final int[] $$robo$$android_security_keystore_KeyProperties$getSetFlags(int flags) {
        if (flags == 0) {
            return EmptyArray.INT;
        }
        int[] result = new int[KeyProperties.getSetBitCount(flags)];
        int resultOffset = 0;
        int flag = 1;
        while (flags != 0) {
            if ((flags & 1) != 0) {
                result[resultOffset] = flag;
                ++resultOffset;
            }
            flags >>>= 1;
            flag <<= 1;
        }
        return result;
    }

    private static final int $$robo$$android_security_keystore_KeyProperties$getSetBitCount(int value) {
        if (value == 0) {
            return 0;
        }
        int result = 0;
        while (value != 0) {
            if ((value & 1) != 0) {
                ++result;
            }
            value >>>= 1;
        }
        return result;
    }

    private void __constructor__() {
        this.$$robo$$android_security_keystore_KeyProperties$__constructor__();
    }

    private KeyProperties() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeyProperties$__constructor__(), 0, this);
    }

    private static int[] getSetFlags(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getSetFlags", $$robo$$android_security_keystore_KeyProperties$getSetFlags(int ), 0, (int)n);
    }

    private static int getSetBitCount(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSetBitCount", $$robo$$android_security_keystore_KeyProperties$getSetBitCount(int ), 0, (int)n);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyProperties)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class Origin
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_KeyProperties_Origin$__constructor__() {
        }

        private static final int $$robo$$android_security_keystore_KeyProperties_Origin$fromKeymaster(int origin) {
            switch (origin) {
                case 0: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 4;
                }
            }
            throw new IllegalArgumentException("Unknown origin: " + origin);
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_KeyProperties_Origin$__constructor__();
        }

        private Origin() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeyProperties_Origin$__constructor__(), 0, this);
        }

        public static int fromKeymaster(int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("fromKeymaster", $$robo$$android_security_keystore_KeyProperties_Origin$fromKeymaster(int ), 0, (int)n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Origin)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Digest
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_KeyProperties_Digest$__constructor__() {
        }

        private static final int $$robo$$android_security_keystore_KeyProperties_Digest$toKeymaster(String digest) {
            switch (digest.toUpperCase(Locale.US)) {
                case "SHA-1": {
                    return 2;
                }
                case "SHA-224": {
                    return 3;
                }
                case "SHA-256": {
                    return 4;
                }
                case "SHA-384": {
                    return 5;
                }
                case "SHA-512": {
                    return 6;
                }
                case "NONE": {
                    return 0;
                }
                case "MD5": {
                    return 1;
                }
            }
            throw new IllegalArgumentException("Unsupported digest algorithm: " + digest);
        }

        private static final String $$robo$$android_security_keystore_KeyProperties_Digest$fromKeymaster(int digest) {
            switch (digest) {
                case 0: {
                    return "NONE";
                }
                case 1: {
                    return "MD5";
                }
                case 2: {
                    return "SHA-1";
                }
                case 3: {
                    return "SHA-224";
                }
                case 4: {
                    return "SHA-256";
                }
                case 5: {
                    return "SHA-384";
                }
                case 6: {
                    return "SHA-512";
                }
            }
            throw new IllegalArgumentException("Unsupported digest algorithm: " + digest);
        }

        private static final String $$robo$$android_security_keystore_KeyProperties_Digest$fromKeymasterToSignatureAlgorithmDigest(int digest) {
            switch (digest) {
                case 0: {
                    return "NONE";
                }
                case 1: {
                    return "MD5";
                }
                case 2: {
                    return "SHA1";
                }
                case 3: {
                    return "SHA224";
                }
                case 4: {
                    return "SHA256";
                }
                case 5: {
                    return "SHA384";
                }
                case 6: {
                    return "SHA512";
                }
            }
            throw new IllegalArgumentException("Unsupported digest algorithm: " + digest);
        }

        private static final String[] $$robo$$android_security_keystore_KeyProperties_Digest$allFromKeymaster(Collection<Integer> digests) {
            if (digests.isEmpty()) {
                return EmptyArray.STRING;
            }
            String[] result = new String[digests.size()];
            int offset = 0;
            for (int digest : digests) {
                result[offset] = Digest.fromKeymaster(digest);
                ++offset;
            }
            return result;
        }

        private static final int[] $$robo$$android_security_keystore_KeyProperties_Digest$allToKeymaster(String[] digests) {
            if (digests == null || digests.length == 0) {
                return EmptyArray.INT;
            }
            int[] result = new int[digests.length];
            int offset = 0;
            for (String digest : digests) {
                result[offset] = Digest.toKeymaster(digest);
                ++offset;
            }
            return result;
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_KeyProperties_Digest$__constructor__();
        }

        private Digest() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeyProperties_Digest$__constructor__(), 0, this);
        }

        public static int toKeymaster(String string2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("toKeymaster", $$robo$$android_security_keystore_KeyProperties_Digest$toKeymaster(java.lang.String ), 0, (String)string2);
        }

        public static String fromKeymaster(int n) {
            return InvokeDynamicSupport.bootstrapStatic("fromKeymaster", $$robo$$android_security_keystore_KeyProperties_Digest$fromKeymaster(int ), 0, (int)n);
        }

        public static String fromKeymasterToSignatureAlgorithmDigest(int n) {
            return InvokeDynamicSupport.bootstrapStatic("fromKeymasterToSignatureAlgorithmDigest", $$robo$$android_security_keystore_KeyProperties_Digest$fromKeymasterToSignatureAlgorithmDigest(int ), 0, (int)n);
        }

        public static String[] allFromKeymaster(Collection<Integer> collection) {
            return InvokeDynamicSupport.bootstrapStatic("allFromKeymaster", $$robo$$android_security_keystore_KeyProperties_Digest$allFromKeymaster(java.util.Collection<java.lang.Integer> ), 0, collection);
        }

        public static int[] allToKeymaster(String[] stringArray) {
            return InvokeDynamicSupport.bootstrapStatic("allToKeymaster", $$robo$$android_security_keystore_KeyProperties_Digest$allToKeymaster(java.lang.String[] ), 0, (String[])stringArray);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Digest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class SignaturePadding
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_KeyProperties_SignaturePadding$__constructor__() {
        }

        private static final int $$robo$$android_security_keystore_KeyProperties_SignaturePadding$toKeymaster(String padding) {
            switch (padding.toUpperCase(Locale.US)) {
                case "PKCS1": {
                    return 5;
                }
                case "PSS": {
                    return 3;
                }
            }
            throw new IllegalArgumentException("Unsupported signature padding scheme: " + padding);
        }

        private static final String $$robo$$android_security_keystore_KeyProperties_SignaturePadding$fromKeymaster(int padding) {
            switch (padding) {
                case 5: {
                    return "PKCS1";
                }
                case 3: {
                    return "PSS";
                }
            }
            throw new IllegalArgumentException("Unsupported signature padding: " + padding);
        }

        private static final int[] $$robo$$android_security_keystore_KeyProperties_SignaturePadding$allToKeymaster(String[] paddings) {
            if (paddings == null || paddings.length == 0) {
                return EmptyArray.INT;
            }
            int[] result = new int[paddings.length];
            for (int i = 0; i < paddings.length; ++i) {
                result[i] = SignaturePadding.toKeymaster(paddings[i]);
            }
            return result;
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_KeyProperties_SignaturePadding$__constructor__();
        }

        private SignaturePadding() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeyProperties_SignaturePadding$__constructor__(), 0, this);
        }

        static int toKeymaster(String string2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("toKeymaster", $$robo$$android_security_keystore_KeyProperties_SignaturePadding$toKeymaster(java.lang.String ), 0, (String)string2);
        }

        static String fromKeymaster(int n) {
            return InvokeDynamicSupport.bootstrapStatic("fromKeymaster", $$robo$$android_security_keystore_KeyProperties_SignaturePadding$fromKeymaster(int ), 0, (int)n);
        }

        static int[] allToKeymaster(String[] stringArray) {
            return InvokeDynamicSupport.bootstrapStatic("allToKeymaster", $$robo$$android_security_keystore_KeyProperties_SignaturePadding$allToKeymaster(java.lang.String[] ), 0, (String[])stringArray);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SignaturePadding)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class EncryptionPadding
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_KeyProperties_EncryptionPadding$__constructor__() {
        }

        private static final int $$robo$$android_security_keystore_KeyProperties_EncryptionPadding$toKeymaster(String padding) {
            if ("NoPadding".equalsIgnoreCase(padding)) {
                return 1;
            }
            if ("PKCS7Padding".equalsIgnoreCase(padding)) {
                return 64;
            }
            if ("PKCS1Padding".equalsIgnoreCase(padding)) {
                return 4;
            }
            if ("OAEPPadding".equalsIgnoreCase(padding)) {
                return 2;
            }
            throw new IllegalArgumentException("Unsupported encryption padding scheme: " + padding);
        }

        private static final String $$robo$$android_security_keystore_KeyProperties_EncryptionPadding$fromKeymaster(int padding) {
            switch (padding) {
                case 1: {
                    return "NoPadding";
                }
                case 64: {
                    return "PKCS7Padding";
                }
                case 4: {
                    return "PKCS1Padding";
                }
                case 2: {
                    return "OAEPPadding";
                }
            }
            throw new IllegalArgumentException("Unsupported encryption padding: " + padding);
        }

        private static final int[] $$robo$$android_security_keystore_KeyProperties_EncryptionPadding$allToKeymaster(String[] paddings) {
            if (paddings == null || paddings.length == 0) {
                return EmptyArray.INT;
            }
            int[] result = new int[paddings.length];
            for (int i = 0; i < paddings.length; ++i) {
                result[i] = EncryptionPadding.toKeymaster(paddings[i]);
            }
            return result;
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_KeyProperties_EncryptionPadding$__constructor__();
        }

        private EncryptionPadding() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeyProperties_EncryptionPadding$__constructor__(), 0, this);
        }

        public static int toKeymaster(String string2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("toKeymaster", $$robo$$android_security_keystore_KeyProperties_EncryptionPadding$toKeymaster(java.lang.String ), 0, (String)string2);
        }

        public static String fromKeymaster(int n) {
            return InvokeDynamicSupport.bootstrapStatic("fromKeymaster", $$robo$$android_security_keystore_KeyProperties_EncryptionPadding$fromKeymaster(int ), 0, (int)n);
        }

        public static int[] allToKeymaster(String[] stringArray) {
            return InvokeDynamicSupport.bootstrapStatic("allToKeymaster", $$robo$$android_security_keystore_KeyProperties_EncryptionPadding$allToKeymaster(java.lang.String[] ), 0, (String[])stringArray);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EncryptionPadding)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class BlockMode
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_KeyProperties_BlockMode$__constructor__() {
        }

        private static final int $$robo$$android_security_keystore_KeyProperties_BlockMode$toKeymaster(String blockMode) {
            if ("ECB".equalsIgnoreCase(blockMode)) {
                return 1;
            }
            if ("CBC".equalsIgnoreCase(blockMode)) {
                return 2;
            }
            if ("CTR".equalsIgnoreCase(blockMode)) {
                return 3;
            }
            if ("GCM".equalsIgnoreCase(blockMode)) {
                return 32;
            }
            throw new IllegalArgumentException("Unsupported block mode: " + blockMode);
        }

        private static final String $$robo$$android_security_keystore_KeyProperties_BlockMode$fromKeymaster(int blockMode) {
            switch (blockMode) {
                case 1: {
                    return "ECB";
                }
                case 2: {
                    return "CBC";
                }
                case 3: {
                    return "CTR";
                }
                case 32: {
                    return "GCM";
                }
            }
            throw new IllegalArgumentException("Unsupported block mode: " + blockMode);
        }

        private static final String[] $$robo$$android_security_keystore_KeyProperties_BlockMode$allFromKeymaster(Collection<Integer> blockModes) {
            if (blockModes == null || blockModes.isEmpty()) {
                return EmptyArray.STRING;
            }
            String[] result = new String[blockModes.size()];
            int offset = 0;
            for (int blockMode : blockModes) {
                result[offset] = BlockMode.fromKeymaster(blockMode);
                ++offset;
            }
            return result;
        }

        private static final int[] $$robo$$android_security_keystore_KeyProperties_BlockMode$allToKeymaster(String[] blockModes) {
            if (blockModes == null || blockModes.length == 0) {
                return EmptyArray.INT;
            }
            int[] result = new int[blockModes.length];
            for (int i = 0; i < blockModes.length; ++i) {
                result[i] = BlockMode.toKeymaster(blockModes[i]);
            }
            return result;
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_KeyProperties_BlockMode$__constructor__();
        }

        private BlockMode() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeyProperties_BlockMode$__constructor__(), 0, this);
        }

        public static int toKeymaster(String string2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("toKeymaster", $$robo$$android_security_keystore_KeyProperties_BlockMode$toKeymaster(java.lang.String ), 0, (String)string2);
        }

        public static String fromKeymaster(int n) {
            return InvokeDynamicSupport.bootstrapStatic("fromKeymaster", $$robo$$android_security_keystore_KeyProperties_BlockMode$fromKeymaster(int ), 0, (int)n);
        }

        public static String[] allFromKeymaster(Collection<Integer> collection) {
            return InvokeDynamicSupport.bootstrapStatic("allFromKeymaster", $$robo$$android_security_keystore_KeyProperties_BlockMode$allFromKeymaster(java.util.Collection<java.lang.Integer> ), 0, collection);
        }

        public static int[] allToKeymaster(String[] stringArray) {
            return InvokeDynamicSupport.bootstrapStatic("allToKeymaster", $$robo$$android_security_keystore_KeyProperties_BlockMode$allToKeymaster(java.lang.String[] ), 0, (String[])stringArray);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BlockMode)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class KeyAlgorithm
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_KeyProperties_KeyAlgorithm$__constructor__() {
        }

        private static final int $$robo$$android_security_keystore_KeyProperties_KeyAlgorithm$toKeymasterAsymmetricKeyAlgorithm(String algorithm) {
            if ("EC".equalsIgnoreCase(algorithm)) {
                return 3;
            }
            if ("RSA".equalsIgnoreCase(algorithm)) {
                return 1;
            }
            throw new IllegalArgumentException("Unsupported key algorithm: " + algorithm);
        }

        private static final String $$robo$$android_security_keystore_KeyProperties_KeyAlgorithm$fromKeymasterAsymmetricKeyAlgorithm(int keymasterAlgorithm) {
            switch (keymasterAlgorithm) {
                case 3: {
                    return "EC";
                }
                case 1: {
                    return "RSA";
                }
            }
            throw new IllegalArgumentException("Unsupported key algorithm: " + keymasterAlgorithm);
        }

        private static final int $$robo$$android_security_keystore_KeyProperties_KeyAlgorithm$toKeymasterSecretKeyAlgorithm(String algorithm) {
            if ("AES".equalsIgnoreCase(algorithm)) {
                return 32;
            }
            if (algorithm.toUpperCase(Locale.US).startsWith("HMAC")) {
                return 128;
            }
            throw new IllegalArgumentException("Unsupported secret key algorithm: " + algorithm);
        }

        private static final String $$robo$$android_security_keystore_KeyProperties_KeyAlgorithm$fromKeymasterSecretKeyAlgorithm(int keymasterAlgorithm, int keymasterDigest) {
            switch (keymasterAlgorithm) {
                case 32: {
                    return "AES";
                }
                case 128: {
                    switch (keymasterDigest) {
                        case 2: {
                            return "HmacSHA1";
                        }
                        case 3: {
                            return "HmacSHA224";
                        }
                        case 4: {
                            return "HmacSHA256";
                        }
                        case 5: {
                            return "HmacSHA384";
                        }
                        case 6: {
                            return "HmacSHA512";
                        }
                    }
                    throw new IllegalArgumentException("Unsupported HMAC digest: " + Digest.fromKeymaster(keymasterDigest));
                }
            }
            throw new IllegalArgumentException("Unsupported key algorithm: " + keymasterAlgorithm);
        }

        private static final int $$robo$$android_security_keystore_KeyProperties_KeyAlgorithm$toKeymasterDigest(String algorithm) {
            String algorithmUpper = algorithm.toUpperCase(Locale.US);
            if (algorithmUpper.startsWith("HMAC")) {
                String digestUpper;
                switch (digestUpper = algorithmUpper.substring("HMAC".length())) {
                    case "SHA1": {
                        return 2;
                    }
                    case "SHA224": {
                        return 3;
                    }
                    case "SHA256": {
                        return 4;
                    }
                    case "SHA384": {
                        return 5;
                    }
                    case "SHA512": {
                        return 6;
                    }
                }
                throw new IllegalArgumentException("Unsupported HMAC digest: " + digestUpper);
            }
            return -1;
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_KeyProperties_KeyAlgorithm$__constructor__();
        }

        private KeyAlgorithm() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeyProperties_KeyAlgorithm$__constructor__(), 0, this);
        }

        public static int toKeymasterAsymmetricKeyAlgorithm(String string2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("toKeymasterAsymmetricKeyAlgorithm", $$robo$$android_security_keystore_KeyProperties_KeyAlgorithm$toKeymasterAsymmetricKeyAlgorithm(java.lang.String ), 0, (String)string2);
        }

        public static String fromKeymasterAsymmetricKeyAlgorithm(int n) {
            return InvokeDynamicSupport.bootstrapStatic("fromKeymasterAsymmetricKeyAlgorithm", $$robo$$android_security_keystore_KeyProperties_KeyAlgorithm$fromKeymasterAsymmetricKeyAlgorithm(int ), 0, (int)n);
        }

        public static int toKeymasterSecretKeyAlgorithm(String string2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("toKeymasterSecretKeyAlgorithm", $$robo$$android_security_keystore_KeyProperties_KeyAlgorithm$toKeymasterSecretKeyAlgorithm(java.lang.String ), 0, (String)string2);
        }

        public static String fromKeymasterSecretKeyAlgorithm(int n, int n2) {
            return InvokeDynamicSupport.bootstrapStatic("fromKeymasterSecretKeyAlgorithm", $$robo$$android_security_keystore_KeyProperties_KeyAlgorithm$fromKeymasterSecretKeyAlgorithm(int int ), 0, (int)n, (int)n2);
        }

        public static int toKeymasterDigest(String string2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("toKeymasterDigest", $$robo$$android_security_keystore_KeyProperties_KeyAlgorithm$toKeymasterDigest(java.lang.String ), 0, (String)string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyAlgorithm)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Purpose
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_KeyProperties_Purpose$__constructor__() {
        }

        private static final int $$robo$$android_security_keystore_KeyProperties_Purpose$toKeymaster(int purpose) {
            switch (purpose) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 4: {
                    return 2;
                }
                case 8: {
                    return 3;
                }
            }
            throw new IllegalArgumentException("Unknown purpose: " + purpose);
        }

        private static final int $$robo$$android_security_keystore_KeyProperties_Purpose$fromKeymaster(int purpose) {
            switch (purpose) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 4;
                }
                case 3: {
                    return 8;
                }
            }
            throw new IllegalArgumentException("Unknown purpose: " + purpose);
        }

        private static final int[] $$robo$$android_security_keystore_KeyProperties_Purpose$allToKeymaster(int purposes) {
            int[] result = KeyProperties.getSetFlags(purposes);
            for (int i = 0; i < result.length; ++i) {
                result[i] = Purpose.toKeymaster(result[i]);
            }
            return result;
        }

        private static final int $$robo$$android_security_keystore_KeyProperties_Purpose$allFromKeymaster(Collection<Integer> purposes) {
            int result = 0;
            for (int keymasterPurpose : purposes) {
                result |= Purpose.fromKeymaster(keymasterPurpose);
            }
            return result;
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_KeyProperties_Purpose$__constructor__();
        }

        private Purpose() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeyProperties_Purpose$__constructor__(), 0, this);
        }

        public static int toKeymaster(int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("toKeymaster", $$robo$$android_security_keystore_KeyProperties_Purpose$toKeymaster(int ), 0, (int)n);
        }

        public static int fromKeymaster(int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("fromKeymaster", $$robo$$android_security_keystore_KeyProperties_Purpose$fromKeymaster(int ), 0, (int)n);
        }

        public static int[] allToKeymaster(int n) {
            return InvokeDynamicSupport.bootstrapStatic("allToKeymaster", $$robo$$android_security_keystore_KeyProperties_Purpose$allToKeymaster(int ), 0, (int)n);
        }

        public static int allFromKeymaster(Collection<Integer> collection) {
            return (int)InvokeDynamicSupport.bootstrapStatic("allFromKeymaster", $$robo$$android_security_keystore_KeyProperties_Purpose$allFromKeymaster(java.util.Collection<java.lang.Integer> ), 0, collection);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Purpose)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

