/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.hardware.fingerprint.FingerprintManager;
import android.security.GateKeeper;
import android.security.KeyStore;
import android.security.keymaster.KeymasterArguments;
import android.security.keystore.KeyProperties;
import com.android.internal.util.ArrayUtils;
import java.security.ProviderException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class KeymasterUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$android_security_keystore_KeymasterUtils$__constructor__() {
    }

    private static final int $$robo$$android_security_keystore_KeymasterUtils$getDigestOutputSizeBits(int keymasterDigest) {
        switch (keymasterDigest) {
            case 0: {
                return -1;
            }
            case 1: {
                return 128;
            }
            case 2: {
                return 160;
            }
            case 3: {
                return 224;
            }
            case 4: {
                return 256;
            }
            case 5: {
                return 384;
            }
            case 6: {
                return 512;
            }
        }
        throw new IllegalArgumentException("Unknown digest: " + keymasterDigest);
    }

    private static final boolean $$robo$$android_security_keystore_KeymasterUtils$isKeymasterBlockModeIndCpaCompatibleWithSymmetricCrypto(int keymasterBlockMode) {
        switch (keymasterBlockMode) {
            case 1: {
                return false;
            }
            case 2: 
            case 3: 
            case 32: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unsupported block mode: " + keymasterBlockMode);
    }

    private static final boolean $$robo$$android_security_keystore_KeymasterUtils$isKeymasterPaddingSchemeIndCpaCompatibleWithAsymmetricCrypto(int keymasterPadding) {
        switch (keymasterPadding) {
            case 1: {
                return false;
            }
            case 2: 
            case 4: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unsupported asymmetric encryption padding scheme: " + keymasterPadding);
    }

    private static final void $$robo$$android_security_keystore_KeymasterUtils$addUserAuthArgs(KeymasterArguments args, boolean userAuthenticationRequired, int userAuthenticationValidityDurationSeconds, boolean userAuthenticationValidWhileOnBody, boolean invalidatedByBiometricEnrollment) {
        if (!userAuthenticationRequired) {
            args.addBoolean(1879048695);
            return;
        }
        if (userAuthenticationValidityDurationSeconds == -1) {
            long fingerprintOnlySid;
            FingerprintManager fingerprintManager = KeyStore.getApplicationContext().getSystemService(FingerprintManager.class);
            long l = fingerprintOnlySid = fingerprintManager != null ? fingerprintManager.getAuthenticatorId() : 0L;
            if (fingerprintOnlySid == 0L) {
                throw new IllegalStateException("At least one fingerprint must be enrolled to create keys requiring user authentication for every use");
            }
            long sid = invalidatedByBiometricEnrollment ? fingerprintOnlySid : KeymasterUtils.getRootSid();
            args.addUnsignedLong(-1610612234, KeymasterArguments.toUint64(sid));
            args.addEnum(268435960, 2);
            if (userAuthenticationValidWhileOnBody) {
                throw new ProviderException("Key validity extension while device is on-body is not supported for keys requiring fingerprint authentication");
            }
        } else {
            long rootSid = KeymasterUtils.getRootSid();
            args.addUnsignedLong(-1610612234, KeymasterArguments.toUint64(rootSid));
            args.addEnum(268435960, 3);
            args.addUnsignedInt(805306873, userAuthenticationValidityDurationSeconds);
            if (userAuthenticationValidWhileOnBody) {
                args.addBoolean(1879048698);
            }
        }
    }

    private static final void $$robo$$android_security_keystore_KeymasterUtils$addMinMacLengthAuthorizationIfNecessary(KeymasterArguments args, int keymasterAlgorithm, int[] keymasterBlockModes, int[] keymasterDigests) {
        switch (keymasterAlgorithm) {
            case 32: {
                if (!ArrayUtils.contains(keymasterBlockModes, 32)) break;
                args.addUnsignedInt(0x30000008, 96L);
                break;
            }
            case 128: {
                if (keymasterDigests.length != 1) {
                    throw new ProviderException("Unsupported number of authorized digests for HMAC key: " + keymasterDigests.length + ". Exactly one digest must be authorized");
                }
                int keymasterDigest = keymasterDigests[0];
                int digestOutputSizeBits = KeymasterUtils.getDigestOutputSizeBits(keymasterDigest);
                if (digestOutputSizeBits == -1) {
                    throw new ProviderException("HMAC key authorized for unsupported digest: " + KeyProperties.Digest.fromKeymaster(keymasterDigest));
                }
                args.addUnsignedInt(0x30000008, digestOutputSizeBits);
            }
        }
    }

    private static final long $$robo$$android_security_keystore_KeymasterUtils$getRootSid() {
        long rootSid = GateKeeper.getSecureUserId();
        if (rootSid == 0L) {
            throw new IllegalStateException("Secure lock screen must be enabled to create keys requiring user authentication");
        }
        return rootSid;
    }

    private void __constructor__() {
        this.$$robo$$android_security_keystore_KeymasterUtils$__constructor__();
    }

    private KeymasterUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeymasterUtils$__constructor__(), 0, this);
    }

    public static int getDigestOutputSizeBits(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDigestOutputSizeBits", $$robo$$android_security_keystore_KeymasterUtils$getDigestOutputSizeBits(int ), 0, (int)n);
    }

    public static boolean isKeymasterBlockModeIndCpaCompatibleWithSymmetricCrypto(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isKeymasterBlockModeIndCpaCompatibleWithSymmetricCrypto", $$robo$$android_security_keystore_KeymasterUtils$isKeymasterBlockModeIndCpaCompatibleWithSymmetricCrypto(int ), 0, (int)n);
    }

    public static boolean isKeymasterPaddingSchemeIndCpaCompatibleWithAsymmetricCrypto(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isKeymasterPaddingSchemeIndCpaCompatibleWithAsymmetricCrypto", $$robo$$android_security_keystore_KeymasterUtils$isKeymasterPaddingSchemeIndCpaCompatibleWithAsymmetricCrypto(int ), 0, (int)n);
    }

    public static void addUserAuthArgs(KeymasterArguments keymasterArguments, boolean bl, int n, boolean bl2, boolean bl3) {
        InvokeDynamicSupport.bootstrapStatic("addUserAuthArgs", $$robo$$android_security_keystore_KeymasterUtils$addUserAuthArgs(android.security.keymaster.KeymasterArguments boolean int boolean boolean ), 0, (KeymasterArguments)keymasterArguments, (boolean)bl, (int)n, (boolean)bl2, (boolean)bl3);
    }

    public static void addMinMacLengthAuthorizationIfNecessary(KeymasterArguments keymasterArguments, int n, int[] nArray, int[] nArray2) {
        InvokeDynamicSupport.bootstrapStatic("addMinMacLengthAuthorizationIfNecessary", $$robo$$android_security_keystore_KeymasterUtils$addMinMacLengthAuthorizationIfNecessary(android.security.keymaster.KeymasterArguments int int[] int[] ), 0, (KeymasterArguments)keymasterArguments, (int)n, (int[])nArray, (int[])nArray2);
    }

    private static long getRootSid() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getRootSid", $$robo$$android_security_keystore_KeymasterUtils$getRootSid(), 0);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeymasterUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

