/*
 * Decompiled with CFR 0.152.
 */
package android.security.net.config;

import android.security.net.config.ConfigSource;
import android.security.net.config.Domain;
import android.security.net.config.NetworkSecurityConfig;
import android.security.net.config.RootTrustManager;
import android.util.Pair;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.net.ssl.X509TrustManager;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class ApplicationConfig
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static ApplicationConfig sInstance;
    private static Object sLock;
    private Set<Pair<Domain, NetworkSecurityConfig>> mConfigs;
    private NetworkSecurityConfig mDefaultConfig;
    private X509TrustManager mTrustManager;
    private ConfigSource mConfigSource;
    private boolean mInitialized;
    private Object mLock;

    private void $$robo$$android_security_net_config_ApplicationConfig$__constructor__(ConfigSource configSource) {
        this.mLock = new Object();
        this.mConfigSource = configSource;
        this.mInitialized = false;
    }

    private final boolean $$robo$$android_security_net_config_ApplicationConfig$hasPerDomainConfigs() {
        this.ensureInitialized();
        return this.mConfigs != null && !this.mConfigs.isEmpty();
    }

    private final NetworkSecurityConfig $$robo$$android_security_net_config_ApplicationConfig$getConfigForHostname(String hostname) {
        this.ensureInitialized();
        if (hostname == null || hostname.isEmpty() || this.mConfigs == null) {
            return this.mDefaultConfig;
        }
        if (hostname.charAt(0) == '.') {
            throw new IllegalArgumentException("hostname must not begin with a .");
        }
        if ((hostname = hostname.toLowerCase(Locale.US)).charAt(hostname.length() - 1) == '.') {
            hostname = hostname.substring(0, hostname.length() - 1);
        }
        Pair<Domain, NetworkSecurityConfig> bestMatch = null;
        for (Pair<Domain, NetworkSecurityConfig> entry : this.mConfigs) {
            Domain domain = (Domain)entry.first;
            NetworkSecurityConfig config = (NetworkSecurityConfig)entry.second;
            if (domain.hostname.equals(hostname)) {
                return config;
            }
            if (!domain.subdomainsIncluded || !hostname.endsWith(domain.hostname) || hostname.charAt(hostname.length() - domain.hostname.length() - 1) != '.') continue;
            if (bestMatch == null) {
                bestMatch = entry;
                continue;
            }
            if (domain.hostname.length() <= ((Domain)bestMatch.first).hostname.length()) continue;
            bestMatch = entry;
        }
        if (bestMatch != null) {
            return (NetworkSecurityConfig)bestMatch.second;
        }
        return this.mDefaultConfig;
    }

    private final X509TrustManager $$robo$$android_security_net_config_ApplicationConfig$getTrustManager() {
        this.ensureInitialized();
        return this.mTrustManager;
    }

    private final boolean $$robo$$android_security_net_config_ApplicationConfig$isCleartextTrafficPermitted() {
        this.ensureInitialized();
        if (this.mConfigs != null) {
            for (Pair<Domain, NetworkSecurityConfig> entry : this.mConfigs) {
                if (((NetworkSecurityConfig)entry.second).isCleartextTrafficPermitted()) continue;
                return false;
            }
        }
        return this.mDefaultConfig.isCleartextTrafficPermitted();
    }

    private final boolean $$robo$$android_security_net_config_ApplicationConfig$isCleartextTrafficPermitted(String hostname) {
        return this.getConfigForHostname(hostname).isCleartextTrafficPermitted();
    }

    private final void $$robo$$android_security_net_config_ApplicationConfig$handleTrustStorageUpdate() {
        this.ensureInitialized();
        this.mDefaultConfig.handleTrustStorageUpdate();
        if (this.mConfigs != null) {
            HashSet updatedConfigs = new HashSet(this.mConfigs.size());
            for (Pair<Domain, NetworkSecurityConfig> entry : this.mConfigs) {
                if (!updatedConfigs.add(entry.second)) continue;
                ((NetworkSecurityConfig)entry.second).handleTrustStorageUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_security_net_config_ApplicationConfig$ensureInitialized() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInitialized) {
                return;
            }
            this.mConfigs = this.mConfigSource.getPerDomainConfigs();
            this.mDefaultConfig = this.mConfigSource.getDefaultConfig();
            this.mConfigSource = null;
            this.mTrustManager = new RootTrustManager(this);
            this.mInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_security_net_config_ApplicationConfig$setDefaultInstance(ApplicationConfig config) {
        Object object = sLock;
        synchronized (object) {
            sInstance = config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ApplicationConfig $$robo$$android_security_net_config_ApplicationConfig$getDefaultInstance() {
        Object object = sLock;
        synchronized (object) {
            return sInstance;
        }
    }

    static void __staticInitializer__() {
        sLock = new Object();
    }

    private void __constructor__(ConfigSource configSource) {
        this.$$robo$$android_security_net_config_ApplicationConfig$__constructor__(configSource);
    }

    public ApplicationConfig(ConfigSource configSource) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_net_config_ApplicationConfig$__constructor__(android.security.net.config.ConfigSource ), 0, this, configSource);
    }

    public boolean hasPerDomainConfigs() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPerDomainConfigs", $$robo$$android_security_net_config_ApplicationConfig$hasPerDomainConfigs(), 0, this);
    }

    public NetworkSecurityConfig getConfigForHostname(String string2) {
        return InvokeDynamicSupport.bootstrap("getConfigForHostname", $$robo$$android_security_net_config_ApplicationConfig$getConfigForHostname(java.lang.String ), 0, this, string2);
    }

    public X509TrustManager getTrustManager() {
        return InvokeDynamicSupport.bootstrap("getTrustManager", $$robo$$android_security_net_config_ApplicationConfig$getTrustManager(), 0, this);
    }

    public boolean isCleartextTrafficPermitted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCleartextTrafficPermitted", $$robo$$android_security_net_config_ApplicationConfig$isCleartextTrafficPermitted(), 0, this);
    }

    public boolean isCleartextTrafficPermitted(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCleartextTrafficPermitted", $$robo$$android_security_net_config_ApplicationConfig$isCleartextTrafficPermitted(java.lang.String ), 0, this, string2);
    }

    public void handleTrustStorageUpdate() {
        InvokeDynamicSupport.bootstrap("handleTrustStorageUpdate", $$robo$$android_security_net_config_ApplicationConfig$handleTrustStorageUpdate(), 0, this);
    }

    private void ensureInitialized() {
        InvokeDynamicSupport.bootstrap("ensureInitialized", $$robo$$android_security_net_config_ApplicationConfig$ensureInitialized(), 0, this);
    }

    public static void setDefaultInstance(ApplicationConfig applicationConfig) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultInstance", $$robo$$android_security_net_config_ApplicationConfig$setDefaultInstance(android.security.net.config.ApplicationConfig ), 0, (ApplicationConfig)applicationConfig);
    }

    public static ApplicationConfig getDefaultInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultInstance", $$robo$$android_security_net_config_ApplicationConfig$getDefaultInstance(), 0);
    }

    static {
        RobolectricInternals.classInitializing(ApplicationConfig.class);
    }

    public /* synthetic */ ApplicationConfig() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApplicationConfig)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

