/*
 * Decompiled with CFR 0.152.
 */
package android.service.textservice;

import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.text.TextUtils;
import android.text.method.WordIterator;
import android.view.textservice.SentenceSuggestionsInfo;
import android.view.textservice.SuggestionsInfo;
import android.view.textservice.TextInfo;
import com.android.internal.textservice.ISpellCheckerService;
import com.android.internal.textservice.ISpellCheckerSession;
import com.android.internal.textservice.ISpellCheckerSessionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class SpellCheckerService
extends Service
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DBG = false;
    public static String SERVICE_INTERFACE = "android.service.textservice.SpellCheckerService";
    private SpellCheckerServiceBinder mBinder;

    private void $$robo$$android_service_textservice_SpellCheckerService$__constructor__() {
        this.mBinder = new SpellCheckerServiceBinder(this);
    }

    private final IBinder $$robo$$android_service_textservice_SpellCheckerService$onBind(Intent intent) {
        return this.mBinder;
    }

    public abstract Session createSession();

    static void __staticInitializer__() {
        TAG = SpellCheckerService.class.getSimpleName();
    }

    private void __constructor__() {
        this.$$robo$$android_service_textservice_SpellCheckerService$__constructor__();
    }

    public SpellCheckerService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_textservice_SpellCheckerService$__constructor__(), 0, this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_service_textservice_SpellCheckerService$onBind(android.content.Intent ), 0, this, intent);
    }

    static {
        RobolectricInternals.classInitializing(SpellCheckerService.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpellCheckerService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class SentenceLevelAdapter
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static SentenceSuggestionsInfo[] EMPTY_SENTENCE_SUGGESTIONS_INFOS;
        private static SuggestionsInfo EMPTY_SUGGESTIONS_INFO;
        private WordIterator mWordIterator;

        private void $$robo$$android_service_textservice_SpellCheckerService_SentenceLevelAdapter$__constructor__(Locale locale) {
            this.mWordIterator = new WordIterator(locale);
        }

        private final SentenceTextInfoParams $$robo$$android_service_textservice_SpellCheckerService_SentenceLevelAdapter$getSplitWords(TextInfo originalTextInfo) {
            WordIterator wordIterator = this.mWordIterator;
            String originalText = originalTextInfo.getText();
            int cookie = originalTextInfo.getCookie();
            boolean start = false;
            int end = originalText.length();
            ArrayList<SentenceWordItem> wordItems = new ArrayList<SentenceWordItem>();
            wordIterator.setCharSequence(originalText, 0, originalText.length());
            int wordEnd = wordIterator.following(0);
            int wordStart = wordIterator.getBeginning(wordEnd);
            while (wordStart <= end && wordEnd != -1 && wordStart != -1) {
                if (wordEnd >= 0 && wordEnd > wordStart) {
                    CharSequence query = originalText.subSequence(wordStart, wordEnd);
                    TextInfo ti = new TextInfo(query, 0, query.length(), cookie, query.hashCode());
                    wordItems.add(new SentenceWordItem(ti, wordStart, wordEnd));
                }
                if ((wordEnd = wordIterator.following(wordEnd)) == -1) break;
                wordStart = wordIterator.getBeginning(wordEnd);
            }
            return new SentenceTextInfoParams(originalTextInfo, wordItems);
        }

        private static final SentenceSuggestionsInfo $$robo$$android_service_textservice_SpellCheckerService_SentenceLevelAdapter$reconstructSuggestions(SentenceTextInfoParams originalTextInfoParams, SuggestionsInfo[] results) {
            if (results == null || results.length == 0) {
                return null;
            }
            if (originalTextInfoParams == null) {
                return null;
            }
            int originalCookie = originalTextInfoParams.mOriginalTextInfo.getCookie();
            int originalSequence = originalTextInfoParams.mOriginalTextInfo.getSequence();
            int querySize = originalTextInfoParams.mSize;
            int[] offsets = new int[querySize];
            int[] lengths = new int[querySize];
            SuggestionsInfo[] reconstructedSuggestions = new SuggestionsInfo[querySize];
            for (int i = 0; i < querySize; ++i) {
                SentenceWordItem item = originalTextInfoParams.mItems.get(i);
                SuggestionsInfo result = null;
                for (int j = 0; j < results.length; ++j) {
                    SuggestionsInfo cur = results[j];
                    if (cur == null || cur.getSequence() != item.mTextInfo.getSequence()) continue;
                    result = cur;
                    result.setCookieAndSequence(originalCookie, originalSequence);
                    break;
                }
                offsets[i] = item.mStart;
                lengths[i] = item.mLength;
                reconstructedSuggestions[i] = result != null ? result : EMPTY_SUGGESTIONS_INFO;
            }
            return new SentenceSuggestionsInfo(reconstructedSuggestions, offsets, lengths);
        }

        static void __staticInitializer__() {
            EMPTY_SENTENCE_SUGGESTIONS_INFOS = new SentenceSuggestionsInfo[0];
            EMPTY_SUGGESTIONS_INFO = new SuggestionsInfo(0, null);
        }

        private void __constructor__(Locale locale) {
            this.$$robo$$android_service_textservice_SpellCheckerService_SentenceLevelAdapter$__constructor__(locale);
        }

        public SentenceLevelAdapter(Locale locale) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_textservice_SpellCheckerService_SentenceLevelAdapter$__constructor__(java.util.Locale ), 0, this, locale);
        }

        private SentenceTextInfoParams getSplitWords(TextInfo textInfo) {
            return InvokeDynamicSupport.bootstrap("getSplitWords", $$robo$$android_service_textservice_SpellCheckerService_SentenceLevelAdapter$getSplitWords(android.view.textservice.TextInfo ), 0, this, textInfo);
        }

        public static SentenceSuggestionsInfo reconstructSuggestions(SentenceTextInfoParams sentenceTextInfoParams, SuggestionsInfo[] suggestionsInfoArray) {
            return InvokeDynamicSupport.bootstrapStatic("reconstructSuggestions", $$robo$$android_service_textservice_SpellCheckerService_SentenceLevelAdapter$reconstructSuggestions(android.service.textservice.SpellCheckerService$SentenceLevelAdapter$SentenceTextInfoParams android.view.textservice.SuggestionsInfo[] ), 0, (SentenceTextInfoParams)sentenceTextInfoParams, (SuggestionsInfo[])suggestionsInfoArray);
        }

        static {
            RobolectricInternals.classInitializing(SentenceLevelAdapter.class);
        }

        public /* synthetic */ SentenceLevelAdapter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SentenceLevelAdapter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class SentenceTextInfoParams
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            TextInfo mOriginalTextInfo;
            ArrayList<SentenceWordItem> mItems;
            int mSize;

            private void $$robo$$android_service_textservice_SpellCheckerService_SentenceLevelAdapter_SentenceTextInfoParams$__constructor__(TextInfo ti, ArrayList<SentenceWordItem> items) {
                this.mOriginalTextInfo = ti;
                this.mItems = items;
                this.mSize = items.size();
            }

            private void __constructor__(TextInfo textInfo, ArrayList<SentenceWordItem> arrayList) {
                this.$$robo$$android_service_textservice_SpellCheckerService_SentenceLevelAdapter_SentenceTextInfoParams$__constructor__(textInfo, arrayList);
            }

            public SentenceTextInfoParams(TextInfo textInfo, ArrayList<SentenceWordItem> arrayList) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_textservice_SpellCheckerService_SentenceLevelAdapter_SentenceTextInfoParams$__constructor__(android.view.textservice.TextInfo java.util.ArrayList<android.service.textservice.SpellCheckerService$SentenceLevelAdapter$SentenceWordItem> ), 0, this, textInfo, arrayList);
            }

            public /* synthetic */ SentenceTextInfoParams() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SentenceTextInfoParams)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static class SentenceWordItem
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            public TextInfo mTextInfo;
            public int mStart;
            public int mLength;

            private void $$robo$$android_service_textservice_SpellCheckerService_SentenceLevelAdapter_SentenceWordItem$__constructor__(TextInfo ti, int start, int end) {
                this.mTextInfo = ti;
                this.mStart = start;
                this.mLength = end - start;
            }

            private void __constructor__(TextInfo textInfo, int n, int n2) {
                this.$$robo$$android_service_textservice_SpellCheckerService_SentenceLevelAdapter_SentenceWordItem$__constructor__(textInfo, n, n2);
            }

            public SentenceWordItem(TextInfo textInfo, int n, int n2) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_textservice_SpellCheckerService_SentenceLevelAdapter_SentenceWordItem$__constructor__(android.view.textservice.TextInfo int int ), 0, this, textInfo, n, n2);
            }

            public /* synthetic */ SentenceWordItem() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SentenceWordItem)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    private static class SpellCheckerServiceBinder
    extends ISpellCheckerService.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<SpellCheckerService> mInternalServiceRef;

        private void $$robo$$android_service_textservice_SpellCheckerService_SpellCheckerServiceBinder$__constructor__(SpellCheckerService service) {
            this.mInternalServiceRef = new WeakReference<SpellCheckerService>(service);
        }

        private final ISpellCheckerSession $$robo$$android_service_textservice_SpellCheckerService_SpellCheckerServiceBinder$getISpellCheckerSession(String locale, ISpellCheckerSessionListener listener, Bundle bundle) {
            SpellCheckerService service = (SpellCheckerService)this.mInternalServiceRef.get();
            if (service == null) {
                return null;
            }
            Session session = service.createSession();
            InternalISpellCheckerSession internalSession = new InternalISpellCheckerSession(locale, listener, bundle, session);
            session.onCreate();
            return internalSession;
        }

        private void __constructor__(SpellCheckerService spellCheckerService) {
            this.$$robo$$android_service_textservice_SpellCheckerService_SpellCheckerServiceBinder$__constructor__(spellCheckerService);
        }

        public SpellCheckerServiceBinder(SpellCheckerService spellCheckerService) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_textservice_SpellCheckerService_SpellCheckerServiceBinder$__constructor__(android.service.textservice.SpellCheckerService ), 0, this, spellCheckerService);
        }

        @Override
        public ISpellCheckerSession getISpellCheckerSession(String string2, ISpellCheckerSessionListener iSpellCheckerSessionListener, Bundle bundle) {
            return InvokeDynamicSupport.bootstrap("getISpellCheckerSession", $$robo$$android_service_textservice_SpellCheckerService_SpellCheckerServiceBinder$getISpellCheckerSession(java.lang.String com.android.internal.textservice.ISpellCheckerSessionListener android.os.Bundle ), 0, this, string2, iSpellCheckerSessionListener, bundle);
        }

        public /* synthetic */ SpellCheckerServiceBinder() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpellCheckerServiceBinder)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class InternalISpellCheckerSession
    extends ISpellCheckerSession.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ISpellCheckerSessionListener mListener;
        private Session mSession;
        private String mLocale;
        private Bundle mBundle;

        private void $$robo$$android_service_textservice_SpellCheckerService_InternalISpellCheckerSession$__constructor__(String locale, ISpellCheckerSessionListener listener, Bundle bundle, Session session) {
            this.mListener = listener;
            this.mSession = session;
            this.mLocale = locale;
            this.mBundle = bundle;
            session.setInternalISpellCheckerSession(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_service_textservice_SpellCheckerService_InternalISpellCheckerSession$onGetSuggestionsMultiple(TextInfo[] textInfos, int suggestionsLimit, boolean sequentialWords) {
            int pri = Process.getThreadPriority(Process.myTid());
            try {
                Process.setThreadPriority(10);
                this.mListener.onGetSuggestions(this.mSession.onGetSuggestionsMultiple(textInfos, suggestionsLimit, sequentialWords));
            }
            catch (RemoteException remoteException) {
            }
            finally {
                Process.setThreadPriority(pri);
            }
        }

        private final void $$robo$$android_service_textservice_SpellCheckerService_InternalISpellCheckerSession$onGetSentenceSuggestionsMultiple(TextInfo[] textInfos, int suggestionsLimit) {
            try {
                this.mListener.onGetSentenceSuggestions(this.mSession.onGetSentenceSuggestionsMultiple(textInfos, suggestionsLimit));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_service_textservice_SpellCheckerService_InternalISpellCheckerSession$onCancel() {
            int pri = Process.getThreadPriority(Process.myTid());
            try {
                Process.setThreadPriority(10);
                this.mSession.onCancel();
            }
            finally {
                Process.setThreadPriority(pri);
            }
        }

        private final void $$robo$$android_service_textservice_SpellCheckerService_InternalISpellCheckerSession$onClose() {
            int pri = Process.getThreadPriority(Process.myTid());
            try {
                Process.setThreadPriority(10);
                this.mSession.onClose();
            }
            finally {
                Process.setThreadPriority(pri);
                this.mListener = null;
            }
        }

        private final String $$robo$$android_service_textservice_SpellCheckerService_InternalISpellCheckerSession$getLocale() {
            return this.mLocale;
        }

        private final Bundle $$robo$$android_service_textservice_SpellCheckerService_InternalISpellCheckerSession$getBundle() {
            return this.mBundle;
        }

        private void __constructor__(String string2, ISpellCheckerSessionListener iSpellCheckerSessionListener, Bundle bundle, Session session) {
            this.$$robo$$android_service_textservice_SpellCheckerService_InternalISpellCheckerSession$__constructor__(string2, iSpellCheckerSessionListener, bundle, session);
        }

        public InternalISpellCheckerSession(String string2, ISpellCheckerSessionListener iSpellCheckerSessionListener, Bundle bundle, Session session) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_textservice_SpellCheckerService_InternalISpellCheckerSession$__constructor__(java.lang.String com.android.internal.textservice.ISpellCheckerSessionListener android.os.Bundle android.service.textservice.SpellCheckerService$Session ), 0, this, string2, iSpellCheckerSessionListener, bundle, session);
        }

        @Override
        public void onGetSuggestionsMultiple(TextInfo[] textInfoArray, int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("onGetSuggestionsMultiple", $$robo$$android_service_textservice_SpellCheckerService_InternalISpellCheckerSession$onGetSuggestionsMultiple(android.view.textservice.TextInfo[] int boolean ), 0, this, textInfoArray, n, bl);
        }

        @Override
        public void onGetSentenceSuggestionsMultiple(TextInfo[] textInfoArray, int n) {
            InvokeDynamicSupport.bootstrap("onGetSentenceSuggestionsMultiple", $$robo$$android_service_textservice_SpellCheckerService_InternalISpellCheckerSession$onGetSentenceSuggestionsMultiple(android.view.textservice.TextInfo[] int ), 0, this, textInfoArray, n);
        }

        @Override
        public void onCancel() {
            InvokeDynamicSupport.bootstrap("onCancel", $$robo$$android_service_textservice_SpellCheckerService_InternalISpellCheckerSession$onCancel(), 0, this);
        }

        @Override
        public void onClose() {
            InvokeDynamicSupport.bootstrap("onClose", $$robo$$android_service_textservice_SpellCheckerService_InternalISpellCheckerSession$onClose(), 0, this);
        }

        public String getLocale() {
            return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_service_textservice_SpellCheckerService_InternalISpellCheckerSession$getLocale(), 0, this);
        }

        public Bundle getBundle() {
            return InvokeDynamicSupport.bootstrap("getBundle", $$robo$$android_service_textservice_SpellCheckerService_InternalISpellCheckerSession$getBundle(), 0, this);
        }

        public /* synthetic */ InternalISpellCheckerSession() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InternalISpellCheckerSession)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Session
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private InternalISpellCheckerSession mInternalSession;
        private volatile SentenceLevelAdapter mSentenceLevelAdapter;

        private void $$robo$$android_service_textservice_SpellCheckerService_Session$__constructor__() {
        }

        private final void $$robo$$android_service_textservice_SpellCheckerService_Session$setInternalISpellCheckerSession(InternalISpellCheckerSession session) {
            this.mInternalSession = session;
        }

        public abstract void onCreate();

        public abstract SuggestionsInfo onGetSuggestions(TextInfo var1, int var2);

        private final SuggestionsInfo[] $$robo$$android_service_textservice_SpellCheckerService_Session$onGetSuggestionsMultiple(TextInfo[] textInfos, int suggestionsLimit, boolean sequentialWords) {
            int length = textInfos.length;
            SuggestionsInfo[] retval = new SuggestionsInfo[length];
            for (int i = 0; i < length; ++i) {
                retval[i] = this.onGetSuggestions(textInfos[i], suggestionsLimit);
                retval[i].setCookieAndSequence(textInfos[i].getCookie(), textInfos[i].getSequence());
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final SentenceSuggestionsInfo[] $$robo$$android_service_textservice_SpellCheckerService_Session$onGetSentenceSuggestionsMultiple(TextInfo[] textInfos, int suggestionsLimit) {
            if (textInfos == null || textInfos.length == 0) {
                return SentenceLevelAdapter.EMPTY_SENTENCE_SUGGESTIONS_INFOS;
            }
            if (this.mSentenceLevelAdapter == null) {
                Session session = this;
                synchronized (session) {
                    String localeStr;
                    if (this.mSentenceLevelAdapter == null && !TextUtils.isEmpty(localeStr = this.getLocale())) {
                        this.mSentenceLevelAdapter = new SentenceLevelAdapter(new Locale(localeStr));
                    }
                }
            }
            if (this.mSentenceLevelAdapter == null) {
                return SentenceLevelAdapter.EMPTY_SENTENCE_SUGGESTIONS_INFOS;
            }
            int infosSize = textInfos.length;
            SentenceSuggestionsInfo[] retval = new SentenceSuggestionsInfo[infosSize];
            for (int i = 0; i < infosSize; ++i) {
                SentenceLevelAdapter.SentenceTextInfoParams textInfoParams = this.mSentenceLevelAdapter.getSplitWords(textInfos[i]);
                ArrayList<SentenceLevelAdapter.SentenceWordItem> mItems = textInfoParams.mItems;
                int itemsSize = mItems.size();
                TextInfo[] splitTextInfos = new TextInfo[itemsSize];
                for (int j = 0; j < itemsSize; ++j) {
                    splitTextInfos[j] = mItems.get((int)j).mTextInfo;
                }
                retval[i] = SentenceLevelAdapter.reconstructSuggestions(textInfoParams, this.onGetSuggestionsMultiple(splitTextInfos, suggestionsLimit, true));
            }
            return retval;
        }

        private final void $$robo$$android_service_textservice_SpellCheckerService_Session$onCancel() {
        }

        private final void $$robo$$android_service_textservice_SpellCheckerService_Session$onClose() {
        }

        private final String $$robo$$android_service_textservice_SpellCheckerService_Session$getLocale() {
            return this.mInternalSession.getLocale();
        }

        private final Bundle $$robo$$android_service_textservice_SpellCheckerService_Session$getBundle() {
            return this.mInternalSession.getBundle();
        }

        private void __constructor__() {
            this.$$robo$$android_service_textservice_SpellCheckerService_Session$__constructor__();
        }

        public Session() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_textservice_SpellCheckerService_Session$__constructor__(), 0, this);
        }

        public void setInternalISpellCheckerSession(InternalISpellCheckerSession internalISpellCheckerSession) {
            InvokeDynamicSupport.bootstrap("setInternalISpellCheckerSession", $$robo$$android_service_textservice_SpellCheckerService_Session$setInternalISpellCheckerSession(android.service.textservice.SpellCheckerService$InternalISpellCheckerSession ), 0, this, internalISpellCheckerSession);
        }

        public SuggestionsInfo[] onGetSuggestionsMultiple(TextInfo[] textInfoArray, int n, boolean bl) {
            return InvokeDynamicSupport.bootstrap("onGetSuggestionsMultiple", $$robo$$android_service_textservice_SpellCheckerService_Session$onGetSuggestionsMultiple(android.view.textservice.TextInfo[] int boolean ), 0, this, textInfoArray, n, bl);
        }

        public SentenceSuggestionsInfo[] onGetSentenceSuggestionsMultiple(TextInfo[] textInfoArray, int n) {
            return InvokeDynamicSupport.bootstrap("onGetSentenceSuggestionsMultiple", $$robo$$android_service_textservice_SpellCheckerService_Session$onGetSentenceSuggestionsMultiple(android.view.textservice.TextInfo[] int ), 0, this, textInfoArray, n);
        }

        public void onCancel() {
            InvokeDynamicSupport.bootstrap("onCancel", $$robo$$android_service_textservice_SpellCheckerService_Session$onCancel(), 0, this);
        }

        public void onClose() {
            InvokeDynamicSupport.bootstrap("onClose", $$robo$$android_service_textservice_SpellCheckerService_Session$onClose(), 0, this);
        }

        public String getLocale() {
            return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_service_textservice_SpellCheckerService_Session$getLocale(), 0, this);
        }

        public Bundle getBundle() {
            return InvokeDynamicSupport.bootstrap("getBundle", $$robo$$android_service_textservice_SpellCheckerService_Session$getBundle(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Session)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

