/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.Xml;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class VoiceInteractionServiceInfo
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "VoiceInteractionServiceInfo";
    private String mParseError;
    private ServiceInfo mServiceInfo;
    private String mSessionService;
    private String mRecognitionService;
    private String mSettingsActivity;
    private boolean mSupportsAssist;
    private boolean mSupportsLaunchFromKeyguard;
    private boolean mSupportsLocalInteraction;

    private void $$robo$$android_service_voice_VoiceInteractionServiceInfo$__constructor__(PackageManager pm, ComponentName comp) throws PackageManager.NameNotFoundException {
    }

    private void $$robo$$android_service_voice_VoiceInteractionServiceInfo$__constructor__(PackageManager pm, ComponentName comp, int userHandle) throws PackageManager.NameNotFoundException {
    }

    private static final ServiceInfo $$robo$$android_service_voice_VoiceInteractionServiceInfo$getServiceInfoOrThrow(ComponentName comp, int userHandle) throws PackageManager.NameNotFoundException {
        try {
            ServiceInfo si = AppGlobals.getPackageManager().getServiceInfo(comp, 269222016, userHandle);
            if (si != null) {
                return si;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        throw new PackageManager.NameNotFoundException(comp.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_service_voice_VoiceInteractionServiceInfo$__constructor__(PackageManager pm, ServiceInfo si) {
        if (si == null) {
            this.mParseError = "Service not available";
            return;
        }
        if (!"android.permission.BIND_VOICE_INTERACTION".equals(si.permission)) {
            this.mParseError = "Service does not require permission android.permission.BIND_VOICE_INTERACTION";
            return;
        }
        try (XmlResourceParser parser = null;){
            int type;
            parser = si.loadXmlMetaData(pm, "android.voice_interaction");
            if (parser == null) {
                this.mParseError = "No android.voice_interaction meta-data for " + si.packageName;
                return;
            }
            Resources res = pm.getResourcesForApplication(si.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"voice-interaction-service".equals(nodeName)) {
                this.mParseError = "Meta-data does not start with voice-interaction-service tag";
                return;
            }
            TypedArray array2 = res.obtainAttributes(attrs, R.styleable.VoiceInteractionService);
            this.mSessionService = array2.getString(1);
            this.mRecognitionService = array2.getString(2);
            this.mSettingsActivity = array2.getString(0);
            this.mSupportsAssist = array2.getBoolean(3, false);
            this.mSupportsLaunchFromKeyguard = array2.getBoolean(4, false);
            this.mSupportsLocalInteraction = array2.getBoolean(5, false);
            array2.recycle();
            if (this.mSessionService == null) {
                this.mParseError = "No sessionService specified";
                return;
            }
            if (this.mRecognitionService == null) {
                this.mParseError = "No recognitionService specified";
                return;
            }
        }
        this.mServiceInfo = si;
    }

    private final String $$robo$$android_service_voice_VoiceInteractionServiceInfo$getParseError() {
        return this.mParseError;
    }

    private final ServiceInfo $$robo$$android_service_voice_VoiceInteractionServiceInfo$getServiceInfo() {
        return this.mServiceInfo;
    }

    private final String $$robo$$android_service_voice_VoiceInteractionServiceInfo$getSessionService() {
        return this.mSessionService;
    }

    private final String $$robo$$android_service_voice_VoiceInteractionServiceInfo$getRecognitionService() {
        return this.mRecognitionService;
    }

    private final String $$robo$$android_service_voice_VoiceInteractionServiceInfo$getSettingsActivity() {
        return this.mSettingsActivity;
    }

    private final boolean $$robo$$android_service_voice_VoiceInteractionServiceInfo$getSupportsAssist() {
        return this.mSupportsAssist;
    }

    private final boolean $$robo$$android_service_voice_VoiceInteractionServiceInfo$getSupportsLaunchFromKeyguard() {
        return this.mSupportsLaunchFromKeyguard;
    }

    private final boolean $$robo$$android_service_voice_VoiceInteractionServiceInfo$getSupportsLocalInteraction() {
        return this.mSupportsLocalInteraction;
    }

    private void __constructor__(PackageManager packageManager, ComponentName componentName) throws PackageManager.NameNotFoundException {
        this.$$robo$$android_service_voice_VoiceInteractionServiceInfo$__constructor__(packageManager, componentName);
    }

    public VoiceInteractionServiceInfo(PackageManager packageManager, ComponentName componentName) throws PackageManager.NameNotFoundException {
        this(packageManager, packageManager.getServiceInfo(componentName, 128));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_voice_VoiceInteractionServiceInfo$__constructor__(android.content.pm.PackageManager android.content.ComponentName ), 0, this, packageManager, componentName);
    }

    private void __constructor__(PackageManager packageManager, ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
        this.$$robo$$android_service_voice_VoiceInteractionServiceInfo$__constructor__(packageManager, componentName, n);
    }

    public VoiceInteractionServiceInfo(PackageManager packageManager, ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
        this(packageManager, VoiceInteractionServiceInfo.getServiceInfoOrThrow(componentName, n));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_voice_VoiceInteractionServiceInfo$__constructor__(android.content.pm.PackageManager android.content.ComponentName int ), 0, this, packageManager, componentName, n);
    }

    static ServiceInfo getServiceInfoOrThrow(ComponentName componentName, int n) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("getServiceInfoOrThrow", $$robo$$android_service_voice_VoiceInteractionServiceInfo$getServiceInfoOrThrow(android.content.ComponentName int ), 0, (ComponentName)componentName, (int)n);
    }

    private void __constructor__(PackageManager packageManager, ServiceInfo serviceInfo) {
        this.$$robo$$android_service_voice_VoiceInteractionServiceInfo$__constructor__(packageManager, serviceInfo);
    }

    public VoiceInteractionServiceInfo(PackageManager packageManager, ServiceInfo serviceInfo) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_voice_VoiceInteractionServiceInfo$__constructor__(android.content.pm.PackageManager android.content.pm.ServiceInfo ), 0, this, packageManager, serviceInfo);
    }

    public String getParseError() {
        return InvokeDynamicSupport.bootstrap("getParseError", $$robo$$android_service_voice_VoiceInteractionServiceInfo$getParseError(), 0, this);
    }

    public ServiceInfo getServiceInfo() {
        return InvokeDynamicSupport.bootstrap("getServiceInfo", $$robo$$android_service_voice_VoiceInteractionServiceInfo$getServiceInfo(), 0, this);
    }

    public String getSessionService() {
        return InvokeDynamicSupport.bootstrap("getSessionService", $$robo$$android_service_voice_VoiceInteractionServiceInfo$getSessionService(), 0, this);
    }

    public String getRecognitionService() {
        return InvokeDynamicSupport.bootstrap("getRecognitionService", $$robo$$android_service_voice_VoiceInteractionServiceInfo$getRecognitionService(), 0, this);
    }

    public String getSettingsActivity() {
        return InvokeDynamicSupport.bootstrap("getSettingsActivity", $$robo$$android_service_voice_VoiceInteractionServiceInfo$getSettingsActivity(), 0, this);
    }

    public boolean getSupportsAssist() {
        return (boolean)InvokeDynamicSupport.bootstrap("getSupportsAssist", $$robo$$android_service_voice_VoiceInteractionServiceInfo$getSupportsAssist(), 0, this);
    }

    public boolean getSupportsLaunchFromKeyguard() {
        return (boolean)InvokeDynamicSupport.bootstrap("getSupportsLaunchFromKeyguard", $$robo$$android_service_voice_VoiceInteractionServiceInfo$getSupportsLaunchFromKeyguard(), 0, this);
    }

    public boolean getSupportsLocalInteraction() {
        return (boolean)InvokeDynamicSupport.bootstrap("getSupportsLocalInteraction", $$robo$$android_service_voice_VoiceInteractionServiceInfo$getSupportsLocalInteraction(), 0, this);
    }

    public /* synthetic */ VoiceInteractionServiceInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VoiceInteractionServiceInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

