/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.media.AudioFormat;
import android.media.AudioTrack;
import android.speech.tts.TextToSpeechService;
import android.util.Log;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BlockingAudioTrack
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "TTS.BlockingAudioTrack";
    private static boolean DBG = false;
    private static long MIN_SLEEP_TIME_MS = 20L;
    private static long MAX_SLEEP_TIME_MS = 2500L;
    private static long MAX_PROGRESS_WAIT_MS = 2500L;
    private static int MIN_AUDIO_BUFFER_SIZE = 8192;
    private TextToSpeechService.AudioOutputParams mAudioParams;
    private int mSampleRateInHz;
    private int mAudioFormat;
    private int mChannelCount;
    private int mBytesPerFrame;
    private boolean mIsShortUtterance;
    private int mAudioBufferSize;
    private int mBytesWritten;
    private Object mAudioTrackLock;
    private AudioTrack mAudioTrack;
    private volatile boolean mStopped;
    private int mSessionId;

    private void $$robo$$android_speech_tts_BlockingAudioTrack$__constructor__(TextToSpeechService.AudioOutputParams audioParams, int sampleRate, int audioFormat, int channelCount) {
        this.mBytesWritten = 0;
        this.mAudioTrackLock = new Object();
        this.mAudioParams = audioParams;
        this.mSampleRateInHz = sampleRate;
        this.mAudioFormat = audioFormat;
        this.mChannelCount = channelCount;
        this.mBytesPerFrame = AudioFormat.getBytesPerSample(this.mAudioFormat) * this.mChannelCount;
        this.mIsShortUtterance = false;
        this.mAudioBufferSize = 0;
        this.mBytesWritten = 0;
        this.mAudioTrack = null;
        this.mStopped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_speech_tts_BlockingAudioTrack$init() {
        AudioTrack track = this.createStreamingAudioTrack();
        Object object = this.mAudioTrackLock;
        synchronized (object) {
            this.mAudioTrack = track;
        }
        return track != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_speech_tts_BlockingAudioTrack$stop() {
        Object object = this.mAudioTrackLock;
        synchronized (object) {
            if (this.mAudioTrack != null) {
                this.mAudioTrack.stop();
            }
            this.mStopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_speech_tts_BlockingAudioTrack$write(byte[] data) {
        AudioTrack track = null;
        Object object = this.mAudioTrackLock;
        synchronized (object) {
            track = this.mAudioTrack;
        }
        if (track == null || this.mStopped) {
            return -1;
        }
        int bytesWritten = BlockingAudioTrack.writeToAudioTrack(track, data);
        this.mBytesWritten += bytesWritten;
        return bytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_speech_tts_BlockingAudioTrack$waitAndRelease() {
        AudioTrack track = null;
        Object object = this.mAudioTrackLock;
        synchronized (object) {
            track = this.mAudioTrack;
        }
        if (track == null) {
            return;
        }
        if (this.mBytesWritten < this.mAudioBufferSize && !this.mStopped) {
            this.mIsShortUtterance = true;
            track.stop();
        }
        if (!this.mStopped) {
            this.blockUntilDone(this.mAudioTrack);
        }
        object = this.mAudioTrackLock;
        synchronized (object) {
            this.mAudioTrack = null;
        }
        track.release();
    }

    private static final int $$robo$$android_speech_tts_BlockingAudioTrack$getChannelConfig(int channelCount) {
        if (channelCount == 1) {
            return 4;
        }
        if (channelCount == 2) {
            return 12;
        }
        return 0;
    }

    private final long $$robo$$android_speech_tts_BlockingAudioTrack$getAudioLengthMs(int numBytes) {
        int unconsumedFrames = numBytes / this.mBytesPerFrame;
        long estimatedTimeMs = unconsumedFrames * 1000 / this.mSampleRateInHz;
        return estimatedTimeMs;
    }

    private static final int $$robo$$android_speech_tts_BlockingAudioTrack$writeToAudioTrack(AudioTrack audioTrack, byte[] bytes) {
        int count;
        int written;
        if (audioTrack.getPlayState() != 3) {
            audioTrack.play();
        }
        for (count = 0; count < bytes.length && (written = audioTrack.write(bytes, count, bytes.length)) > 0; count += written) {
        }
        return count;
    }

    private final AudioTrack $$robo$$android_speech_tts_BlockingAudioTrack$createStreamingAudioTrack() {
        int channelConfig = BlockingAudioTrack.getChannelConfig(this.mChannelCount);
        int minBufferSizeInBytes = AudioTrack.getMinBufferSize(this.mSampleRateInHz, channelConfig, this.mAudioFormat);
        int bufferSizeInBytes = Math.max(8192, minBufferSizeInBytes);
        AudioFormat audioFormat = new AudioFormat.Builder().setChannelMask(channelConfig).setEncoding(this.mAudioFormat).setSampleRate(this.mSampleRateInHz).build();
        AudioTrack audioTrack = new AudioTrack(this.mAudioParams.mAudioAttributes, audioFormat, bufferSizeInBytes, 1, this.mAudioParams.mSessionId);
        if (audioTrack.getState() != 1) {
            Log.w("TTS.BlockingAudioTrack", "Unable to create audio track.");
            audioTrack.release();
            return null;
        }
        this.mAudioBufferSize = bufferSizeInBytes;
        BlockingAudioTrack.setupVolume(audioTrack, this.mAudioParams.mVolume, this.mAudioParams.mPan);
        return audioTrack;
    }

    private final void $$robo$$android_speech_tts_BlockingAudioTrack$blockUntilDone(AudioTrack audioTrack) {
        if (this.mBytesWritten <= 0) {
            return;
        }
        if (this.mIsShortUtterance) {
            this.blockUntilEstimatedCompletion();
        } else {
            this.blockUntilCompletion(audioTrack);
        }
    }

    private final void $$robo$$android_speech_tts_BlockingAudioTrack$blockUntilEstimatedCompletion() {
        int lengthInFrames = this.mBytesWritten / this.mBytesPerFrame;
        long estimatedTimeMs = lengthInFrames * 1000 / this.mSampleRateInHz;
        try {
            Thread.sleep(estimatedTimeMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_speech_tts_BlockingAudioTrack$blockUntilCompletion(AudioTrack audioTrack) {
        int lengthInFrames = this.mBytesWritten / this.mBytesPerFrame;
        int previousPosition = -1;
        int currentPosition = 0;
        long blockedTimeMs = 0L;
        while ((currentPosition = audioTrack.getPlaybackHeadPosition()) < lengthInFrames && audioTrack.getPlayState() == 3 && !this.mStopped) {
            long estimatedTimeMs = (lengthInFrames - currentPosition) * 1000 / audioTrack.getSampleRate();
            long sleepTimeMs = BlockingAudioTrack.clip(estimatedTimeMs, 20L, 2500L);
            if (currentPosition == previousPosition) {
                if ((blockedTimeMs += sleepTimeMs) > 2500L) {
                    Log.w("TTS.BlockingAudioTrack", "Waited unsuccessfully for 2500ms for AudioTrack to make progress, Aborting");
                    break;
                }
            } else {
                blockedTimeMs = 0L;
            }
            previousPosition = currentPosition;
            try {
                Thread.sleep(sleepTimeMs);
            }
            catch (InterruptedException ie) {
                break;
            }
        }
    }

    private static final void $$robo$$android_speech_tts_BlockingAudioTrack$setupVolume(AudioTrack audioTrack, float volume, float pan) {
        float vol = BlockingAudioTrack.clip(volume, 0.0f, 1.0f);
        float panning = BlockingAudioTrack.clip(pan, -1.0f, 1.0f);
        float volLeft = vol;
        float volRight = vol;
        if (panning > 0.0f) {
            volLeft *= 1.0f - panning;
        } else if (panning < 0.0f) {
            volRight *= 1.0f + panning;
        }
        if (audioTrack.setStereoVolume(volLeft, volRight) != 0) {
            Log.e("TTS.BlockingAudioTrack", "Failed to set volume");
        }
    }

    private static final long $$robo$$android_speech_tts_BlockingAudioTrack$clip(long value, long min, long max) {
        return value < min ? min : (value < max ? value : max);
    }

    private static final float $$robo$$android_speech_tts_BlockingAudioTrack$clip(float value, float min, float max) {
        return value < min ? min : (value < max ? value : max);
    }

    private void __constructor__(TextToSpeechService.AudioOutputParams audioOutputParams, int n, int n2, int n3) {
        this.$$robo$$android_speech_tts_BlockingAudioTrack$__constructor__(audioOutputParams, n, n2, n3);
    }

    BlockingAudioTrack(TextToSpeechService.AudioOutputParams audioOutputParams, int n, int n2, int n3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_BlockingAudioTrack$__constructor__(android.speech.tts.TextToSpeechService$AudioOutputParams int int int ), 0, this, audioOutputParams, n, n2, n3);
    }

    public boolean init() {
        return (boolean)InvokeDynamicSupport.bootstrap("init", $$robo$$android_speech_tts_BlockingAudioTrack$init(), 0, this);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_speech_tts_BlockingAudioTrack$stop(), 0, this);
    }

    public int write(byte[] byArray) {
        return (int)InvokeDynamicSupport.bootstrap("write", $$robo$$android_speech_tts_BlockingAudioTrack$write(byte[] ), 0, this, byArray);
    }

    public void waitAndRelease() {
        InvokeDynamicSupport.bootstrap("waitAndRelease", $$robo$$android_speech_tts_BlockingAudioTrack$waitAndRelease(), 0, this);
    }

    static int getChannelConfig(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getChannelConfig", $$robo$$android_speech_tts_BlockingAudioTrack$getChannelConfig(int ), 0, (int)n);
    }

    long getAudioLengthMs(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getAudioLengthMs", $$robo$$android_speech_tts_BlockingAudioTrack$getAudioLengthMs(int ), 0, this, n);
    }

    private static int writeToAudioTrack(AudioTrack audioTrack, byte[] byArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("writeToAudioTrack", $$robo$$android_speech_tts_BlockingAudioTrack$writeToAudioTrack(android.media.AudioTrack byte[] ), 0, (AudioTrack)audioTrack, (byte[])byArray);
    }

    private AudioTrack createStreamingAudioTrack() {
        return InvokeDynamicSupport.bootstrap("createStreamingAudioTrack", $$robo$$android_speech_tts_BlockingAudioTrack$createStreamingAudioTrack(), 0, this);
    }

    private void blockUntilDone(AudioTrack audioTrack) {
        InvokeDynamicSupport.bootstrap("blockUntilDone", $$robo$$android_speech_tts_BlockingAudioTrack$blockUntilDone(android.media.AudioTrack ), 0, this, audioTrack);
    }

    private void blockUntilEstimatedCompletion() {
        InvokeDynamicSupport.bootstrap("blockUntilEstimatedCompletion", $$robo$$android_speech_tts_BlockingAudioTrack$blockUntilEstimatedCompletion(), 0, this);
    }

    private void blockUntilCompletion(AudioTrack audioTrack) {
        InvokeDynamicSupport.bootstrap("blockUntilCompletion", $$robo$$android_speech_tts_BlockingAudioTrack$blockUntilCompletion(android.media.AudioTrack ), 0, this, audioTrack);
    }

    private static void setupVolume(AudioTrack audioTrack, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("setupVolume", $$robo$$android_speech_tts_BlockingAudioTrack$setupVolume(android.media.AudioTrack float float ), 0, (AudioTrack)audioTrack, (float)f, (float)f2);
    }

    private static long clip(long l, long l2, long l3) {
        return (long)InvokeDynamicSupport.bootstrapStatic("clip", $$robo$$android_speech_tts_BlockingAudioTrack$clip(long long long ), 0, (long)l, (long)l2, (long)l3);
    }

    private static float clip(float f, float f2, float f3) {
        return (float)InvokeDynamicSupport.bootstrapStatic("clip", $$robo$$android_speech_tts_BlockingAudioTrack$clip(float float float ), 0, (float)f, (float)f2, (float)f3);
    }

    public /* synthetic */ BlockingAudioTrack() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BlockingAudioTrack)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

