/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.telecom.AudioState;
import android.telecom.CallAudioState;
import android.telecom.Conference;
import android.telecom.ConferenceParticipant;
import android.telecom.Conferenceable;
import android.telecom.ConnectionService;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.StatusHints;
import android.telecom.VideoProfile;
import android.util.ArraySet;
import android.view.Surface;
import com.android.internal.os.SomeArgs;
import com.android.internal.telecom.IVideoCallback;
import com.android.internal.telecom.IVideoProvider;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Connection
extends Conferenceable
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int STATE_INITIALIZING = 0;
    public static int STATE_NEW = 1;
    public static int STATE_RINGING = 2;
    public static int STATE_DIALING = 3;
    public static int STATE_ACTIVE = 4;
    public static int STATE_HOLDING = 5;
    public static int STATE_DISCONNECTED = 6;
    public static int STATE_PULLING_CALL = 7;
    public static int CAPABILITY_HOLD = 1;
    public static int CAPABILITY_SUPPORT_HOLD = 2;
    public static int CAPABILITY_MERGE_CONFERENCE = 4;
    public static int CAPABILITY_SWAP_CONFERENCE = 8;
    public static int CAPABILITY_UNUSED = 16;
    public static int CAPABILITY_RESPOND_VIA_TEXT = 32;
    public static int CAPABILITY_MUTE = 64;
    public static int CAPABILITY_MANAGE_CONFERENCE = 128;
    public static int CAPABILITY_SUPPORTS_VT_LOCAL_RX = 256;
    public static int CAPABILITY_SUPPORTS_VT_LOCAL_TX = 512;
    public static int CAPABILITY_SUPPORTS_VT_LOCAL_BIDIRECTIONAL = 768;
    public static int CAPABILITY_SUPPORTS_VT_REMOTE_RX = 1024;
    public static int CAPABILITY_SUPPORTS_VT_REMOTE_TX = 2048;
    public static int CAPABILITY_SUPPORTS_VT_REMOTE_BIDIRECTIONAL = 3072;
    public static int CAPABILITY_SEPARATE_FROM_CONFERENCE = 4096;
    public static int CAPABILITY_DISCONNECT_FROM_CONFERENCE = 8192;
    public static int CAPABILITY_UNUSED_2 = 16384;
    public static int CAPABILITY_UNUSED_3 = 32768;
    public static int CAPABILITY_UNUSED_4 = 65536;
    public static int CAPABILITY_UNUSED_5 = 131072;
    public static int CAPABILITY_SPEED_UP_MT_AUDIO = 262144;
    public static int CAPABILITY_CAN_UPGRADE_TO_VIDEO = 524288;
    public static int CAPABILITY_CAN_PAUSE_VIDEO = 0x100000;
    public static int CAPABILITY_CONFERENCE_HAS_NO_CHILDREN = 0x200000;
    public static int CAPABILITY_CAN_SEND_RESPONSE_VIA_CONNECTION = 0x400000;
    public static int CAPABILITY_CANNOT_DOWNGRADE_VIDEO_TO_AUDIO = 0x800000;
    public static int CAPABILITY_CAN_PULL_CALL = 0x1000000;
    public static int PROPERTY_SHOW_CALLBACK_NUMBER = 1;
    public static int PROPERTY_GENERIC_CONFERENCE = 2;
    public static int PROPERTY_HIGH_DEF_AUDIO = 4;
    public static int PROPERTY_WIFI = 8;
    public static int PROPERTY_IS_EXTERNAL_CALL = 16;
    public static String EXTRA_LAST_FORWARDED_NUMBER = "android.telecom.extra.LAST_FORWARDED_NUMBER";
    public static String EXTRA_CHILD_ADDRESS = "android.telecom.extra.CHILD_ADDRESS";
    public static String EXTRA_CALL_SUBJECT = "android.telecom.extra.CALL_SUBJECT";
    public static String EVENT_ON_HOLD_TONE_START = "android.telecom.event.ON_HOLD_TONE_START";
    public static String EVENT_ON_HOLD_TONE_END = "android.telecom.event.ON_HOLD_TONE_END";
    public static String EVENT_CALL_PULL_FAILED = "android.telecom.event.CALL_PULL_FAILED";
    private static boolean PII_DEBUG;
    private Listener mConnectionDeathListener;
    private Conference.Listener mConferenceDeathListener;
    private Set<Listener> mListeners;
    private List<Conferenceable> mConferenceables;
    private List<Conferenceable> mUnmodifiableConferenceables;
    private String mTelecomCallId;
    private int mState;
    private CallAudioState mCallAudioState;
    private Uri mAddress;
    private int mAddressPresentation;
    private String mCallerDisplayName;
    private int mCallerDisplayNamePresentation;
    private boolean mRingbackRequested;
    private int mConnectionCapabilities;
    private int mConnectionProperties;
    private VideoProvider mVideoProvider;
    private boolean mAudioModeIsVoip;
    private long mConnectTimeMillis;
    private StatusHints mStatusHints;
    private int mVideoState;
    private DisconnectCause mDisconnectCause;
    private Conference mConference;
    private ConnectionService mConnectionService;
    private Bundle mExtras;
    private Object mExtrasLock;
    private Set<String> mPreviousExtraKeys;

    private static final boolean $$robo$$android_telecom_Connection$can(int capabilities, int capability) {
        return (capabilities & capability) == capability;
    }

    private final boolean $$robo$$android_telecom_Connection$can(int capability) {
        return Connection.can(this.mConnectionCapabilities, capability);
    }

    private final void $$robo$$android_telecom_Connection$removeCapability(int capability) {
        this.mConnectionCapabilities &= ~capability;
    }

    private final void $$robo$$android_telecom_Connection$addCapability(int capability) {
        this.mConnectionCapabilities |= capability;
    }

    private static final String $$robo$$android_telecom_Connection$capabilitiesToString(int capabilities) {
        StringBuilder builder = new StringBuilder();
        builder.append("[Capabilities:");
        if (Connection.can(capabilities, 1)) {
            builder.append(" CAPABILITY_HOLD");
        }
        if (Connection.can(capabilities, 2)) {
            builder.append(" CAPABILITY_SUPPORT_HOLD");
        }
        if (Connection.can(capabilities, 4)) {
            builder.append(" CAPABILITY_MERGE_CONFERENCE");
        }
        if (Connection.can(capabilities, 8)) {
            builder.append(" CAPABILITY_SWAP_CONFERENCE");
        }
        if (Connection.can(capabilities, 32)) {
            builder.append(" CAPABILITY_RESPOND_VIA_TEXT");
        }
        if (Connection.can(capabilities, 64)) {
            builder.append(" CAPABILITY_MUTE");
        }
        if (Connection.can(capabilities, 128)) {
            builder.append(" CAPABILITY_MANAGE_CONFERENCE");
        }
        if (Connection.can(capabilities, 256)) {
            builder.append(" CAPABILITY_SUPPORTS_VT_LOCAL_RX");
        }
        if (Connection.can(capabilities, 512)) {
            builder.append(" CAPABILITY_SUPPORTS_VT_LOCAL_TX");
        }
        if (Connection.can(capabilities, 768)) {
            builder.append(" CAPABILITY_SUPPORTS_VT_LOCAL_BIDIRECTIONAL");
        }
        if (Connection.can(capabilities, 1024)) {
            builder.append(" CAPABILITY_SUPPORTS_VT_REMOTE_RX");
        }
        if (Connection.can(capabilities, 2048)) {
            builder.append(" CAPABILITY_SUPPORTS_VT_REMOTE_TX");
        }
        if (Connection.can(capabilities, 3072)) {
            builder.append(" CAPABILITY_SUPPORTS_VT_REMOTE_BIDIRECTIONAL");
        }
        if (Connection.can(capabilities, 0x800000)) {
            builder.append(" CAPABILITY_CANNOT_DOWNGRADE_VIDEO_TO_AUDIO");
        }
        if (Connection.can(capabilities, 262144)) {
            builder.append(" CAPABILITY_SPEED_UP_MT_AUDIO");
        }
        if (Connection.can(capabilities, 524288)) {
            builder.append(" CAPABILITY_CAN_UPGRADE_TO_VIDEO");
        }
        if (Connection.can(capabilities, 0x100000)) {
            builder.append(" CAPABILITY_CAN_PAUSE_VIDEO");
        }
        if (Connection.can(capabilities, 0x200000)) {
            builder.append(" CAPABILITY_SINGLE_PARTY_CONFERENCE");
        }
        if (Connection.can(capabilities, 0x400000)) {
            builder.append(" CAPABILITY_CAN_SEND_RESPONSE_VIA_CONNECTION");
        }
        if (Connection.can(capabilities, 0x1000000)) {
            builder.append(" CAPABILITY_CAN_PULL_CALL");
        }
        builder.append("]");
        return builder.toString();
    }

    private static final String $$robo$$android_telecom_Connection$propertiesToString(int properties) {
        StringBuilder builder = new StringBuilder();
        builder.append("[Properties:");
        if (Connection.can(properties, 1)) {
            builder.append(" PROPERTY_SHOW_CALLBACK_NUMBER");
        }
        if (Connection.can(properties, 4)) {
            builder.append(" PROPERTY_HIGH_DEF_AUDIO");
        }
        if (Connection.can(properties, 8)) {
            builder.append(" PROPERTY_WIFI");
        }
        if (Connection.can(properties, 2)) {
            builder.append(" PROPERTY_GENERIC_CONFERENCE");
        }
        if (Connection.can(properties, 16)) {
            builder.append(" PROPERTY_IS_EXTERNAL_CALL");
        }
        builder.append("]");
        return builder.toString();
    }

    private void $$robo$$android_telecom_Connection$__constructor__() {
        this.mConnectionDeathListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Connection this$0;

            private void $$robo$$android_telecom_Connection_1$__constructor__(Connection this$0) {
            }

            private final void $$robo$$android_telecom_Connection_1$onDestroyed(Connection c) {
                if (this.this$0.mConferenceables.remove(c)) {
                    this.this$0.fireOnConferenceableConnectionsChanged();
                }
            }

            private void __constructor__(Connection connection) {
                this.$$robo$$android_telecom_Connection_1$__constructor__(connection);
            }
            {
                this.this$0 = connection;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Connection_1$__constructor__(android.telecom.Connection ), 0, this, connection);
            }

            @Override
            public void onDestroyed(Connection connection) {
                InvokeDynamicSupport.bootstrap("onDestroyed", $$robo$$android_telecom_Connection_1$onDestroyed(android.telecom.Connection ), 0, this, connection);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConferenceDeathListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Connection this$0;

            private void $$robo$$android_telecom_Connection_2$__constructor__(Connection this$0) {
            }

            private final void $$robo$$android_telecom_Connection_2$onDestroyed(Conference c) {
                if (this.this$0.mConferenceables.remove(c)) {
                    this.this$0.fireOnConferenceableConnectionsChanged();
                }
            }

            private void __constructor__(Connection connection) {
                this.$$robo$$android_telecom_Connection_2$__constructor__(connection);
            }
            {
                this.this$0 = connection;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Connection_2$__constructor__(android.telecom.Connection ), 0, this, connection);
            }

            @Override
            public void onDestroyed(Conference conference) {
                InvokeDynamicSupport.bootstrap("onDestroyed", $$robo$$android_telecom_Connection_2$onDestroyed(android.telecom.Conference ), 0, this, conference);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mListeners = Collections.newSetFromMap(new ConcurrentHashMap(8, 0.9f, 1));
        this.mConferenceables = new ArrayList<Conferenceable>();
        this.mUnmodifiableConferenceables = Collections.unmodifiableList(this.mConferenceables);
        this.mState = 1;
        this.mRingbackRequested = false;
        this.mConnectTimeMillis = 0L;
        this.mExtrasLock = new Object();
    }

    private final String $$robo$$android_telecom_Connection$getTelecomCallId() {
        return this.mTelecomCallId;
    }

    private final Uri $$robo$$android_telecom_Connection$getAddress() {
        return this.mAddress;
    }

    private final int $$robo$$android_telecom_Connection$getAddressPresentation() {
        return this.mAddressPresentation;
    }

    private final String $$robo$$android_telecom_Connection$getCallerDisplayName() {
        return this.mCallerDisplayName;
    }

    private final int $$robo$$android_telecom_Connection$getCallerDisplayNamePresentation() {
        return this.mCallerDisplayNamePresentation;
    }

    private final int $$robo$$android_telecom_Connection$getState() {
        return this.mState;
    }

    private final int $$robo$$android_telecom_Connection$getVideoState() {
        return this.mVideoState;
    }

    @Deprecated
    private final AudioState $$robo$$android_telecom_Connection$getAudioState() {
        if (this.mCallAudioState == null) {
            return null;
        }
        return new AudioState(this.mCallAudioState);
    }

    private final CallAudioState $$robo$$android_telecom_Connection$getCallAudioState() {
        return this.mCallAudioState;
    }

    private final Conference $$robo$$android_telecom_Connection$getConference() {
        return this.mConference;
    }

    private final boolean $$robo$$android_telecom_Connection$isRingbackRequested() {
        return this.mRingbackRequested;
    }

    private final boolean $$robo$$android_telecom_Connection$getAudioModeIsVoip() {
        return this.mAudioModeIsVoip;
    }

    private final long $$robo$$android_telecom_Connection$getConnectTimeMillis() {
        return this.mConnectTimeMillis;
    }

    private final StatusHints $$robo$$android_telecom_Connection$getStatusHints() {
        return this.mStatusHints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bundle $$robo$$android_telecom_Connection$getExtras() {
        Bundle extras = null;
        Object object = this.mExtrasLock;
        synchronized (object) {
            if (this.mExtras != null) {
                extras = new Bundle(this.mExtras);
            }
        }
        return extras;
    }

    private final Connection $$robo$$android_telecom_Connection$addConnectionListener(Listener l) {
        this.mListeners.add(l);
        return this;
    }

    private final Connection $$robo$$android_telecom_Connection$removeConnectionListener(Listener l) {
        if (l != null) {
            this.mListeners.remove(l);
        }
        return this;
    }

    private final DisconnectCause $$robo$$android_telecom_Connection$getDisconnectCause() {
        return this.mDisconnectCause;
    }

    private final void $$robo$$android_telecom_Connection$setTelecomCallId(String callId) {
        this.mTelecomCallId = callId;
    }

    private final void $$robo$$android_telecom_Connection$setCallAudioState(CallAudioState state) {
        this.checkImmutable();
        Log.d(this, "setAudioState %s", state);
        this.mCallAudioState = state;
        this.onAudioStateChanged(this.getAudioState());
        this.onCallAudioStateChanged(state);
    }

    private static final String $$robo$$android_telecom_Connection$stateToString(int state) {
        switch (state) {
            case 0: {
                return "INITIALIZING";
            }
            case 1: {
                return "NEW";
            }
            case 2: {
                return "RINGING";
            }
            case 3: {
                return "DIALING";
            }
            case 4: {
                return "ACTIVE";
            }
            case 5: {
                return "HOLDING";
            }
            case 6: {
                return "DISCONNECTED";
            }
        }
        Log.wtf(Connection.class, "Unknown state %d", state);
        return "UNKNOWN";
    }

    private final int $$robo$$android_telecom_Connection$getConnectionCapabilities() {
        return this.mConnectionCapabilities;
    }

    private final int $$robo$$android_telecom_Connection$getConnectionProperties() {
        return this.mConnectionProperties;
    }

    private final void $$robo$$android_telecom_Connection$setAddress(Uri address, int presentation) {
        this.checkImmutable();
        Log.d(this, "setAddress %s", address);
        this.mAddress = address;
        this.mAddressPresentation = presentation;
        for (Listener l : this.mListeners) {
            l.onAddressChanged(this, address, presentation);
        }
    }

    private final void $$robo$$android_telecom_Connection$setCallerDisplayName(String callerDisplayName, int presentation) {
        this.checkImmutable();
        Log.d(this, "setCallerDisplayName %s", callerDisplayName);
        this.mCallerDisplayName = callerDisplayName;
        this.mCallerDisplayNamePresentation = presentation;
        for (Listener l : this.mListeners) {
            l.onCallerDisplayNameChanged(this, callerDisplayName, presentation);
        }
    }

    private final void $$robo$$android_telecom_Connection$setVideoState(int videoState) {
        this.checkImmutable();
        Log.d(this, "setVideoState %d", videoState);
        this.mVideoState = videoState;
        for (Listener l : this.mListeners) {
            l.onVideoStateChanged(this, this.mVideoState);
        }
    }

    private final void $$robo$$android_telecom_Connection$setActive() {
        this.checkImmutable();
        this.setRingbackRequested(false);
        this.setState(4);
    }

    private final void $$robo$$android_telecom_Connection$setRinging() {
        this.checkImmutable();
        this.setState(2);
    }

    private final void $$robo$$android_telecom_Connection$setInitializing() {
        this.checkImmutable();
        this.setState(0);
    }

    private final void $$robo$$android_telecom_Connection$setInitialized() {
        this.checkImmutable();
        this.setState(1);
    }

    private final void $$robo$$android_telecom_Connection$setDialing() {
        this.checkImmutable();
        this.setState(3);
    }

    private final void $$robo$$android_telecom_Connection$setOnHold() {
        this.checkImmutable();
        this.setState(5);
    }

    private final void $$robo$$android_telecom_Connection$setVideoProvider(VideoProvider videoProvider) {
        this.checkImmutable();
        this.mVideoProvider = videoProvider;
        for (Listener l : this.mListeners) {
            l.onVideoProviderChanged(this, videoProvider);
        }
    }

    private final VideoProvider $$robo$$android_telecom_Connection$getVideoProvider() {
        return this.mVideoProvider;
    }

    private final void $$robo$$android_telecom_Connection$setDisconnected(DisconnectCause disconnectCause) {
        this.checkImmutable();
        this.mDisconnectCause = disconnectCause;
        this.setState(6);
        Log.d(this, "Disconnected with cause %s", disconnectCause);
        for (Listener l : this.mListeners) {
            l.onDisconnected(this, disconnectCause);
        }
    }

    private final void $$robo$$android_telecom_Connection$setPostDialWait(String remaining) {
        this.checkImmutable();
        for (Listener l : this.mListeners) {
            l.onPostDialWait(this, remaining);
        }
    }

    private final void $$robo$$android_telecom_Connection$setNextPostDialChar(char nextChar) {
        this.checkImmutable();
        for (Listener l : this.mListeners) {
            l.onPostDialChar(this, nextChar);
        }
    }

    private final void $$robo$$android_telecom_Connection$setRingbackRequested(boolean ringback) {
        this.checkImmutable();
        if (this.mRingbackRequested != ringback) {
            this.mRingbackRequested = ringback;
            for (Listener l : this.mListeners) {
                l.onRingbackRequested(this, ringback);
            }
        }
    }

    private final void $$robo$$android_telecom_Connection$setConnectionCapabilities(int connectionCapabilities) {
        this.checkImmutable();
        if (this.mConnectionCapabilities != connectionCapabilities) {
            this.mConnectionCapabilities = connectionCapabilities;
            for (Listener l : this.mListeners) {
                l.onConnectionCapabilitiesChanged(this, this.mConnectionCapabilities);
            }
        }
    }

    private final void $$robo$$android_telecom_Connection$setConnectionProperties(int connectionProperties) {
        this.checkImmutable();
        if (this.mConnectionProperties != connectionProperties) {
            this.mConnectionProperties = connectionProperties;
            for (Listener l : this.mListeners) {
                l.onConnectionPropertiesChanged(this, this.mConnectionProperties);
            }
        }
    }

    private final void $$robo$$android_telecom_Connection$destroy() {
        for (Listener l : this.mListeners) {
            l.onDestroyed(this);
        }
    }

    private final void $$robo$$android_telecom_Connection$setAudioModeIsVoip(boolean isVoip) {
        this.checkImmutable();
        this.mAudioModeIsVoip = isVoip;
        for (Listener l : this.mListeners) {
            l.onAudioModeIsVoipChanged(this, isVoip);
        }
    }

    private final void $$robo$$android_telecom_Connection$setConnectTimeMillis(long connectTimeMillis) {
        this.mConnectTimeMillis = connectTimeMillis;
    }

    private final void $$robo$$android_telecom_Connection$setStatusHints(StatusHints statusHints) {
        this.checkImmutable();
        this.mStatusHints = statusHints;
        for (Listener l : this.mListeners) {
            l.onStatusHintsChanged(this, statusHints);
        }
    }

    private final void $$robo$$android_telecom_Connection$setConferenceableConnections(List<Connection> conferenceableConnections) {
        this.checkImmutable();
        this.clearConferenceableList();
        for (Connection c : conferenceableConnections) {
            if (this.mConferenceables.contains(c)) continue;
            c.addConnectionListener(this.mConnectionDeathListener);
            this.mConferenceables.add(c);
        }
        this.fireOnConferenceableConnectionsChanged();
    }

    private final void $$robo$$android_telecom_Connection$setConferenceables(List<Conferenceable> conferenceables) {
        this.clearConferenceableList();
        for (Conferenceable c : conferenceables) {
            if (this.mConferenceables.contains(c)) continue;
            if (c instanceof Connection) {
                Connection connection = (Connection)c;
                connection.addConnectionListener(this.mConnectionDeathListener);
            } else if (c instanceof Conference) {
                Conference conference = (Conference)c;
                conference.addListener(this.mConferenceDeathListener);
            }
            this.mConferenceables.add(c);
        }
        this.fireOnConferenceableConnectionsChanged();
    }

    private final List<Conferenceable> $$robo$$android_telecom_Connection$getConferenceables() {
        return this.mUnmodifiableConferenceables;
    }

    private final void $$robo$$android_telecom_Connection$setConnectionService(ConnectionService connectionService) {
        this.checkImmutable();
        if (this.mConnectionService != null) {
            Log.e(this, (Throwable)new Exception(), "Trying to set ConnectionService on a connection which is already associated with another ConnectionService.", new Object[0]);
        } else {
            this.mConnectionService = connectionService;
        }
    }

    private final void $$robo$$android_telecom_Connection$unsetConnectionService(ConnectionService connectionService) {
        if (this.mConnectionService != connectionService) {
            Log.e(this, (Throwable)new Exception(), "Trying to remove ConnectionService from a Connection that does not belong to the ConnectionService.", new Object[0]);
        } else {
            this.mConnectionService = null;
        }
    }

    private final ConnectionService $$robo$$android_telecom_Connection$getConnectionService() {
        return this.mConnectionService;
    }

    private final boolean $$robo$$android_telecom_Connection$setConference(Conference conference) {
        this.checkImmutable();
        if (this.mConference == null) {
            this.mConference = conference;
            if (this.mConnectionService != null && this.mConnectionService.containsConference(conference)) {
                this.fireConferenceChanged();
            }
            return true;
        }
        return false;
    }

    private final void $$robo$$android_telecom_Connection$resetConference() {
        if (this.mConference != null) {
            Log.d(this, "Conference reset", new Object[0]);
            this.mConference = null;
            this.fireConferenceChanged();
        }
    }

    private final void $$robo$$android_telecom_Connection$setExtras(Bundle extras) {
        this.checkImmutable();
        this.putExtras(extras);
        if (this.mPreviousExtraKeys != null) {
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String oldKey : this.mPreviousExtraKeys) {
                if (extras != null && extras.containsKey(oldKey)) continue;
                toRemove.add(oldKey);
            }
            if (!toRemove.isEmpty()) {
                this.removeExtras(toRemove);
            }
        }
        if (this.mPreviousExtraKeys == null) {
            this.mPreviousExtraKeys = new ArraySet<String>();
        }
        this.mPreviousExtraKeys.clear();
        if (extras != null) {
            this.mPreviousExtraKeys.addAll(extras.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telecom_Connection$putExtras(Bundle extras) {
        Bundle listenerExtras;
        this.checkImmutable();
        if (extras == null) {
            return;
        }
        Iterator<Listener> iterator = this.mExtrasLock;
        synchronized (iterator) {
            if (this.mExtras == null) {
                this.mExtras = new Bundle();
            }
            this.mExtras.putAll(extras);
            listenerExtras = new Bundle(this.mExtras);
        }
        for (Listener l : this.mListeners) {
            l.onExtrasChanged(this, new Bundle(listenerExtras));
        }
    }

    private final void $$robo$$android_telecom_Connection$putExtra(String key, boolean value) {
        Bundle newExtras = new Bundle();
        newExtras.putBoolean(key, value);
        this.putExtras(newExtras);
    }

    private final void $$robo$$android_telecom_Connection$putExtra(String key, int value) {
        Bundle newExtras = new Bundle();
        newExtras.putInt(key, value);
        this.putExtras(newExtras);
    }

    private final void $$robo$$android_telecom_Connection$putExtra(String key, String value) {
        Bundle newExtras = new Bundle();
        newExtras.putString(key, value);
        this.putExtras(newExtras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telecom_Connection$removeExtras(List<String> keys) {
        Object object = this.mExtrasLock;
        synchronized (object) {
            if (this.mExtras != null) {
                for (String key : keys) {
                    this.mExtras.remove(key);
                }
            }
        }
        List<String> unmodifiableKeys = Collections.unmodifiableList(keys);
        for (Listener l : this.mListeners) {
            l.onExtrasRemoved(this, unmodifiableKeys);
        }
    }

    @Deprecated
    private final void $$robo$$android_telecom_Connection$onAudioStateChanged(AudioState state) {
    }

    private final void $$robo$$android_telecom_Connection$onCallAudioStateChanged(CallAudioState state) {
    }

    private final void $$robo$$android_telecom_Connection$onStateChanged(int state) {
    }

    private final void $$robo$$android_telecom_Connection$onPlayDtmfTone(char c) {
    }

    private final void $$robo$$android_telecom_Connection$onStopDtmfTone() {
    }

    private final void $$robo$$android_telecom_Connection$onDisconnect() {
    }

    private final void $$robo$$android_telecom_Connection$onDisconnectConferenceParticipant(Uri endpoint) {
    }

    private final void $$robo$$android_telecom_Connection$onSeparate() {
    }

    private final void $$robo$$android_telecom_Connection$onAbort() {
    }

    private final void $$robo$$android_telecom_Connection$onHold() {
    }

    private final void $$robo$$android_telecom_Connection$onUnhold() {
    }

    private final void $$robo$$android_telecom_Connection$onAnswer(int videoState) {
    }

    private final void $$robo$$android_telecom_Connection$onAnswer() {
        this.onAnswer(0);
    }

    private final void $$robo$$android_telecom_Connection$onReject() {
    }

    private final void $$robo$$android_telecom_Connection$onReject(String replyMessage) {
    }

    private final void $$robo$$android_telecom_Connection$onSilence() {
    }

    private final void $$robo$$android_telecom_Connection$onPostDialContinue(boolean proceed) {
    }

    private final void $$robo$$android_telecom_Connection$onPullExternalCall() {
    }

    private final void $$robo$$android_telecom_Connection$onCallEvent(String event, Bundle extras) {
    }

    private final void $$robo$$android_telecom_Connection$onExtrasChanged(Bundle extras) {
    }

    private static final String $$robo$$android_telecom_Connection$toLogSafePhoneNumber(String number) {
        if (number == null) {
            return "";
        }
        if (PII_DEBUG) {
            return number;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < number.length(); ++i) {
            char c = number.charAt(i);
            if (c == '-' || c == '@' || c == '.') {
                builder.append(c);
                continue;
            }
            builder.append('x');
        }
        return builder.toString();
    }

    private final void $$robo$$android_telecom_Connection$setState(int state) {
        this.checkImmutable();
        if (this.mState == 6 && this.mState != state) {
            Log.d(this, "Connection already DISCONNECTED; cannot transition out of this state.", new Object[0]);
            return;
        }
        if (this.mState != state) {
            Log.d(this, "setState: %s", Connection.stateToString(state));
            this.mState = state;
            this.onStateChanged(state);
            for (Listener l : this.mListeners) {
                l.onStateChanged(this, state);
            }
        }
    }

    private static final Connection $$robo$$android_telecom_Connection$createFailedConnection(DisconnectCause disconnectCause) {
        return new FailureSignalingConnection(disconnectCause);
    }

    private final void $$robo$$android_telecom_Connection$checkImmutable() {
    }

    private static final Connection $$robo$$android_telecom_Connection$createCanceledConnection() {
        return new FailureSignalingConnection(new DisconnectCause(4));
    }

    private final void $$robo$$android_telecom_Connection$fireOnConferenceableConnectionsChanged() {
        for (Listener l : this.mListeners) {
            l.onConferenceablesChanged(this, this.getConferenceables());
        }
    }

    private final void $$robo$$android_telecom_Connection$fireConferenceChanged() {
        for (Listener l : this.mListeners) {
            l.onConferenceChanged(this, this.mConference);
        }
    }

    private final void $$robo$$android_telecom_Connection$clearConferenceableList() {
        for (Conferenceable c : this.mConferenceables) {
            if (c instanceof Connection) {
                Connection connection = (Connection)c;
                connection.removeConnectionListener(this.mConnectionDeathListener);
                continue;
            }
            if (!(c instanceof Conference)) continue;
            Conference conference = (Conference)c;
            conference.removeListener(this.mConferenceDeathListener);
        }
        this.mConferenceables.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telecom_Connection$handleExtrasChanged(Bundle extras) {
        Bundle b = null;
        Object object = this.mExtrasLock;
        synchronized (object) {
            this.mExtras = extras;
            if (this.mExtras != null) {
                b = new Bundle(this.mExtras);
            }
        }
        this.onExtrasChanged(b);
    }

    private final void $$robo$$android_telecom_Connection$notifyConferenceMergeFailed() {
        for (Listener l : this.mListeners) {
            l.onConferenceMergeFailed(this);
        }
    }

    private final void $$robo$$android_telecom_Connection$updateConferenceParticipants(List<ConferenceParticipant> conferenceParticipants) {
        for (Listener l : this.mListeners) {
            l.onConferenceParticipantsChanged(this, conferenceParticipants);
        }
    }

    private final void $$robo$$android_telecom_Connection$notifyConferenceStarted() {
        for (Listener l : this.mListeners) {
            l.onConferenceStarted();
        }
    }

    private final void $$robo$$android_telecom_Connection$sendConnectionEvent(String event, Bundle extras) {
        for (Listener l : this.mListeners) {
            l.onConnectionEvent(this, event, extras);
        }
    }

    static void __staticInitializer__() {
        PII_DEBUG = Log.isLoggable(3);
    }

    public static boolean can(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("can", $$robo$$android_telecom_Connection$can(int int ), 0, (int)n, (int)n2);
    }

    public boolean can(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("can", $$robo$$android_telecom_Connection$can(int ), 0, this, n);
    }

    public void removeCapability(int n) {
        InvokeDynamicSupport.bootstrap("removeCapability", $$robo$$android_telecom_Connection$removeCapability(int ), 0, this, n);
    }

    public void addCapability(int n) {
        InvokeDynamicSupport.bootstrap("addCapability", $$robo$$android_telecom_Connection$addCapability(int ), 0, this, n);
    }

    public static String capabilitiesToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("capabilitiesToString", $$robo$$android_telecom_Connection$capabilitiesToString(int ), 0, (int)n);
    }

    public static String propertiesToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("propertiesToString", $$robo$$android_telecom_Connection$propertiesToString(int ), 0, (int)n);
    }

    private void __constructor__() {
        this.$$robo$$android_telecom_Connection$__constructor__();
    }

    public Connection() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Connection$__constructor__(), 0, this);
    }

    public String getTelecomCallId() {
        return InvokeDynamicSupport.bootstrap("getTelecomCallId", $$robo$$android_telecom_Connection$getTelecomCallId(), 0, this);
    }

    public Uri getAddress() {
        return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$android_telecom_Connection$getAddress(), 0, this);
    }

    public int getAddressPresentation() {
        return (int)InvokeDynamicSupport.bootstrap("getAddressPresentation", $$robo$$android_telecom_Connection$getAddressPresentation(), 0, this);
    }

    public String getCallerDisplayName() {
        return InvokeDynamicSupport.bootstrap("getCallerDisplayName", $$robo$$android_telecom_Connection$getCallerDisplayName(), 0, this);
    }

    public int getCallerDisplayNamePresentation() {
        return (int)InvokeDynamicSupport.bootstrap("getCallerDisplayNamePresentation", $$robo$$android_telecom_Connection$getCallerDisplayNamePresentation(), 0, this);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_telecom_Connection$getState(), 0, this);
    }

    public int getVideoState() {
        return (int)InvokeDynamicSupport.bootstrap("getVideoState", $$robo$$android_telecom_Connection$getVideoState(), 0, this);
    }

    @Deprecated
    public AudioState getAudioState() {
        return InvokeDynamicSupport.bootstrap("getAudioState", $$robo$$android_telecom_Connection$getAudioState(), 0, this);
    }

    public CallAudioState getCallAudioState() {
        return InvokeDynamicSupport.bootstrap("getCallAudioState", $$robo$$android_telecom_Connection$getCallAudioState(), 0, this);
    }

    public Conference getConference() {
        return InvokeDynamicSupport.bootstrap("getConference", $$robo$$android_telecom_Connection$getConference(), 0, this);
    }

    public boolean isRingbackRequested() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRingbackRequested", $$robo$$android_telecom_Connection$isRingbackRequested(), 0, this);
    }

    public boolean getAudioModeIsVoip() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAudioModeIsVoip", $$robo$$android_telecom_Connection$getAudioModeIsVoip(), 0, this);
    }

    public long getConnectTimeMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getConnectTimeMillis", $$robo$$android_telecom_Connection$getConnectTimeMillis(), 0, this);
    }

    public StatusHints getStatusHints() {
        return InvokeDynamicSupport.bootstrap("getStatusHints", $$robo$$android_telecom_Connection$getStatusHints(), 0, this);
    }

    public Bundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_telecom_Connection$getExtras(), 0, this);
    }

    public Connection addConnectionListener(Listener listener) {
        return InvokeDynamicSupport.bootstrap("addConnectionListener", $$robo$$android_telecom_Connection$addConnectionListener(android.telecom.Connection$Listener ), 0, this, listener);
    }

    public Connection removeConnectionListener(Listener listener) {
        return InvokeDynamicSupport.bootstrap("removeConnectionListener", $$robo$$android_telecom_Connection$removeConnectionListener(android.telecom.Connection$Listener ), 0, this, listener);
    }

    public DisconnectCause getDisconnectCause() {
        return InvokeDynamicSupport.bootstrap("getDisconnectCause", $$robo$$android_telecom_Connection$getDisconnectCause(), 0, this);
    }

    public void setTelecomCallId(String string2) {
        InvokeDynamicSupport.bootstrap("setTelecomCallId", $$robo$$android_telecom_Connection$setTelecomCallId(java.lang.String ), 0, this, string2);
    }

    void setCallAudioState(CallAudioState callAudioState) {
        InvokeDynamicSupport.bootstrap("setCallAudioState", $$robo$$android_telecom_Connection$setCallAudioState(android.telecom.CallAudioState ), 0, this, callAudioState);
    }

    public static String stateToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("stateToString", $$robo$$android_telecom_Connection$stateToString(int ), 0, (int)n);
    }

    public int getConnectionCapabilities() {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionCapabilities", $$robo$$android_telecom_Connection$getConnectionCapabilities(), 0, this);
    }

    public int getConnectionProperties() {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionProperties", $$robo$$android_telecom_Connection$getConnectionProperties(), 0, this);
    }

    public void setAddress(Uri uri, int n) {
        InvokeDynamicSupport.bootstrap("setAddress", $$robo$$android_telecom_Connection$setAddress(android.net.Uri int ), 0, this, uri, n);
    }

    public void setCallerDisplayName(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setCallerDisplayName", $$robo$$android_telecom_Connection$setCallerDisplayName(java.lang.String int ), 0, this, string2, n);
    }

    public void setVideoState(int n) {
        InvokeDynamicSupport.bootstrap("setVideoState", $$robo$$android_telecom_Connection$setVideoState(int ), 0, this, n);
    }

    public void setActive() {
        InvokeDynamicSupport.bootstrap("setActive", $$robo$$android_telecom_Connection$setActive(), 0, this);
    }

    public void setRinging() {
        InvokeDynamicSupport.bootstrap("setRinging", $$robo$$android_telecom_Connection$setRinging(), 0, this);
    }

    public void setInitializing() {
        InvokeDynamicSupport.bootstrap("setInitializing", $$robo$$android_telecom_Connection$setInitializing(), 0, this);
    }

    public void setInitialized() {
        InvokeDynamicSupport.bootstrap("setInitialized", $$robo$$android_telecom_Connection$setInitialized(), 0, this);
    }

    public void setDialing() {
        InvokeDynamicSupport.bootstrap("setDialing", $$robo$$android_telecom_Connection$setDialing(), 0, this);
    }

    public void setOnHold() {
        InvokeDynamicSupport.bootstrap("setOnHold", $$robo$$android_telecom_Connection$setOnHold(), 0, this);
    }

    public void setVideoProvider(VideoProvider videoProvider) {
        InvokeDynamicSupport.bootstrap("setVideoProvider", $$robo$$android_telecom_Connection$setVideoProvider(android.telecom.Connection$VideoProvider ), 0, this, videoProvider);
    }

    public VideoProvider getVideoProvider() {
        return InvokeDynamicSupport.bootstrap("getVideoProvider", $$robo$$android_telecom_Connection$getVideoProvider(), 0, this);
    }

    public void setDisconnected(DisconnectCause disconnectCause) {
        InvokeDynamicSupport.bootstrap("setDisconnected", $$robo$$android_telecom_Connection$setDisconnected(android.telecom.DisconnectCause ), 0, this, disconnectCause);
    }

    public void setPostDialWait(String string2) {
        InvokeDynamicSupport.bootstrap("setPostDialWait", $$robo$$android_telecom_Connection$setPostDialWait(java.lang.String ), 0, this, string2);
    }

    public void setNextPostDialChar(char c) {
        InvokeDynamicSupport.bootstrap("setNextPostDialChar", $$robo$$android_telecom_Connection$setNextPostDialChar(char ), 0, this, c);
    }

    public void setRingbackRequested(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRingbackRequested", $$robo$$android_telecom_Connection$setRingbackRequested(boolean ), 0, this, bl);
    }

    public void setConnectionCapabilities(int n) {
        InvokeDynamicSupport.bootstrap("setConnectionCapabilities", $$robo$$android_telecom_Connection$setConnectionCapabilities(int ), 0, this, n);
    }

    public void setConnectionProperties(int n) {
        InvokeDynamicSupport.bootstrap("setConnectionProperties", $$robo$$android_telecom_Connection$setConnectionProperties(int ), 0, this, n);
    }

    public void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_telecom_Connection$destroy(), 0, this);
    }

    public void setAudioModeIsVoip(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAudioModeIsVoip", $$robo$$android_telecom_Connection$setAudioModeIsVoip(boolean ), 0, this, bl);
    }

    public void setConnectTimeMillis(long l) {
        InvokeDynamicSupport.bootstrap("setConnectTimeMillis", $$robo$$android_telecom_Connection$setConnectTimeMillis(long ), 0, this, l);
    }

    public void setStatusHints(StatusHints statusHints) {
        InvokeDynamicSupport.bootstrap("setStatusHints", $$robo$$android_telecom_Connection$setStatusHints(android.telecom.StatusHints ), 0, this, statusHints);
    }

    public void setConferenceableConnections(List<Connection> list) {
        InvokeDynamicSupport.bootstrap("setConferenceableConnections", $$robo$$android_telecom_Connection$setConferenceableConnections(java.util.List<android.telecom.Connection> ), 0, this, list);
    }

    public void setConferenceables(List<Conferenceable> list) {
        InvokeDynamicSupport.bootstrap("setConferenceables", $$robo$$android_telecom_Connection$setConferenceables(java.util.List<android.telecom.Conferenceable> ), 0, this, list);
    }

    public List<Conferenceable> getConferenceables() {
        return InvokeDynamicSupport.bootstrap("getConferenceables", $$robo$$android_telecom_Connection$getConferenceables(), 0, this);
    }

    public void setConnectionService(ConnectionService connectionService) {
        InvokeDynamicSupport.bootstrap("setConnectionService", $$robo$$android_telecom_Connection$setConnectionService(android.telecom.ConnectionService ), 0, this, connectionService);
    }

    public void unsetConnectionService(ConnectionService connectionService) {
        InvokeDynamicSupport.bootstrap("unsetConnectionService", $$robo$$android_telecom_Connection$unsetConnectionService(android.telecom.ConnectionService ), 0, this, connectionService);
    }

    public ConnectionService getConnectionService() {
        return InvokeDynamicSupport.bootstrap("getConnectionService", $$robo$$android_telecom_Connection$getConnectionService(), 0, this);
    }

    public boolean setConference(Conference conference) {
        return (boolean)InvokeDynamicSupport.bootstrap("setConference", $$robo$$android_telecom_Connection$setConference(android.telecom.Conference ), 0, this, conference);
    }

    public void resetConference() {
        InvokeDynamicSupport.bootstrap("resetConference", $$robo$$android_telecom_Connection$resetConference(), 0, this);
    }

    public void setExtras(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setExtras", $$robo$$android_telecom_Connection$setExtras(android.os.Bundle ), 0, this, bundle);
    }

    public void putExtras(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("putExtras", $$robo$$android_telecom_Connection$putExtras(android.os.Bundle ), 0, this, bundle);
    }

    public void putExtra(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_telecom_Connection$putExtra(java.lang.String boolean ), 0, this, string2, bl);
    }

    public void putExtra(String string2, int n) {
        InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_telecom_Connection$putExtra(java.lang.String int ), 0, this, string2, n);
    }

    public void putExtra(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_telecom_Connection$putExtra(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void removeExtras(List<String> list) {
        InvokeDynamicSupport.bootstrap("removeExtras", $$robo$$android_telecom_Connection$removeExtras(java.util.List<java.lang.String> ), 0, this, list);
    }

    @Deprecated
    public void onAudioStateChanged(AudioState audioState) {
        InvokeDynamicSupport.bootstrap("onAudioStateChanged", $$robo$$android_telecom_Connection$onAudioStateChanged(android.telecom.AudioState ), 0, this, audioState);
    }

    public void onCallAudioStateChanged(CallAudioState callAudioState) {
        InvokeDynamicSupport.bootstrap("onCallAudioStateChanged", $$robo$$android_telecom_Connection$onCallAudioStateChanged(android.telecom.CallAudioState ), 0, this, callAudioState);
    }

    public void onStateChanged(int n) {
        InvokeDynamicSupport.bootstrap("onStateChanged", $$robo$$android_telecom_Connection$onStateChanged(int ), 0, this, n);
    }

    public void onPlayDtmfTone(char c) {
        InvokeDynamicSupport.bootstrap("onPlayDtmfTone", $$robo$$android_telecom_Connection$onPlayDtmfTone(char ), 0, this, c);
    }

    public void onStopDtmfTone() {
        InvokeDynamicSupport.bootstrap("onStopDtmfTone", $$robo$$android_telecom_Connection$onStopDtmfTone(), 0, this);
    }

    public void onDisconnect() {
        InvokeDynamicSupport.bootstrap("onDisconnect", $$robo$$android_telecom_Connection$onDisconnect(), 0, this);
    }

    public void onDisconnectConferenceParticipant(Uri uri) {
        InvokeDynamicSupport.bootstrap("onDisconnectConferenceParticipant", $$robo$$android_telecom_Connection$onDisconnectConferenceParticipant(android.net.Uri ), 0, this, uri);
    }

    public void onSeparate() {
        InvokeDynamicSupport.bootstrap("onSeparate", $$robo$$android_telecom_Connection$onSeparate(), 0, this);
    }

    public void onAbort() {
        InvokeDynamicSupport.bootstrap("onAbort", $$robo$$android_telecom_Connection$onAbort(), 0, this);
    }

    public void onHold() {
        InvokeDynamicSupport.bootstrap("onHold", $$robo$$android_telecom_Connection$onHold(), 0, this);
    }

    public void onUnhold() {
        InvokeDynamicSupport.bootstrap("onUnhold", $$robo$$android_telecom_Connection$onUnhold(), 0, this);
    }

    public void onAnswer(int n) {
        InvokeDynamicSupport.bootstrap("onAnswer", $$robo$$android_telecom_Connection$onAnswer(int ), 0, this, n);
    }

    public void onAnswer() {
        InvokeDynamicSupport.bootstrap("onAnswer", $$robo$$android_telecom_Connection$onAnswer(), 0, this);
    }

    public void onReject() {
        InvokeDynamicSupport.bootstrap("onReject", $$robo$$android_telecom_Connection$onReject(), 0, this);
    }

    public void onReject(String string2) {
        InvokeDynamicSupport.bootstrap("onReject", $$robo$$android_telecom_Connection$onReject(java.lang.String ), 0, this, string2);
    }

    public void onSilence() {
        InvokeDynamicSupport.bootstrap("onSilence", $$robo$$android_telecom_Connection$onSilence(), 0, this);
    }

    public void onPostDialContinue(boolean bl) {
        InvokeDynamicSupport.bootstrap("onPostDialContinue", $$robo$$android_telecom_Connection$onPostDialContinue(boolean ), 0, this, bl);
    }

    public void onPullExternalCall() {
        InvokeDynamicSupport.bootstrap("onPullExternalCall", $$robo$$android_telecom_Connection$onPullExternalCall(), 0, this);
    }

    public void onCallEvent(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCallEvent", $$robo$$android_telecom_Connection$onCallEvent(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    public void onExtrasChanged(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onExtrasChanged", $$robo$$android_telecom_Connection$onExtrasChanged(android.os.Bundle ), 0, this, bundle);
    }

    static String toLogSafePhoneNumber(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("toLogSafePhoneNumber", $$robo$$android_telecom_Connection$toLogSafePhoneNumber(java.lang.String ), 0, (String)string2);
    }

    private void setState(int n) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$android_telecom_Connection$setState(int ), 0, this, n);
    }

    public static Connection createFailedConnection(DisconnectCause disconnectCause) {
        return InvokeDynamicSupport.bootstrapStatic("createFailedConnection", $$robo$$android_telecom_Connection$createFailedConnection(android.telecom.DisconnectCause ), 0, (DisconnectCause)disconnectCause);
    }

    public void checkImmutable() {
        InvokeDynamicSupport.bootstrap("checkImmutable", $$robo$$android_telecom_Connection$checkImmutable(), 0, this);
    }

    public static Connection createCanceledConnection() {
        return InvokeDynamicSupport.bootstrapStatic("createCanceledConnection", $$robo$$android_telecom_Connection$createCanceledConnection(), 0);
    }

    private void fireOnConferenceableConnectionsChanged() {
        InvokeDynamicSupport.bootstrap("fireOnConferenceableConnectionsChanged", $$robo$$android_telecom_Connection$fireOnConferenceableConnectionsChanged(), 0, this);
    }

    private void fireConferenceChanged() {
        InvokeDynamicSupport.bootstrap("fireConferenceChanged", $$robo$$android_telecom_Connection$fireConferenceChanged(), 0, this);
    }

    private void clearConferenceableList() {
        InvokeDynamicSupport.bootstrap("clearConferenceableList", $$robo$$android_telecom_Connection$clearConferenceableList(), 0, this);
    }

    void handleExtrasChanged(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("handleExtrasChanged", $$robo$$android_telecom_Connection$handleExtrasChanged(android.os.Bundle ), 0, this, bundle);
    }

    protected void notifyConferenceMergeFailed() {
        InvokeDynamicSupport.bootstrap("notifyConferenceMergeFailed", $$robo$$android_telecom_Connection$notifyConferenceMergeFailed(), 0, this);
    }

    protected void updateConferenceParticipants(List<ConferenceParticipant> list) {
        InvokeDynamicSupport.bootstrap("updateConferenceParticipants", $$robo$$android_telecom_Connection$updateConferenceParticipants(java.util.List<android.telecom.ConferenceParticipant> ), 0, this, list);
    }

    protected void notifyConferenceStarted() {
        InvokeDynamicSupport.bootstrap("notifyConferenceStarted", $$robo$$android_telecom_Connection$notifyConferenceStarted(), 0, this);
    }

    public void sendConnectionEvent(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("sendConnectionEvent", $$robo$$android_telecom_Connection$sendConnectionEvent(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    static {
        RobolectricInternals.classInitializing(Connection.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Connection)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class FailureSignalingConnection
    extends Connection
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private boolean mImmutable;

        private void $$robo$$android_telecom_Connection_FailureSignalingConnection$__constructor__(DisconnectCause disconnectCause) {
            this.mImmutable = false;
            this.setDisconnected(disconnectCause);
            this.mImmutable = true;
        }

        private final void $$robo$$android_telecom_Connection_FailureSignalingConnection$checkImmutable() {
            if (this.mImmutable) {
                throw new UnsupportedOperationException("Connection is immutable");
            }
        }

        private void __constructor__(DisconnectCause disconnectCause) {
            this.$$robo$$android_telecom_Connection_FailureSignalingConnection$__constructor__(disconnectCause);
        }

        public FailureSignalingConnection(DisconnectCause disconnectCause) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Connection_FailureSignalingConnection$__constructor__(android.telecom.DisconnectCause ), 0, this, disconnectCause);
        }

        @Override
        public void checkImmutable() {
            InvokeDynamicSupport.bootstrap("checkImmutable", $$robo$$android_telecom_Connection_FailureSignalingConnection$checkImmutable(), 0, this);
        }

        public /* synthetic */ FailureSignalingConnection() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FailureSignalingConnection)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class VideoProvider
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int SESSION_EVENT_RX_PAUSE = 1;
        public static int SESSION_EVENT_RX_RESUME = 2;
        public static int SESSION_EVENT_TX_START = 3;
        public static int SESSION_EVENT_TX_STOP = 4;
        public static int SESSION_EVENT_CAMERA_FAILURE = 5;
        public static int SESSION_EVENT_CAMERA_READY = 6;
        public static int SESSION_MODIFY_REQUEST_SUCCESS = 1;
        public static int SESSION_MODIFY_REQUEST_FAIL = 2;
        public static int SESSION_MODIFY_REQUEST_INVALID = 3;
        public static int SESSION_MODIFY_REQUEST_TIMED_OUT = 4;
        public static int SESSION_MODIFY_REQUEST_REJECTED_BY_REMOTE = 5;
        private static int MSG_ADD_VIDEO_CALLBACK = 1;
        private static int MSG_SET_CAMERA = 2;
        private static int MSG_SET_PREVIEW_SURFACE = 3;
        private static int MSG_SET_DISPLAY_SURFACE = 4;
        private static int MSG_SET_DEVICE_ORIENTATION = 5;
        private static int MSG_SET_ZOOM = 6;
        private static int MSG_SEND_SESSION_MODIFY_REQUEST = 7;
        private static int MSG_SEND_SESSION_MODIFY_RESPONSE = 8;
        private static int MSG_REQUEST_CAMERA_CAPABILITIES = 9;
        private static int MSG_REQUEST_CONNECTION_DATA_USAGE = 10;
        private static int MSG_SET_PAUSE_IMAGE = 11;
        private static int MSG_REMOVE_VIDEO_CALLBACK = 12;
        private VideoProviderHandler mMessageHandler;
        private VideoProviderBinder mBinder;
        private ConcurrentHashMap<IBinder, IVideoCallback> mVideoCallbacks;

        private void $$robo$$android_telecom_Connection_VideoProvider$__constructor__() {
            this.mVideoCallbacks = new ConcurrentHashMap(8, 0.9f, 1);
            this.mBinder = new VideoProviderBinder(this);
            this.mMessageHandler = new VideoProviderHandler(this, Looper.getMainLooper());
        }

        private void $$robo$$android_telecom_Connection_VideoProvider$__constructor__(Looper looper) {
            this.mVideoCallbacks = new ConcurrentHashMap(8, 0.9f, 1);
            this.mBinder = new VideoProviderBinder(this);
            this.mMessageHandler = new VideoProviderHandler(this, looper);
        }

        private final IVideoProvider $$robo$$android_telecom_Connection_VideoProvider$getInterface() {
            return this.mBinder;
        }

        public abstract void onSetCamera(String var1);

        public abstract void onSetPreviewSurface(Surface var1);

        public abstract void onSetDisplaySurface(Surface var1);

        public abstract void onSetDeviceOrientation(int var1);

        public abstract void onSetZoom(float var1);

        public abstract void onSendSessionModifyRequest(VideoProfile var1, VideoProfile var2);

        public abstract void onSendSessionModifyResponse(VideoProfile var1);

        public abstract void onRequestCameraCapabilities();

        public abstract void onRequestConnectionDataUsage();

        public abstract void onSetPauseImage(Uri var1);

        private final void $$robo$$android_telecom_Connection_VideoProvider$receiveSessionModifyRequest(VideoProfile videoProfile) {
            if (this.mVideoCallbacks != null) {
                for (IVideoCallback callback : this.mVideoCallbacks.values()) {
                    try {
                        callback.receiveSessionModifyRequest(videoProfile);
                    }
                    catch (RemoteException ignored) {
                        Log.w(this, "receiveSessionModifyRequest callback failed", ignored);
                    }
                }
            }
        }

        private final void $$robo$$android_telecom_Connection_VideoProvider$receiveSessionModifyResponse(int status, VideoProfile requestedProfile, VideoProfile responseProfile) {
            if (this.mVideoCallbacks != null) {
                for (IVideoCallback callback : this.mVideoCallbacks.values()) {
                    try {
                        callback.receiveSessionModifyResponse(status, requestedProfile, responseProfile);
                    }
                    catch (RemoteException ignored) {
                        Log.w(this, "receiveSessionModifyResponse callback failed", ignored);
                    }
                }
            }
        }

        private final void $$robo$$android_telecom_Connection_VideoProvider$handleCallSessionEvent(int event) {
            if (this.mVideoCallbacks != null) {
                for (IVideoCallback callback : this.mVideoCallbacks.values()) {
                    try {
                        callback.handleCallSessionEvent(event);
                    }
                    catch (RemoteException ignored) {
                        Log.w(this, "handleCallSessionEvent callback failed", ignored);
                    }
                }
            }
        }

        private final void $$robo$$android_telecom_Connection_VideoProvider$changePeerDimensions(int width, int height) {
            if (this.mVideoCallbacks != null) {
                for (IVideoCallback callback : this.mVideoCallbacks.values()) {
                    try {
                        callback.changePeerDimensions(width, height);
                    }
                    catch (RemoteException ignored) {
                        Log.w(this, "changePeerDimensions callback failed", ignored);
                    }
                }
            }
        }

        private final void $$robo$$android_telecom_Connection_VideoProvider$setCallDataUsage(long dataUsage) {
            if (this.mVideoCallbacks != null) {
                for (IVideoCallback callback : this.mVideoCallbacks.values()) {
                    try {
                        callback.changeCallDataUsage(dataUsage);
                    }
                    catch (RemoteException ignored) {
                        Log.w(this, "setCallDataUsage callback failed", ignored);
                    }
                }
            }
        }

        private final void $$robo$$android_telecom_Connection_VideoProvider$changeCallDataUsage(long dataUsage) {
            this.setCallDataUsage(dataUsage);
        }

        private final void $$robo$$android_telecom_Connection_VideoProvider$changeCameraCapabilities(VideoProfile.CameraCapabilities cameraCapabilities) {
            if (this.mVideoCallbacks != null) {
                for (IVideoCallback callback : this.mVideoCallbacks.values()) {
                    try {
                        callback.changeCameraCapabilities(cameraCapabilities);
                    }
                    catch (RemoteException ignored) {
                        Log.w(this, "changeCameraCapabilities callback failed", ignored);
                    }
                }
            }
        }

        private final void $$robo$$android_telecom_Connection_VideoProvider$changeVideoQuality(int videoQuality) {
            if (this.mVideoCallbacks != null) {
                for (IVideoCallback callback : this.mVideoCallbacks.values()) {
                    try {
                        callback.changeVideoQuality(videoQuality);
                    }
                    catch (RemoteException ignored) {
                        Log.w(this, "changeVideoQuality callback failed", ignored);
                    }
                }
            }
        }

        private void __constructor__() {
            this.$$robo$$android_telecom_Connection_VideoProvider$__constructor__();
        }

        public VideoProvider() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Connection_VideoProvider$__constructor__(), 0, this);
        }

        private void __constructor__(Looper looper) {
            this.$$robo$$android_telecom_Connection_VideoProvider$__constructor__(looper);
        }

        public VideoProvider(Looper looper) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Connection_VideoProvider$__constructor__(android.os.Looper ), 0, this, looper);
        }

        public IVideoProvider getInterface() {
            return InvokeDynamicSupport.bootstrap("getInterface", $$robo$$android_telecom_Connection_VideoProvider$getInterface(), 0, this);
        }

        public void receiveSessionModifyRequest(VideoProfile videoProfile) {
            InvokeDynamicSupport.bootstrap("receiveSessionModifyRequest", $$robo$$android_telecom_Connection_VideoProvider$receiveSessionModifyRequest(android.telecom.VideoProfile ), 0, this, videoProfile);
        }

        public void receiveSessionModifyResponse(int n, VideoProfile videoProfile, VideoProfile videoProfile2) {
            InvokeDynamicSupport.bootstrap("receiveSessionModifyResponse", $$robo$$android_telecom_Connection_VideoProvider$receiveSessionModifyResponse(int android.telecom.VideoProfile android.telecom.VideoProfile ), 0, this, n, videoProfile, videoProfile2);
        }

        public void handleCallSessionEvent(int n) {
            InvokeDynamicSupport.bootstrap("handleCallSessionEvent", $$robo$$android_telecom_Connection_VideoProvider$handleCallSessionEvent(int ), 0, this, n);
        }

        public void changePeerDimensions(int n, int n2) {
            InvokeDynamicSupport.bootstrap("changePeerDimensions", $$robo$$android_telecom_Connection_VideoProvider$changePeerDimensions(int int ), 0, this, n, n2);
        }

        public void setCallDataUsage(long l) {
            InvokeDynamicSupport.bootstrap("setCallDataUsage", $$robo$$android_telecom_Connection_VideoProvider$setCallDataUsage(long ), 0, this, l);
        }

        public void changeCallDataUsage(long l) {
            InvokeDynamicSupport.bootstrap("changeCallDataUsage", $$robo$$android_telecom_Connection_VideoProvider$changeCallDataUsage(long ), 0, this, l);
        }

        public void changeCameraCapabilities(VideoProfile.CameraCapabilities cameraCapabilities) {
            InvokeDynamicSupport.bootstrap("changeCameraCapabilities", $$robo$$android_telecom_Connection_VideoProvider$changeCameraCapabilities(android.telecom.VideoProfile$CameraCapabilities ), 0, this, cameraCapabilities);
        }

        public void changeVideoQuality(int n) {
            InvokeDynamicSupport.bootstrap("changeVideoQuality", $$robo$$android_telecom_Connection_VideoProvider$changeVideoQuality(int ), 0, this, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VideoProvider)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        private final class VideoProviderBinder
        extends IVideoProvider.Stub
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ VideoProvider this$0;

            private void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$__constructor__(VideoProvider videoProvider) {
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$addVideoCallback(IBinder videoCallbackBinder) {
                this.this$0.mMessageHandler.obtainMessage(1, videoCallbackBinder).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$removeVideoCallback(IBinder videoCallbackBinder) {
                this.this$0.mMessageHandler.obtainMessage(12, videoCallbackBinder).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setCamera(String cameraId) {
                this.this$0.mMessageHandler.obtainMessage(2, cameraId).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setPreviewSurface(Surface surface) {
                this.this$0.mMessageHandler.obtainMessage(3, surface).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setDisplaySurface(Surface surface) {
                this.this$0.mMessageHandler.obtainMessage(4, surface).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setDeviceOrientation(int rotation) {
                this.this$0.mMessageHandler.obtainMessage(5, rotation, 0).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setZoom(float value) {
                this.this$0.mMessageHandler.obtainMessage(6, Float.valueOf(value)).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$sendSessionModifyRequest(VideoProfile fromProfile, VideoProfile toProfile) {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = fromProfile;
                args.arg2 = toProfile;
                this.this$0.mMessageHandler.obtainMessage(7, args).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$sendSessionModifyResponse(VideoProfile responseProfile) {
                this.this$0.mMessageHandler.obtainMessage(8, responseProfile).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$requestCameraCapabilities() {
                this.this$0.mMessageHandler.obtainMessage(9).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$requestCallDataUsage() {
                this.this$0.mMessageHandler.obtainMessage(10).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setPauseImage(Uri uri) {
                this.this$0.mMessageHandler.obtainMessage(11, uri).sendToTarget();
            }

            private /* synthetic */ void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$__constructor__(VideoProvider x0, 1 x1) {
            }

            private void __constructor__(VideoProvider videoProvider) {
                this.$$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$__constructor__(videoProvider);
            }

            private VideoProviderBinder(VideoProvider videoProvider) {
                this.this$0 = videoProvider;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$__constructor__(android.telecom.Connection$VideoProvider ), 0, this, videoProvider);
            }

            @Override
            public void addVideoCallback(IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("addVideoCallback", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$addVideoCallback(android.os.IBinder ), 0, this, iBinder);
            }

            @Override
            public void removeVideoCallback(IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("removeVideoCallback", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$removeVideoCallback(android.os.IBinder ), 0, this, iBinder);
            }

            @Override
            public void setCamera(String string2) {
                InvokeDynamicSupport.bootstrap("setCamera", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setCamera(java.lang.String ), 0, this, string2);
            }

            @Override
            public void setPreviewSurface(Surface surface) {
                InvokeDynamicSupport.bootstrap("setPreviewSurface", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setPreviewSurface(android.view.Surface ), 0, this, surface);
            }

            @Override
            public void setDisplaySurface(Surface surface) {
                InvokeDynamicSupport.bootstrap("setDisplaySurface", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setDisplaySurface(android.view.Surface ), 0, this, surface);
            }

            @Override
            public void setDeviceOrientation(int n) {
                InvokeDynamicSupport.bootstrap("setDeviceOrientation", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setDeviceOrientation(int ), 0, this, n);
            }

            @Override
            public void setZoom(float f) {
                InvokeDynamicSupport.bootstrap("setZoom", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setZoom(float ), 0, this, f);
            }

            @Override
            public void sendSessionModifyRequest(VideoProfile videoProfile, VideoProfile videoProfile2) {
                InvokeDynamicSupport.bootstrap("sendSessionModifyRequest", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$sendSessionModifyRequest(android.telecom.VideoProfile android.telecom.VideoProfile ), 0, this, videoProfile, videoProfile2);
            }

            @Override
            public void sendSessionModifyResponse(VideoProfile videoProfile) {
                InvokeDynamicSupport.bootstrap("sendSessionModifyResponse", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$sendSessionModifyResponse(android.telecom.VideoProfile ), 0, this, videoProfile);
            }

            @Override
            public void requestCameraCapabilities() {
                InvokeDynamicSupport.bootstrap("requestCameraCapabilities", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$requestCameraCapabilities(), 0, this);
            }

            @Override
            public void requestCallDataUsage() {
                InvokeDynamicSupport.bootstrap("requestCallDataUsage", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$requestCallDataUsage(), 0, this);
            }

            @Override
            public void setPauseImage(Uri uri) {
                InvokeDynamicSupport.bootstrap("setPauseImage", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setPauseImage(android.net.Uri ), 0, this, uri);
            }

            private /* synthetic */ void __constructor__(VideoProvider videoProvider, 1 var2_2) {
                this.$$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$__constructor__(videoProvider, var2_2);
            }

            public /* synthetic */ VideoProviderBinder() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VideoProviderBinder)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        private final class VideoProviderHandler
        extends Handler
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ VideoProvider this$0;

            private void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderHandler$__constructor__(VideoProvider videoProvider) {
            }

            private void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderHandler$__constructor__(VideoProvider videoProvider, Looper looper) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderHandler$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        IBinder binder = (IBinder)msg.obj;
                        IVideoCallback callback = IVideoCallback.Stub.asInterface((IBinder)msg.obj);
                        if (callback == null) {
                            Log.w(this, "addVideoProvider - skipped; callback is null.", new Object[0]);
                            break;
                        }
                        if (this.this$0.mVideoCallbacks.containsKey(binder)) {
                            Log.i(this, "addVideoProvider - skipped; already present.", new Object[0]);
                            break;
                        }
                        this.this$0.mVideoCallbacks.put(binder, callback);
                        break;
                    }
                    case 12: {
                        IBinder binder = (IBinder)msg.obj;
                        IVideoCallback callback = IVideoCallback.Stub.asInterface((IBinder)msg.obj);
                        if (!this.this$0.mVideoCallbacks.containsKey(binder)) {
                            Log.i(this, "removeVideoProvider - skipped; not present.", new Object[0]);
                            break;
                        }
                        this.this$0.mVideoCallbacks.remove(binder);
                        break;
                    }
                    case 2: {
                        this.this$0.onSetCamera((String)msg.obj);
                        break;
                    }
                    case 3: {
                        this.this$0.onSetPreviewSurface((Surface)msg.obj);
                        break;
                    }
                    case 4: {
                        this.this$0.onSetDisplaySurface((Surface)msg.obj);
                        break;
                    }
                    case 5: {
                        this.this$0.onSetDeviceOrientation(msg.arg1);
                        break;
                    }
                    case 6: {
                        this.this$0.onSetZoom(((Float)msg.obj).floatValue());
                        break;
                    }
                    case 7: {
                        SomeArgs args = (SomeArgs)msg.obj;
                        try {
                            this.this$0.onSendSessionModifyRequest((VideoProfile)args.arg1, (VideoProfile)args.arg2);
                            break;
                        }
                        finally {
                            args.recycle();
                        }
                    }
                    case 8: {
                        this.this$0.onSendSessionModifyResponse((VideoProfile)msg.obj);
                        break;
                    }
                    case 9: {
                        this.this$0.onRequestCameraCapabilities();
                        break;
                    }
                    case 10: {
                        this.this$0.onRequestConnectionDataUsage();
                        break;
                    }
                    case 11: {
                        this.this$0.onSetPauseImage((Uri)msg.obj);
                        break;
                    }
                }
            }

            private void __constructor__(VideoProvider videoProvider) {
                this.$$robo$$android_telecom_Connection_VideoProvider_VideoProviderHandler$__constructor__(videoProvider);
            }

            public VideoProviderHandler(VideoProvider videoProvider) {
                this.this$0 = videoProvider;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderHandler$__constructor__(android.telecom.Connection$VideoProvider ), 0, this, videoProvider);
            }

            private void __constructor__(VideoProvider videoProvider, Looper looper) {
                this.$$robo$$android_telecom_Connection_VideoProvider_VideoProviderHandler$__constructor__(videoProvider, looper);
            }

            public VideoProviderHandler(VideoProvider videoProvider, Looper looper) {
                this.this$0 = videoProvider;
                super(looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderHandler$__constructor__(android.telecom.Connection$VideoProvider android.os.Looper ), 0, this, videoProvider, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderHandler$handleMessage(android.os.Message ), 0, this, message);
            }

            public /* synthetic */ VideoProviderHandler() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VideoProviderHandler)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static abstract class Listener
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_telecom_Connection_Listener$__constructor__() {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onStateChanged(Connection c, int state) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onAddressChanged(Connection c, Uri newAddress, int presentation) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onCallerDisplayNameChanged(Connection c, String callerDisplayName, int presentation) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onVideoStateChanged(Connection c, int videoState) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onDisconnected(Connection c, DisconnectCause disconnectCause) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onPostDialWait(Connection c, String remaining) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onPostDialChar(Connection c, char nextChar) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onRingbackRequested(Connection c, boolean ringback) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onDestroyed(Connection c) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onConnectionCapabilitiesChanged(Connection c, int capabilities) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onConnectionPropertiesChanged(Connection c, int properties) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onVideoProviderChanged(Connection c, VideoProvider videoProvider) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onAudioModeIsVoipChanged(Connection c, boolean isVoip) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onStatusHintsChanged(Connection c, StatusHints statusHints) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onConferenceablesChanged(Connection c, List<Conferenceable> conferenceables) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onConferenceChanged(Connection c, Conference conference) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onConferenceParticipantsChanged(Connection c, List<ConferenceParticipant> participants) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onConferenceStarted() {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onConferenceMergeFailed(Connection c) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onExtrasChanged(Connection c, Bundle extras) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onExtrasRemoved(Connection c, List<String> keys) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onConnectionEvent(Connection c, String event, Bundle extras) {
        }

        private void __constructor__() {
            this.$$robo$$android_telecom_Connection_Listener$__constructor__();
        }

        public Listener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Connection_Listener$__constructor__(), 0, this);
        }

        public void onStateChanged(Connection connection, int n) {
            InvokeDynamicSupport.bootstrap("onStateChanged", $$robo$$android_telecom_Connection_Listener$onStateChanged(android.telecom.Connection int ), 0, this, connection, n);
        }

        public void onAddressChanged(Connection connection, Uri uri, int n) {
            InvokeDynamicSupport.bootstrap("onAddressChanged", $$robo$$android_telecom_Connection_Listener$onAddressChanged(android.telecom.Connection android.net.Uri int ), 0, this, connection, uri, n);
        }

        public void onCallerDisplayNameChanged(Connection connection, String string2, int n) {
            InvokeDynamicSupport.bootstrap("onCallerDisplayNameChanged", $$robo$$android_telecom_Connection_Listener$onCallerDisplayNameChanged(android.telecom.Connection java.lang.String int ), 0, this, connection, string2, n);
        }

        public void onVideoStateChanged(Connection connection, int n) {
            InvokeDynamicSupport.bootstrap("onVideoStateChanged", $$robo$$android_telecom_Connection_Listener$onVideoStateChanged(android.telecom.Connection int ), 0, this, connection, n);
        }

        public void onDisconnected(Connection connection, DisconnectCause disconnectCause) {
            InvokeDynamicSupport.bootstrap("onDisconnected", $$robo$$android_telecom_Connection_Listener$onDisconnected(android.telecom.Connection android.telecom.DisconnectCause ), 0, this, connection, disconnectCause);
        }

        public void onPostDialWait(Connection connection, String string2) {
            InvokeDynamicSupport.bootstrap("onPostDialWait", $$robo$$android_telecom_Connection_Listener$onPostDialWait(android.telecom.Connection java.lang.String ), 0, this, connection, string2);
        }

        public void onPostDialChar(Connection connection, char c) {
            InvokeDynamicSupport.bootstrap("onPostDialChar", $$robo$$android_telecom_Connection_Listener$onPostDialChar(android.telecom.Connection char ), 0, this, connection, c);
        }

        public void onRingbackRequested(Connection connection, boolean bl) {
            InvokeDynamicSupport.bootstrap("onRingbackRequested", $$robo$$android_telecom_Connection_Listener$onRingbackRequested(android.telecom.Connection boolean ), 0, this, connection, bl);
        }

        public void onDestroyed(Connection connection) {
            InvokeDynamicSupport.bootstrap("onDestroyed", $$robo$$android_telecom_Connection_Listener$onDestroyed(android.telecom.Connection ), 0, this, connection);
        }

        public void onConnectionCapabilitiesChanged(Connection connection, int n) {
            InvokeDynamicSupport.bootstrap("onConnectionCapabilitiesChanged", $$robo$$android_telecom_Connection_Listener$onConnectionCapabilitiesChanged(android.telecom.Connection int ), 0, this, connection, n);
        }

        public void onConnectionPropertiesChanged(Connection connection, int n) {
            InvokeDynamicSupport.bootstrap("onConnectionPropertiesChanged", $$robo$$android_telecom_Connection_Listener$onConnectionPropertiesChanged(android.telecom.Connection int ), 0, this, connection, n);
        }

        public void onVideoProviderChanged(Connection connection, VideoProvider videoProvider) {
            InvokeDynamicSupport.bootstrap("onVideoProviderChanged", $$robo$$android_telecom_Connection_Listener$onVideoProviderChanged(android.telecom.Connection android.telecom.Connection$VideoProvider ), 0, this, connection, videoProvider);
        }

        public void onAudioModeIsVoipChanged(Connection connection, boolean bl) {
            InvokeDynamicSupport.bootstrap("onAudioModeIsVoipChanged", $$robo$$android_telecom_Connection_Listener$onAudioModeIsVoipChanged(android.telecom.Connection boolean ), 0, this, connection, bl);
        }

        public void onStatusHintsChanged(Connection connection, StatusHints statusHints) {
            InvokeDynamicSupport.bootstrap("onStatusHintsChanged", $$robo$$android_telecom_Connection_Listener$onStatusHintsChanged(android.telecom.Connection android.telecom.StatusHints ), 0, this, connection, statusHints);
        }

        public void onConferenceablesChanged(Connection connection, List<Conferenceable> list) {
            InvokeDynamicSupport.bootstrap("onConferenceablesChanged", $$robo$$android_telecom_Connection_Listener$onConferenceablesChanged(android.telecom.Connection java.util.List<android.telecom.Conferenceable> ), 0, this, connection, list);
        }

        public void onConferenceChanged(Connection connection, Conference conference) {
            InvokeDynamicSupport.bootstrap("onConferenceChanged", $$robo$$android_telecom_Connection_Listener$onConferenceChanged(android.telecom.Connection android.telecom.Conference ), 0, this, connection, conference);
        }

        public void onConferenceParticipantsChanged(Connection connection, List<ConferenceParticipant> list) {
            InvokeDynamicSupport.bootstrap("onConferenceParticipantsChanged", $$robo$$android_telecom_Connection_Listener$onConferenceParticipantsChanged(android.telecom.Connection java.util.List<android.telecom.ConferenceParticipant> ), 0, this, connection, list);
        }

        public void onConferenceStarted() {
            InvokeDynamicSupport.bootstrap("onConferenceStarted", $$robo$$android_telecom_Connection_Listener$onConferenceStarted(), 0, this);
        }

        public void onConferenceMergeFailed(Connection connection) {
            InvokeDynamicSupport.bootstrap("onConferenceMergeFailed", $$robo$$android_telecom_Connection_Listener$onConferenceMergeFailed(android.telecom.Connection ), 0, this, connection);
        }

        public void onExtrasChanged(Connection connection, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onExtrasChanged", $$robo$$android_telecom_Connection_Listener$onExtrasChanged(android.telecom.Connection android.os.Bundle ), 0, this, connection, bundle);
        }

        public void onExtrasRemoved(Connection connection, List<String> list) {
            InvokeDynamicSupport.bootstrap("onExtrasRemoved", $$robo$$android_telecom_Connection_Listener$onExtrasRemoved(android.telecom.Connection java.util.List<java.lang.String> ), 0, this, connection, list);
        }

        public void onConnectionEvent(Connection connection, String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onConnectionEvent", $$robo$$android_telecom_Connection_Listener$onConnectionEvent(android.telecom.Connection java.lang.String android.os.Bundle ), 0, this, connection, string2, bundle);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Listener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

