/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telecom.Log;
import android.telecom.ParcelableCallAnalytics;
import android.telecom.PhoneAccount;
import android.telecom.PhoneAccountHandle;
import android.text.TextUtils;
import com.android.internal.telecom.ITelecomService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TelecomManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String ACTION_INCOMING_CALL = "android.telecom.action.INCOMING_CALL";
    public static String ACTION_NEW_UNKNOWN_CALL = "android.telecom.action.NEW_UNKNOWN_CALL";
    public static String ACTION_CONFIGURE_PHONE_ACCOUNT = "android.telecom.action.CONFIGURE_PHONE_ACCOUNT";
    public static String ACTION_SHOW_CALL_ACCESSIBILITY_SETTINGS = "android.telecom.action.SHOW_CALL_ACCESSIBILITY_SETTINGS";
    public static String ACTION_SHOW_CALL_SETTINGS = "android.telecom.action.SHOW_CALL_SETTINGS";
    public static String ACTION_SHOW_RESPOND_VIA_SMS_SETTINGS = "android.telecom.action.SHOW_RESPOND_VIA_SMS_SETTINGS";
    public static String ACTION_CHANGE_PHONE_ACCOUNTS = "android.telecom.action.CHANGE_PHONE_ACCOUNTS";
    public static String ACTION_PHONE_ACCOUNT_REGISTERED = "android.telecom.action.PHONE_ACCOUNT_REGISTERED";
    public static String ACTION_PHONE_ACCOUNT_UNREGISTERED = "android.telecom.action.PHONE_ACCOUNT_UNREGISTERED";
    public static String ACTION_CHANGE_DEFAULT_DIALER = "android.telecom.action.CHANGE_DEFAULT_DIALER";
    public static String ACTION_DEFAULT_DIALER_CHANGED = "android.telecom.action.DEFAULT_DIALER_CHANGED";
    public static String EXTRA_CHANGE_DEFAULT_DIALER_PACKAGE_NAME = "android.telecom.extra.CHANGE_DEFAULT_DIALER_PACKAGE_NAME";
    public static String EXTRA_START_CALL_WITH_SPEAKERPHONE = "android.telecom.extra.START_CALL_WITH_SPEAKERPHONE";
    public static String EXTRA_START_CALL_WITH_VIDEO_STATE = "android.telecom.extra.START_CALL_WITH_VIDEO_STATE";
    public static String EXTRA_PHONE_ACCOUNT_HANDLE = "android.telecom.extra.PHONE_ACCOUNT_HANDLE";
    public static String EXTRA_CALL_SUBJECT = "android.telecom.extra.CALL_SUBJECT";
    public static String EXTRA_INCOMING_CALL_ADDRESS = "android.telecom.extra.INCOMING_CALL_ADDRESS";
    public static String EXTRA_INCOMING_CALL_EXTRAS = "android.telecom.extra.INCOMING_CALL_EXTRAS";
    public static String EXTRA_OUTGOING_CALL_EXTRAS = "android.telecom.extra.OUTGOING_CALL_EXTRAS";
    public static String EXTRA_UNKNOWN_CALL_HANDLE = "android.telecom.extra.UNKNOWN_CALL_HANDLE";
    public static String EXTRA_CALL_CREATED_TIME_MILLIS = "android.telecom.extra.CALL_CREATED_TIME_MILLIS";
    public static String EXTRA_CALL_TELECOM_ROUTING_START_TIME_MILLIS = "android.telecom.extra.CALL_TELECOM_ROUTING_START_TIME_MILLIS";
    public static String EXTRA_CALL_TELECOM_ROUTING_END_TIME_MILLIS = "android.telecom.extra.CALL_TELECOM_ROUTING_END_TIME_MILLIS";
    public static String EXTRA_CALL_DISCONNECT_CAUSE = "android.telecom.extra.CALL_DISCONNECT_CAUSE";
    public static String EXTRA_CALL_DISCONNECT_MESSAGE = "android.telecom.extra.CALL_DISCONNECT_MESSAGE";
    public static String EXTRA_CONNECTION_SERVICE = "android.telecom.extra.CONNECTION_SERVICE";
    public static String EXTRA_CALL_TECHNOLOGY_TYPE = "android.telecom.extra.CALL_TECHNOLOGY_TYPE";
    public static String GATEWAY_PROVIDER_PACKAGE = "android.telecom.extra.GATEWAY_PROVIDER_PACKAGE";
    public static String GATEWAY_ORIGINAL_ADDRESS = "android.telecom.extra.GATEWAY_ORIGINAL_ADDRESS";
    public static String EXTRA_CALL_BACK_NUMBER = "android.telecom.extra.CALL_BACK_NUMBER";
    public static String METADATA_IN_CALL_SERVICE_UI = "android.telecom.IN_CALL_SERVICE_UI";
    public static String METADATA_IN_CALL_SERVICE_CAR_MODE_UI = "android.telecom.IN_CALL_SERVICE_CAR_MODE_UI";
    public static String METADATA_IN_CALL_SERVICE_RINGING = "android.telecom.IN_CALL_SERVICE_RINGING";
    public static String METADATA_INCLUDE_EXTERNAL_CALLS = "android.telecom.INCLUDE_EXTERNAL_CALLS";
    public static char DTMF_CHARACTER_PAUSE = ',';
    public static char DTMF_CHARACTER_WAIT = ';';
    public static int TTY_MODE_OFF = 0;
    public static int TTY_MODE_FULL = 1;
    public static int TTY_MODE_HCO = 2;
    public static int TTY_MODE_VCO = 3;
    public static String ACTION_CURRENT_TTY_MODE_CHANGED = "android.telecom.action.CURRENT_TTY_MODE_CHANGED";
    public static String EXTRA_CURRENT_TTY_MODE = "android.telecom.intent.extra.CURRENT_TTY_MODE";
    public static String ACTION_TTY_PREFERRED_MODE_CHANGED = "android.telecom.action.TTY_PREFERRED_MODE_CHANGED";
    public static String EXTRA_TTY_PREFERRED_MODE = "android.telecom.intent.extra.TTY_PREFERRED";
    public static String ACTION_SHOW_MISSED_CALLS_NOTIFICATION = "android.telecom.action.SHOW_MISSED_CALLS_NOTIFICATION";
    public static String EXTRA_NOTIFICATION_COUNT = "android.telecom.extra.NOTIFICATION_COUNT";
    public static String EXTRA_NOTIFICATION_PHONE_NUMBER = "android.telecom.extra.NOTIFICATION_PHONE_NUMBER";
    public static String EXTRA_CLEAR_MISSED_CALLS_INTENT = "android.telecom.extra.CLEAR_MISSED_CALLS_INTENT";
    public static String EXTRA_CALL_BACK_INTENT = "android.telecom.extra.CALL_BACK_INTENT";
    public static int PRESENTATION_ALLOWED = 1;
    public static int PRESENTATION_RESTRICTED = 2;
    public static int PRESENTATION_UNKNOWN = 3;
    public static int PRESENTATION_PAYPHONE = 4;
    private static String TAG = "TelecomManager";
    private Context mContext;
    private ITelecomService mTelecomServiceOverride;

    private static final TelecomManager $$robo$$android_telecom_TelecomManager$from(Context context) {
        return (TelecomManager)context.getSystemService("telecom");
    }

    private void $$robo$$android_telecom_TelecomManager$__constructor__(Context context) {
    }

    private void $$robo$$android_telecom_TelecomManager$__constructor__(Context context, ITelecomService telecomServiceImpl) {
        Context appContext = context.getApplicationContext();
        this.mContext = appContext != null ? appContext : context;
        this.mTelecomServiceOverride = telecomServiceImpl;
        Log.initMd5Sum();
    }

    private final PhoneAccountHandle $$robo$$android_telecom_TelecomManager$getDefaultOutgoingPhoneAccount(String uriScheme) {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getDefaultOutgoingPhoneAccount(uriScheme, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "Error calling ITelecomService#getDefaultOutgoingPhoneAccount", e);
        }
        return null;
    }

    private final PhoneAccountHandle $$robo$$android_telecom_TelecomManager$getUserSelectedOutgoingPhoneAccount() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getUserSelectedOutgoingPhoneAccount();
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "Error calling ITelecomService#getUserSelectedOutgoingPhoneAccount", e);
        }
        return null;
    }

    private final void $$robo$$android_telecom_TelecomManager$setUserSelectedOutgoingPhoneAccount(PhoneAccountHandle accountHandle) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().setUserSelectedOutgoingPhoneAccount(accountHandle);
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "Error calling ITelecomService#setUserSelectedOutgoingPhoneAccount");
        }
    }

    private final PhoneAccountHandle $$robo$$android_telecom_TelecomManager$getSimCallManager() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getSimCallManager();
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "Error calling ITelecomService#getSimCallManager");
        }
        return null;
    }

    private final PhoneAccountHandle $$robo$$android_telecom_TelecomManager$getSimCallManager(int userId) {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getSimCallManagerForUser(userId);
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "Error calling ITelecomService#getSimCallManagerForUser");
        }
        return null;
    }

    private final PhoneAccountHandle $$robo$$android_telecom_TelecomManager$getConnectionManager() {
        return this.getSimCallManager();
    }

    private final List<PhoneAccountHandle> $$robo$$android_telecom_TelecomManager$getPhoneAccountsSupportingScheme(String uriScheme) {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getPhoneAccountsSupportingScheme(uriScheme, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "Error calling ITelecomService#getPhoneAccountsSupportingScheme", e);
        }
        return new ArrayList<PhoneAccountHandle>();
    }

    private final List<PhoneAccountHandle> $$robo$$android_telecom_TelecomManager$getCallCapablePhoneAccounts() {
        return this.getCallCapablePhoneAccounts(false);
    }

    private final List<PhoneAccountHandle> $$robo$$android_telecom_TelecomManager$getCallCapablePhoneAccounts(boolean includeDisabledAccounts) {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getCallCapablePhoneAccounts(includeDisabledAccounts, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "Error calling ITelecomService#getCallCapablePhoneAccounts(" + includeDisabledAccounts + ")", e);
        }
        return new ArrayList<PhoneAccountHandle>();
    }

    private final List<PhoneAccountHandle> $$robo$$android_telecom_TelecomManager$getPhoneAccountsForPackage() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getPhoneAccountsForPackage(this.mContext.getPackageName());
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "Error calling ITelecomService#getPhoneAccountsForPackage", e);
        }
        return null;
    }

    private final PhoneAccount $$robo$$android_telecom_TelecomManager$getPhoneAccount(PhoneAccountHandle account) {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getPhoneAccount(account);
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "Error calling ITelecomService#getPhoneAccount", e);
        }
        return null;
    }

    private final int $$robo$$android_telecom_TelecomManager$getAllPhoneAccountsCount() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getAllPhoneAccountsCount();
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "Error calling ITelecomService#getAllPhoneAccountsCount", e);
        }
        return 0;
    }

    private final List<PhoneAccount> $$robo$$android_telecom_TelecomManager$getAllPhoneAccounts() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getAllPhoneAccounts();
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "Error calling ITelecomService#getAllPhoneAccounts", e);
        }
        return Collections.EMPTY_LIST;
    }

    private final List<PhoneAccountHandle> $$robo$$android_telecom_TelecomManager$getAllPhoneAccountHandles() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getAllPhoneAccountHandles();
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "Error calling ITelecomService#getAllPhoneAccountHandles", e);
        }
        return Collections.EMPTY_LIST;
    }

    private final void $$robo$$android_telecom_TelecomManager$registerPhoneAccount(PhoneAccount account) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().registerPhoneAccount(account);
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "Error calling ITelecomService#registerPhoneAccount", e);
        }
    }

    private final void $$robo$$android_telecom_TelecomManager$unregisterPhoneAccount(PhoneAccountHandle accountHandle) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().unregisterPhoneAccount(accountHandle);
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "Error calling ITelecomService#unregisterPhoneAccount", e);
        }
    }

    private final void $$robo$$android_telecom_TelecomManager$clearPhoneAccounts() {
        this.clearAccounts();
    }

    private final void $$robo$$android_telecom_TelecomManager$clearAccounts() {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().clearAccounts(this.mContext.getPackageName());
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "Error calling ITelecomService#clearAccounts", e);
        }
    }

    private final void $$robo$$android_telecom_TelecomManager$clearAccountsForPackage(String packageName) {
        try {
            if (this.isServiceConnected() && !TextUtils.isEmpty(packageName)) {
                this.getTelecomService().clearAccounts(packageName);
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "Error calling ITelecomService#clearAccountsForPackage", e);
        }
    }

    private final ComponentName $$robo$$android_telecom_TelecomManager$getDefaultPhoneApp() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getDefaultPhoneApp();
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "RemoteException attempting to get the default phone app.", e);
        }
        return null;
    }

    private final String $$robo$$android_telecom_TelecomManager$getDefaultDialerPackage() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getDefaultDialerPackage();
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "RemoteException attempting to get the default dialer package name.", e);
        }
        return null;
    }

    private final boolean $$robo$$android_telecom_TelecomManager$setDefaultDialer(String packageName) {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().setDefaultDialer(packageName);
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "RemoteException attempting to set the default dialer.", e);
        }
        return false;
    }

    private final String $$robo$$android_telecom_TelecomManager$getSystemDialerPackage() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getSystemDialerPackage();
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "RemoteException attempting to get the system dialer package name.", e);
        }
        return null;
    }

    private final boolean $$robo$$android_telecom_TelecomManager$isVoiceMailNumber(PhoneAccountHandle accountHandle, String number) {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().isVoiceMailNumber(accountHandle, number, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "RemoteException calling ITelecomService#isVoiceMailNumber.", e);
        }
        return false;
    }

    private final String $$robo$$android_telecom_TelecomManager$getVoiceMailNumber(PhoneAccountHandle accountHandle) {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getVoiceMailNumber(accountHandle, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "RemoteException calling ITelecomService#hasVoiceMailNumber.", e);
        }
        return null;
    }

    private final String $$robo$$android_telecom_TelecomManager$getLine1Number(PhoneAccountHandle accountHandle) {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getLine1Number(accountHandle, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "RemoteException calling ITelecomService#getLine1Number.", e);
        }
        return null;
    }

    private final boolean $$robo$$android_telecom_TelecomManager$isInCall() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().isInCall(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "RemoteException calling isInCall().", e);
        }
        return false;
    }

    private final int $$robo$$android_telecom_TelecomManager$getCallState() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getCallState();
            }
        }
        catch (RemoteException e) {
            android.util.Log.d("TelecomManager", "RemoteException calling getCallState().", e);
        }
        return 0;
    }

    private final boolean $$robo$$android_telecom_TelecomManager$isRinging() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().isRinging(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "RemoteException attempting to get ringing state of phone app.", e);
        }
        return false;
    }

    private final boolean $$robo$$android_telecom_TelecomManager$endCall() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().endCall();
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "Error calling ITelecomService#endCall", e);
        }
        return false;
    }

    private final void $$robo$$android_telecom_TelecomManager$acceptRingingCall() {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().acceptRingingCall();
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "Error calling ITelecomService#acceptRingingCall", e);
        }
    }

    private final void $$robo$$android_telecom_TelecomManager$acceptRingingCall(int videoState) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().acceptRingingCallWithVideoState(videoState);
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "Error calling ITelecomService#acceptRingingCallWithVideoState", e);
        }
    }

    private final void $$robo$$android_telecom_TelecomManager$silenceRinger() {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().silenceRinger(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "Error calling ITelecomService#silenceRinger", e);
        }
    }

    private final boolean $$robo$$android_telecom_TelecomManager$isTtySupported() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().isTtySupported(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "RemoteException attempting to get TTY supported state.", e);
        }
        return false;
    }

    private final int $$robo$$android_telecom_TelecomManager$getCurrentTtyMode() {
        try {
            if (this.isServiceConnected()) {
                return this.getTelecomService().getCurrentTtyMode(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "RemoteException attempting to get the current TTY mode.", e);
        }
        return 0;
    }

    private final void $$robo$$android_telecom_TelecomManager$addNewIncomingCall(PhoneAccountHandle phoneAccount, Bundle extras) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().addNewIncomingCall(phoneAccount, extras == null ? new Bundle() : extras);
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "RemoteException adding a new incoming call: " + phoneAccount, e);
        }
    }

    private final void $$robo$$android_telecom_TelecomManager$addNewUnknownCall(PhoneAccountHandle phoneAccount, Bundle extras) {
        try {
            if (this.isServiceConnected()) {
                this.getTelecomService().addNewUnknownCall(phoneAccount, extras == null ? new Bundle() : extras);
            }
        }
        catch (RemoteException e) {
            android.util.Log.e("TelecomManager", "RemoteException adding a new unknown call: " + phoneAccount, e);
        }
    }

    private final boolean $$robo$$android_telecom_TelecomManager$handleMmi(String dialString) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.handlePinMmi(dialString, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                android.util.Log.e("TelecomManager", "Error calling ITelecomService#handlePinMmi", e);
            }
        }
        return false;
    }

    private final boolean $$robo$$android_telecom_TelecomManager$handleMmi(String dialString, PhoneAccountHandle accountHandle) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.handlePinMmiForPhoneAccount(accountHandle, dialString, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                android.util.Log.e("TelecomManager", "Error calling ITelecomService#handlePinMmi", e);
            }
        }
        return false;
    }

    private final Uri $$robo$$android_telecom_TelecomManager$getAdnUriForPhoneAccount(PhoneAccountHandle accountHandle) {
        ITelecomService service = this.getTelecomService();
        if (service != null && accountHandle != null) {
            try {
                return service.getAdnUriForPhoneAccount(accountHandle, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                android.util.Log.e("TelecomManager", "Error calling ITelecomService#getAdnUriForPhoneAccount", e);
            }
        }
        return Uri.parse("content://icc/adn");
    }

    private final void $$robo$$android_telecom_TelecomManager$cancelMissedCallsNotification() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.cancelMissedCallsNotification(this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                android.util.Log.e("TelecomManager", "Error calling ITelecomService#cancelMissedCallsNotification", e);
            }
        }
    }

    private final void $$robo$$android_telecom_TelecomManager$showInCallScreen(boolean showDialpad) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.showInCallScreen(showDialpad, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                android.util.Log.e("TelecomManager", "Error calling ITelecomService#showCallScreen", e);
            }
        }
    }

    private final void $$robo$$android_telecom_TelecomManager$placeCall(Uri address, Bundle extras) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            if (address == null) {
                android.util.Log.w("TelecomManager", "Cannot place call to empty address.");
            }
            try {
                service.placeCall(address, extras == null ? new Bundle() : extras, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                android.util.Log.e("TelecomManager", "Error calling ITelecomService#placeCall", e);
            }
        }
    }

    private final void $$robo$$android_telecom_TelecomManager$enablePhoneAccount(PhoneAccountHandle handle, boolean isEnabled) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.enablePhoneAccount(handle, isEnabled);
            }
            catch (RemoteException e) {
                android.util.Log.e("TelecomManager", "Error enablePhoneAbbount", e);
            }
        }
    }

    private final List<ParcelableCallAnalytics> $$robo$$android_telecom_TelecomManager$dumpAnalytics() {
        ITelecomService service = this.getTelecomService();
        List<ParcelableCallAnalytics> result = null;
        if (service != null) {
            try {
                result = service.dumpCallAnalytics();
            }
            catch (RemoteException e) {
                android.util.Log.e("TelecomManager", "Error dumping call analytics", e);
            }
        }
        return result;
    }

    private final Intent $$robo$$android_telecom_TelecomManager$createManageBlockedNumbersIntent() {
        ITelecomService service = this.getTelecomService();
        Intent result = null;
        if (service != null) {
            try {
                result = service.createManageBlockedNumbersIntent();
            }
            catch (RemoteException e) {
                android.util.Log.e("TelecomManager", "Error calling ITelecomService#createManageBlockedNumbersIntent", e);
            }
        }
        return result;
    }

    private final ITelecomService $$robo$$android_telecom_TelecomManager$getTelecomService() {
        if (this.mTelecomServiceOverride != null) {
            return this.mTelecomServiceOverride;
        }
        return ITelecomService.Stub.asInterface(ServiceManager.getService("telecom"));
    }

    private final boolean $$robo$$android_telecom_TelecomManager$isServiceConnected() {
        boolean isConnected;
        boolean bl = isConnected = this.getTelecomService() != null;
        if (!isConnected) {
            android.util.Log.w("TelecomManager", "Telecom Service not found.");
        }
        return isConnected;
    }

    public static TelecomManager from(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_telecom_TelecomManager$from(android.content.Context ), 0, (Context)context);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_telecom_TelecomManager$__constructor__(context);
    }

    public TelecomManager(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_TelecomManager$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, ITelecomService iTelecomService) {
        this.$$robo$$android_telecom_TelecomManager$__constructor__(context, iTelecomService);
    }

    public TelecomManager(Context context, ITelecomService iTelecomService) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_TelecomManager$__constructor__(android.content.Context com.android.internal.telecom.ITelecomService ), 0, this, context, iTelecomService);
    }

    public PhoneAccountHandle getDefaultOutgoingPhoneAccount(String string2) {
        return InvokeDynamicSupport.bootstrap("getDefaultOutgoingPhoneAccount", $$robo$$android_telecom_TelecomManager$getDefaultOutgoingPhoneAccount(java.lang.String ), 0, this, string2);
    }

    public PhoneAccountHandle getUserSelectedOutgoingPhoneAccount() {
        return InvokeDynamicSupport.bootstrap("getUserSelectedOutgoingPhoneAccount", $$robo$$android_telecom_TelecomManager$getUserSelectedOutgoingPhoneAccount(), 0, this);
    }

    public void setUserSelectedOutgoingPhoneAccount(PhoneAccountHandle phoneAccountHandle) {
        InvokeDynamicSupport.bootstrap("setUserSelectedOutgoingPhoneAccount", $$robo$$android_telecom_TelecomManager$setUserSelectedOutgoingPhoneAccount(android.telecom.PhoneAccountHandle ), 0, this, phoneAccountHandle);
    }

    public PhoneAccountHandle getSimCallManager() {
        return InvokeDynamicSupport.bootstrap("getSimCallManager", $$robo$$android_telecom_TelecomManager$getSimCallManager(), 0, this);
    }

    public PhoneAccountHandle getSimCallManager(int n) {
        return InvokeDynamicSupport.bootstrap("getSimCallManager", $$robo$$android_telecom_TelecomManager$getSimCallManager(int ), 0, this, n);
    }

    public PhoneAccountHandle getConnectionManager() {
        return InvokeDynamicSupport.bootstrap("getConnectionManager", $$robo$$android_telecom_TelecomManager$getConnectionManager(), 0, this);
    }

    public List<PhoneAccountHandle> getPhoneAccountsSupportingScheme(String string2) {
        return InvokeDynamicSupport.bootstrap("getPhoneAccountsSupportingScheme", $$robo$$android_telecom_TelecomManager$getPhoneAccountsSupportingScheme(java.lang.String ), 0, this, string2);
    }

    public List<PhoneAccountHandle> getCallCapablePhoneAccounts() {
        return InvokeDynamicSupport.bootstrap("getCallCapablePhoneAccounts", $$robo$$android_telecom_TelecomManager$getCallCapablePhoneAccounts(), 0, this);
    }

    public List<PhoneAccountHandle> getCallCapablePhoneAccounts(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getCallCapablePhoneAccounts", $$robo$$android_telecom_TelecomManager$getCallCapablePhoneAccounts(boolean ), 0, this, bl);
    }

    public List<PhoneAccountHandle> getPhoneAccountsForPackage() {
        return InvokeDynamicSupport.bootstrap("getPhoneAccountsForPackage", $$robo$$android_telecom_TelecomManager$getPhoneAccountsForPackage(), 0, this);
    }

    public PhoneAccount getPhoneAccount(PhoneAccountHandle phoneAccountHandle) {
        return InvokeDynamicSupport.bootstrap("getPhoneAccount", $$robo$$android_telecom_TelecomManager$getPhoneAccount(android.telecom.PhoneAccountHandle ), 0, this, phoneAccountHandle);
    }

    public int getAllPhoneAccountsCount() {
        return (int)InvokeDynamicSupport.bootstrap("getAllPhoneAccountsCount", $$robo$$android_telecom_TelecomManager$getAllPhoneAccountsCount(), 0, this);
    }

    public List<PhoneAccount> getAllPhoneAccounts() {
        return InvokeDynamicSupport.bootstrap("getAllPhoneAccounts", $$robo$$android_telecom_TelecomManager$getAllPhoneAccounts(), 0, this);
    }

    public List<PhoneAccountHandle> getAllPhoneAccountHandles() {
        return InvokeDynamicSupport.bootstrap("getAllPhoneAccountHandles", $$robo$$android_telecom_TelecomManager$getAllPhoneAccountHandles(), 0, this);
    }

    public void registerPhoneAccount(PhoneAccount phoneAccount) {
        InvokeDynamicSupport.bootstrap("registerPhoneAccount", $$robo$$android_telecom_TelecomManager$registerPhoneAccount(android.telecom.PhoneAccount ), 0, this, phoneAccount);
    }

    public void unregisterPhoneAccount(PhoneAccountHandle phoneAccountHandle) {
        InvokeDynamicSupport.bootstrap("unregisterPhoneAccount", $$robo$$android_telecom_TelecomManager$unregisterPhoneAccount(android.telecom.PhoneAccountHandle ), 0, this, phoneAccountHandle);
    }

    public void clearPhoneAccounts() {
        InvokeDynamicSupport.bootstrap("clearPhoneAccounts", $$robo$$android_telecom_TelecomManager$clearPhoneAccounts(), 0, this);
    }

    public void clearAccounts() {
        InvokeDynamicSupport.bootstrap("clearAccounts", $$robo$$android_telecom_TelecomManager$clearAccounts(), 0, this);
    }

    public void clearAccountsForPackage(String string2) {
        InvokeDynamicSupport.bootstrap("clearAccountsForPackage", $$robo$$android_telecom_TelecomManager$clearAccountsForPackage(java.lang.String ), 0, this, string2);
    }

    public ComponentName getDefaultPhoneApp() {
        return InvokeDynamicSupport.bootstrap("getDefaultPhoneApp", $$robo$$android_telecom_TelecomManager$getDefaultPhoneApp(), 0, this);
    }

    public String getDefaultDialerPackage() {
        return InvokeDynamicSupport.bootstrap("getDefaultDialerPackage", $$robo$$android_telecom_TelecomManager$getDefaultDialerPackage(), 0, this);
    }

    public boolean setDefaultDialer(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setDefaultDialer", $$robo$$android_telecom_TelecomManager$setDefaultDialer(java.lang.String ), 0, this, string2);
    }

    public String getSystemDialerPackage() {
        return InvokeDynamicSupport.bootstrap("getSystemDialerPackage", $$robo$$android_telecom_TelecomManager$getSystemDialerPackage(), 0, this);
    }

    public boolean isVoiceMailNumber(PhoneAccountHandle phoneAccountHandle, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isVoiceMailNumber", $$robo$$android_telecom_TelecomManager$isVoiceMailNumber(android.telecom.PhoneAccountHandle java.lang.String ), 0, this, phoneAccountHandle, string2);
    }

    public String getVoiceMailNumber(PhoneAccountHandle phoneAccountHandle) {
        return InvokeDynamicSupport.bootstrap("getVoiceMailNumber", $$robo$$android_telecom_TelecomManager$getVoiceMailNumber(android.telecom.PhoneAccountHandle ), 0, this, phoneAccountHandle);
    }

    public String getLine1Number(PhoneAccountHandle phoneAccountHandle) {
        return InvokeDynamicSupport.bootstrap("getLine1Number", $$robo$$android_telecom_TelecomManager$getLine1Number(android.telecom.PhoneAccountHandle ), 0, this, phoneAccountHandle);
    }

    public boolean isInCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInCall", $$robo$$android_telecom_TelecomManager$isInCall(), 0, this);
    }

    public int getCallState() {
        return (int)InvokeDynamicSupport.bootstrap("getCallState", $$robo$$android_telecom_TelecomManager$getCallState(), 0, this);
    }

    public boolean isRinging() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRinging", $$robo$$android_telecom_TelecomManager$isRinging(), 0, this);
    }

    public boolean endCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("endCall", $$robo$$android_telecom_TelecomManager$endCall(), 0, this);
    }

    public void acceptRingingCall() {
        InvokeDynamicSupport.bootstrap("acceptRingingCall", $$robo$$android_telecom_TelecomManager$acceptRingingCall(), 0, this);
    }

    public void acceptRingingCall(int n) {
        InvokeDynamicSupport.bootstrap("acceptRingingCall", $$robo$$android_telecom_TelecomManager$acceptRingingCall(int ), 0, this, n);
    }

    public void silenceRinger() {
        InvokeDynamicSupport.bootstrap("silenceRinger", $$robo$$android_telecom_TelecomManager$silenceRinger(), 0, this);
    }

    public boolean isTtySupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTtySupported", $$robo$$android_telecom_TelecomManager$isTtySupported(), 0, this);
    }

    public int getCurrentTtyMode() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentTtyMode", $$robo$$android_telecom_TelecomManager$getCurrentTtyMode(), 0, this);
    }

    public void addNewIncomingCall(PhoneAccountHandle phoneAccountHandle, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("addNewIncomingCall", $$robo$$android_telecom_TelecomManager$addNewIncomingCall(android.telecom.PhoneAccountHandle android.os.Bundle ), 0, this, phoneAccountHandle, bundle);
    }

    public void addNewUnknownCall(PhoneAccountHandle phoneAccountHandle, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("addNewUnknownCall", $$robo$$android_telecom_TelecomManager$addNewUnknownCall(android.telecom.PhoneAccountHandle android.os.Bundle ), 0, this, phoneAccountHandle, bundle);
    }

    public boolean handleMmi(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleMmi", $$robo$$android_telecom_TelecomManager$handleMmi(java.lang.String ), 0, this, string2);
    }

    public boolean handleMmi(String string2, PhoneAccountHandle phoneAccountHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleMmi", $$robo$$android_telecom_TelecomManager$handleMmi(java.lang.String android.telecom.PhoneAccountHandle ), 0, this, string2, phoneAccountHandle);
    }

    public Uri getAdnUriForPhoneAccount(PhoneAccountHandle phoneAccountHandle) {
        return InvokeDynamicSupport.bootstrap("getAdnUriForPhoneAccount", $$robo$$android_telecom_TelecomManager$getAdnUriForPhoneAccount(android.telecom.PhoneAccountHandle ), 0, this, phoneAccountHandle);
    }

    public void cancelMissedCallsNotification() {
        InvokeDynamicSupport.bootstrap("cancelMissedCallsNotification", $$robo$$android_telecom_TelecomManager$cancelMissedCallsNotification(), 0, this);
    }

    public void showInCallScreen(boolean bl) {
        InvokeDynamicSupport.bootstrap("showInCallScreen", $$robo$$android_telecom_TelecomManager$showInCallScreen(boolean ), 0, this, bl);
    }

    public void placeCall(Uri uri, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("placeCall", $$robo$$android_telecom_TelecomManager$placeCall(android.net.Uri android.os.Bundle ), 0, this, uri, bundle);
    }

    public void enablePhoneAccount(PhoneAccountHandle phoneAccountHandle, boolean bl) {
        InvokeDynamicSupport.bootstrap("enablePhoneAccount", $$robo$$android_telecom_TelecomManager$enablePhoneAccount(android.telecom.PhoneAccountHandle boolean ), 0, this, phoneAccountHandle, bl);
    }

    public List<ParcelableCallAnalytics> dumpAnalytics() {
        return InvokeDynamicSupport.bootstrap("dumpAnalytics", $$robo$$android_telecom_TelecomManager$dumpAnalytics(), 0, this);
    }

    public Intent createManageBlockedNumbersIntent() {
        return InvokeDynamicSupport.bootstrap("createManageBlockedNumbersIntent", $$robo$$android_telecom_TelecomManager$createManageBlockedNumbersIntent(), 0, this);
    }

    private ITelecomService getTelecomService() {
        return InvokeDynamicSupport.bootstrap("getTelecomService", $$robo$$android_telecom_TelecomManager$getTelecomService(), 0, this);
    }

    private boolean isServiceConnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isServiceConnected", $$robo$$android_telecom_TelecomManager$isServiceConnected(), 0, this);
    }

    public /* synthetic */ TelecomManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TelecomManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

