/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.StaticLayout;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Hyphenator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static Object sLock;
    @GuardedBy(value="sLock")
    static HashMap<Locale, Hyphenator> sMap;
    static Hyphenator sEmptyHyphenator;
    private long mNativePtr;
    private ByteBuffer mBuffer;
    private static String[][] LOCALE_FALLBACK_DATA;

    private void $$robo$$android_text_Hyphenator$__constructor__(long nativePtr, ByteBuffer b) {
        this.mNativePtr = nativePtr;
        this.mBuffer = b;
    }

    private final long $$robo$$android_text_Hyphenator$getNativePtr() {
        return this.mNativePtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Hyphenator $$robo$$android_text_Hyphenator$get(Locale locale) {
        Object object = sLock;
        synchronized (object) {
            Locale scriptOnlyLocale;
            Locale languageAndVariantOnlyLocale;
            Hyphenator result = sMap.get(locale);
            if (result != null) {
                return result;
            }
            String variant = locale.getVariant();
            if (!variant.isEmpty() && (result = sMap.get(languageAndVariantOnlyLocale = new Locale(locale.getLanguage(), "", variant))) != null) {
                sMap.put(locale, result);
                return result;
            }
            Locale languageOnlyLocale = new Locale(locale.getLanguage());
            result = sMap.get(languageOnlyLocale);
            if (result != null) {
                sMap.put(locale, result);
                return result;
            }
            String script = locale.getScript();
            if (!script.equals("") && (result = sMap.get(scriptOnlyLocale = new Locale.Builder().setLanguage("und").setScript(script).build())) != null) {
                sMap.put(locale, result);
                return result;
            }
            sMap.put(locale, sEmptyHyphenator);
        }
        return sEmptyHyphenator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Hyphenator $$robo$$android_text_Hyphenator$loadHyphenator(String languageTag) {
        Hyphenator hyphenator;
        String patternFilename = "hyph-" + languageTag.toLowerCase(Locale.US) + ".hyb";
        File patternFile = new File(Hyphenator.getSystemHyphenatorLocation(), patternFilename);
        RandomAccessFile f = new RandomAccessFile(patternFile, "r");
        try {
            FileChannel fc = f.getChannel();
            MappedByteBuffer buf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            long nativePtr = StaticLayout.nLoadHyphenator(buf, 0);
            hyphenator = new Hyphenator(nativePtr, buf);
        }
        catch (Throwable throwable) {
            try {
                f.close();
                throw throwable;
            }
            catch (IOException e) {
                Log.e(TAG, "error loading hyphenation " + patternFile, e);
                return null;
            }
        }
        f.close();
        return hyphenator;
    }

    private static final File $$robo$$android_text_Hyphenator$getSystemHyphenatorLocation() {
        return new File("/system/usr/hyphen-data");
    }

    private static final void $$robo$$android_text_Hyphenator$init() {
        int i;
        sMap.put(null, null);
        String[] availableLanguages = new String[]{"as", "bn", "cy", "da", "de-1901", "de-1996", "de-CH-1901", "en-GB", "en-US", "es", "et", "eu", "fr", "ga", "gu", "hi", "hr", "hu", "hy", "kn", "ml", "mn-Cyrl", "mr", "nb", "nn", "or", "pa", "pt", "sl", "ta", "te", "tk", "und-Ethi"};
        for (i = 0; i < availableLanguages.length; ++i) {
            String languageTag = availableLanguages[i];
            Hyphenator h = Hyphenator.loadHyphenator(languageTag);
            if (h == null) continue;
            sMap.put(Locale.forLanguageTag(languageTag), h);
        }
        for (i = 0; i < LOCALE_FALLBACK_DATA.length; ++i) {
            String language = LOCALE_FALLBACK_DATA[i][0];
            String fallback = LOCALE_FALLBACK_DATA[i][1];
            sMap.put(Locale.forLanguageTag(language), sMap.get(Locale.forLanguageTag(fallback)));
        }
    }

    static void __staticInitializer__() {
        TAG = "Hyphenator";
        sLock = new Object();
        sMap = new HashMap();
        sEmptyHyphenator = new Hyphenator(StaticLayout.nLoadHyphenator(null, 0), null);
        LOCALE_FALLBACK_DATA = new String[][]{{"en-AS", "en-US"}, {"en-GU", "en-US"}, {"en-MH", "en-US"}, {"en-MP", "en-US"}, {"en-PR", "en-US"}, {"en-UM", "en-US"}, {"en-VI", "en-US"}, {"en", "en-GB"}, {"de", "de-1996"}, {"de-LI-1901", "de-CH-1901"}, {"no", "nb"}, {"mn", "mn-Cyrl"}, {"am", "und-Ethi"}, {"byn", "und-Ethi"}, {"gez", "und-Ethi"}, {"ti", "und-Ethi"}, {"wal", "und-Ethi"}};
    }

    private void __constructor__(long l, ByteBuffer byteBuffer) {
        this.$$robo$$android_text_Hyphenator$__constructor__(l, byteBuffer);
    }

    private Hyphenator(long l, ByteBuffer byteBuffer) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_Hyphenator$__constructor__(long java.nio.ByteBuffer ), 0, this, l, byteBuffer);
    }

    public long getNativePtr() {
        return (long)InvokeDynamicSupport.bootstrap("getNativePtr", $$robo$$android_text_Hyphenator$getNativePtr(), 0, this);
    }

    public static Hyphenator get(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$android_text_Hyphenator$get(java.util.Locale ), 0, (Locale)locale);
    }

    private static Hyphenator loadHyphenator(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("loadHyphenator", $$robo$$android_text_Hyphenator$loadHyphenator(java.lang.String ), 0, (String)string2);
    }

    private static File getSystemHyphenatorLocation() {
        return InvokeDynamicSupport.bootstrapStatic("getSystemHyphenatorLocation", $$robo$$android_text_Hyphenator$getSystemHyphenatorLocation(), 0);
    }

    public static void init() {
        InvokeDynamicSupport.bootstrapStatic("init", $$robo$$android_text_Hyphenator$init(), 0);
    }

    static {
        RobolectricInternals.classInitializing(Hyphenator.class);
    }

    public /* synthetic */ Hyphenator() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Hyphenator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

