/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.content.res.Resources;
import android.icu.util.ULocale;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemProperties;
import android.text.AndroidCharacter;
import android.text.Annotation;
import android.text.GetChars;
import android.text.MeasuredText;
import android.text.ParcelableSpan;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.BulletSpan;
import android.text.style.CharacterStyle;
import android.text.style.EasyEditSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.LocaleSpan;
import android.text.style.MetricAffectingSpan;
import android.text.style.QuoteSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.ReplacementSpan;
import android.text.style.ScaleXSpan;
import android.text.style.SpellCheckSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuggestionRangeSpan;
import android.text.style.SuggestionSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TextAppearanceSpan;
import android.text.style.TtsSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.util.Log;
import android.util.Printer;
import com.android.internal.util.ArrayUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TextUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "TextUtils";
    static char[] ELLIPSIS_NORMAL;
    public static String ELLIPSIS_STRING;
    static char[] ELLIPSIS_TWO_DOTS;
    private static String ELLIPSIS_TWO_DOTS_STRING;
    public static int ALIGNMENT_SPAN = 1;
    public static int FIRST_SPAN = 1;
    public static int FOREGROUND_COLOR_SPAN = 2;
    public static int RELATIVE_SIZE_SPAN = 3;
    public static int SCALE_X_SPAN = 4;
    public static int STRIKETHROUGH_SPAN = 5;
    public static int UNDERLINE_SPAN = 6;
    public static int STYLE_SPAN = 7;
    public static int BULLET_SPAN = 8;
    public static int QUOTE_SPAN = 9;
    public static int LEADING_MARGIN_SPAN = 10;
    public static int URL_SPAN = 11;
    public static int BACKGROUND_COLOR_SPAN = 12;
    public static int TYPEFACE_SPAN = 13;
    public static int SUPERSCRIPT_SPAN = 14;
    public static int SUBSCRIPT_SPAN = 15;
    public static int ABSOLUTE_SIZE_SPAN = 16;
    public static int TEXT_APPEARANCE_SPAN = 17;
    public static int ANNOTATION = 18;
    public static int SUGGESTION_SPAN = 19;
    public static int SPELL_CHECK_SPAN = 20;
    public static int SUGGESTION_RANGE_SPAN = 21;
    public static int EASY_EDIT_SPAN = 22;
    public static int LOCALE_SPAN = 23;
    public static int TTS_SPAN = 24;
    public static int LAST_SPAN = 24;
    public static Parcelable.Creator<CharSequence> CHAR_SEQUENCE_CREATOR;
    private static char FIRST_RIGHT_TO_LEFT = '\u0590';
    public static int CAP_MODE_CHARACTERS = 4096;
    public static int CAP_MODE_WORDS = 8192;
    public static int CAP_MODE_SENTENCES = 16384;
    private static Object sLock;
    private static char[] sTemp;
    private static String[] EMPTY_STRING_ARRAY;
    private static char ZWNBS_CHAR = '\ufeff';

    private void $$robo$$android_text_TextUtils$__constructor__() {
    }

    private static final void $$robo$$android_text_TextUtils$getChars(CharSequence s, int start, int end, char[] dest, int destoff) {
        Class<?> c = s.getClass();
        if (c == String.class) {
            ((String)s).getChars(start, end, dest, destoff);
        } else if (c == StringBuffer.class) {
            ((StringBuffer)s).getChars(start, end, dest, destoff);
        } else if (c == StringBuilder.class) {
            ((StringBuilder)s).getChars(start, end, dest, destoff);
        } else if (s instanceof GetChars) {
            ((GetChars)s).getChars(start, end, dest, destoff);
        } else {
            for (int i = start; i < end; ++i) {
                dest[destoff++] = s.charAt(i);
            }
        }
    }

    private static final int $$robo$$android_text_TextUtils$indexOf(CharSequence s, char ch) {
        return TextUtils.indexOf(s, ch, 0);
    }

    private static final int $$robo$$android_text_TextUtils$indexOf(CharSequence s, char ch, int start) {
        Class<?> c = s.getClass();
        if (c == String.class) {
            return ((String)s).indexOf(ch, start);
        }
        return TextUtils.indexOf(s, ch, start, s.length());
    }

    private static final int $$robo$$android_text_TextUtils$indexOf(CharSequence s, char ch, int start, int end) {
        Class<?> c = s.getClass();
        if (s instanceof GetChars || c == StringBuffer.class || c == StringBuilder.class || c == String.class) {
            int INDEX_INCREMENT = 500;
            char[] temp = TextUtils.obtain(500);
            while (start < end) {
                int segend = start + 500;
                if (segend > end) {
                    segend = end;
                }
                TextUtils.getChars(s, start, segend, temp, 0);
                int count = segend - start;
                for (int i = 0; i < count; ++i) {
                    if (temp[i] != ch) continue;
                    TextUtils.recycle(temp);
                    return i + start;
                }
                start = segend;
            }
            TextUtils.recycle(temp);
            return -1;
        }
        for (int i = start; i < end; ++i) {
            if (s.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    private static final int $$robo$$android_text_TextUtils$lastIndexOf(CharSequence s, char ch) {
        return TextUtils.lastIndexOf(s, ch, s.length() - 1);
    }

    private static final int $$robo$$android_text_TextUtils$lastIndexOf(CharSequence s, char ch, int last) {
        Class<?> c = s.getClass();
        if (c == String.class) {
            return ((String)s).lastIndexOf(ch, last);
        }
        return TextUtils.lastIndexOf(s, ch, 0, last);
    }

    private static final int $$robo$$android_text_TextUtils$lastIndexOf(CharSequence s, char ch, int start, int last) {
        if (last < 0) {
            return -1;
        }
        if (last >= s.length()) {
            last = s.length() - 1;
        }
        int end = last + 1;
        Class<?> c = s.getClass();
        if (s instanceof GetChars || c == StringBuffer.class || c == StringBuilder.class || c == String.class) {
            int INDEX_INCREMENT = 500;
            char[] temp = TextUtils.obtain(500);
            while (start < end) {
                int segstart = end - 500;
                if (segstart < start) {
                    segstart = start;
                }
                TextUtils.getChars(s, segstart, end, temp, 0);
                int count = end - segstart;
                for (int i = count - 1; i >= 0; --i) {
                    if (temp[i] != ch) continue;
                    TextUtils.recycle(temp);
                    return i + segstart;
                }
                end = segstart;
            }
            TextUtils.recycle(temp);
            return -1;
        }
        for (int i = end - 1; i >= start; --i) {
            if (s.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    private static final int $$robo$$android_text_TextUtils$indexOf(CharSequence s, CharSequence needle) {
        return TextUtils.indexOf(s, needle, 0, s.length());
    }

    private static final int $$robo$$android_text_TextUtils$indexOf(CharSequence s, CharSequence needle, int start) {
        return TextUtils.indexOf(s, needle, start, s.length());
    }

    private static final int $$robo$$android_text_TextUtils$indexOf(CharSequence s, CharSequence needle, int start, int end) {
        int nlen = needle.length();
        if (nlen == 0) {
            return start;
        }
        char c = needle.charAt(0);
        while ((start = TextUtils.indexOf(s, c, start)) <= end - nlen) {
            if (start < 0) {
                return -1;
            }
            if (TextUtils.regionMatches(s, start, needle, 0, nlen)) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    private static final boolean $$robo$$android_text_TextUtils$regionMatches(CharSequence one, int toffset, CharSequence two, int ooffset, int len) {
        int tempLen = 2 * len;
        if (tempLen < len) {
            throw new IndexOutOfBoundsException();
        }
        char[] temp = TextUtils.obtain(tempLen);
        TextUtils.getChars(one, toffset, toffset + len, temp, 0);
        TextUtils.getChars(two, ooffset, ooffset + len, temp, len);
        boolean match = true;
        for (int i = 0; i < len; ++i) {
            if (temp[i] == temp[i + len]) continue;
            match = false;
            break;
        }
        TextUtils.recycle(temp);
        return match;
    }

    private static final String $$robo$$android_text_TextUtils$substring(CharSequence source, int start, int end) {
        if (source instanceof String) {
            return ((String)source).substring(start, end);
        }
        if (source instanceof StringBuilder) {
            return ((StringBuilder)source).substring(start, end);
        }
        if (source instanceof StringBuffer) {
            return ((StringBuffer)source).substring(start, end);
        }
        char[] temp = TextUtils.obtain(end - start);
        TextUtils.getChars(source, start, end, temp, 0);
        String ret = new String(temp, 0, end - start);
        TextUtils.recycle(temp);
        return ret;
    }

    private static final String $$robo$$android_text_TextUtils$join(CharSequence delimiter, Object[] tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    private static final String $$robo$$android_text_TextUtils$join(CharSequence delimiter, Iterable tokens) {
        StringBuilder sb = new StringBuilder();
        Iterator it = tokens.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(delimiter);
                sb.append(it.next());
            }
        }
        return sb.toString();
    }

    private static final String[] $$robo$$android_text_TextUtils$split(String text, String expression) {
        if (text.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return text.split(expression, -1);
    }

    private static final String[] $$robo$$android_text_TextUtils$split(String text, Pattern pattern) {
        if (text.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return pattern.split(text, -1);
    }

    private static final CharSequence $$robo$$android_text_TextUtils$stringOrSpannedString(CharSequence source) {
        if (source == null) {
            return null;
        }
        if (source instanceof SpannedString) {
            return source;
        }
        if (source instanceof Spanned) {
            return new SpannedString(source);
        }
        return source.toString();
    }

    private static final boolean $$robo$$android_text_TextUtils$isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    private static final String $$robo$$android_text_TextUtils$nullIfEmpty(String str) {
        return TextUtils.isEmpty(str) ? null : str;
    }

    private static final int $$robo$$android_text_TextUtils$getTrimmedLength(CharSequence s) {
        int end;
        int start;
        int len = s.length();
        for (start = 0; start < len && s.charAt(start) <= ' '; ++start) {
        }
        for (end = len; end > start && s.charAt(end - 1) <= ' '; --end) {
        }
        return end - start;
    }

    private static final boolean $$robo$$android_text_TextUtils$equals(CharSequence a, CharSequence b) {
        int length;
        if (a == b) {
            return true;
        }
        if (a != null && b != null && (length = a.length()) == b.length()) {
            if (a instanceof String && b instanceof String) {
                return a.equals(b);
            }
            for (int i = 0; i < length; ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Deprecated
    private static final CharSequence $$robo$$android_text_TextUtils$getReverse(CharSequence source, int start, int end) {
        return new Reverser(source, start, end);
    }

    private static final void $$robo$$android_text_TextUtils$writeToParcel(CharSequence cs, Parcel p, int parcelableFlags) {
        if (cs instanceof Spanned) {
            p.writeInt(0);
            p.writeString(cs.toString());
            Spanned sp = (Spanned)cs;
            Object[] os = sp.getSpans(0, cs.length(), Object.class);
            for (int i = 0; i < os.length; ++i) {
                Object o = os[i];
                Object prop = os[i];
                if (prop instanceof CharacterStyle) {
                    prop = ((CharacterStyle)prop).getUnderlying();
                }
                if (!(prop instanceof ParcelableSpan)) continue;
                ParcelableSpan ps = (ParcelableSpan)prop;
                int spanTypeId = ps.getSpanTypeIdInternal();
                if (spanTypeId < 1 || spanTypeId > 24) {
                    Log.e("TextUtils", "External class \"" + ps.getClass().getSimpleName() + "\" is attempting to use the frameworks-only ParcelableSpan interface");
                    continue;
                }
                p.writeInt(spanTypeId);
                ps.writeToParcelInternal(p, parcelableFlags);
                TextUtils.writeWhere(p, sp, o);
            }
            p.writeInt(0);
        } else {
            p.writeInt(1);
            if (cs != null) {
                p.writeString(cs.toString());
            } else {
                p.writeString(null);
            }
        }
    }

    private static final void $$robo$$android_text_TextUtils$writeWhere(Parcel p, Spanned sp, Object o) {
        p.writeInt(sp.getSpanStart(o));
        p.writeInt(sp.getSpanEnd(o));
        p.writeInt(sp.getSpanFlags(o));
    }

    private static final void $$robo$$android_text_TextUtils$dumpSpans(CharSequence cs, Printer printer, String prefix) {
        if (cs instanceof Spanned) {
            Spanned sp = (Spanned)cs;
            Object[] os = sp.getSpans(0, cs.length(), Object.class);
            for (int i = 0; i < os.length; ++i) {
                Object o = os[i];
                printer.println(prefix + cs.subSequence(sp.getSpanStart(o), sp.getSpanEnd(o)) + ": " + Integer.toHexString(System.identityHashCode(o)) + " " + o.getClass().getCanonicalName() + " (" + sp.getSpanStart(o) + "-" + sp.getSpanEnd(o) + ") fl=#" + sp.getSpanFlags(o));
            }
        } else {
            printer.println(prefix + cs + ": (no spans)");
        }
    }

    private static final CharSequence $$robo$$android_text_TextUtils$replace(CharSequence template, String[] sources, CharSequence[] destinations) {
        int i;
        SpannableStringBuilder tb = new SpannableStringBuilder(template);
        for (i = 0; i < sources.length; ++i) {
            int where = TextUtils.indexOf((CharSequence)tb, sources[i]);
            if (where < 0) continue;
            tb.setSpan(sources[i], where, where + sources[i].length(), 33);
        }
        for (i = 0; i < sources.length; ++i) {
            int start = tb.getSpanStart(sources[i]);
            int end = tb.getSpanEnd(sources[i]);
            if (start < 0) continue;
            tb.replace(start, end, destinations[i]);
        }
        return tb;
    }

    private static final CharSequence $$robo$$android_text_TextUtils$expandTemplate(CharSequence template, CharSequence ... values) {
        if (values.length > 9) {
            throw new IllegalArgumentException("max of 9 values are supported");
        }
        SpannableStringBuilder ssb = new SpannableStringBuilder(template);
        try {
            int i = 0;
            while (i < ssb.length()) {
                if (ssb.charAt(i) == '^') {
                    char next = ssb.charAt(i + 1);
                    if (next == '^') {
                        ssb.delete(i + 1, i + 2);
                        ++i;
                        continue;
                    }
                    if (Character.isDigit(next)) {
                        int which = Character.getNumericValue(next) - 1;
                        if (which < 0) {
                            throw new IllegalArgumentException("template requests value ^" + (which + 1));
                        }
                        if (which >= values.length) {
                            throw new IllegalArgumentException("template requests value ^" + (which + 1) + "; only " + values.length + " provided");
                        }
                        ssb.replace(i, i + 2, values[which]);
                        i += values[which].length();
                        continue;
                    }
                }
                ++i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return ssb;
    }

    private static final int $$robo$$android_text_TextUtils$getOffsetBefore(CharSequence text, int offset) {
        char c1;
        if (offset == 0) {
            return 0;
        }
        if (offset == 1) {
            return 0;
        }
        char c = text.charAt(offset - 1);
        offset = c >= '\udc00' && c <= '\udfff' ? ((c1 = text.charAt(offset - 2)) >= '\ud800' && c1 <= '\udbff' ? (offset -= 2) : --offset) : --offset;
        if (text instanceof Spanned) {
            ReplacementSpan[] spans = ((Spanned)text).getSpans(offset, offset, ReplacementSpan.class);
            for (int i = 0; i < spans.length; ++i) {
                int start = ((Spanned)text).getSpanStart(spans[i]);
                int end = ((Spanned)text).getSpanEnd(spans[i]);
                if (start >= offset || end <= offset) continue;
                offset = start;
            }
        }
        return offset;
    }

    private static final int $$robo$$android_text_TextUtils$getOffsetAfter(CharSequence text, int offset) {
        char c1;
        int len = text.length();
        if (offset == len) {
            return len;
        }
        if (offset == len - 1) {
            return len;
        }
        char c = text.charAt(offset);
        offset = c >= '\ud800' && c <= '\udbff' ? ((c1 = text.charAt(offset + 1)) >= '\udc00' && c1 <= '\udfff' ? (offset += 2) : ++offset) : ++offset;
        if (text instanceof Spanned) {
            ReplacementSpan[] spans = ((Spanned)text).getSpans(offset, offset, ReplacementSpan.class);
            for (int i = 0; i < spans.length; ++i) {
                int start = ((Spanned)text).getSpanStart(spans[i]);
                int end = ((Spanned)text).getSpanEnd(spans[i]);
                if (start >= offset || end <= offset) continue;
                offset = end;
            }
        }
        return offset;
    }

    private static final void $$robo$$android_text_TextUtils$readSpan(Parcel p, Spannable sp, Object o) {
        sp.setSpan(o, p.readInt(), p.readInt(), p.readInt());
    }

    private static final void $$robo$$android_text_TextUtils$copySpansFrom(Spanned source, int start, int end, Class kind, Spannable dest, int destoff) {
        if (kind == null) {
            kind = Object.class;
        }
        Object[] spans = source.getSpans(start, end, kind);
        for (int i = 0; i < spans.length; ++i) {
            int st = source.getSpanStart(spans[i]);
            int en = source.getSpanEnd(spans[i]);
            int fl = source.getSpanFlags(spans[i]);
            if (st < start) {
                st = start;
            }
            if (en > end) {
                en = end;
            }
            dest.setSpan(spans[i], st - start + destoff, en - start + destoff, fl);
        }
    }

    private static final CharSequence $$robo$$android_text_TextUtils$ellipsize(CharSequence text, TextPaint p, float avail, TruncateAt where) {
        return TextUtils.ellipsize(text, p, avail, where, false, null);
    }

    private static final CharSequence $$robo$$android_text_TextUtils$ellipsize(CharSequence text, TextPaint paint, float avail, TruncateAt where, boolean preserveLength, EllipsizeCallback callback) {
        return TextUtils.ellipsize(text, paint, avail, where, preserveLength, callback, TextDirectionHeuristics.FIRSTSTRONG_LTR, where == TruncateAt.END_SMALL ? ELLIPSIS_TWO_DOTS_STRING : ELLIPSIS_STRING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final CharSequence $$robo$$android_text_TextUtils$ellipsize(CharSequence text, TextPaint paint, float avail, TruncateAt where, boolean preserveLength, EllipsizeCallback callback, TextDirectionHeuristic textDir, String ellipsis) {
        int len = text.length();
        MeasuredText mt = MeasuredText.obtain();
        try {
            float width = TextUtils.setPara(mt, paint, text, 0, text.length(), textDir);
            if (width <= avail) {
                if (callback != null) {
                    callback.ellipsized(0, 0);
                }
                CharSequence charSequence = text;
                return charSequence;
            }
            float ellipsiswid = paint.measureText(ellipsis);
            int left = 0;
            int right = len;
            if (!((avail -= ellipsiswid) < 0.0f)) {
                if (where == TruncateAt.START) {
                    right = len - mt.breakText(len, false, avail);
                } else if (where == TruncateAt.END || where == TruncateAt.END_SMALL) {
                    left = mt.breakText(len, true, avail);
                } else {
                    right = len - mt.breakText(len, false, avail / 2.0f);
                    left = mt.breakText(right, true, avail -= mt.measure(right, len));
                }
            }
            if (callback != null) {
                callback.ellipsized(left, right);
            }
            char[] buf = mt.mChars;
            Spanned sp = text instanceof Spanned ? (Spanned)text : null;
            int remaining = len - (right - left);
            if (preserveLength) {
                if (remaining > 0) {
                    buf[left++] = ellipsis.charAt(0);
                }
                for (int i = left; i < right; ++i) {
                    buf[i] = 65279;
                }
                String s = new String(buf, 0, len);
                if (sp == null) {
                    String string2 = s;
                    return string2;
                }
                SpannableString ss = new SpannableString(s);
                TextUtils.copySpansFrom(sp, 0, len, Object.class, ss, 0);
                SpannableString spannableString = ss;
                return spannableString;
            }
            if (remaining == 0) {
                String s = "";
                return s;
            }
            if (sp == null) {
                StringBuilder sb = new StringBuilder(remaining + ellipsis.length());
                sb.append(buf, 0, left);
                sb.append(ellipsis);
                sb.append(buf, right, len - right);
                String string3 = sb.toString();
                return string3;
            }
            SpannableStringBuilder ssb = new SpannableStringBuilder();
            ssb.append(text, 0, left);
            ssb.append(ellipsis);
            ssb.append(text, right, len);
            SpannableStringBuilder spannableStringBuilder = ssb;
            return spannableStringBuilder;
        }
        finally {
            MeasuredText.recycle(mt);
        }
    }

    private static final CharSequence $$robo$$android_text_TextUtils$commaEllipsize(CharSequence text, TextPaint p, float avail, String oneMore, String more) {
        return TextUtils.commaEllipsize(text, p, avail, oneMore, more, TextDirectionHeuristics.FIRSTSTRONG_LTR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final CharSequence $$robo$$android_text_TextUtils$commaEllipsize(CharSequence text, TextPaint p, float avail, String oneMore, String more, TextDirectionHeuristic textDir) {
        MeasuredText mt = MeasuredText.obtain();
        try {
            int len = text.length();
            float width = TextUtils.setPara(mt, p, text, 0, len, textDir);
            if (width <= avail) {
                CharSequence charSequence = text;
                return charSequence;
            }
            char[] buf = mt.mChars;
            int commaCount = 0;
            for (int i = 0; i < len; ++i) {
                if (buf[i] != ',') continue;
                ++commaCount;
            }
            int remaining = commaCount + 1;
            int ok = 0;
            String okFormat = "";
            int w = 0;
            int count = 0;
            float[] widths = mt.mWidths;
            MeasuredText tempMt = MeasuredText.obtain();
            for (int i = 0; i < len; ++i) {
                w = (int)((float)w + widths[i]);
                if (buf[i] != ',') continue;
                ++count;
                String format = --remaining == 1 ? " " + oneMore : " " + String.format(more, remaining);
                tempMt.setPara(format, 0, format.length(), textDir, null);
                float moreWid = tempMt.addStyleRun(p, tempMt.mLen, null);
                if (!((float)w + moreWid <= avail)) continue;
                ok = i + 1;
                okFormat = format;
            }
            MeasuredText.recycle(tempMt);
            SpannableStringBuilder out = new SpannableStringBuilder(okFormat);
            out.insert(0, text, 0, ok);
            SpannableStringBuilder spannableStringBuilder = out;
            return spannableStringBuilder;
        }
        finally {
            MeasuredText.recycle(mt);
        }
    }

    private static final float $$robo$$android_text_TextUtils$setPara(MeasuredText mt, TextPaint paint, CharSequence text, int start, int end, TextDirectionHeuristic textDir) {
        float width;
        mt.setPara(text, start, end, textDir, null);
        Spanned sp = text instanceof Spanned ? (Spanned)text : null;
        int len = end - start;
        if (sp == null) {
            width = mt.addStyleRun(paint, len, null);
        } else {
            width = 0.0f;
            int spanStart = 0;
            while (spanStart < len) {
                int spanEnd = sp.nextSpanTransition(spanStart, len, MetricAffectingSpan.class);
                MetricAffectingSpan[] spans = sp.getSpans(spanStart, spanEnd, MetricAffectingSpan.class);
                spans = TextUtils.removeEmptySpans(spans, sp, MetricAffectingSpan.class);
                width += mt.addStyleRun(paint, spans, spanEnd - spanStart, null);
                spanStart = spanEnd;
            }
        }
        return width;
    }

    private static final boolean $$robo$$android_text_TextUtils$doesNotNeedBidi(CharSequence s, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (s.charAt(i) < '\u0590') continue;
            return false;
        }
        return true;
    }

    private static final boolean $$robo$$android_text_TextUtils$doesNotNeedBidi(char[] text, int start, int len) {
        int i;
        int e = i + len;
        for (i = start; i < e; ++i) {
            if (text[i] < '\u0590') continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final char[] $$robo$$android_text_TextUtils$obtain(int len) {
        char[] buf;
        Object object = sLock;
        synchronized (object) {
            buf = sTemp;
            sTemp = null;
        }
        if (buf == null || buf.length < len) {
            buf = ArrayUtils.newUnpaddedCharArray(len);
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_text_TextUtils$recycle(char[] temp) {
        if (temp.length > 1000) {
            return;
        }
        Object object = sLock;
        synchronized (object) {
            sTemp = temp;
        }
    }

    private static final String $$robo$$android_text_TextUtils$htmlEncode(String s) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static final CharSequence $$robo$$android_text_TextUtils$concat(CharSequence ... text) {
        if (text.length == 0) {
            return "";
        }
        if (text.length == 1) {
            return text[0];
        }
        boolean spanned = false;
        for (int i = 0; i < text.length; ++i) {
            if (!(text[i] instanceof Spanned)) continue;
            spanned = true;
            break;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length; ++i) {
            sb.append(text[i]);
        }
        if (!spanned) {
            return sb.toString();
        }
        SpannableString ss = new SpannableString(sb);
        int off = 0;
        for (int i = 0; i < text.length; ++i) {
            int len = text[i].length();
            if (text[i] instanceof Spanned) {
                TextUtils.copySpansFrom((Spanned)text[i], 0, len, Object.class, ss, off);
            }
            off += len;
        }
        return new SpannedString(ss);
    }

    private static final boolean $$robo$$android_text_TextUtils$isGraphic(CharSequence str) {
        int cp;
        int len = str.length();
        for (int i = 0; i < len; i += Character.charCount(cp)) {
            cp = Character.codePointAt(str, i);
            int gc = Character.getType(cp);
            if (gc == 15 || gc == 16 || gc == 19 || gc == 0 || gc == 13 || gc == 14 || gc == 12) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    private static final boolean $$robo$$android_text_TextUtils$isGraphic(char c) {
        int gc = Character.getType(c);
        return gc != 15 && gc != 16 && gc != 19 && gc != 0 && gc != 13 && gc != 14 && gc != 12;
    }

    private static final boolean $$robo$$android_text_TextUtils$isDigitsOnly(CharSequence str) {
        int cp;
        int len = str.length();
        for (int i = 0; i < len; i += Character.charCount(cp)) {
            cp = Character.codePointAt(str, i);
            if (Character.isDigit(cp)) continue;
            return false;
        }
        return true;
    }

    private static final boolean $$robo$$android_text_TextUtils$isPrintableAscii(char c) {
        int asciiFirst = 32;
        int asciiLast = 126;
        return ' ' <= c && c <= '~' || c == '\r' || c == '\n';
    }

    private static final boolean $$robo$$android_text_TextUtils$isPrintableAsciiOnly(CharSequence str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (TextUtils.isPrintableAscii(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static final int $$robo$$android_text_TextUtils$getCapsMode(CharSequence cs, int off, int reqModes) {
        int j;
        char c;
        int i;
        if (off < 0) {
            return 0;
        }
        int mode = 0;
        if ((reqModes & 0x1000) != 0) {
            mode |= 0x1000;
        }
        if ((reqModes & 0x6000) == 0) {
            return mode;
        }
        for (i = off; i > 0 && ((c = cs.charAt(i - 1)) == '\"' || c == '\'' || Character.getType(c) == 21); --i) {
        }
        for (j = i; j > 0 && ((c = cs.charAt(j - 1)) == ' ' || c == '\t'); --j) {
        }
        if (j == 0 || cs.charAt(j - 1) == '\n') {
            return mode | 0x2000;
        }
        if ((reqModes & 0x4000) == 0) {
            if (i != j) {
                mode |= 0x2000;
            }
            return mode;
        }
        if (i == j) {
            return mode;
        }
        while (j > 0 && ((c = cs.charAt(j - 1)) == '\"' || c == '\'' || Character.getType(c) == 22)) {
            --j;
        }
        if (j > 0 && ((c = cs.charAt(j - 1)) == '.' || c == '?' || c == '!')) {
            if (c == '.') {
                for (int k = j - 2; k >= 0; --k) {
                    c = cs.charAt(k);
                    if (c == '.') {
                        return mode;
                    }
                    if (!Character.isLetter(c)) break;
                }
            }
            return mode | 0x4000;
        }
        return mode;
    }

    private static final boolean $$robo$$android_text_TextUtils$delimitedStringContains(String delimitedString, char delimiter, String item) {
        if (TextUtils.isEmpty(delimitedString) || TextUtils.isEmpty(item)) {
            return false;
        }
        int pos = -1;
        int length = delimitedString.length();
        while ((pos = delimitedString.indexOf(item, pos + 1)) != -1) {
            if (pos > 0 && delimitedString.charAt(pos - 1) != delimiter) continue;
            int expectedDelimiterPos = pos + item.length();
            if (expectedDelimiterPos == length) {
                return true;
            }
            if (delimitedString.charAt(expectedDelimiterPos) != delimiter) continue;
            return true;
        }
        return false;
    }

    private static final <T> T[] $$robo$$android_text_TextUtils$removeEmptySpans(T[] spans, Spanned spanned, Class<T> klass) {
        Object[] copy = null;
        int count = 0;
        for (int i = 0; i < spans.length; ++i) {
            int end;
            T span = spans[i];
            int start = spanned.getSpanStart(span);
            if (start == (end = spanned.getSpanEnd(span))) {
                if (copy != null) continue;
                copy = (Object[])Array.newInstance(klass, spans.length - 1);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", spans, (int)0, (Object)copy, (int)0, (int)i);
                count = i;
                continue;
            }
            if (copy == null) continue;
            copy[count] = span;
            ++count;
        }
        if (copy != null) {
            Object[] result = (Object[])Array.newInstance(klass, count);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", copy, (int)0, (Object)result, (int)0, (int)count);
            return result;
        }
        return spans;
    }

    private static final long $$robo$$android_text_TextUtils$packRangeInLong(int start, int end) {
        return (long)start << 32 | (long)end;
    }

    private static final int $$robo$$android_text_TextUtils$unpackRangeStartFromLong(long range) {
        return (int)(range >>> 32);
    }

    private static final int $$robo$$android_text_TextUtils$unpackRangeEndFromLong(long range) {
        return (int)(range & 0xFFFFFFFFL);
    }

    private static final int $$robo$$android_text_TextUtils$getLayoutDirectionFromLocale(Locale locale) {
        return locale != null && !locale.equals(Locale.ROOT) && ULocale.forLocale(locale).isRightToLeft() || SystemProperties.getBoolean("debug.force_rtl", false) ? 1 : 0;
    }

    private static final CharSequence $$robo$$android_text_TextUtils$formatSelectedCount(int count) {
        return Resources.getSystem().getQuantityString(18087971, count, count);
    }

    static void __staticInitializer__() {
        ELLIPSIS_NORMAL = new char[]{'\u2026'};
        ELLIPSIS_STRING = new String(ELLIPSIS_NORMAL);
        ELLIPSIS_TWO_DOTS = new char[]{'\u2025'};
        ELLIPSIS_TWO_DOTS_STRING = new String(ELLIPSIS_TWO_DOTS);
        CHAR_SEQUENCE_CREATOR = new Parcelable.Creator<CharSequence>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_text_TextUtils_1$__constructor__() {
            }

            private final CharSequence $$robo$$android_text_TextUtils_1$createFromParcel(Parcel p) {
                int kind = p.readInt();
                String string2 = p.readString();
                if (string2 == null) {
                    return null;
                }
                if (kind == 1) {
                    return string2;
                }
                SpannableString sp = new SpannableString(string2);
                block26: while ((kind = p.readInt()) != 0) {
                    switch (kind) {
                        case 1: {
                            TextUtils.readSpan(p, sp, new AlignmentSpan.Standard(p));
                            continue block26;
                        }
                        case 2: {
                            TextUtils.readSpan(p, sp, new ForegroundColorSpan(p));
                            continue block26;
                        }
                        case 3: {
                            TextUtils.readSpan(p, sp, new RelativeSizeSpan(p));
                            continue block26;
                        }
                        case 4: {
                            TextUtils.readSpan(p, sp, new ScaleXSpan(p));
                            continue block26;
                        }
                        case 5: {
                            TextUtils.readSpan(p, sp, new StrikethroughSpan(p));
                            continue block26;
                        }
                        case 6: {
                            TextUtils.readSpan(p, sp, new UnderlineSpan(p));
                            continue block26;
                        }
                        case 7: {
                            TextUtils.readSpan(p, sp, new StyleSpan(p));
                            continue block26;
                        }
                        case 8: {
                            TextUtils.readSpan(p, sp, new BulletSpan(p));
                            continue block26;
                        }
                        case 9: {
                            TextUtils.readSpan(p, sp, new QuoteSpan(p));
                            continue block26;
                        }
                        case 10: {
                            TextUtils.readSpan(p, sp, new LeadingMarginSpan.Standard(p));
                            continue block26;
                        }
                        case 11: {
                            TextUtils.readSpan(p, sp, new URLSpan(p));
                            continue block26;
                        }
                        case 12: {
                            TextUtils.readSpan(p, sp, new BackgroundColorSpan(p));
                            continue block26;
                        }
                        case 13: {
                            TextUtils.readSpan(p, sp, new TypefaceSpan(p));
                            continue block26;
                        }
                        case 14: {
                            TextUtils.readSpan(p, sp, new SuperscriptSpan(p));
                            continue block26;
                        }
                        case 15: {
                            TextUtils.readSpan(p, sp, new SubscriptSpan(p));
                            continue block26;
                        }
                        case 16: {
                            TextUtils.readSpan(p, sp, new AbsoluteSizeSpan(p));
                            continue block26;
                        }
                        case 17: {
                            TextUtils.readSpan(p, sp, new TextAppearanceSpan(p));
                            continue block26;
                        }
                        case 18: {
                            TextUtils.readSpan(p, sp, new Annotation(p));
                            continue block26;
                        }
                        case 19: {
                            TextUtils.readSpan(p, sp, new SuggestionSpan(p));
                            continue block26;
                        }
                        case 20: {
                            TextUtils.readSpan(p, sp, new SpellCheckSpan(p));
                            continue block26;
                        }
                        case 21: {
                            TextUtils.readSpan(p, sp, new SuggestionRangeSpan(p));
                            continue block26;
                        }
                        case 22: {
                            TextUtils.readSpan(p, sp, new EasyEditSpan(p));
                            continue block26;
                        }
                        case 23: {
                            TextUtils.readSpan(p, sp, new LocaleSpan(p));
                            continue block26;
                        }
                        case 24: {
                            TextUtils.readSpan(p, sp, new TtsSpan(p));
                            continue block26;
                        }
                    }
                    throw new RuntimeException("bogus span encoding " + kind);
                }
                return sp;
            }

            private final CharSequence[] $$robo$$android_text_TextUtils_1$newArray(int size) {
                return new CharSequence[size];
            }

            private void __constructor__() {
                this.$$robo$$android_text_TextUtils_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_TextUtils_1$__constructor__(), 0, this);
            }

            @Override
            public CharSequence createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_text_TextUtils_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public CharSequence[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_text_TextUtils_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sLock = new Object();
        sTemp = null;
        EMPTY_STRING_ARRAY = new String[0];
    }

    private void __constructor__() {
        this.$$robo$$android_text_TextUtils$__constructor__();
    }

    private TextUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_TextUtils$__constructor__(), 0, this);
    }

    public static void getChars(CharSequence charSequence, int n, int n2, char[] cArray, int n3) {
        InvokeDynamicSupport.bootstrapStatic("getChars", $$robo$$android_text_TextUtils$getChars(java.lang.CharSequence int int char[] int ), 0, (CharSequence)charSequence, (int)n, (int)n2, (char[])cArray, (int)n3);
    }

    public static int indexOf(CharSequence charSequence, char c) {
        return (int)InvokeDynamicSupport.bootstrapStatic("indexOf", $$robo$$android_text_TextUtils$indexOf(java.lang.CharSequence char ), 0, (CharSequence)charSequence, (char)c);
    }

    public static int indexOf(CharSequence charSequence, char c, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("indexOf", $$robo$$android_text_TextUtils$indexOf(java.lang.CharSequence char int ), 0, (CharSequence)charSequence, (char)c, (int)n);
    }

    public static int indexOf(CharSequence charSequence, char c, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("indexOf", $$robo$$android_text_TextUtils$indexOf(java.lang.CharSequence char int int ), 0, (CharSequence)charSequence, (char)c, (int)n, (int)n2);
    }

    public static int lastIndexOf(CharSequence charSequence, char c) {
        return (int)InvokeDynamicSupport.bootstrapStatic("lastIndexOf", $$robo$$android_text_TextUtils$lastIndexOf(java.lang.CharSequence char ), 0, (CharSequence)charSequence, (char)c);
    }

    public static int lastIndexOf(CharSequence charSequence, char c, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("lastIndexOf", $$robo$$android_text_TextUtils$lastIndexOf(java.lang.CharSequence char int ), 0, (CharSequence)charSequence, (char)c, (int)n);
    }

    public static int lastIndexOf(CharSequence charSequence, char c, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("lastIndexOf", $$robo$$android_text_TextUtils$lastIndexOf(java.lang.CharSequence char int int ), 0, (CharSequence)charSequence, (char)c, (int)n, (int)n2);
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("indexOf", $$robo$$android_text_TextUtils$indexOf(java.lang.CharSequence java.lang.CharSequence ), 0, (CharSequence)charSequence, (CharSequence)charSequence2);
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("indexOf", $$robo$$android_text_TextUtils$indexOf(java.lang.CharSequence java.lang.CharSequence int ), 0, (CharSequence)charSequence, (CharSequence)charSequence2, (int)n);
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("indexOf", $$robo$$android_text_TextUtils$indexOf(java.lang.CharSequence java.lang.CharSequence int int ), 0, (CharSequence)charSequence, (CharSequence)charSequence2, (int)n, (int)n2);
    }

    public static boolean regionMatches(CharSequence charSequence, int n, CharSequence charSequence2, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("regionMatches", $$robo$$android_text_TextUtils$regionMatches(java.lang.CharSequence int java.lang.CharSequence int int ), 0, (CharSequence)charSequence, (int)n, (CharSequence)charSequence2, (int)n2, (int)n3);
    }

    public static String substring(CharSequence charSequence, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("substring", $$robo$$android_text_TextUtils$substring(java.lang.CharSequence int int ), 0, (CharSequence)charSequence, (int)n, (int)n2);
    }

    public static String join(CharSequence charSequence, Object[] objectArray) {
        return InvokeDynamicSupport.bootstrapStatic("join", $$robo$$android_text_TextUtils$join(java.lang.CharSequence java.lang.Object[] ), 0, (CharSequence)charSequence, (Object[])objectArray);
    }

    public static String join(CharSequence charSequence, Iterable iterable) {
        return InvokeDynamicSupport.bootstrapStatic("join", $$robo$$android_text_TextUtils$join(java.lang.CharSequence java.lang.Iterable ), 0, (CharSequence)charSequence, (Iterable)iterable);
    }

    public static String[] split(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("split", $$robo$$android_text_TextUtils$split(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static String[] split(String string2, Pattern pattern) {
        return InvokeDynamicSupport.bootstrapStatic("split", $$robo$$android_text_TextUtils$split(java.lang.String java.util.regex.Pattern ), 0, (String)string2, (Pattern)pattern);
    }

    public static CharSequence stringOrSpannedString(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("stringOrSpannedString", $$robo$$android_text_TextUtils$stringOrSpannedString(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEmpty", $$robo$$android_text_TextUtils$isEmpty(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    public static String nullIfEmpty(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("nullIfEmpty", $$robo$$android_text_TextUtils$nullIfEmpty(java.lang.String ), 0, (String)string2);
    }

    public static int getTrimmedLength(CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getTrimmedLength", $$robo$$android_text_TextUtils$getTrimmedLength(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    public static boolean equals(CharSequence charSequence, CharSequence charSequence2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("equals", $$robo$$android_text_TextUtils$equals(java.lang.CharSequence java.lang.CharSequence ), 0, (CharSequence)charSequence, (CharSequence)charSequence2);
    }

    @Deprecated
    public static CharSequence getReverse(CharSequence charSequence, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getReverse", $$robo$$android_text_TextUtils$getReverse(java.lang.CharSequence int int ), 0, (CharSequence)charSequence, (int)n, (int)n2);
    }

    public static void writeToParcel(CharSequence charSequence, Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrapStatic("writeToParcel", $$robo$$android_text_TextUtils$writeToParcel(java.lang.CharSequence android.os.Parcel int ), 0, (CharSequence)charSequence, (Parcel)parcel, (int)n);
    }

    private static void writeWhere(Parcel parcel, Spanned spanned, Object object) {
        InvokeDynamicSupport.bootstrapStatic("writeWhere", $$robo$$android_text_TextUtils$writeWhere(android.os.Parcel android.text.Spanned java.lang.Object ), 0, (Parcel)parcel, (Spanned)spanned, (Object)object);
    }

    public static void dumpSpans(CharSequence charSequence, Printer printer, String string2) {
        InvokeDynamicSupport.bootstrapStatic("dumpSpans", $$robo$$android_text_TextUtils$dumpSpans(java.lang.CharSequence android.util.Printer java.lang.String ), 0, (CharSequence)charSequence, (Printer)printer, (String)string2);
    }

    public static CharSequence replace(CharSequence charSequence, String[] stringArray, CharSequence[] charSequenceArray) {
        return InvokeDynamicSupport.bootstrapStatic("replace", $$robo$$android_text_TextUtils$replace(java.lang.CharSequence java.lang.String[] java.lang.CharSequence[] ), 0, (CharSequence)charSequence, (String[])stringArray, (CharSequence[])charSequenceArray);
    }

    public static CharSequence expandTemplate(CharSequence charSequence, CharSequence ... charSequenceArray) {
        return InvokeDynamicSupport.bootstrapStatic("expandTemplate", $$robo$$android_text_TextUtils$expandTemplate(java.lang.CharSequence java.lang.CharSequence[] ), 0, (CharSequence)charSequence, (CharSequence[])charSequenceArray);
    }

    public static int getOffsetBefore(CharSequence charSequence, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getOffsetBefore", $$robo$$android_text_TextUtils$getOffsetBefore(java.lang.CharSequence int ), 0, (CharSequence)charSequence, (int)n);
    }

    public static int getOffsetAfter(CharSequence charSequence, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getOffsetAfter", $$robo$$android_text_TextUtils$getOffsetAfter(java.lang.CharSequence int ), 0, (CharSequence)charSequence, (int)n);
    }

    private static void readSpan(Parcel parcel, Spannable spannable, Object object) {
        InvokeDynamicSupport.bootstrapStatic("readSpan", $$robo$$android_text_TextUtils$readSpan(android.os.Parcel android.text.Spannable java.lang.Object ), 0, (Parcel)parcel, (Spannable)spannable, (Object)object);
    }

    public static void copySpansFrom(Spanned spanned, int n, int n2, Class clazz, Spannable spannable, int n3) {
        InvokeDynamicSupport.bootstrapStatic("copySpansFrom", $$robo$$android_text_TextUtils$copySpansFrom(android.text.Spanned int int java.lang.Class android.text.Spannable int ), 0, (Spanned)spanned, (int)n, (int)n2, (Class)clazz, (Spannable)spannable, (int)n3);
    }

    public static CharSequence ellipsize(CharSequence charSequence, TextPaint textPaint, float f, TruncateAt truncateAt) {
        return InvokeDynamicSupport.bootstrapStatic("ellipsize", $$robo$$android_text_TextUtils$ellipsize(java.lang.CharSequence android.text.TextPaint float android.text.TextUtils$TruncateAt ), 0, (CharSequence)charSequence, (TextPaint)textPaint, (float)f, (TruncateAt)truncateAt);
    }

    public static CharSequence ellipsize(CharSequence charSequence, TextPaint textPaint, float f, TruncateAt truncateAt, boolean bl, EllipsizeCallback ellipsizeCallback) {
        return InvokeDynamicSupport.bootstrapStatic("ellipsize", $$robo$$android_text_TextUtils$ellipsize(java.lang.CharSequence android.text.TextPaint float android.text.TextUtils$TruncateAt boolean android.text.TextUtils$EllipsizeCallback ), 0, (CharSequence)charSequence, (TextPaint)textPaint, (float)f, (TruncateAt)truncateAt, (boolean)bl, (EllipsizeCallback)ellipsizeCallback);
    }

    public static CharSequence ellipsize(CharSequence charSequence, TextPaint textPaint, float f, TruncateAt truncateAt, boolean bl, EllipsizeCallback ellipsizeCallback, TextDirectionHeuristic textDirectionHeuristic, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("ellipsize", $$robo$$android_text_TextUtils$ellipsize(java.lang.CharSequence android.text.TextPaint float android.text.TextUtils$TruncateAt boolean android.text.TextUtils$EllipsizeCallback android.text.TextDirectionHeuristic java.lang.String ), 0, (CharSequence)charSequence, (TextPaint)textPaint, (float)f, (TruncateAt)truncateAt, (boolean)bl, (EllipsizeCallback)ellipsizeCallback, (TextDirectionHeuristic)textDirectionHeuristic, (String)string2);
    }

    public static CharSequence commaEllipsize(CharSequence charSequence, TextPaint textPaint, float f, String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("commaEllipsize", $$robo$$android_text_TextUtils$commaEllipsize(java.lang.CharSequence android.text.TextPaint float java.lang.String java.lang.String ), 0, (CharSequence)charSequence, (TextPaint)textPaint, (float)f, (String)string2, (String)string3);
    }

    public static CharSequence commaEllipsize(CharSequence charSequence, TextPaint textPaint, float f, String string2, String string3, TextDirectionHeuristic textDirectionHeuristic) {
        return InvokeDynamicSupport.bootstrapStatic("commaEllipsize", $$robo$$android_text_TextUtils$commaEllipsize(java.lang.CharSequence android.text.TextPaint float java.lang.String java.lang.String android.text.TextDirectionHeuristic ), 0, (CharSequence)charSequence, (TextPaint)textPaint, (float)f, (String)string2, (String)string3, (TextDirectionHeuristic)textDirectionHeuristic);
    }

    private static float setPara(MeasuredText measuredText, TextPaint textPaint, CharSequence charSequence, int n, int n2, TextDirectionHeuristic textDirectionHeuristic) {
        return (float)InvokeDynamicSupport.bootstrapStatic("setPara", $$robo$$android_text_TextUtils$setPara(android.text.MeasuredText android.text.TextPaint java.lang.CharSequence int int android.text.TextDirectionHeuristic ), 0, (MeasuredText)measuredText, (TextPaint)textPaint, (CharSequence)charSequence, (int)n, (int)n2, (TextDirectionHeuristic)textDirectionHeuristic);
    }

    static boolean doesNotNeedBidi(CharSequence charSequence, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("doesNotNeedBidi", $$robo$$android_text_TextUtils$doesNotNeedBidi(java.lang.CharSequence int int ), 0, (CharSequence)charSequence, (int)n, (int)n2);
    }

    static boolean doesNotNeedBidi(char[] cArray, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("doesNotNeedBidi", $$robo$$android_text_TextUtils$doesNotNeedBidi(char[] int int ), 0, (char[])cArray, (int)n, (int)n2);
    }

    static char[] obtain(int n) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_text_TextUtils$obtain(int ), 0, (int)n);
    }

    static void recycle(char[] cArray) {
        InvokeDynamicSupport.bootstrapStatic("recycle", $$robo$$android_text_TextUtils$recycle(char[] ), 0, (char[])cArray);
    }

    public static String htmlEncode(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("htmlEncode", $$robo$$android_text_TextUtils$htmlEncode(java.lang.String ), 0, (String)string2);
    }

    public static CharSequence concat(CharSequence ... charSequenceArray) {
        return InvokeDynamicSupport.bootstrapStatic("concat", $$robo$$android_text_TextUtils$concat(java.lang.CharSequence[] ), 0, (CharSequence[])charSequenceArray);
    }

    public static boolean isGraphic(CharSequence charSequence) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isGraphic", $$robo$$android_text_TextUtils$isGraphic(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    @Deprecated
    public static boolean isGraphic(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isGraphic", $$robo$$android_text_TextUtils$isGraphic(char ), 0, (char)c);
    }

    public static boolean isDigitsOnly(CharSequence charSequence) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDigitsOnly", $$robo$$android_text_TextUtils$isDigitsOnly(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    public static boolean isPrintableAscii(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPrintableAscii", $$robo$$android_text_TextUtils$isPrintableAscii(char ), 0, (char)c);
    }

    public static boolean isPrintableAsciiOnly(CharSequence charSequence) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPrintableAsciiOnly", $$robo$$android_text_TextUtils$isPrintableAsciiOnly(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    public static int getCapsMode(CharSequence charSequence, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCapsMode", $$robo$$android_text_TextUtils$getCapsMode(java.lang.CharSequence int int ), 0, (CharSequence)charSequence, (int)n, (int)n2);
    }

    public static boolean delimitedStringContains(String string2, char c, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("delimitedStringContains", $$robo$$android_text_TextUtils$delimitedStringContains(java.lang.String char java.lang.String ), 0, (String)string2, (char)c, (String)string3);
    }

    public static <T> T[] removeEmptySpans(T[] TArray, Spanned spanned, Class<T> clazz) {
        return InvokeDynamicSupport.bootstrapStatic("removeEmptySpans", $$robo$$android_text_TextUtils$removeEmptySpans(T[] android.text.Spanned java.lang.Class<T> ), 0, (Object[])TArray, (Spanned)spanned, clazz);
    }

    public static long packRangeInLong(int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("packRangeInLong", $$robo$$android_text_TextUtils$packRangeInLong(int int ), 0, (int)n, (int)n2);
    }

    public static int unpackRangeStartFromLong(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("unpackRangeStartFromLong", $$robo$$android_text_TextUtils$unpackRangeStartFromLong(long ), 0, (long)l);
    }

    public static int unpackRangeEndFromLong(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("unpackRangeEndFromLong", $$robo$$android_text_TextUtils$unpackRangeEndFromLong(long ), 0, (long)l);
    }

    public static int getLayoutDirectionFromLocale(Locale locale) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getLayoutDirectionFromLocale", $$robo$$android_text_TextUtils$getLayoutDirectionFromLocale(java.util.Locale ), 0, (Locale)locale);
    }

    public static CharSequence formatSelectedCount(int n) {
        return InvokeDynamicSupport.bootstrapStatic("formatSelectedCount", $$robo$$android_text_TextUtils$formatSelectedCount(int ), 0, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(TextUtils.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface EllipsizeCallback
    extends InstrumentedInterface {
        public void ellipsized(int var1, int var2);
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class TruncateAt
    extends Enum<TruncateAt> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ TruncateAt START;
        public static /* enum */ TruncateAt MIDDLE;
        public static /* enum */ TruncateAt END;
        public static /* enum */ TruncateAt MARQUEE;
        public static /* enum */ TruncateAt END_SMALL;
        private static /* synthetic */ TruncateAt[] $VALUES;

        private static final TruncateAt[] $$robo$$android_text_TextUtils_TruncateAt$values() {
            return (TruncateAt[])$VALUES.clone();
        }

        private static final TruncateAt $$robo$$android_text_TextUtils_TruncateAt$valueOf(String name) {
            return Enum.valueOf(TruncateAt.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_text_TextUtils_TruncateAt$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            START = new TruncateAt();
            MIDDLE = new TruncateAt();
            END = new TruncateAt();
            MARQUEE = new TruncateAt();
            END_SMALL = new TruncateAt();
            $VALUES = new TruncateAt[]{START, MIDDLE, END, MARQUEE, END_SMALL};
        }

        public static TruncateAt[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_text_TextUtils_TruncateAt$values(), 0);
        }

        public static TruncateAt valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_text_TextUtils_TruncateAt$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_text_TextUtils_TruncateAt$__constructor__(string2, n);
        }

        private TruncateAt() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_TextUtils_TruncateAt$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(TruncateAt.class);
        }

        public /* synthetic */ TruncateAt() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TruncateAt)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Reverser
    implements CharSequence,
    GetChars,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private CharSequence mSource;
        private int mStart;
        private int mEnd;

        private void $$robo$$android_text_TextUtils_Reverser$__constructor__(CharSequence source, int start, int end) {
            this.mSource = source;
            this.mStart = start;
            this.mEnd = end;
        }

        private final int $$robo$$android_text_TextUtils_Reverser$length() {
            return this.mEnd - this.mStart;
        }

        private final CharSequence $$robo$$android_text_TextUtils_Reverser$subSequence(int start, int end) {
            char[] buf = new char[end - start];
            this.getChars(start, end, buf, 0);
            return new String(buf);
        }

        private final String $$robo$$android_text_TextUtils_Reverser$toString() {
            return this.subSequence(0, this.length()).toString();
        }

        private final char $$robo$$android_text_TextUtils_Reverser$charAt(int off) {
            return AndroidCharacter.getMirror(this.mSource.charAt(this.mEnd - 1 - off));
        }

        private final void $$robo$$android_text_TextUtils_Reverser$getChars(int start, int end, char[] dest, int destoff) {
            TextUtils.getChars(this.mSource, start + this.mStart, end + this.mStart, dest, destoff);
            AndroidCharacter.mirror(dest, 0, end - start);
            int len = end - start;
            int n = (end - start) / 2;
            for (int i = 0; i < n; ++i) {
                char tmp = dest[destoff + i];
                dest[destoff + i] = dest[destoff + len - i - 1];
                dest[destoff + len - i - 1] = tmp;
            }
        }

        private void __constructor__(CharSequence charSequence, int n, int n2) {
            this.$$robo$$android_text_TextUtils_Reverser$__constructor__(charSequence, n, n2);
        }

        public Reverser(CharSequence charSequence, int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_TextUtils_Reverser$__constructor__(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
        }

        @Override
        public int length() {
            return (int)InvokeDynamicSupport.bootstrap("length", $$robo$$android_text_TextUtils_Reverser$length(), 0, this);
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("subSequence", $$robo$$android_text_TextUtils_Reverser$subSequence(int int ), 0, this, n, n2);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_text_TextUtils_Reverser$toString(), 0, this);
        }

        @Override
        public char charAt(int n) {
            return (char)InvokeDynamicSupport.bootstrap("charAt", $$robo$$android_text_TextUtils_Reverser$charAt(int ), 0, this, n);
        }

        @Override
        public void getChars(int n, int n2, char[] cArray, int n3) {
            InvokeDynamicSupport.bootstrap("getChars", $$robo$$android_text_TextUtils_Reverser$getChars(int int char[] int ), 0, this, n, n2, cArray, n3);
        }

        public /* synthetic */ Reverser() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Reverser)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SimpleStringSplitter
    implements StringSplitter,
    Iterator<String> {
        public transient /* synthetic */ Object __robo_data__;
        private String mString;
        private char mDelimiter;
        private int mPosition;
        private int mLength;

        private void $$robo$$android_text_TextUtils_SimpleStringSplitter$__constructor__(char delimiter) {
            this.mDelimiter = delimiter;
        }

        private final void $$robo$$android_text_TextUtils_SimpleStringSplitter$setString(String string2) {
            this.mString = string2;
            this.mPosition = 0;
            this.mLength = this.mString.length();
        }

        private final Iterator<String> $$robo$$android_text_TextUtils_SimpleStringSplitter$iterator() {
            return this;
        }

        private final boolean $$robo$$android_text_TextUtils_SimpleStringSplitter$hasNext() {
            return this.mPosition < this.mLength;
        }

        private final String $$robo$$android_text_TextUtils_SimpleStringSplitter$next() {
            int end = this.mString.indexOf(this.mDelimiter, this.mPosition);
            if (end == -1) {
                end = this.mLength;
            }
            String nextString = this.mString.substring(this.mPosition, end);
            this.mPosition = end + 1;
            return nextString;
        }

        private final void $$robo$$android_text_TextUtils_SimpleStringSplitter$remove() {
            throw new UnsupportedOperationException();
        }

        private void __constructor__(char c) {
            this.$$robo$$android_text_TextUtils_SimpleStringSplitter$__constructor__(c);
        }

        public SimpleStringSplitter(char c) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_TextUtils_SimpleStringSplitter$__constructor__(char ), 0, this, c);
        }

        @Override
        public void setString(String string2) {
            InvokeDynamicSupport.bootstrap("setString", $$robo$$android_text_TextUtils_SimpleStringSplitter$setString(java.lang.String ), 0, this, string2);
        }

        @Override
        public Iterator<String> iterator() {
            return InvokeDynamicSupport.bootstrap("iterator", $$robo$$android_text_TextUtils_SimpleStringSplitter$iterator(), 0, this);
        }

        @Override
        public boolean hasNext() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasNext", $$robo$$android_text_TextUtils_SimpleStringSplitter$hasNext(), 0, this);
        }

        @Override
        public String next() {
            return InvokeDynamicSupport.bootstrap("next", $$robo$$android_text_TextUtils_SimpleStringSplitter$next(), 0, this);
        }

        @Override
        public void remove() {
            InvokeDynamicSupport.bootstrap("remove", $$robo$$android_text_TextUtils_SimpleStringSplitter$remove(), 0, this);
        }

        public /* synthetic */ SimpleStringSplitter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimpleStringSplitter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface StringSplitter
    extends Iterable<String> {
        public void setString(String var1);
    }
}

