/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.content.Context;
import android.content.res.Resources;
import android.net.NetworkUtils;
import android.text.BidiFormatter;
import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class Formatter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int FLAG_SHORTER = 1;
    public static int FLAG_CALCULATE_ROUNDED = 2;
    private static int SECONDS_PER_MINUTE = 60;
    private static int SECONDS_PER_HOUR = 3600;
    private static int SECONDS_PER_DAY = 86400;
    private static int MILLIS_PER_MINUTE = 60000;

    private void $$robo$$android_text_format_Formatter$__constructor__() {
    }

    private static final String $$robo$$android_text_format_Formatter$bidiWrap(Context context, String source) {
        Locale locale = context.getResources().getConfiguration().locale;
        if (TextUtils.getLayoutDirectionFromLocale(locale) == 1) {
            return BidiFormatter.getInstance(true).unicodeWrap(source);
        }
        return source;
    }

    private static final String $$robo$$android_text_format_Formatter$formatFileSize(Context context, long sizeBytes) {
        if (context == null) {
            return "";
        }
        BytesResult res = Formatter.formatBytes(context.getResources(), sizeBytes, 0);
        return Formatter.bidiWrap(context, context.getString(17039502, res.value, res.units));
    }

    private static final String $$robo$$android_text_format_Formatter$formatShortFileSize(Context context, long sizeBytes) {
        if (context == null) {
            return "";
        }
        BytesResult res = Formatter.formatBytes(context.getResources(), sizeBytes, 1);
        return Formatter.bidiWrap(context, context.getString(17039502, res.value, res.units));
    }

    private static final BytesResult $$robo$$android_text_format_Formatter$formatBytes(Resources res, long sizeBytes, int flags) {
        String roundFormat;
        int roundFactor;
        boolean isNegative = sizeBytes < 0L;
        float result = isNegative ? (float)(-sizeBytes) : (float)sizeBytes;
        int suffix = 17039496;
        long mult = 1L;
        if (result > 900.0f) {
            suffix = 17039497;
            mult = 1024L;
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = 17039498;
            mult = 0x100000L;
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = 17039499;
            mult = 0x40000000L;
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = 17039500;
            mult = 0x10000000000L;
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = 17039501;
            mult = 0x4000000000000L;
            result /= 1024.0f;
        }
        if (mult == 1L || result >= 100.0f) {
            roundFactor = 1;
            roundFormat = "%.0f";
        } else if (result < 1.0f) {
            roundFactor = 100;
            roundFormat = "%.2f";
        } else if (result < 10.0f) {
            if ((flags & 1) != 0) {
                roundFactor = 10;
                roundFormat = "%.1f";
            } else {
                roundFactor = 100;
                roundFormat = "%.2f";
            }
        } else if ((flags & 1) != 0) {
            roundFactor = 1;
            roundFormat = "%.0f";
        } else {
            roundFactor = 100;
            roundFormat = "%.2f";
        }
        if (isNegative) {
            result = -result;
        }
        String roundedString = String.format(roundFormat, Float.valueOf(result));
        long roundedBytes = (flags & 2) == 0 ? 0L : (long)Math.round(result * (float)roundFactor) * mult / (long)roundFactor;
        String units = res.getString(suffix);
        return new BytesResult(roundedString, units, roundedBytes);
    }

    @Deprecated
    private static final String $$robo$$android_text_format_Formatter$formatIpAddress(int ipv4Address) {
        return NetworkUtils.intToInetAddress(ipv4Address).getHostAddress();
    }

    private static final String $$robo$$android_text_format_Formatter$formatShortElapsedTime(Context context, long millis) {
        long secondsLong = millis / 1000L;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        if (secondsLong >= 86400L) {
            days = (int)(secondsLong / 86400L);
            secondsLong -= (long)(days * 86400);
        }
        if (secondsLong >= 3600L) {
            hours = (int)(secondsLong / 3600L);
            secondsLong -= (long)(hours * 3600);
        }
        if (secondsLong >= 60L) {
            minutes = (int)(secondsLong / 60L);
            secondsLong -= (long)(minutes * 60);
        }
        int seconds = (int)secondsLong;
        if (days >= 2) {
            return context.getString(17039503, days += (hours + 12) / 24);
        }
        if (days > 0) {
            if (hours == 1) {
                return context.getString(17039505, days, hours);
            }
            return context.getString(17039504, days, hours);
        }
        if (hours >= 2) {
            return context.getString(17039506, hours += (minutes + 30) / 60);
        }
        if (hours > 0) {
            if (minutes == 1) {
                return context.getString(17039508, hours, minutes);
            }
            return context.getString(17039507, hours, minutes);
        }
        if (minutes >= 2) {
            return context.getString(17039509, minutes += (seconds + 30) / 60);
        }
        if (minutes > 0) {
            if (seconds == 1) {
                return context.getString(17039512, minutes, seconds);
            }
            return context.getString(17039511, minutes, seconds);
        }
        if (seconds == 1) {
            return context.getString(17039514, seconds);
        }
        return context.getString(17039513, seconds);
    }

    private static final String $$robo$$android_text_format_Formatter$formatShortElapsedTimeRoundingUpToMinutes(Context context, long millis) {
        long minutesRoundedUp = (millis + 60000L - 1L) / 60000L;
        if (minutesRoundedUp == 0L) {
            return context.getString(17039509, 0);
        }
        if (minutesRoundedUp == 1L) {
            return context.getString(17039510, 1);
        }
        return Formatter.formatShortElapsedTime(context, minutesRoundedUp * 60000L);
    }

    private void __constructor__() {
        this.$$robo$$android_text_format_Formatter$__constructor__();
    }

    public Formatter() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_format_Formatter$__constructor__(), 0, this);
    }

    private static String bidiWrap(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("bidiWrap", $$robo$$android_text_format_Formatter$bidiWrap(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    public static String formatFileSize(Context context, long l) {
        return InvokeDynamicSupport.bootstrapStatic("formatFileSize", $$robo$$android_text_format_Formatter$formatFileSize(android.content.Context long ), 0, (Context)context, (long)l);
    }

    public static String formatShortFileSize(Context context, long l) {
        return InvokeDynamicSupport.bootstrapStatic("formatShortFileSize", $$robo$$android_text_format_Formatter$formatShortFileSize(android.content.Context long ), 0, (Context)context, (long)l);
    }

    public static BytesResult formatBytes(Resources resources, long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("formatBytes", $$robo$$android_text_format_Formatter$formatBytes(android.content.res.Resources long int ), 0, (Resources)resources, (long)l, (int)n);
    }

    @Deprecated
    public static String formatIpAddress(int n) {
        return InvokeDynamicSupport.bootstrapStatic("formatIpAddress", $$robo$$android_text_format_Formatter$formatIpAddress(int ), 0, (int)n);
    }

    public static String formatShortElapsedTime(Context context, long l) {
        return InvokeDynamicSupport.bootstrapStatic("formatShortElapsedTime", $$robo$$android_text_format_Formatter$formatShortElapsedTime(android.content.Context long ), 0, (Context)context, (long)l);
    }

    public static String formatShortElapsedTimeRoundingUpToMinutes(Context context, long l) {
        return InvokeDynamicSupport.bootstrapStatic("formatShortElapsedTimeRoundingUpToMinutes", $$robo$$android_text_format_Formatter$formatShortElapsedTimeRoundingUpToMinutes(android.content.Context long ), 0, (Context)context, (long)l);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Formatter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class BytesResult
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String value;
        public String units;
        public long roundedBytes;

        private void $$robo$$android_text_format_Formatter_BytesResult$__constructor__(String value, String units, long roundedBytes) {
            this.value = value;
            this.units = units;
            this.roundedBytes = roundedBytes;
        }

        private void __constructor__(String string2, String string3, long l) {
            this.$$robo$$android_text_format_Formatter_BytesResult$__constructor__(string2, string3, l);
        }

        public BytesResult(String string2, String string3, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_format_Formatter_BytesResult$__constructor__(java.lang.String java.lang.String long ), 0, this, string2, string3, l);
        }

        public /* synthetic */ BytesResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BytesResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

