/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.method.NumberKeyListener;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DigitsKeyListener
extends NumberKeyListener
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private char[] mAccepted;
    private boolean mSign;
    private boolean mDecimal;
    private static int SIGN = 1;
    private static int DECIMAL = 2;
    private static char[][] CHARACTERS;
    private static DigitsKeyListener[] sInstance;

    private final char[] $$robo$$android_text_method_DigitsKeyListener$getAcceptedChars() {
        return this.mAccepted;
    }

    private static final boolean $$robo$$android_text_method_DigitsKeyListener$isSignChar(char c) {
        return c == '-' || c == '+';
    }

    private static final boolean $$robo$$android_text_method_DigitsKeyListener$isDecimalPointChar(char c) {
        return c == '.';
    }

    private void $$robo$$android_text_method_DigitsKeyListener$__constructor__() {
    }

    private void $$robo$$android_text_method_DigitsKeyListener$__constructor__(boolean sign, boolean decimal) {
        this.mSign = sign;
        this.mDecimal = decimal;
        int kind = (sign ? 1 : 0) | (decimal ? 2 : 0);
        this.mAccepted = CHARACTERS[kind];
    }

    private static final DigitsKeyListener $$robo$$android_text_method_DigitsKeyListener$getInstance() {
        return DigitsKeyListener.getInstance(false, false);
    }

    private static final DigitsKeyListener $$robo$$android_text_method_DigitsKeyListener$getInstance(boolean sign, boolean decimal) {
        int kind = (sign ? 1 : 0) | (decimal ? 2 : 0);
        if (sInstance[kind] != null) {
            return sInstance[kind];
        }
        DigitsKeyListener.sInstance[kind] = new DigitsKeyListener(sign, decimal);
        return sInstance[kind];
    }

    private static final DigitsKeyListener $$robo$$android_text_method_DigitsKeyListener$getInstance(String accepted) {
        DigitsKeyListener dim = new DigitsKeyListener();
        dim.mAccepted = new char[accepted.length()];
        accepted.getChars(0, accepted.length(), dim.mAccepted, 0);
        return dim;
    }

    private final int $$robo$$android_text_method_DigitsKeyListener$getInputType() {
        int contentType = 2;
        if (this.mSign) {
            contentType |= 0x1000;
        }
        if (this.mDecimal) {
            contentType |= 0x2000;
        }
        return contentType;
    }

    private final CharSequence $$robo$$android_text_method_DigitsKeyListener$filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
        char c;
        int i;
        CharSequence out = super.filter(source, start, end, dest, dstart, dend);
        if (!this.mSign && !this.mDecimal) {
            return out;
        }
        if (out != null) {
            source = out;
            start = 0;
            end = out.length();
        }
        int sign = -1;
        int decimal = -1;
        int dlen = dest.length();
        for (i = 0; i < dstart; ++i) {
            c = dest.charAt(i);
            if (DigitsKeyListener.isSignChar(c)) {
                sign = i;
                continue;
            }
            if (!DigitsKeyListener.isDecimalPointChar(c)) continue;
            decimal = i;
        }
        for (i = dend; i < dlen; ++i) {
            c = dest.charAt(i);
            if (DigitsKeyListener.isSignChar(c)) {
                return "";
            }
            if (!DigitsKeyListener.isDecimalPointChar(c)) continue;
            decimal = i;
        }
        SpannableStringBuilder stripped = null;
        for (int i2 = end - 1; i2 >= start; --i2) {
            char c2 = source.charAt(i2);
            boolean strip = false;
            if (DigitsKeyListener.isSignChar(c2)) {
                if (i2 != start || dstart != 0) {
                    strip = true;
                } else if (sign >= 0) {
                    strip = true;
                } else {
                    sign = i2;
                }
            } else if (DigitsKeyListener.isDecimalPointChar(c2)) {
                if (decimal >= 0) {
                    strip = true;
                } else {
                    decimal = i2;
                }
            }
            if (!strip) continue;
            if (end == start + 1) {
                return "";
            }
            if (stripped == null) {
                stripped = new SpannableStringBuilder(source, start, end);
            }
            stripped.delete(i2 - start, i2 + 1 - start);
        }
        if (stripped != null) {
            return stripped;
        }
        if (out != null) {
            return out;
        }
        return null;
    }

    static void __staticInitializer__() {
        CHARACTERS = new char[][]{{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'}, {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '+'}, {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.'}, {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '+', '.'}};
        sInstance = new DigitsKeyListener[4];
    }

    @Override
    protected char[] getAcceptedChars() {
        return InvokeDynamicSupport.bootstrap("getAcceptedChars", $$robo$$android_text_method_DigitsKeyListener$getAcceptedChars(), 0, this);
    }

    private static boolean isSignChar(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSignChar", $$robo$$android_text_method_DigitsKeyListener$isSignChar(char ), 0, (char)c);
    }

    private static boolean isDecimalPointChar(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDecimalPointChar", $$robo$$android_text_method_DigitsKeyListener$isDecimalPointChar(char ), 0, (char)c);
    }

    private void __constructor__() {
        this.$$robo$$android_text_method_DigitsKeyListener$__constructor__();
    }

    public DigitsKeyListener() {
        this(false, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_method_DigitsKeyListener$__constructor__(), 0, this);
    }

    private void __constructor__(boolean bl, boolean bl2) {
        this.$$robo$$android_text_method_DigitsKeyListener$__constructor__(bl, bl2);
    }

    public DigitsKeyListener(boolean bl, boolean bl2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_method_DigitsKeyListener$__constructor__(boolean boolean ), 0, this, bl, bl2);
    }

    public static DigitsKeyListener getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_text_method_DigitsKeyListener$getInstance(), 0);
    }

    public static DigitsKeyListener getInstance(boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_text_method_DigitsKeyListener$getInstance(boolean boolean ), 0, (boolean)bl, (boolean)bl2);
    }

    public static DigitsKeyListener getInstance(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_text_method_DigitsKeyListener$getInstance(java.lang.String ), 0, (String)string2);
    }

    @Override
    public int getInputType() {
        return (int)InvokeDynamicSupport.bootstrap("getInputType", $$robo$$android_text_method_DigitsKeyListener$getInputType(), 0, this);
    }

    @Override
    public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
        return InvokeDynamicSupport.bootstrap("filter", $$robo$$android_text_method_DigitsKeyListener$filter(java.lang.CharSequence int int android.text.Spanned int int ), 0, this, charSequence, n, n2, spanned, n3, n4);
    }

    static {
        RobolectricInternals.classInitializing(DigitsKeyListener.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DigitsKeyListener)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

