/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.icu.text.BreakIterator;
import android.text.Selection;
import android.text.SpannableStringBuilder;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WordIterator
implements Selection.PositionIterator,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int WINDOW_WIDTH = 50;
    private String mString;
    private int mOffsetShift;
    private BreakIterator mIterator;

    private void $$robo$$android_text_method_WordIterator$__constructor__() {
    }

    private void $$robo$$android_text_method_WordIterator$__constructor__(Locale locale) {
        this.mIterator = BreakIterator.getWordInstance(locale);
    }

    private final void $$robo$$android_text_method_WordIterator$setCharSequence(CharSequence charSequence, int start, int end) {
        this.mOffsetShift = Math.max(0, start - 50);
        int windowEnd = Math.min(charSequence.length(), end + 50);
        this.mString = charSequence instanceof SpannableStringBuilder ? ((SpannableStringBuilder)charSequence).substring(this.mOffsetShift, windowEnd) : charSequence.subSequence(this.mOffsetShift, windowEnd).toString();
        this.mIterator.setText(this.mString);
    }

    private final int $$robo$$android_text_method_WordIterator$preceding(int offset) {
        int shiftedOffset = offset - this.mOffsetShift;
        do {
            if ((shiftedOffset = this.mIterator.preceding(shiftedOffset)) != -1) continue;
            return -1;
        } while (!this.isOnLetterOrDigit(shiftedOffset));
        return shiftedOffset + this.mOffsetShift;
    }

    private final int $$robo$$android_text_method_WordIterator$following(int offset) {
        int shiftedOffset = offset - this.mOffsetShift;
        do {
            if ((shiftedOffset = this.mIterator.following(shiftedOffset)) != -1) continue;
            return -1;
        } while (!this.isAfterLetterOrDigit(shiftedOffset));
        return shiftedOffset + this.mOffsetShift;
    }

    private final boolean $$robo$$android_text_method_WordIterator$isBoundary(int offset) {
        int shiftedOffset = offset - this.mOffsetShift;
        this.checkOffsetIsValid(shiftedOffset);
        return this.mIterator.isBoundary(shiftedOffset);
    }

    private final int $$robo$$android_text_method_WordIterator$nextBoundary(int offset) {
        int shiftedOffset = offset - this.mOffsetShift;
        if ((shiftedOffset = this.mIterator.following(shiftedOffset)) == -1) {
            return -1;
        }
        return shiftedOffset + this.mOffsetShift;
    }

    private final int $$robo$$android_text_method_WordIterator$prevBoundary(int offset) {
        int shiftedOffset = offset - this.mOffsetShift;
        if ((shiftedOffset = this.mIterator.preceding(shiftedOffset)) == -1) {
            return -1;
        }
        return shiftedOffset + this.mOffsetShift;
    }

    private final int $$robo$$android_text_method_WordIterator$getBeginning(int offset) {
        return this.getBeginning(offset, false);
    }

    private final int $$robo$$android_text_method_WordIterator$getEnd(int offset) {
        return this.getEnd(offset, false);
    }

    private final int $$robo$$android_text_method_WordIterator$getPrevWordBeginningOnTwoWordsBoundary(int offset) {
        return this.getBeginning(offset, true);
    }

    private final int $$robo$$android_text_method_WordIterator$getNextWordEndOnTwoWordBoundary(int offset) {
        return this.getEnd(offset, true);
    }

    private final int $$robo$$android_text_method_WordIterator$getBeginning(int offset, boolean getPrevWordBeginningOnTwoWordsBoundary) {
        int shiftedOffset = offset - this.mOffsetShift;
        this.checkOffsetIsValid(shiftedOffset);
        if (this.isOnLetterOrDigit(shiftedOffset)) {
            if (!(!this.mIterator.isBoundary(shiftedOffset) || this.isAfterLetterOrDigit(shiftedOffset) && getPrevWordBeginningOnTwoWordsBoundary)) {
                return shiftedOffset + this.mOffsetShift;
            }
            return this.mIterator.preceding(shiftedOffset) + this.mOffsetShift;
        }
        if (this.isAfterLetterOrDigit(shiftedOffset)) {
            return this.mIterator.preceding(shiftedOffset) + this.mOffsetShift;
        }
        return -1;
    }

    private final int $$robo$$android_text_method_WordIterator$getEnd(int offset, boolean getNextWordEndOnTwoWordBoundary) {
        int shiftedOffset = offset - this.mOffsetShift;
        this.checkOffsetIsValid(shiftedOffset);
        if (this.isAfterLetterOrDigit(shiftedOffset)) {
            if (!(!this.mIterator.isBoundary(shiftedOffset) || this.isOnLetterOrDigit(shiftedOffset) && getNextWordEndOnTwoWordBoundary)) {
                return shiftedOffset + this.mOffsetShift;
            }
            return this.mIterator.following(shiftedOffset) + this.mOffsetShift;
        }
        if (this.isOnLetterOrDigit(shiftedOffset)) {
            return this.mIterator.following(shiftedOffset) + this.mOffsetShift;
        }
        return -1;
    }

    private final int $$robo$$android_text_method_WordIterator$getPunctuationBeginning(int offset) {
        while (offset != -1 && !this.isPunctuationStartBoundary(offset)) {
            offset = this.prevBoundary(offset);
        }
        return offset;
    }

    private final int $$robo$$android_text_method_WordIterator$getPunctuationEnd(int offset) {
        while (offset != -1 && !this.isPunctuationEndBoundary(offset)) {
            offset = this.nextBoundary(offset);
        }
        return offset;
    }

    private final boolean $$robo$$android_text_method_WordIterator$isAfterPunctuation(int offset) {
        int shiftedOffset = offset - this.mOffsetShift;
        if (shiftedOffset >= 1 && shiftedOffset <= this.mString.length()) {
            int codePoint = this.mString.codePointBefore(shiftedOffset);
            return this.isPunctuation(codePoint);
        }
        return false;
    }

    private final boolean $$robo$$android_text_method_WordIterator$isOnPunctuation(int offset) {
        int shiftedOffset = offset - this.mOffsetShift;
        if (shiftedOffset >= 0 && shiftedOffset < this.mString.length()) {
            int codePoint = this.mString.codePointAt(shiftedOffset);
            return this.isPunctuation(codePoint);
        }
        return false;
    }

    private final boolean $$robo$$android_text_method_WordIterator$isPunctuationStartBoundary(int offset) {
        return this.isOnPunctuation(offset) && !this.isAfterPunctuation(offset);
    }

    private final boolean $$robo$$android_text_method_WordIterator$isPunctuationEndBoundary(int offset) {
        return !this.isOnPunctuation(offset) && this.isAfterPunctuation(offset);
    }

    private final boolean $$robo$$android_text_method_WordIterator$isPunctuation(int cp) {
        int type = Character.getType(cp);
        return type == 23 || type == 20 || type == 22 || type == 30 || type == 29 || type == 24 || type == 21;
    }

    private final boolean $$robo$$android_text_method_WordIterator$isAfterLetterOrDigit(int shiftedOffset) {
        int codePoint;
        return shiftedOffset >= 1 && shiftedOffset <= this.mString.length() && Character.isLetterOrDigit(codePoint = this.mString.codePointBefore(shiftedOffset));
    }

    private final boolean $$robo$$android_text_method_WordIterator$isOnLetterOrDigit(int shiftedOffset) {
        int codePoint;
        return shiftedOffset >= 0 && shiftedOffset < this.mString.length() && Character.isLetterOrDigit(codePoint = this.mString.codePointAt(shiftedOffset));
    }

    private final void $$robo$$android_text_method_WordIterator$checkOffsetIsValid(int shiftedOffset) {
        if (shiftedOffset < 0 || shiftedOffset > this.mString.length()) {
            throw new IllegalArgumentException("Invalid offset: " + (shiftedOffset + this.mOffsetShift) + ". Valid range is [" + this.mOffsetShift + ", " + (this.mString.length() + this.mOffsetShift) + "]");
        }
    }

    private void __constructor__() {
        this.$$robo$$android_text_method_WordIterator$__constructor__();
    }

    public WordIterator() {
        this(Locale.getDefault());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_method_WordIterator$__constructor__(), 0, this);
    }

    private void __constructor__(Locale locale) {
        this.$$robo$$android_text_method_WordIterator$__constructor__(locale);
    }

    public WordIterator(Locale locale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_method_WordIterator$__constructor__(java.util.Locale ), 0, this, locale);
    }

    public void setCharSequence(CharSequence charSequence, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setCharSequence", $$robo$$android_text_method_WordIterator$setCharSequence(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
    }

    @Override
    public int preceding(int n) {
        return (int)InvokeDynamicSupport.bootstrap("preceding", $$robo$$android_text_method_WordIterator$preceding(int ), 0, this, n);
    }

    @Override
    public int following(int n) {
        return (int)InvokeDynamicSupport.bootstrap("following", $$robo$$android_text_method_WordIterator$following(int ), 0, this, n);
    }

    public boolean isBoundary(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isBoundary", $$robo$$android_text_method_WordIterator$isBoundary(int ), 0, this, n);
    }

    public int nextBoundary(int n) {
        return (int)InvokeDynamicSupport.bootstrap("nextBoundary", $$robo$$android_text_method_WordIterator$nextBoundary(int ), 0, this, n);
    }

    public int prevBoundary(int n) {
        return (int)InvokeDynamicSupport.bootstrap("prevBoundary", $$robo$$android_text_method_WordIterator$prevBoundary(int ), 0, this, n);
    }

    public int getBeginning(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getBeginning", $$robo$$android_text_method_WordIterator$getBeginning(int ), 0, this, n);
    }

    public int getEnd(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getEnd", $$robo$$android_text_method_WordIterator$getEnd(int ), 0, this, n);
    }

    public int getPrevWordBeginningOnTwoWordsBoundary(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPrevWordBeginningOnTwoWordsBoundary", $$robo$$android_text_method_WordIterator$getPrevWordBeginningOnTwoWordsBoundary(int ), 0, this, n);
    }

    public int getNextWordEndOnTwoWordBoundary(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getNextWordEndOnTwoWordBoundary", $$robo$$android_text_method_WordIterator$getNextWordEndOnTwoWordBoundary(int ), 0, this, n);
    }

    private int getBeginning(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getBeginning", $$robo$$android_text_method_WordIterator$getBeginning(int boolean ), 0, this, n, bl);
    }

    private int getEnd(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getEnd", $$robo$$android_text_method_WordIterator$getEnd(int boolean ), 0, this, n, bl);
    }

    public int getPunctuationBeginning(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPunctuationBeginning", $$robo$$android_text_method_WordIterator$getPunctuationBeginning(int ), 0, this, n);
    }

    public int getPunctuationEnd(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPunctuationEnd", $$robo$$android_text_method_WordIterator$getPunctuationEnd(int ), 0, this, n);
    }

    public boolean isAfterPunctuation(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAfterPunctuation", $$robo$$android_text_method_WordIterator$isAfterPunctuation(int ), 0, this, n);
    }

    public boolean isOnPunctuation(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOnPunctuation", $$robo$$android_text_method_WordIterator$isOnPunctuation(int ), 0, this, n);
    }

    private boolean isPunctuationStartBoundary(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPunctuationStartBoundary", $$robo$$android_text_method_WordIterator$isPunctuationStartBoundary(int ), 0, this, n);
    }

    private boolean isPunctuationEndBoundary(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPunctuationEndBoundary", $$robo$$android_text_method_WordIterator$isPunctuationEndBoundary(int ), 0, this, n);
    }

    private boolean isPunctuation(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPunctuation", $$robo$$android_text_method_WordIterator$isPunctuation(int ), 0, this, n);
    }

    private boolean isAfterLetterOrDigit(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAfterLetterOrDigit", $$robo$$android_text_method_WordIterator$isAfterLetterOrDigit(int ), 0, this, n);
    }

    private boolean isOnLetterOrDigit(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOnLetterOrDigit", $$robo$$android_text_method_WordIterator$isOnLetterOrDigit(int ), 0, this, n);
    }

    private void checkOffsetIsValid(int n) {
        InvokeDynamicSupport.bootstrap("checkOffsetIsValid", $$robo$$android_text_method_WordIterator$checkOffsetIsValid(int ), 0, this, n);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WordIterator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

