/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.transition.PathMotion;
import android.util.AttributeSet;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ArcMotion
extends PathMotion
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static float DEFAULT_MIN_ANGLE_DEGREES = 0.0f;
    private static float DEFAULT_MAX_ANGLE_DEGREES = 70.0f;
    private static float DEFAULT_MAX_TANGENT;
    private float mMinimumHorizontalAngle;
    private float mMinimumVerticalAngle;
    private float mMaximumAngle;
    private float mMinimumHorizontalTangent;
    private float mMinimumVerticalTangent;
    private float mMaximumTangent;

    private void $$robo$$android_transition_ArcMotion$__constructor__() {
        this.mMinimumHorizontalAngle = 0.0f;
        this.mMinimumVerticalAngle = 0.0f;
        this.mMaximumAngle = 70.0f;
        this.mMinimumHorizontalTangent = 0.0f;
        this.mMinimumVerticalTangent = 0.0f;
        this.mMaximumTangent = DEFAULT_MAX_TANGENT;
    }

    private void $$robo$$android_transition_ArcMotion$__constructor__(Context context, AttributeSet attrs) {
        this.mMinimumHorizontalAngle = 0.0f;
        this.mMinimumVerticalAngle = 0.0f;
        this.mMaximumAngle = 70.0f;
        this.mMinimumHorizontalTangent = 0.0f;
        this.mMinimumVerticalTangent = 0.0f;
        this.mMaximumTangent = DEFAULT_MAX_TANGENT;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ArcMotion);
        float minimumVerticalAngle = a.getFloat(1, 0.0f);
        this.setMinimumVerticalAngle(minimumVerticalAngle);
        float minimumHorizontalAngle = a.getFloat(0, 0.0f);
        this.setMinimumHorizontalAngle(minimumHorizontalAngle);
        float maximumAngle = a.getFloat(2, 70.0f);
        this.setMaximumAngle(maximumAngle);
        a.recycle();
    }

    private final void $$robo$$android_transition_ArcMotion$setMinimumHorizontalAngle(float angleInDegrees) {
        this.mMinimumHorizontalAngle = angleInDegrees;
        this.mMinimumHorizontalTangent = ArcMotion.toTangent(angleInDegrees);
    }

    private final float $$robo$$android_transition_ArcMotion$getMinimumHorizontalAngle() {
        return this.mMinimumHorizontalAngle;
    }

    private final void $$robo$$android_transition_ArcMotion$setMinimumVerticalAngle(float angleInDegrees) {
        this.mMinimumVerticalAngle = angleInDegrees;
        this.mMinimumVerticalTangent = ArcMotion.toTangent(angleInDegrees);
    }

    private final float $$robo$$android_transition_ArcMotion$getMinimumVerticalAngle() {
        return this.mMinimumVerticalAngle;
    }

    private final void $$robo$$android_transition_ArcMotion$setMaximumAngle(float angleInDegrees) {
        this.mMaximumAngle = angleInDegrees;
        this.mMaximumTangent = ArcMotion.toTangent(angleInDegrees);
    }

    private final float $$robo$$android_transition_ArcMotion$getMaximumAngle() {
        return this.mMaximumAngle;
    }

    private static final float $$robo$$android_transition_ArcMotion$toTangent(float arcInDegrees) {
        if (arcInDegrees < 0.0f || arcInDegrees > 90.0f) {
            throw new IllegalArgumentException("Arc must be between 0 and 90 degrees");
        }
        return (float)Math.tan(Math.toRadians(arcInDegrees / 2.0f));
    }

    private final Path $$robo$$android_transition_ArcMotion$getPath(float startX, float startY, float endX, float endY) {
        float ey;
        float ex;
        Path path = new Path();
        path.moveTo(startX, startY);
        if (startY == endY) {
            ex = (startX + endX) / 2.0f;
            ey = startY + this.mMinimumHorizontalTangent * Math.abs(endX - startX) / 2.0f;
        } else if (startX == endX) {
            ex = startX + this.mMinimumVerticalTangent * Math.abs(endY - startY) / 2.0f;
            ey = (startY + endY) / 2.0f;
        } else {
            boolean isQuadrant1Or3;
            float deltaX = endX - startX;
            float deltaY = endY - startY;
            float h2 = deltaX * deltaX + deltaY * deltaY;
            float dx = (startX + endX) / 2.0f;
            float dy = (startY + endY) / 2.0f;
            float midDist2 = h2 * 0.25f;
            float minimumArcDist2 = 0.0f;
            boolean bl = isQuadrant1Or3 = deltaX * deltaY > 0.0f;
            if (Math.abs(deltaX) < Math.abs(deltaY)) {
                float eDistY = h2 / (2.0f * deltaY);
                if (isQuadrant1Or3) {
                    ey = startY + eDistY;
                    ex = startX;
                } else {
                    ey = endY - eDistY;
                    ex = endX;
                }
                minimumArcDist2 = midDist2 * this.mMinimumVerticalTangent * this.mMinimumVerticalTangent;
            } else {
                float eDistX = h2 / (2.0f * deltaX);
                if (isQuadrant1Or3) {
                    ex = endX - eDistX;
                    ey = endY;
                } else {
                    ex = startX + eDistX;
                    ey = startY;
                }
                minimumArcDist2 = midDist2 * this.mMinimumHorizontalTangent * this.mMinimumHorizontalTangent;
            }
            float arcDistX = dx - ex;
            float arcDistY = dy - ey;
            float arcDist2 = arcDistX * arcDistX + arcDistY * arcDistY;
            float maximumArcDist2 = midDist2 * this.mMaximumTangent * this.mMaximumTangent;
            float newArcDistance2 = 0.0f;
            if (arcDist2 < minimumArcDist2) {
                newArcDistance2 = minimumArcDist2;
            } else if (arcDist2 > maximumArcDist2) {
                newArcDistance2 = maximumArcDist2;
            }
            if (newArcDistance2 != 0.0f) {
                float ratio2 = newArcDistance2 / arcDist2;
                float ratio = (float)Math.sqrt(ratio2);
                ex = dx + ratio * (ex - dx);
                ey = dy + ratio * (ey - dy);
            }
        }
        float controlX1 = (startX + ex) / 2.0f;
        float controlY1 = (startY + ey) / 2.0f;
        float controlX2 = (ex + endX) / 2.0f;
        float controlY2 = (ey + endY) / 2.0f;
        path.cubicTo(controlX1, controlY1, controlX2, controlY2, endX, endY);
        return path;
    }

    static void __staticInitializer__() {
        DEFAULT_MAX_TANGENT = (float)Math.tan(Math.toRadians(35.0));
    }

    private void __constructor__() {
        this.$$robo$$android_transition_ArcMotion$__constructor__();
    }

    public ArcMotion() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_ArcMotion$__constructor__(), 0, this);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_transition_ArcMotion$__constructor__(context, attributeSet);
    }

    public ArcMotion(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_ArcMotion$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    public void setMinimumHorizontalAngle(float f) {
        InvokeDynamicSupport.bootstrap("setMinimumHorizontalAngle", $$robo$$android_transition_ArcMotion$setMinimumHorizontalAngle(float ), 0, this, f);
    }

    public float getMinimumHorizontalAngle() {
        return (float)InvokeDynamicSupport.bootstrap("getMinimumHorizontalAngle", $$robo$$android_transition_ArcMotion$getMinimumHorizontalAngle(), 0, this);
    }

    public void setMinimumVerticalAngle(float f) {
        InvokeDynamicSupport.bootstrap("setMinimumVerticalAngle", $$robo$$android_transition_ArcMotion$setMinimumVerticalAngle(float ), 0, this, f);
    }

    public float getMinimumVerticalAngle() {
        return (float)InvokeDynamicSupport.bootstrap("getMinimumVerticalAngle", $$robo$$android_transition_ArcMotion$getMinimumVerticalAngle(), 0, this);
    }

    public void setMaximumAngle(float f) {
        InvokeDynamicSupport.bootstrap("setMaximumAngle", $$robo$$android_transition_ArcMotion$setMaximumAngle(float ), 0, this, f);
    }

    public float getMaximumAngle() {
        return (float)InvokeDynamicSupport.bootstrap("getMaximumAngle", $$robo$$android_transition_ArcMotion$getMaximumAngle(), 0, this);
    }

    private static float toTangent(float f) {
        return (float)InvokeDynamicSupport.bootstrapStatic("toTangent", $$robo$$android_transition_ArcMotion$toTangent(float ), 0, (float)f);
    }

    @Override
    public Path getPath(float f, float f2, float f3, float f4) {
        return InvokeDynamicSupport.bootstrap("getPath", $$robo$$android_transition_ArcMotion$getPath(float float float float ), 0, this, f, f2, f3, f4);
    }

    static {
        RobolectricInternals.classInitializing(ArcMotion.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ArcMotion)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

