/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.ContainerHelpers;
import android.util.MapCollections;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class ArraySet<E>
implements Collection<E>,
Set<E> {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String TAG = "ArraySet";
    private static int BASE_SIZE = 4;
    private static int CACHE_SIZE = 10;
    static Object[] mBaseCache;
    static int mBaseCacheSize;
    static Object[] mTwiceBaseCache;
    static int mTwiceBaseCacheSize;
    boolean mIdentityHashCode;
    int[] mHashes;
    Object[] mArray;
    int mSize;
    MapCollections<E, E> mCollections;

    private final int $$robo$$android_util_ArraySet$indexOf(Object key, int hash) {
        int end;
        int N = this.mSize;
        if (N == 0) {
            return -1;
        }
        int index = ContainerHelpers.binarySearch(this.mHashes, N, hash);
        if (index < 0) {
            return index;
        }
        if (key.equals(this.mArray[index])) {
            return index;
        }
        for (end = index + 1; end < N && this.mHashes[end] == hash; ++end) {
            if (!key.equals(this.mArray[end])) continue;
            return end;
        }
        for (int i = index - 1; i >= 0 && this.mHashes[i] == hash; --i) {
            if (!key.equals(this.mArray[i])) continue;
            return i;
        }
        return ~end;
    }

    private final int $$robo$$android_util_ArraySet$indexOfNull() {
        int end;
        int N = this.mSize;
        if (N == 0) {
            return -1;
        }
        int index = ContainerHelpers.binarySearch(this.mHashes, N, 0);
        if (index < 0) {
            return index;
        }
        if (null == this.mArray[index]) {
            return index;
        }
        for (end = index + 1; end < N && this.mHashes[end] == 0; ++end) {
            if (null != this.mArray[end]) continue;
            return end;
        }
        for (int i = index - 1; i >= 0 && this.mHashes[i] == 0; --i) {
            if (null != this.mArray[i]) continue;
            return i;
        }
        return ~end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void $$robo$$android_util_ArraySet$allocArrays(int size) {
        if (size == 8) {
            Class<ArraySet> clazz = ArraySet.class;
            // MONITORENTER : android.util.ArraySet.class
            if (mTwiceBaseCache != null) {
                Object[] array2 = mTwiceBaseCache;
                this.mArray = array2;
                mTwiceBaseCache = (Object[])array2[0];
                this.mHashes = (int[])array2[1];
                array2[1] = null;
                array2[0] = null;
                --mTwiceBaseCacheSize;
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz
        } else if (size == 4) {
            Class<ArraySet> clazz = ArraySet.class;
            // MONITORENTER : android.util.ArraySet.class
            if (mBaseCache != null) {
                Object[] array3 = mBaseCache;
                this.mArray = array3;
                mBaseCache = (Object[])array3[0];
                this.mHashes = (int[])array3[1];
                array3[1] = null;
                array3[0] = null;
                --mBaseCacheSize;
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz
        }
        this.mHashes = new int[size];
        this.mArray = new Object[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void $$robo$$android_util_ArraySet$freeArrays(int[] hashes, Object[] array2, int size) {
        if (hashes.length == 8) {
            Class<ArraySet> clazz = ArraySet.class;
            synchronized (ArraySet.class) {
                if (mTwiceBaseCacheSize >= 10) return;
                array2[0] = mTwiceBaseCache;
                array2[1] = hashes;
                for (int i = size - 1; i >= 2; --i) {
                    array2[i] = null;
                }
                mTwiceBaseCache = array2;
                ++mTwiceBaseCacheSize;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
        if (hashes.length != 4) return;
        Class<ArraySet> clazz = ArraySet.class;
        synchronized (ArraySet.class) {
            if (mBaseCacheSize >= 10) return;
            array2[0] = mBaseCache;
            array2[1] = hashes;
            for (int i = size - 1; i >= 2; --i) {
                array2[i] = null;
            }
            mBaseCache = array2;
            ++mBaseCacheSize;
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    private void $$robo$$android_util_ArraySet$__constructor__() {
    }

    private void $$robo$$android_util_ArraySet$__constructor__(int capacity) {
    }

    private void $$robo$$android_util_ArraySet$__constructor__(int capacity, boolean identityHashCode) {
        this.mIdentityHashCode = identityHashCode;
        if (capacity == 0) {
            this.mHashes = EmptyArray.INT;
            this.mArray = EmptyArray.OBJECT;
        } else {
            this.allocArrays(capacity);
        }
        this.mSize = 0;
    }

    private void $$robo$$android_util_ArraySet$__constructor__(ArraySet<E> set) {
        if (set != null) {
            this.addAll(set);
        }
    }

    private void $$robo$$android_util_ArraySet$__constructor__(Collection<E> set) {
        if (set != null) {
            this.addAll(set);
        }
    }

    private final void $$robo$$android_util_ArraySet$clear() {
        if (this.mSize != 0) {
            ArraySet.freeArrays(this.mHashes, this.mArray, this.mSize);
            this.mHashes = EmptyArray.INT;
            this.mArray = EmptyArray.OBJECT;
            this.mSize = 0;
        }
    }

    private final void $$robo$$android_util_ArraySet$ensureCapacity(int minimumCapacity) {
        if (this.mHashes.length < minimumCapacity) {
            int[] ohashes = this.mHashes;
            Object[] oarray = this.mArray;
            this.allocArrays(minimumCapacity);
            if (this.mSize > 0) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])ohashes, (int)0, (int[])this.mHashes, (int)0, (int)this.mSize);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oarray, (int)0, (Object)this.mArray, (int)0, (int)this.mSize);
            }
            ArraySet.freeArrays(ohashes, oarray, this.mSize);
        }
    }

    private final boolean $$robo$$android_util_ArraySet$contains(Object key) {
        return this.indexOf(key) >= 0;
    }

    private final int $$robo$$android_util_ArraySet$indexOf(Object key) {
        return key == null ? this.indexOfNull() : this.indexOf(key, this.mIdentityHashCode ? System.identityHashCode(key) : key.hashCode());
    }

    private final E $$robo$$android_util_ArraySet$valueAt(int index) {
        return (E)this.mArray[index];
    }

    private final boolean $$robo$$android_util_ArraySet$isEmpty() {
        return this.mSize <= 0;
    }

    private final boolean $$robo$$android_util_ArraySet$add(E value) {
        int index;
        int hash;
        if (value == null) {
            hash = 0;
            index = this.indexOfNull();
        } else {
            hash = this.mIdentityHashCode ? System.identityHashCode(value) : value.hashCode();
            index = this.indexOf(value, hash);
        }
        if (index >= 0) {
            return false;
        }
        index ^= 0xFFFFFFFF;
        if (this.mSize >= this.mHashes.length) {
            int n = this.mSize >= 8 ? this.mSize + (this.mSize >> 1) : (this.mSize >= 4 ? 8 : 4);
            int[] ohashes = this.mHashes;
            Object[] oarray = this.mArray;
            this.allocArrays(n);
            if (this.mHashes.length > 0) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])ohashes, (int)0, (int[])this.mHashes, (int)0, (int)ohashes.length);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oarray, (int)0, (Object)this.mArray, (int)0, (int)oarray.length);
            }
            ArraySet.freeArrays(ohashes, oarray, this.mSize);
        }
        if (index < this.mSize) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.mHashes, (int)index, (int[])this.mHashes, (int)(index + 1), (int)(this.mSize - index));
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mArray, (int)index, (Object)this.mArray, (int)(index + 1), (int)(this.mSize - index));
        }
        this.mHashes[index] = hash;
        this.mArray[index] = value;
        ++this.mSize;
        return true;
    }

    private final void $$robo$$android_util_ArraySet$append(E value) {
        int hash;
        int index = this.mSize;
        int n = value == null ? 0 : (hash = this.mIdentityHashCode ? System.identityHashCode(value) : value.hashCode());
        if (index >= this.mHashes.length) {
            throw new IllegalStateException("Array is full");
        }
        if (index > 0 && this.mHashes[index - 1] > hash) {
            this.add(value);
            return;
        }
        this.mSize = index + 1;
        this.mHashes[index] = hash;
        this.mArray[index] = value;
    }

    private final void $$robo$$android_util_ArraySet$addAll(ArraySet<? extends E> array2) {
        int N = array2.mSize;
        this.ensureCapacity(this.mSize + N);
        if (this.mSize == 0) {
            if (N > 0) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])array2.mHashes, (int)0, (int[])this.mHashes, (int)0, (int)N);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)array2.mArray, (int)0, (Object)this.mArray, (int)0, (int)N);
                this.mSize = N;
            }
        } else {
            for (int i = 0; i < N; ++i) {
                this.add(array2.valueAt(i));
            }
        }
    }

    private final boolean $$robo$$android_util_ArraySet$remove(Object object) {
        int index = this.indexOf(object);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    private final E $$robo$$android_util_ArraySet$removeAt(int index) {
        Object old = this.mArray[index];
        if (this.mSize <= 1) {
            ArraySet.freeArrays(this.mHashes, this.mArray, this.mSize);
            this.mHashes = EmptyArray.INT;
            this.mArray = EmptyArray.OBJECT;
            this.mSize = 0;
        } else if (this.mHashes.length > 8 && this.mSize < this.mHashes.length / 3) {
            int n = this.mSize > 8 ? this.mSize + (this.mSize >> 1) : 8;
            int[] ohashes = this.mHashes;
            Object[] oarray = this.mArray;
            this.allocArrays(n);
            --this.mSize;
            if (index > 0) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])ohashes, (int)0, (int[])this.mHashes, (int)0, (int)index);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oarray, (int)0, (Object)this.mArray, (int)0, (int)index);
            }
            if (index < this.mSize) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])ohashes, (int)(index + 1), (int[])this.mHashes, (int)index, (int)(this.mSize - index));
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oarray, (int)(index + 1), (Object)this.mArray, (int)index, (int)(this.mSize - index));
            }
        } else {
            --this.mSize;
            if (index < this.mSize) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.mHashes, (int)(index + 1), (int[])this.mHashes, (int)index, (int)(this.mSize - index));
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mArray, (int)(index + 1), (Object)this.mArray, (int)index, (int)(this.mSize - index));
            }
            this.mArray[this.mSize] = null;
        }
        return (E)old;
    }

    private final boolean $$robo$$android_util_ArraySet$removeAll(ArraySet<? extends E> array2) {
        int N = array2.mSize;
        int originalSize = this.mSize;
        for (int i = 0; i < N; ++i) {
            this.remove(array2.valueAt(i));
        }
        return originalSize != this.mSize;
    }

    private final int $$robo$$android_util_ArraySet$size() {
        return this.mSize;
    }

    private final Object[] $$robo$$android_util_ArraySet$toArray() {
        Object[] result = new Object[this.mSize];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mArray, (int)0, (Object)result, (int)0, (int)this.mSize);
        return result;
    }

    private final <T> T[] $$robo$$android_util_ArraySet$toArray(T[] array2) {
        if (array2.length < this.mSize) {
            Object[] newArray = (Object[])Array.newInstance(array2.getClass().getComponentType(), this.mSize);
            array2 = newArray;
        }
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mArray, (int)0, array2, (int)0, (int)this.mSize);
        if (array2.length > this.mSize) {
            array2[this.mSize] = null;
        }
        return array2;
    }

    private final boolean $$robo$$android_util_ArraySet$equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Set) {
            Set set = (Set)object;
            if (this.size() != set.size()) {
                return false;
            }
            try {
                for (int i = 0; i < this.mSize; ++i) {
                    E mine = this.valueAt(i);
                    if (set.contains(mine)) continue;
                    return false;
                }
            }
            catch (NullPointerException ignored) {
                return false;
            }
            catch (ClassCastException ignored) {
                return false;
            }
            return true;
        }
        return false;
    }

    private final int $$robo$$android_util_ArraySet$hashCode() {
        int[] hashes = this.mHashes;
        int result = 0;
        int s = this.mSize;
        for (int i = 0; i < s; ++i) {
            result += hashes[i];
        }
        return result;
    }

    private final String $$robo$$android_util_ArraySet$toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 14);
        buffer.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            E value;
            if (i > 0) {
                buffer.append(", ");
            }
            if ((value = this.valueAt(i)) != this) {
                buffer.append(value);
                continue;
            }
            buffer.append("(this Set)");
        }
        buffer.append('}');
        return buffer.toString();
    }

    private final MapCollections<E, E> $$robo$$android_util_ArraySet$getCollection() {
        if (this.mCollections == null) {
            this.mCollections = new MapCollections<E, E>(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ArraySet this$0;

                private void $$robo$$android_util_ArraySet_1$__constructor__(ArraySet this$0) {
                }

                private final int $$robo$$android_util_ArraySet_1$colGetSize() {
                    return this.this$0.mSize;
                }

                private final Object $$robo$$android_util_ArraySet_1$colGetEntry(int index, int offset) {
                    return this.this$0.mArray[index];
                }

                private final int $$robo$$android_util_ArraySet_1$colIndexOfKey(Object key) {
                    return this.this$0.indexOf(key);
                }

                private final int $$robo$$android_util_ArraySet_1$colIndexOfValue(Object value) {
                    return this.this$0.indexOf(value);
                }

                private final Map<E, E> $$robo$$android_util_ArraySet_1$colGetMap() {
                    throw new UnsupportedOperationException("not a map");
                }

                private final void $$robo$$android_util_ArraySet_1$colPut(E key, E value) {
                    this.this$0.add(key);
                }

                private final E $$robo$$android_util_ArraySet_1$colSetValue(int index, E value) {
                    throw new UnsupportedOperationException("not a map");
                }

                private final void $$robo$$android_util_ArraySet_1$colRemoveAt(int index) {
                    this.this$0.removeAt(index);
                }

                private final void $$robo$$android_util_ArraySet_1$colClear() {
                    this.this$0.clear();
                }

                private void __constructor__(ArraySet arraySet) {
                    this.$$robo$$android_util_ArraySet_1$__constructor__(arraySet);
                }
                {
                    this.this$0 = arraySet;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_ArraySet_1$__constructor__(android.util.ArraySet ), 0, this, arraySet);
                }

                @Override
                protected int colGetSize() {
                    return (int)InvokeDynamicSupport.bootstrap("colGetSize", $$robo$$android_util_ArraySet_1$colGetSize(), 0, this);
                }

                @Override
                protected Object colGetEntry(int n, int n2) {
                    return InvokeDynamicSupport.bootstrap("colGetEntry", $$robo$$android_util_ArraySet_1$colGetEntry(int int ), 0, this, n, n2);
                }

                @Override
                protected int colIndexOfKey(Object object) {
                    return (int)InvokeDynamicSupport.bootstrap("colIndexOfKey", $$robo$$android_util_ArraySet_1$colIndexOfKey(java.lang.Object ), 0, this, object);
                }

                @Override
                protected int colIndexOfValue(Object object) {
                    return (int)InvokeDynamicSupport.bootstrap("colIndexOfValue", $$robo$$android_util_ArraySet_1$colIndexOfValue(java.lang.Object ), 0, this, object);
                }

                @Override
                protected Map<E, E> colGetMap() {
                    return InvokeDynamicSupport.bootstrap("colGetMap", $$robo$$android_util_ArraySet_1$colGetMap(), 0, this);
                }

                @Override
                protected void colPut(E e, E e2) {
                    InvokeDynamicSupport.bootstrap("colPut", $$robo$$android_util_ArraySet_1$colPut(E E ), 0, this, e, e2);
                }

                @Override
                protected E colSetValue(int n, E e) {
                    return InvokeDynamicSupport.bootstrap("colSetValue", $$robo$$android_util_ArraySet_1$colSetValue(int E ), 0, this, n, e);
                }

                @Override
                protected void colRemoveAt(int n) {
                    InvokeDynamicSupport.bootstrap("colRemoveAt", $$robo$$android_util_ArraySet_1$colRemoveAt(int ), 0, this, n);
                }

                @Override
                protected void colClear() {
                    InvokeDynamicSupport.bootstrap("colClear", $$robo$$android_util_ArraySet_1$colClear(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }
        return this.mCollections;
    }

    private final Iterator<E> $$robo$$android_util_ArraySet$iterator() {
        return this.getCollection().getKeySet().iterator();
    }

    private final boolean $$robo$$android_util_ArraySet$containsAll(Collection<?> collection) {
        Iterator<?> it = collection.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_util_ArraySet$addAll(Collection<? extends E> collection) {
        this.ensureCapacity(this.mSize + collection.size());
        boolean added = false;
        for (E value : collection) {
            added |= this.add(value);
        }
        return added;
    }

    private final boolean $$robo$$android_util_ArraySet$removeAll(Collection<?> collection) {
        boolean removed = false;
        for (Object value : collection) {
            removed |= this.remove(value);
        }
        return removed;
    }

    private final boolean $$robo$$android_util_ArraySet$retainAll(Collection<?> collection) {
        boolean removed = false;
        for (int i = this.mSize - 1; i >= 0; --i) {
            if (collection.contains(this.mArray[i])) continue;
            this.removeAt(i);
            removed = true;
        }
        return removed;
    }

    private int indexOf(Object object, int n) {
        return (int)InvokeDynamicSupport.bootstrap("indexOf", $$robo$$android_util_ArraySet$indexOf(java.lang.Object int ), 0, this, object, n);
    }

    private int indexOfNull() {
        return (int)InvokeDynamicSupport.bootstrap("indexOfNull", $$robo$$android_util_ArraySet$indexOfNull(), 0, this);
    }

    private void allocArrays(int n) {
        InvokeDynamicSupport.bootstrap("allocArrays", $$robo$$android_util_ArraySet$allocArrays(int ), 0, this, n);
    }

    private static void freeArrays(int[] nArray, Object[] objectArray, int n) {
        InvokeDynamicSupport.bootstrapStatic("freeArrays", $$robo$$android_util_ArraySet$freeArrays(int[] java.lang.Object[] int ), 0, (int[])nArray, (Object[])objectArray, (int)n);
    }

    private void __constructor__() {
        this.$$robo$$android_util_ArraySet$__constructor__();
    }

    public ArraySet() {
        this(0, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_ArraySet$__constructor__(), 0, this);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_util_ArraySet$__constructor__(n);
    }

    public ArraySet(int n) {
        this(n, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_ArraySet$__constructor__(int ), 0, this, n);
    }

    private void __constructor__(int n, boolean bl) {
        this.$$robo$$android_util_ArraySet$__constructor__(n, bl);
    }

    public ArraySet(int n, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_ArraySet$__constructor__(int boolean ), 0, this, n, bl);
    }

    private void __constructor__(ArraySet<E> arraySet) {
        this.$$robo$$android_util_ArraySet$__constructor__(arraySet);
    }

    public ArraySet(ArraySet<E> arraySet) {
        this();
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_ArraySet$__constructor__(android.util.ArraySet<E> ), 0, this, arraySet);
    }

    private void __constructor__(Collection<E> collection) {
        this.$$robo$$android_util_ArraySet$__constructor__(collection);
    }

    public ArraySet(Collection<E> collection) {
        this();
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_ArraySet$__constructor__(java.util.Collection<E> ), 0, this, collection);
    }

    @Override
    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_util_ArraySet$clear(), 0, this);
    }

    public void ensureCapacity(int n) {
        InvokeDynamicSupport.bootstrap("ensureCapacity", $$robo$$android_util_ArraySet$ensureCapacity(int ), 0, this, n);
    }

    @Override
    public boolean contains(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_util_ArraySet$contains(java.lang.Object ), 0, this, object);
    }

    public int indexOf(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("indexOf", $$robo$$android_util_ArraySet$indexOf(java.lang.Object ), 0, this, object);
    }

    public E valueAt(int n) {
        return (E)InvokeDynamicSupport.bootstrap("valueAt", $$robo$$android_util_ArraySet$valueAt(int ), 0, this, n);
    }

    @Override
    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_util_ArraySet$isEmpty(), 0, this);
    }

    @Override
    public boolean add(E e) {
        return (boolean)InvokeDynamicSupport.bootstrap("add", $$robo$$android_util_ArraySet$add(E ), 0, this, e);
    }

    public void append(E e) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$android_util_ArraySet$append(E ), 0, this, e);
    }

    public void addAll(ArraySet<? extends E> arraySet) {
        InvokeDynamicSupport.bootstrap("addAll", $$robo$$android_util_ArraySet$addAll(android.util.ArraySet<? extends E> ), 0, this, arraySet);
    }

    @Override
    public boolean remove(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("remove", $$robo$$android_util_ArraySet$remove(java.lang.Object ), 0, this, object);
    }

    public E removeAt(int n) {
        return (E)InvokeDynamicSupport.bootstrap("removeAt", $$robo$$android_util_ArraySet$removeAt(int ), 0, this, n);
    }

    @Override
    public boolean removeAll(ArraySet<? extends E> arraySet) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeAll", $$robo$$android_util_ArraySet$removeAll(android.util.ArraySet<? extends E> ), 0, this, arraySet);
    }

    @Override
    public int size() {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_util_ArraySet$size(), 0, this);
    }

    @Override
    public Object[] toArray() {
        return InvokeDynamicSupport.bootstrap("toArray", $$robo$$android_util_ArraySet$toArray(), 0, this);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return InvokeDynamicSupport.bootstrap("toArray", $$robo$$android_util_ArraySet$toArray(T[] ), 0, this, TArray);
    }

    @Override
    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_util_ArraySet$equals(java.lang.Object ), 0, this, object);
    }

    @Override
    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_util_ArraySet$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_util_ArraySet$toString(), 0, this);
    }

    private MapCollections<E, E> getCollection() {
        return InvokeDynamicSupport.bootstrap("getCollection", $$robo$$android_util_ArraySet$getCollection(), 0, this);
    }

    @Override
    public Iterator<E> iterator() {
        return InvokeDynamicSupport.bootstrap("iterator", $$robo$$android_util_ArraySet$iterator(), 0, this);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsAll", $$robo$$android_util_ArraySet$containsAll(java.util.Collection<?> ), 0, this, collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return (boolean)InvokeDynamicSupport.bootstrap("addAll", $$robo$$android_util_ArraySet$addAll(java.util.Collection<? extends E> ), 0, this, collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeAll", $$robo$$android_util_ArraySet$removeAll(java.util.Collection<?> ), 0, this, collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return (boolean)InvokeDynamicSupport.bootstrap("retainAll", $$robo$$android_util_ArraySet$retainAll(java.util.Collection<?> ), 0, this, collection);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ArraySet)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

