/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class EventLog
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "EventLog";
    private static String TAGS_FILE = "/system/etc/event-log-tags";
    private static String COMMENT_PATTERN = "^\\s*(#.*)?$";
    private static String TAG_PATTERN = "^\\s*(\\d+)\\s+(\\w+)\\s*(\\(.*\\))?\\s*$";
    private static HashMap<String, Integer> sTagCodes;
    private static HashMap<Integer, String> sTagNames;

    private void $$robo$$android_util_EventLog$__constructor__() {
    }

    private static final int $$robo$$android_util_EventLog$writeEvent(int n, int n2) {
        return 0;
    }

    private static final int $$robo$$android_util_EventLog$writeEvent(int n, long l) {
        return 0;
    }

    private static final int $$robo$$android_util_EventLog$writeEvent(int n, float f) {
        return 0;
    }

    private static final int $$robo$$android_util_EventLog$writeEvent(int n, String string2) {
        return 0;
    }

    private static final int $$robo$$android_util_EventLog$writeEvent(int n, Object ... objectArray) {
        return 0;
    }

    private static final void $$robo$$android_util_EventLog$readEvents(int[] nArray, Collection<Event> collection) throws IOException {
    }

    private static final String $$robo$$android_util_EventLog$getTagName(int tag) {
        EventLog.readTagsFile();
        return sTagNames.get(tag);
    }

    private static final int $$robo$$android_util_EventLog$getTagCode(String name) {
        EventLog.readTagsFile();
        Integer code = sTagCodes.get(name);
        return code != null ? code : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final synchronized void $$robo$$android_util_EventLog$readTagsFile() {
        if (sTagCodes != null && sTagNames != null) {
            return;
        }
        sTagCodes = new HashMap();
        sTagNames = new HashMap();
        Pattern comment = Pattern.compile("^\\s*(#.*)?$");
        Pattern tag = Pattern.compile("^\\s*(\\d+)\\s+(\\w+)\\s*(\\(.*\\))?\\s*$");
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader("/system/etc/event-log-tags"), 256);
            while ((line = reader.readLine()) != null) {
                if (comment.matcher(line).matches()) continue;
                Matcher m = tag.matcher(line);
                if (!m.matches()) {
                    Log.wtf("EventLog", "Bad entry in /system/etc/event-log-tags: " + line);
                    continue;
                }
                try {
                    int num = Integer.parseInt(m.group(1));
                    String name = m.group(2);
                    sTagCodes.put(name, num);
                    sTagNames.put(num, name);
                }
                catch (NumberFormatException e) {
                    Log.wtf("EventLog", "Error in /system/etc/event-log-tags: " + line, e);
                }
            }
        }
        catch (IOException e) {
            Log.wtf("EventLog", "Error reading /system/etc/event-log-tags", e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    static void __staticInitializer__() {
        sTagCodes = null;
        sTagNames = null;
    }

    private void __constructor__() {
        this.$$robo$$android_util_EventLog$__constructor__();
    }

    public EventLog() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_EventLog$__constructor__(), 0, this);
    }

    private static final native /* synthetic */ int $$robo$$writeEvent$nativeBinding(int var0, int var1);

    public static int writeEvent(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("writeEvent", $$robo$$android_util_EventLog$writeEvent(int int ), 1, (int)n, (int)n2);
    }

    private static final native /* synthetic */ int $$robo$$writeEvent$nativeBinding(int var0, long var1);

    public static int writeEvent(int n, long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("writeEvent", $$robo$$android_util_EventLog$writeEvent(int long ), 1, (int)n, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$writeEvent$nativeBinding(int var0, float var1);

    public static int writeEvent(int n, float f) {
        return (int)InvokeDynamicSupport.bootstrapStatic("writeEvent", $$robo$$android_util_EventLog$writeEvent(int float ), 1, (int)n, (float)f);
    }

    private static final native /* synthetic */ int $$robo$$writeEvent$nativeBinding(int var0, String var1);

    public static int writeEvent(int n, String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("writeEvent", $$robo$$android_util_EventLog$writeEvent(int java.lang.String ), 1, (int)n, (String)string2);
    }

    private static final native /* synthetic */ int $$robo$$writeEvent$nativeBinding(int var0, Object ... var1);

    public static int writeEvent(int n, Object ... objectArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("writeEvent", $$robo$$android_util_EventLog$writeEvent(int java.lang.Object[] ), 1, (int)n, (Object[])objectArray);
    }

    private static final native /* synthetic */ void $$robo$$readEvents$nativeBinding(int[] var0, Collection<Event> var1) throws IOException;

    public static void readEvents(int[] nArray, Collection<Event> collection) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("readEvents", $$robo$$android_util_EventLog$readEvents(int[] java.util.Collection<android.util.EventLog$Event> ), 1, (int[])nArray, collection);
    }

    public static String getTagName(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getTagName", $$robo$$android_util_EventLog$getTagName(int ), 0, (int)n);
    }

    public static int getTagCode(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getTagCode", $$robo$$android_util_EventLog$getTagCode(java.lang.String ), 0, (String)string2);
    }

    private static synchronized void readTagsFile() {
        InvokeDynamicSupport.bootstrapStatic("readTagsFile", $$robo$$android_util_EventLog$readTagsFile(), 0);
    }

    static {
        RobolectricInternals.classInitializing(EventLog.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventLog)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Event
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ByteBuffer mBuffer;
        private static int LENGTH_OFFSET = 0;
        private static int HEADER_SIZE_OFFSET = 2;
        private static int PROCESS_OFFSET = 4;
        private static int THREAD_OFFSET = 8;
        private static int SECONDS_OFFSET = 12;
        private static int NANOSECONDS_OFFSET = 16;
        private static int V1_PAYLOAD_START = 20;
        private static int DATA_OFFSET = 4;
        private static byte INT_TYPE = 0;
        private static byte LONG_TYPE = 1;
        private static byte STRING_TYPE = 2;
        private static byte LIST_TYPE = 3;
        private static byte FLOAT_TYPE = 4;

        private void $$robo$$android_util_EventLog_Event$__constructor__(byte[] data) {
            this.mBuffer = ByteBuffer.wrap(data);
            this.mBuffer.order(ByteOrder.nativeOrder());
        }

        private final int $$robo$$android_util_EventLog_Event$getProcessId() {
            return this.mBuffer.getInt(4);
        }

        private final int $$robo$$android_util_EventLog_Event$getThreadId() {
            return this.mBuffer.getInt(8);
        }

        private final long $$robo$$android_util_EventLog_Event$getTimeNanos() {
            return (long)this.mBuffer.getInt(12) * 1000000000L + (long)this.mBuffer.getInt(16);
        }

        private final int $$robo$$android_util_EventLog_Event$getTag() {
            int offset = this.mBuffer.getShort(2);
            if (offset == 0) {
                offset = 20;
            }
            return this.mBuffer.getInt(offset);
        }

        private final synchronized Object $$robo$$android_util_EventLog_Event$getData() {
            try {
                int offset = this.mBuffer.getShort(2);
                if (offset == 0) {
                    offset = 20;
                }
                this.mBuffer.limit(offset + this.mBuffer.getShort(0));
                this.mBuffer.position(offset + 4);
                return this.decodeObject();
            }
            catch (IllegalArgumentException e) {
                Log.wtf("EventLog", "Illegal entry payload: tag=" + this.getTag(), e);
                return null;
            }
            catch (BufferUnderflowException e) {
                Log.wtf("EventLog", "Truncated entry payload: tag=" + this.getTag(), e);
                return null;
            }
        }

        private final Object $$robo$$android_util_EventLog_Event$decodeObject() {
            byte type = this.mBuffer.get();
            switch (type) {
                case 0: {
                    return this.mBuffer.getInt();
                }
                case 1: {
                    return this.mBuffer.getLong();
                }
                case 4: {
                    return Float.valueOf(this.mBuffer.getFloat());
                }
                case 2: {
                    try {
                        int length = this.mBuffer.getInt();
                        int start = this.mBuffer.position();
                        this.mBuffer.position(start + length);
                        return new String(this.mBuffer.array(), start, length, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        Log.wtf("EventLog", "UTF-8 is not supported", e);
                        return null;
                    }
                }
                case 3: {
                    int length = this.mBuffer.get();
                    if (length < 0) {
                        length += 256;
                    }
                    Object[] array2 = new Object[length];
                    for (int i = 0; i < length; ++i) {
                        array2[i] = this.decodeObject();
                    }
                    return array2;
                }
            }
            throw new IllegalArgumentException("Unknown entry type: " + type);
        }

        private static final Event $$robo$$android_util_EventLog_Event$fromBytes(byte[] data) {
            return new Event(data);
        }

        private final byte[] $$robo$$android_util_EventLog_Event$getBytes() {
            byte[] bytes = this.mBuffer.array();
            return Arrays.copyOf(bytes, bytes.length);
        }

        private void __constructor__(byte[] byArray) {
            this.$$robo$$android_util_EventLog_Event$__constructor__(byArray);
        }

        Event(byte[] byArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_EventLog_Event$__constructor__(byte[] ), 0, this, byArray);
        }

        public int getProcessId() {
            return (int)InvokeDynamicSupport.bootstrap("getProcessId", $$robo$$android_util_EventLog_Event$getProcessId(), 0, this);
        }

        public int getThreadId() {
            return (int)InvokeDynamicSupport.bootstrap("getThreadId", $$robo$$android_util_EventLog_Event$getThreadId(), 0, this);
        }

        public long getTimeNanos() {
            return (long)InvokeDynamicSupport.bootstrap("getTimeNanos", $$robo$$android_util_EventLog_Event$getTimeNanos(), 0, this);
        }

        public int getTag() {
            return (int)InvokeDynamicSupport.bootstrap("getTag", $$robo$$android_util_EventLog_Event$getTag(), 0, this);
        }

        public synchronized Object getData() {
            return InvokeDynamicSupport.bootstrap("getData", $$robo$$android_util_EventLog_Event$getData(), 0, this);
        }

        private Object decodeObject() {
            return InvokeDynamicSupport.bootstrap("decodeObject", $$robo$$android_util_EventLog_Event$decodeObject(), 0, this);
        }

        public static Event fromBytes(byte[] byArray) {
            return InvokeDynamicSupport.bootstrapStatic("fromBytes", $$robo$$android_util_EventLog_Event$fromBytes(byte[] ), 0, (byte[])byArray);
        }

        public byte[] getBytes() {
            return InvokeDynamicSupport.bootstrap("getBytes", $$robo$$android_util_EventLog_Event$getBytes(), 0, this);
        }

        public /* synthetic */ Event() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Event)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

