/*
 * Decompiled with CFR 0.152.
 */
package android.util.apk;

import android.util.Pair;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class ZipUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int ZIP_EOCD_REC_MIN_SIZE = 22;
    private static int ZIP_EOCD_REC_SIG = 101010256;
    private static int ZIP_EOCD_CENTRAL_DIR_SIZE_FIELD_OFFSET = 12;
    private static int ZIP_EOCD_CENTRAL_DIR_OFFSET_FIELD_OFFSET = 16;
    private static int ZIP_EOCD_COMMENT_LENGTH_FIELD_OFFSET = 20;
    private static int ZIP64_EOCD_LOCATOR_SIZE = 20;
    private static int ZIP64_EOCD_LOCATOR_SIG_REVERSE_BYTE_ORDER = 1347094023;
    private static int UINT16_MAX_VALUE = 65535;

    private void $$robo$$android_util_apk_ZipUtils$__constructor__() {
    }

    private static final Pair<ByteBuffer, Long> $$robo$$android_util_apk_ZipUtils$findZipEndOfCentralDirectoryRecord(RandomAccessFile zip) throws IOException {
        long fileSize = zip.length();
        if (fileSize < 22L) {
            return null;
        }
        Pair<ByteBuffer, Long> result = ZipUtils.findZipEndOfCentralDirectoryRecord(zip, 0);
        if (result != null) {
            return result;
        }
        return ZipUtils.findZipEndOfCentralDirectoryRecord(zip, 65535);
    }

    private static final Pair<ByteBuffer, Long> $$robo$$android_util_apk_ZipUtils$findZipEndOfCentralDirectoryRecord(RandomAccessFile zip, int maxCommentSize) throws IOException {
        if (maxCommentSize < 0 || maxCommentSize > 65535) {
            throw new IllegalArgumentException("maxCommentSize: " + maxCommentSize);
        }
        long fileSize = zip.length();
        if (fileSize < 22L) {
            return null;
        }
        maxCommentSize = (int)Math.min((long)maxCommentSize, fileSize - 22L);
        ByteBuffer buf = ByteBuffer.allocate(22 + maxCommentSize);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        long bufOffsetInFile = fileSize - (long)buf.capacity();
        zip.seek(bufOffsetInFile);
        zip.readFully(buf.array(), buf.arrayOffset(), buf.capacity());
        int eocdOffsetInBuf = ZipUtils.findZipEndOfCentralDirectoryRecord(buf);
        if (eocdOffsetInBuf == -1) {
            return null;
        }
        buf.position(eocdOffsetInBuf);
        ByteBuffer eocd = buf.slice();
        eocd.order(ByteOrder.LITTLE_ENDIAN);
        return Pair.create(eocd, bufOffsetInFile + (long)eocdOffsetInBuf);
    }

    private static final int $$robo$$android_util_apk_ZipUtils$findZipEndOfCentralDirectoryRecord(ByteBuffer zipContents) {
        ZipUtils.assertByteOrderLittleEndian(zipContents);
        int archiveSize = zipContents.capacity();
        if (archiveSize < 22) {
            return -1;
        }
        int maxCommentLength = Math.min(archiveSize - 22, 65535);
        int eocdWithEmptyCommentStartPosition = archiveSize - 22;
        for (int expectedCommentLength = 0; expectedCommentLength < maxCommentLength; ++expectedCommentLength) {
            int actualCommentLength;
            int eocdStartPos = eocdWithEmptyCommentStartPosition - expectedCommentLength;
            if (zipContents.getInt(eocdStartPos) != 101010256 || (actualCommentLength = ZipUtils.getUnsignedInt16(zipContents, eocdStartPos + 20)) != expectedCommentLength) continue;
            return eocdStartPos;
        }
        return -1;
    }

    private static final boolean $$robo$$android_util_apk_ZipUtils$isZip64EndOfCentralDirectoryLocatorPresent(RandomAccessFile zip, long zipEndOfCentralDirectoryPosition) throws IOException {
        long locatorPosition = zipEndOfCentralDirectoryPosition - 20L;
        if (locatorPosition < 0L) {
            return false;
        }
        zip.seek(locatorPosition);
        return zip.readInt() == 1347094023;
    }

    private static final long $$robo$$android_util_apk_ZipUtils$getZipEocdCentralDirectoryOffset(ByteBuffer zipEndOfCentralDirectory) {
        ZipUtils.assertByteOrderLittleEndian(zipEndOfCentralDirectory);
        return ZipUtils.getUnsignedInt32(zipEndOfCentralDirectory, zipEndOfCentralDirectory.position() + 16);
    }

    private static final void $$robo$$android_util_apk_ZipUtils$setZipEocdCentralDirectoryOffset(ByteBuffer zipEndOfCentralDirectory, long offset) {
        ZipUtils.assertByteOrderLittleEndian(zipEndOfCentralDirectory);
        ZipUtils.setUnsignedInt32(zipEndOfCentralDirectory, zipEndOfCentralDirectory.position() + 16, offset);
    }

    private static final long $$robo$$android_util_apk_ZipUtils$getZipEocdCentralDirectorySizeBytes(ByteBuffer zipEndOfCentralDirectory) {
        ZipUtils.assertByteOrderLittleEndian(zipEndOfCentralDirectory);
        return ZipUtils.getUnsignedInt32(zipEndOfCentralDirectory, zipEndOfCentralDirectory.position() + 12);
    }

    private static final void $$robo$$android_util_apk_ZipUtils$assertByteOrderLittleEndian(ByteBuffer buffer) {
        if (buffer.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("ByteBuffer byte order must be little endian");
        }
    }

    private static final int $$robo$$android_util_apk_ZipUtils$getUnsignedInt16(ByteBuffer buffer, int offset) {
        return buffer.getShort(offset) & 0xFFFF;
    }

    private static final long $$robo$$android_util_apk_ZipUtils$getUnsignedInt32(ByteBuffer buffer, int offset) {
        return (long)buffer.getInt(offset) & 0xFFFFFFFFL;
    }

    private static final void $$robo$$android_util_apk_ZipUtils$setUnsignedInt32(ByteBuffer buffer, int offset, long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("uint32 value of out range: " + value);
        }
        buffer.putInt(buffer.position() + offset, (int)value);
    }

    private void __constructor__() {
        this.$$robo$$android_util_apk_ZipUtils$__constructor__();
    }

    private ZipUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_apk_ZipUtils$__constructor__(), 0, this);
    }

    static Pair<ByteBuffer, Long> findZipEndOfCentralDirectoryRecord(RandomAccessFile randomAccessFile) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("findZipEndOfCentralDirectoryRecord", $$robo$$android_util_apk_ZipUtils$findZipEndOfCentralDirectoryRecord(java.io.RandomAccessFile ), 0, (RandomAccessFile)randomAccessFile);
    }

    private static Pair<ByteBuffer, Long> findZipEndOfCentralDirectoryRecord(RandomAccessFile randomAccessFile, int n) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("findZipEndOfCentralDirectoryRecord", $$robo$$android_util_apk_ZipUtils$findZipEndOfCentralDirectoryRecord(java.io.RandomAccessFile int ), 0, (RandomAccessFile)randomAccessFile, (int)n);
    }

    private static int findZipEndOfCentralDirectoryRecord(ByteBuffer byteBuffer) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findZipEndOfCentralDirectoryRecord", $$robo$$android_util_apk_ZipUtils$findZipEndOfCentralDirectoryRecord(java.nio.ByteBuffer ), 0, (ByteBuffer)byteBuffer);
    }

    public static boolean isZip64EndOfCentralDirectoryLocatorPresent(RandomAccessFile randomAccessFile, long l) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isZip64EndOfCentralDirectoryLocatorPresent", $$robo$$android_util_apk_ZipUtils$isZip64EndOfCentralDirectoryLocatorPresent(java.io.RandomAccessFile long ), 0, (RandomAccessFile)randomAccessFile, (long)l);
    }

    public static long getZipEocdCentralDirectoryOffset(ByteBuffer byteBuffer) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getZipEocdCentralDirectoryOffset", $$robo$$android_util_apk_ZipUtils$getZipEocdCentralDirectoryOffset(java.nio.ByteBuffer ), 0, (ByteBuffer)byteBuffer);
    }

    public static void setZipEocdCentralDirectoryOffset(ByteBuffer byteBuffer, long l) {
        InvokeDynamicSupport.bootstrapStatic("setZipEocdCentralDirectoryOffset", $$robo$$android_util_apk_ZipUtils$setZipEocdCentralDirectoryOffset(java.nio.ByteBuffer long ), 0, (ByteBuffer)byteBuffer, (long)l);
    }

    public static long getZipEocdCentralDirectorySizeBytes(ByteBuffer byteBuffer) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getZipEocdCentralDirectorySizeBytes", $$robo$$android_util_apk_ZipUtils$getZipEocdCentralDirectorySizeBytes(java.nio.ByteBuffer ), 0, (ByteBuffer)byteBuffer);
    }

    private static void assertByteOrderLittleEndian(ByteBuffer byteBuffer) {
        InvokeDynamicSupport.bootstrapStatic("assertByteOrderLittleEndian", $$robo$$android_util_apk_ZipUtils$assertByteOrderLittleEndian(java.nio.ByteBuffer ), 0, (ByteBuffer)byteBuffer);
    }

    private static int getUnsignedInt16(ByteBuffer byteBuffer, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getUnsignedInt16", $$robo$$android_util_apk_ZipUtils$getUnsignedInt16(java.nio.ByteBuffer int ), 0, (ByteBuffer)byteBuffer, (int)n);
    }

    private static long getUnsignedInt32(ByteBuffer byteBuffer, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getUnsignedInt32", $$robo$$android_util_apk_ZipUtils$getUnsignedInt32(java.nio.ByteBuffer int ), 0, (ByteBuffer)byteBuffer, (int)n);
    }

    private static void setUnsignedInt32(ByteBuffer byteBuffer, int n, long l) {
        InvokeDynamicSupport.bootstrapStatic("setUnsignedInt32", $$robo$$android_util_apk_ZipUtils$setUnsignedInt32(java.nio.ByteBuffer int long ), 0, (ByteBuffer)byteBuffer, (int)n, (long)l);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZipUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

