/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.hardware.display.DisplayManagerGlobal;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.util.Log;
import android.util.TimeUtils;
import android.view.DisplayEventReceiver;
import android.view.DisplayInfo;
import android.view.FrameInfo;
import com.google.errorprone.annotations.DoNotMock;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class Choreographer
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Choreographer";
    private static boolean DEBUG_JANK = false;
    private static boolean DEBUG_FRAMES = false;
    private static long DEFAULT_FRAME_DELAY = 10L;
    private static volatile long sFrameDelay;
    private static ThreadLocal<Choreographer> sThreadInstance;
    private static boolean USE_VSYNC;
    private static boolean USE_FRAME_TIME;
    private static int SKIPPED_FRAME_WARNING_LIMIT;
    private static int MSG_DO_FRAME = 0;
    private static int MSG_DO_SCHEDULE_VSYNC = 1;
    private static int MSG_DO_SCHEDULE_CALLBACK = 2;
    private static Object FRAME_CALLBACK_TOKEN;
    private Object mLock;
    private Looper mLooper;
    private FrameHandler mHandler;
    private FrameDisplayEventReceiver mDisplayEventReceiver;
    private CallbackRecord mCallbackPool;
    private CallbackQueue[] mCallbackQueues;
    private boolean mFrameScheduled;
    private boolean mCallbacksRunning;
    private long mLastFrameTimeNanos;
    private long mFrameIntervalNanos;
    private boolean mDebugPrintNextFrameTimeDelta;
    FrameInfo mFrameInfo;
    private static String[] CALLBACK_TRACE_TITLES;
    public static int CALLBACK_INPUT = 0;
    public static int CALLBACK_ANIMATION = 1;
    public static int CALLBACK_TRAVERSAL = 2;
    public static int CALLBACK_COMMIT = 3;
    private static int CALLBACK_LAST = 3;

    private void $$robo$$android_view_Choreographer$__constructor__(Looper looper) {
        this.mLock = new Object();
        this.mFrameInfo = new FrameInfo();
        this.mLooper = looper;
        this.mHandler = new FrameHandler(this, looper);
        this.mDisplayEventReceiver = USE_VSYNC ? new FrameDisplayEventReceiver(this, looper) : null;
        this.mLastFrameTimeNanos = Long.MIN_VALUE;
        this.mFrameIntervalNanos = (long)(1.0E9f / Choreographer.getRefreshRate());
        this.mCallbackQueues = new CallbackQueue[4];
        for (int i = 0; i <= 3; ++i) {
            this.mCallbackQueues[i] = new CallbackQueue(this);
        }
    }

    private static final float $$robo$$android_view_Choreographer$getRefreshRate() {
        DisplayInfo di = DisplayManagerGlobal.getInstance().getDisplayInfo(0);
        return di.getMode().getRefreshRate();
    }

    private static final Choreographer $$robo$$android_view_Choreographer$getInstance() {
        return sThreadInstance.get();
    }

    private static final void $$robo$$android_view_Choreographer$releaseInstance() {
        Choreographer old = sThreadInstance.get();
        sThreadInstance.remove();
        old.dispose();
    }

    private final void $$robo$$android_view_Choreographer$dispose() {
        this.mDisplayEventReceiver.dispose();
    }

    private static final long $$robo$$android_view_Choreographer$getFrameDelay() {
        return sFrameDelay;
    }

    private static final void $$robo$$android_view_Choreographer$setFrameDelay(long frameDelay) {
        sFrameDelay = frameDelay;
    }

    private static final long $$robo$$android_view_Choreographer$subtractFrameDelay(long delayMillis) {
        long frameDelay = sFrameDelay;
        return delayMillis <= frameDelay ? 0L : delayMillis - frameDelay;
    }

    private final long $$robo$$android_view_Choreographer$getFrameIntervalNanos() {
        return this.mFrameIntervalNanos;
    }

    private final void $$robo$$android_view_Choreographer$dump(String prefix, PrintWriter writer) {
        String innerPrefix = prefix + "  ";
        writer.print(prefix);
        writer.println("Choreographer:");
        writer.print(innerPrefix);
        writer.print("mFrameScheduled=");
        writer.println(this.mFrameScheduled);
        writer.print(innerPrefix);
        writer.print("mLastFrameTime=");
        writer.println(TimeUtils.formatUptime(this.mLastFrameTimeNanos / 1000000L));
    }

    private final void $$robo$$android_view_Choreographer$postCallback(int callbackType, Runnable action, Object token) {
        this.postCallbackDelayed(callbackType, action, token, 0L);
    }

    private final void $$robo$$android_view_Choreographer$postCallbackDelayed(int callbackType, Runnable action, Object token, long delayMillis) {
        if (action == null) {
            throw new IllegalArgumentException("action must not be null");
        }
        if (callbackType < 0 || callbackType > 3) {
            throw new IllegalArgumentException("callbackType is invalid");
        }
        this.postCallbackDelayedInternal(callbackType, action, token, delayMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_Choreographer$postCallbackDelayedInternal(int callbackType, Object action, Object token, long delayMillis) {
        Object object = this.mLock;
        synchronized (object) {
            long now = SystemClock.uptimeMillis();
            long dueTime = now + delayMillis;
            this.mCallbackQueues[callbackType].addCallbackLocked(dueTime, action, token);
            if (dueTime <= now) {
                this.scheduleFrameLocked(now);
            } else {
                Message msg = this.mHandler.obtainMessage(2, action);
                msg.arg1 = callbackType;
                msg.setAsynchronous(true);
                this.mHandler.sendMessageAtTime(msg, dueTime);
            }
        }
    }

    private final void $$robo$$android_view_Choreographer$removeCallbacks(int callbackType, Runnable action, Object token) {
        if (callbackType < 0 || callbackType > 3) {
            throw new IllegalArgumentException("callbackType is invalid");
        }
        this.removeCallbacksInternal(callbackType, action, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_Choreographer$removeCallbacksInternal(int callbackType, Object action, Object token) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbackQueues[callbackType].removeCallbacksLocked(action, token);
            if (action != null && token == null) {
                this.mHandler.removeMessages(2, action);
            }
        }
    }

    private final void $$robo$$android_view_Choreographer$postFrameCallback(FrameCallback callback) {
        this.postFrameCallbackDelayed(callback, 0L);
    }

    private final void $$robo$$android_view_Choreographer$postFrameCallbackDelayed(FrameCallback callback, long delayMillis) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        this.postCallbackDelayedInternal(1, callback, FRAME_CALLBACK_TOKEN, delayMillis);
    }

    private final void $$robo$$android_view_Choreographer$removeFrameCallback(FrameCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        this.removeCallbacksInternal(1, callback, FRAME_CALLBACK_TOKEN);
    }

    private final long $$robo$$android_view_Choreographer$getFrameTime() {
        return this.getFrameTimeNanos() / 1000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_view_Choreographer$getFrameTimeNanos() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mCallbacksRunning) {
                throw new IllegalStateException("This method must only be called as part of a callback while a frame is in progress.");
            }
            return (long)(USE_FRAME_TIME ? (Object)this.mLastFrameTimeNanos : InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System"));
        }
    }

    private final void $$robo$$android_view_Choreographer$scheduleFrameLocked(long now) {
        if (!this.mFrameScheduled) {
            this.mFrameScheduled = true;
            if (USE_VSYNC) {
                if (this.isRunningOnLooperThreadLocked()) {
                    this.scheduleVsyncLocked();
                } else {
                    Message msg = this.mHandler.obtainMessage(1);
                    msg.setAsynchronous(true);
                    this.mHandler.sendMessageAtFrontOfQueue(msg);
                }
            } else {
                long nextFrameTime = Math.max(this.mLastFrameTimeNanos / 1000000L + sFrameDelay, now);
                Message msg = this.mHandler.obtainMessage(0);
                msg.setAsynchronous(true);
                this.mHandler.sendMessageAtTime(msg, nextFrameTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_Choreographer$doFrame(long frameTimeNanos, int frame) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mFrameScheduled) {
                return;
            }
            reference intendedFrameTimeNanos = frameTimeNanos;
            CallSite startNanos = InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System");
            reference var9_6 = startNanos - frameTimeNanos;
            if (var9_6 >= this.mFrameIntervalNanos) {
                reference var11_7 = var9_6 / this.mFrameIntervalNanos;
                if (var11_7 >= (long)SKIPPED_FRAME_WARNING_LIMIT) {
                    Log.i("Choreographer", "Skipped " + (long)var11_7 + " frames!  The application may be doing too much work on its main thread.");
                }
                reference var13_8 = var9_6 % this.mFrameIntervalNanos;
                frameTimeNanos = startNanos - var13_8;
            }
            if (frameTimeNanos < this.mLastFrameTimeNanos) {
                this.scheduleVsyncLocked();
                return;
            }
            this.mFrameInfo.setVsync((long)intendedFrameTimeNanos, (long)frameTimeNanos);
            this.mFrameScheduled = false;
            this.mLastFrameTimeNanos = (long)frameTimeNanos;
        }
        try {
            Trace.traceBegin(8L, "Choreographer#doFrame");
            this.mFrameInfo.markInputHandlingStart();
            this.doCallbacks(0, (long)frameTimeNanos);
            this.mFrameInfo.markAnimationsStart();
            this.doCallbacks(1, (long)frameTimeNanos);
            this.mFrameInfo.markPerformTraversalsStart();
            this.doCallbacks(2, (long)frameTimeNanos);
            this.doCallbacks(3, (long)frameTimeNanos);
        }
        finally {
            Trace.traceEnd(8L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_Choreographer$doCallbacks(int callbackType, long frameTimeNanos) {
        CallbackRecord callbacks;
        Object object = this.mLock;
        synchronized (object) {
            CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System");
            callbacks = this.mCallbackQueues[callbackType].extractDueCallbacksLocked((long)(now / 1000000L));
            if (callbacks == null) {
                return;
            }
            this.mCallbacksRunning = true;
            if (callbackType == 3) {
                reference var8_7 = now - frameTimeNanos;
                Trace.traceCounter(8L, "jitterNanos", (int)var8_7);
                if (var8_7 >= 2L * this.mFrameIntervalNanos) {
                    reference var10_8 = var8_7 % this.mFrameIntervalNanos + this.mFrameIntervalNanos;
                    frameTimeNanos = now - var10_8;
                    this.mLastFrameTimeNanos = (long)frameTimeNanos;
                }
            }
        }
        try {
            Trace.traceBegin(8L, CALLBACK_TRACE_TITLES[callbackType]);
            CallbackRecord c = callbacks;
            while (c != null) {
                c.run((long)frameTimeNanos);
                c = c.next;
            }
        }
        finally {
            object = this.mLock;
            synchronized (object) {
                CallbackRecord next;
                this.mCallbacksRunning = false;
                do {
                    next = callbacks.next;
                    this.recycleCallbackLocked(callbacks);
                } while ((callbacks = next) != null);
            }
            Trace.traceEnd(8L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_Choreographer$doScheduleVsync() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mFrameScheduled) {
                this.scheduleVsyncLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_Choreographer$doScheduleCallback(int callbackType) {
        Object object = this.mLock;
        synchronized (object) {
            long now;
            if (!this.mFrameScheduled && this.mCallbackQueues[callbackType].hasDueCallbacksLocked(now = SystemClock.uptimeMillis())) {
                this.scheduleFrameLocked(now);
            }
        }
    }

    private final void $$robo$$android_view_Choreographer$scheduleVsyncLocked() {
        this.mDisplayEventReceiver.scheduleVsync();
    }

    private final boolean $$robo$$android_view_Choreographer$isRunningOnLooperThreadLocked() {
        return Looper.myLooper() == this.mLooper;
    }

    private final CallbackRecord $$robo$$android_view_Choreographer$obtainCallbackLocked(long dueTime, Object action, Object token) {
        CallbackRecord callback = this.mCallbackPool;
        if (callback == null) {
            callback = new CallbackRecord();
        } else {
            this.mCallbackPool = callback.next;
            callback.next = null;
        }
        callback.dueTime = dueTime;
        callback.action = action;
        callback.token = token;
        return callback;
    }

    private final void $$robo$$android_view_Choreographer$recycleCallbackLocked(CallbackRecord callback) {
        callback.action = null;
        callback.token = null;
        callback.next = this.mCallbackPool;
        this.mCallbackPool = callback;
    }

    private /* synthetic */ void $$robo$$android_view_Choreographer$__constructor__(Looper x0, 1 x1) {
    }

    static void __staticInitializer__() {
        sFrameDelay = 10L;
        sThreadInstance = new ThreadLocal<Choreographer>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_Choreographer_1$__constructor__() {
            }

            private final Choreographer $$robo$$android_view_Choreographer_1$initialValue() {
                Looper looper = Looper.myLooper();
                if (looper == null) {
                    throw new IllegalStateException("The current thread must have a looper!");
                }
                return new Choreographer(looper);
            }

            private void __constructor__() {
                this.$$robo$$android_view_Choreographer_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_Choreographer_1$__constructor__(), 0, this);
            }

            @Override
            protected Choreographer initialValue() {
                return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$android_view_Choreographer_1$initialValue(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        USE_VSYNC = SystemProperties.getBoolean("debug.choreographer.vsync", true);
        USE_FRAME_TIME = SystemProperties.getBoolean("debug.choreographer.frametime", true);
        SKIPPED_FRAME_WARNING_LIMIT = SystemProperties.getInt("debug.choreographer.skipwarning", 30);
        FRAME_CALLBACK_TOKEN = new ShadowedObject(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_Choreographer_2$__constructor__() {
            }

            private final String $$robo$$android_view_Choreographer_2$toString() {
                return "FRAME_CALLBACK_TOKEN";
            }

            private void __constructor__() {
                this.$$robo$$android_view_Choreographer_2$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_Choreographer_2$__constructor__(), 0, this);
            }

            public String toString() {
                return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_Choreographer_2$toString(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        CALLBACK_TRACE_TITLES = new String[]{"input", "animation", "traversal", "commit"};
    }

    private void __constructor__(Looper looper) {
        this.$$robo$$android_view_Choreographer$__constructor__(looper);
    }

    private Choreographer(Looper looper) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_Choreographer$__constructor__(android.os.Looper ), 0, this, looper);
    }

    private static float getRefreshRate() {
        return (float)InvokeDynamicSupport.bootstrapStatic("getRefreshRate", $$robo$$android_view_Choreographer$getRefreshRate(), 0);
    }

    public static Choreographer getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_view_Choreographer$getInstance(), 0);
    }

    public static void releaseInstance() {
        InvokeDynamicSupport.bootstrapStatic("releaseInstance", $$robo$$android_view_Choreographer$releaseInstance(), 0);
    }

    private void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$android_view_Choreographer$dispose(), 0, this);
    }

    public static long getFrameDelay() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getFrameDelay", $$robo$$android_view_Choreographer$getFrameDelay(), 0);
    }

    public static void setFrameDelay(long l) {
        InvokeDynamicSupport.bootstrapStatic("setFrameDelay", $$robo$$android_view_Choreographer$setFrameDelay(long ), 0, (long)l);
    }

    public static long subtractFrameDelay(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("subtractFrameDelay", $$robo$$android_view_Choreographer$subtractFrameDelay(long ), 0, (long)l);
    }

    public long getFrameIntervalNanos() {
        return (long)InvokeDynamicSupport.bootstrap("getFrameIntervalNanos", $$robo$$android_view_Choreographer$getFrameIntervalNanos(), 0, this);
    }

    void dump(String string2, PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_view_Choreographer$dump(java.lang.String java.io.PrintWriter ), 0, this, string2, printWriter);
    }

    public void postCallback(int n, Runnable runnable, Object object) {
        InvokeDynamicSupport.bootstrap("postCallback", $$robo$$android_view_Choreographer$postCallback(int java.lang.Runnable java.lang.Object ), 0, this, n, runnable, object);
    }

    public void postCallbackDelayed(int n, Runnable runnable, Object object, long l) {
        InvokeDynamicSupport.bootstrap("postCallbackDelayed", $$robo$$android_view_Choreographer$postCallbackDelayed(int java.lang.Runnable java.lang.Object long ), 0, this, n, runnable, object, l);
    }

    private void postCallbackDelayedInternal(int n, Object object, Object object2, long l) {
        InvokeDynamicSupport.bootstrap("postCallbackDelayedInternal", $$robo$$android_view_Choreographer$postCallbackDelayedInternal(int java.lang.Object java.lang.Object long ), 0, this, n, object, object2, l);
    }

    public void removeCallbacks(int n, Runnable runnable, Object object) {
        InvokeDynamicSupport.bootstrap("removeCallbacks", $$robo$$android_view_Choreographer$removeCallbacks(int java.lang.Runnable java.lang.Object ), 0, this, n, runnable, object);
    }

    private void removeCallbacksInternal(int n, Object object, Object object2) {
        InvokeDynamicSupport.bootstrap("removeCallbacksInternal", $$robo$$android_view_Choreographer$removeCallbacksInternal(int java.lang.Object java.lang.Object ), 0, this, n, object, object2);
    }

    public void postFrameCallback(FrameCallback frameCallback) {
        InvokeDynamicSupport.bootstrap("postFrameCallback", $$robo$$android_view_Choreographer$postFrameCallback(android.view.Choreographer$FrameCallback ), 0, this, frameCallback);
    }

    public void postFrameCallbackDelayed(FrameCallback frameCallback, long l) {
        InvokeDynamicSupport.bootstrap("postFrameCallbackDelayed", $$robo$$android_view_Choreographer$postFrameCallbackDelayed(android.view.Choreographer$FrameCallback long ), 0, this, frameCallback, l);
    }

    public void removeFrameCallback(FrameCallback frameCallback) {
        InvokeDynamicSupport.bootstrap("removeFrameCallback", $$robo$$android_view_Choreographer$removeFrameCallback(android.view.Choreographer$FrameCallback ), 0, this, frameCallback);
    }

    public long getFrameTime() {
        return (long)InvokeDynamicSupport.bootstrap("getFrameTime", $$robo$$android_view_Choreographer$getFrameTime(), 0, this);
    }

    public long getFrameTimeNanos() {
        return (long)InvokeDynamicSupport.bootstrap("getFrameTimeNanos", $$robo$$android_view_Choreographer$getFrameTimeNanos(), 0, this);
    }

    private void scheduleFrameLocked(long l) {
        InvokeDynamicSupport.bootstrap("scheduleFrameLocked", $$robo$$android_view_Choreographer$scheduleFrameLocked(long ), 0, this, l);
    }

    void doFrame(long l, int n) {
        InvokeDynamicSupport.bootstrap("doFrame", $$robo$$android_view_Choreographer$doFrame(long int ), 0, this, l, n);
    }

    void doCallbacks(int n, long l) {
        InvokeDynamicSupport.bootstrap("doCallbacks", $$robo$$android_view_Choreographer$doCallbacks(int long ), 0, this, n, l);
    }

    void doScheduleVsync() {
        InvokeDynamicSupport.bootstrap("doScheduleVsync", $$robo$$android_view_Choreographer$doScheduleVsync(), 0, this);
    }

    void doScheduleCallback(int n) {
        InvokeDynamicSupport.bootstrap("doScheduleCallback", $$robo$$android_view_Choreographer$doScheduleCallback(int ), 0, this, n);
    }

    private void scheduleVsyncLocked() {
        InvokeDynamicSupport.bootstrap("scheduleVsyncLocked", $$robo$$android_view_Choreographer$scheduleVsyncLocked(), 0, this);
    }

    private boolean isRunningOnLooperThreadLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRunningOnLooperThreadLocked", $$robo$$android_view_Choreographer$isRunningOnLooperThreadLocked(), 0, this);
    }

    private CallbackRecord obtainCallbackLocked(long l, Object object, Object object2) {
        return InvokeDynamicSupport.bootstrap("obtainCallbackLocked", $$robo$$android_view_Choreographer$obtainCallbackLocked(long java.lang.Object java.lang.Object ), 0, this, l, object, object2);
    }

    private void recycleCallbackLocked(CallbackRecord callbackRecord) {
        InvokeDynamicSupport.bootstrap("recycleCallbackLocked", $$robo$$android_view_Choreographer$recycleCallbackLocked(android.view.Choreographer$CallbackRecord ), 0, this, callbackRecord);
    }

    private /* synthetic */ void __constructor__(Looper looper, 1 var2_2) {
        this.$$robo$$android_view_Choreographer$__constructor__(looper, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(Choreographer.class);
    }

    public /* synthetic */ Choreographer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Choreographer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class CallbackQueue
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private CallbackRecord mHead;
        /* synthetic */ Choreographer this$0;

        private void $$robo$$android_view_Choreographer_CallbackQueue$__constructor__(Choreographer choreographer) {
        }

        private final boolean $$robo$$android_view_Choreographer_CallbackQueue$hasDueCallbacksLocked(long now) {
            return this.mHead != null && this.mHead.dueTime <= now;
        }

        private final CallbackRecord $$robo$$android_view_Choreographer_CallbackQueue$extractDueCallbacksLocked(long now) {
            CallbackRecord callbacks = this.mHead;
            if (callbacks == null || callbacks.dueTime > now) {
                return null;
            }
            CallbackRecord last = callbacks;
            CallbackRecord next = last.next;
            while (next != null) {
                if (next.dueTime > now) {
                    last.next = null;
                    break;
                }
                last = next;
                next = next.next;
            }
            this.mHead = next;
            return callbacks;
        }

        private final void $$robo$$android_view_Choreographer_CallbackQueue$addCallbackLocked(long dueTime, Object action, Object token) {
            CallbackRecord callback = this.this$0.obtainCallbackLocked(dueTime, action, token);
            CallbackRecord entry = this.mHead;
            if (entry == null) {
                this.mHead = callback;
                return;
            }
            if (dueTime < entry.dueTime) {
                callback.next = entry;
                this.mHead = callback;
                return;
            }
            while (entry.next != null) {
                if (dueTime < entry.next.dueTime) {
                    callback.next = entry.next;
                    break;
                }
                entry = entry.next;
            }
            entry.next = callback;
        }

        private final void $$robo$$android_view_Choreographer_CallbackQueue$removeCallbacksLocked(Object action, Object token) {
            CallbackRecord predecessor = null;
            CallbackRecord callback = this.mHead;
            while (callback != null) {
                CallbackRecord next = callback.next;
                if (!(action != null && callback.action != action || token != null && callback.token != token)) {
                    if (predecessor != null) {
                        predecessor.next = next;
                    } else {
                        this.mHead = next;
                    }
                    this.this$0.recycleCallbackLocked(callback);
                } else {
                    predecessor = callback;
                }
                callback = next;
            }
        }

        private /* synthetic */ void $$robo$$android_view_Choreographer_CallbackQueue$__constructor__(Choreographer x0, 1 x1) {
        }

        private void __constructor__(Choreographer choreographer) {
            this.$$robo$$android_view_Choreographer_CallbackQueue$__constructor__(choreographer);
        }

        private CallbackQueue(Choreographer choreographer) {
            this.this$0 = choreographer;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_Choreographer_CallbackQueue$__constructor__(android.view.Choreographer ), 0, this, choreographer);
        }

        public boolean hasDueCallbacksLocked(long l) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasDueCallbacksLocked", $$robo$$android_view_Choreographer_CallbackQueue$hasDueCallbacksLocked(long ), 0, this, l);
        }

        public CallbackRecord extractDueCallbacksLocked(long l) {
            return InvokeDynamicSupport.bootstrap("extractDueCallbacksLocked", $$robo$$android_view_Choreographer_CallbackQueue$extractDueCallbacksLocked(long ), 0, this, l);
        }

        public void addCallbackLocked(long l, Object object, Object object2) {
            InvokeDynamicSupport.bootstrap("addCallbackLocked", $$robo$$android_view_Choreographer_CallbackQueue$addCallbackLocked(long java.lang.Object java.lang.Object ), 0, this, l, object, object2);
        }

        public void removeCallbacksLocked(Object object, Object object2) {
            InvokeDynamicSupport.bootstrap("removeCallbacksLocked", $$robo$$android_view_Choreographer_CallbackQueue$removeCallbacksLocked(java.lang.Object java.lang.Object ), 0, this, object, object2);
        }

        private /* synthetic */ void __constructor__(Choreographer choreographer, 1 var2_2) {
            this.$$robo$$android_view_Choreographer_CallbackQueue$__constructor__(choreographer, var2_2);
        }

        public /* synthetic */ CallbackQueue() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackQueue)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class CallbackRecord
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public CallbackRecord next;
        public long dueTime;
        public Object action;
        public Object token;

        private void $$robo$$android_view_Choreographer_CallbackRecord$__constructor__() {
        }

        private final void $$robo$$android_view_Choreographer_CallbackRecord$run(long frameTimeNanos) {
            if (this.token == FRAME_CALLBACK_TOKEN) {
                ((FrameCallback)this.action).doFrame(frameTimeNanos);
            } else {
                ((Runnable)this.action).run();
            }
        }

        private /* synthetic */ void $$robo$$android_view_Choreographer_CallbackRecord$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_view_Choreographer_CallbackRecord$__constructor__();
        }

        private CallbackRecord() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_Choreographer_CallbackRecord$__constructor__(), 0, this);
        }

        public void run(long l) {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_view_Choreographer_CallbackRecord$run(long ), 0, this, l);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_view_Choreographer_CallbackRecord$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackRecord)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class FrameDisplayEventReceiver
    extends DisplayEventReceiver
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private boolean mHavePendingVsync;
        private long mTimestampNanos;
        private int mFrame;
        /* synthetic */ Choreographer this$0;

        private void $$robo$$android_view_Choreographer_FrameDisplayEventReceiver$__constructor__(Choreographer choreographer, Looper looper) {
        }

        private final void $$robo$$android_view_Choreographer_FrameDisplayEventReceiver$onVsync(long timestampNanos, int builtInDisplayId, int frame) {
            if (builtInDisplayId != 0) {
                Log.d("Choreographer", "Received vsync from secondary display, but we don't support this case yet.  Choreographer needs a way to explicitly request vsync for a specific display to ensure it doesn't lose track of its scheduled vsync.");
                this.scheduleVsync();
                return;
            }
            CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System");
            if (timestampNanos > now) {
                Log.w("Choreographer", "Frame time is " + (float)(timestampNanos - now) * 1.0E-6f + " ms in the future!  Check that graphics HAL is generating vsync timestamps using the correct timebase.");
                timestampNanos = now;
            }
            if (this.mHavePendingVsync) {
                Log.w("Choreographer", "Already have a pending vsync event.  There should only be one at a time.");
            } else {
                this.mHavePendingVsync = true;
            }
            this.mTimestampNanos = timestampNanos;
            this.mFrame = frame;
            Message msg = Message.obtain((Handler)this.this$0.mHandler, this);
            msg.setAsynchronous(true);
            this.this$0.mHandler.sendMessageAtTime(msg, timestampNanos / 1000000L);
        }

        private final void $$robo$$android_view_Choreographer_FrameDisplayEventReceiver$run() {
            this.mHavePendingVsync = false;
            this.this$0.doFrame(this.mTimestampNanos, this.mFrame);
        }

        private void __constructor__(Choreographer choreographer, Looper looper) {
            this.$$robo$$android_view_Choreographer_FrameDisplayEventReceiver$__constructor__(choreographer, looper);
        }

        public FrameDisplayEventReceiver(Choreographer choreographer, Looper looper) {
            this.this$0 = choreographer;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_Choreographer_FrameDisplayEventReceiver$__constructor__(android.view.Choreographer android.os.Looper ), 0, this, choreographer, looper);
        }

        @Override
        public void onVsync(long l, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onVsync", $$robo$$android_view_Choreographer_FrameDisplayEventReceiver$onVsync(long int int ), 0, this, l, n, n2);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_view_Choreographer_FrameDisplayEventReceiver$run(), 0, this);
        }

        public /* synthetic */ FrameDisplayEventReceiver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FrameDisplayEventReceiver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class FrameHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ Choreographer this$0;

        private void $$robo$$android_view_Choreographer_FrameHandler$__constructor__(Choreographer choreographer, Looper looper) {
        }

        private final void $$robo$$android_view_Choreographer_FrameHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    this.this$0.doFrame((long)InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System"), 0);
                    break;
                }
                case 1: {
                    this.this$0.doScheduleVsync();
                    break;
                }
                case 2: {
                    this.this$0.doScheduleCallback(msg.arg1);
                }
            }
        }

        private void __constructor__(Choreographer choreographer, Looper looper) {
            this.$$robo$$android_view_Choreographer_FrameHandler$__constructor__(choreographer, looper);
        }

        public FrameHandler(Choreographer choreographer, Looper looper) {
            this.this$0 = choreographer;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_Choreographer_FrameHandler$__constructor__(android.view.Choreographer android.os.Looper ), 0, this, choreographer, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_view_Choreographer_FrameHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ FrameHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FrameHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface FrameCallback
    extends InstrumentedInterface {
        public void doFrame(long var1);
    }
}

