/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.PixelFormat;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Display;
import android.view.IWindowSession;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.android.internal.view.BaseIWindow;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SurfaceView
extends View
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SurfaceView";
    private static boolean DEBUG = false;
    ArrayList<SurfaceHolder.Callback> mCallbacks;
    int[] mLocation;
    ReentrantLock mSurfaceLock;
    Surface mSurface;
    Surface mNewSurface;
    boolean mDrawingStopped;
    WindowManager.LayoutParams mLayout;
    IWindowSession mSession;
    MyWindow mWindow;
    Rect mVisibleInsets;
    Rect mWinFrame;
    Rect mOverscanInsets;
    Rect mContentInsets;
    Rect mStableInsets;
    Rect mOutsets;
    Rect mBackdropFrame;
    Configuration mConfiguration;
    static int KEEP_SCREEN_ON_MSG = 1;
    static int GET_NEW_SURFACE_MSG = 2;
    static int UPDATE_WINDOW_MSG = 3;
    int mWindowType;
    boolean mIsCreating;
    private volatile boolean mRtHandlingPositionUpdates;
    Handler mHandler;
    private ViewTreeObserver.OnScrollChangedListener mScrollChangedListener;
    private ViewTreeObserver.OnPreDrawListener mDrawListener;
    boolean mRequestedVisible;
    boolean mWindowVisibility;
    boolean mViewVisibility;
    int mRequestedWidth;
    int mRequestedHeight;
    int mRequestedFormat;
    boolean mHaveFrame;
    boolean mSurfaceCreated;
    long mLastLockTime;
    boolean mVisible;
    int mWindowSpaceLeft;
    int mWindowSpaceTop;
    int mWindowSpaceWidth;
    int mWindowSpaceHeight;
    int mFormat;
    Rect mSurfaceFrame;
    int mLastSurfaceWidth;
    int mLastSurfaceHeight;
    boolean mUpdateWindowNeeded;
    boolean mReportDrawNeeded;
    private CompatibilityInfo.Translator mTranslator;
    private int mWindowInsetLeft;
    private int mWindowInsetTop;
    private boolean mGlobalListenersAdded;
    private Rect mRTLastReportedPosition;
    private SurfaceHolder mSurfaceHolder;

    private void $$robo$$android_view_SurfaceView$__constructor__(Context context) {
        this.mCallbacks = new ArrayList();
        this.mLocation = new int[2];
        this.mSurfaceLock = new ReentrantLock();
        this.mSurface = new Surface();
        this.mNewSurface = new Surface();
        this.mDrawingStopped = true;
        this.mLayout = new WindowManager.LayoutParams();
        this.mVisibleInsets = new Rect();
        this.mWinFrame = new Rect();
        this.mOverscanInsets = new Rect();
        this.mContentInsets = new Rect();
        this.mStableInsets = new Rect();
        this.mOutsets = new Rect();
        this.mBackdropFrame = new Rect();
        this.mConfiguration = new Configuration();
        this.mWindowType = 1001;
        this.mIsCreating = false;
        this.mRtHandlingPositionUpdates = false;
        this.mHandler = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SurfaceView this$0;

            private void $$robo$$android_view_SurfaceView_1$__constructor__(SurfaceView this$0) {
            }

            private final void $$robo$$android_view_SurfaceView_1$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        this.this$0.setKeepScreenOn(msg.arg1 != 0);
                        break;
                    }
                    case 2: {
                        this.this$0.handleGetNewSurface();
                        break;
                    }
                    case 3: {
                        this.this$0.updateWindow(false, false);
                    }
                }
            }

            private void __constructor__(SurfaceView surfaceView) {
                this.$$robo$$android_view_SurfaceView_1$__constructor__(surfaceView);
            }
            {
                this.this$0 = surfaceView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_SurfaceView_1$__constructor__(android.view.SurfaceView ), 0, this, surfaceView);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_view_SurfaceView_1$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mScrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SurfaceView this$0;

            private void $$robo$$android_view_SurfaceView_2$__constructor__(SurfaceView this$0) {
            }

            private final void $$robo$$android_view_SurfaceView_2$onScrollChanged() {
                this.this$0.updateWindow(false, false);
            }

            private void __constructor__(SurfaceView surfaceView) {
                this.$$robo$$android_view_SurfaceView_2$__constructor__(surfaceView);
            }
            {
                this.this$0 = surfaceView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_SurfaceView_2$__constructor__(android.view.SurfaceView ), 0, this, surfaceView);
            }

            @Override
            public void onScrollChanged() {
                InvokeDynamicSupport.bootstrap("onScrollChanged", $$robo$$android_view_SurfaceView_2$onScrollChanged(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mDrawListener = new ViewTreeObserver.OnPreDrawListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SurfaceView this$0;

            private void $$robo$$android_view_SurfaceView_3$__constructor__(SurfaceView this$0) {
            }

            private final boolean $$robo$$android_view_SurfaceView_3$onPreDraw() {
                this.this$0.mHaveFrame = this.this$0.getWidth() > 0 && this.this$0.getHeight() > 0;
                this.this$0.updateWindow(false, false);
                return true;
            }

            private void __constructor__(SurfaceView surfaceView) {
                this.$$robo$$android_view_SurfaceView_3$__constructor__(surfaceView);
            }
            {
                this.this$0 = surfaceView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_SurfaceView_3$__constructor__(android.view.SurfaceView ), 0, this, surfaceView);
            }

            @Override
            public boolean onPreDraw() {
                return (boolean)InvokeDynamicSupport.bootstrap("onPreDraw", $$robo$$android_view_SurfaceView_3$onPreDraw(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mRequestedVisible = false;
        this.mWindowVisibility = false;
        this.mViewVisibility = false;
        this.mRequestedWidth = -1;
        this.mRequestedHeight = -1;
        this.mRequestedFormat = 4;
        this.mHaveFrame = false;
        this.mSurfaceCreated = false;
        this.mLastLockTime = 0L;
        this.mVisible = false;
        this.mWindowSpaceLeft = -1;
        this.mWindowSpaceTop = -1;
        this.mWindowSpaceWidth = -1;
        this.mWindowSpaceHeight = -1;
        this.mFormat = -1;
        this.mSurfaceFrame = new Rect();
        this.mLastSurfaceWidth = -1;
        this.mLastSurfaceHeight = -1;
        this.mRTLastReportedPosition = new Rect();
        this.mSurfaceHolder = new SurfaceHolder(this){
            public transient /* synthetic */ Object __robo_data__;
            private static String LOG_TAG = "SurfaceHolder";
            /* synthetic */ SurfaceView this$0;

            private void $$robo$$android_view_SurfaceView_4$__constructor__(SurfaceView this$0) {
            }

            private final boolean $$robo$$android_view_SurfaceView_4$isCreating() {
                return this.this$0.mIsCreating;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_view_SurfaceView_4$addCallback(SurfaceHolder.Callback callback) {
                ArrayList<SurfaceHolder.Callback> arrayList = this.this$0.mCallbacks;
                synchronized (arrayList) {
                    if (!this.this$0.mCallbacks.contains(callback)) {
                        this.this$0.mCallbacks.add(callback);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_view_SurfaceView_4$removeCallback(SurfaceHolder.Callback callback) {
                ArrayList<SurfaceHolder.Callback> arrayList = this.this$0.mCallbacks;
                synchronized (arrayList) {
                    this.this$0.mCallbacks.remove(callback);
                }
            }

            private final void $$robo$$android_view_SurfaceView_4$setFixedSize(int width, int height) {
                if (this.this$0.mRequestedWidth != width || this.this$0.mRequestedHeight != height) {
                    this.this$0.mRequestedWidth = width;
                    this.this$0.mRequestedHeight = height;
                    this.this$0.requestLayout();
                }
            }

            private final void $$robo$$android_view_SurfaceView_4$setSizeFromLayout() {
                if (this.this$0.mRequestedWidth != -1 || this.this$0.mRequestedHeight != -1) {
                    this.this$0.mRequestedHeight = -1;
                    this.this$0.mRequestedWidth = -1;
                    this.this$0.requestLayout();
                }
            }

            private final void $$robo$$android_view_SurfaceView_4$setFormat(int format) {
                if (format == -1) {
                    format = 4;
                }
                this.this$0.mRequestedFormat = format;
                if (this.this$0.mWindow != null) {
                    this.this$0.updateWindow(false, false);
                }
            }

            @Deprecated
            private final void $$robo$$android_view_SurfaceView_4$setType(int type) {
            }

            private final void $$robo$$android_view_SurfaceView_4$setKeepScreenOn(boolean screenOn) {
                Message msg = this.this$0.mHandler.obtainMessage(1);
                msg.arg1 = screenOn ? 1 : 0;
                this.this$0.mHandler.sendMessage(msg);
            }

            private final Canvas $$robo$$android_view_SurfaceView_4$lockCanvas() {
                return this.internalLockCanvas(null);
            }

            private final Canvas $$robo$$android_view_SurfaceView_4$lockCanvas(Rect inOutDirty) {
                return this.internalLockCanvas(inOutDirty);
            }

            private final Canvas $$robo$$android_view_SurfaceView_4$internalLockCanvas(Rect dirty) {
                this.this$0.mSurfaceLock.lock();
                Canvas c = null;
                if (!this.this$0.mDrawingStopped && this.this$0.mWindow != null) {
                    try {
                        c = this.this$0.mSurface.lockCanvas(dirty);
                    }
                    catch (Exception e) {
                        Log.e("SurfaceHolder", "Exception locking surface", e);
                    }
                }
                if (c != null) {
                    this.this$0.mLastLockTime = SystemClock.uptimeMillis();
                    return c;
                }
                long nextTime = this.this$0.mLastLockTime + 100L;
                long now = SystemClock.uptimeMillis();
                if (nextTime > now) {
                    try {
                        Thread.sleep(nextTime - now);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    now = SystemClock.uptimeMillis();
                }
                this.this$0.mLastLockTime = now;
                this.this$0.mSurfaceLock.unlock();
                return null;
            }

            private final void $$robo$$android_view_SurfaceView_4$unlockCanvasAndPost(Canvas canvas) {
                this.this$0.mSurface.unlockCanvasAndPost(canvas);
                this.this$0.mSurfaceLock.unlock();
            }

            private final Surface $$robo$$android_view_SurfaceView_4$getSurface() {
                return this.this$0.mSurface;
            }

            private final Rect $$robo$$android_view_SurfaceView_4$getSurfaceFrame() {
                return this.this$0.mSurfaceFrame;
            }

            private void __constructor__(SurfaceView surfaceView) {
                this.$$robo$$android_view_SurfaceView_4$__constructor__(surfaceView);
            }
            {
                this.this$0 = surfaceView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_SurfaceView_4$__constructor__(android.view.SurfaceView ), 0, this, surfaceView);
            }

            @Override
            public boolean isCreating() {
                return (boolean)InvokeDynamicSupport.bootstrap("isCreating", $$robo$$android_view_SurfaceView_4$isCreating(), 0, this);
            }

            @Override
            public void addCallback(SurfaceHolder.Callback callback) {
                InvokeDynamicSupport.bootstrap("addCallback", $$robo$$android_view_SurfaceView_4$addCallback(android.view.SurfaceHolder$Callback ), 0, this, callback);
            }

            @Override
            public void removeCallback(SurfaceHolder.Callback callback) {
                InvokeDynamicSupport.bootstrap("removeCallback", $$robo$$android_view_SurfaceView_4$removeCallback(android.view.SurfaceHolder$Callback ), 0, this, callback);
            }

            @Override
            public void setFixedSize(int n, int n2) {
                InvokeDynamicSupport.bootstrap("setFixedSize", $$robo$$android_view_SurfaceView_4$setFixedSize(int int ), 0, this, n, n2);
            }

            @Override
            public void setSizeFromLayout() {
                InvokeDynamicSupport.bootstrap("setSizeFromLayout", $$robo$$android_view_SurfaceView_4$setSizeFromLayout(), 0, this);
            }

            @Override
            public void setFormat(int n) {
                InvokeDynamicSupport.bootstrap("setFormat", $$robo$$android_view_SurfaceView_4$setFormat(int ), 0, this, n);
            }

            @Override
            @Deprecated
            public void setType(int n) {
                InvokeDynamicSupport.bootstrap("setType", $$robo$$android_view_SurfaceView_4$setType(int ), 0, this, n);
            }

            @Override
            public void setKeepScreenOn(boolean bl) {
                InvokeDynamicSupport.bootstrap("setKeepScreenOn", $$robo$$android_view_SurfaceView_4$setKeepScreenOn(boolean ), 0, this, bl);
            }

            @Override
            public Canvas lockCanvas() {
                return InvokeDynamicSupport.bootstrap("lockCanvas", $$robo$$android_view_SurfaceView_4$lockCanvas(), 0, this);
            }

            @Override
            public Canvas lockCanvas(Rect rect) {
                return InvokeDynamicSupport.bootstrap("lockCanvas", $$robo$$android_view_SurfaceView_4$lockCanvas(android.graphics.Rect ), 0, this, rect);
            }

            private Canvas internalLockCanvas(Rect rect) {
                return InvokeDynamicSupport.bootstrap("internalLockCanvas", $$robo$$android_view_SurfaceView_4$internalLockCanvas(android.graphics.Rect ), 0, this, rect);
            }

            @Override
            public void unlockCanvasAndPost(Canvas canvas) {
                InvokeDynamicSupport.bootstrap("unlockCanvasAndPost", $$robo$$android_view_SurfaceView_4$unlockCanvasAndPost(android.graphics.Canvas ), 0, this, canvas);
            }

            @Override
            public Surface getSurface() {
                return InvokeDynamicSupport.bootstrap("getSurface", $$robo$$android_view_SurfaceView_4$getSurface(), 0, this);
            }

            @Override
            public Rect getSurfaceFrame() {
                return InvokeDynamicSupport.bootstrap("getSurfaceFrame", $$robo$$android_view_SurfaceView_4$getSurfaceFrame(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.init();
    }

    private void $$robo$$android_view_SurfaceView$__constructor__(Context context, AttributeSet attrs) {
        this.mCallbacks = new ArrayList();
        this.mLocation = new int[2];
        this.mSurfaceLock = new ReentrantLock();
        this.mSurface = new Surface();
        this.mNewSurface = new Surface();
        this.mDrawingStopped = true;
        this.mLayout = new WindowManager.LayoutParams();
        this.mVisibleInsets = new Rect();
        this.mWinFrame = new Rect();
        this.mOverscanInsets = new Rect();
        this.mContentInsets = new Rect();
        this.mStableInsets = new Rect();
        this.mOutsets = new Rect();
        this.mBackdropFrame = new Rect();
        this.mConfiguration = new Configuration();
        this.mWindowType = 1001;
        this.mIsCreating = false;
        this.mRtHandlingPositionUpdates = false;
        this.mHandler = new /* invalid duplicate definition of identical inner class */;
        this.mScrollChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.mDrawListener = new /* invalid duplicate definition of identical inner class */;
        this.mRequestedVisible = false;
        this.mWindowVisibility = false;
        this.mViewVisibility = false;
        this.mRequestedWidth = -1;
        this.mRequestedHeight = -1;
        this.mRequestedFormat = 4;
        this.mHaveFrame = false;
        this.mSurfaceCreated = false;
        this.mLastLockTime = 0L;
        this.mVisible = false;
        this.mWindowSpaceLeft = -1;
        this.mWindowSpaceTop = -1;
        this.mWindowSpaceWidth = -1;
        this.mWindowSpaceHeight = -1;
        this.mFormat = -1;
        this.mSurfaceFrame = new Rect();
        this.mLastSurfaceWidth = -1;
        this.mLastSurfaceHeight = -1;
        this.mRTLastReportedPosition = new Rect();
        this.mSurfaceHolder = new /* invalid duplicate definition of identical inner class */;
        this.init();
    }

    private void $$robo$$android_view_SurfaceView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mCallbacks = new ArrayList();
        this.mLocation = new int[2];
        this.mSurfaceLock = new ReentrantLock();
        this.mSurface = new Surface();
        this.mNewSurface = new Surface();
        this.mDrawingStopped = true;
        this.mLayout = new WindowManager.LayoutParams();
        this.mVisibleInsets = new Rect();
        this.mWinFrame = new Rect();
        this.mOverscanInsets = new Rect();
        this.mContentInsets = new Rect();
        this.mStableInsets = new Rect();
        this.mOutsets = new Rect();
        this.mBackdropFrame = new Rect();
        this.mConfiguration = new Configuration();
        this.mWindowType = 1001;
        this.mIsCreating = false;
        this.mRtHandlingPositionUpdates = false;
        this.mHandler = new /* invalid duplicate definition of identical inner class */;
        this.mScrollChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.mDrawListener = new /* invalid duplicate definition of identical inner class */;
        this.mRequestedVisible = false;
        this.mWindowVisibility = false;
        this.mViewVisibility = false;
        this.mRequestedWidth = -1;
        this.mRequestedHeight = -1;
        this.mRequestedFormat = 4;
        this.mHaveFrame = false;
        this.mSurfaceCreated = false;
        this.mLastLockTime = 0L;
        this.mVisible = false;
        this.mWindowSpaceLeft = -1;
        this.mWindowSpaceTop = -1;
        this.mWindowSpaceWidth = -1;
        this.mWindowSpaceHeight = -1;
        this.mFormat = -1;
        this.mSurfaceFrame = new Rect();
        this.mLastSurfaceWidth = -1;
        this.mLastSurfaceHeight = -1;
        this.mRTLastReportedPosition = new Rect();
        this.mSurfaceHolder = new /* invalid duplicate definition of identical inner class */;
        this.init();
    }

    private void $$robo$$android_view_SurfaceView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mCallbacks = new ArrayList();
        this.mLocation = new int[2];
        this.mSurfaceLock = new ReentrantLock();
        this.mSurface = new Surface();
        this.mNewSurface = new Surface();
        this.mDrawingStopped = true;
        this.mLayout = new WindowManager.LayoutParams();
        this.mVisibleInsets = new Rect();
        this.mWinFrame = new Rect();
        this.mOverscanInsets = new Rect();
        this.mContentInsets = new Rect();
        this.mStableInsets = new Rect();
        this.mOutsets = new Rect();
        this.mBackdropFrame = new Rect();
        this.mConfiguration = new Configuration();
        this.mWindowType = 1001;
        this.mIsCreating = false;
        this.mRtHandlingPositionUpdates = false;
        this.mHandler = new /* invalid duplicate definition of identical inner class */;
        this.mScrollChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.mDrawListener = new /* invalid duplicate definition of identical inner class */;
        this.mRequestedVisible = false;
        this.mWindowVisibility = false;
        this.mViewVisibility = false;
        this.mRequestedWidth = -1;
        this.mRequestedHeight = -1;
        this.mRequestedFormat = 4;
        this.mHaveFrame = false;
        this.mSurfaceCreated = false;
        this.mLastLockTime = 0L;
        this.mVisible = false;
        this.mWindowSpaceLeft = -1;
        this.mWindowSpaceTop = -1;
        this.mWindowSpaceWidth = -1;
        this.mWindowSpaceHeight = -1;
        this.mFormat = -1;
        this.mSurfaceFrame = new Rect();
        this.mLastSurfaceWidth = -1;
        this.mLastSurfaceHeight = -1;
        this.mRTLastReportedPosition = new Rect();
        this.mSurfaceHolder = new /* invalid duplicate definition of identical inner class */;
        this.init();
    }

    private final void $$robo$$android_view_SurfaceView$init() {
        this.setWillNotDraw(true);
    }

    private final SurfaceHolder $$robo$$android_view_SurfaceView$getHolder() {
        return this.mSurfaceHolder;
    }

    private final void $$robo$$android_view_SurfaceView$onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mParent.requestTransparentRegion(this);
        this.mSession = this.getWindowSession();
        this.mLayout.token = this.getWindowToken();
        this.mLayout.setTitle("SurfaceView - " + this.getViewRootImpl().getTitle());
        boolean bl = this.mViewVisibility = this.getVisibility() == 0;
        if (!this.mGlobalListenersAdded) {
            ViewTreeObserver observer = this.getViewTreeObserver();
            observer.addOnScrollChangedListener(this.mScrollChangedListener);
            observer.addOnPreDrawListener(this.mDrawListener);
            this.mGlobalListenersAdded = true;
        }
    }

    private final void $$robo$$android_view_SurfaceView$onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mWindowVisibility = visibility == 0;
        this.mRequestedVisible = this.mWindowVisibility && this.mViewVisibility;
        this.updateWindow(false, false);
    }

    private final void $$robo$$android_view_SurfaceView$setVisibility(int visibility) {
        boolean newRequestedVisible;
        super.setVisibility(visibility);
        this.mViewVisibility = visibility == 0;
        boolean bl = newRequestedVisible = this.mWindowVisibility && this.mViewVisibility;
        if (newRequestedVisible != this.mRequestedVisible) {
            this.requestLayout();
        }
        this.mRequestedVisible = newRequestedVisible;
        this.updateWindow(false, false);
    }

    private final void $$robo$$android_view_SurfaceView$onDetachedFromWindow() {
        if (this.mGlobalListenersAdded) {
            ViewTreeObserver observer = this.getViewTreeObserver();
            observer.removeOnScrollChangedListener(this.mScrollChangedListener);
            observer.removeOnPreDrawListener(this.mDrawListener);
            this.mGlobalListenersAdded = false;
        }
        this.mRequestedVisible = false;
        this.updateWindow(false, false);
        this.mHaveFrame = false;
        if (this.mWindow != null) {
            try {
                this.mSession.remove(this.mWindow);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mWindow = null;
        }
        this.mSession = null;
        this.mLayout.token = null;
        super.onDetachedFromWindow();
    }

    private final void $$robo$$android_view_SurfaceView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.mRequestedWidth >= 0 ? SurfaceView.resolveSizeAndState(this.mRequestedWidth, widthMeasureSpec, 0) : SurfaceView.getDefaultSize(0, widthMeasureSpec);
        int height = this.mRequestedHeight >= 0 ? SurfaceView.resolveSizeAndState(this.mRequestedHeight, heightMeasureSpec, 0) : SurfaceView.getDefaultSize(0, heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    private final boolean $$robo$$android_view_SurfaceView$setFrame(int left, int top, int right, int bottom) {
        boolean result = super.setFrame(left, top, right, bottom);
        this.updateWindow(false, false);
        return result;
    }

    private final boolean $$robo$$android_view_SurfaceView$gatherTransparentRegion(Region region) {
        if (this.mWindowType == 1000) {
            return super.gatherTransparentRegion(region);
        }
        boolean opaque = true;
        if ((this.mPrivateFlags & 0x80) == 0) {
            opaque = super.gatherTransparentRegion(region);
        } else if (region != null) {
            int w = this.getWidth();
            int h = this.getHeight();
            if (w > 0 && h > 0) {
                this.getLocationInWindow(this.mLocation);
                int l = this.mLocation[0];
                int t = this.mLocation[1];
                region.op(l, t, l + w, t + h, Region.Op.UNION);
            }
        }
        if (PixelFormat.formatHasAlpha(this.mRequestedFormat)) {
            opaque = false;
        }
        return opaque;
    }

    private final void $$robo$$android_view_SurfaceView$draw(Canvas canvas) {
        if (this.mWindowType != 1000 && (this.mPrivateFlags & 0x80) == 0) {
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        super.draw(canvas);
    }

    private final void $$robo$$android_view_SurfaceView$dispatchDraw(Canvas canvas) {
        if (this.mWindowType != 1000 && (this.mPrivateFlags & 0x80) == 128) {
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        super.dispatchDraw(canvas);
    }

    private final void $$robo$$android_view_SurfaceView$setZOrderMediaOverlay(boolean isMediaOverlay) {
        this.mWindowType = isMediaOverlay ? 1004 : 1001;
    }

    private final void $$robo$$android_view_SurfaceView$setZOrderOnTop(boolean onTop) {
        if (onTop) {
            this.mWindowType = 1000;
            this.mLayout.flags |= 0x20000;
        } else {
            this.mWindowType = 1001;
            this.mLayout.flags &= 0xFFFDFFFF;
        }
    }

    private final void $$robo$$android_view_SurfaceView$setSecure(boolean isSecure) {
        this.mLayout.flags = isSecure ? (this.mLayout.flags |= 0x2000) : (this.mLayout.flags &= 0xFFFFDFFF);
    }

    private final void $$robo$$android_view_SurfaceView$setWindowType(int type) {
        this.mWindowType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_SurfaceView$updateWindow(boolean force, boolean redrawNeeded) {
        boolean layoutSizeChanged;
        int myHeight;
        int myWidth;
        if (!this.mHaveFrame) {
            return;
        }
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot != null) {
            this.mTranslator = viewRoot.mTranslator;
        }
        if (this.mTranslator != null) {
            this.mSurface.setCompatibilityTranslator(this.mTranslator);
        }
        if ((myWidth = this.mRequestedWidth) <= 0) {
            myWidth = this.getWidth();
        }
        if ((myHeight = this.mRequestedHeight) <= 0) {
            myHeight = this.getHeight();
        }
        boolean creating = this.mWindow == null;
        boolean formatChanged = this.mFormat != this.mRequestedFormat;
        boolean sizeChanged = this.mWindowSpaceWidth != myWidth || this.mWindowSpaceHeight != myHeight;
        boolean visibleChanged = this.mVisible != this.mRequestedVisible;
        boolean bl = layoutSizeChanged = this.getWidth() != this.mLayout.width || this.getHeight() != this.mLayout.height;
        if (force || creating || formatChanged || sizeChanged || visibleChanged || this.mUpdateWindowNeeded || this.mReportDrawNeeded || redrawNeeded) {
            this.getLocationInWindow(this.mLocation);
            try {
                boolean realSizeChanged;
                int relayoutResult;
                boolean reportDrawNeeded;
                boolean visible = this.mVisible = this.mRequestedVisible;
                this.mWindowSpaceLeft = this.mLocation[0];
                this.mWindowSpaceTop = this.mLocation[1];
                this.mWindowSpaceWidth = myWidth;
                this.mWindowSpaceHeight = myHeight;
                this.mFormat = this.mRequestedFormat;
                this.mLayout.x = this.mWindowSpaceLeft;
                this.mLayout.y = this.mWindowSpaceTop;
                this.mLayout.width = this.getWidth();
                this.mLayout.height = this.getHeight();
                if (this.mTranslator != null) {
                    this.mTranslator.translateLayoutParamsInAppWindowToScreen(this.mLayout);
                }
                this.mLayout.format = this.mRequestedFormat;
                this.mLayout.flags |= 0x4218;
                this.mLayout.privateFlags = !(creating || force || this.mUpdateWindowNeeded || sizeChanged) ? (this.mLayout.privateFlags |= 0x2000) : (this.mLayout.privateFlags &= 0xFFFFDFFF);
                if (!this.getContext().getResources().getCompatibilityInfo().supportsScreen()) {
                    this.mLayout.privateFlags |= 0x80;
                }
                this.mLayout.privateFlags |= 0x10040;
                if (this.mWindow == null) {
                    Display display = this.getDisplay();
                    this.mWindow = new MyWindow(this);
                    this.mLayout.type = this.mWindowType;
                    this.mLayout.gravity = 0x800033;
                    this.mSession.addToDisplayWithoutInputChannel(this.mWindow, this.mWindow.mSeq, this.mLayout, this.mVisible ? 0 : 8, display.getDisplayId(), this.mContentInsets, this.mStableInsets);
                }
                this.mSurfaceLock.lock();
                try {
                    this.mUpdateWindowNeeded = false;
                    reportDrawNeeded = this.mReportDrawNeeded;
                    this.mReportDrawNeeded = false;
                    this.mDrawingStopped = !visible;
                    relayoutResult = this.mSession.relayout(this.mWindow, this.mWindow.mSeq, this.mLayout, this.mWindowSpaceWidth, this.mWindowSpaceHeight, visible ? 0 : 8, 2, this.mWinFrame, this.mOverscanInsets, this.mContentInsets, this.mVisibleInsets, this.mStableInsets, this.mOutsets, this.mBackdropFrame, this.mConfiguration, this.mNewSurface);
                    if ((relayoutResult & 2) != 0) {
                        reportDrawNeeded = true;
                    }
                    this.mSurfaceFrame.left = 0;
                    this.mSurfaceFrame.top = 0;
                    if (this.mTranslator == null) {
                        this.mSurfaceFrame.right = this.mWinFrame.width();
                        this.mSurfaceFrame.bottom = this.mWinFrame.height();
                    } else {
                        float appInvertedScale = this.mTranslator.applicationInvertedScale;
                        this.mSurfaceFrame.right = (int)((float)this.mWinFrame.width() * appInvertedScale + 0.5f);
                        this.mSurfaceFrame.bottom = (int)((float)this.mWinFrame.height() * appInvertedScale + 0.5f);
                    }
                    int surfaceWidth = this.mSurfaceFrame.right;
                    int surfaceHeight = this.mSurfaceFrame.bottom;
                    realSizeChanged = this.mLastSurfaceWidth != surfaceWidth || this.mLastSurfaceHeight != surfaceHeight;
                    this.mLastSurfaceWidth = surfaceWidth;
                    this.mLastSurfaceHeight = surfaceHeight;
                }
                finally {
                    this.mSurfaceLock.unlock();
                }
                try {
                    boolean surfaceChanged;
                    redrawNeeded |= creating | reportDrawNeeded;
                    SurfaceHolder.Callback[] callbacks = null;
                    boolean bl2 = surfaceChanged = (relayoutResult & 4) != 0;
                    if (this.mSurfaceCreated && (surfaceChanged || !visible && visibleChanged)) {
                        this.mSurfaceCreated = false;
                        if (this.mSurface.isValid()) {
                            for (SurfaceHolder.Callback c : callbacks = this.getSurfaceCallbacks()) {
                                c.surfaceDestroyed(this.mSurfaceHolder);
                            }
                        }
                    }
                    this.mSurface.transferFrom(this.mNewSurface);
                    if (visible && this.mSurface.isValid()) {
                        if (!this.mSurfaceCreated && (surfaceChanged || visibleChanged)) {
                            this.mSurfaceCreated = true;
                            this.mIsCreating = true;
                            if (callbacks == null) {
                                callbacks = this.getSurfaceCallbacks();
                            }
                            for (SurfaceHolder.Callback c : callbacks) {
                                c.surfaceCreated(this.mSurfaceHolder);
                            }
                        }
                        if (creating || formatChanged || sizeChanged || visibleChanged || realSizeChanged) {
                            if (callbacks == null) {
                                callbacks = this.getSurfaceCallbacks();
                            }
                            for (SurfaceHolder.Callback c : callbacks) {
                                c.surfaceChanged(this.mSurfaceHolder, this.mFormat, myWidth, myHeight);
                            }
                        }
                        if (redrawNeeded) {
                            if (callbacks == null) {
                                callbacks = this.getSurfaceCallbacks();
                            }
                            for (SurfaceHolder.Callback c : callbacks) {
                                if (!(c instanceof SurfaceHolder.Callback2)) continue;
                                ((SurfaceHolder.Callback2)c).surfaceRedrawNeeded(this.mSurfaceHolder);
                            }
                        }
                    }
                }
                finally {
                    this.mIsCreating = false;
                    if (redrawNeeded) {
                        this.mSession.finishDrawing(this.mWindow);
                    }
                    this.mSession.performDeferredDestroy(this.mWindow);
                }
            }
            catch (RemoteException ex) {
                Log.e("SurfaceView", "Exception from relayout", ex);
            }
        } else {
            boolean positionChanged;
            this.getLocationInWindow(this.mLocation);
            boolean bl3 = positionChanged = this.mWindowSpaceLeft != this.mLocation[0] || this.mWindowSpaceTop != this.mLocation[1];
            if (positionChanged || layoutSizeChanged) {
                this.mWindowSpaceLeft = this.mLocation[0];
                this.mWindowSpaceTop = this.mLocation[1];
                this.mLocation[0] = this.mLayout.width = this.getWidth();
                this.mLocation[1] = this.mLayout.height = this.getHeight();
                this.transformFromViewToWindowSpace(this.mLocation);
                this.mWinFrame.set(this.mWindowSpaceLeft, this.mWindowSpaceTop, this.mLocation[0], this.mLocation[1]);
                if (this.mTranslator != null) {
                    this.mTranslator.translateRectInAppWindowToScreen(this.mWinFrame);
                }
                if (!this.isHardwareAccelerated() || !this.mRtHandlingPositionUpdates) {
                    try {
                        this.mSession.repositionChild(this.mWindow, this.mWinFrame.left, this.mWinFrame.top, this.mWinFrame.right, this.mWinFrame.bottom, -1L, this.mWinFrame);
                    }
                    catch (RemoteException ex) {
                        Log.e("SurfaceView", "Exception from relayout", ex);
                    }
                }
            }
        }
    }

    private final void $$robo$$android_view_SurfaceView$updateWindowPositionRT(long frameNumber, int left, int top, int right, int bottom) {
        IWindowSession session = this.mSession;
        MyWindow window = this.mWindow;
        if (session == null || window == null) {
            return;
        }
        this.mRtHandlingPositionUpdates = true;
        if (this.mRTLastReportedPosition.left == left && this.mRTLastReportedPosition.top == top && this.mRTLastReportedPosition.right == right && this.mRTLastReportedPosition.bottom == bottom) {
            return;
        }
        try {
            session.repositionChild(window, left, top, right, bottom, frameNumber, this.mRTLastReportedPosition);
            this.mRTLastReportedPosition.set(left, top, right, bottom);
        }
        catch (RemoteException ex) {
            Log.e("SurfaceView", "Exception from repositionChild", ex);
        }
    }

    private final void $$robo$$android_view_SurfaceView$windowPositionLostRT(long frameNumber) {
        IWindowSession session = this.mSession;
        MyWindow window = this.mWindow;
        if (session == null || window == null) {
            return;
        }
        if (this.mRtHandlingPositionUpdates) {
            this.mRtHandlingPositionUpdates = false;
            if (!this.mWinFrame.isEmpty() && !this.mWinFrame.equals(this.mRTLastReportedPosition)) {
                try {
                    session.repositionChild(window, this.mWinFrame.left, this.mWinFrame.top, this.mWinFrame.right, this.mWinFrame.bottom, frameNumber, this.mWinFrame);
                }
                catch (RemoteException ex) {
                    Log.e("SurfaceView", "Exception from relayout", ex);
                }
            }
            this.mRTLastReportedPosition.setEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SurfaceHolder.Callback[] $$robo$$android_view_SurfaceView$getSurfaceCallbacks() {
        SurfaceHolder.Callback[] callbacks;
        ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
        synchronized (arrayList) {
            callbacks = new SurfaceHolder.Callback[this.mCallbacks.size()];
            this.mCallbacks.toArray(callbacks);
        }
        return callbacks;
    }

    private final void $$robo$$android_view_SurfaceView$handleGetNewSurface() {
        this.updateWindow(false, false);
    }

    private final boolean $$robo$$android_view_SurfaceView$isFixedSize() {
        return this.mRequestedWidth != -1 || this.mRequestedHeight != -1;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_view_SurfaceView$__constructor__(context);
    }

    public SurfaceView(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_SurfaceView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_view_SurfaceView$__constructor__(context, attributeSet);
    }

    public SurfaceView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_SurfaceView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_view_SurfaceView$__constructor__(context, attributeSet, n);
    }

    public SurfaceView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_SurfaceView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_view_SurfaceView$__constructor__(context, attributeSet, n, n2);
    }

    public SurfaceView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_SurfaceView$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void init() {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_view_SurfaceView$init(), 0, this);
    }

    public SurfaceHolder getHolder() {
        return InvokeDynamicSupport.bootstrap("getHolder", $$robo$$android_view_SurfaceView$getHolder(), 0, this);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_view_SurfaceView$onAttachedToWindow(), 0, this);
    }

    @Override
    protected void onWindowVisibilityChanged(int n) {
        InvokeDynamicSupport.bootstrap("onWindowVisibilityChanged", $$robo$$android_view_SurfaceView$onWindowVisibilityChanged(int ), 0, this, n);
    }

    @Override
    public void setVisibility(int n) {
        InvokeDynamicSupport.bootstrap("setVisibility", $$robo$$android_view_SurfaceView$setVisibility(int ), 0, this, n);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_view_SurfaceView$onDetachedFromWindow(), 0, this);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_view_SurfaceView$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    protected boolean setFrame(int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("setFrame", $$robo$$android_view_SurfaceView$setFrame(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public boolean gatherTransparentRegion(Region region) {
        return (boolean)InvokeDynamicSupport.bootstrap("gatherTransparentRegion", $$robo$$android_view_SurfaceView$gatherTransparentRegion(android.graphics.Region ), 0, this, region);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_view_SurfaceView$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("dispatchDraw", $$robo$$android_view_SurfaceView$dispatchDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    public void setZOrderMediaOverlay(boolean bl) {
        InvokeDynamicSupport.bootstrap("setZOrderMediaOverlay", $$robo$$android_view_SurfaceView$setZOrderMediaOverlay(boolean ), 0, this, bl);
    }

    public void setZOrderOnTop(boolean bl) {
        InvokeDynamicSupport.bootstrap("setZOrderOnTop", $$robo$$android_view_SurfaceView$setZOrderOnTop(boolean ), 0, this, bl);
    }

    public void setSecure(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSecure", $$robo$$android_view_SurfaceView$setSecure(boolean ), 0, this, bl);
    }

    public void setWindowType(int n) {
        InvokeDynamicSupport.bootstrap("setWindowType", $$robo$$android_view_SurfaceView$setWindowType(int ), 0, this, n);
    }

    protected void updateWindow(boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("updateWindow", $$robo$$android_view_SurfaceView$updateWindow(boolean boolean ), 0, this, bl, bl2);
    }

    public void updateWindowPositionRT(long l, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("updateWindowPositionRT", $$robo$$android_view_SurfaceView$updateWindowPositionRT(long int int int int ), 0, this, l, n, n2, n3, n4);
    }

    public void windowPositionLostRT(long l) {
        InvokeDynamicSupport.bootstrap("windowPositionLostRT", $$robo$$android_view_SurfaceView$windowPositionLostRT(long ), 0, this, l);
    }

    private SurfaceHolder.Callback[] getSurfaceCallbacks() {
        return InvokeDynamicSupport.bootstrap("getSurfaceCallbacks", $$robo$$android_view_SurfaceView$getSurfaceCallbacks(), 0, this);
    }

    void handleGetNewSurface() {
        InvokeDynamicSupport.bootstrap("handleGetNewSurface", $$robo$$android_view_SurfaceView$handleGetNewSurface(), 0, this);
    }

    public boolean isFixedSize() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFixedSize", $$robo$$android_view_SurfaceView$isFixedSize(), 0, this);
    }

    public /* synthetic */ SurfaceView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SurfaceView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class MyWindow
    extends BaseIWindow
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<SurfaceView> mSurfaceView;
        int mCurWidth;
        int mCurHeight;

        private void $$robo$$android_view_SurfaceView_MyWindow$__constructor__(SurfaceView surfaceView) {
            this.mCurWidth = -1;
            this.mCurHeight = -1;
            this.mSurfaceView = new WeakReference<SurfaceView>(surfaceView);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_view_SurfaceView_MyWindow$resized(Rect frame, Rect overscanInsets, Rect contentInsets, Rect visibleInsets, Rect stableInsets, Rect outsets, boolean reportDraw, Configuration newConfig, Rect backDropRect, boolean forceLayout, boolean alwaysConsumeNavBar) {
            SurfaceView surfaceView = (SurfaceView)this.mSurfaceView.get();
            if (surfaceView != null) {
                surfaceView.mSurfaceLock.lock();
                try {
                    if (reportDraw) {
                        surfaceView.mUpdateWindowNeeded = true;
                        surfaceView.mReportDrawNeeded = true;
                        surfaceView.mHandler.sendEmptyMessage(3);
                    } else if (surfaceView.mWinFrame.width() != frame.width() || surfaceView.mWinFrame.height() != frame.height() || forceLayout) {
                        surfaceView.mUpdateWindowNeeded = true;
                        surfaceView.mHandler.sendEmptyMessage(3);
                    }
                }
                finally {
                    surfaceView.mSurfaceLock.unlock();
                }
            }
        }

        private final void $$robo$$android_view_SurfaceView_MyWindow$dispatchAppVisibility(boolean visible) {
        }

        private final void $$robo$$android_view_SurfaceView_MyWindow$dispatchGetNewSurface() {
            SurfaceView surfaceView = (SurfaceView)this.mSurfaceView.get();
            if (surfaceView != null) {
                Message msg = surfaceView.mHandler.obtainMessage(2);
                surfaceView.mHandler.sendMessage(msg);
            }
        }

        private final void $$robo$$android_view_SurfaceView_MyWindow$windowFocusChanged(boolean hasFocus, boolean touchEnabled) {
            Log.w("SurfaceView", "Unexpected focus in surface: focus=" + hasFocus + ", touchEnabled=" + touchEnabled);
        }

        private final void $$robo$$android_view_SurfaceView_MyWindow$executeCommand(String command, String parameters, ParcelFileDescriptor out) {
        }

        private void __constructor__(SurfaceView surfaceView) {
            this.$$robo$$android_view_SurfaceView_MyWindow$__constructor__(surfaceView);
        }

        public MyWindow(SurfaceView surfaceView) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_SurfaceView_MyWindow$__constructor__(android.view.SurfaceView ), 0, this, surfaceView);
        }

        @Override
        public void resized(Rect rect, Rect rect2, Rect rect3, Rect rect4, Rect rect5, Rect rect6, boolean bl, Configuration configuration, Rect rect7, boolean bl2, boolean bl3) {
            InvokeDynamicSupport.bootstrap("resized", $$robo$$android_view_SurfaceView_MyWindow$resized(android.graphics.Rect android.graphics.Rect android.graphics.Rect android.graphics.Rect android.graphics.Rect android.graphics.Rect boolean android.content.res.Configuration android.graphics.Rect boolean boolean ), 0, this, rect, rect2, rect3, rect4, rect5, rect6, bl, configuration, rect7, bl2, bl3);
        }

        @Override
        public void dispatchAppVisibility(boolean bl) {
            InvokeDynamicSupport.bootstrap("dispatchAppVisibility", $$robo$$android_view_SurfaceView_MyWindow$dispatchAppVisibility(boolean ), 0, this, bl);
        }

        @Override
        public void dispatchGetNewSurface() {
            InvokeDynamicSupport.bootstrap("dispatchGetNewSurface", $$robo$$android_view_SurfaceView_MyWindow$dispatchGetNewSurface(), 0, this);
        }

        @Override
        public void windowFocusChanged(boolean bl, boolean bl2) {
            InvokeDynamicSupport.bootstrap("windowFocusChanged", $$robo$$android_view_SurfaceView_MyWindow$windowFocusChanged(boolean boolean ), 0, this, bl, bl2);
        }

        @Override
        public void executeCommand(String string2, String string3, ParcelFileDescriptor parcelFileDescriptor) {
            InvokeDynamicSupport.bootstrap("executeCommand", $$robo$$android_view_SurfaceView_MyWindow$executeCommand(java.lang.String java.lang.String android.os.ParcelFileDescriptor ), 0, this, string2, string3, parcelFileDescriptor);
        }

        public /* synthetic */ MyWindow() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyWindow)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

