/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemClock;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.MetaKeyKeyListener;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.ComposingText;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BaseInputConnection
implements InputConnection,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String TAG = "BaseInputConnection";
    static Object COMPOSING;
    protected InputMethodManager mIMM;
    View mTargetView;
    boolean mDummyMode;
    private Object[] mDefaultComposingSpans;
    Editable mEditable;
    KeyCharacterMap mKeyCharacterMap;
    private static int INVALID_INDEX;

    private void $$robo$$android_view_inputmethod_BaseInputConnection$__constructor__(InputMethodManager mgr, boolean fullEditor) {
        this.mIMM = mgr;
        this.mTargetView = null;
        this.mDummyMode = !fullEditor;
    }

    private void $$robo$$android_view_inputmethod_BaseInputConnection$__constructor__(View targetView, boolean fullEditor) {
        this.mIMM = (InputMethodManager)targetView.getContext().getSystemService("input_method");
        this.mTargetView = targetView;
        this.mDummyMode = !fullEditor;
    }

    private static final void $$robo$$android_view_inputmethod_BaseInputConnection$removeComposingSpans(Spannable text) {
        text.removeSpan(COMPOSING);
        Object[] sps = text.getSpans(0, text.length(), Object.class);
        if (sps != null) {
            for (int i = sps.length - 1; i >= 0; --i) {
                Object o = sps[i];
                if ((text.getSpanFlags(o) & 0x100) == 0) continue;
                text.removeSpan(o);
            }
        }
    }

    private static final void $$robo$$android_view_inputmethod_BaseInputConnection$setComposingSpans(Spannable text) {
        BaseInputConnection.setComposingSpans(text, 0, text.length());
    }

    private static final void $$robo$$android_view_inputmethod_BaseInputConnection$setComposingSpans(Spannable text, int start, int end) {
        Object[] sps = text.getSpans(start, end, Object.class);
        if (sps != null) {
            for (int i = sps.length - 1; i >= 0; --i) {
                Object o = sps[i];
                if (o == COMPOSING) {
                    text.removeSpan(o);
                    continue;
                }
                int fl = text.getSpanFlags(o);
                if ((fl & 0x133) == 289) continue;
                text.setSpan(o, text.getSpanStart(o), text.getSpanEnd(o), fl & 0xFFFFFFCC | 0x100 | 0x21);
            }
        }
        text.setSpan(COMPOSING, start, end, 289);
    }

    private static final int $$robo$$android_view_inputmethod_BaseInputConnection$getComposingSpanStart(Spannable text) {
        return text.getSpanStart(COMPOSING);
    }

    private static final int $$robo$$android_view_inputmethod_BaseInputConnection$getComposingSpanEnd(Spannable text) {
        return text.getSpanEnd(COMPOSING);
    }

    private final Editable $$robo$$android_view_inputmethod_BaseInputConnection$getEditable() {
        if (this.mEditable == null) {
            this.mEditable = Editable.Factory.getInstance().newEditable("");
            Selection.setSelection(this.mEditable, 0);
        }
        return this.mEditable;
    }

    private final boolean $$robo$$android_view_inputmethod_BaseInputConnection$beginBatchEdit() {
        return false;
    }

    private final boolean $$robo$$android_view_inputmethod_BaseInputConnection$endBatchEdit() {
        return false;
    }

    private final void $$robo$$android_view_inputmethod_BaseInputConnection$closeConnection() {
        this.finishComposingText();
    }

    private final boolean $$robo$$android_view_inputmethod_BaseInputConnection$clearMetaKeyStates(int states) {
        Editable content = this.getEditable();
        if (content == null) {
            return false;
        }
        MetaKeyKeyListener.clearMetaKeyState(content, states);
        return true;
    }

    private final boolean $$robo$$android_view_inputmethod_BaseInputConnection$commitCompletion(CompletionInfo text) {
        return false;
    }

    private final boolean $$robo$$android_view_inputmethod_BaseInputConnection$commitCorrection(CorrectionInfo correctionInfo) {
        return false;
    }

    private final boolean $$robo$$android_view_inputmethod_BaseInputConnection$commitText(CharSequence text, int newCursorPosition) {
        this.replaceText(text, newCursorPosition, false);
        this.sendCurrentText();
        return true;
    }

    private final boolean $$robo$$android_view_inputmethod_BaseInputConnection$deleteSurroundingText(int beforeLength, int afterLength) {
        Editable content = this.getEditable();
        if (content == null) {
            return false;
        }
        this.beginBatchEdit();
        int a = Selection.getSelectionStart(content);
        int b = Selection.getSelectionEnd(content);
        if (a > b) {
            int tmp = a;
            a = b;
            b = tmp;
        }
        int ca = BaseInputConnection.getComposingSpanStart(content);
        int cb = BaseInputConnection.getComposingSpanEnd(content);
        if (cb < ca) {
            int tmp = ca;
            ca = cb;
            cb = tmp;
        }
        if (ca != -1 && cb != -1) {
            if (ca < a) {
                a = ca;
            }
            if (cb > b) {
                b = cb;
            }
        }
        int deleted = 0;
        if (beforeLength > 0) {
            int start = a - beforeLength;
            if (start < 0) {
                start = 0;
            }
            content.delete(start, a);
            deleted = a - start;
        }
        if (afterLength > 0) {
            int end = (b -= deleted) + afterLength;
            if (end > content.length()) {
                end = content.length();
            }
            content.delete(b, end);
        }
        this.endBatchEdit();
        return true;
    }

    private static final int $$robo$$android_view_inputmethod_BaseInputConnection$findIndexBackward(CharSequence cs, int from, int numCodePoints) {
        int currentIndex = from;
        boolean waitingHighSurrogate = false;
        int N = cs.length();
        if (currentIndex < 0 || N < currentIndex) {
            return INVALID_INDEX;
        }
        if (numCodePoints < 0) {
            return INVALID_INDEX;
        }
        int remainingCodePoints = numCodePoints;
        while (remainingCodePoints != 0) {
            if (--currentIndex < 0) {
                if (waitingHighSurrogate) {
                    return INVALID_INDEX;
                }
                return 0;
            }
            char c = cs.charAt(currentIndex);
            if (waitingHighSurrogate) {
                if (!Character.isHighSurrogate(c)) {
                    return INVALID_INDEX;
                }
                waitingHighSurrogate = false;
                --remainingCodePoints;
                continue;
            }
            if (!Character.isSurrogate(c)) {
                --remainingCodePoints;
                continue;
            }
            if (Character.isHighSurrogate(c)) {
                return INVALID_INDEX;
            }
            waitingHighSurrogate = true;
        }
        return currentIndex;
    }

    private static final int $$robo$$android_view_inputmethod_BaseInputConnection$findIndexForward(CharSequence cs, int from, int numCodePoints) {
        int currentIndex = from;
        boolean waitingLowSurrogate = false;
        int N = cs.length();
        if (currentIndex < 0 || N < currentIndex) {
            return INVALID_INDEX;
        }
        if (numCodePoints < 0) {
            return INVALID_INDEX;
        }
        int remainingCodePoints = numCodePoints;
        while (remainingCodePoints != 0) {
            if (currentIndex >= N) {
                if (waitingLowSurrogate) {
                    return INVALID_INDEX;
                }
                return N;
            }
            char c = cs.charAt(currentIndex);
            if (waitingLowSurrogate) {
                if (!Character.isLowSurrogate(c)) {
                    return INVALID_INDEX;
                }
                --remainingCodePoints;
                waitingLowSurrogate = false;
                ++currentIndex;
                continue;
            }
            if (!Character.isSurrogate(c)) {
                --remainingCodePoints;
                ++currentIndex;
                continue;
            }
            if (Character.isLowSurrogate(c)) {
                return INVALID_INDEX;
            }
            waitingLowSurrogate = true;
            ++currentIndex;
        }
        return currentIndex;
    }

    private final boolean $$robo$$android_view_inputmethod_BaseInputConnection$deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) {
        int end;
        int start;
        Editable content = this.getEditable();
        if (content == null) {
            return false;
        }
        this.beginBatchEdit();
        int a = Selection.getSelectionStart(content);
        int b = Selection.getSelectionEnd(content);
        if (a > b) {
            int tmp = a;
            a = b;
            b = tmp;
        }
        int ca = BaseInputConnection.getComposingSpanStart(content);
        int cb = BaseInputConnection.getComposingSpanEnd(content);
        if (cb < ca) {
            int tmp = ca;
            ca = cb;
            cb = tmp;
        }
        if (ca != -1 && cb != -1) {
            if (ca < a) {
                a = ca;
            }
            if (cb > b) {
                b = cb;
            }
        }
        if (a >= 0 && b >= 0 && (start = BaseInputConnection.findIndexBackward(content, a, Math.max(beforeLength, 0))) != INVALID_INDEX && (end = BaseInputConnection.findIndexForward(content, b, Math.max(afterLength, 0))) != INVALID_INDEX) {
            int numDeleteAfter;
            int numDeleteBefore = a - start;
            if (numDeleteBefore > 0) {
                content.delete(start, a);
            }
            if ((numDeleteAfter = end - b) > 0) {
                content.delete(b - numDeleteBefore, end - numDeleteBefore);
            }
        }
        this.endBatchEdit();
        return true;
    }

    private final boolean $$robo$$android_view_inputmethod_BaseInputConnection$finishComposingText() {
        Editable content = this.getEditable();
        if (content != null) {
            this.beginBatchEdit();
            BaseInputConnection.removeComposingSpans(content);
            this.sendCurrentText();
            this.endBatchEdit();
        }
        return true;
    }

    private final int $$robo$$android_view_inputmethod_BaseInputConnection$getCursorCapsMode(int reqModes) {
        int b;
        if (this.mDummyMode) {
            return 0;
        }
        Editable content = this.getEditable();
        if (content == null) {
            return 0;
        }
        int a = Selection.getSelectionStart(content);
        if (a > (b = Selection.getSelectionEnd(content))) {
            int tmp = a;
            a = b;
            b = tmp;
        }
        return TextUtils.getCapsMode(content, a, reqModes);
    }

    private final ExtractedText $$robo$$android_view_inputmethod_BaseInputConnection$getExtractedText(ExtractedTextRequest request, int flags) {
        return null;
    }

    private final CharSequence $$robo$$android_view_inputmethod_BaseInputConnection$getTextBeforeCursor(int length, int flags) {
        int b;
        Editable content = this.getEditable();
        if (content == null) {
            return null;
        }
        int a = Selection.getSelectionStart(content);
        if (a > (b = Selection.getSelectionEnd(content))) {
            int tmp = a;
            a = b;
            b = tmp;
        }
        if (a <= 0) {
            return "";
        }
        if (length > a) {
            length = a;
        }
        if ((flags & 1) != 0) {
            return content.subSequence(a - length, a);
        }
        return TextUtils.substring(content, a - length, a);
    }

    private final CharSequence $$robo$$android_view_inputmethod_BaseInputConnection$getSelectedText(int flags) {
        int b;
        Editable content = this.getEditable();
        if (content == null) {
            return null;
        }
        int a = Selection.getSelectionStart(content);
        if (a > (b = Selection.getSelectionEnd(content))) {
            int tmp = a;
            a = b;
            b = tmp;
        }
        if (a == b) {
            return null;
        }
        if ((flags & 1) != 0) {
            return content.subSequence(a, b);
        }
        return TextUtils.substring(content, a, b);
    }

    private final CharSequence $$robo$$android_view_inputmethod_BaseInputConnection$getTextAfterCursor(int length, int flags) {
        int b;
        Editable content = this.getEditable();
        if (content == null) {
            return null;
        }
        int a = Selection.getSelectionStart(content);
        if (a > (b = Selection.getSelectionEnd(content))) {
            int tmp = a;
            a = b;
            b = tmp;
        }
        if (b < 0) {
            b = 0;
        }
        if (b + length > content.length()) {
            length = content.length() - b;
        }
        if ((flags & 1) != 0) {
            return content.subSequence(b, b + length);
        }
        return TextUtils.substring(content, b, b + length);
    }

    private final boolean $$robo$$android_view_inputmethod_BaseInputConnection$performEditorAction(int actionCode) {
        long eventTime = SystemClock.uptimeMillis();
        this.sendKeyEvent(new KeyEvent(eventTime, eventTime, 0, 66, 0, 0, -1, 0, 22));
        this.sendKeyEvent(new KeyEvent(SystemClock.uptimeMillis(), eventTime, 1, 66, 0, 0, -1, 0, 22));
        return true;
    }

    private final boolean $$robo$$android_view_inputmethod_BaseInputConnection$performContextMenuAction(int id2) {
        return false;
    }

    private final boolean $$robo$$android_view_inputmethod_BaseInputConnection$performPrivateCommand(String action, Bundle data) {
        return false;
    }

    private final boolean $$robo$$android_view_inputmethod_BaseInputConnection$requestCursorUpdates(int cursorUpdateMode) {
        return false;
    }

    private final Handler $$robo$$android_view_inputmethod_BaseInputConnection$getHandler() {
        return null;
    }

    private final boolean $$robo$$android_view_inputmethod_BaseInputConnection$setComposingText(CharSequence text, int newCursorPosition) {
        this.replaceText(text, newCursorPosition, true);
        return true;
    }

    private final boolean $$robo$$android_view_inputmethod_BaseInputConnection$setComposingRegion(int start, int end) {
        Editable content = this.getEditable();
        if (content != null) {
            this.beginBatchEdit();
            BaseInputConnection.removeComposingSpans(content);
            int a = start;
            int b = end;
            if (a > b) {
                int tmp = a;
                a = b;
                b = tmp;
            }
            int length = content.length();
            if (a < 0) {
                a = 0;
            }
            if (b < 0) {
                b = 0;
            }
            if (a > length) {
                a = length;
            }
            if (b > length) {
                b = length;
            }
            this.ensureDefaultComposingSpans();
            if (this.mDefaultComposingSpans != null) {
                for (int i = 0; i < this.mDefaultComposingSpans.length; ++i) {
                    content.setSpan(this.mDefaultComposingSpans[i], a, b, 289);
                }
            }
            content.setSpan(COMPOSING, a, b, 289);
            this.sendCurrentText();
            this.endBatchEdit();
        }
        return true;
    }

    private final boolean $$robo$$android_view_inputmethod_BaseInputConnection$setSelection(int start, int end) {
        Editable content = this.getEditable();
        if (content == null) {
            return false;
        }
        int len = content.length();
        if (start > len || end > len || start < 0 || end < 0) {
            return true;
        }
        if (start == end && MetaKeyKeyListener.getMetaState((CharSequence)content, 2048) != 0) {
            Selection.extendSelection(content, start);
        } else {
            Selection.setSelection(content, start, end);
        }
        return true;
    }

    private final boolean $$robo$$android_view_inputmethod_BaseInputConnection$sendKeyEvent(KeyEvent event) {
        this.mIMM.dispatchKeyEventFromInputMethod(this.mTargetView, event);
        return false;
    }

    private final boolean $$robo$$android_view_inputmethod_BaseInputConnection$reportFullscreenMode(boolean enabled) {
        return true;
    }

    private final void $$robo$$android_view_inputmethod_BaseInputConnection$sendCurrentText() {
        if (!this.mDummyMode) {
            return;
        }
        Editable content = this.getEditable();
        if (content != null) {
            int N = content.length();
            if (N == 0) {
                return;
            }
            if (N == 1) {
                if (this.mKeyCharacterMap == null) {
                    this.mKeyCharacterMap = KeyCharacterMap.load(-1);
                }
                char[] chars = new char[1];
                content.getChars(0, 1, chars, 0);
                KeyEvent[] events = this.mKeyCharacterMap.getEvents(chars);
                if (events != null) {
                    for (int i = 0; i < events.length; ++i) {
                        this.sendKeyEvent(events[i]);
                    }
                    content.clear();
                    return;
                }
            }
            KeyEvent event = new KeyEvent(SystemClock.uptimeMillis(), content.toString(), -1, 0);
            this.sendKeyEvent(event);
            content.clear();
        }
    }

    private final void $$robo$$android_view_inputmethod_BaseInputConnection$ensureDefaultComposingSpans() {
        Context context;
        if (this.mDefaultComposingSpans == null && (context = this.mTargetView != null ? this.mTargetView.getContext() : (this.mIMM.mServedView != null ? this.mIMM.mServedView.getContext() : null)) != null) {
            TypedArray ta = context.getTheme().obtainStyledAttributes(new int[]{16843312});
            CharSequence style2 = ta.getText(0);
            ta.recycle();
            if (style2 != null && style2 instanceof Spanned) {
                this.mDefaultComposingSpans = ((Spanned)style2).getSpans(0, style2.length(), Object.class);
            }
        }
    }

    private final void $$robo$$android_view_inputmethod_BaseInputConnection$replaceText(CharSequence text, int newCursorPosition, boolean composing) {
        int tmp;
        Editable content = this.getEditable();
        if (content == null) {
            return;
        }
        this.beginBatchEdit();
        int a = BaseInputConnection.getComposingSpanStart(content);
        int b = BaseInputConnection.getComposingSpanEnd(content);
        if (b < a) {
            tmp = a;
            a = b;
            b = tmp;
        }
        if (a != -1 && b != -1) {
            BaseInputConnection.removeComposingSpans(content);
        } else {
            a = Selection.getSelectionStart(content);
            b = Selection.getSelectionEnd(content);
            if (a < 0) {
                a = 0;
            }
            if (b < 0) {
                b = 0;
            }
            if (b < a) {
                tmp = a;
                a = b;
                b = tmp;
            }
        }
        if (composing) {
            Spannable sp = null;
            if (!(text instanceof Spannable)) {
                sp = new SpannableStringBuilder(text);
                text = sp;
                this.ensureDefaultComposingSpans();
                if (this.mDefaultComposingSpans != null) {
                    for (int i = 0; i < this.mDefaultComposingSpans.length; ++i) {
                        sp.setSpan(this.mDefaultComposingSpans[i], 0, sp.length(), 289);
                    }
                }
            } else {
                sp = (Spannable)text;
            }
            BaseInputConnection.setComposingSpans(sp);
        }
        newCursorPosition = newCursorPosition > 0 ? (newCursorPosition += b - 1) : (newCursorPosition += a);
        if (newCursorPosition < 0) {
            newCursorPosition = 0;
        }
        if (newCursorPosition > content.length()) {
            newCursorPosition = content.length();
        }
        Selection.setSelection(content, newCursorPosition);
        content.replace(a, b, text);
        this.endBatchEdit();
    }

    static void __staticInitializer__() {
        COMPOSING = new ComposingText();
        INVALID_INDEX = -1;
    }

    private void __constructor__(InputMethodManager inputMethodManager, boolean bl) {
        this.$$robo$$android_view_inputmethod_BaseInputConnection$__constructor__(inputMethodManager, bl);
    }

    BaseInputConnection(InputMethodManager inputMethodManager, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_BaseInputConnection$__constructor__(android.view.inputmethod.InputMethodManager boolean ), 0, this, inputMethodManager, bl);
    }

    private void __constructor__(View view, boolean bl) {
        this.$$robo$$android_view_inputmethod_BaseInputConnection$__constructor__(view, bl);
    }

    public BaseInputConnection(View view, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_BaseInputConnection$__constructor__(android.view.View boolean ), 0, this, view, bl);
    }

    public static void removeComposingSpans(Spannable spannable) {
        InvokeDynamicSupport.bootstrapStatic("removeComposingSpans", $$robo$$android_view_inputmethod_BaseInputConnection$removeComposingSpans(android.text.Spannable ), 0, (Spannable)spannable);
    }

    public static void setComposingSpans(Spannable spannable) {
        InvokeDynamicSupport.bootstrapStatic("setComposingSpans", $$robo$$android_view_inputmethod_BaseInputConnection$setComposingSpans(android.text.Spannable ), 0, (Spannable)spannable);
    }

    public static void setComposingSpans(Spannable spannable, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("setComposingSpans", $$robo$$android_view_inputmethod_BaseInputConnection$setComposingSpans(android.text.Spannable int int ), 0, (Spannable)spannable, (int)n, (int)n2);
    }

    public static int getComposingSpanStart(Spannable spannable) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getComposingSpanStart", $$robo$$android_view_inputmethod_BaseInputConnection$getComposingSpanStart(android.text.Spannable ), 0, (Spannable)spannable);
    }

    public static int getComposingSpanEnd(Spannable spannable) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getComposingSpanEnd", $$robo$$android_view_inputmethod_BaseInputConnection$getComposingSpanEnd(android.text.Spannable ), 0, (Spannable)spannable);
    }

    public Editable getEditable() {
        return InvokeDynamicSupport.bootstrap("getEditable", $$robo$$android_view_inputmethod_BaseInputConnection$getEditable(), 0, this);
    }

    @Override
    public boolean beginBatchEdit() {
        return (boolean)InvokeDynamicSupport.bootstrap("beginBatchEdit", $$robo$$android_view_inputmethod_BaseInputConnection$beginBatchEdit(), 0, this);
    }

    @Override
    public boolean endBatchEdit() {
        return (boolean)InvokeDynamicSupport.bootstrap("endBatchEdit", $$robo$$android_view_inputmethod_BaseInputConnection$endBatchEdit(), 0, this);
    }

    @Override
    public void closeConnection() {
        InvokeDynamicSupport.bootstrap("closeConnection", $$robo$$android_view_inputmethod_BaseInputConnection$closeConnection(), 0, this);
    }

    @Override
    public boolean clearMetaKeyStates(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("clearMetaKeyStates", $$robo$$android_view_inputmethod_BaseInputConnection$clearMetaKeyStates(int ), 0, this, n);
    }

    @Override
    public boolean commitCompletion(CompletionInfo completionInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("commitCompletion", $$robo$$android_view_inputmethod_BaseInputConnection$commitCompletion(android.view.inputmethod.CompletionInfo ), 0, this, completionInfo);
    }

    @Override
    public boolean commitCorrection(CorrectionInfo correctionInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("commitCorrection", $$robo$$android_view_inputmethod_BaseInputConnection$commitCorrection(android.view.inputmethod.CorrectionInfo ), 0, this, correctionInfo);
    }

    @Override
    public boolean commitText(CharSequence charSequence, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("commitText", $$robo$$android_view_inputmethod_BaseInputConnection$commitText(java.lang.CharSequence int ), 0, this, charSequence, n);
    }

    @Override
    public boolean deleteSurroundingText(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("deleteSurroundingText", $$robo$$android_view_inputmethod_BaseInputConnection$deleteSurroundingText(int int ), 0, this, n, n2);
    }

    private static int findIndexBackward(CharSequence charSequence, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findIndexBackward", $$robo$$android_view_inputmethod_BaseInputConnection$findIndexBackward(java.lang.CharSequence int int ), 0, (CharSequence)charSequence, (int)n, (int)n2);
    }

    private static int findIndexForward(CharSequence charSequence, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findIndexForward", $$robo$$android_view_inputmethod_BaseInputConnection$findIndexForward(java.lang.CharSequence int int ), 0, (CharSequence)charSequence, (int)n, (int)n2);
    }

    @Override
    public boolean deleteSurroundingTextInCodePoints(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("deleteSurroundingTextInCodePoints", $$robo$$android_view_inputmethod_BaseInputConnection$deleteSurroundingTextInCodePoints(int int ), 0, this, n, n2);
    }

    @Override
    public boolean finishComposingText() {
        return (boolean)InvokeDynamicSupport.bootstrap("finishComposingText", $$robo$$android_view_inputmethod_BaseInputConnection$finishComposingText(), 0, this);
    }

    @Override
    public int getCursorCapsMode(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCursorCapsMode", $$robo$$android_view_inputmethod_BaseInputConnection$getCursorCapsMode(int ), 0, this, n);
    }

    @Override
    public ExtractedText getExtractedText(ExtractedTextRequest extractedTextRequest, int n) {
        return InvokeDynamicSupport.bootstrap("getExtractedText", $$robo$$android_view_inputmethod_BaseInputConnection$getExtractedText(android.view.inputmethod.ExtractedTextRequest int ), 0, this, extractedTextRequest, n);
    }

    @Override
    public CharSequence getTextBeforeCursor(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getTextBeforeCursor", $$robo$$android_view_inputmethod_BaseInputConnection$getTextBeforeCursor(int int ), 0, this, n, n2);
    }

    @Override
    public CharSequence getSelectedText(int n) {
        return InvokeDynamicSupport.bootstrap("getSelectedText", $$robo$$android_view_inputmethod_BaseInputConnection$getSelectedText(int ), 0, this, n);
    }

    @Override
    public CharSequence getTextAfterCursor(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getTextAfterCursor", $$robo$$android_view_inputmethod_BaseInputConnection$getTextAfterCursor(int int ), 0, this, n, n2);
    }

    @Override
    public boolean performEditorAction(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("performEditorAction", $$robo$$android_view_inputmethod_BaseInputConnection$performEditorAction(int ), 0, this, n);
    }

    @Override
    public boolean performContextMenuAction(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("performContextMenuAction", $$robo$$android_view_inputmethod_BaseInputConnection$performContextMenuAction(int ), 0, this, n);
    }

    @Override
    public boolean performPrivateCommand(String string2, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performPrivateCommand", $$robo$$android_view_inputmethod_BaseInputConnection$performPrivateCommand(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    @Override
    public boolean requestCursorUpdates(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestCursorUpdates", $$robo$$android_view_inputmethod_BaseInputConnection$requestCursorUpdates(int ), 0, this, n);
    }

    @Override
    public Handler getHandler() {
        return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$android_view_inputmethod_BaseInputConnection$getHandler(), 0, this);
    }

    @Override
    public boolean setComposingText(CharSequence charSequence, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setComposingText", $$robo$$android_view_inputmethod_BaseInputConnection$setComposingText(java.lang.CharSequence int ), 0, this, charSequence, n);
    }

    @Override
    public boolean setComposingRegion(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setComposingRegion", $$robo$$android_view_inputmethod_BaseInputConnection$setComposingRegion(int int ), 0, this, n, n2);
    }

    @Override
    public boolean setSelection(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setSelection", $$robo$$android_view_inputmethod_BaseInputConnection$setSelection(int int ), 0, this, n, n2);
    }

    @Override
    public boolean sendKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendKeyEvent", $$robo$$android_view_inputmethod_BaseInputConnection$sendKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    @Override
    public boolean reportFullscreenMode(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("reportFullscreenMode", $$robo$$android_view_inputmethod_BaseInputConnection$reportFullscreenMode(boolean ), 0, this, bl);
    }

    private void sendCurrentText() {
        InvokeDynamicSupport.bootstrap("sendCurrentText", $$robo$$android_view_inputmethod_BaseInputConnection$sendCurrentText(), 0, this);
    }

    private void ensureDefaultComposingSpans() {
        InvokeDynamicSupport.bootstrap("ensureDefaultComposingSpans", $$robo$$android_view_inputmethod_BaseInputConnection$ensureDefaultComposingSpans(), 0, this);
    }

    private void replaceText(CharSequence charSequence, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("replaceText", $$robo$$android_view_inputmethod_BaseInputConnection$replaceText(java.lang.CharSequence int boolean ), 0, this, charSequence, n, bl);
    }

    static {
        RobolectricInternals.classInitializing(BaseInputConnection.class);
    }

    public /* synthetic */ BaseInputConnection() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BaseInputConnection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

