/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AbsSeekBar;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RatingBar
extends AbsSeekBar
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int mNumStars;
    private int mProgressOnStartTracking;
    private OnRatingBarChangeListener mOnRatingBarChangeListener;

    private void $$robo$$android_widget_RatingBar$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_RatingBar$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mNumStars = 5;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RatingBar, defStyleAttr, defStyleRes);
        int numStars = a.getInt(0, this.mNumStars);
        this.setIsIndicator(a.getBoolean(3, !this.mIsUserSeekable));
        float rating = a.getFloat(1, -1.0f);
        float stepSize = a.getFloat(2, -1.0f);
        a.recycle();
        if (numStars > 0 && numStars != this.mNumStars) {
            this.setNumStars(numStars);
        }
        if (stepSize >= 0.0f) {
            this.setStepSize(stepSize);
        } else {
            this.setStepSize(0.5f);
        }
        if (rating >= 0.0f) {
            this.setRating(rating);
        }
        this.mTouchProgressOffset = 1.1f;
    }

    private void $$robo$$android_widget_RatingBar$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_RatingBar$__constructor__(Context context) {
    }

    private final void $$robo$$android_widget_RatingBar$setOnRatingBarChangeListener(OnRatingBarChangeListener listener) {
        this.mOnRatingBarChangeListener = listener;
    }

    private final OnRatingBarChangeListener $$robo$$android_widget_RatingBar$getOnRatingBarChangeListener() {
        return this.mOnRatingBarChangeListener;
    }

    private final void $$robo$$android_widget_RatingBar$setIsIndicator(boolean isIndicator) {
        this.mIsUserSeekable = !isIndicator;
        this.setFocusable(!isIndicator);
    }

    private final boolean $$robo$$android_widget_RatingBar$isIndicator() {
        return !this.mIsUserSeekable;
    }

    private final void $$robo$$android_widget_RatingBar$setNumStars(int numStars) {
        if (numStars <= 0) {
            return;
        }
        this.mNumStars = numStars;
        this.requestLayout();
    }

    private final int $$robo$$android_widget_RatingBar$getNumStars() {
        return this.mNumStars;
    }

    private final void $$robo$$android_widget_RatingBar$setRating(float rating) {
        this.setProgress(Math.round(rating * this.getProgressPerStar()));
    }

    private final float $$robo$$android_widget_RatingBar$getRating() {
        return (float)this.getProgress() / this.getProgressPerStar();
    }

    private final void $$robo$$android_widget_RatingBar$setStepSize(float stepSize) {
        if (stepSize <= 0.0f) {
            return;
        }
        float newMax = (float)this.mNumStars / stepSize;
        int newProgress = (int)(newMax / (float)this.getMax() * (float)this.getProgress());
        this.setMax((int)newMax);
        this.setProgress(newProgress);
    }

    private final float $$robo$$android_widget_RatingBar$getStepSize() {
        return (float)this.getNumStars() / (float)this.getMax();
    }

    private final float $$robo$$android_widget_RatingBar$getProgressPerStar() {
        if (this.mNumStars > 0) {
            return 1.0f * (float)this.getMax() / (float)this.mNumStars;
        }
        return 1.0f;
    }

    private final Shape $$robo$$android_widget_RatingBar$getDrawableShape() {
        return new RectShape();
    }

    private final void $$robo$$android_widget_RatingBar$onProgressRefresh(float scale, boolean fromUser, int progress) {
        super.onProgressRefresh(scale, fromUser, progress);
        this.updateSecondaryProgress(progress);
        if (!fromUser) {
            this.dispatchRatingChange(false);
        }
    }

    private final void $$robo$$android_widget_RatingBar$updateSecondaryProgress(int progress) {
        float ratio = this.getProgressPerStar();
        if (ratio > 0.0f) {
            float progressInStars = (float)progress / ratio;
            int secondaryProgress = (int)(Math.ceil(progressInStars) * (double)ratio);
            this.setSecondaryProgress(secondaryProgress);
        }
    }

    private final synchronized void $$robo$$android_widget_RatingBar$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mSampleTile != null) {
            int width = this.mSampleTile.getWidth() * this.mNumStars;
            this.setMeasuredDimension(RatingBar.resolveSizeAndState(width, widthMeasureSpec, 0), this.getMeasuredHeight());
        }
    }

    private final void $$robo$$android_widget_RatingBar$onStartTrackingTouch() {
        this.mProgressOnStartTracking = this.getProgress();
        super.onStartTrackingTouch();
    }

    private final void $$robo$$android_widget_RatingBar$onStopTrackingTouch() {
        super.onStopTrackingTouch();
        if (this.getProgress() != this.mProgressOnStartTracking) {
            this.dispatchRatingChange(true);
        }
    }

    private final void $$robo$$android_widget_RatingBar$onKeyChange() {
        super.onKeyChange();
        this.dispatchRatingChange(true);
    }

    private final void $$robo$$android_widget_RatingBar$dispatchRatingChange(boolean fromUser) {
        if (this.mOnRatingBarChangeListener != null) {
            this.mOnRatingBarChangeListener.onRatingChanged(this, this.getRating(), fromUser);
        }
    }

    private final synchronized void $$robo$$android_widget_RatingBar$setMax(int max) {
        if (max <= 0) {
            return;
        }
        super.setMax(max);
    }

    private final CharSequence $$robo$$android_widget_RatingBar$getAccessibilityClassName() {
        return RatingBar.class.getName();
    }

    private final void $$robo$$android_widget_RatingBar$onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        if (this.canUserSetProgress()) {
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SET_PROGRESS);
        }
    }

    private final boolean $$robo$$android_widget_RatingBar$canUserSetProgress() {
        return super.canUserSetProgress() && !this.isIndicator();
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_RatingBar$__constructor__(context, attributeSet, n);
    }

    public RatingBar(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RatingBar$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_RatingBar$__constructor__(context, attributeSet, n, n2);
    }

    public RatingBar(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RatingBar$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_RatingBar$__constructor__(context, attributeSet);
    }

    public RatingBar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842876);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RatingBar$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_RatingBar$__constructor__(context);
    }

    public RatingBar(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RatingBar$__constructor__(android.content.Context ), 0, this, context);
    }

    public void setOnRatingBarChangeListener(OnRatingBarChangeListener onRatingBarChangeListener) {
        InvokeDynamicSupport.bootstrap("setOnRatingBarChangeListener", $$robo$$android_widget_RatingBar$setOnRatingBarChangeListener(android.widget.RatingBar$OnRatingBarChangeListener ), 0, this, onRatingBarChangeListener);
    }

    public OnRatingBarChangeListener getOnRatingBarChangeListener() {
        return InvokeDynamicSupport.bootstrap("getOnRatingBarChangeListener", $$robo$$android_widget_RatingBar$getOnRatingBarChangeListener(), 0, this);
    }

    public void setIsIndicator(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsIndicator", $$robo$$android_widget_RatingBar$setIsIndicator(boolean ), 0, this, bl);
    }

    public boolean isIndicator() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIndicator", $$robo$$android_widget_RatingBar$isIndicator(), 0, this);
    }

    public void setNumStars(int n) {
        InvokeDynamicSupport.bootstrap("setNumStars", $$robo$$android_widget_RatingBar$setNumStars(int ), 0, this, n);
    }

    public int getNumStars() {
        return (int)InvokeDynamicSupport.bootstrap("getNumStars", $$robo$$android_widget_RatingBar$getNumStars(), 0, this);
    }

    public void setRating(float f) {
        InvokeDynamicSupport.bootstrap("setRating", $$robo$$android_widget_RatingBar$setRating(float ), 0, this, f);
    }

    public float getRating() {
        return (float)InvokeDynamicSupport.bootstrap("getRating", $$robo$$android_widget_RatingBar$getRating(), 0, this);
    }

    public void setStepSize(float f) {
        InvokeDynamicSupport.bootstrap("setStepSize", $$robo$$android_widget_RatingBar$setStepSize(float ), 0, this, f);
    }

    public float getStepSize() {
        return (float)InvokeDynamicSupport.bootstrap("getStepSize", $$robo$$android_widget_RatingBar$getStepSize(), 0, this);
    }

    private float getProgressPerStar() {
        return (float)InvokeDynamicSupport.bootstrap("getProgressPerStar", $$robo$$android_widget_RatingBar$getProgressPerStar(), 0, this);
    }

    @Override
    Shape getDrawableShape() {
        return InvokeDynamicSupport.bootstrap("getDrawableShape", $$robo$$android_widget_RatingBar$getDrawableShape(), 0, this);
    }

    @Override
    void onProgressRefresh(float f, boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("onProgressRefresh", $$robo$$android_widget_RatingBar$onProgressRefresh(float boolean int ), 0, this, f, bl, n);
    }

    private void updateSecondaryProgress(int n) {
        InvokeDynamicSupport.bootstrap("updateSecondaryProgress", $$robo$$android_widget_RatingBar$updateSecondaryProgress(int ), 0, this, n);
    }

    @Override
    protected synchronized void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_RatingBar$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    void onStartTrackingTouch() {
        InvokeDynamicSupport.bootstrap("onStartTrackingTouch", $$robo$$android_widget_RatingBar$onStartTrackingTouch(), 0, this);
    }

    @Override
    void onStopTrackingTouch() {
        InvokeDynamicSupport.bootstrap("onStopTrackingTouch", $$robo$$android_widget_RatingBar$onStopTrackingTouch(), 0, this);
    }

    @Override
    void onKeyChange() {
        InvokeDynamicSupport.bootstrap("onKeyChange", $$robo$$android_widget_RatingBar$onKeyChange(), 0, this);
    }

    void dispatchRatingChange(boolean bl) {
        InvokeDynamicSupport.bootstrap("dispatchRatingChange", $$robo$$android_widget_RatingBar$dispatchRatingChange(boolean ), 0, this, bl);
    }

    @Override
    public synchronized void setMax(int n) {
        InvokeDynamicSupport.bootstrap("setMax", $$robo$$android_widget_RatingBar$setMax(int ), 0, this, n);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_RatingBar$getAccessibilityClassName(), 0, this);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoInternal", $$robo$$android_widget_RatingBar$onInitializeAccessibilityNodeInfoInternal(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    @Override
    boolean canUserSetProgress() {
        return (boolean)InvokeDynamicSupport.bootstrap("canUserSetProgress", $$robo$$android_widget_RatingBar$canUserSetProgress(), 0, this);
    }

    public /* synthetic */ RatingBar() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RatingBar)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnRatingBarChangeListener
    extends InstrumentedInterface {
        public void onRatingChanged(RatingBar var1, float var2, boolean var3);
    }
}

