/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.android.internal.widget.ScrollBarUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ScrollBarDrawable
extends Drawable
implements Drawable.Callback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Drawable mVerticalTrack;
    private Drawable mHorizontalTrack;
    private Drawable mVerticalThumb;
    private Drawable mHorizontalThumb;
    private int mRange;
    private int mOffset;
    private int mExtent;
    private boolean mVertical;
    private boolean mBoundsChanged;
    private boolean mRangeChanged;
    private boolean mAlwaysDrawHorizontalTrack;
    private boolean mAlwaysDrawVerticalTrack;
    private boolean mMutated;
    private int mAlpha;
    private boolean mHasSetAlpha;
    private ColorFilter mColorFilter;
    private boolean mHasSetColorFilter;

    private void $$robo$$android_widget_ScrollBarDrawable$__constructor__() {
        this.mAlpha = 255;
    }

    private final void $$robo$$android_widget_ScrollBarDrawable$setAlwaysDrawHorizontalTrack(boolean alwaysDrawTrack) {
        this.mAlwaysDrawHorizontalTrack = alwaysDrawTrack;
    }

    private final void $$robo$$android_widget_ScrollBarDrawable$setAlwaysDrawVerticalTrack(boolean alwaysDrawTrack) {
        this.mAlwaysDrawVerticalTrack = alwaysDrawTrack;
    }

    private final boolean $$robo$$android_widget_ScrollBarDrawable$getAlwaysDrawVerticalTrack() {
        return this.mAlwaysDrawVerticalTrack;
    }

    private final boolean $$robo$$android_widget_ScrollBarDrawable$getAlwaysDrawHorizontalTrack() {
        return this.mAlwaysDrawHorizontalTrack;
    }

    private final void $$robo$$android_widget_ScrollBarDrawable$setParameters(int range, int offset, int extent, boolean vertical) {
        if (this.mVertical != vertical) {
            this.mVertical = vertical;
            this.mBoundsChanged = true;
        }
        if (this.mRange != range || this.mOffset != offset || this.mExtent != extent) {
            this.mRange = range;
            this.mOffset = offset;
            this.mExtent = extent;
            this.mRangeChanged = true;
        }
    }

    private final void $$robo$$android_widget_ScrollBarDrawable$draw(Canvas canvas) {
        boolean vertical = this.mVertical;
        int extent = this.mExtent;
        int range = this.mRange;
        boolean drawTrack = true;
        boolean drawThumb = true;
        if (extent <= 0 || range <= extent) {
            drawTrack = vertical ? this.mAlwaysDrawVerticalTrack : this.mAlwaysDrawHorizontalTrack;
            drawThumb = false;
        }
        Rect r = this.getBounds();
        if (canvas.quickReject(r.left, r.top, r.right, r.bottom, Canvas.EdgeType.AA)) {
            return;
        }
        if (drawTrack) {
            this.drawTrack(canvas, r, vertical);
        }
        if (drawThumb) {
            int scrollBarLength = vertical ? r.height() : r.width();
            int thickness = vertical ? r.width() : r.height();
            int thumbLength = ScrollBarUtils.getThumbLength(scrollBarLength, thickness, extent, range);
            int thumbOffset = ScrollBarUtils.getThumbOffset(scrollBarLength, thumbLength, extent, range, this.mOffset);
            this.drawThumb(canvas, r, thumbOffset, thumbLength, vertical);
        }
    }

    private final void $$robo$$android_widget_ScrollBarDrawable$onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mBoundsChanged = true;
    }

    private final boolean $$robo$$android_widget_ScrollBarDrawable$isStateful() {
        return this.mVerticalTrack != null && this.mVerticalTrack.isStateful() || this.mVerticalThumb != null && this.mVerticalThumb.isStateful() || this.mHorizontalTrack != null && this.mHorizontalTrack.isStateful() || this.mHorizontalThumb != null && this.mHorizontalThumb.isStateful() || super.isStateful();
    }

    private final boolean $$robo$$android_widget_ScrollBarDrawable$onStateChange(int[] state) {
        boolean changed = super.onStateChange(state);
        if (this.mVerticalTrack != null) {
            changed |= this.mVerticalTrack.setState(state);
        }
        if (this.mVerticalThumb != null) {
            changed |= this.mVerticalThumb.setState(state);
        }
        if (this.mHorizontalTrack != null) {
            changed |= this.mHorizontalTrack.setState(state);
        }
        if (this.mHorizontalThumb != null) {
            changed |= this.mHorizontalThumb.setState(state);
        }
        return changed;
    }

    private final void $$robo$$android_widget_ScrollBarDrawable$drawTrack(Canvas canvas, Rect bounds, boolean vertical) {
        Drawable track = vertical ? this.mVerticalTrack : this.mHorizontalTrack;
        if (track != null) {
            if (this.mBoundsChanged) {
                track.setBounds(bounds);
            }
            track.draw(canvas);
        }
    }

    private final void $$robo$$android_widget_ScrollBarDrawable$drawThumb(Canvas canvas, Rect bounds, int offset, int length, boolean vertical) {
        boolean changed;
        boolean bl = changed = this.mRangeChanged || this.mBoundsChanged;
        if (vertical) {
            if (this.mVerticalThumb != null) {
                Drawable thumb = this.mVerticalThumb;
                if (changed) {
                    thumb.setBounds(bounds.left, bounds.top + offset, bounds.right, bounds.top + offset + length);
                }
                thumb.draw(canvas);
            }
        } else if (this.mHorizontalThumb != null) {
            Drawable thumb = this.mHorizontalThumb;
            if (changed) {
                thumb.setBounds(bounds.left + offset, bounds.top, bounds.left + offset + length, bounds.bottom);
            }
            thumb.draw(canvas);
        }
    }

    private final void $$robo$$android_widget_ScrollBarDrawable$setVerticalThumbDrawable(Drawable thumb) {
        if (this.mVerticalThumb != null) {
            this.mVerticalThumb.setCallback(null);
        }
        this.propagateCurrentState(thumb);
        this.mVerticalThumb = thumb;
    }

    private final void $$robo$$android_widget_ScrollBarDrawable$setVerticalTrackDrawable(Drawable track) {
        if (this.mVerticalTrack != null) {
            this.mVerticalTrack.setCallback(null);
        }
        this.propagateCurrentState(track);
        this.mVerticalTrack = track;
    }

    private final void $$robo$$android_widget_ScrollBarDrawable$setHorizontalThumbDrawable(Drawable thumb) {
        if (this.mHorizontalThumb != null) {
            this.mHorizontalThumb.setCallback(null);
        }
        this.propagateCurrentState(thumb);
        this.mHorizontalThumb = thumb;
    }

    private final void $$robo$$android_widget_ScrollBarDrawable$setHorizontalTrackDrawable(Drawable track) {
        if (this.mHorizontalTrack != null) {
            this.mHorizontalTrack.setCallback(null);
        }
        this.propagateCurrentState(track);
        this.mHorizontalTrack = track;
    }

    private final void $$robo$$android_widget_ScrollBarDrawable$propagateCurrentState(Drawable d) {
        if (d != null) {
            if (this.mMutated) {
                d.mutate();
            }
            d.setState(this.getState());
            d.setCallback(this);
            if (this.mHasSetAlpha) {
                d.setAlpha(this.mAlpha);
            }
            if (this.mHasSetColorFilter) {
                d.setColorFilter(this.mColorFilter);
            }
        }
    }

    private final int $$robo$$android_widget_ScrollBarDrawable$getSize(boolean vertical) {
        if (vertical) {
            return this.mVerticalTrack != null ? this.mVerticalTrack.getIntrinsicWidth() : (this.mVerticalThumb != null ? this.mVerticalThumb.getIntrinsicWidth() : 0);
        }
        return this.mHorizontalTrack != null ? this.mHorizontalTrack.getIntrinsicHeight() : (this.mHorizontalThumb != null ? this.mHorizontalThumb.getIntrinsicHeight() : 0);
    }

    private final ScrollBarDrawable $$robo$$android_widget_ScrollBarDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            if (this.mVerticalTrack != null) {
                this.mVerticalTrack.mutate();
            }
            if (this.mVerticalThumb != null) {
                this.mVerticalThumb.mutate();
            }
            if (this.mHorizontalTrack != null) {
                this.mHorizontalTrack.mutate();
            }
            if (this.mHorizontalThumb != null) {
                this.mHorizontalThumb.mutate();
            }
            this.mMutated = true;
        }
        return this;
    }

    private final void $$robo$$android_widget_ScrollBarDrawable$setAlpha(int alpha) {
        this.mAlpha = alpha;
        this.mHasSetAlpha = true;
        if (this.mVerticalTrack != null) {
            this.mVerticalTrack.setAlpha(alpha);
        }
        if (this.mVerticalThumb != null) {
            this.mVerticalThumb.setAlpha(alpha);
        }
        if (this.mHorizontalTrack != null) {
            this.mHorizontalTrack.setAlpha(alpha);
        }
        if (this.mHorizontalThumb != null) {
            this.mHorizontalThumb.setAlpha(alpha);
        }
    }

    private final int $$robo$$android_widget_ScrollBarDrawable$getAlpha() {
        return this.mAlpha;
    }

    private final void $$robo$$android_widget_ScrollBarDrawable$setColorFilter(ColorFilter colorFilter) {
        this.mColorFilter = colorFilter;
        this.mHasSetColorFilter = true;
        if (this.mVerticalTrack != null) {
            this.mVerticalTrack.setColorFilter(colorFilter);
        }
        if (this.mVerticalThumb != null) {
            this.mVerticalThumb.setColorFilter(colorFilter);
        }
        if (this.mHorizontalTrack != null) {
            this.mHorizontalTrack.setColorFilter(colorFilter);
        }
        if (this.mHorizontalThumb != null) {
            this.mHorizontalThumb.setColorFilter(colorFilter);
        }
    }

    private final ColorFilter $$robo$$android_widget_ScrollBarDrawable$getColorFilter() {
        return this.mColorFilter;
    }

    private final int $$robo$$android_widget_ScrollBarDrawable$getOpacity() {
        return -3;
    }

    private final void $$robo$$android_widget_ScrollBarDrawable$invalidateDrawable(Drawable who) {
        this.invalidateSelf();
    }

    private final void $$robo$$android_widget_ScrollBarDrawable$scheduleDrawable(Drawable who, Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    private final void $$robo$$android_widget_ScrollBarDrawable$unscheduleDrawable(Drawable who, Runnable what) {
        this.unscheduleSelf(what);
    }

    private final String $$robo$$android_widget_ScrollBarDrawable$toString() {
        return "ScrollBarDrawable: range=" + this.mRange + " offset=" + this.mOffset + " extent=" + this.mExtent + (this.mVertical ? " V" : " H");
    }

    private void __constructor__() {
        this.$$robo$$android_widget_ScrollBarDrawable$__constructor__();
    }

    public ScrollBarDrawable() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ScrollBarDrawable$__constructor__(), 0, this);
    }

    public void setAlwaysDrawHorizontalTrack(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAlwaysDrawHorizontalTrack", $$robo$$android_widget_ScrollBarDrawable$setAlwaysDrawHorizontalTrack(boolean ), 0, this, bl);
    }

    public void setAlwaysDrawVerticalTrack(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAlwaysDrawVerticalTrack", $$robo$$android_widget_ScrollBarDrawable$setAlwaysDrawVerticalTrack(boolean ), 0, this, bl);
    }

    public boolean getAlwaysDrawVerticalTrack() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAlwaysDrawVerticalTrack", $$robo$$android_widget_ScrollBarDrawable$getAlwaysDrawVerticalTrack(), 0, this);
    }

    public boolean getAlwaysDrawHorizontalTrack() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAlwaysDrawHorizontalTrack", $$robo$$android_widget_ScrollBarDrawable$getAlwaysDrawHorizontalTrack(), 0, this);
    }

    public void setParameters(int n, int n2, int n3, boolean bl) {
        InvokeDynamicSupport.bootstrap("setParameters", $$robo$$android_widget_ScrollBarDrawable$setParameters(int int int boolean ), 0, this, n, n2, n3, bl);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_widget_ScrollBarDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_widget_ScrollBarDrawable$onBoundsChange(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_widget_ScrollBarDrawable$isStateful(), 0, this);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_widget_ScrollBarDrawable$onStateChange(int[] ), 0, this, nArray);
    }

    private void drawTrack(Canvas canvas, Rect rect, boolean bl) {
        InvokeDynamicSupport.bootstrap("drawTrack", $$robo$$android_widget_ScrollBarDrawable$drawTrack(android.graphics.Canvas android.graphics.Rect boolean ), 0, this, canvas, rect, bl);
    }

    private void drawThumb(Canvas canvas, Rect rect, int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("drawThumb", $$robo$$android_widget_ScrollBarDrawable$drawThumb(android.graphics.Canvas android.graphics.Rect int int boolean ), 0, this, canvas, rect, n, n2, bl);
    }

    public void setVerticalThumbDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setVerticalThumbDrawable", $$robo$$android_widget_ScrollBarDrawable$setVerticalThumbDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setVerticalTrackDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setVerticalTrackDrawable", $$robo$$android_widget_ScrollBarDrawable$setVerticalTrackDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setHorizontalThumbDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setHorizontalThumbDrawable", $$robo$$android_widget_ScrollBarDrawable$setHorizontalThumbDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setHorizontalTrackDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setHorizontalTrackDrawable", $$robo$$android_widget_ScrollBarDrawable$setHorizontalTrackDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    private void propagateCurrentState(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("propagateCurrentState", $$robo$$android_widget_ScrollBarDrawable$propagateCurrentState(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public int getSize(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getSize", $$robo$$android_widget_ScrollBarDrawable$getSize(boolean ), 0, this, bl);
    }

    @Override
    public ScrollBarDrawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_widget_ScrollBarDrawable$mutate(), 0, this);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_widget_ScrollBarDrawable$setAlpha(int ), 0, this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_widget_ScrollBarDrawable$getAlpha(), 0, this);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_widget_ScrollBarDrawable$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    @Override
    public ColorFilter getColorFilter() {
        return InvokeDynamicSupport.bootstrap("getColorFilter", $$robo$$android_widget_ScrollBarDrawable$getColorFilter(), 0, this);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_widget_ScrollBarDrawable$getOpacity(), 0, this);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("invalidateDrawable", $$robo$$android_widget_ScrollBarDrawable$invalidateDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        InvokeDynamicSupport.bootstrap("scheduleDrawable", $$robo$$android_widget_ScrollBarDrawable$scheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable long ), 0, this, drawable2, runnable, l);
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        InvokeDynamicSupport.bootstrap("unscheduleDrawable", $$robo$$android_widget_ScrollBarDrawable$unscheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable ), 0, this, drawable2, runnable);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_widget_ScrollBarDrawable$toString(), 0, this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScrollBarDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

