/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.R;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@Deprecated
public class SlidingDrawer
extends ViewGroup
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int ORIENTATION_HORIZONTAL = 0;
    public static int ORIENTATION_VERTICAL = 1;
    private static int TAP_THRESHOLD = 6;
    private static float MAXIMUM_TAP_VELOCITY = 100.0f;
    private static float MAXIMUM_MINOR_VELOCITY = 150.0f;
    private static float MAXIMUM_MAJOR_VELOCITY = 200.0f;
    private static float MAXIMUM_ACCELERATION = 2000.0f;
    private static int VELOCITY_UNITS = 1000;
    private static int ANIMATION_FRAME_DURATION = 16;
    private static int EXPANDED_FULL_OPEN = -10001;
    private static int COLLAPSED_FULL_CLOSED = -10002;
    private int mHandleId;
    private int mContentId;
    private View mHandle;
    private View mContent;
    private Rect mFrame;
    private Rect mInvalidate;
    private boolean mTracking;
    private boolean mLocked;
    private VelocityTracker mVelocityTracker;
    private boolean mVertical;
    private boolean mExpanded;
    private int mBottomOffset;
    private int mTopOffset;
    private int mHandleHeight;
    private int mHandleWidth;
    private OnDrawerOpenListener mOnDrawerOpenListener;
    private OnDrawerCloseListener mOnDrawerCloseListener;
    private OnDrawerScrollListener mOnDrawerScrollListener;
    private float mAnimatedAcceleration;
    private float mAnimatedVelocity;
    private float mAnimationPosition;
    private long mAnimationLastTime;
    private long mCurrentAnimationTime;
    private int mTouchDelta;
    private boolean mAnimating;
    private boolean mAllowSingleTap;
    private boolean mAnimateOnClick;
    private int mTapThreshold;
    private int mMaximumTapVelocity;
    private int mMaximumMinorVelocity;
    private int mMaximumMajorVelocity;
    private int mMaximumAcceleration;
    private int mVelocityUnits;
    private Runnable mSlidingRunnable;

    private void $$robo$$android_widget_SlidingDrawer$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_SlidingDrawer$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_SlidingDrawer$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mFrame = new Rect();
        this.mInvalidate = new Rect();
        this.mSlidingRunnable = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SlidingDrawer this$0;

            private void $$robo$$android_widget_SlidingDrawer_1$__constructor__(SlidingDrawer this$0) {
            }

            private final void $$robo$$android_widget_SlidingDrawer_1$run() {
                this.this$0.doAnimation();
            }

            private void __constructor__(SlidingDrawer slidingDrawer) {
                this.$$robo$$android_widget_SlidingDrawer_1$__constructor__(slidingDrawer);
            }
            {
                this.this$0 = slidingDrawer;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SlidingDrawer_1$__constructor__(android.widget.SlidingDrawer ), 0, this, slidingDrawer);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_SlidingDrawer_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SlidingDrawer, defStyleAttr, defStyleRes);
        int orientation = a.getInt(0, 1);
        this.mVertical = orientation == 1;
        this.mBottomOffset = (int)a.getDimension(1, 0.0f);
        this.mTopOffset = (int)a.getDimension(2, 0.0f);
        this.mAllowSingleTap = a.getBoolean(3, true);
        this.mAnimateOnClick = a.getBoolean(6, true);
        int handleId = a.getResourceId(4, 0);
        if (handleId == 0) {
            throw new IllegalArgumentException("The handle attribute is required and must refer to a valid child.");
        }
        int contentId = a.getResourceId(5, 0);
        if (contentId == 0) {
            throw new IllegalArgumentException("The content attribute is required and must refer to a valid child.");
        }
        if (handleId == contentId) {
            throw new IllegalArgumentException("The content and handle attributes must refer to different children.");
        }
        this.mHandleId = handleId;
        this.mContentId = contentId;
        float density = this.getResources().getDisplayMetrics().density;
        this.mTapThreshold = (int)(6.0f * density + 0.5f);
        this.mMaximumTapVelocity = (int)(100.0f * density + 0.5f);
        this.mMaximumMinorVelocity = (int)(150.0f * density + 0.5f);
        this.mMaximumMajorVelocity = (int)(200.0f * density + 0.5f);
        this.mMaximumAcceleration = (int)(2000.0f * density + 0.5f);
        this.mVelocityUnits = (int)(1000.0f * density + 0.5f);
        a.recycle();
        this.setAlwaysDrawnWithCacheEnabled(false);
    }

    private final void $$robo$$android_widget_SlidingDrawer$onFinishInflate() {
        this.mHandle = this.findViewById(this.mHandleId);
        if (this.mHandle == null) {
            throw new IllegalArgumentException("The handle attribute is must refer to an existing child.");
        }
        this.mHandle.setOnClickListener(new DrawerToggler(this));
        this.mContent = this.findViewById(this.mContentId);
        if (this.mContent == null) {
            throw new IllegalArgumentException("The content attribute is must refer to an existing child.");
        }
        this.mContent.setVisibility(8);
    }

    private final void $$robo$$android_widget_SlidingDrawer$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpecMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize(heightMeasureSpec);
        if (widthSpecMode == 0 || heightSpecMode == 0) {
            throw new RuntimeException("SlidingDrawer cannot have UNSPECIFIED dimensions");
        }
        View handle = this.mHandle;
        this.measureChild(handle, widthMeasureSpec, heightMeasureSpec);
        if (this.mVertical) {
            int height = heightSpecSize - handle.getMeasuredHeight() - this.mTopOffset;
            this.mContent.measure(View.MeasureSpec.makeMeasureSpec(widthSpecSize, 0x40000000), View.MeasureSpec.makeMeasureSpec(height, 0x40000000));
        } else {
            int width = widthSpecSize - handle.getMeasuredWidth() - this.mTopOffset;
            this.mContent.measure(View.MeasureSpec.makeMeasureSpec(width, 0x40000000), View.MeasureSpec.makeMeasureSpec(heightSpecSize, 0x40000000));
        }
        this.setMeasuredDimension(widthSpecSize, heightSpecSize);
    }

    private final void $$robo$$android_widget_SlidingDrawer$dispatchDraw(Canvas canvas) {
        long drawingTime = this.getDrawingTime();
        View handle = this.mHandle;
        boolean isVertical = this.mVertical;
        this.drawChild(canvas, handle, drawingTime);
        if (this.mTracking || this.mAnimating) {
            Bitmap cache = this.mContent.getDrawingCache();
            if (cache != null) {
                if (isVertical) {
                    canvas.drawBitmap(cache, 0.0f, handle.getBottom(), null);
                } else {
                    canvas.drawBitmap(cache, handle.getRight(), 0.0f, null);
                }
            } else {
                canvas.save();
                canvas.translate(isVertical ? 0.0f : (float)(handle.getLeft() - this.mTopOffset), isVertical ? (float)(handle.getTop() - this.mTopOffset) : 0.0f);
                this.drawChild(canvas, this.mContent, drawingTime);
                canvas.restore();
            }
        } else if (this.mExpanded) {
            this.drawChild(canvas, this.mContent, drawingTime);
        }
    }

    private final void $$robo$$android_widget_SlidingDrawer$onLayout(boolean changed, int l, int t, int r, int b) {
        int childTop;
        int childLeft;
        if (this.mTracking) {
            return;
        }
        int width = r - l;
        int height = b - t;
        View handle = this.mHandle;
        int childWidth = handle.getMeasuredWidth();
        int childHeight = handle.getMeasuredHeight();
        View content = this.mContent;
        if (this.mVertical) {
            childLeft = (width - childWidth) / 2;
            childTop = this.mExpanded ? this.mTopOffset : height - childHeight + this.mBottomOffset;
            content.layout(0, this.mTopOffset + childHeight, content.getMeasuredWidth(), this.mTopOffset + childHeight + content.getMeasuredHeight());
        } else {
            childLeft = this.mExpanded ? this.mTopOffset : width - childWidth + this.mBottomOffset;
            childTop = (height - childHeight) / 2;
            content.layout(this.mTopOffset + childWidth, 0, this.mTopOffset + childWidth + content.getMeasuredWidth(), content.getMeasuredHeight());
        }
        handle.layout(childLeft, childTop, childLeft + childWidth, childTop + childHeight);
        this.mHandleHeight = handle.getHeight();
        this.mHandleWidth = handle.getWidth();
    }

    private final boolean $$robo$$android_widget_SlidingDrawer$onInterceptTouchEvent(MotionEvent event) {
        if (this.mLocked) {
            return false;
        }
        int action = event.getAction();
        float x = event.getX();
        float y = event.getY();
        Rect frame = this.mFrame;
        View handle = this.mHandle;
        handle.getHitRect(frame);
        if (!this.mTracking && !frame.contains((int)x, (int)y)) {
            return false;
        }
        if (action == 0) {
            this.mTracking = true;
            handle.setPressed(true);
            this.prepareContent();
            if (this.mOnDrawerScrollListener != null) {
                this.mOnDrawerScrollListener.onScrollStarted();
            }
            if (this.mVertical) {
                int top = this.mHandle.getTop();
                this.mTouchDelta = (int)y - top;
                this.prepareTracking(top);
            } else {
                int left = this.mHandle.getLeft();
                this.mTouchDelta = (int)x - left;
                this.prepareTracking(left);
            }
            this.mVelocityTracker.addMovement(event);
        }
        return true;
    }

    private final boolean $$robo$$android_widget_SlidingDrawer$onTouchEvent(MotionEvent event) {
        if (this.mLocked) {
            return true;
        }
        if (this.mTracking) {
            this.mVelocityTracker.addMovement(event);
            int action = event.getAction();
            switch (action) {
                case 2: {
                    this.moveHandle((int)(this.mVertical ? event.getY() : event.getX()) - this.mTouchDelta);
                    break;
                }
                case 1: 
                case 3: {
                    boolean negative;
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    velocityTracker.computeCurrentVelocity(this.mVelocityUnits);
                    float yVelocity = velocityTracker.getYVelocity();
                    float xVelocity = velocityTracker.getXVelocity();
                    boolean vertical = this.mVertical;
                    if (vertical) {
                        boolean bl = negative = yVelocity < 0.0f;
                        if (xVelocity < 0.0f) {
                            xVelocity = -xVelocity;
                        }
                        if (xVelocity > (float)this.mMaximumMinorVelocity) {
                            xVelocity = this.mMaximumMinorVelocity;
                        }
                    } else {
                        boolean bl = negative = xVelocity < 0.0f;
                        if (yVelocity < 0.0f) {
                            yVelocity = -yVelocity;
                        }
                        if (yVelocity > (float)this.mMaximumMinorVelocity) {
                            yVelocity = this.mMaximumMinorVelocity;
                        }
                    }
                    float velocity = (float)Math.hypot(xVelocity, yVelocity);
                    if (negative) {
                        velocity = -velocity;
                    }
                    int top = this.mHandle.getTop();
                    int left = this.mHandle.getLeft();
                    if (Math.abs(velocity) < (float)this.mMaximumTapVelocity) {
                        if (vertical ? this.mExpanded && top < this.mTapThreshold + this.mTopOffset || !this.mExpanded && top > this.mBottomOffset + this.mBottom - this.mTop - this.mHandleHeight - this.mTapThreshold : this.mExpanded && left < this.mTapThreshold + this.mTopOffset || !this.mExpanded && left > this.mBottomOffset + this.mRight - this.mLeft - this.mHandleWidth - this.mTapThreshold) {
                            if (this.mAllowSingleTap) {
                                this.playSoundEffect(0);
                                if (this.mExpanded) {
                                    this.animateClose(vertical ? top : left);
                                    break;
                                }
                                this.animateOpen(vertical ? top : left);
                                break;
                            }
                            this.performFling(vertical ? top : left, velocity, false);
                            break;
                        }
                        this.performFling(vertical ? top : left, velocity, false);
                        break;
                    }
                    this.performFling(vertical ? top : left, velocity, false);
                }
            }
        }
        return this.mTracking || this.mAnimating || super.onTouchEvent(event);
    }

    private final void $$robo$$android_widget_SlidingDrawer$animateClose(int position) {
        this.prepareTracking(position);
        this.performFling(position, this.mMaximumAcceleration, true);
    }

    private final void $$robo$$android_widget_SlidingDrawer$animateOpen(int position) {
        this.prepareTracking(position);
        this.performFling(position, -this.mMaximumAcceleration, true);
    }

    private final void $$robo$$android_widget_SlidingDrawer$performFling(int position, float velocity, boolean always) {
        long now;
        this.mAnimationPosition = position;
        this.mAnimatedVelocity = velocity;
        if (this.mExpanded) {
            if (always || velocity > (float)this.mMaximumMajorVelocity || position > this.mTopOffset + (this.mVertical ? this.mHandleHeight : this.mHandleWidth) && velocity > (float)(-this.mMaximumMajorVelocity)) {
                this.mAnimatedAcceleration = this.mMaximumAcceleration;
                if (velocity < 0.0f) {
                    this.mAnimatedVelocity = 0.0f;
                }
            } else {
                this.mAnimatedAcceleration = -this.mMaximumAcceleration;
                if (velocity > 0.0f) {
                    this.mAnimatedVelocity = 0.0f;
                }
            }
        } else if (!always && (velocity > (float)this.mMaximumMajorVelocity || position > (this.mVertical ? this.getHeight() : this.getWidth()) / 2 && velocity > (float)(-this.mMaximumMajorVelocity))) {
            this.mAnimatedAcceleration = this.mMaximumAcceleration;
            if (velocity < 0.0f) {
                this.mAnimatedVelocity = 0.0f;
            }
        } else {
            this.mAnimatedAcceleration = -this.mMaximumAcceleration;
            if (velocity > 0.0f) {
                this.mAnimatedVelocity = 0.0f;
            }
        }
        this.mAnimationLastTime = now = SystemClock.uptimeMillis();
        this.mCurrentAnimationTime = now + 16L;
        this.mAnimating = true;
        this.removeCallbacks(this.mSlidingRunnable);
        this.postDelayed(this.mSlidingRunnable, 16L);
        this.stopTracking();
    }

    private final void $$robo$$android_widget_SlidingDrawer$prepareTracking(int position) {
        boolean opening;
        this.mTracking = true;
        this.mVelocityTracker = VelocityTracker.obtain();
        boolean bl = opening = !this.mExpanded;
        if (opening) {
            long now;
            this.mAnimatedAcceleration = this.mMaximumAcceleration;
            this.mAnimatedVelocity = this.mMaximumMajorVelocity;
            this.mAnimationPosition = this.mBottomOffset + (this.mVertical ? this.getHeight() - this.mHandleHeight : this.getWidth() - this.mHandleWidth);
            this.moveHandle((int)this.mAnimationPosition);
            this.mAnimating = true;
            this.removeCallbacks(this.mSlidingRunnable);
            this.mAnimationLastTime = now = SystemClock.uptimeMillis();
            this.mCurrentAnimationTime = now + 16L;
            this.mAnimating = true;
        } else {
            if (this.mAnimating) {
                this.mAnimating = false;
                this.removeCallbacks(this.mSlidingRunnable);
            }
            this.moveHandle(position);
        }
    }

    private final void $$robo$$android_widget_SlidingDrawer$moveHandle(int position) {
        View handle = this.mHandle;
        if (this.mVertical) {
            if (position == -10001) {
                handle.offsetTopAndBottom(this.mTopOffset - handle.getTop());
                this.invalidate();
            } else if (position == -10002) {
                handle.offsetTopAndBottom(this.mBottomOffset + this.mBottom - this.mTop - this.mHandleHeight - handle.getTop());
                this.invalidate();
            } else {
                int top = handle.getTop();
                int deltaY = position - top;
                if (position < this.mTopOffset) {
                    deltaY = this.mTopOffset - top;
                } else if (deltaY > this.mBottomOffset + this.mBottom - this.mTop - this.mHandleHeight - top) {
                    deltaY = this.mBottomOffset + this.mBottom - this.mTop - this.mHandleHeight - top;
                }
                handle.offsetTopAndBottom(deltaY);
                Rect frame = this.mFrame;
                Rect region = this.mInvalidate;
                handle.getHitRect(frame);
                region.set(frame);
                region.union(frame.left, frame.top - deltaY, frame.right, frame.bottom - deltaY);
                region.union(0, frame.bottom - deltaY, this.getWidth(), frame.bottom - deltaY + this.mContent.getHeight());
                this.invalidate(region);
            }
        } else if (position == -10001) {
            handle.offsetLeftAndRight(this.mTopOffset - handle.getLeft());
            this.invalidate();
        } else if (position == -10002) {
            handle.offsetLeftAndRight(this.mBottomOffset + this.mRight - this.mLeft - this.mHandleWidth - handle.getLeft());
            this.invalidate();
        } else {
            int left = handle.getLeft();
            int deltaX = position - left;
            if (position < this.mTopOffset) {
                deltaX = this.mTopOffset - left;
            } else if (deltaX > this.mBottomOffset + this.mRight - this.mLeft - this.mHandleWidth - left) {
                deltaX = this.mBottomOffset + this.mRight - this.mLeft - this.mHandleWidth - left;
            }
            handle.offsetLeftAndRight(deltaX);
            Rect frame = this.mFrame;
            Rect region = this.mInvalidate;
            handle.getHitRect(frame);
            region.set(frame);
            region.union(frame.left - deltaX, frame.top, frame.right - deltaX, frame.bottom);
            region.union(frame.right - deltaX, 0, frame.right - deltaX + this.mContent.getWidth(), this.getHeight());
            this.invalidate(region);
        }
    }

    private final void $$robo$$android_widget_SlidingDrawer$prepareContent() {
        if (this.mAnimating) {
            return;
        }
        View content = this.mContent;
        if (content.isLayoutRequested()) {
            if (this.mVertical) {
                int childHeight = this.mHandleHeight;
                int height = this.mBottom - this.mTop - childHeight - this.mTopOffset;
                content.measure(View.MeasureSpec.makeMeasureSpec(this.mRight - this.mLeft, 0x40000000), View.MeasureSpec.makeMeasureSpec(height, 0x40000000));
                content.layout(0, this.mTopOffset + childHeight, content.getMeasuredWidth(), this.mTopOffset + childHeight + content.getMeasuredHeight());
            } else {
                int childWidth = this.mHandle.getWidth();
                int width = this.mRight - this.mLeft - childWidth - this.mTopOffset;
                content.measure(View.MeasureSpec.makeMeasureSpec(width, 0x40000000), View.MeasureSpec.makeMeasureSpec(this.mBottom - this.mTop, 0x40000000));
                content.layout(childWidth + this.mTopOffset, 0, this.mTopOffset + childWidth + content.getMeasuredWidth(), content.getMeasuredHeight());
            }
        }
        content.getViewTreeObserver().dispatchOnPreDraw();
        if (!content.isHardwareAccelerated()) {
            content.buildDrawingCache();
        }
        content.setVisibility(8);
    }

    private final void $$robo$$android_widget_SlidingDrawer$stopTracking() {
        this.mHandle.setPressed(false);
        this.mTracking = false;
        if (this.mOnDrawerScrollListener != null) {
            this.mOnDrawerScrollListener.onScrollEnded();
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private final void $$robo$$android_widget_SlidingDrawer$doAnimation() {
        if (this.mAnimating) {
            this.incrementAnimation();
            int n = this.mVertical ? this.getHeight() : this.getWidth();
            if (this.mAnimationPosition >= (float)(this.mBottomOffset + n - 1)) {
                this.mAnimating = false;
                this.closeDrawer();
            } else if (this.mAnimationPosition < (float)this.mTopOffset) {
                this.mAnimating = false;
                this.openDrawer();
            } else {
                this.moveHandle((int)this.mAnimationPosition);
                this.mCurrentAnimationTime += 16L;
                this.postDelayed(this.mSlidingRunnable, 16L);
            }
        }
    }

    private final void $$robo$$android_widget_SlidingDrawer$incrementAnimation() {
        long now = SystemClock.uptimeMillis();
        float t = (float)(now - this.mAnimationLastTime) / 1000.0f;
        float position = this.mAnimationPosition;
        float v = this.mAnimatedVelocity;
        float a = this.mAnimatedAcceleration;
        this.mAnimationPosition = position + v * t + 0.5f * a * t * t;
        this.mAnimatedVelocity = v + a * t;
        this.mAnimationLastTime = now;
    }

    private final void $$robo$$android_widget_SlidingDrawer$toggle() {
        if (!this.mExpanded) {
            this.openDrawer();
        } else {
            this.closeDrawer();
        }
        this.invalidate();
        this.requestLayout();
    }

    private final void $$robo$$android_widget_SlidingDrawer$animateToggle() {
        if (!this.mExpanded) {
            this.animateOpen();
        } else {
            this.animateClose();
        }
    }

    private final void $$robo$$android_widget_SlidingDrawer$open() {
        this.openDrawer();
        this.invalidate();
        this.requestLayout();
        this.sendAccessibilityEvent(32);
    }

    private final void $$robo$$android_widget_SlidingDrawer$close() {
        this.closeDrawer();
        this.invalidate();
        this.requestLayout();
    }

    private final void $$robo$$android_widget_SlidingDrawer$animateClose() {
        this.prepareContent();
        OnDrawerScrollListener scrollListener = this.mOnDrawerScrollListener;
        if (scrollListener != null) {
            scrollListener.onScrollStarted();
        }
        this.animateClose(this.mVertical ? this.mHandle.getTop() : this.mHandle.getLeft());
        if (scrollListener != null) {
            scrollListener.onScrollEnded();
        }
    }

    private final void $$robo$$android_widget_SlidingDrawer$animateOpen() {
        this.prepareContent();
        OnDrawerScrollListener scrollListener = this.mOnDrawerScrollListener;
        if (scrollListener != null) {
            scrollListener.onScrollStarted();
        }
        this.animateOpen(this.mVertical ? this.mHandle.getTop() : this.mHandle.getLeft());
        this.sendAccessibilityEvent(32);
        if (scrollListener != null) {
            scrollListener.onScrollEnded();
        }
    }

    private final CharSequence $$robo$$android_widget_SlidingDrawer$getAccessibilityClassName() {
        return SlidingDrawer.class.getName();
    }

    private final void $$robo$$android_widget_SlidingDrawer$closeDrawer() {
        this.moveHandle(-10002);
        this.mContent.setVisibility(8);
        this.mContent.destroyDrawingCache();
        if (!this.mExpanded) {
            return;
        }
        this.mExpanded = false;
        if (this.mOnDrawerCloseListener != null) {
            this.mOnDrawerCloseListener.onDrawerClosed();
        }
    }

    private final void $$robo$$android_widget_SlidingDrawer$openDrawer() {
        this.moveHandle(-10001);
        this.mContent.setVisibility(0);
        if (this.mExpanded) {
            return;
        }
        this.mExpanded = true;
        if (this.mOnDrawerOpenListener != null) {
            this.mOnDrawerOpenListener.onDrawerOpened();
        }
    }

    private final void $$robo$$android_widget_SlidingDrawer$setOnDrawerOpenListener(OnDrawerOpenListener onDrawerOpenListener) {
        this.mOnDrawerOpenListener = onDrawerOpenListener;
    }

    private final void $$robo$$android_widget_SlidingDrawer$setOnDrawerCloseListener(OnDrawerCloseListener onDrawerCloseListener) {
        this.mOnDrawerCloseListener = onDrawerCloseListener;
    }

    private final void $$robo$$android_widget_SlidingDrawer$setOnDrawerScrollListener(OnDrawerScrollListener onDrawerScrollListener) {
        this.mOnDrawerScrollListener = onDrawerScrollListener;
    }

    private final View $$robo$$android_widget_SlidingDrawer$getHandle() {
        return this.mHandle;
    }

    private final View $$robo$$android_widget_SlidingDrawer$getContent() {
        return this.mContent;
    }

    private final void $$robo$$android_widget_SlidingDrawer$unlock() {
        this.mLocked = false;
    }

    private final void $$robo$$android_widget_SlidingDrawer$lock() {
        this.mLocked = true;
    }

    private final boolean $$robo$$android_widget_SlidingDrawer$isOpened() {
        return this.mExpanded;
    }

    private final boolean $$robo$$android_widget_SlidingDrawer$isMoving() {
        return this.mTracking || this.mAnimating;
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_SlidingDrawer$__constructor__(context, attributeSet);
    }

    public SlidingDrawer(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SlidingDrawer$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_SlidingDrawer$__constructor__(context, attributeSet, n);
    }

    public SlidingDrawer(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SlidingDrawer$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_SlidingDrawer$__constructor__(context, attributeSet, n, n2);
    }

    public SlidingDrawer(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SlidingDrawer$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    @Override
    protected void onFinishInflate() {
        InvokeDynamicSupport.bootstrap("onFinishInflate", $$robo$$android_widget_SlidingDrawer$onFinishInflate(), 0, this);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_SlidingDrawer$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("dispatchDraw", $$robo$$android_widget_SlidingDrawer$dispatchDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_SlidingDrawer$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$android_widget_SlidingDrawer$onInterceptTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_SlidingDrawer$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void animateClose(int n) {
        InvokeDynamicSupport.bootstrap("animateClose", $$robo$$android_widget_SlidingDrawer$animateClose(int ), 0, this, n);
    }

    private void animateOpen(int n) {
        InvokeDynamicSupport.bootstrap("animateOpen", $$robo$$android_widget_SlidingDrawer$animateOpen(int ), 0, this, n);
    }

    private void performFling(int n, float f, boolean bl) {
        InvokeDynamicSupport.bootstrap("performFling", $$robo$$android_widget_SlidingDrawer$performFling(int float boolean ), 0, this, n, f, bl);
    }

    private void prepareTracking(int n) {
        InvokeDynamicSupport.bootstrap("prepareTracking", $$robo$$android_widget_SlidingDrawer$prepareTracking(int ), 0, this, n);
    }

    private void moveHandle(int n) {
        InvokeDynamicSupport.bootstrap("moveHandle", $$robo$$android_widget_SlidingDrawer$moveHandle(int ), 0, this, n);
    }

    private void prepareContent() {
        InvokeDynamicSupport.bootstrap("prepareContent", $$robo$$android_widget_SlidingDrawer$prepareContent(), 0, this);
    }

    private void stopTracking() {
        InvokeDynamicSupport.bootstrap("stopTracking", $$robo$$android_widget_SlidingDrawer$stopTracking(), 0, this);
    }

    private void doAnimation() {
        InvokeDynamicSupport.bootstrap("doAnimation", $$robo$$android_widget_SlidingDrawer$doAnimation(), 0, this);
    }

    private void incrementAnimation() {
        InvokeDynamicSupport.bootstrap("incrementAnimation", $$robo$$android_widget_SlidingDrawer$incrementAnimation(), 0, this);
    }

    public void toggle() {
        InvokeDynamicSupport.bootstrap("toggle", $$robo$$android_widget_SlidingDrawer$toggle(), 0, this);
    }

    public void animateToggle() {
        InvokeDynamicSupport.bootstrap("animateToggle", $$robo$$android_widget_SlidingDrawer$animateToggle(), 0, this);
    }

    public void open() {
        InvokeDynamicSupport.bootstrap("open", $$robo$$android_widget_SlidingDrawer$open(), 0, this);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_widget_SlidingDrawer$close(), 0, this);
    }

    public void animateClose() {
        InvokeDynamicSupport.bootstrap("animateClose", $$robo$$android_widget_SlidingDrawer$animateClose(), 0, this);
    }

    public void animateOpen() {
        InvokeDynamicSupport.bootstrap("animateOpen", $$robo$$android_widget_SlidingDrawer$animateOpen(), 0, this);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_SlidingDrawer$getAccessibilityClassName(), 0, this);
    }

    private void closeDrawer() {
        InvokeDynamicSupport.bootstrap("closeDrawer", $$robo$$android_widget_SlidingDrawer$closeDrawer(), 0, this);
    }

    private void openDrawer() {
        InvokeDynamicSupport.bootstrap("openDrawer", $$robo$$android_widget_SlidingDrawer$openDrawer(), 0, this);
    }

    public void setOnDrawerOpenListener(OnDrawerOpenListener onDrawerOpenListener) {
        InvokeDynamicSupport.bootstrap("setOnDrawerOpenListener", $$robo$$android_widget_SlidingDrawer$setOnDrawerOpenListener(android.widget.SlidingDrawer$OnDrawerOpenListener ), 0, this, onDrawerOpenListener);
    }

    public void setOnDrawerCloseListener(OnDrawerCloseListener onDrawerCloseListener) {
        InvokeDynamicSupport.bootstrap("setOnDrawerCloseListener", $$robo$$android_widget_SlidingDrawer$setOnDrawerCloseListener(android.widget.SlidingDrawer$OnDrawerCloseListener ), 0, this, onDrawerCloseListener);
    }

    public void setOnDrawerScrollListener(OnDrawerScrollListener onDrawerScrollListener) {
        InvokeDynamicSupport.bootstrap("setOnDrawerScrollListener", $$robo$$android_widget_SlidingDrawer$setOnDrawerScrollListener(android.widget.SlidingDrawer$OnDrawerScrollListener ), 0, this, onDrawerScrollListener);
    }

    public View getHandle() {
        return InvokeDynamicSupport.bootstrap("getHandle", $$robo$$android_widget_SlidingDrawer$getHandle(), 0, this);
    }

    public View getContent() {
        return InvokeDynamicSupport.bootstrap("getContent", $$robo$$android_widget_SlidingDrawer$getContent(), 0, this);
    }

    public void unlock() {
        InvokeDynamicSupport.bootstrap("unlock", $$robo$$android_widget_SlidingDrawer$unlock(), 0, this);
    }

    public void lock() {
        InvokeDynamicSupport.bootstrap("lock", $$robo$$android_widget_SlidingDrawer$lock(), 0, this);
    }

    public boolean isOpened() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOpened", $$robo$$android_widget_SlidingDrawer$isOpened(), 0, this);
    }

    public boolean isMoving() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMoving", $$robo$$android_widget_SlidingDrawer$isMoving(), 0, this);
    }

    public /* synthetic */ SlidingDrawer() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SlidingDrawer)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class DrawerToggler
    implements View.OnClickListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ SlidingDrawer this$0;

        private void $$robo$$android_widget_SlidingDrawer_DrawerToggler$__constructor__(SlidingDrawer slidingDrawer) {
        }

        private final void $$robo$$android_widget_SlidingDrawer_DrawerToggler$onClick(View v) {
            if (this.this$0.mLocked) {
                return;
            }
            if (this.this$0.mAnimateOnClick) {
                this.this$0.animateToggle();
            } else {
                this.this$0.toggle();
            }
        }

        private /* synthetic */ void $$robo$$android_widget_SlidingDrawer_DrawerToggler$__constructor__(SlidingDrawer x0, 1 x1) {
        }

        private void __constructor__(SlidingDrawer slidingDrawer) {
            this.$$robo$$android_widget_SlidingDrawer_DrawerToggler$__constructor__(slidingDrawer);
        }

        private DrawerToggler(SlidingDrawer slidingDrawer) {
            this.this$0 = slidingDrawer;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SlidingDrawer_DrawerToggler$__constructor__(android.widget.SlidingDrawer ), 0, this, slidingDrawer);
        }

        @Override
        public void onClick(View view) {
            InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_SlidingDrawer_DrawerToggler$onClick(android.view.View ), 0, this, view);
        }

        private /* synthetic */ void __constructor__(SlidingDrawer slidingDrawer, 1 var2_2) {
            this.$$robo$$android_widget_SlidingDrawer_DrawerToggler$__constructor__(slidingDrawer, var2_2);
        }

        public /* synthetic */ DrawerToggler() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DrawerToggler)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnDrawerScrollListener
    extends InstrumentedInterface {
        public void onScrollStarted();

        public void onScrollEnded();
    }

    public static interface OnDrawerCloseListener
    extends InstrumentedInterface {
        public void onDrawerClosed();
    }

    public static interface OnDrawerOpenListener
    extends InstrumentedInterface {
        public void onDrawerOpened();
    }
}

