/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.phonenumbers;

import com.android.i18n.phonenumbers.MetadataLoader;
import com.android.i18n.phonenumbers.MetadataSource;
import com.android.i18n.phonenumbers.Phonemetadata;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

final class MultiFileMetadataSourceImpl
implements MetadataSource {
    private static final Logger logger = Logger.getLogger(MultiFileMetadataSourceImpl.class.getName());
    private static final String META_DATA_FILE_PREFIX = "/com/android/i18n/phonenumbers/data/PhoneNumberMetadataProto";
    private final Map<String, Phonemetadata.PhoneMetadata> regionToMetadataMap = Collections.synchronizedMap(new HashMap());
    private final Map<Integer, Phonemetadata.PhoneMetadata> countryCodeToNonGeographicalMetadataMap = Collections.synchronizedMap(new HashMap());
    private final String currentFilePrefix;
    private final MetadataLoader metadataLoader;

    public MultiFileMetadataSourceImpl(String currentFilePrefix, MetadataLoader metadataLoader) {
        this.currentFilePrefix = currentFilePrefix;
        this.metadataLoader = metadataLoader;
    }

    public MultiFileMetadataSourceImpl(MetadataLoader metadataLoader) {
        this(META_DATA_FILE_PREFIX, metadataLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Phonemetadata.PhoneMetadata getMetadataForRegion(String regionCode) {
        Map<String, Phonemetadata.PhoneMetadata> map = this.regionToMetadataMap;
        synchronized (map) {
            if (!this.regionToMetadataMap.containsKey(regionCode)) {
                this.loadMetadataFromFile(this.currentFilePrefix, regionCode, 0, this.metadataLoader);
            }
        }
        return this.regionToMetadataMap.get(regionCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Phonemetadata.PhoneMetadata getMetadataForNonGeographicalRegion(int countryCallingCode) {
        Map<Integer, Phonemetadata.PhoneMetadata> map = this.countryCodeToNonGeographicalMetadataMap;
        synchronized (map) {
            if (!this.countryCodeToNonGeographicalMetadataMap.containsKey(countryCallingCode)) {
                this.loadMetadataFromFile(this.currentFilePrefix, "001", countryCallingCode, this.metadataLoader);
            }
        }
        return this.countryCodeToNonGeographicalMetadataMap.get(countryCallingCode);
    }

    void loadMetadataFromFile(String filePrefix, String regionCode, int countryCallingCode, MetadataLoader metadataLoader) {
        boolean isNonGeoRegion = "001".equals(regionCode);
        String fileName = filePrefix + "_" + (isNonGeoRegion ? String.valueOf(countryCallingCode) : regionCode);
        InputStream source = metadataLoader.loadMetadata(fileName);
        if (source == null) {
            logger.log(Level.SEVERE, "missing metadata: " + fileName);
            throw new IllegalStateException("missing metadata: " + fileName);
        }
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(source);
            Phonemetadata.PhoneMetadataCollection metadataCollection = MultiFileMetadataSourceImpl.loadMetadataAndCloseInput(in);
            List<Phonemetadata.PhoneMetadata> metadataList = metadataCollection.getMetadataList();
            if (metadataList.isEmpty()) {
                logger.log(Level.SEVERE, "empty metadata: " + fileName);
                throw new IllegalStateException("empty metadata: " + fileName);
            }
            if (metadataList.size() > 1) {
                logger.log(Level.WARNING, "invalid metadata (too many entries): " + fileName);
            }
            Phonemetadata.PhoneMetadata metadata = metadataList.get(0);
            if (isNonGeoRegion) {
                this.countryCodeToNonGeographicalMetadataMap.put(countryCallingCode, metadata);
            } else {
                this.regionToMetadataMap.put(regionCode, metadata);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "cannot load/parse metadata: " + fileName, e);
            throw new RuntimeException("cannot load/parse metadata: " + fileName, e);
        }
    }

    private static Phonemetadata.PhoneMetadataCollection loadMetadataAndCloseInput(ObjectInputStream source) {
        Phonemetadata.PhoneMetadataCollection metadataCollection = new Phonemetadata.PhoneMetadataCollection();
        try {
            metadataCollection.readExternal(source);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "error reading input (ignored)", e);
        }
        finally {
            try {
                source.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "error closing input stream (ignored)", e);
            }
        }
        return metadataCollection;
    }
}

