/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.midi;

import java.lang.invoke.CallSite;
import java.util.SortedMap;
import java.util.TreeMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class EventScheduler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static long NANOS_PER_MILLI = 1000000L;
    private Object mLock;
    private volatile SortedMap<Long, FastEventQueue> mEventBuffer;
    private FastEventQueue mEventPool;
    private int mMaxPoolSize;
    private boolean mClosed;

    private void $$robo$$com_android_internal_midi_EventScheduler$__constructor__() {
        this.mLock = new Object();
        this.mEventPool = null;
        this.mMaxPoolSize = 200;
        this.mEventBuffer = new TreeMap<Long, FastEventQueue>();
    }

    private final SchedulableEvent $$robo$$com_android_internal_midi_EventScheduler$removeEventfromPool() {
        SchedulableEvent event = null;
        if (this.mEventPool != null && this.mEventPool.size() > 1) {
            event = this.mEventPool.remove();
        }
        return event;
    }

    private final void $$robo$$com_android_internal_midi_EventScheduler$addEventToPool(SchedulableEvent event) {
        if (this.mEventPool == null) {
            this.mEventPool = new FastEventQueue(this, event);
        } else if (this.mEventPool.size() < this.mMaxPoolSize) {
            this.mEventPool.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_midi_EventScheduler$add(SchedulableEvent event) {
        Object object = this.mLock;
        synchronized (object) {
            FastEventQueue list = (FastEventQueue)this.mEventBuffer.get(event.getTimestamp());
            if (list == null) {
                long lowestTime = this.mEventBuffer.isEmpty() ? Long.MAX_VALUE : this.mEventBuffer.firstKey();
                list = new FastEventQueue(this, event);
                this.mEventBuffer.put(event.getTimestamp(), list);
                if (event.getTimestamp() < lowestTime) {
                    this.mLock.notify();
                }
            } else {
                list.add(event);
            }
        }
    }

    private final SchedulableEvent $$robo$$com_android_internal_midi_EventScheduler$removeNextEventLocked(long lowestTime) {
        FastEventQueue list = (FastEventQueue)this.mEventBuffer.get(lowestTime);
        if (list.size() == 1) {
            this.mEventBuffer.remove(lowestTime);
        }
        SchedulableEvent event = list.remove();
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SchedulableEvent $$robo$$com_android_internal_midi_EventScheduler$getNextEvent(long time) {
        SchedulableEvent event = null;
        Object object = this.mLock;
        synchronized (object) {
            long lowestTime;
            if (!this.mEventBuffer.isEmpty() && (lowestTime = this.mEventBuffer.firstKey().longValue()) <= time) {
                event = this.removeNextEventLocked(lowestTime);
            }
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SchedulableEvent $$robo$$com_android_internal_midi_EventScheduler$waitNextEvent() throws InterruptedException {
        SchedulableEvent event = null;
        Object object = this.mLock;
        synchronized (object) {
            while (!this.mClosed) {
                long millisToWait = Integer.MAX_VALUE;
                if (!this.mEventBuffer.isEmpty()) {
                    CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System");
                    long lowestTime = this.mEventBuffer.firstKey();
                    if (lowestTime <= now) {
                        event = this.removeNextEventLocked(lowestTime);
                        break;
                    }
                    long nanosToWait = lowestTime - now;
                    millisToWait = 1L + nanosToWait / 1000000L;
                    if (millisToWait > Integer.MAX_VALUE) {
                        millisToWait = Integer.MAX_VALUE;
                    }
                }
                this.mLock.wait((int)millisToWait);
            }
        }
        return event;
    }

    private final void $$robo$$com_android_internal_midi_EventScheduler$flush() {
        this.mEventBuffer = new TreeMap<Long, FastEventQueue>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_midi_EventScheduler$close() {
        Object object = this.mLock;
        synchronized (object) {
            this.mClosed = true;
            this.mLock.notify();
        }
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_midi_EventScheduler$__constructor__();
    }

    public EventScheduler() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_midi_EventScheduler$__constructor__(), 0, this);
    }

    public SchedulableEvent removeEventfromPool() {
        return InvokeDynamicSupport.bootstrap("removeEventfromPool", $$robo$$com_android_internal_midi_EventScheduler$removeEventfromPool(), 0, this);
    }

    public void addEventToPool(SchedulableEvent schedulableEvent) {
        InvokeDynamicSupport.bootstrap("addEventToPool", $$robo$$com_android_internal_midi_EventScheduler$addEventToPool(com.android.internal.midi.EventScheduler$SchedulableEvent ), 0, this, schedulableEvent);
    }

    public void add(SchedulableEvent schedulableEvent) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_midi_EventScheduler$add(com.android.internal.midi.EventScheduler$SchedulableEvent ), 0, this, schedulableEvent);
    }

    private SchedulableEvent removeNextEventLocked(long l) {
        return InvokeDynamicSupport.bootstrap("removeNextEventLocked", $$robo$$com_android_internal_midi_EventScheduler$removeNextEventLocked(long ), 0, this, l);
    }

    public SchedulableEvent getNextEvent(long l) {
        return InvokeDynamicSupport.bootstrap("getNextEvent", $$robo$$com_android_internal_midi_EventScheduler$getNextEvent(long ), 0, this, l);
    }

    public SchedulableEvent waitNextEvent() throws InterruptedException {
        return InvokeDynamicSupport.bootstrap("waitNextEvent", $$robo$$com_android_internal_midi_EventScheduler$waitNextEvent(), 0, this);
    }

    protected void flush() {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$com_android_internal_midi_EventScheduler$flush(), 0, this);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$com_android_internal_midi_EventScheduler$close(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventScheduler)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class SchedulableEvent
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private long mTimestamp;
        private volatile SchedulableEvent mNext;

        private void $$robo$$com_android_internal_midi_EventScheduler_SchedulableEvent$__constructor__(long timestamp) {
            this.mNext = null;
            this.mTimestamp = timestamp;
        }

        private final long $$robo$$com_android_internal_midi_EventScheduler_SchedulableEvent$getTimestamp() {
            return this.mTimestamp;
        }

        private final void $$robo$$com_android_internal_midi_EventScheduler_SchedulableEvent$setTimestamp(long timestamp) {
            this.mTimestamp = timestamp;
        }

        private void __constructor__(long l) {
            this.$$robo$$com_android_internal_midi_EventScheduler_SchedulableEvent$__constructor__(l);
        }

        public SchedulableEvent(long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_midi_EventScheduler_SchedulableEvent$__constructor__(long ), 0, this, l);
        }

        public long getTimestamp() {
            return (long)InvokeDynamicSupport.bootstrap("getTimestamp", $$robo$$com_android_internal_midi_EventScheduler_SchedulableEvent$getTimestamp(), 0, this);
        }

        public void setTimestamp(long l) {
            InvokeDynamicSupport.bootstrap("setTimestamp", $$robo$$com_android_internal_midi_EventScheduler_SchedulableEvent$setTimestamp(long ), 0, this, l);
        }

        public /* synthetic */ SchedulableEvent() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SchedulableEvent)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class FastEventQueue
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        volatile SchedulableEvent mFirst;
        volatile SchedulableEvent mLast;
        volatile long mEventsAdded;
        volatile long mEventsRemoved;
        /* synthetic */ EventScheduler this$0;

        private void $$robo$$com_android_internal_midi_EventScheduler_FastEventQueue$__constructor__(EventScheduler eventScheduler, SchedulableEvent event) {
            this.mLast = this.mFirst = event;
            this.mEventsAdded = 1L;
            this.mEventsRemoved = 0L;
        }

        private final int $$robo$$com_android_internal_midi_EventScheduler_FastEventQueue$size() {
            return (int)(this.mEventsAdded - this.mEventsRemoved);
        }

        private final SchedulableEvent $$robo$$com_android_internal_midi_EventScheduler_FastEventQueue$remove() {
            ++this.mEventsRemoved;
            SchedulableEvent event = this.mFirst;
            this.mFirst = event.mNext;
            event.mNext = null;
            return event;
        }

        private final void $$robo$$com_android_internal_midi_EventScheduler_FastEventQueue$add(SchedulableEvent event) {
            event.mNext = null;
            this.mLast.mNext = event;
            this.mLast = event;
            ++this.mEventsAdded;
        }

        private void __constructor__(EventScheduler eventScheduler, SchedulableEvent schedulableEvent) {
            this.$$robo$$com_android_internal_midi_EventScheduler_FastEventQueue$__constructor__(eventScheduler, schedulableEvent);
        }

        FastEventQueue(EventScheduler eventScheduler, SchedulableEvent schedulableEvent) {
            this.this$0 = eventScheduler;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_midi_EventScheduler_FastEventQueue$__constructor__(com.android.internal.midi.EventScheduler com.android.internal.midi.EventScheduler$SchedulableEvent ), 0, this, eventScheduler, schedulableEvent);
        }

        int size() {
            return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$com_android_internal_midi_EventScheduler_FastEventQueue$size(), 0, this);
        }

        public SchedulableEvent remove() {
            return InvokeDynamicSupport.bootstrap("remove", $$robo$$com_android_internal_midi_EventScheduler_FastEventQueue$remove(), 0, this);
        }

        public void add(SchedulableEvent schedulableEvent) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_midi_EventScheduler_FastEventQueue$add(com.android.internal.midi.EventScheduler$SchedulableEvent ), 0, this, schedulableEvent);
        }

        public /* synthetic */ FastEventQueue() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FastEventQueue)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

