/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.icu.impl.CacheValue;
import android.icu.text.DecimalFormatSymbols;
import android.icu.util.ULocale;
import android.net.LocalServerSocket;
import android.opengl.EGL14;
import android.os.Process;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.security.keystore.AndroidKeyStoreProvider;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructPollfd;
import android.text.Hyphenator;
import android.util.EventLog;
import android.util.Log;
import android.webkit.WebViewFactory;
import android.widget.TextView;
import com.android.internal.os.InstallerConnection;
import com.android.internal.os.PathClassLoaderFactory;
import com.android.internal.os.RuntimeInit;
import com.android.internal.os.SamplingProfilerIntegration;
import com.android.internal.os.WrapperInit;
import com.android.internal.os.Zygote;
import com.android.internal.os.ZygoteConnection;
import dalvik.system.DexFile;
import dalvik.system.PathClassLoader;
import dalvik.system.VMRuntime;
import dalvik.system.ZygoteHooks;
import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ZygoteInit
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Zygote";
    private static String PROPERTY_DISABLE_OPENGL_PRELOADING = "ro.zygote.disable_gl_preload";
    private static String PROPERTY_RUNNING_IN_CONTAINER = "ro.boot.container";
    private static String ANDROID_SOCKET_PREFIX = "ANDROID_SOCKET_";
    private static int LOG_BOOT_PROGRESS_PRELOAD_START = 3020;
    private static int LOG_BOOT_PROGRESS_PRELOAD_END = 3030;
    private static int PRELOAD_GC_THRESHOLD = 50000;
    private static String ABI_LIST_ARG = "--abi-list=";
    private static String SOCKET_NAME_ARG = "--socket-name=";
    private static LocalServerSocket sServerSocket;
    private static Resources mResources;
    private static String PRELOADED_CLASSES = "/system/etc/preloaded-classes";
    public static boolean PRELOAD_RESOURCES = true;
    private static int UNPRIVILEGED_UID = 9999;
    private static int UNPRIVILEGED_GID = 9999;
    private static int ROOT_UID = 0;
    private static int ROOT_GID = 0;

    private static final void $$robo$$com_android_internal_os_ZygoteInit$registerZygoteSocket(String socketName) {
        if (sServerSocket == null) {
            int fileDesc;
            String fullSocketName = "ANDROID_SOCKET_" + socketName;
            try {
                String env = System.getenv(fullSocketName);
                fileDesc = Integer.parseInt(env);
            }
            catch (RuntimeException ex) {
                throw new RuntimeException(fullSocketName + " unset or invalid", ex);
            }
            try {
                FileDescriptor fd = new FileDescriptor();
                InvokeDynamicSupport.bootstrapIntrinsic("setInt$", "java.io.FileDescriptor", (FileDescriptor)fd, (int)fileDesc);
                sServerSocket = new LocalServerSocket(fd);
            }
            catch (IOException ex) {
                throw new RuntimeException("Error binding to local socket '" + fileDesc + "'", ex);
            }
        }
    }

    private static final ZygoteConnection $$robo$$com_android_internal_os_ZygoteInit$acceptCommandPeer(String abiList) {
        try {
            return new ZygoteConnection(sServerSocket.accept(), abiList);
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException during accept()", ex);
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$closeServerSocket() {
        try {
            if (sServerSocket != null) {
                FileDescriptor fd = sServerSocket.getFileDescriptor();
                sServerSocket.close();
                if (fd != null) {
                    Os.close(fd);
                }
            }
        }
        catch (IOException ex) {
            Log.e("Zygote", "Zygote:  error closing sockets", ex);
        }
        catch (ErrnoException ex) {
            Log.e("Zygote", "Zygote:  error closing descriptor", ex);
        }
        sServerSocket = null;
    }

    private static final FileDescriptor $$robo$$com_android_internal_os_ZygoteInit$getServerSocketFileDescriptor() {
        return sServerSocket.getFileDescriptor();
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$preload() {
        Log.d("Zygote", "begin preload");
        Trace.traceBegin(16384L, "BeginIcuCachePinning");
        ZygoteInit.beginIcuCachePinning();
        Trace.traceEnd(16384L);
        Trace.traceBegin(16384L, "PreloadClasses");
        ZygoteInit.preloadClasses();
        Trace.traceEnd(16384L);
        Trace.traceBegin(16384L, "PreloadResources");
        ZygoteInit.preloadResources();
        Trace.traceEnd(16384L);
        Trace.traceBegin(16384L, "PreloadOpenGL");
        ZygoteInit.preloadOpenGL();
        Trace.traceEnd(16384L);
        ZygoteInit.preloadSharedLibraries();
        ZygoteInit.preloadTextResources();
        WebViewFactory.prepareWebViewInZygote();
        ZygoteInit.endIcuCachePinning();
        ZygoteInit.warmUpJcaProviders();
        Log.d("Zygote", "end preload");
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$beginIcuCachePinning() {
        ULocale[] localesToPin;
        Log.i("Zygote", "Installing ICU cache reference pinning...");
        CacheValue.setStrength(CacheValue.Strength.STRONG);
        Log.i("Zygote", "Preloading ICU data...");
        for (ULocale uLocale : localesToPin = new ULocale[]{ULocale.ROOT, ULocale.US, ULocale.getDefault()}) {
            new DecimalFormatSymbols(uLocale);
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$endIcuCachePinning() {
        CacheValue.setStrength(CacheValue.Strength.SOFT);
        Log.i("Zygote", "Uninstalled ICU cache reference pinning...");
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$preloadSharedLibraries() {
        Log.i("Zygote", "Preloading shared libraries...");
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"android");
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"compiler_rt");
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"jnigraphics");
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$preloadOpenGL() {
        if (!SystemProperties.getBoolean("ro.zygote.disable_gl_preload", false)) {
            EGL14.eglGetDisplay(0);
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$preloadTextResources() {
        Hyphenator.init();
        TextView.preloadFontCache();
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$warmUpJcaProviders() {
        long startTime = SystemClock.uptimeMillis();
        Trace.traceBegin(16384L, "Starting installation of AndroidKeyStoreProvider");
        AndroidKeyStoreProvider.install();
        Log.i("Zygote", "Installed AndroidKeyStoreProvider in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
        Trace.traceEnd(16384L);
        startTime = SystemClock.uptimeMillis();
        Trace.traceBegin(16384L, "Starting warm up of JCA providers");
        for (Provider p : Security.getProviders()) {
            p.warmUpServiceProvision();
        }
        Log.i("Zygote", "Warmed up JCA providers in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
        Trace.traceEnd(16384L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_os_ZygoteInit$preloadClasses() {
        FileInputStream is;
        VMRuntime runtime = VMRuntime.getRuntime();
        try {
            is = new FileInputStream("/system/etc/preloaded-classes");
        }
        catch (FileNotFoundException e) {
            Log.e("Zygote", "Couldn't find /system/etc/preloaded-classes.");
            return;
        }
        Log.i("Zygote", "Preloading classes...");
        long startTime = SystemClock.uptimeMillis();
        int reuid = Os.getuid();
        int regid = Os.getgid();
        boolean droppedPriviliges = false;
        if (reuid == 0 && regid == 0) {
            try {
                Os.setregid(0, 9999);
                Os.setreuid(0, 9999);
            }
            catch (ErrnoException ex) {
                throw new RuntimeException("Failed to drop root", ex);
            }
            droppedPriviliges = true;
        }
        float defaultUtilization = runtime.getTargetHeapUtilization();
        runtime.setTargetHeapUtilization(0.8f);
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(is), 256);
            int count = 0;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.equals("")) continue;
                Trace.traceBegin(16384L, "PreloadClass " + line);
                try {
                    Class.forName(line, true, null);
                    ++count;
                }
                catch (ClassNotFoundException e) {
                    Log.w("Zygote", "Class not found for preloading: " + line);
                }
                catch (UnsatisfiedLinkError e) {
                    Log.w("Zygote", "Problem preloading " + line + ": " + e);
                }
                catch (Throwable t) {
                    Log.e("Zygote", "Error preloading " + line + ".", t);
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException(t);
                }
                Trace.traceEnd(16384L);
            }
            Log.i("Zygote", "...preloaded " + count + " classes in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
        }
        catch (IOException e) {
            Log.e("Zygote", "Error reading /system/etc/preloaded-classes.", e);
        }
        finally {
            IoUtils.closeQuietly(is);
            runtime.setTargetHeapUtilization(defaultUtilization);
            Trace.traceBegin(16384L, "PreloadDexCaches");
            runtime.preloadDexCaches();
            Trace.traceEnd(16384L);
            if (droppedPriviliges) {
                try {
                    Os.setreuid(0, 0);
                    Os.setregid(0, 0);
                }
                catch (ErrnoException ex) {
                    throw new RuntimeException("Failed to restore root", ex);
                }
            }
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$preloadResources() {
        VMRuntime runtime = VMRuntime.getRuntime();
        try {
            mResources = Resources.getSystem();
            mResources.startPreloading();
            Log.i("Zygote", "Preloading resources...");
            long startTime = SystemClock.uptimeMillis();
            TypedArray ar = mResources.obtainTypedArray(17235974);
            int N = ZygoteInit.preloadDrawables(ar);
            ar.recycle();
            Log.i("Zygote", "...preloaded " + N + " resources in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
            startTime = SystemClock.uptimeMillis();
            ar = mResources.obtainTypedArray(0x1070007);
            N = ZygoteInit.preloadColorStateLists(ar);
            ar.recycle();
            Log.i("Zygote", "...preloaded " + N + " resources in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
            if (mResources.getBoolean(17957032)) {
                startTime = SystemClock.uptimeMillis();
                ar = mResources.obtainTypedArray(17235976);
                N = ZygoteInit.preloadDrawables(ar);
                ar.recycle();
                Log.i("Zygote", "...preloaded " + N + " resource in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
            }
            mResources.finishPreloading();
        }
        catch (RuntimeException e) {
            Log.w("Zygote", "Failure preloading resources", e);
        }
    }

    private static final int $$robo$$com_android_internal_os_ZygoteInit$preloadColorStateLists(TypedArray ar) {
        int N = ar.length();
        for (int i = 0; i < N; ++i) {
            int id2 = ar.getResourceId(i, 0);
            if (id2 == 0 || mResources.getColorStateList(id2, null) != null) continue;
            throw new IllegalArgumentException("Unable to find preloaded color resource #0x" + Integer.toHexString(id2) + " (" + ar.getString(i) + ")");
        }
        return N;
    }

    private static final int $$robo$$com_android_internal_os_ZygoteInit$preloadDrawables(TypedArray ar) {
        int N = ar.length();
        for (int i = 0; i < N; ++i) {
            int id2 = ar.getResourceId(i, 0);
            if (id2 == 0 || mResources.getDrawable(id2, null) != null) continue;
            throw new IllegalArgumentException("Unable to find preloaded drawable resource #0x" + Integer.toHexString(id2) + " (" + ar.getString(i) + ")");
        }
        return N;
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$gcAndFinalize() {
        VMRuntime runtime = VMRuntime.getRuntime();
        System.gc();
        runtime.runFinalizationSync();
        System.gc();
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$handleSystemServerProcess(ZygoteConnection.Arguments parsedArgs) throws MethodAndArgsCaller {
        String systemServerClasspath;
        ZygoteInit.closeServerSocket();
        Os.umask(OsConstants.S_IRWXG | OsConstants.S_IRWXO);
        if (parsedArgs.niceName != null) {
            Process.setArgV0(parsedArgs.niceName);
        }
        if ((systemServerClasspath = Os.getenv("SYSTEMSERVERCLASSPATH")) != null) {
            ZygoteInit.performSystemServerDexOpt(systemServerClasspath);
        }
        if (parsedArgs.invokeWith != null) {
            String[] args = parsedArgs.remainingArgs;
            if (systemServerClasspath != null) {
                String[] amendedArgs = new String[args.length + 2];
                amendedArgs[0] = "-cp";
                amendedArgs[1] = systemServerClasspath;
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)parsedArgs.remainingArgs, (int)0, (Object)amendedArgs, (int)2, (int)parsedArgs.remainingArgs.length);
            }
            WrapperInit.execApplication(parsedArgs.invokeWith, parsedArgs.niceName, parsedArgs.targetSdkVersion, VMRuntime.getCurrentInstructionSet(), null, args);
        } else {
            PathClassLoader cl = null;
            if (systemServerClasspath != null) {
                cl = ZygoteInit.createSystemServerClassLoader(systemServerClasspath, parsedArgs.targetSdkVersion);
                Thread.currentThread().setContextClassLoader(cl);
            }
            RuntimeInit.zygoteInit(parsedArgs.targetSdkVersion, parsedArgs.remainingArgs, cl);
        }
    }

    private static final PathClassLoader $$robo$$com_android_internal_os_ZygoteInit$createSystemServerClassLoader(String systemServerClasspath, int targetSdkVersion) {
        String librarySearchPath = System.getProperty("java.library.path");
        return PathClassLoaderFactory.createClassLoader(systemServerClasspath, librarySearchPath, null, ClassLoader.getSystemClassLoader(), targetSdkVersion, true);
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$performSystemServerDexOpt(String classPath) {
        String[] classPathElements = classPath.split(":");
        InstallerConnection installer = new InstallerConnection();
        installer.waitForConnection();
        String instructionSet = VMRuntime.getRuntime().vmInstructionSet();
        try {
            String sharedLibraries = "";
            for (String classPathElement : classPathElements) {
                int dexoptNeeded = DexFile.getDexOptNeeded(classPathElement, instructionSet, "speed", false);
                if (dexoptNeeded != 0) {
                    installer.dexopt(classPathElement, 1000, instructionSet, dexoptNeeded, 0, "speed", null, sharedLibraries);
                }
                if (!sharedLibraries.isEmpty()) {
                    sharedLibraries = sharedLibraries + ":";
                }
                sharedLibraries = sharedLibraries + classPathElement;
            }
        }
        catch (InstallerConnection.InstallerException | IOException e) {
            throw new RuntimeException("Error starting system_server", e);
        }
        finally {
            installer.disconnect();
        }
    }

    private static final boolean $$robo$$com_android_internal_os_ZygoteInit$startSystemServer(String abiList, String socketName) throws MethodAndArgsCaller, RuntimeException {
        int pid;
        long capabilities = ZygoteInit.posixCapabilitiesAsBits(OsConstants.CAP_IPC_LOCK, OsConstants.CAP_KILL, OsConstants.CAP_NET_ADMIN, OsConstants.CAP_NET_BIND_SERVICE, OsConstants.CAP_NET_BROADCAST, OsConstants.CAP_NET_RAW, OsConstants.CAP_SYS_MODULE, OsConstants.CAP_SYS_NICE, OsConstants.CAP_SYS_RESOURCE, OsConstants.CAP_SYS_TIME, OsConstants.CAP_SYS_TTY_CONFIG);
        if (!SystemProperties.getBoolean("ro.boot.container", false)) {
            capabilities |= ZygoteInit.posixCapabilitiesAsBits(OsConstants.CAP_BLOCK_SUSPEND);
        }
        String[] args = new String[]{"--setuid=1000", "--setgid=1000", "--setgroups=1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1018,1021,1032,3001,3002,3003,3006,3007,3009,3010", "--capabilities=" + capabilities + "," + capabilities, "--nice-name=system_server", "--runtime-args", "com.android.server.SystemServer"};
        ZygoteConnection.Arguments parsedArgs = null;
        try {
            parsedArgs = new ZygoteConnection.Arguments(args);
            ZygoteConnection.applyDebuggerSystemProperty(parsedArgs);
            ZygoteConnection.applyInvokeWithSystemProperty(parsedArgs);
            pid = Zygote.forkSystemServer(parsedArgs.uid, parsedArgs.gid, parsedArgs.gids, parsedArgs.debugFlags, null, parsedArgs.permittedCapabilities, parsedArgs.effectiveCapabilities);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        if (pid == 0) {
            if (ZygoteInit.hasSecondZygote(abiList)) {
                ZygoteInit.waitForSecondaryZygote(socketName);
            }
            ZygoteInit.handleSystemServerProcess(parsedArgs);
        }
        return true;
    }

    private static final long $$robo$$com_android_internal_os_ZygoteInit$posixCapabilitiesAsBits(int ... capabilities) {
        long result = 0L;
        for (int capability : capabilities) {
            if (capability < 0 || capability > OsConstants.CAP_LAST_CAP) {
                throw new IllegalArgumentException(String.valueOf(capability));
            }
            result |= 1L << capability;
        }
        return result;
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$main(String[] argv) {
        ZygoteHooks.startZygoteNoThreadCreation();
        try {
            Trace.traceBegin(16384L, "ZygoteInit");
            RuntimeInit.enableDdms();
            SamplingProfilerIntegration.start();
            boolean startSystemServer = false;
            String socketName = "zygote";
            String abiList = null;
            for (int i = 1; i < argv.length; ++i) {
                if ("start-system-server".equals(argv[i])) {
                    startSystemServer = true;
                    continue;
                }
                if (argv[i].startsWith("--abi-list=")) {
                    abiList = argv[i].substring("--abi-list=".length());
                    continue;
                }
                if (argv[i].startsWith("--socket-name=")) {
                    socketName = argv[i].substring("--socket-name=".length());
                    continue;
                }
                throw new RuntimeException("Unknown command line argument: " + argv[i]);
            }
            if (abiList == null) {
                throw new RuntimeException("No ABI list supplied.");
            }
            ZygoteInit.registerZygoteSocket(socketName);
            Trace.traceBegin(16384L, "ZygotePreload");
            EventLog.writeEvent(3020, SystemClock.uptimeMillis());
            ZygoteInit.preload();
            EventLog.writeEvent(3030, SystemClock.uptimeMillis());
            Trace.traceEnd(16384L);
            SamplingProfilerIntegration.writeZygoteSnapshot();
            Trace.traceBegin(16384L, "PostZygoteInitGC");
            ZygoteInit.gcAndFinalize();
            Trace.traceEnd(16384L);
            Trace.traceEnd(16384L);
            Trace.setTracingEnabled(false);
            Zygote.nativeUnmountStorageOnInit();
            ZygoteHooks.stopZygoteNoThreadCreation();
            if (startSystemServer) {
                ZygoteInit.startSystemServer(abiList, socketName);
            }
            Log.i("Zygote", "Accepting command socket connections");
            ZygoteInit.runSelectLoop(abiList);
            ZygoteInit.closeServerSocket();
        }
        catch (MethodAndArgsCaller caller) {
            caller.run();
        }
        catch (RuntimeException ex) {
            Log.e("Zygote", "Zygote died with exception", ex);
            ZygoteInit.closeServerSocket();
            throw ex;
        }
    }

    private static final boolean $$robo$$com_android_internal_os_ZygoteInit$hasSecondZygote(String abiList) {
        return !SystemProperties.get("ro.product.cpu.abilist").equals(abiList);
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$waitForSecondaryZygote(String socketName) {
        String otherZygoteName = "zygote".equals(socketName) ? "zygote_secondary" : "zygote";
        while (true) {
            try {
                Process.ZygoteState zs = Process.ZygoteState.connect(otherZygoteName);
                zs.close();
            }
            catch (IOException ioe) {
                Log.w("Zygote", "Got error connecting to zygote, retrying. msg= " + ioe.getMessage());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$runSelectLoop(String abiList) throws MethodAndArgsCaller {
        ArrayList<FileDescriptor> fds = new ArrayList<FileDescriptor>();
        ArrayList<ZygoteConnection> peers = new ArrayList<ZygoteConnection>();
        fds.add(sServerSocket.getFileDescriptor());
        peers.add(null);
        block2: while (true) {
            int i;
            StructPollfd[] pollFds = new StructPollfd[fds.size()];
            for (i = 0; i < pollFds.length; ++i) {
                pollFds[i] = new StructPollfd();
                pollFds[i].fd = (FileDescriptor)fds.get(i);
                pollFds[i].events = (short)OsConstants.POLLIN;
            }
            try {
                Os.poll(pollFds, -1);
            }
            catch (ErrnoException ex) {
                throw new RuntimeException("poll failed", ex);
            }
            i = pollFds.length - 1;
            while (true) {
                if (i < 0) continue block2;
                if ((pollFds[i].revents & OsConstants.POLLIN) != 0) {
                    if (i == 0) {
                        ZygoteConnection newPeer = ZygoteInit.acceptCommandPeer(abiList);
                        peers.add(newPeer);
                        fds.add(newPeer.getFileDesciptor());
                    } else {
                        boolean done = ((ZygoteConnection)peers.get(i)).runOnce();
                        if (done) {
                            peers.remove(i);
                            fds.remove(i);
                        }
                    }
                }
                --i;
            }
            break;
        }
    }

    private void $$robo$$com_android_internal_os_ZygoteInit$__constructor__() {
    }

    private static void registerZygoteSocket(String string2) {
        InvokeDynamicSupport.bootstrapStatic("registerZygoteSocket", $$robo$$com_android_internal_os_ZygoteInit$registerZygoteSocket(java.lang.String ), 0, (String)string2);
    }

    private static ZygoteConnection acceptCommandPeer(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("acceptCommandPeer", $$robo$$com_android_internal_os_ZygoteInit$acceptCommandPeer(java.lang.String ), 0, (String)string2);
    }

    static void closeServerSocket() {
        InvokeDynamicSupport.bootstrapStatic("closeServerSocket", $$robo$$com_android_internal_os_ZygoteInit$closeServerSocket(), 0);
    }

    static FileDescriptor getServerSocketFileDescriptor() {
        return InvokeDynamicSupport.bootstrapStatic("getServerSocketFileDescriptor", $$robo$$com_android_internal_os_ZygoteInit$getServerSocketFileDescriptor(), 0);
    }

    static void preload() {
        InvokeDynamicSupport.bootstrapStatic("preload", $$robo$$com_android_internal_os_ZygoteInit$preload(), 0);
    }

    private static void beginIcuCachePinning() {
        InvokeDynamicSupport.bootstrapStatic("beginIcuCachePinning", $$robo$$com_android_internal_os_ZygoteInit$beginIcuCachePinning(), 0);
    }

    private static void endIcuCachePinning() {
        InvokeDynamicSupport.bootstrapStatic("endIcuCachePinning", $$robo$$com_android_internal_os_ZygoteInit$endIcuCachePinning(), 0);
    }

    private static void preloadSharedLibraries() {
        InvokeDynamicSupport.bootstrapStatic("preloadSharedLibraries", $$robo$$com_android_internal_os_ZygoteInit$preloadSharedLibraries(), 0);
    }

    private static void preloadOpenGL() {
        InvokeDynamicSupport.bootstrapStatic("preloadOpenGL", $$robo$$com_android_internal_os_ZygoteInit$preloadOpenGL(), 0);
    }

    private static void preloadTextResources() {
        InvokeDynamicSupport.bootstrapStatic("preloadTextResources", $$robo$$com_android_internal_os_ZygoteInit$preloadTextResources(), 0);
    }

    private static void warmUpJcaProviders() {
        InvokeDynamicSupport.bootstrapStatic("warmUpJcaProviders", $$robo$$com_android_internal_os_ZygoteInit$warmUpJcaProviders(), 0);
    }

    private static void preloadClasses() {
        InvokeDynamicSupport.bootstrapStatic("preloadClasses", $$robo$$com_android_internal_os_ZygoteInit$preloadClasses(), 0);
    }

    private static void preloadResources() {
        InvokeDynamicSupport.bootstrapStatic("preloadResources", $$robo$$com_android_internal_os_ZygoteInit$preloadResources(), 0);
    }

    private static int preloadColorStateLists(TypedArray typedArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("preloadColorStateLists", $$robo$$com_android_internal_os_ZygoteInit$preloadColorStateLists(android.content.res.TypedArray ), 0, (TypedArray)typedArray);
    }

    private static int preloadDrawables(TypedArray typedArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("preloadDrawables", $$robo$$com_android_internal_os_ZygoteInit$preloadDrawables(android.content.res.TypedArray ), 0, (TypedArray)typedArray);
    }

    static void gcAndFinalize() {
        InvokeDynamicSupport.bootstrapStatic("gcAndFinalize", $$robo$$com_android_internal_os_ZygoteInit$gcAndFinalize(), 0);
    }

    private static void handleSystemServerProcess(ZygoteConnection.Arguments arguments) throws MethodAndArgsCaller {
        InvokeDynamicSupport.bootstrapStatic("handleSystemServerProcess", $$robo$$com_android_internal_os_ZygoteInit$handleSystemServerProcess(com.android.internal.os.ZygoteConnection$Arguments ), 0, (ZygoteConnection.Arguments)arguments);
    }

    private static PathClassLoader createSystemServerClassLoader(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createSystemServerClassLoader", $$robo$$com_android_internal_os_ZygoteInit$createSystemServerClassLoader(java.lang.String int ), 0, (String)string2, (int)n);
    }

    private static void performSystemServerDexOpt(String string2) {
        InvokeDynamicSupport.bootstrapStatic("performSystemServerDexOpt", $$robo$$com_android_internal_os_ZygoteInit$performSystemServerDexOpt(java.lang.String ), 0, (String)string2);
    }

    private static boolean startSystemServer(String string2, String string3) throws MethodAndArgsCaller, RuntimeException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("startSystemServer", $$robo$$com_android_internal_os_ZygoteInit$startSystemServer(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private static long posixCapabilitiesAsBits(int ... nArray) {
        return (long)InvokeDynamicSupport.bootstrapStatic("posixCapabilitiesAsBits", $$robo$$com_android_internal_os_ZygoteInit$posixCapabilitiesAsBits(int[] ), 0, (int[])nArray);
    }

    public static void main(String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("main", $$robo$$com_android_internal_os_ZygoteInit$main(java.lang.String[] ), 0, (String[])stringArray);
    }

    private static boolean hasSecondZygote(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasSecondZygote", $$robo$$com_android_internal_os_ZygoteInit$hasSecondZygote(java.lang.String ), 0, (String)string2);
    }

    private static void waitForSecondaryZygote(String string2) {
        InvokeDynamicSupport.bootstrapStatic("waitForSecondaryZygote", $$robo$$com_android_internal_os_ZygoteInit$waitForSecondaryZygote(java.lang.String ), 0, (String)string2);
    }

    private static void runSelectLoop(String string2) throws MethodAndArgsCaller {
        InvokeDynamicSupport.bootstrapStatic("runSelectLoop", $$robo$$com_android_internal_os_ZygoteInit$runSelectLoop(java.lang.String ), 0, (String)string2);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_os_ZygoteInit$__constructor__();
    }

    private ZygoteInit() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_ZygoteInit$__constructor__(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZygoteInit)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class MethodAndArgsCaller
    extends Exception
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Method mMethod;
        private String[] mArgs;

        private void $$robo$$com_android_internal_os_ZygoteInit_MethodAndArgsCaller$__constructor__(Method method, String[] args) {
            this.mMethod = method;
            this.mArgs = args;
        }

        private final void $$robo$$com_android_internal_os_ZygoteInit_MethodAndArgsCaller$run() {
            try {
                this.mMethod.invoke(null, new Object[]{this.mArgs});
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException(ex);
            }
        }

        private void __constructor__(Method method, String[] stringArray) {
            this.$$robo$$com_android_internal_os_ZygoteInit_MethodAndArgsCaller$__constructor__(method, stringArray);
        }

        public MethodAndArgsCaller(Method method, String[] stringArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_ZygoteInit_MethodAndArgsCaller$__constructor__(java.lang.reflect.Method java.lang.String[] ), 0, this, method, stringArray);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_os_ZygoteInit_MethodAndArgsCaller$run(), 0, this);
        }

        public /* synthetic */ MethodAndArgsCaller() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MethodAndArgsCaller)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

