/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.telephony.Rlog;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.uicc.AdnRecord;
import com.android.internal.telephony.uicc.AdnRecordCache;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IccPhoneBookInterfaceManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "IccPhoneBookIM";
    protected static boolean DBG = true;
    protected Phone mPhone;
    private UiccCardApplication mCurrentApp;
    protected AdnRecordCache mAdnCache;
    protected Object mLock;
    protected int[] mRecordSize;
    protected boolean mSuccess;
    private boolean mIs3gCard;
    protected List<AdnRecord> mRecords;
    protected static boolean ALLOW_SIM_OP_IN_UI_THREAD = false;
    protected static int EVENT_GET_SIZE_DONE = 1;
    protected static int EVENT_LOAD_DONE = 2;
    protected static int EVENT_UPDATE_DONE = 3;
    protected Handler mBaseHandler;

    private void $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$__constructor__(Phone phone) {
        this.mCurrentApp = null;
        this.mLock = new Object();
        this.mIs3gCard = false;
        this.mBaseHandler = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IccPhoneBookInterfaceManager this$0;

            private void $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager_1$__constructor__(IccPhoneBookInterfaceManager this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager_1$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        AsyncResult ar = (AsyncResult)msg.obj;
                        Object object = this.this$0.mLock;
                        synchronized (object) {
                            if (ar.exception == null) {
                                this.this$0.mRecordSize = (int[])ar.result;
                                this.this$0.logd("GET_RECORD_SIZE Size " + this.this$0.mRecordSize[0] + " total " + this.this$0.mRecordSize[1] + " #record " + this.this$0.mRecordSize[2]);
                            }
                            this.notifyPending(ar);
                            break;
                        }
                    }
                    case 3: {
                        AsyncResult ar = (AsyncResult)msg.obj;
                        Object object = this.this$0.mLock;
                        synchronized (object) {
                            this.this$0.mSuccess = ar.exception == null;
                            this.notifyPending(ar);
                            break;
                        }
                    }
                    case 2: {
                        AsyncResult ar = (AsyncResult)msg.obj;
                        Object object = this.this$0.mLock;
                        synchronized (object) {
                            if (ar.exception == null) {
                                this.this$0.mRecords = (List)ar.result;
                            } else {
                                this.this$0.logd("Cannot load ADN records");
                                this.this$0.mRecords = null;
                            }
                            this.notifyPending(ar);
                            break;
                        }
                    }
                }
            }

            private final void $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager_1$notifyPending(AsyncResult ar) {
                if (ar.userObj != null) {
                    AtomicBoolean status = (AtomicBoolean)ar.userObj;
                    status.set(true);
                }
                this.this$0.mLock.notifyAll();
            }

            private void __constructor__(IccPhoneBookInterfaceManager iccPhoneBookInterfaceManager) {
                this.$$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager_1$__constructor__(iccPhoneBookInterfaceManager);
            }
            {
                this.this$0 = iccPhoneBookInterfaceManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager_1$__constructor__(com.android.internal.telephony.IccPhoneBookInterfaceManager ), 0, this, iccPhoneBookInterfaceManager);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager_1$handleMessage(android.os.Message ), 0, this, message);
            }

            private void notifyPending(AsyncResult asyncResult) {
                InvokeDynamicSupport.bootstrap("notifyPending", $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager_1$notifyPending(android.os.AsyncResult ), 0, this, asyncResult);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhone = phone;
        IccRecords r = phone.getIccRecords();
        if (r != null) {
            this.mAdnCache = r.getAdnCache();
        }
    }

    private final void $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$dispose() {
    }

    private final void $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$updateIccRecords(IccRecords iccRecords) {
        this.mAdnCache = iccRecords != null ? iccRecords.getAdnCache() : null;
    }

    private final void $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$logd(String msg) {
        Rlog.d("IccPhoneBookIM", "[IccPbInterfaceManager] " + msg);
    }

    private final void $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$loge(String msg) {
        Rlog.e("IccPhoneBookIM", "[IccPbInterfaceManager] " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$updateAdnRecordsInEfBySearch(int efid, String oldTag, String oldPhoneNumber, String newTag, String newPhoneNumber, String pin2) {
        if (this.mPhone.getContext().checkCallingOrSelfPermission("android.permission.WRITE_CONTACTS") != 0) {
            throw new SecurityException("Requires android.permission.WRITE_CONTACTS permission");
        }
        this.logd("updateAdnRecordsInEfBySearch: efid=0x" + Integer.toHexString(efid).toUpperCase() + " (" + oldTag + "," + oldPhoneNumber + ")==> (" + newTag + "," + newPhoneNumber + ") pin2=" + pin2);
        efid = this.updateEfForIccType(efid);
        Object object = this.mLock;
        synchronized (object) {
            this.checkThread();
            this.mSuccess = false;
            AtomicBoolean status = new AtomicBoolean(false);
            Message response = this.mBaseHandler.obtainMessage(3, status);
            AdnRecord oldAdn = new AdnRecord(oldTag, oldPhoneNumber);
            AdnRecord newAdn = new AdnRecord(newTag, newPhoneNumber);
            if (this.mAdnCache != null) {
                this.mAdnCache.updateAdnBySearch(efid, oldAdn, newAdn, pin2, response);
                this.waitForResult(status);
            } else {
                this.loge("Failure while trying to update by search due to uninitialised adncache");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$updateAdnRecordsInEfByIndex(int efid, String newTag, String newPhoneNumber, int index, String pin2) {
        if (this.mPhone.getContext().checkCallingOrSelfPermission("android.permission.WRITE_CONTACTS") != 0) {
            throw new SecurityException("Requires android.permission.WRITE_CONTACTS permission");
        }
        this.logd("updateAdnRecordsInEfByIndex: efid=0x" + Integer.toHexString(efid).toUpperCase() + " Index=" + index + " ==> (" + newTag + "," + newPhoneNumber + ") pin2=" + pin2);
        Object object = this.mLock;
        synchronized (object) {
            this.checkThread();
            this.mSuccess = false;
            AtomicBoolean status = new AtomicBoolean(false);
            Message response = this.mBaseHandler.obtainMessage(3, status);
            AdnRecord newAdn = new AdnRecord(newTag, newPhoneNumber);
            if (this.mAdnCache != null) {
                this.mAdnCache.updateAdnByIndex(efid, newAdn, index, pin2, response);
                this.waitForResult(status);
            } else {
                this.loge("Failure while trying to update by index due to uninitialised adncache");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int[] $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$getAdnRecordsSize(int efid) {
        this.logd("getAdnRecordsSize: efid=" + efid);
        Object object = this.mLock;
        synchronized (object) {
            this.checkThread();
            this.mRecordSize = new int[3];
            AtomicBoolean status = new AtomicBoolean(false);
            Message response = this.mBaseHandler.obtainMessage(1, status);
            IccFileHandler fh = this.mPhone.getIccFileHandler();
            if (fh != null) {
                fh.getEFLinearRecordSize(efid, response);
                this.waitForResult(status);
            }
        }
        return this.mRecordSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AdnRecord> $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$getAdnRecordsInEf(int efid) {
        if (this.mPhone.getContext().checkCallingOrSelfPermission("android.permission.READ_CONTACTS") != 0) {
            throw new SecurityException("Requires android.permission.READ_CONTACTS permission");
        }
        efid = this.updateEfForIccType(efid);
        this.logd("getAdnRecordsInEF: efid=0x" + Integer.toHexString(efid).toUpperCase());
        Object object = this.mLock;
        synchronized (object) {
            this.checkThread();
            AtomicBoolean status = new AtomicBoolean(false);
            Message response = this.mBaseHandler.obtainMessage(2, status);
            if (this.mAdnCache != null) {
                this.mAdnCache.requestLoadAllAdnLike(efid, this.mAdnCache.extensionEfForEf(efid), response);
                this.waitForResult(status);
            } else {
                this.loge("Failure while trying to load from SIM due to uninitialised adncache");
            }
        }
        return this.mRecords;
    }

    private final void $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$checkThread() {
        if (this.mBaseHandler.getLooper().equals(Looper.myLooper())) {
            this.loge("query() called on the main UI thread!");
            throw new IllegalStateException("You cannot call query on this provder from the main UI thread.");
        }
    }

    private final void $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$waitForResult(AtomicBoolean status) {
        while (!status.get()) {
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.logd("interrupted while trying to update by search");
            }
        }
    }

    private final int $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$updateEfForIccType(int efid) {
        if (efid == 28474 && this.mPhone.getCurrentUiccAppType() == IccCardApplicationStatus.AppType.APPTYPE_USIM) {
            return 20272;
        }
        return efid;
    }

    private void __constructor__(Phone phone) {
        this.$$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$__constructor__(phone);
    }

    public IccPhoneBookInterfaceManager(Phone phone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$__constructor__(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$dispose(), 0, this);
    }

    public void updateIccRecords(IccRecords iccRecords) {
        InvokeDynamicSupport.bootstrap("updateIccRecords", $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$updateIccRecords(com.android.internal.telephony.uicc.IccRecords ), 0, this, iccRecords);
    }

    protected void logd(String string2) {
        InvokeDynamicSupport.bootstrap("logd", $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$logd(java.lang.String ), 0, this, string2);
    }

    protected void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$loge(java.lang.String ), 0, this, string2);
    }

    public boolean updateAdnRecordsInEfBySearch(int n, String string2, String string3, String string4, String string5, String string6) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateAdnRecordsInEfBySearch", $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$updateAdnRecordsInEfBySearch(int java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String ), 0, this, n, string2, string3, string4, string5, string6);
    }

    public boolean updateAdnRecordsInEfByIndex(int n, String string2, String string3, int n2, String string4) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateAdnRecordsInEfByIndex", $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$updateAdnRecordsInEfByIndex(int java.lang.String java.lang.String int java.lang.String ), 0, this, n, string2, string3, n2, string4);
    }

    public int[] getAdnRecordsSize(int n) {
        return InvokeDynamicSupport.bootstrap("getAdnRecordsSize", $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$getAdnRecordsSize(int ), 0, this, n);
    }

    public List<AdnRecord> getAdnRecordsInEf(int n) {
        return InvokeDynamicSupport.bootstrap("getAdnRecordsInEf", $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$getAdnRecordsInEf(int ), 0, this, n);
    }

    protected void checkThread() {
        InvokeDynamicSupport.bootstrap("checkThread", $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$checkThread(), 0, this);
    }

    protected void waitForResult(AtomicBoolean atomicBoolean) {
        InvokeDynamicSupport.bootstrap("waitForResult", $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$waitForResult(java.util.concurrent.atomic.AtomicBoolean ), 0, this, atomicBoolean);
    }

    private int updateEfForIccType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("updateEfForIccType", $$robo$$com_android_internal_telephony_IccPhoneBookInterfaceManager$updateEfForIccType(int ), 0, this, n);
    }

    public /* synthetic */ IccPhoneBookInterfaceManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IccPhoneBookInterfaceManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

