/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AppGlobals;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.XmlResourceParser;
import android.database.ContentObserver;
import android.os.Binder;
import android.os.Handler;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.util.AtomicFile;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SmsUsageMonitor
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SmsUsageMonitor";
    private static boolean DBG = false;
    private static boolean VDBG = false;
    private static String SHORT_CODE_PATH = "/data/misc/sms/codes";
    private static int DEFAULT_SMS_CHECK_PERIOD = 60000;
    private static int DEFAULT_SMS_MAX_COUNT = 30;
    static int CATEGORY_NOT_SHORT_CODE = 0;
    static int CATEGORY_FREE_SHORT_CODE = 1;
    static int CATEGORY_STANDARD_SHORT_CODE = 2;
    static int CATEGORY_POSSIBLE_PREMIUM_SHORT_CODE = 3;
    static int CATEGORY_PREMIUM_SHORT_CODE = 4;
    public static int PREMIUM_SMS_PERMISSION_UNKNOWN = 0;
    public static int PREMIUM_SMS_PERMISSION_ASK_USER = 1;
    public static int PREMIUM_SMS_PERMISSION_NEVER_ALLOW = 2;
    public static int PREMIUM_SMS_PERMISSION_ALWAYS_ALLOW = 3;
    private int mCheckPeriod;
    private int mMaxAllowed;
    private HashMap<String, ArrayList<Long>> mSmsStamp;
    private Context mContext;
    private String mCurrentCountry;
    private ShortCodePatternMatcher mCurrentPatternMatcher;
    private AtomicBoolean mCheckEnabled;
    private SettingsObserverHandler mSettingsObserverHandler;
    private File mPatternFile;
    private long mPatternFileLastModified;
    private static String SMS_POLICY_FILE_DIRECTORY = "/data/misc/sms";
    private static String SMS_POLICY_FILE_NAME = "premium_sms_policy.xml";
    private static String TAG_SHORTCODES = "shortcodes";
    private static String TAG_SHORTCODE = "shortcode";
    private static String ATTR_COUNTRY = "country";
    private static String ATTR_PATTERN = "pattern";
    private static String ATTR_PREMIUM = "premium";
    private static String ATTR_FREE = "free";
    private static String ATTR_STANDARD = "standard";
    private AtomicFile mPolicyFile;
    private HashMap<String, Integer> mPremiumSmsPolicy;
    private static String TAG_SMS_POLICY_BODY = "premium-sms-policy";
    private static String TAG_PACKAGE = "package";
    private static String ATTR_PACKAGE_NAME = "name";
    private static String ATTR_PACKAGE_SMS_POLICY = "sms-policy";

    private static final int $$robo$$com_android_internal_telephony_SmsUsageMonitor$mergeShortCodeCategories(int type1, int type2) {
        if (type1 > type2) {
            return type1;
        }
        return type2;
    }

    private void $$robo$$com_android_internal_telephony_SmsUsageMonitor$__constructor__(Context context) {
        this.mSmsStamp = new HashMap();
        this.mCheckEnabled = new AtomicBoolean(true);
        this.mPatternFile = new File("/data/misc/sms/codes");
        this.mPatternFileLastModified = 0L;
        this.mPremiumSmsPolicy = new HashMap();
        this.mContext = context;
        ContentResolver resolver = context.getContentResolver();
        this.mMaxAllowed = Settings.Global.getInt(resolver, "sms_outgoing_check_max_count", 30);
        this.mCheckPeriod = Settings.Global.getInt(resolver, "sms_outgoing_check_interval_ms", 60000);
        this.mSettingsObserverHandler = new SettingsObserverHandler(this.mContext, this.mCheckEnabled);
        this.loadPremiumSmsPolicyDb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ShortCodePatternMatcher $$robo$$com_android_internal_telephony_SmsUsageMonitor$getPatternMatcherFromFile(String country) {
        FileReader patternReader = null;
        XmlPullParser parser = null;
        try {
            patternReader = new FileReader(this.mPatternFile);
            parser = Xml.newPullParser();
            parser.setInput(patternReader);
            ShortCodePatternMatcher shortCodePatternMatcher = this.getPatternMatcherFromXmlParser(parser, country);
            return shortCodePatternMatcher;
        }
        catch (FileNotFoundException e) {
            Rlog.e("SmsUsageMonitor", "Short Code Pattern File not found");
        }
        catch (XmlPullParserException e) {
            Rlog.e("SmsUsageMonitor", "XML parser exception reading short code pattern file", e);
        }
        finally {
            this.mPatternFileLastModified = this.mPatternFile.lastModified();
            if (patternReader != null) {
                try {
                    patternReader.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ShortCodePatternMatcher $$robo$$com_android_internal_telephony_SmsUsageMonitor$getPatternMatcherFromResource(String country) {
        int id2 = 0x1110012;
        try (XmlResourceParser parser = null;){
            parser = this.mContext.getResources().getXml(id2);
            ShortCodePatternMatcher shortCodePatternMatcher = this.getPatternMatcherFromXmlParser(parser, country);
            return shortCodePatternMatcher;
        }
    }

    private final ShortCodePatternMatcher $$robo$$com_android_internal_telephony_SmsUsageMonitor$getPatternMatcherFromXmlParser(XmlPullParser parser, String country) {
        try {
            XmlUtils.beginDocument(parser, "shortcodes");
            while (true) {
                XmlUtils.nextElement(parser);
                String element = parser.getName();
                if (element == null) {
                    Rlog.e("SmsUsageMonitor", "Parsing pattern data found null");
                    break;
                }
                if (element.equals("shortcode")) {
                    String currentCountry = parser.getAttributeValue(null, "country");
                    if (!country.equals(currentCountry)) continue;
                    String pattern = parser.getAttributeValue(null, "pattern");
                    String premium = parser.getAttributeValue(null, "premium");
                    String free = parser.getAttributeValue(null, "free");
                    String standard = parser.getAttributeValue(null, "standard");
                    return new ShortCodePatternMatcher(pattern, premium, free, standard);
                }
                Rlog.e("SmsUsageMonitor", "Error: skipping unknown XML tag " + element);
            }
        }
        catch (XmlPullParserException e) {
            Rlog.e("SmsUsageMonitor", "XML parser exception reading short code patterns", e);
        }
        catch (IOException e) {
            Rlog.e("SmsUsageMonitor", "I/O exception reading short code patterns", e);
        }
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_SmsUsageMonitor$dispose() {
        this.mSmsStamp.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_SmsUsageMonitor$check(String appName, int smsWaiting) {
        HashMap<String, ArrayList<Long>> hashMap = this.mSmsStamp;
        synchronized (hashMap) {
            this.removeExpiredTimestamps();
            ArrayList<Long> sentList = this.mSmsStamp.get(appName);
            if (sentList == null) {
                sentList = new ArrayList();
                this.mSmsStamp.put(appName, sentList);
            }
            return this.isUnderLimit(sentList, smsWaiting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_SmsUsageMonitor$checkDestination(String destAddress, String countryIso) {
        SettingsObserverHandler settingsObserverHandler = this.mSettingsObserverHandler;
        synchronized (settingsObserverHandler) {
            if (PhoneNumberUtils.isEmergencyNumber(destAddress, countryIso)) {
                return 0;
            }
            if (!this.mCheckEnabled.get()) {
                return 0;
            }
            if (!(countryIso == null || this.mCurrentCountry != null && countryIso.equals(this.mCurrentCountry) && this.mPatternFile.lastModified() == this.mPatternFileLastModified)) {
                this.mCurrentPatternMatcher = this.mPatternFile.exists() ? this.getPatternMatcherFromFile(countryIso) : this.getPatternMatcherFromResource(countryIso);
                this.mCurrentCountry = countryIso;
            }
            if (this.mCurrentPatternMatcher != null) {
                return this.mCurrentPatternMatcher.getNumberCategory(destAddress);
            }
            Rlog.e("SmsUsageMonitor", "No patterns for \"" + countryIso + "\": using generic short code rule");
            if (destAddress.length() <= 5) {
                return 3;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_SmsUsageMonitor$loadPremiumSmsPolicyDb() {
        HashMap<String, Integer> hashMap = this.mPremiumSmsPolicy;
        synchronized (hashMap) {
            if (this.mPolicyFile == null) {
                File dir = new File("/data/misc/sms");
                this.mPolicyFile = new AtomicFile(new File(dir, "premium_sms_policy.xml"));
                this.mPremiumSmsPolicy.clear();
                FileInputStream infile = null;
                try {
                    infile = this.mPolicyFile.openRead();
                    XmlPullParser parser = Xml.newPullParser();
                    parser.setInput(infile, StandardCharsets.UTF_8.name());
                    XmlUtils.beginDocument(parser, "premium-sms-policy");
                    while (true) {
                        XmlUtils.nextElement(parser);
                        String element = parser.getName();
                        if (element == null) {
                            break;
                        }
                        if (element.equals("package")) {
                            String packageName = parser.getAttributeValue(null, "name");
                            String policy = parser.getAttributeValue(null, "sms-policy");
                            if (packageName == null) {
                                Rlog.e("SmsUsageMonitor", "Error: missing package name attribute");
                                continue;
                            }
                            if (policy == null) {
                                Rlog.e("SmsUsageMonitor", "Error: missing package policy attribute");
                                continue;
                            }
                            try {
                                this.mPremiumSmsPolicy.put(packageName, Integer.parseInt(policy));
                            }
                            catch (NumberFormatException e) {
                                Rlog.e("SmsUsageMonitor", "Error: non-numeric policy type " + policy);
                            }
                            continue;
                        }
                        Rlog.e("SmsUsageMonitor", "Error: skipping unknown XML tag " + element);
                    }
                }
                catch (FileNotFoundException parser) {
                }
                catch (IOException e) {
                    Rlog.e("SmsUsageMonitor", "Unable to read premium SMS policy database", e);
                }
                catch (NumberFormatException e) {
                    Rlog.e("SmsUsageMonitor", "Unable to parse premium SMS policy database", e);
                }
                catch (XmlPullParserException e) {
                    Rlog.e("SmsUsageMonitor", "Unable to parse premium SMS policy database", e);
                }
                finally {
                    if (infile != null) {
                        try {
                            infile.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_SmsUsageMonitor$writePremiumSmsPolicyDb() {
        HashMap<String, Integer> hashMap = this.mPremiumSmsPolicy;
        synchronized (hashMap) {
            block6: {
                FileOutputStream outfile = null;
                try {
                    outfile = this.mPolicyFile.startWrite();
                    FastXmlSerializer out = new FastXmlSerializer();
                    out.setOutput(outfile, StandardCharsets.UTF_8.name());
                    out.startDocument(null, true);
                    out.startTag(null, "premium-sms-policy");
                    for (Map.Entry<String, Integer> policy : this.mPremiumSmsPolicy.entrySet()) {
                        out.startTag(null, "package");
                        out.attribute(null, "name", policy.getKey());
                        out.attribute(null, "sms-policy", policy.getValue().toString());
                        out.endTag(null, "package");
                    }
                    out.endTag(null, "premium-sms-policy");
                    out.endDocument();
                    this.mPolicyFile.finishWrite(outfile);
                }
                catch (IOException e) {
                    Rlog.e("SmsUsageMonitor", "Unable to write premium SMS policy database", e);
                    if (outfile == null) break block6;
                    this.mPolicyFile.failWrite(outfile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_SmsUsageMonitor$getPremiumSmsPermission(String packageName) {
        SmsUsageMonitor.checkCallerIsSystemOrPhoneOrSameApp(packageName);
        HashMap<String, Integer> hashMap = this.mPremiumSmsPolicy;
        synchronized (hashMap) {
            Integer policy = this.mPremiumSmsPolicy.get(packageName);
            if (policy == null) {
                return 0;
            }
            return policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_SmsUsageMonitor$setPremiumSmsPermission(String packageName, int permission2) {
        SmsUsageMonitor.checkCallerIsSystemOrPhoneApp();
        if (permission2 < 1 || permission2 > 3) {
            throw new IllegalArgumentException("invalid SMS permission type " + permission2);
        }
        HashMap<String, Integer> hashMap = this.mPremiumSmsPolicy;
        synchronized (hashMap) {
            this.mPremiumSmsPolicy.put(packageName, permission2);
        }
        new Thread(new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SmsUsageMonitor this$0;

            private void $$robo$$com_android_internal_telephony_SmsUsageMonitor_1$__constructor__(SmsUsageMonitor this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_SmsUsageMonitor_1$run() {
                this.this$0.writePremiumSmsPolicyDb();
            }

            private void __constructor__(SmsUsageMonitor smsUsageMonitor) {
                this.$$robo$$com_android_internal_telephony_SmsUsageMonitor_1$__constructor__(smsUsageMonitor);
            }
            {
                this.this$0 = smsUsageMonitor;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsUsageMonitor_1$__constructor__(com.android.internal.telephony.SmsUsageMonitor ), 0, this, smsUsageMonitor);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_telephony_SmsUsageMonitor_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }).start();
    }

    private static final void $$robo$$com_android_internal_telephony_SmsUsageMonitor$checkCallerIsSystemOrPhoneOrSameApp(String pkg) {
        int uid = Binder.getCallingUid();
        int appId = UserHandle.getAppId(uid);
        if (appId == 1000 || appId == 1001 || uid == 0) {
            return;
        }
        try {
            ApplicationInfo ai = AppGlobals.getPackageManager().getApplicationInfo(pkg, 0, UserHandle.getCallingUserId());
            if (!UserHandle.isSameApp(ai.uid, uid)) {
                throw new SecurityException("Calling uid " + uid + " gave package" + pkg + " which is owned by uid " + ai.uid);
            }
        }
        catch (RemoteException re) {
            throw new SecurityException("Unknown package " + pkg + "\n" + re);
        }
    }

    private static final void $$robo$$com_android_internal_telephony_SmsUsageMonitor$checkCallerIsSystemOrPhoneApp() {
        int uid = Binder.getCallingUid();
        int appId = UserHandle.getAppId(uid);
        if (appId == 1000 || appId == 1001 || uid == 0) {
            return;
        }
        throw new SecurityException("Disallowed call for uid " + uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_SmsUsageMonitor$removeExpiredTimestamps() {
        reference var1_1 = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") - (long)this.mCheckPeriod;
        HashMap<String, ArrayList<Long>> hashMap = this.mSmsStamp;
        synchronized (hashMap) {
            Iterator<Map.Entry<String, ArrayList<Long>>> iter = this.mSmsStamp.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, ArrayList<Long>> entry = iter.next();
                ArrayList<Long> oldList = entry.getValue();
                if (!oldList.isEmpty() && oldList.get(oldList.size() - 1) >= var1_1) continue;
                iter.remove();
            }
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_SmsUsageMonitor$isUnderLimit(ArrayList<Long> sent, int smsWaiting) {
        Long ct = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        long beginCheckPeriod = ct - (long)this.mCheckPeriod;
        while (!sent.isEmpty() && sent.get(0) < beginCheckPeriod) {
            sent.remove(0);
        }
        if (sent.size() + smsWaiting <= this.mMaxAllowed) {
            for (int i = 0; i < smsWaiting; ++i) {
                sent.add(ct);
            }
            return true;
        }
        return false;
    }

    private static final void $$robo$$com_android_internal_telephony_SmsUsageMonitor$log(String msg) {
        Rlog.d("SmsUsageMonitor", msg);
    }

    public static int mergeShortCodeCategories(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("mergeShortCodeCategories", $$robo$$com_android_internal_telephony_SmsUsageMonitor$mergeShortCodeCategories(int int ), 0, (int)n, (int)n2);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_telephony_SmsUsageMonitor$__constructor__(context);
    }

    public SmsUsageMonitor(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsUsageMonitor$__constructor__(android.content.Context ), 0, this, context);
    }

    private ShortCodePatternMatcher getPatternMatcherFromFile(String string2) {
        return InvokeDynamicSupport.bootstrap("getPatternMatcherFromFile", $$robo$$com_android_internal_telephony_SmsUsageMonitor$getPatternMatcherFromFile(java.lang.String ), 0, this, string2);
    }

    private ShortCodePatternMatcher getPatternMatcherFromResource(String string2) {
        return InvokeDynamicSupport.bootstrap("getPatternMatcherFromResource", $$robo$$com_android_internal_telephony_SmsUsageMonitor$getPatternMatcherFromResource(java.lang.String ), 0, this, string2);
    }

    private ShortCodePatternMatcher getPatternMatcherFromXmlParser(XmlPullParser xmlPullParser, String string2) {
        return InvokeDynamicSupport.bootstrap("getPatternMatcherFromXmlParser", $$robo$$com_android_internal_telephony_SmsUsageMonitor$getPatternMatcherFromXmlParser(org.xmlpull.v1.XmlPullParser java.lang.String ), 0, this, xmlPullParser, string2);
    }

    void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_SmsUsageMonitor$dispose(), 0, this);
    }

    public boolean check(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("check", $$robo$$com_android_internal_telephony_SmsUsageMonitor$check(java.lang.String int ), 0, this, string2, n);
    }

    public int checkDestination(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("checkDestination", $$robo$$com_android_internal_telephony_SmsUsageMonitor$checkDestination(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private void loadPremiumSmsPolicyDb() {
        InvokeDynamicSupport.bootstrap("loadPremiumSmsPolicyDb", $$robo$$com_android_internal_telephony_SmsUsageMonitor$loadPremiumSmsPolicyDb(), 0, this);
    }

    private void writePremiumSmsPolicyDb() {
        InvokeDynamicSupport.bootstrap("writePremiumSmsPolicyDb", $$robo$$com_android_internal_telephony_SmsUsageMonitor$writePremiumSmsPolicyDb(), 0, this);
    }

    public int getPremiumSmsPermission(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getPremiumSmsPermission", $$robo$$com_android_internal_telephony_SmsUsageMonitor$getPremiumSmsPermission(java.lang.String ), 0, this, string2);
    }

    public void setPremiumSmsPermission(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setPremiumSmsPermission", $$robo$$com_android_internal_telephony_SmsUsageMonitor$setPremiumSmsPermission(java.lang.String int ), 0, this, string2, n);
    }

    private static void checkCallerIsSystemOrPhoneOrSameApp(String string2) {
        InvokeDynamicSupport.bootstrapStatic("checkCallerIsSystemOrPhoneOrSameApp", $$robo$$com_android_internal_telephony_SmsUsageMonitor$checkCallerIsSystemOrPhoneOrSameApp(java.lang.String ), 0, (String)string2);
    }

    private static void checkCallerIsSystemOrPhoneApp() {
        InvokeDynamicSupport.bootstrapStatic("checkCallerIsSystemOrPhoneApp", $$robo$$com_android_internal_telephony_SmsUsageMonitor$checkCallerIsSystemOrPhoneApp(), 0);
    }

    private void removeExpiredTimestamps() {
        InvokeDynamicSupport.bootstrap("removeExpiredTimestamps", $$robo$$com_android_internal_telephony_SmsUsageMonitor$removeExpiredTimestamps(), 0, this);
    }

    private boolean isUnderLimit(ArrayList<Long> arrayList, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUnderLimit", $$robo$$com_android_internal_telephony_SmsUsageMonitor$isUnderLimit(java.util.ArrayList<java.lang.Long> int ), 0, this, arrayList, n);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$com_android_internal_telephony_SmsUsageMonitor$log(java.lang.String ), 0, (String)string2);
    }

    public /* synthetic */ SmsUsageMonitor() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsUsageMonitor)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class SettingsObserverHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_telephony_SmsUsageMonitor_SettingsObserverHandler$__constructor__(Context context, AtomicBoolean enabled) {
            ContentResolver resolver = context.getContentResolver();
            SettingsObserver globalObserver = new SettingsObserver(this, context, enabled);
            resolver.registerContentObserver(Settings.Global.getUriFor("sms_short_code_confirmation"), false, globalObserver);
        }

        private void __constructor__(Context context, AtomicBoolean atomicBoolean) {
            this.$$robo$$com_android_internal_telephony_SmsUsageMonitor_SettingsObserverHandler$__constructor__(context, atomicBoolean);
        }

        SettingsObserverHandler(Context context, AtomicBoolean atomicBoolean) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsUsageMonitor_SettingsObserverHandler$__constructor__(android.content.Context java.util.concurrent.atomic.AtomicBoolean ), 0, this, context, atomicBoolean);
        }

        public /* synthetic */ SettingsObserverHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SettingsObserverHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SettingsObserver
    extends ContentObserver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Context mContext;
        private AtomicBoolean mEnabled;

        private void $$robo$$com_android_internal_telephony_SmsUsageMonitor_SettingsObserver$__constructor__(Handler handler, Context context, AtomicBoolean enabled) {
            this.mContext = context;
            this.mEnabled = enabled;
            this.onChange(false);
        }

        private final void $$robo$$com_android_internal_telephony_SmsUsageMonitor_SettingsObserver$onChange(boolean selfChange) {
            this.mEnabled.set(Settings.Global.getInt(this.mContext.getContentResolver(), "sms_short_code_confirmation", 1) != 0);
        }

        private void __constructor__(Handler handler, Context context, AtomicBoolean atomicBoolean) {
            this.$$robo$$com_android_internal_telephony_SmsUsageMonitor_SettingsObserver$__constructor__(handler, context, atomicBoolean);
        }

        SettingsObserver(Handler handler, Context context, AtomicBoolean atomicBoolean) {
            super(handler);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsUsageMonitor_SettingsObserver$__constructor__(android.os.Handler android.content.Context java.util.concurrent.atomic.AtomicBoolean ), 0, this, handler, context, atomicBoolean);
        }

        @Override
        public void onChange(boolean bl) {
            InvokeDynamicSupport.bootstrap("onChange", $$robo$$com_android_internal_telephony_SmsUsageMonitor_SettingsObserver$onChange(boolean ), 0, this, bl);
        }

        public /* synthetic */ SettingsObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SettingsObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class ShortCodePatternMatcher
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Pattern mShortCodePattern;
        private Pattern mPremiumShortCodePattern;
        private Pattern mFreeShortCodePattern;
        private Pattern mStandardShortCodePattern;

        private void $$robo$$com_android_internal_telephony_SmsUsageMonitor_ShortCodePatternMatcher$__constructor__(String shortCodeRegex, String premiumShortCodeRegex, String freeShortCodeRegex, String standardShortCodeRegex) {
            this.mShortCodePattern = shortCodeRegex != null ? Pattern.compile(shortCodeRegex) : null;
            this.mPremiumShortCodePattern = premiumShortCodeRegex != null ? Pattern.compile(premiumShortCodeRegex) : null;
            this.mFreeShortCodePattern = freeShortCodeRegex != null ? Pattern.compile(freeShortCodeRegex) : null;
            this.mStandardShortCodePattern = standardShortCodeRegex != null ? Pattern.compile(standardShortCodeRegex) : null;
        }

        private final int $$robo$$com_android_internal_telephony_SmsUsageMonitor_ShortCodePatternMatcher$getNumberCategory(String phoneNumber) {
            if (this.mFreeShortCodePattern != null && this.mFreeShortCodePattern.matcher(phoneNumber).matches()) {
                return 1;
            }
            if (this.mStandardShortCodePattern != null && this.mStandardShortCodePattern.matcher(phoneNumber).matches()) {
                return 2;
            }
            if (this.mPremiumShortCodePattern != null && this.mPremiumShortCodePattern.matcher(phoneNumber).matches()) {
                return 4;
            }
            if (this.mShortCodePattern != null && this.mShortCodePattern.matcher(phoneNumber).matches()) {
                return 3;
            }
            return 0;
        }

        private void __constructor__(String string2, String string3, String string4, String string5) {
            this.$$robo$$com_android_internal_telephony_SmsUsageMonitor_ShortCodePatternMatcher$__constructor__(string2, string3, string4, string5);
        }

        ShortCodePatternMatcher(String string2, String string3, String string4, String string5) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsUsageMonitor_ShortCodePatternMatcher$__constructor__(java.lang.String java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4, string5);
        }

        int getNumberCategory(String string2) {
            return (int)InvokeDynamicSupport.bootstrap("getNumberCategory", $$robo$$com_android_internal_telephony_SmsUsageMonitor_ShortCodePatternMatcher$getNumberCategory(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ ShortCodePatternMatcher() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ShortCodePatternMatcher)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

