/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManagerNative;
import android.app.IUserSwitchObserver;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.IPackageManager;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.IRemoteCallback;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserManager;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.internal.telephony.CarrierAppUtils;
import com.android.internal.telephony.CarrierServiceBindHelper;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.RILConstants;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccUtils;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SubscriptionInfoUpdater
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "SubscriptionInfoUpdater";
    private static int PROJECT_SIM_NUM;
    private static int EVENT_SIM_LOCKED_QUERY_ICCID_DONE = 1;
    private static int EVENT_GET_NETWORK_SELECTION_MODE_DONE = 2;
    private static int EVENT_SIM_LOADED = 3;
    private static int EVENT_SIM_ABSENT = 4;
    private static int EVENT_SIM_LOCKED = 5;
    private static int EVENT_SIM_IO_ERROR = 6;
    private static int EVENT_SIM_UNKNOWN = 7;
    private static String ICCID_STRING_FOR_NO_SIM = "";
    public static int SIM_NOT_CHANGE = 0;
    public static int SIM_CHANGED = -1;
    public static int SIM_NEW = -2;
    public static int SIM_REPOSITION = -3;
    public static int SIM_NOT_INSERT = -99;
    public static int STATUS_NO_SIM_INSERTED = 0;
    public static int STATUS_SIM1_INSERTED = 1;
    public static int STATUS_SIM2_INSERTED = 2;
    public static int STATUS_SIM3_INSERTED = 4;
    public static int STATUS_SIM4_INSERTED = 8;
    public static String CURR_SUBID = "curr_subid";
    private static Phone[] mPhone;
    private static Context mContext;
    private static String[] mIccId;
    private static int[] mInsertSimState;
    private SubscriptionManager mSubscriptionManager;
    private IPackageManager mPackageManager;
    private UserManager mUserManager;
    private Map<Integer, Intent> rebroadcastIntentsOnUnlock;
    private int mCurrentlyActiveUserId;
    private CarrierServiceBindHelper mCarrierServiceBindHelper;
    private BroadcastReceiver sReceiver;

    private void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$__constructor__(Context context, Phone[] phone, CommandsInterface[] ci) {
        this.mSubscriptionManager = null;
        this.rebroadcastIntentsOnUnlock = new HashMap<Integer, Intent>();
        this.sReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SubscriptionInfoUpdater this$0;

            private void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_2$__constructor__(SubscriptionInfoUpdater this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_2$onReceive(Context context, Intent intent) {
                this.this$0.logd("[Receiver]+");
                String action = intent.getAction();
                this.this$0.logd("Action: " + action);
                if (action.equals("android.intent.action.USER_UNLOCKED")) {
                    Iterator iterator = this.this$0.rebroadcastIntentsOnUnlock.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry pair = iterator.next();
                        Intent i = (Intent)pair.getValue();
                        iterator.remove();
                        this.this$0.logd("Broadcasting intent ACTION_SIM_STATE_CHANGED for mCardIndex: " + pair.getKey());
                        ActivityManagerNative.broadcastStickyIntent(i, "android.permission.READ_PHONE_STATE", -1);
                    }
                    this.this$0.rebroadcastIntentsOnUnlock = null;
                    this.this$0.logd("[Receiver]-");
                    return;
                }
                if (!action.equals("android.intent.action.SIM_STATE_CHANGED") && !action.equals("android.intent.action.internal_sim_state_changed")) {
                    return;
                }
                int slotId = intent.getIntExtra("phone", -1);
                this.this$0.logd("slotId: " + slotId);
                if (slotId == -1) {
                    return;
                }
                String simStatus = intent.getStringExtra("ss");
                this.this$0.logd("simStatus: " + simStatus);
                if (action.equals("android.intent.action.SIM_STATE_CHANGED")) {
                    if ("ABSENT".equals(simStatus)) {
                        this.this$0.sendMessage(this.this$0.obtainMessage(4, slotId, -1));
                    } else if ("UNKNOWN".equals(simStatus)) {
                        this.this$0.sendMessage(this.this$0.obtainMessage(7, slotId, -1));
                    } else if ("CARD_IO_ERROR".equals(simStatus)) {
                        this.this$0.sendMessage(this.this$0.obtainMessage(6, slotId, -1));
                    } else {
                        this.this$0.logd("Ignoring simStatus: " + simStatus);
                    }
                } else if (action.equals("android.intent.action.internal_sim_state_changed")) {
                    if ("LOCKED".equals(simStatus)) {
                        String reason = intent.getStringExtra("reason");
                        this.this$0.sendMessage(this.this$0.obtainMessage(5, slotId, -1, reason));
                    } else if ("LOADED".equals(simStatus)) {
                        this.this$0.sendMessage(this.this$0.obtainMessage(3, slotId, -1));
                    } else {
                        this.this$0.logd("Ignoring simStatus: " + simStatus);
                    }
                }
                this.this$0.logd("[Receiver]-");
            }

            private void __constructor__(SubscriptionInfoUpdater subscriptionInfoUpdater) {
                this.$$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_2$__constructor__(subscriptionInfoUpdater);
            }
            {
                this.this$0 = subscriptionInfoUpdater;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_2$__constructor__(com.android.internal.telephony.SubscriptionInfoUpdater ), 0, this, subscriptionInfoUpdater);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_2$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.logd("Constructor invoked");
        mContext = context;
        mPhone = phone;
        this.mSubscriptionManager = SubscriptionManager.from(mContext);
        this.mPackageManager = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
        this.mUserManager = (UserManager)mContext.getSystemService("user");
        IntentFilter intentFilter = new IntentFilter("android.intent.action.SIM_STATE_CHANGED");
        intentFilter.addAction("android.intent.action.internal_sim_state_changed");
        intentFilter.addAction("android.intent.action.USER_UNLOCKED");
        mContext.registerReceiver(this.sReceiver, intentFilter);
        this.mCarrierServiceBindHelper = new CarrierServiceBindHelper(mContext);
        this.initializeCarrierApps();
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$initializeCarrierApps() {
        this.mCurrentlyActiveUserId = 0;
        try {
            ActivityManagerNative.getDefault().registerUserSwitchObserver((IUserSwitchObserver)new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ SubscriptionInfoUpdater this$0;

                private void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_1$__constructor__(SubscriptionInfoUpdater this$0) {
                }

                private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_1$onUserSwitching(int newUserId, IRemoteCallback reply) throws RemoteException {
                    this.this$0.mCurrentlyActiveUserId = newUserId;
                    CarrierAppUtils.disableCarrierAppsUntilPrivileged(mContext.getOpPackageName(), this.this$0.mPackageManager, TelephonyManager.getDefault(), this.this$0.mCurrentlyActiveUserId);
                    if (reply != null) {
                        try {
                            reply.sendResult(null);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }

                private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_1$onUserSwitchComplete(int newUserId) {
                }

                private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_1$onForegroundProfileSwitch(int newProfileId) throws RemoteException {
                }

                private void __constructor__(SubscriptionInfoUpdater subscriptionInfoUpdater) {
                    this.$$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_1$__constructor__(subscriptionInfoUpdater);
                }
                {
                    this.this$0 = subscriptionInfoUpdater;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_1$__constructor__(com.android.internal.telephony.SubscriptionInfoUpdater ), 0, this, subscriptionInfoUpdater);
                }

                @Override
                public void onUserSwitching(int n, IRemoteCallback iRemoteCallback) throws RemoteException {
                    InvokeDynamicSupport.bootstrap("onUserSwitching", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_1$onUserSwitching(int android.os.IRemoteCallback ), 0, this, n, iRemoteCallback);
                }

                @Override
                public void onUserSwitchComplete(int n) {
                    InvokeDynamicSupport.bootstrap("onUserSwitchComplete", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_1$onUserSwitchComplete(int ), 0, this, n);
                }

                @Override
                public void onForegroundProfileSwitch(int n) throws RemoteException {
                    InvokeDynamicSupport.bootstrap("onForegroundProfileSwitch", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_1$onForegroundProfileSwitch(int ), 0, this, n);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            this.mCurrentlyActiveUserId = ActivityManagerNative.getDefault().getCurrentUser().id;
        }
        catch (RemoteException e) {
            this.logd("Couldn't get current user ID; guessing it's 0: " + e.getMessage());
        }
        CarrierAppUtils.disableCarrierAppsUntilPrivileged(mContext.getOpPackageName(), this.mPackageManager, TelephonyManager.getDefault(), this.mCurrentlyActiveUserId);
    }

    private final boolean $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$isAllIccIdQueryDone() {
        for (int i = 0; i < PROJECT_SIM_NUM; ++i) {
            if (mIccId[i] != null) continue;
            this.logd("Wait for SIM" + (i + 1) + " IccId");
            return false;
        }
        this.logd("All IccIds query complete");
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$setDisplayNameForNewSub(String newSubName, int subId, int newNameSource) {
        SubscriptionInfo subInfo = this.mSubscriptionManager.getActiveSubscriptionInfo(subId);
        if (subInfo != null) {
            int oldNameSource = subInfo.getNameSource();
            CharSequence oldSubName = subInfo.getDisplayName();
            this.logd("[setDisplayNameForNewSub] subId = " + subInfo.getSubscriptionId() + ", oldSimName = " + oldSubName + ", oldNameSource = " + oldNameSource + ", newSubName = " + newSubName + ", newNameSource = " + newNameSource);
            if (oldSubName == null || oldNameSource == 0 && newSubName != null || oldNameSource == 1 && newSubName != null && !newSubName.equals(oldSubName)) {
                this.mSubscriptionManager.setDisplayName(newSubName, subInfo.getSubscriptionId(), newNameSource);
            }
        } else {
            this.logd("SUB" + (subId + 1) + " SubInfo not created yet");
        }
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                AsyncResult ar = (AsyncResult)msg.obj;
                QueryIccIdUserObj uObj = (QueryIccIdUserObj)ar.userObj;
                int slotId = uObj.slotId;
                this.logd("handleMessage : <EVENT_SIM_LOCKED_QUERY_ICCID_DONE> SIM" + (slotId + 1));
                if (ar.exception == null) {
                    if (ar.result != null) {
                        byte[] data = (byte[])ar.result;
                        SubscriptionInfoUpdater.mIccId[slotId] = IccUtils.bcdToString(data, 0, data.length);
                    } else {
                        this.logd("Null ar");
                        SubscriptionInfoUpdater.mIccId[slotId] = "";
                    }
                } else {
                    SubscriptionInfoUpdater.mIccId[slotId] = "";
                    this.logd("Query IccId fail: " + ar.exception);
                }
                this.logd("sIccId[" + slotId + "] = " + mIccId[slotId]);
                if (this.isAllIccIdQueryDone()) {
                    this.updateSubscriptionInfoByIccId();
                }
                this.broadcastSimStateChanged(slotId, "LOCKED", uObj.reason);
                if ("".equals(mIccId[slotId])) break;
                this.updateCarrierServices(slotId, "LOCKED");
                break;
            }
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                Integer slotId = (Integer)ar.userObj;
                if (ar.exception == null && ar.result != null) {
                    int[] modes = (int[])ar.result;
                    if (modes[0] != 1) break;
                    mPhone[slotId].setNetworkSelectionModeAutomatic(null);
                    break;
                }
                this.logd("EVENT_GET_NETWORK_SELECTION_MODE_DONE: error getting network mode.");
                break;
            }
            case 3: {
                this.handleSimLoaded(msg.arg1);
                break;
            }
            case 4: {
                this.handleSimAbsent(msg.arg1);
                break;
            }
            case 5: {
                this.handleSimLocked(msg.arg1, (String)msg.obj);
                break;
            }
            case 7: {
                this.updateCarrierServices(msg.arg1, "UNKNOWN");
                break;
            }
            case 6: {
                this.updateCarrierServices(msg.arg1, "CARD_IO_ERROR");
                break;
            }
            default: {
                this.logd("Unknown msg:" + msg.what);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$handleSimLocked(int slotId, String reason) {
        IccFileHandler fileHandler;
        if (mIccId[slotId] != null && mIccId[slotId].equals("")) {
            this.logd("SIM" + (slotId + 1) + " hot plug in");
            SubscriptionInfoUpdater.mIccId[slotId] = null;
        }
        IccFileHandler iccFileHandler = fileHandler = mPhone[slotId].getIccCard() == null ? null : mPhone[slotId].getIccCard().getIccFileHandler();
        if (fileHandler != null) {
            String iccId = mIccId[slotId];
            if (iccId == null) {
                this.logd("Querying IccId");
                fileHandler.loadEFTransparent(12258, this.obtainMessage(1, new QueryIccIdUserObj(reason, slotId)));
            } else {
                this.logd("NOT Querying IccId its already set sIccid[" + slotId + "]=" + iccId);
                this.updateCarrierServices(slotId, "LOCKED");
                this.broadcastSimStateChanged(slotId, "LOCKED", reason);
            }
        } else {
            this.logd("sFh[" + slotId + "] is null, ignore");
        }
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$handleSimLoaded(int slotId) {
        this.logd("handleSimStateLoadedInternal: slotId: " + slotId);
        IccRecords records = mPhone[slotId].getIccCard().getIccRecords();
        if (records == null) {
            this.logd("onRecieve: IccRecords null");
            return;
        }
        if (records.getIccId() == null) {
            this.logd("onRecieve: IccID null");
            return;
        }
        SubscriptionInfoUpdater.mIccId[slotId] = records.getIccId();
        if (this.isAllIccIdQueryDone()) {
            this.updateSubscriptionInfoByIccId();
        }
        int subId = Integer.MAX_VALUE;
        int[] subIds = SubscriptionController.getInstance().getSubId(slotId);
        if (subIds != null) {
            subId = subIds[0];
        }
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            SharedPreferences sp;
            int storedSubId;
            TelephonyManager tm = TelephonyManager.getDefault();
            String operator = tm.getSimOperatorNumericForPhone(slotId);
            if (!TextUtils.isEmpty(operator)) {
                if (subId == SubscriptionController.getInstance().getDefaultSubId()) {
                    MccTable.updateMccMncConfiguration(mContext, operator, false);
                }
                SubscriptionController.getInstance().setMccMnc(operator, subId);
            } else {
                this.logd("EVENT_RECORDS_LOADED Operator name is null");
            }
            String msisdn = tm.getLine1Number(subId);
            ContentResolver contentResolver = mContext.getContentResolver();
            if (msisdn != null) {
                ContentValues number = new ContentValues(1);
                number.put("number", msisdn);
                contentResolver.update(SubscriptionManager.CONTENT_URI, number, "_id=" + Long.toString(subId), null);
            }
            SubscriptionInfo subInfo = this.mSubscriptionManager.getActiveSubscriptionInfo(subId);
            String simCarrierName = tm.getSimOperatorName(subId);
            ContentValues name = new ContentValues(1);
            if (subInfo != null && subInfo.getNameSource() != 2) {
                String nameToSet = !TextUtils.isEmpty(simCarrierName) ? simCarrierName : "CARD " + Integer.toString(slotId + 1);
                name.put("display_name", nameToSet);
                this.logd("sim name = " + nameToSet);
                contentResolver.update(SubscriptionManager.CONTENT_URI, name, "_id=" + Long.toString(subId), null);
            }
            if ((storedSubId = (sp = PreferenceManager.getDefaultSharedPreferences(mContext)).getInt("curr_subid" + slotId, -1)) != subId) {
                int networkType = RILConstants.PREFERRED_NETWORK_MODE;
                mPhone[slotId].setPreferredNetworkType(networkType, null);
                Settings.Global.putInt(mPhone[slotId].getContext().getContentResolver(), "preferred_network_mode" + subId, networkType);
                mPhone[slotId].getNetworkSelectionMode(this.obtainMessage(2, new Integer(slotId)));
                SharedPreferences.Editor editor = sp.edit();
                editor.putInt("curr_subid" + slotId, subId);
                editor.apply();
            }
        } else {
            this.logd("Invalid subId, could not update ContentResolver");
        }
        CarrierAppUtils.disableCarrierAppsUntilPrivileged(mContext.getOpPackageName(), this.mPackageManager, TelephonyManager.getDefault(), this.mCurrentlyActiveUserId);
        this.broadcastSimStateChanged(slotId, "LOADED", null);
        this.updateCarrierServices(slotId, "LOADED");
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$updateCarrierServices(int slotId, String simState) {
        CarrierConfigManager configManager = (CarrierConfigManager)mContext.getSystemService("carrier_config");
        configManager.updateConfigForPhoneId(slotId, simState);
        this.mCarrierServiceBindHelper.updateForPhoneId(slotId, simState);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$handleSimAbsent(int slotId) {
        if (mIccId[slotId] != null && !mIccId[slotId].equals("")) {
            this.logd("SIM" + (slotId + 1) + " hot plug out");
        }
        SubscriptionInfoUpdater.mIccId[slotId] = "";
        if (this.isAllIccIdQueryDone()) {
            this.updateSubscriptionInfoByIccId();
        }
        this.updateCarrierServices(slotId, "ABSENT");
    }

    private final synchronized void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$updateSubscriptionInfoByIccId() {
        int i;
        int i2;
        this.logd("updateSubscriptionInfoByIccId:+ Start");
        this.mSubscriptionManager.clearSubscriptionInfo();
        for (int i3 = 0; i3 < PROJECT_SIM_NUM; ++i3) {
            SubscriptionInfoUpdater.mInsertSimState[i3] = 0;
        }
        int insertedSimCount = PROJECT_SIM_NUM;
        for (int i4 = 0; i4 < PROJECT_SIM_NUM; ++i4) {
            if (!"".equals(mIccId[i4])) continue;
            --insertedSimCount;
            SubscriptionInfoUpdater.mInsertSimState[i4] = -99;
        }
        this.logd("insertedSimCount = " + insertedSimCount);
        int index = 0;
        for (int i5 = 0; i5 < PROJECT_SIM_NUM; ++i5) {
            if (mInsertSimState[i5] == -99) continue;
            index = 2;
            for (int j = i5 + 1; j < PROJECT_SIM_NUM; ++j) {
                if (mInsertSimState[j] != 0 || !mIccId[i5].equals(mIccId[j])) continue;
                SubscriptionInfoUpdater.mInsertSimState[i5] = 1;
                SubscriptionInfoUpdater.mInsertSimState[j] = index++;
            }
        }
        ContentResolver contentResolver = mContext.getContentResolver();
        String[] oldIccId = new String[PROJECT_SIM_NUM];
        for (i2 = 0; i2 < PROJECT_SIM_NUM; ++i2) {
            oldIccId[i2] = null;
            List<SubscriptionInfo> oldSubInfo = SubscriptionController.getInstance().getSubInfoUsingSlotIdWithCheck(i2, false, mContext.getOpPackageName());
            if (oldSubInfo != null) {
                oldIccId[i2] = oldSubInfo.get(0).getIccId();
                this.logd("updateSubscriptionInfoByIccId: oldSubId = " + oldSubInfo.get(0).getSubscriptionId());
                if (mInsertSimState[i2] == 0 && !mIccId[i2].equals(oldIccId[i2])) {
                    SubscriptionInfoUpdater.mInsertSimState[i2] = -1;
                }
                if (mInsertSimState[i2] == 0) continue;
                ContentValues value = new ContentValues(1);
                value.put("sim_id", -1);
                contentResolver.update(SubscriptionManager.CONTENT_URI, value, "_id=" + Integer.toString(oldSubInfo.get(0).getSubscriptionId()), null);
                continue;
            }
            if (mInsertSimState[i2] == 0) {
                SubscriptionInfoUpdater.mInsertSimState[i2] = -1;
            }
            oldIccId[i2] = "";
            this.logd("updateSubscriptionInfoByIccId: No SIM in slot " + i2 + " last time");
        }
        for (i2 = 0; i2 < PROJECT_SIM_NUM; ++i2) {
            this.logd("updateSubscriptionInfoByIccId: oldIccId[" + i2 + "] = " + oldIccId[i2] + ", sIccId[" + i2 + "] = " + mIccId[i2]);
        }
        int nNewCardCount = 0;
        int nNewSimStatus = 0;
        for (i = 0; i < PROJECT_SIM_NUM; ++i) {
            if (mInsertSimState[i] == -99) {
                this.logd("updateSubscriptionInfoByIccId: No SIM inserted in slot " + i + " this time");
                continue;
            }
            if (mInsertSimState[i] > 0) {
                this.mSubscriptionManager.addSubscriptionInfoRecord(mIccId[i] + Integer.toString(mInsertSimState[i]), i);
                this.logd("SUB" + (i + 1) + " has invalid IccId");
            } else {
                this.mSubscriptionManager.addSubscriptionInfoRecord(mIccId[i], i);
            }
            if (!this.isNewSim(mIccId[i], oldIccId)) continue;
            ++nNewCardCount;
            switch (i) {
                case 0: {
                    nNewSimStatus |= 1;
                    break;
                }
                case 1: {
                    nNewSimStatus |= 2;
                    break;
                }
                case 2: {
                    nNewSimStatus |= 4;
                }
            }
            SubscriptionInfoUpdater.mInsertSimState[i] = -2;
        }
        for (i = 0; i < PROJECT_SIM_NUM; ++i) {
            if (mInsertSimState[i] == -1) {
                SubscriptionInfoUpdater.mInsertSimState[i] = -3;
            }
            this.logd("updateSubscriptionInfoByIccId: sInsertSimState[" + i + "] = " + mInsertSimState[i]);
        }
        List<SubscriptionInfo> subInfos = this.mSubscriptionManager.getActiveSubscriptionInfoList();
        int nSubCount = subInfos == null ? 0 : subInfos.size();
        this.logd("updateSubscriptionInfoByIccId: nSubCount = " + nSubCount);
        for (int i6 = 0; i6 < nSubCount; ++i6) {
            SubscriptionInfo temp = subInfos.get(i6);
            String msisdn = TelephonyManager.getDefault().getLine1Number(temp.getSubscriptionId());
            if (msisdn == null) continue;
            ContentValues value = new ContentValues(1);
            value.put("number", msisdn);
            contentResolver.update(SubscriptionManager.CONTENT_URI, value, "_id=" + Integer.toString(temp.getSubscriptionId()), null);
        }
        SubscriptionInfoUpdater subscriptionInfoUpdater = this;
        this.mSubscriptionManager.setDefaultDataSubId(subscriptionInfoUpdater.mSubscriptionManager.getDefaultDataSubscriptionId());
        SubscriptionController.getInstance().notifySubscriptionInfoChanged();
        this.logd("updateSubscriptionInfoByIccId:- SsubscriptionInfo update complete");
    }

    private final boolean $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$isNewSim(String iccId, String[] oldIccId) {
        boolean newSim = true;
        for (int i = 0; i < PROJECT_SIM_NUM; ++i) {
            if (!iccId.equals(oldIccId[i])) continue;
            newSim = false;
            break;
        }
        this.logd("newSim = " + newSim);
        return newSim;
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$broadcastSimStateChanged(int slotId, String state, String reason) {
        Intent i = new Intent("android.intent.action.SIM_STATE_CHANGED");
        i.addFlags(0x4000000);
        i.putExtra("phoneName", "Phone");
        i.putExtra("ss", state);
        i.putExtra("reason", reason);
        SubscriptionManager.putPhoneIdAndSubIdExtra(i, slotId);
        this.logd("Broadcasting intent ACTION_SIM_STATE_CHANGED " + state + " reason " + reason + " for mCardIndex: " + slotId);
        ActivityManagerNative.broadcastStickyIntent(i, "android.permission.READ_PHONE_STATE", -1);
        if (!this.mUserManager.isUserUnlocked()) {
            this.rebroadcastIntentsOnUnlock.put(slotId, i);
        }
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$dispose() {
        this.logd("[dispose]");
        mContext.unregisterReceiver(this.sReceiver);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$logd(String message) {
        Rlog.d("SubscriptionInfoUpdater", message);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("SubscriptionInfoUpdater:");
        this.mCarrierServiceBindHelper.dump(fd, pw, args);
    }

    static void __staticInitializer__() {
        PROJECT_SIM_NUM = TelephonyManager.getDefault().getPhoneCount();
        mContext = null;
        mIccId = new String[PROJECT_SIM_NUM];
        mInsertSimState = new int[PROJECT_SIM_NUM];
    }

    private void __constructor__(Context context, Phone[] phoneArray, CommandsInterface[] commandsInterfaceArray) {
        this.$$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$__constructor__(context, phoneArray, commandsInterfaceArray);
    }

    public SubscriptionInfoUpdater(Context context, Phone[] phoneArray, CommandsInterface[] commandsInterfaceArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$__constructor__(android.content.Context com.android.internal.telephony.Phone[] com.android.internal.telephony.CommandsInterface[] ), 0, this, context, phoneArray, commandsInterfaceArray);
    }

    private void initializeCarrierApps() {
        InvokeDynamicSupport.bootstrap("initializeCarrierApps", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$initializeCarrierApps(), 0, this);
    }

    private boolean isAllIccIdQueryDone() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAllIccIdQueryDone", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$isAllIccIdQueryDone(), 0, this);
    }

    public void setDisplayNameForNewSub(String string2, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setDisplayNameForNewSub", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$setDisplayNameForNewSub(java.lang.String int int ), 0, this, string2, n, n2);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$handleMessage(android.os.Message ), 0, this, message);
    }

    private void handleSimLocked(int n, String string2) {
        InvokeDynamicSupport.bootstrap("handleSimLocked", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$handleSimLocked(int java.lang.String ), 0, this, n, string2);
    }

    private void handleSimLoaded(int n) {
        InvokeDynamicSupport.bootstrap("handleSimLoaded", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$handleSimLoaded(int ), 0, this, n);
    }

    private void updateCarrierServices(int n, String string2) {
        InvokeDynamicSupport.bootstrap("updateCarrierServices", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$updateCarrierServices(int java.lang.String ), 0, this, n, string2);
    }

    private void handleSimAbsent(int n) {
        InvokeDynamicSupport.bootstrap("handleSimAbsent", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$handleSimAbsent(int ), 0, this, n);
    }

    private synchronized void updateSubscriptionInfoByIccId() {
        InvokeDynamicSupport.bootstrap("updateSubscriptionInfoByIccId", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$updateSubscriptionInfoByIccId(), 0, this);
    }

    private boolean isNewSim(String string2, String[] stringArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("isNewSim", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$isNewSim(java.lang.String java.lang.String[] ), 0, this, string2, stringArray);
    }

    private void broadcastSimStateChanged(int n, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("broadcastSimStateChanged", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$broadcastSimStateChanged(int java.lang.String java.lang.String ), 0, this, n, string2, string3);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$dispose(), 0, this);
    }

    private void logd(String string2) {
        InvokeDynamicSupport.bootstrap("logd", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$logd(java.lang.String ), 0, this, string2);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    static {
        RobolectricInternals.classInitializing(SubscriptionInfoUpdater.class);
    }

    public /* synthetic */ SubscriptionInfoUpdater() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SubscriptionInfoUpdater)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class QueryIccIdUserObj
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String reason;
        public int slotId;

        private void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_QueryIccIdUserObj$__constructor__(String reason, int slotId) {
            this.reason = reason;
            this.slotId = slotId;
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_QueryIccIdUserObj$__constructor__(string2, n);
        }

        QueryIccIdUserObj(String string2, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_QueryIccIdUserObj$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        public /* synthetic */ QueryIccIdUserObj() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (QueryIccIdUserObj)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

