/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.net.ConnectivityMetricsLogger;
import android.os.Bundle;
import android.telephony.ServiceState;
import com.android.ims.ImsReasonInfo;
import com.android.ims.internal.ImsCallSession;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.SmsResponse;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.dataconnection.DataCallResponse;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TelephonyEventLog
extends ConnectivityMetricsLogger
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DBG = true;
    private static boolean VDBG = false;
    public static int TAG_SETTINGS = 1;
    public static int TAG_SERVICE_STATE = 2;
    public static int TAG_IMS_CONNECTION_STATE = 3;
    public static int TAG_IMS_CAPABILITIES = 4;
    public static int TAG_DATA_CALL_LIST = 5;
    public static int TAG_PHONE_STATE = 8;
    public static int TAG_RIL_REQUEST = 1001;
    public static int TAG_RIL_RESPONSE = 1002;
    public static int TAG_RIL_UNSOL_RESPONSE = 1003;
    public static int TAG_RIL_TIMEOUT_RESPONSE = 1004;
    public static int TAG_IMS_CALL_START = 2001;
    public static int TAG_IMS_CALL_START_CONFERENCE = 2002;
    public static int TAG_IMS_CALL_RECEIVE = 2003;
    public static int TAG_IMS_CALL_ACCEPT = 2004;
    public static int TAG_IMS_CALL_REJECT = 2005;
    public static int TAG_IMS_CALL_TERMINATE = 2006;
    public static int TAG_IMS_CALL_HOLD = 2007;
    public static int TAG_IMS_CALL_RESUME = 2008;
    public static int TAG_IMS_CALL_MERGE = 2009;
    public static int TAG_IMS_CALL_UPDATE = 2010;
    public static int TAG_IMS_CALL_PROGRESSING = 2011;
    public static int TAG_IMS_CALL_STARTED = 2012;
    public static int TAG_IMS_CALL_START_FAILED = 2013;
    public static int TAG_IMS_CALL_TERMINATED = 2014;
    public static int TAG_IMS_CALL_HELD = 2015;
    public static int TAG_IMS_CALL_HOLD_FAILED = 2016;
    public static int TAG_IMS_CALL_HOLD_RECEIVED = 2017;
    public static int TAG_IMS_CALL_RESUMED = 2018;
    public static int TAG_IMS_CALL_RESUME_FAILED = 2019;
    public static int TAG_IMS_CALL_RESUME_RECEIVED = 2020;
    public static int TAG_IMS_CALL_UPDATED = 2021;
    public static int TAG_IMS_CALL_UPDATE_FAILED = 2022;
    public static int TAG_IMS_CALL_MERGED = 2023;
    public static int TAG_IMS_CALL_MERGE_FAILED = 2024;
    public static int TAG_IMS_CALL_HANDOVER = 2025;
    public static int TAG_IMS_CALL_HANDOVER_FAILED = 2026;
    public static int TAG_IMS_CALL_TTY_MODE_RECEIVED = 2027;
    public static int TAG_IMS_CONFERENCE_PARTICIPANTS_STATE_CHANGED = 2028;
    public static int TAG_IMS_MULTIPARTY_STATE_CHANGED = 2029;
    public static int TAG_IMS_CALL_STATE = 2030;
    public static int SETTING_AIRPLANE_MODE = 1;
    public static int SETTING_CELL_DATA_ENABLED = 2;
    public static int SETTING_DATA_ROAMING_ENABLED = 3;
    public static int SETTING_PREFERRED_NETWORK_MODE = 4;
    public static int SETTING_WIFI_ENABLED = 5;
    public static int SETTING_VO_LTE_ENABLED = 6;
    public static int SETTING_VO_WIFI_ENABLED = 7;
    public static int SETTING_WFC_MODE = 8;
    public static int SETTING_VI_LTE_ENABLED = 9;
    public static int SETTING_VI_WIFI_ENABLED = 10;
    public static int IMS_CONNECTION_STATE_CONNECTED = 1;
    public static int IMS_CONNECTION_STATE_PROGRESSING = 2;
    public static int IMS_CONNECTION_STATE_DISCONNECTED = 3;
    public static int IMS_CONNECTION_STATE_RESUMED = 4;
    public static int IMS_CONNECTION_STATE_SUSPENDED = 5;
    public static String DATA_KEY_PHONE_ID = "phoneId";
    public static String DATA_KEY_PARAM1 = "param1";
    public static String DATA_KEY_PARAM2 = "param2";
    public static String DATA_KEY_REASONINFO_CODE = "code";
    public static String DATA_KEY_REASONINFO_EXTRA_CODE = "extra-code";
    public static String DATA_KEY_REASONINFO_EXTRA_MESSAGE = "extra-message";
    public static String DATA_KEY_VOLTE = "VoLTE";
    public static String DATA_KEY_VILTE = "ViLTE";
    public static String DATA_KEY_VOWIFI = "VoWiFi";
    public static String DATA_KEY_VIWIFI = "ViWiFi";
    public static String DATA_KEY_UTLTE = "UTLTE";
    public static String DATA_KEY_UTWIFI = "UTWiFi";
    public static String DATA_KEY_RAT = "rat";
    public static String DATA_KEY_DATA_PROFILE = "profile";
    public static String DATA_KEY_APN = "apn";
    public static String DATA_KEY_PROTOCOL = "protocol";
    public static String DATA_KEY_DATA_DEACTIVATE_REASON = "reason";
    public static String DATA_KEY_DATA_CALL_STATUSES = "statuses";
    public static String DATA_KEY_DATA_CALL_CIDS = "cids";
    public static String DATA_KEY_DATA_CALL_ACTIVES = "actives";
    public static String DATA_KEY_DATA_CALL_TYPES = "types";
    public static String DATA_KEY_DATA_CALL_IFNAMES = "ifnames";
    public static String DATA_KEY_CLIR_MODE = "clirMode";
    public static String DATA_KEY_RIL_CALL_RING_RESPONSE = "response";
    public static String DATA_KEY_RIL_HANGUP_GSM_INDEX = "gsmIndex";
    public static String DATA_KEY_RIL_ERROR = "error";
    public static String DATA_KEY_DATA_CALL_STATUS = "status";
    public static String DATA_KEY_DATA_CALL_RETRY = "retry";
    public static String DATA_KEY_DATA_CALL_CID = "cid";
    public static String DATA_KEY_DATA_CALL_ACTIVE = "active";
    public static String DATA_KEY_DATA_CALL_TYPE = "type";
    public static String DATA_KEY_DATA_CALL_IFNAME = "ifname";
    public static String DATA_KEY_SMS_MESSAGE_REF = "messageRef";
    public static String DATA_KEY_SMS_ACK_PDU = "ackPDU";
    public static String DATA_KEY_SMS_ERROR_CODE = "errorCode";
    public static String DATA_KEY_CALLEE = "callee";
    public static String DATA_KEY_PARTICIPANTS = "participants";
    public static String DATA_KEY_SRC_TECH = "src-tech";
    public static String DATA_KEY_TARGET_TECH = "target-tech";
    public static String SERVICE_STATE_VOICE_REG_STATE = "regSt";
    public static String SERVICE_STATE_DATA_REG_STATE = "dataRegSt";
    public static String SERVICE_STATE_VOICE_ROAMING_TYPE = "roamingType";
    public static String SERVICE_STATE_DATA_ROAMING_TYPE = "dataRoamingType";
    public static String SERVICE_STATE_VOICE_ALPHA_LONG = "alphaLong";
    public static String SERVICE_STATE_VOICE_ALPNA_SHORT = "alphaShort";
    public static String SERVICE_STATE_VOICE_NUMERIC = "operator";
    public static String SERVICE_STATE_DATA_ALPHA_LONG = "dataAlphaLong";
    public static String SERVICE_STATE_DATA_ALPNA_SHORT = "dataAlphaShort";
    public static String SERVICE_STATE_DATA_NUMERIC = "dataOperator";
    public static String SERVICE_STATE_VOICE_RAT = "rat";
    public static String SERVICE_STATE_DATA_RAT = "dataRat";
    public static String SERVICE_STATE_EMERGENCY_ONLY = "emergencyOnly";
    int mPhoneId;
    private int mVoiceRegState;
    private int mDataRegState;
    private int mVoiceRoamingType;
    private int mDataRoamingType;
    private String mVoiceOperatorAlphaShort;
    private String mVoiceOperatorNumeric;
    private String mDataOperatorAlphaShort;
    private String mDataOperatorNumeric;
    private int mRilVoiceRadioTechnology;
    private int mRilDataRadioTechnology;
    private boolean mEmergencyOnly;
    private boolean[] mImsCapabilities;

    private void $$robo$$com_android_internal_telephony_TelephonyEventLog$__constructor__(int phoneId) {
        this.mVoiceRegState = -1;
        this.mDataRegState = -1;
        this.mVoiceRoamingType = -1;
        this.mDataRoamingType = -1;
        this.mRilVoiceRadioTechnology = -1;
        this.mRilDataRadioTechnology = -1;
        this.mEmergencyOnly = false;
        this.mImsCapabilities = new boolean[]{false, false, false, false, false, false};
        this.mPhoneId = phoneId;
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeEvent(int tag, Bundle data) {
        this.writeEvent((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"), tag, -1, -1, data);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeEvent(int tag, int param1, int param2) {
        this.writeEvent((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"), tag, param1, param2, null);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeEvent(int tag, int param1, int param2, Bundle data) {
        this.writeEvent((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"), tag, param1, param2, data);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeEvent(long timestamp, int tag, int param1, int param2, Bundle data) {
        Bundle b = data;
        if (b == null) {
            b = new Bundle();
        }
        b.putInt("phoneId", this.mPhoneId);
        b.putInt("param1", param1);
        b.putInt("param2", param2);
        this.logEvent(timestamp, 4, tag, b);
    }

    private static final boolean $$robo$$com_android_internal_telephony_TelephonyEventLog$equals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeServiceStateChanged(ServiceState serviceState) {
        Bundle b = new Bundle();
        boolean changed = false;
        if (this.mVoiceRegState != serviceState.getVoiceRegState()) {
            this.mVoiceRegState = serviceState.getVoiceRegState();
            b.putInt("regSt", this.mVoiceRegState);
            changed = true;
        }
        if (this.mDataRegState != serviceState.getDataRegState()) {
            this.mDataRegState = serviceState.getDataRegState();
            b.putInt("dataRegSt", this.mDataRegState);
            changed = true;
        }
        if (this.mVoiceRoamingType != serviceState.getVoiceRoamingType()) {
            this.mVoiceRoamingType = serviceState.getVoiceRoamingType();
            b.putInt("roamingType", this.mVoiceRoamingType);
            changed = true;
        }
        if (this.mDataRoamingType != serviceState.getDataRoamingType()) {
            this.mDataRoamingType = serviceState.getDataRoamingType();
            b.putInt("dataRoamingType", this.mDataRoamingType);
            changed = true;
        }
        if (!TelephonyEventLog.equals(this.mVoiceOperatorAlphaShort, serviceState.getVoiceOperatorAlphaShort()) || !TelephonyEventLog.equals(this.mVoiceOperatorNumeric, serviceState.getVoiceOperatorNumeric())) {
            this.mVoiceOperatorAlphaShort = serviceState.getVoiceOperatorAlphaShort();
            this.mVoiceOperatorNumeric = serviceState.getVoiceOperatorNumeric();
            b.putString("alphaShort", this.mVoiceOperatorAlphaShort);
            b.putString("operator", this.mVoiceOperatorNumeric);
            changed = true;
        }
        if (!TelephonyEventLog.equals(this.mDataOperatorAlphaShort, serviceState.getDataOperatorAlphaShort()) || !TelephonyEventLog.equals(this.mDataOperatorNumeric, serviceState.getDataOperatorNumeric())) {
            this.mDataOperatorAlphaShort = serviceState.getDataOperatorAlphaShort();
            this.mDataOperatorNumeric = serviceState.getDataOperatorNumeric();
            b.putString("dataAlphaShort", this.mDataOperatorAlphaShort);
            b.putString("dataOperator", this.mDataOperatorNumeric);
            changed = true;
        }
        if (this.mRilVoiceRadioTechnology != serviceState.getRilVoiceRadioTechnology()) {
            this.mRilVoiceRadioTechnology = serviceState.getRilVoiceRadioTechnology();
            b.putInt("rat", this.mRilVoiceRadioTechnology);
            changed = true;
        }
        if (this.mRilDataRadioTechnology != serviceState.getRilDataRadioTechnology()) {
            this.mRilDataRadioTechnology = serviceState.getRilDataRadioTechnology();
            b.putInt("dataRat", this.mRilDataRadioTechnology);
            changed = true;
        }
        if (this.mEmergencyOnly != serviceState.isEmergencyOnly()) {
            this.mEmergencyOnly = serviceState.isEmergencyOnly();
            b.putBoolean("emergencyOnly", this.mEmergencyOnly);
            changed = true;
        }
        if (changed) {
            this.writeEvent(2, b);
        }
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeSetAirplaneMode(boolean enabled) {
        this.writeEvent(1, 1, enabled ? 1 : 0);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeSetCellDataEnabled(boolean enabled) {
        this.writeEvent(1, 2, enabled ? 1 : 0);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeSetDataRoamingEnabled(boolean enabled) {
        this.writeEvent(1, 3, enabled ? 1 : 0);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeSetPreferredNetworkType(int mode) {
        this.writeEvent(1, 4, mode);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeSetWifiEnabled(boolean enabled) {
        this.writeEvent(1, 5, enabled ? 1 : 0);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeSetWfcMode(int mode) {
        this.writeEvent(1, 8, mode);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeImsSetFeatureValue(int feature, int network, int value, int status) {
        switch (feature) {
            case 0: {
                this.writeEvent(1, 6, value);
                break;
            }
            case 2: {
                this.writeEvent(1, 7, value);
                break;
            }
            case 1: {
                this.writeEvent(1, 9, value);
                break;
            }
            case 3: {
                this.writeEvent(1, 10, value);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsConnectionState(int state, ImsReasonInfo reasonInfo) {
        this.writeEvent(3, state, -1, this.imsReasonInfoToBundle(reasonInfo));
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCapabilities(boolean[] capabilities) {
        boolean changed = false;
        for (int i = 0; i < capabilities.length; ++i) {
            if (this.mImsCapabilities[i] == capabilities[i]) continue;
            this.mImsCapabilities[i] = capabilities[i];
            changed = true;
        }
        if (changed) {
            Bundle b = new Bundle();
            b.putBoolean("VoLTE", capabilities[0]);
            b.putBoolean("ViLTE", capabilities[1]);
            b.putBoolean("VoWiFi", capabilities[2]);
            b.putBoolean("ViWiFi", capabilities[3]);
            b.putBoolean("UTLTE", capabilities[4]);
            b.putBoolean("UTWiFi", capabilities[5]);
            this.writeEvent(4, b);
        }
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeRilSetupDataCall(int rilSerial, int radioTechnology, int profile, String apn, String user, String password, int authType, String protocol) {
        Bundle b = new Bundle();
        b.putInt("rat", radioTechnology);
        b.putInt("profile", profile);
        b.putString("apn", apn);
        b.putString("protocol", protocol);
        this.writeEvent(1001, 27, rilSerial, b);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeRilDeactivateDataCall(int rilSerial, int cid, int reason) {
        Bundle b = new Bundle();
        b.putInt("cid", cid);
        b.putInt("reason", reason);
        this.writeEvent(1001, 41, rilSerial, b);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeRilDataCallList(ArrayList<DataCallResponse> dcsList) {
        Bundle b = new Bundle();
        int[] statuses = new int[dcsList.size()];
        int[] cids = new int[dcsList.size()];
        int[] actives = new int[dcsList.size()];
        String[] types = new String[dcsList.size()];
        String[] ifnames = new String[dcsList.size()];
        for (int i = 0; i < dcsList.size(); ++i) {
            DataCallResponse dcs = dcsList.get(i);
            statuses[i] = dcs.status;
            cids[i] = dcs.cid;
            actives[i] = dcs.active;
            types[i] = dcs.type;
            ifnames[i] = dcs.ifname;
        }
        b.putIntArray("statuses", statuses);
        b.putIntArray("cids", cids);
        b.putIntArray("actives", actives);
        b.putStringArray("types", types);
        b.putStringArray("ifnames", ifnames);
        this.writeEvent(5, -1, -1, b);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeRilDial(int rilSerial, int clirMode, UUSInfo uusInfo) {
        Bundle b = new Bundle();
        b.putInt("clirMode", clirMode);
        this.writeEvent(1001, 10, rilSerial, b);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeRilCallRing(char[] response) {
        Bundle b = new Bundle();
        b.putCharArray("response", response);
        this.writeEvent(1003, 1018, -1, b);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeRilHangup(int rilSerial, int req, int gsmIndex) {
        Bundle b = new Bundle();
        b.putInt("gsmIndex", gsmIndex);
        this.writeEvent(1001, req, rilSerial, b);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeRilAnswer(int rilSerial) {
        this.writeEvent(1001, 40, rilSerial, null);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeRilSrvcc(int rilSrvccState) {
        this.writeEvent(1003, 1039, rilSrvccState, null);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeRilSendSms(int rilSerial, int req) {
        this.writeEvent(1001, req, rilSerial, null);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeRilNewSms(int response) {
        this.writeEvent(1003, response, -1, null);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnRilSolicitedResponse(int rilSerial, int rilError, int rilRequest, Object ret) {
        Bundle b = new Bundle();
        if (rilError != 0) {
            b.putInt("error", rilError);
        }
        switch (rilRequest) {
            case 27: {
                DataCallResponse dataCall = (DataCallResponse)ret;
                b.putInt("status", dataCall.status);
                b.putInt("retry", dataCall.suggestedRetryTime);
                b.putInt("cid", dataCall.cid);
                b.putInt("active", dataCall.active);
                b.putString("type", dataCall.type);
                b.putString("ifname", dataCall.ifname);
                this.writeEvent(1002, rilRequest, rilSerial, b);
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 40: 
            case 41: {
                this.writeEvent(1002, rilRequest, rilSerial, b);
                break;
            }
            case 25: 
            case 26: 
            case 87: 
            case 113: {
                SmsResponse smsResponse = (SmsResponse)ret;
                b.putInt("messageRef", smsResponse.mMessageRef);
                b.putString("ackPDU", smsResponse.mAckPdu);
                b.putInt("errorCode", smsResponse.mErrorCode);
                this.writeEvent(1002, rilRequest, rilSerial, b);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnRilTimeoutResponse(int rilSerial, int rilRequest) {
        this.writeEvent(1004, rilRequest, rilSerial, null);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writePhoneState(PhoneConstants.State phoneState) {
        int state;
        switch (1.$SwitchMap$com$android$internal$telephony$PhoneConstants$State[phoneState.ordinal()]) {
            case 1: {
                state = 0;
                break;
            }
            case 2: {
                state = 1;
                break;
            }
            case 3: {
                state = 2;
                break;
            }
            default: {
                state = -1;
            }
        }
        this.writeEvent(8, state, -1);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeImsCallState(ImsCallSession session, Call.State callState) {
        int state;
        switch (1.$SwitchMap$com$android$internal$telephony$Call$State[callState.ordinal()]) {
            case 1: {
                state = 0;
                break;
            }
            case 2: {
                state = 1;
                break;
            }
            case 3: {
                state = 2;
                break;
            }
            case 4: {
                state = 3;
                break;
            }
            case 5: {
                state = 4;
                break;
            }
            case 6: {
                state = 5;
                break;
            }
            case 7: {
                state = 6;
                break;
            }
            case 8: {
                state = 7;
                break;
            }
            case 9: {
                state = 8;
                break;
            }
            default: {
                state = -1;
            }
        }
        this.writeEvent(2030, this.getCallId(session), state);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeImsCallEvent(int tag, ImsCallSession session) {
        this.writeEvent(tag, this.getCallId(session), -1);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeImsCallEvent(int tag, ImsCallSession session, ImsReasonInfo reasonInfo) {
        this.writeEvent(tag, this.getCallId(session), -1, this.imsReasonInfoToBundle(reasonInfo));
    }

    private final Bundle $$robo$$com_android_internal_telephony_TelephonyEventLog$imsReasonInfoToBundle(ImsReasonInfo reasonInfo) {
        if (reasonInfo != null) {
            Bundle b = new Bundle();
            b.putInt("code", reasonInfo.mCode);
            b.putInt("extra-code", reasonInfo.mExtraCode);
            b.putString("extra-message", reasonInfo.mExtraMessage);
            return b;
        }
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallStart(ImsCallSession session, String callee) {
        Bundle b = new Bundle();
        b.putString("callee", callee);
        this.writeEvent(2001, this.getCallId(session), -1, b);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallStartConference(ImsCallSession session, String[] participants) {
        Bundle b = new Bundle();
        b.putStringArray("participants", participants);
        this.writeEvent(2002, this.getCallId(session), -1, b);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallReceive(ImsCallSession session) {
        this.writeImsCallEvent(2003, session);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallAccept(ImsCallSession session) {
        this.writeImsCallEvent(2004, session);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallReject(ImsCallSession session) {
        this.writeImsCallEvent(2005, session);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallTerminate(ImsCallSession session) {
        this.writeImsCallEvent(2006, session);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallHold(ImsCallSession session) {
        this.writeImsCallEvent(2007, session);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallResume(ImsCallSession session) {
        this.writeImsCallEvent(2008, session);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallProgressing(ImsCallSession session) {
        this.writeImsCallEvent(2011, session);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallStarted(ImsCallSession session) {
        this.writeImsCallEvent(2012, session);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallStartFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        this.writeImsCallEvent(2013, session, reasonInfo);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallTerminated(ImsCallSession session, ImsReasonInfo reasonInfo) {
        this.writeImsCallEvent(2014, session, reasonInfo);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallHeld(ImsCallSession session) {
        this.writeImsCallEvent(2015, session);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallHoldReceived(ImsCallSession session) {
        this.writeImsCallEvent(2017, session);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallHoldFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        this.writeImsCallEvent(2016, session, reasonInfo);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallResumed(ImsCallSession session) {
        this.writeImsCallEvent(2018, session);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallResumeReceived(ImsCallSession session) {
        this.writeImsCallEvent(2020, session);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallResumeFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        this.writeImsCallEvent(2019, session, reasonInfo);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallHandover(ImsCallSession session, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
        Bundle b = this.imsHandoverToBundle(srcAccessTech, targetAccessTech, reasonInfo);
        this.writeEvent(2025, this.getCallId(session), -1, b);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallHandoverFailed(ImsCallSession session, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
        Bundle b = this.imsHandoverToBundle(srcAccessTech, targetAccessTech, reasonInfo);
        this.writeEvent(2026, this.getCallId(session), -1, b);
    }

    private final int $$robo$$com_android_internal_telephony_TelephonyEventLog$getCallId(ImsCallSession session) {
        if (session == null) {
            return -1;
        }
        try {
            return Integer.parseInt(session.getCallId());
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private final Bundle $$robo$$com_android_internal_telephony_TelephonyEventLog$imsHandoverToBundle(int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
        Bundle b = new Bundle();
        b.putInt("src-tech", srcAccessTech);
        b.putInt("target-tech", targetAccessTech);
        b.putInt("code", reasonInfo.mCode);
        b.putInt("extra-code", reasonInfo.mExtraCode);
        b.putString("extra-message", reasonInfo.mExtraMessage);
        return b;
    }

    static void __staticInitializer__() {
        TAG = "TelephonyEventLog";
    }

    private void __constructor__(int n) {
        this.$$robo$$com_android_internal_telephony_TelephonyEventLog$__constructor__(n);
    }

    public TelephonyEventLog(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_TelephonyEventLog$__constructor__(int ), 0, this, n);
    }

    private void writeEvent(int n, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("writeEvent", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeEvent(int android.os.Bundle ), 0, this, n, bundle);
    }

    private void writeEvent(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("writeEvent", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeEvent(int int int ), 0, this, n, n2, n3);
    }

    private void writeEvent(int n, int n2, int n3, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("writeEvent", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeEvent(int int int android.os.Bundle ), 0, this, n, n2, n3, bundle);
    }

    private void writeEvent(long l, int n, int n2, int n3, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("writeEvent", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeEvent(long int int int android.os.Bundle ), 0, this, l, n, n2, n3, bundle);
    }

    public static boolean equals(Object object, Object object2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("equals", $$robo$$com_android_internal_telephony_TelephonyEventLog$equals(java.lang.Object java.lang.Object ), 0, (Object)object, (Object)object2);
    }

    public void writeServiceStateChanged(ServiceState serviceState) {
        InvokeDynamicSupport.bootstrap("writeServiceStateChanged", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeServiceStateChanged(android.telephony.ServiceState ), 0, this, serviceState);
    }

    public void writeSetAirplaneMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("writeSetAirplaneMode", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeSetAirplaneMode(boolean ), 0, this, bl);
    }

    public void writeSetCellDataEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("writeSetCellDataEnabled", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeSetCellDataEnabled(boolean ), 0, this, bl);
    }

    public void writeSetDataRoamingEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("writeSetDataRoamingEnabled", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeSetDataRoamingEnabled(boolean ), 0, this, bl);
    }

    public void writeSetPreferredNetworkType(int n) {
        InvokeDynamicSupport.bootstrap("writeSetPreferredNetworkType", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeSetPreferredNetworkType(int ), 0, this, n);
    }

    public void writeSetWifiEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("writeSetWifiEnabled", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeSetWifiEnabled(boolean ), 0, this, bl);
    }

    public void writeSetWfcMode(int n) {
        InvokeDynamicSupport.bootstrap("writeSetWfcMode", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeSetWfcMode(int ), 0, this, n);
    }

    public void writeImsSetFeatureValue(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("writeImsSetFeatureValue", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeImsSetFeatureValue(int int int int ), 0, this, n, n2, n3, n4);
    }

    public void writeOnImsConnectionState(int n, ImsReasonInfo imsReasonInfo) {
        InvokeDynamicSupport.bootstrap("writeOnImsConnectionState", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsConnectionState(int com.android.ims.ImsReasonInfo ), 0, this, n, imsReasonInfo);
    }

    public void writeOnImsCapabilities(boolean[] blArray) {
        InvokeDynamicSupport.bootstrap("writeOnImsCapabilities", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCapabilities(boolean[] ), 0, this, blArray);
    }

    public void writeRilSetupDataCall(int n, int n2, int n3, String string2, String string3, String string4, int n4, String string5) {
        InvokeDynamicSupport.bootstrap("writeRilSetupDataCall", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeRilSetupDataCall(int int int java.lang.String java.lang.String java.lang.String int java.lang.String ), 0, this, n, n2, n3, string2, string3, string4, n4, string5);
    }

    public void writeRilDeactivateDataCall(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("writeRilDeactivateDataCall", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeRilDeactivateDataCall(int int int ), 0, this, n, n2, n3);
    }

    public void writeRilDataCallList(ArrayList<DataCallResponse> arrayList) {
        InvokeDynamicSupport.bootstrap("writeRilDataCallList", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeRilDataCallList(java.util.ArrayList<com.android.internal.telephony.dataconnection.DataCallResponse> ), 0, this, arrayList);
    }

    public void writeRilDial(int n, int n2, UUSInfo uUSInfo) {
        InvokeDynamicSupport.bootstrap("writeRilDial", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeRilDial(int int com.android.internal.telephony.UUSInfo ), 0, this, n, n2, uUSInfo);
    }

    public void writeRilCallRing(char[] cArray) {
        InvokeDynamicSupport.bootstrap("writeRilCallRing", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeRilCallRing(char[] ), 0, this, cArray);
    }

    public void writeRilHangup(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("writeRilHangup", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeRilHangup(int int int ), 0, this, n, n2, n3);
    }

    public void writeRilAnswer(int n) {
        InvokeDynamicSupport.bootstrap("writeRilAnswer", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeRilAnswer(int ), 0, this, n);
    }

    public void writeRilSrvcc(int n) {
        InvokeDynamicSupport.bootstrap("writeRilSrvcc", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeRilSrvcc(int ), 0, this, n);
    }

    public void writeRilSendSms(int n, int n2) {
        InvokeDynamicSupport.bootstrap("writeRilSendSms", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeRilSendSms(int int ), 0, this, n, n2);
    }

    public void writeRilNewSms(int n) {
        InvokeDynamicSupport.bootstrap("writeRilNewSms", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeRilNewSms(int ), 0, this, n);
    }

    public void writeOnRilSolicitedResponse(int n, int n2, int n3, Object object) {
        InvokeDynamicSupport.bootstrap("writeOnRilSolicitedResponse", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnRilSolicitedResponse(int int int java.lang.Object ), 0, this, n, n2, n3, object);
    }

    public void writeOnRilTimeoutResponse(int n, int n2) {
        InvokeDynamicSupport.bootstrap("writeOnRilTimeoutResponse", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnRilTimeoutResponse(int int ), 0, this, n, n2);
    }

    public void writePhoneState(PhoneConstants.State state) {
        InvokeDynamicSupport.bootstrap("writePhoneState", $$robo$$com_android_internal_telephony_TelephonyEventLog$writePhoneState(com.android.internal.telephony.PhoneConstants$State ), 0, this, state);
    }

    public void writeImsCallState(ImsCallSession imsCallSession, Call.State state) {
        InvokeDynamicSupport.bootstrap("writeImsCallState", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeImsCallState(com.android.ims.internal.ImsCallSession com.android.internal.telephony.Call$State ), 0, this, imsCallSession, state);
    }

    private void writeImsCallEvent(int n, ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeImsCallEvent", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeImsCallEvent(int com.android.ims.internal.ImsCallSession ), 0, this, n, imsCallSession);
    }

    private void writeImsCallEvent(int n, ImsCallSession imsCallSession, ImsReasonInfo imsReasonInfo) {
        InvokeDynamicSupport.bootstrap("writeImsCallEvent", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeImsCallEvent(int com.android.ims.internal.ImsCallSession com.android.ims.ImsReasonInfo ), 0, this, n, imsCallSession, imsReasonInfo);
    }

    private Bundle imsReasonInfoToBundle(ImsReasonInfo imsReasonInfo) {
        return InvokeDynamicSupport.bootstrap("imsReasonInfoToBundle", $$robo$$com_android_internal_telephony_TelephonyEventLog$imsReasonInfoToBundle(com.android.ims.ImsReasonInfo ), 0, this, imsReasonInfo);
    }

    public void writeOnImsCallStart(ImsCallSession imsCallSession, String string2) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallStart", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallStart(com.android.ims.internal.ImsCallSession java.lang.String ), 0, this, imsCallSession, string2);
    }

    public void writeOnImsCallStartConference(ImsCallSession imsCallSession, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallStartConference", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallStartConference(com.android.ims.internal.ImsCallSession java.lang.String[] ), 0, this, imsCallSession, stringArray);
    }

    public void writeOnImsCallReceive(ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallReceive", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallReceive(com.android.ims.internal.ImsCallSession ), 0, this, imsCallSession);
    }

    public void writeOnImsCallAccept(ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallAccept", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallAccept(com.android.ims.internal.ImsCallSession ), 0, this, imsCallSession);
    }

    public void writeOnImsCallReject(ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallReject", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallReject(com.android.ims.internal.ImsCallSession ), 0, this, imsCallSession);
    }

    public void writeOnImsCallTerminate(ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallTerminate", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallTerminate(com.android.ims.internal.ImsCallSession ), 0, this, imsCallSession);
    }

    public void writeOnImsCallHold(ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallHold", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallHold(com.android.ims.internal.ImsCallSession ), 0, this, imsCallSession);
    }

    public void writeOnImsCallResume(ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallResume", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallResume(com.android.ims.internal.ImsCallSession ), 0, this, imsCallSession);
    }

    public void writeOnImsCallProgressing(ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallProgressing", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallProgressing(com.android.ims.internal.ImsCallSession ), 0, this, imsCallSession);
    }

    public void writeOnImsCallStarted(ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallStarted", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallStarted(com.android.ims.internal.ImsCallSession ), 0, this, imsCallSession);
    }

    public void writeOnImsCallStartFailed(ImsCallSession imsCallSession, ImsReasonInfo imsReasonInfo) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallStartFailed", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallStartFailed(com.android.ims.internal.ImsCallSession com.android.ims.ImsReasonInfo ), 0, this, imsCallSession, imsReasonInfo);
    }

    public void writeOnImsCallTerminated(ImsCallSession imsCallSession, ImsReasonInfo imsReasonInfo) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallTerminated", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallTerminated(com.android.ims.internal.ImsCallSession com.android.ims.ImsReasonInfo ), 0, this, imsCallSession, imsReasonInfo);
    }

    public void writeOnImsCallHeld(ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallHeld", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallHeld(com.android.ims.internal.ImsCallSession ), 0, this, imsCallSession);
    }

    public void writeOnImsCallHoldReceived(ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallHoldReceived", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallHoldReceived(com.android.ims.internal.ImsCallSession ), 0, this, imsCallSession);
    }

    public void writeOnImsCallHoldFailed(ImsCallSession imsCallSession, ImsReasonInfo imsReasonInfo) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallHoldFailed", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallHoldFailed(com.android.ims.internal.ImsCallSession com.android.ims.ImsReasonInfo ), 0, this, imsCallSession, imsReasonInfo);
    }

    public void writeOnImsCallResumed(ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallResumed", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallResumed(com.android.ims.internal.ImsCallSession ), 0, this, imsCallSession);
    }

    public void writeOnImsCallResumeReceived(ImsCallSession imsCallSession) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallResumeReceived", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallResumeReceived(com.android.ims.internal.ImsCallSession ), 0, this, imsCallSession);
    }

    public void writeOnImsCallResumeFailed(ImsCallSession imsCallSession, ImsReasonInfo imsReasonInfo) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallResumeFailed", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallResumeFailed(com.android.ims.internal.ImsCallSession com.android.ims.ImsReasonInfo ), 0, this, imsCallSession, imsReasonInfo);
    }

    public void writeOnImsCallHandover(ImsCallSession imsCallSession, int n, int n2, ImsReasonInfo imsReasonInfo) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallHandover", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallHandover(com.android.ims.internal.ImsCallSession int int com.android.ims.ImsReasonInfo ), 0, this, imsCallSession, n, n2, imsReasonInfo);
    }

    public void writeOnImsCallHandoverFailed(ImsCallSession imsCallSession, int n, int n2, ImsReasonInfo imsReasonInfo) {
        InvokeDynamicSupport.bootstrap("writeOnImsCallHandoverFailed", $$robo$$com_android_internal_telephony_TelephonyEventLog$writeOnImsCallHandoverFailed(com.android.ims.internal.ImsCallSession int int com.android.ims.ImsReasonInfo ), 0, this, imsCallSession, n, n2, imsReasonInfo);
    }

    private int getCallId(ImsCallSession imsCallSession) {
        return (int)InvokeDynamicSupport.bootstrap("getCallId", $$robo$$com_android_internal_telephony_TelephonyEventLog$getCallId(com.android.ims.internal.ImsCallSession ), 0, this, imsCallSession);
    }

    private Bundle imsHandoverToBundle(int n, int n2, ImsReasonInfo imsReasonInfo) {
        return InvokeDynamicSupport.bootstrap("imsHandoverToBundle", $$robo$$com_android_internal_telephony_TelephonyEventLog$imsHandoverToBundle(int int com.android.ims.ImsReasonInfo ), 0, this, n, n2, imsReasonInfo);
    }

    static {
        RobolectricInternals.classInitializing(TelephonyEventLog.class);
    }

    public /* synthetic */ TelephonyEventLog() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TelephonyEventLog)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

