/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.util.ArrayMap;
import android.util.Log;
import com.android.ims.ImsCallProfile;
import com.android.ims.ImsExternalCallState;
import com.android.ims.ImsExternalCallStateListener;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.imsphone.ImsExternalConnection;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.imsphone.ImsPullCall;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImsExternalCallTracker
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String TAG = "ImsExternalCallTracker";
    public static String EXTRA_IMS_EXTERNAL_CALL_ID = "android.telephony.ImsExternalCallTracker.extra.EXTERNAL_CALL_ID";
    private Map<Integer, ImsExternalConnection> mExternalConnections;
    private ImsPhone mPhone;
    private ExternalCallStateListener mExternalCallStateListener;
    private ExternalConnectionListener mExternalConnectionListener;
    private ImsPullCall mCallPuller;

    private void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$__constructor__(ImsPhone phone, ImsPullCall callPuller) {
        this.mExternalConnections = new ArrayMap<Integer, ImsExternalConnection>();
        this.mExternalConnectionListener = new ExternalConnectionListener(this);
        this.mPhone = phone;
        this.mExternalCallStateListener = new ExternalCallStateListener(this);
        this.mCallPuller = callPuller;
    }

    private final ExternalCallStateListener $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$getExternalCallStateListener() {
        return this.mExternalCallStateListener;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$refreshExternalCallState(List<ImsExternalCallState> externalCallStates) {
        Log.d("ImsExternalCallTracker", "refreshExternalCallState: depSize = " + externalCallStates.size());
        Iterator<Map.Entry<Integer, ImsExternalConnection>> connectionIterator = this.mExternalConnections.entrySet().iterator();
        boolean wasCallRemoved = false;
        while (connectionIterator.hasNext()) {
            Map.Entry<Integer, ImsExternalConnection> entry = connectionIterator.next();
            int callId = entry.getKey();
            if (this.containsCallId(externalCallStates, callId)) continue;
            ImsExternalConnection externalConnection = entry.getValue();
            externalConnection.setTerminated();
            externalConnection.removeListener(this.mExternalConnectionListener);
            connectionIterator.remove();
            wasCallRemoved = true;
        }
        if (wasCallRemoved) {
            this.mPhone.notifyPreciseCallStateChanged();
        }
        for (ImsExternalCallState callState : externalCallStates) {
            if (!this.mExternalConnections.containsKey(callState.getCallId())) {
                Log.d("ImsExternalCallTracker", "refreshExternalCallState: got = " + callState);
                if (callState.getCallState() != 1) continue;
                this.createExternalConnection(callState);
                continue;
            }
            this.updateExistingConnection(this.mExternalConnections.get(callState.getCallId()), callState);
        }
    }

    private final Connection $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$getConnectionById(int callId) {
        return this.mExternalConnections.get(callId);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$createExternalConnection(ImsExternalCallState state) {
        Log.i("ImsExternalCallTracker", "createExternalConnection");
        ImsExternalConnection connection = new ImsExternalConnection(this.mPhone, state.getCallId(), state.getAddress().getSchemeSpecificPart(), state.isCallPullable());
        connection.setVideoState(ImsCallProfile.getVideoStateFromCallType(state.getCallType()));
        connection.addListener(this.mExternalConnectionListener);
        this.mExternalConnections.put(connection.getCallId(), connection);
        this.mPhone.notifyUnknownConnection(connection);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$updateExistingConnection(ImsExternalConnection connection, ImsExternalCallState state) {
        Call.State newState;
        Call.State existingState = connection.getState();
        Call.State state2 = newState = state.getCallState() == 1 ? Call.State.ACTIVE : Call.State.DISCONNECTED;
        if (existingState != newState) {
            if (newState == Call.State.ACTIVE) {
                connection.setActive();
            } else {
                connection.setTerminated();
                connection.removeListener(this.mExternalConnectionListener);
                this.mExternalConnections.remove(connection);
                this.mPhone.notifyPreciseCallStateChanged();
            }
        }
        connection.setIsPullable(state.isCallPullable());
        int newVideoState = ImsCallProfile.getVideoStateFromCallType(state.getCallType());
        if (newVideoState != connection.getVideoState()) {
            connection.setVideoState(newVideoState);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$containsCallId(List<ImsExternalCallState> externalCallStates, int callId) {
        for (ImsExternalCallState state : externalCallStates) {
            if (state.getCallId() != callId) continue;
            return true;
        }
        return false;
    }

    private void __constructor__(ImsPhone imsPhone, ImsPullCall imsPullCall) {
        this.$$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$__constructor__(imsPhone, imsPullCall);
    }

    public ImsExternalCallTracker(ImsPhone imsPhone, ImsPullCall imsPullCall) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$__constructor__(com.android.internal.telephony.imsphone.ImsPhone com.android.internal.telephony.imsphone.ImsPullCall ), 0, this, imsPhone, imsPullCall);
    }

    public ExternalCallStateListener getExternalCallStateListener() {
        return InvokeDynamicSupport.bootstrap("getExternalCallStateListener", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$getExternalCallStateListener(), 0, this);
    }

    public void refreshExternalCallState(List<ImsExternalCallState> list) {
        InvokeDynamicSupport.bootstrap("refreshExternalCallState", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$refreshExternalCallState(java.util.List<com.android.ims.ImsExternalCallState> ), 0, this, list);
    }

    public Connection getConnectionById(int n) {
        return InvokeDynamicSupport.bootstrap("getConnectionById", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$getConnectionById(int ), 0, this, n);
    }

    private void createExternalConnection(ImsExternalCallState imsExternalCallState) {
        InvokeDynamicSupport.bootstrap("createExternalConnection", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$createExternalConnection(com.android.ims.ImsExternalCallState ), 0, this, imsExternalCallState);
    }

    private void updateExistingConnection(ImsExternalConnection imsExternalConnection, ImsExternalCallState imsExternalCallState) {
        InvokeDynamicSupport.bootstrap("updateExistingConnection", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$updateExistingConnection(com.android.internal.telephony.imsphone.ImsExternalConnection com.android.ims.ImsExternalCallState ), 0, this, imsExternalConnection, imsExternalCallState);
    }

    private boolean containsCallId(List<ImsExternalCallState> list, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsCallId", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$containsCallId(java.util.List<com.android.ims.ImsExternalCallState> int ), 0, this, list, n);
    }

    public /* synthetic */ ImsExternalCallTracker() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsExternalCallTracker)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class ExternalConnectionListener
    implements ImsExternalConnection.Listener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ImsExternalCallTracker this$0;

        private void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_ExternalConnectionListener$__constructor__(ImsExternalCallTracker this$0) {
        }

        private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_ExternalConnectionListener$onPullExternalCall(ImsExternalConnection connection) {
            Log.d("ImsExternalCallTracker", "onPullExternalCall: connection = " + connection);
            this.this$0.mCallPuller.pullExternalCall(connection.getAddress(), connection.getVideoState());
        }

        private void __constructor__(ImsExternalCallTracker imsExternalCallTracker) {
            this.$$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_ExternalConnectionListener$__constructor__(imsExternalCallTracker);
        }

        public ExternalConnectionListener(ImsExternalCallTracker imsExternalCallTracker) {
            this.this$0 = imsExternalCallTracker;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_ExternalConnectionListener$__constructor__(com.android.internal.telephony.imsphone.ImsExternalCallTracker ), 0, this, imsExternalCallTracker);
        }

        @Override
        public void onPullExternalCall(ImsExternalConnection imsExternalConnection) {
            InvokeDynamicSupport.bootstrap("onPullExternalCall", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_ExternalConnectionListener$onPullExternalCall(com.android.internal.telephony.imsphone.ImsExternalConnection ), 0, this, imsExternalConnection);
        }

        public /* synthetic */ ExternalConnectionListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExternalConnectionListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class ExternalCallStateListener
    extends ImsExternalCallStateListener
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ImsExternalCallTracker this$0;

        private void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_ExternalCallStateListener$__constructor__(ImsExternalCallTracker this$0) {
        }

        private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_ExternalCallStateListener$onImsExternalCallStateUpdate(List<ImsExternalCallState> externalCallState) {
            this.this$0.refreshExternalCallState(externalCallState);
        }

        private void __constructor__(ImsExternalCallTracker imsExternalCallTracker) {
            this.$$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_ExternalCallStateListener$__constructor__(imsExternalCallTracker);
        }

        public ExternalCallStateListener(ImsExternalCallTracker imsExternalCallTracker) {
            this.this$0 = imsExternalCallTracker;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_ExternalCallStateListener$__constructor__(com.android.internal.telephony.imsphone.ImsExternalCallTracker ), 0, this, imsExternalCallTracker);
        }

        public void onImsExternalCallStateUpdate(List<ImsExternalCallState> list) {
            InvokeDynamicSupport.bootstrap("onImsExternalCallStateUpdate", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_ExternalCallStateListener$onImsExternalCallStateUpdate(java.util.List<com.android.ims.ImsExternalCallState> ), 0, this, list);
        }

        public /* synthetic */ ExternalCallStateListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExternalCallStateListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

