/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telecom.ConferenceParticipant;
import android.telecom.Connection;
import android.telecom.VideoProfile;
import android.telephony.CarrierConfigManager;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.text.TextUtils;
import com.android.ims.ImsCall;
import com.android.ims.ImsCallProfile;
import com.android.ims.ImsConfigListener;
import com.android.ims.ImsConnectionStateListener;
import com.android.ims.ImsEcbm;
import com.android.ims.ImsException;
import com.android.ims.ImsManager;
import com.android.ims.ImsMultiEndpoint;
import com.android.ims.ImsReasonInfo;
import com.android.ims.ImsSuppServiceNotification;
import com.android.ims.ImsUtInterface;
import com.android.ims.internal.IImsVideoCallProvider;
import com.android.ims.internal.ImsVideoCallProviderWrapper;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneInternalInterface;
import com.android.internal.telephony.TelephonyEventLog;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.imsphone.ImsPhoneCall;
import com.android.internal.telephony.imsphone.ImsPhoneConnection;
import com.android.internal.telephony.imsphone.ImsPullCall;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImsPhoneCallTracker
extends CallTracker
implements ImsPullCall,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "ImsPhoneCallTracker";
    private static boolean DBG = true;
    private static boolean VERBOSE_STATE_LOGGING = false;
    private boolean[] mImsFeatureEnabled;
    private String[] mImsFeatureStrings;
    private TelephonyEventLog mEventLog;
    private BroadcastReceiver mReceiver;
    static int MAX_CONNECTIONS = 7;
    static int MAX_CONNECTIONS_PER_CALL = 5;
    private static int EVENT_HANGUP_PENDINGMO = 18;
    private static int EVENT_RESUME_BACKGROUND = 19;
    private static int EVENT_DIAL_PENDINGMO = 20;
    private static int EVENT_EXIT_ECBM_BEFORE_PENDINGMO = 21;
    private static int TIMEOUT_HANGUP_PENDINGMO = 500;
    private ArrayList<ImsPhoneConnection> mConnections;
    private RegistrantList mVoiceCallEndedRegistrants;
    private RegistrantList mVoiceCallStartedRegistrants;
    public ImsPhoneCall mRingingCall;
    public ImsPhoneCall mForegroundCall;
    public ImsPhoneCall mBackgroundCall;
    public ImsPhoneCall mHandoverCall;
    private ImsPhoneConnection mPendingMO;
    private int mClirMode;
    private Object mSyncHold;
    private ImsCall mUssdSession;
    private Message mPendingUssd;
    ImsPhone mPhone;
    private boolean mDesiredMute;
    private boolean mOnHoldToneStarted;
    private int mOnHoldToneId;
    private PhoneConstants.State mState;
    private ImsManager mImsManager;
    private int mServiceId;
    private Call.SrvccState mSrvccState;
    private boolean mIsInEmergencyCall;
    private int pendingCallClirMode;
    private int mPendingCallVideoState;
    private Bundle mPendingIntentExtras;
    private boolean pendingCallInEcm;
    private boolean mSwitchingFgAndBgCalls;
    private ImsCall mCallExpectedToResume;
    private boolean mAllowEmergencyVideoCalls;
    private ImsCall.Listener mImsCallListener;
    private ImsCall.Listener mImsUssdListener;
    private ImsConnectionStateListener mImsConnectionStateListener;
    private ImsConfigListener.Stub mImsConfigListener;

    private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$__constructor__(ImsPhone phone) {
        this.mImsFeatureEnabled = new boolean[]{false, false, false, false, false, false};
        this.mImsFeatureStrings = new String[]{"VoLTE", "ViLTE", "VoWiFi", "ViWiFi", "UTLTE", "UTWiFi"};
        this.mReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsPhoneCallTracker this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_1$__constructor__(ImsPhoneCallTracker this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_1$onReceive(Context context, Intent intent) {
                int subId;
                if (intent.getAction().equals("com.android.ims.IMS_INCOMING_CALL")) {
                    this.this$0.log("onReceive : incoming call intent");
                    if (this.this$0.mImsManager == null) {
                        return;
                    }
                    if (this.this$0.mServiceId < 0) {
                        return;
                    }
                    try {
                        boolean isUssd = intent.getBooleanExtra("android:ussd", false);
                        if (isUssd) {
                            this.this$0.log("onReceive : USSD");
                            this.this$0.mUssdSession = this.this$0.mImsManager.takeCall(this.this$0.mServiceId, intent, this.this$0.mImsUssdListener);
                            if (this.this$0.mUssdSession != null) {
                                this.this$0.mUssdSession.accept(2);
                            }
                            return;
                        }
                        boolean isUnknown = intent.getBooleanExtra("android:isUnknown", false);
                        this.this$0.log("onReceive : isUnknown = " + isUnknown + " fg = " + (Object)((Object)this.this$0.mForegroundCall.getState()) + " bg = " + (Object)((Object)this.this$0.mBackgroundCall.getState()));
                        ImsCall imsCall = this.this$0.mImsManager.takeCall(this.this$0.mServiceId, intent, this.this$0.mImsCallListener);
                        ImsPhoneConnection conn = new ImsPhoneConnection((Phone)this.this$0.mPhone, imsCall, this.this$0, isUnknown ? this.this$0.mForegroundCall : this.this$0.mRingingCall, isUnknown);
                        this.this$0.addConnection(conn);
                        this.this$0.setVideoCallProvider(conn, imsCall);
                        this.this$0.mEventLog.writeOnImsCallReceive(imsCall.getSession());
                        if (isUnknown) {
                            this.this$0.mPhone.notifyUnknownConnection(conn);
                        } else {
                            if (this.this$0.mForegroundCall.getState() != Call.State.IDLE || this.this$0.mBackgroundCall.getState() != Call.State.IDLE) {
                                conn.update(imsCall, Call.State.WAITING);
                            }
                            this.this$0.mPhone.notifyNewRingingConnection(conn);
                            this.this$0.mPhone.notifyIncomingRing();
                        }
                        this.this$0.updatePhoneState();
                        this.this$0.mPhone.notifyPreciseCallStateChanged();
                    }
                    catch (ImsException e) {
                        this.this$0.loge("onReceive : exception " + (Object)((Object)e));
                    }
                    catch (RemoteException e) {}
                } else if (intent.getAction().equals("android.telephony.action.CARRIER_CONFIG_CHANGED") && (subId = intent.getIntExtra("subscription", -1)) == this.this$0.mPhone.getSubId()) {
                    this.this$0.mAllowEmergencyVideoCalls = this.this$0.isEmergencyVtCallAllowed(subId);
                    this.this$0.log("onReceive : Updating mAllowEmergencyVideoCalls = " + this.this$0.mAllowEmergencyVideoCalls);
                }
            }

            private void __constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_1$__constructor__(imsPhoneCallTracker);
            }
            {
                this.this$0 = imsPhoneCallTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_1$__constructor__(com.android.internal.telephony.imsphone.ImsPhoneCallTracker ), 0, this, imsPhoneCallTracker);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnections = new ArrayList();
        this.mVoiceCallEndedRegistrants = new RegistrantList();
        this.mVoiceCallStartedRegistrants = new RegistrantList();
        this.mRingingCall = new ImsPhoneCall(this, "RG");
        this.mForegroundCall = new ImsPhoneCall(this, "FG");
        this.mBackgroundCall = new ImsPhoneCall(this, "BG");
        this.mHandoverCall = new ImsPhoneCall(this, "HO");
        this.mClirMode = 0;
        this.mSyncHold = new Object();
        this.mUssdSession = null;
        this.mPendingUssd = null;
        this.mDesiredMute = false;
        this.mOnHoldToneStarted = false;
        this.mOnHoldToneId = -1;
        this.mState = PhoneConstants.State.IDLE;
        this.mServiceId = -1;
        this.mSrvccState = Call.SrvccState.NONE;
        this.mIsInEmergencyCall = false;
        this.pendingCallInEcm = false;
        this.mSwitchingFgAndBgCalls = false;
        this.mCallExpectedToResume = null;
        this.mAllowEmergencyVideoCalls = false;
        this.mImsCallListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsPhoneCallTracker this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$__constructor__(ImsPhoneCallTracker this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallProgressing(ImsCall imsCall) {
                this.this$0.log("onCallProgressing");
                this.this$0.mPendingMO = null;
                this.this$0.processCallStateChange(imsCall, Call.State.ALERTING, 0);
                this.this$0.mEventLog.writeOnImsCallProgressing(imsCall.getCallSession());
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallStarted(ImsCall imsCall) {
                this.this$0.log("onCallStarted");
                this.this$0.mPendingMO = null;
                this.this$0.processCallStateChange(imsCall, Call.State.ACTIVE, 0);
                this.this$0.mEventLog.writeOnImsCallStarted(imsCall.getCallSession());
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallUpdated(ImsCall imsCall) {
                this.this$0.log("onCallUpdated");
                if (imsCall == null) {
                    return;
                }
                ImsPhoneConnection conn = this.this$0.findConnection(imsCall);
                if (conn != null) {
                    this.this$0.processCallStateChange(imsCall, ((ImsPhoneCall)conn.getCall()).mState, 0, true);
                    this.this$0.mEventLog.writeImsCallState(imsCall.getCallSession(), ((ImsPhoneCall)conn.getCall()).mState);
                }
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallStartFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
                this.this$0.log("onCallStartFailed reasonCode=" + reasonInfo.getCode());
                if (this.this$0.mPendingMO != null) {
                    if (reasonInfo.getCode() == 146 && this.this$0.mBackgroundCall.getState() == Call.State.IDLE && this.this$0.mRingingCall.getState() == Call.State.IDLE) {
                        this.this$0.mForegroundCall.detach(this.this$0.mPendingMO);
                        this.this$0.removeConnection(this.this$0.mPendingMO);
                        this.this$0.mPendingMO.finalize();
                        this.this$0.mPendingMO = null;
                        this.this$0.mPhone.initiateSilentRedial();
                        return;
                    }
                    this.this$0.mPendingMO = null;
                    int cause = this.this$0.getDisconnectCauseFromReasonInfo(reasonInfo);
                    this.this$0.processCallStateChange(imsCall, Call.State.DISCONNECTED, cause);
                    this.this$0.mEventLog.writeOnImsCallStartFailed(imsCall.getCallSession(), reasonInfo);
                }
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallTerminated(ImsCall imsCall, ImsReasonInfo reasonInfo) {
                this.this$0.log("onCallTerminated reasonCode=" + reasonInfo.getCode());
                Call.State oldState = this.this$0.mForegroundCall.getState();
                int cause = this.this$0.getDisconnectCauseFromReasonInfo(reasonInfo);
                ImsPhoneConnection conn = this.this$0.findConnection(imsCall);
                this.this$0.log("cause = " + cause + " conn = " + conn);
                if (this.this$0.mOnHoldToneId == System.identityHashCode(conn)) {
                    if (conn != null && this.this$0.mOnHoldToneStarted) {
                        this.this$0.mPhone.stopOnHoldTone(conn);
                    }
                    this.this$0.mOnHoldToneStarted = false;
                    this.this$0.mOnHoldToneId = -1;
                }
                if (conn != null && conn.isIncoming() && conn.getConnectTime() == 0L) {
                    cause = cause == 2 ? 1 : 16;
                    this.this$0.log("Incoming connection of 0 connect time detected - translated cause = " + cause);
                }
                if (cause == 2 && conn != null && conn.getImsCall().isMerged()) {
                    cause = 45;
                }
                this.this$0.mEventLog.writeOnImsCallTerminated(imsCall.getCallSession(), reasonInfo);
                this.this$0.processCallStateChange(imsCall, Call.State.DISCONNECTED, cause);
                if (this.this$0.mForegroundCall.getState() != Call.State.ACTIVE) {
                    if (this.this$0.mRingingCall.getState().isRinging()) {
                        this.this$0.mPendingMO = null;
                    } else if (this.this$0.mPendingMO != null) {
                        this.this$0.sendEmptyMessage(20);
                    }
                }
                if (this.this$0.mSwitchingFgAndBgCalls) {
                    this.this$0.log("onCallTerminated: Call terminated in the midst of Switching Fg and Bg calls.");
                    if (imsCall == this.this$0.mCallExpectedToResume) {
                        this.this$0.log("onCallTerminated: switching " + this.this$0.mForegroundCall + " with " + this.this$0.mBackgroundCall);
                        this.this$0.mForegroundCall.switchWith(this.this$0.mBackgroundCall);
                    }
                    if (this.this$0.mForegroundCall.getState() == Call.State.HOLDING) {
                        this.this$0.sendEmptyMessage(19);
                        this.this$0.mSwitchingFgAndBgCalls = false;
                        this.this$0.mCallExpectedToResume = null;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallHeld(ImsCall imsCall) {
                if (this.this$0.mForegroundCall.getImsCall() == imsCall) {
                    this.this$0.log("onCallHeld (fg) " + imsCall);
                } else if (this.this$0.mBackgroundCall.getImsCall() == imsCall) {
                    this.this$0.log("onCallHeld (bg) " + imsCall);
                }
                Object object = this.this$0.mSyncHold;
                synchronized (object) {
                    Call.State oldState = this.this$0.mBackgroundCall.getState();
                    this.this$0.processCallStateChange(imsCall, Call.State.HOLDING, 0);
                    if (oldState == Call.State.ACTIVE) {
                        if (this.this$0.mForegroundCall.getState() == Call.State.HOLDING || this.this$0.mRingingCall.getState() == Call.State.WAITING) {
                            this.this$0.sendEmptyMessage(19);
                        } else {
                            if (this.this$0.mPendingMO != null) {
                                this.this$0.dialPendingMO();
                            }
                            this.this$0.mSwitchingFgAndBgCalls = false;
                        }
                    } else if (oldState == Call.State.IDLE && this.this$0.mSwitchingFgAndBgCalls && this.this$0.mForegroundCall.getState() == Call.State.HOLDING) {
                        this.this$0.sendEmptyMessage(19);
                        this.this$0.mSwitchingFgAndBgCalls = false;
                        this.this$0.mCallExpectedToResume = null;
                    }
                }
                this.this$0.mEventLog.writeOnImsCallHeld(imsCall.getCallSession());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallHoldFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
                this.this$0.log("onCallHoldFailed reasonCode=" + reasonInfo.getCode());
                Object object = this.this$0.mSyncHold;
                synchronized (object) {
                    Call.State bgState = this.this$0.mBackgroundCall.getState();
                    if (reasonInfo.getCode() == 148) {
                        if (this.this$0.mPendingMO != null) {
                            this.this$0.dialPendingMO();
                        }
                    } else if (bgState == Call.State.ACTIVE) {
                        this.this$0.mForegroundCall.switchWith(this.this$0.mBackgroundCall);
                        if (this.this$0.mPendingMO != null) {
                            this.this$0.mPendingMO.setDisconnectCause(36);
                            this.this$0.sendEmptyMessageDelayed(18, 500L);
                        }
                    }
                    this.this$0.mPhone.notifySuppServiceFailed(PhoneInternalInterface.SuppService.HOLD);
                }
                this.this$0.mEventLog.writeOnImsCallHoldFailed(imsCall.getCallSession(), reasonInfo);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallResumed(ImsCall imsCall) {
                this.this$0.log("onCallResumed");
                if (this.this$0.mSwitchingFgAndBgCalls) {
                    if (imsCall != this.this$0.mCallExpectedToResume) {
                        this.this$0.log("onCallResumed : switching " + this.this$0.mForegroundCall + " with " + this.this$0.mBackgroundCall);
                        this.this$0.mForegroundCall.switchWith(this.this$0.mBackgroundCall);
                    } else {
                        this.this$0.log("onCallResumed : expected call resumed.");
                    }
                    this.this$0.mSwitchingFgAndBgCalls = false;
                    this.this$0.mCallExpectedToResume = null;
                }
                this.this$0.processCallStateChange(imsCall, Call.State.ACTIVE, 0);
                this.this$0.mEventLog.writeOnImsCallResumed(imsCall.getCallSession());
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallResumeFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
                if (this.this$0.mSwitchingFgAndBgCalls) {
                    if (imsCall == this.this$0.mCallExpectedToResume) {
                        this.this$0.log("onCallResumeFailed : switching " + this.this$0.mForegroundCall + " with " + this.this$0.mBackgroundCall);
                        this.this$0.mForegroundCall.switchWith(this.this$0.mBackgroundCall);
                        if (this.this$0.mForegroundCall.getState() == Call.State.HOLDING) {
                            this.this$0.sendEmptyMessage(19);
                        }
                    }
                    this.this$0.mCallExpectedToResume = null;
                    this.this$0.mSwitchingFgAndBgCalls = false;
                }
                this.this$0.mPhone.notifySuppServiceFailed(PhoneInternalInterface.SuppService.RESUME);
                this.this$0.mEventLog.writeOnImsCallResumeFailed(imsCall.getCallSession(), reasonInfo);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallResumeReceived(ImsCall imsCall) {
                this.this$0.log("onCallResumeReceived");
                ImsPhoneConnection conn = this.this$0.findConnection(imsCall);
                if (conn != null && this.this$0.mOnHoldToneStarted) {
                    this.this$0.mPhone.stopOnHoldTone(conn);
                    this.this$0.mOnHoldToneStarted = false;
                }
                SuppServiceNotification supp = new SuppServiceNotification();
                supp.notificationType = 1;
                supp.code = 3;
                this.this$0.mPhone.notifySuppSvcNotification(supp);
                this.this$0.mEventLog.writeOnImsCallResumeReceived(imsCall.getCallSession());
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallHoldReceived(ImsCall imsCall) {
                this.this$0.log("onCallHoldReceived");
                ImsPhoneConnection conn = this.this$0.findConnection(imsCall);
                if (conn != null && conn.getState() == Call.State.ACTIVE && !this.this$0.mOnHoldToneStarted && ImsPhoneCall.isLocalTone(imsCall)) {
                    this.this$0.mPhone.startOnHoldTone(conn);
                    this.this$0.mOnHoldToneStarted = true;
                    this.this$0.mOnHoldToneId = System.identityHashCode(conn);
                }
                SuppServiceNotification supp = new SuppServiceNotification();
                supp.notificationType = 1;
                supp.code = 2;
                this.this$0.mPhone.notifySuppSvcNotification(supp);
                this.this$0.mEventLog.writeOnImsCallHoldReceived(imsCall.getCallSession());
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallSuppServiceReceived(ImsCall call, ImsSuppServiceNotification suppServiceInfo) {
                this.this$0.log("onCallSuppServiceReceived: suppServiceInfo=" + suppServiceInfo);
                SuppServiceNotification supp = new SuppServiceNotification();
                supp.notificationType = suppServiceInfo.notificationType;
                supp.code = suppServiceInfo.code;
                supp.index = suppServiceInfo.index;
                supp.number = suppServiceInfo.number;
                supp.history = suppServiceInfo.history;
                this.this$0.mPhone.notifySuppSvcNotification(supp);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallMerged(ImsCall call, ImsCall peerCall, boolean swapCalls) {
                Call peerImsPhoneCall;
                this.this$0.log("onCallMerged");
                Call foregroundImsPhoneCall = this.this$0.findConnection(call).getCall();
                ImsPhoneConnection peerConnection = this.this$0.findConnection(peerCall);
                Call call2 = peerImsPhoneCall = peerConnection == null ? null : peerConnection.getCall();
                if (swapCalls) {
                    this.this$0.switchAfterConferenceSuccess();
                }
                ((ImsPhoneCall)foregroundImsPhoneCall).merge((ImsPhoneCall)peerImsPhoneCall, Call.State.ACTIVE);
                try {
                    ImsPhoneConnection conn = this.this$0.findConnection(call);
                    this.this$0.log("onCallMerged: ImsPhoneConnection=" + conn);
                    this.this$0.log("onCallMerged: CurrentVideoProvider=" + conn.getVideoProvider());
                    this.this$0.setVideoCallProvider(conn, call);
                    this.this$0.log("onCallMerged: CurrentVideoProvider=" + conn.getVideoProvider());
                }
                catch (Exception e) {
                    this.this$0.loge("onCallMerged: exception " + e);
                }
                this.this$0.processCallStateChange(this.this$0.mForegroundCall.getImsCall(), Call.State.ACTIVE, 0);
                if (peerConnection != null) {
                    this.this$0.processCallStateChange(this.this$0.mBackgroundCall.getImsCall(), Call.State.HOLDING, 0);
                }
                if (!call.isMergeRequestedByConf()) {
                    this.this$0.log("onCallMerged :: calling onMultipartyStateChanged()");
                    this.onMultipartyStateChanged(call, true);
                } else {
                    this.this$0.log("onCallMerged :: Merge requested by existing conference.");
                    call.resetIsMergeRequestedByConf(false);
                }
                this.this$0.logState();
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallMergeFailed(ImsCall call, ImsReasonInfo reasonInfo) {
                this.this$0.log("onCallMergeFailed reasonInfo=" + reasonInfo);
                this.this$0.mPhone.notifySuppServiceFailed(PhoneInternalInterface.SuppService.CONFERENCE);
                ImsPhoneConnection conn = this.this$0.findConnection(call);
                if (conn != null) {
                    conn.onConferenceMergeFailed();
                }
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onConferenceParticipantsStateChanged(ImsCall call, List<ConferenceParticipant> participants) {
                this.this$0.log("onConferenceParticipantsStateChanged");
                ImsPhoneConnection conn = this.this$0.findConnection(call);
                if (conn != null) {
                    conn.updateConferenceParticipants(participants);
                }
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallSessionTtyModeReceived(ImsCall call, int mode) {
                this.this$0.mPhone.onTtyModeReceived(mode);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallHandover(ImsCall imsCall, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
                this.this$0.log("onCallHandover ::  srcAccessTech=" + srcAccessTech + ", targetAccessTech=" + targetAccessTech + ", reasonInfo=" + reasonInfo);
                this.this$0.mEventLog.writeOnImsCallHandover(imsCall.getCallSession(), srcAccessTech, targetAccessTech, reasonInfo);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallHandoverFailed(ImsCall imsCall, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
                this.this$0.log("onCallHandoverFailed :: srcAccessTech=" + srcAccessTech + ", targetAccessTech=" + targetAccessTech + ", reasonInfo=" + reasonInfo);
                this.this$0.mEventLog.writeOnImsCallHandoverFailed(imsCall.getCallSession(), srcAccessTech, targetAccessTech, reasonInfo);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onMultipartyStateChanged(ImsCall imsCall, boolean isMultiParty) {
                this.this$0.log("onMultipartyStateChanged to " + (isMultiParty ? "Y" : "N"));
                ImsPhoneConnection conn = this.this$0.findConnection(imsCall);
                if (conn != null) {
                    conn.updateMultipartyState(isMultiParty);
                }
            }

            private void __constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$__constructor__(imsPhoneCallTracker);
            }
            {
                this.this$0 = imsPhoneCallTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$__constructor__(com.android.internal.telephony.imsphone.ImsPhoneCallTracker ), 0, this, imsPhoneCallTracker);
            }

            public void onCallProgressing(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallProgressing", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallProgressing(com.android.ims.ImsCall ), 0, this, imsCall);
            }

            public void onCallStarted(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallStarted", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallStarted(com.android.ims.ImsCall ), 0, this, imsCall);
            }

            public void onCallUpdated(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallUpdated", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallUpdated(com.android.ims.ImsCall ), 0, this, imsCall);
            }

            public void onCallStartFailed(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallStartFailed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallStartFailed(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), 0, this, imsCall, imsReasonInfo);
            }

            public void onCallTerminated(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallTerminated", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallTerminated(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), 0, this, imsCall, imsReasonInfo);
            }

            public void onCallHeld(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallHeld", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallHeld(com.android.ims.ImsCall ), 0, this, imsCall);
            }

            public void onCallHoldFailed(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallHoldFailed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallHoldFailed(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), 0, this, imsCall, imsReasonInfo);
            }

            public void onCallResumed(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallResumed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallResumed(com.android.ims.ImsCall ), 0, this, imsCall);
            }

            public void onCallResumeFailed(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallResumeFailed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallResumeFailed(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), 0, this, imsCall, imsReasonInfo);
            }

            public void onCallResumeReceived(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallResumeReceived", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallResumeReceived(com.android.ims.ImsCall ), 0, this, imsCall);
            }

            public void onCallHoldReceived(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallHoldReceived", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallHoldReceived(com.android.ims.ImsCall ), 0, this, imsCall);
            }

            public void onCallSuppServiceReceived(ImsCall imsCall, ImsSuppServiceNotification imsSuppServiceNotification) {
                InvokeDynamicSupport.bootstrap("onCallSuppServiceReceived", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallSuppServiceReceived(com.android.ims.ImsCall com.android.ims.ImsSuppServiceNotification ), 0, this, imsCall, imsSuppServiceNotification);
            }

            public void onCallMerged(ImsCall imsCall, ImsCall imsCall2, boolean bl) {
                InvokeDynamicSupport.bootstrap("onCallMerged", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallMerged(com.android.ims.ImsCall com.android.ims.ImsCall boolean ), 0, this, imsCall, imsCall2, bl);
            }

            public void onCallMergeFailed(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallMergeFailed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallMergeFailed(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), 0, this, imsCall, imsReasonInfo);
            }

            public void onConferenceParticipantsStateChanged(ImsCall imsCall, List<ConferenceParticipant> list) {
                InvokeDynamicSupport.bootstrap("onConferenceParticipantsStateChanged", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onConferenceParticipantsStateChanged(com.android.ims.ImsCall java.util.List<android.telecom.ConferenceParticipant> ), 0, this, imsCall, list);
            }

            public void onCallSessionTtyModeReceived(ImsCall imsCall, int n) {
                InvokeDynamicSupport.bootstrap("onCallSessionTtyModeReceived", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallSessionTtyModeReceived(com.android.ims.ImsCall int ), 0, this, imsCall, n);
            }

            public void onCallHandover(ImsCall imsCall, int n, int n2, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallHandover", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallHandover(com.android.ims.ImsCall int int com.android.ims.ImsReasonInfo ), 0, this, imsCall, n, n2, imsReasonInfo);
            }

            public void onCallHandoverFailed(ImsCall imsCall, int n, int n2, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallHandoverFailed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallHandoverFailed(com.android.ims.ImsCall int int com.android.ims.ImsReasonInfo ), 0, this, imsCall, n, n2, imsReasonInfo);
            }

            public void onMultipartyStateChanged(ImsCall imsCall, boolean bl) {
                InvokeDynamicSupport.bootstrap("onMultipartyStateChanged", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onMultipartyStateChanged(com.android.ims.ImsCall boolean ), 0, this, imsCall, bl);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mImsUssdListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsPhoneCallTracker this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$__constructor__(ImsPhoneCallTracker this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onCallStarted(ImsCall imsCall) {
                this.this$0.log("mImsUssdListener onCallStarted");
                if (imsCall == this.this$0.mUssdSession && this.this$0.mPendingUssd != null) {
                    AsyncResult.forMessage(this.this$0.mPendingUssd);
                    this.this$0.mPendingUssd.sendToTarget();
                    this.this$0.mPendingUssd = null;
                }
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onCallStartFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
                this.this$0.log("mImsUssdListener onCallStartFailed reasonCode=" + reasonInfo.getCode());
                this.onCallTerminated(imsCall, reasonInfo);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onCallTerminated(ImsCall imsCall, ImsReasonInfo reasonInfo) {
                this.this$0.log("mImsUssdListener onCallTerminated reasonCode=" + reasonInfo.getCode());
                if (imsCall == this.this$0.mUssdSession) {
                    this.this$0.mUssdSession = null;
                    if (this.this$0.mPendingUssd != null) {
                        CommandException ex = new CommandException(CommandException.Error.GENERIC_FAILURE);
                        AsyncResult.forMessage(this.this$0.mPendingUssd, null, ex);
                        this.this$0.mPendingUssd.sendToTarget();
                        this.this$0.mPendingUssd = null;
                    }
                }
                imsCall.close();
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onCallUssdMessageReceived(ImsCall call, int mode, String ussdMessage) {
                this.this$0.log("mImsUssdListener onCallUssdMessageReceived mode=" + mode);
                int ussdMode = -1;
                switch (mode) {
                    case 1: {
                        ussdMode = 1;
                        break;
                    }
                    case 0: {
                        ussdMode = 0;
                    }
                }
                this.this$0.mPhone.onIncomingUSSD(ussdMode, ussdMessage);
            }

            private void __constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$__constructor__(imsPhoneCallTracker);
            }
            {
                this.this$0 = imsPhoneCallTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$__constructor__(com.android.internal.telephony.imsphone.ImsPhoneCallTracker ), 0, this, imsPhoneCallTracker);
            }

            public void onCallStarted(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallStarted", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onCallStarted(com.android.ims.ImsCall ), 0, this, imsCall);
            }

            public void onCallStartFailed(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallStartFailed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onCallStartFailed(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), 0, this, imsCall, imsReasonInfo);
            }

            public void onCallTerminated(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallTerminated", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onCallTerminated(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), 0, this, imsCall, imsReasonInfo);
            }

            public void onCallUssdMessageReceived(ImsCall imsCall, int n, String string2) {
                InvokeDynamicSupport.bootstrap("onCallUssdMessageReceived", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onCallUssdMessageReceived(com.android.ims.ImsCall int java.lang.String ), 0, this, imsCall, n, string2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mImsConnectionStateListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsPhoneCallTracker this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$__constructor__(ImsPhoneCallTracker this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onImsConnected() {
                this.this$0.log("onImsConnected");
                this.this$0.mPhone.setServiceState(0);
                this.this$0.mPhone.setImsRegistered(true);
                this.this$0.mEventLog.writeOnImsConnectionState(1, null);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onImsDisconnected(ImsReasonInfo imsReasonInfo) {
                this.this$0.log("onImsDisconnected imsReasonInfo=" + imsReasonInfo);
                this.this$0.mPhone.setServiceState(1);
                this.this$0.mPhone.setImsRegistered(false);
                this.this$0.mPhone.processDisconnectReason(imsReasonInfo);
                this.this$0.mEventLog.writeOnImsConnectionState(3, imsReasonInfo);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onImsProgressing() {
                this.this$0.log("onImsProgressing");
                this.this$0.mPhone.setServiceState(1);
                this.this$0.mPhone.setImsRegistered(false);
                this.this$0.mEventLog.writeOnImsConnectionState(2, null);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onImsResumed() {
                this.this$0.log("onImsResumed");
                this.this$0.mPhone.setServiceState(0);
                this.this$0.mEventLog.writeOnImsConnectionState(4, null);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onImsSuspended() {
                this.this$0.log("onImsSuspended");
                this.this$0.mPhone.setServiceState(1);
                this.this$0.mEventLog.writeOnImsConnectionState(5, null);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onFeatureCapabilityChanged(int serviceClass, int[] enabledFeatures, int[] disabledFeatures) {
                if (serviceClass == 1) {
                    boolean tmpIsVideoCallEnabled = this.this$0.isVideoCallEnabled();
                    StringBuilder sb = new StringBuilder(120);
                    sb.append("onFeatureCapabilityChanged: ");
                    for (int i = 0; i <= 5 && i < enabledFeatures.length; ++i) {
                        if (enabledFeatures[i] == i) {
                            sb.append(this.this$0.mImsFeatureStrings[i]);
                            sb.append(":true ");
                            ((ImsPhoneCallTracker)this.this$0).mImsFeatureEnabled[i] = true;
                            continue;
                        }
                        if (enabledFeatures[i] == -1) {
                            sb.append(this.this$0.mImsFeatureStrings[i]);
                            sb.append(":false ");
                            ((ImsPhoneCallTracker)this.this$0).mImsFeatureEnabled[i] = false;
                            continue;
                        }
                        this.this$0.loge("onFeatureCapabilityChanged(" + i + ", " + this.this$0.mImsFeatureStrings[i] + "): unexpectedValue=" + enabledFeatures[i]);
                    }
                    this.this$0.log(sb.toString());
                    if (tmpIsVideoCallEnabled != this.this$0.isVideoCallEnabled()) {
                        this.this$0.mPhone.notifyForVideoCapabilityChanged(this.this$0.isVideoCallEnabled());
                    }
                    this.this$0.log("onFeatureCapabilityChanged: isVolteEnabled=" + this.this$0.isVolteEnabled() + ", isVideoCallEnabled=" + this.this$0.isVideoCallEnabled() + ", isVowifiEnabled=" + this.this$0.isVowifiEnabled() + ", isUtEnabled=" + this.this$0.isUtEnabled());
                    for (ImsPhoneConnection connection : this.this$0.mConnections) {
                        connection.updateWifiState();
                    }
                    this.this$0.mPhone.onFeatureCapabilityChanged();
                    this.this$0.mEventLog.writeOnImsCapabilities(this.this$0.mImsFeatureEnabled);
                }
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onVoiceMessageCountChanged(int count) {
                this.this$0.log("onVoiceMessageCountChanged :: count=" + count);
                this.this$0.mPhone.mDefaultPhone.setVoiceMessageCount(count);
            }

            private void __constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$__constructor__(imsPhoneCallTracker);
            }
            {
                this.this$0 = imsPhoneCallTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$__constructor__(com.android.internal.telephony.imsphone.ImsPhoneCallTracker ), 0, this, imsPhoneCallTracker);
            }

            public void onImsConnected() {
                InvokeDynamicSupport.bootstrap("onImsConnected", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onImsConnected(), 0, this);
            }

            public void onImsDisconnected(ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onImsDisconnected", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onImsDisconnected(com.android.ims.ImsReasonInfo ), 0, this, imsReasonInfo);
            }

            public void onImsProgressing() {
                InvokeDynamicSupport.bootstrap("onImsProgressing", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onImsProgressing(), 0, this);
            }

            public void onImsResumed() {
                InvokeDynamicSupport.bootstrap("onImsResumed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onImsResumed(), 0, this);
            }

            public void onImsSuspended() {
                InvokeDynamicSupport.bootstrap("onImsSuspended", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onImsSuspended(), 0, this);
            }

            public void onFeatureCapabilityChanged(int n, int[] nArray, int[] nArray2) {
                InvokeDynamicSupport.bootstrap("onFeatureCapabilityChanged", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onFeatureCapabilityChanged(int int[] int[] ), 0, this, n, nArray, nArray2);
            }

            public void onVoiceMessageCountChanged(int n) {
                InvokeDynamicSupport.bootstrap("onVoiceMessageCountChanged", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onVoiceMessageCountChanged(int ), 0, this, n);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mImsConfigListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsPhoneCallTracker this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_6$__constructor__(ImsPhoneCallTracker this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_6$onGetFeatureResponse(int feature, int network, int value, int status) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_6$onSetFeatureResponse(int feature, int network, int value, int status) {
                this.this$0.mEventLog.writeImsSetFeatureValue(feature, network, value, status);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_6$onGetVideoQuality(int status, int quality) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_6$onSetVideoQuality(int status) {
            }

            private void __constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_6$__constructor__(imsPhoneCallTracker);
            }
            {
                this.this$0 = imsPhoneCallTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_6$__constructor__(com.android.internal.telephony.imsphone.ImsPhoneCallTracker ), 0, this, imsPhoneCallTracker);
            }

            @Override
            public void onGetFeatureResponse(int n, int n2, int n3, int n4) {
                InvokeDynamicSupport.bootstrap("onGetFeatureResponse", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_6$onGetFeatureResponse(int int int int ), 0, this, n, n2, n3, n4);
            }

            @Override
            public void onSetFeatureResponse(int n, int n2, int n3, int n4) {
                InvokeDynamicSupport.bootstrap("onSetFeatureResponse", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_6$onSetFeatureResponse(int int int int ), 0, this, n, n2, n3, n4);
            }

            @Override
            public void onGetVideoQuality(int n, int n2) {
                InvokeDynamicSupport.bootstrap("onGetVideoQuality", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_6$onGetVideoQuality(int int ), 0, this, n, n2);
            }

            @Override
            public void onSetVideoQuality(int n) {
                InvokeDynamicSupport.bootstrap("onSetVideoQuality", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_6$onSetVideoQuality(int ), 0, this, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhone = phone;
        this.mEventLog = new TelephonyEventLog(this.mPhone.getPhoneId());
        IntentFilter intentfilter = new IntentFilter();
        intentfilter.addAction("com.android.ims.IMS_INCOMING_CALL");
        intentfilter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
        this.mPhone.getContext().registerReceiver(this.mReceiver, intentfilter);
        this.mAllowEmergencyVideoCalls = this.isEmergencyVtCallAllowed(this.mPhone.getSubId());
        ShadowedObject t = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsPhoneCallTracker this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$__constructor__(ImsPhoneCallTracker this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$run() {
                this.this$0.getImsService();
            }

            private void __constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$__constructor__(imsPhoneCallTracker);
            }
            {
                this.this$0 = imsPhoneCallTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$__constructor__(com.android.internal.telephony.imsphone.ImsPhoneCallTracker ), 0, this, imsPhoneCallTracker);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        t.start();
    }

    private final PendingIntent $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$createIncomingCallPendingIntent() {
        Intent intent = new Intent("com.android.ims.IMS_INCOMING_CALL");
        intent.addFlags(0x10000000);
        return PendingIntent.getBroadcast(this.mPhone.getContext(), 0, intent, 0x8000000);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getImsService() {
        this.log("getImsService");
        this.mImsManager = ImsManager.getInstance((Context)this.mPhone.getContext(), (int)this.mPhone.getPhoneId());
        try {
            this.mServiceId = this.mImsManager.open(1, this.createIncomingCallPendingIntent(), this.mImsConnectionStateListener);
            this.mImsManager.setImsConfigListener((ImsConfigListener)this.mImsConfigListener);
            this.getEcbmInterface().setEcbmStateListener(this.mPhone.getImsEcbmStateListener());
            if (this.mPhone.isInEcm()) {
                this.mPhone.exitEmergencyCallbackMode();
            }
            int mPreferredTtyMode = Settings.Secure.getInt(this.mPhone.getContext().getContentResolver(), "preferred_tty_mode", 0);
            this.mImsManager.setUiTTYMode(this.mPhone.getContext(), this.mServiceId, mPreferredTtyMode, null);
        }
        catch (ImsException e) {
            this.loge("getImsService: " + (Object)((Object)e));
            this.mImsManager = null;
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dispose() {
        this.log("dispose");
        this.mRingingCall.dispose();
        this.mBackgroundCall.dispose();
        this.mForegroundCall.dispose();
        this.mHandoverCall.dispose();
        this.clearDisconnected();
        this.mPhone.getContext().unregisterReceiver(this.mReceiver);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$finalize() {
        this.log("ImsPhoneCallTracker finalized");
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$registerForVoiceCallStarted(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallStartedRegistrants.add(r);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$unregisterForVoiceCallStarted(Handler h) {
        this.mVoiceCallStartedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$registerForVoiceCallEnded(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallEndedRegistrants.add(r);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$unregisterForVoiceCallEnded(Handler h) {
        this.mVoiceCallEndedRegistrants.remove(h);
    }

    private final Connection $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dial(String dialString, int videoState, Bundle intentExtras) throws CallStateException {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mPhone.getContext());
        int oirMode = sp.getInt("clir_key", 0);
        return this.dial(dialString, oirMode, videoState, intentExtras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized Connection $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dial(String dialString, int clirMode, int videoState, Bundle intentExtras) throws CallStateException {
        boolean isPhoneInEcmMode = this.isPhoneInEcbMode();
        boolean isEmergencyNumber = PhoneNumberUtils.isEmergencyNumber(dialString);
        this.log("dial clirMode=" + clirMode);
        this.clearDisconnected();
        if (this.mImsManager == null) {
            throw new CallStateException("service not available");
        }
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        if (isPhoneInEcmMode && isEmergencyNumber) {
            this.handleEcmTimer(1);
        }
        if (isEmergencyNumber && VideoProfile.isVideo(videoState) && !this.mAllowEmergencyVideoCalls) {
            this.loge("dial: carrier does not support video emergency calls; downgrade to audio-only");
            videoState = 0;
        }
        boolean holdBeforeDial = false;
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            if (this.mBackgroundCall.getState() != Call.State.IDLE) {
                throw new CallStateException("cannot dial in current state");
            }
            holdBeforeDial = true;
            this.mPendingCallVideoState = videoState;
            this.mPendingIntentExtras = intentExtras;
            this.switchWaitingOrHoldingAndActive();
        }
        Call.State fgState = Call.State.IDLE;
        Call.State bgState = Call.State.IDLE;
        this.mClirMode = clirMode;
        Object object = this.mSyncHold;
        synchronized (object) {
            if (holdBeforeDial) {
                fgState = this.mForegroundCall.getState();
                bgState = this.mBackgroundCall.getState();
                if (fgState == Call.State.ACTIVE) {
                    throw new CallStateException("cannot dial in current state");
                }
                if (bgState == Call.State.HOLDING) {
                    holdBeforeDial = false;
                }
            }
            this.mPendingMO = new ImsPhoneConnection((Phone)this.mPhone, this.checkForTestEmergencyNumber(dialString), this, this.mForegroundCall, isEmergencyNumber);
            this.mPendingMO.setVideoState(videoState);
        }
        this.addConnection(this.mPendingMO);
        if (!holdBeforeDial) {
            if (!isPhoneInEcmMode || isPhoneInEcmMode && isEmergencyNumber) {
                this.dialInternal(this.mPendingMO, clirMode, videoState, intentExtras);
            } else {
                try {
                    this.getEcbmInterface().exitEmergencyCallbackMode();
                }
                catch (ImsException e) {
                    e.printStackTrace();
                    throw new CallStateException("service not available");
                }
                this.mPhone.setOnEcbModeExitResponse(this, 14, null);
                this.pendingCallClirMode = clirMode;
                this.mPendingCallVideoState = videoState;
                this.pendingCallInEcm = true;
            }
        }
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
        return this.mPendingMO;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isEmergencyVtCallAllowed(int subId) {
        CarrierConfigManager carrierConfigManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
        if (carrierConfigManager == null) {
            this.loge("isEmergencyVideoCallsSupported: No carrier config service found.");
            return false;
        }
        PersistableBundle carrierConfig = carrierConfigManager.getConfigForSubId(subId);
        if (carrierConfig == null) {
            this.loge("isEmergencyVideoCallsSupported: Empty carrier config.");
            return false;
        }
        return carrierConfig.getBoolean("allow_emergency_video_calls_bool");
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handleEcmTimer(int action) {
        this.mPhone.handleTimerInEmergencyCallbackMode(action);
        switch (action) {
            case 1: {
                break;
            }
            case 0: {
                break;
            }
            default: {
                this.log("handleEcmTimer, unsupported action " + action);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dialInternal(ImsPhoneConnection conn, int clirMode, int videoState, Bundle intentExtras) {
        if (conn == null) {
            return;
        }
        if (conn.getAddress() == null || conn.getAddress().length() == 0 || conn.getAddress().indexOf(78) >= 0) {
            conn.setDisconnectCause(7);
            this.sendEmptyMessageDelayed(18, 500L);
            return;
        }
        this.setMute(false);
        int serviceType = PhoneNumberUtils.isEmergencyNumber(conn.getAddress()) ? 2 : 1;
        int callType = ImsCallProfile.getCallTypeFromVideoState(videoState);
        conn.setVideoState(videoState);
        try {
            String[] callees = new String[]{conn.getAddress()};
            ImsCallProfile profile = this.mImsManager.createCallProfile(this.mServiceId, serviceType, callType);
            profile.setCallExtraInt("oir", clirMode);
            if (intentExtras != null) {
                if (intentExtras.containsKey("android.telecom.extra.CALL_SUBJECT")) {
                    intentExtras.putString("DisplayText", this.cleanseInstantLetteringMessage(intentExtras.getString("android.telecom.extra.CALL_SUBJECT")));
                }
                profile.mCallExtras.putBundle("OemCallExtras", intentExtras);
            }
            ImsCall imsCall = this.mImsManager.makeCall(this.mServiceId, profile, callees, this.mImsCallListener);
            conn.setImsCall(imsCall);
            this.mEventLog.writeOnImsCallStart(imsCall.getSession(), callees[0]);
            this.setVideoCallProvider(conn, imsCall);
        }
        catch (ImsException e) {
            this.loge("dialInternal : " + (Object)((Object)e));
            conn.setDisconnectCause(36);
            this.sendEmptyMessageDelayed(18, 500L);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$acceptCall(int videoState) throws CallStateException {
        this.log("acceptCall");
        if (this.mForegroundCall.getState().isAlive() && this.mBackgroundCall.getState().isAlive()) {
            throw new CallStateException("cannot accept call");
        }
        if (this.mRingingCall.getState() == Call.State.WAITING && this.mForegroundCall.getState().isAlive()) {
            this.setMute(false);
            this.mPendingCallVideoState = videoState;
            this.switchWaitingOrHoldingAndActive();
        } else if (this.mRingingCall.getState().isRinging()) {
            this.log("acceptCall: incoming...");
            this.setMute(false);
            try {
                ImsCall imsCall = this.mRingingCall.getImsCall();
                if (imsCall == null) {
                    throw new CallStateException("no valid ims call");
                }
                imsCall.accept(ImsCallProfile.getCallTypeFromVideoState(videoState));
                this.mEventLog.writeOnImsCallAccept(imsCall.getSession());
            }
            catch (ImsException e) {
                throw new CallStateException("cannot accept call");
            }
        } else {
            throw new CallStateException("phone not ringing");
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$rejectCall() throws CallStateException {
        this.log("rejectCall");
        if (!this.mRingingCall.getState().isRinging()) {
            throw new CallStateException("phone not ringing");
        }
        this.hangup(this.mRingingCall);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$switchAfterConferenceSuccess() {
        this.log("switchAfterConferenceSuccess fg =" + (Object)((Object)this.mForegroundCall.getState()) + ", bg = " + (Object)((Object)this.mBackgroundCall.getState()));
        if (this.mBackgroundCall.getState() == Call.State.HOLDING) {
            this.log("switchAfterConferenceSuccess");
            this.mForegroundCall.switchWith(this.mBackgroundCall);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$switchWaitingOrHoldingAndActive() throws CallStateException {
        this.log("switchWaitingOrHoldingAndActive");
        if (this.mRingingCall.getState() == Call.State.INCOMING) {
            throw new CallStateException("cannot be in the incoming state");
        }
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            ImsCall imsCall = this.mForegroundCall.getImsCall();
            if (imsCall == null) {
                throw new CallStateException("no ims call");
            }
            this.mSwitchingFgAndBgCalls = true;
            this.mCallExpectedToResume = this.mBackgroundCall.getImsCall();
            this.mForegroundCall.switchWith(this.mBackgroundCall);
            try {
                imsCall.hold();
                this.mEventLog.writeOnImsCallHold(imsCall.getSession());
                if (this.mCallExpectedToResume != null) return;
                this.mSwitchingFgAndBgCalls = false;
                return;
            }
            catch (ImsException e) {
                this.mForegroundCall.switchWith(this.mBackgroundCall);
                throw new CallStateException(e.getMessage());
            }
        } else {
            if (this.mBackgroundCall.getState() != Call.State.HOLDING) return;
            this.resumeWaitingOrHolding();
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$conference() {
        long conferenceConnectTime;
        this.log("conference");
        ImsCall fgImsCall = this.mForegroundCall.getImsCall();
        if (fgImsCall == null) {
            this.log("conference no foreground ims call");
            return;
        }
        ImsCall bgImsCall = this.mBackgroundCall.getImsCall();
        if (bgImsCall == null) {
            this.log("conference no background ims call");
            return;
        }
        long foregroundConnectTime = this.mForegroundCall.getEarliestConnectTime();
        long backgroundConnectTime = this.mBackgroundCall.getEarliestConnectTime();
        if (foregroundConnectTime > 0L && backgroundConnectTime > 0L) {
            conferenceConnectTime = Math.min(this.mForegroundCall.getEarliestConnectTime(), this.mBackgroundCall.getEarliestConnectTime());
            this.log("conference - using connect time = " + conferenceConnectTime);
        } else if (foregroundConnectTime > 0L) {
            this.log("conference - bg call connect time is 0; using fg = " + foregroundConnectTime);
            conferenceConnectTime = foregroundConnectTime;
        } else {
            this.log("conference - fg call connect time is 0; using bg = " + backgroundConnectTime);
            conferenceConnectTime = backgroundConnectTime;
        }
        ImsPhoneConnection foregroundConnection = this.mForegroundCall.getFirstConnection();
        if (foregroundConnection != null) {
            foregroundConnection.setConferenceConnectTime(conferenceConnectTime);
        }
        try {
            fgImsCall.merge(bgImsCall);
        }
        catch (ImsException e) {
            this.log("conference " + e.getMessage());
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$explicitCallTransfer() {
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$clearDisconnected() {
        this.log("clearDisconnected");
        this.internalClearDisconnected();
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$canConference() {
        return this.mForegroundCall.getState() == Call.State.ACTIVE && this.mBackgroundCall.getState() == Call.State.HOLDING && !this.mBackgroundCall.isFull() && !this.mForegroundCall.isFull();
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$canDial() {
        int serviceState = this.mPhone.getServiceState().getState();
        String disableCall = SystemProperties.get("ro.telephony.disable-call", "false");
        boolean ret = serviceState != 3 && this.mPendingMO == null && !this.mRingingCall.isRinging() && !disableCall.equals("true") && (!this.mForegroundCall.getState().isAlive() || !this.mBackgroundCall.getState().isAlive());
        return ret;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$canTransfer() {
        return this.mForegroundCall.getState() == Call.State.ACTIVE && this.mBackgroundCall.getState() == Call.State.HOLDING;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$internalClearDisconnected() {
        this.mRingingCall.clearDisconnected();
        this.mForegroundCall.clearDisconnected();
        this.mBackgroundCall.clearDisconnected();
        this.mHandoverCall.clearDisconnected();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$updatePhoneState() {
        PhoneConstants.State oldState = this.mState;
        this.mState = this.mRingingCall.isRinging() ? PhoneConstants.State.RINGING : (this.mPendingMO != null || !this.mForegroundCall.isIdle() || !this.mBackgroundCall.isIdle() ? PhoneConstants.State.OFFHOOK : PhoneConstants.State.IDLE);
        if (this.mState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallEndedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else if (oldState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallStartedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        }
        this.log("updatePhoneState oldState=" + (Object)((Object)oldState) + ", newState=" + (Object)((Object)this.mState));
        if (this.mState != oldState) {
            this.mPhone.notifyPhoneStateChanged();
            this.mEventLog.writePhoneState(this.mState);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handleRadioNotAvailable() {
        this.pollCallsWhenSafe();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dumpState() {
        int i;
        this.log("Phone State:" + (Object)((Object)this.mState));
        this.log("Ringing call: " + this.mRingingCall.toString());
        List<Connection> l = this.mRingingCall.getConnections();
        int s = l.size();
        for (i = 0; i < s; ++i) {
            this.log(((Object)l.get(i)).toString());
        }
        this.log("Foreground call: " + this.mForegroundCall.toString());
        l = this.mForegroundCall.getConnections();
        s = l.size();
        for (i = 0; i < s; ++i) {
            this.log(((Object)l.get(i)).toString());
        }
        this.log("Background call: " + this.mBackgroundCall.toString());
        l = this.mBackgroundCall.getConnections();
        s = l.size();
        for (i = 0; i < s; ++i) {
            this.log(((Object)l.get(i)).toString());
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$setUiTTYMode(int uiTtyMode, Message onComplete) {
        try {
            this.mImsManager.setUiTTYMode(this.mPhone.getContext(), this.mServiceId, uiTtyMode, onComplete);
        }
        catch (ImsException e) {
            this.loge("setTTYMode : " + (Object)((Object)e));
            this.mPhone.sendErrorResponse(onComplete, e);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$setMute(boolean mute) {
        this.mDesiredMute = mute;
        this.mForegroundCall.setMute(mute);
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getMute() {
        return this.mDesiredMute;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$sendDtmf(char c, Message result) {
        this.log("sendDtmf");
        ImsCall imscall = this.mForegroundCall.getImsCall();
        if (imscall != null) {
            imscall.sendDtmf(c, result);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$startDtmf(char c) {
        this.log("startDtmf");
        ImsCall imscall = this.mForegroundCall.getImsCall();
        if (imscall != null) {
            imscall.startDtmf(c);
        } else {
            this.loge("startDtmf : no foreground call");
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$stopDtmf() {
        this.log("stopDtmf");
        ImsCall imscall = this.mForegroundCall.getImsCall();
        if (imscall != null) {
            imscall.stopDtmf();
        } else {
            this.loge("stopDtmf : no foreground call");
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$hangup(ImsPhoneConnection conn) throws CallStateException {
        this.log("hangup connection");
        if (conn.getOwner() != this) {
            throw new CallStateException("ImsPhoneConnection " + conn + "does not belong to ImsPhoneCallTracker " + this);
        }
        this.hangup((ImsPhoneCall)conn.getCall());
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$hangup(ImsPhoneCall call) throws CallStateException {
        this.log("hangup call");
        if (call.getConnections().size() == 0) {
            throw new CallStateException("no connections");
        }
        ImsCall imsCall = call.getImsCall();
        boolean rejectCall = false;
        if (call == this.mRingingCall) {
            this.log("(ringing) hangup incoming");
            rejectCall = true;
        } else if (call == this.mForegroundCall) {
            if (call.isDialingOrAlerting()) {
                this.log("(foregnd) hangup dialing or alerting...");
            } else {
                this.log("(foregnd) hangup foreground");
            }
        } else if (call == this.mBackgroundCall) {
            this.log("(backgnd) hangup waiting or background");
        } else {
            throw new CallStateException("ImsPhoneCall " + call + "does not belong to ImsPhoneCallTracker " + this);
        }
        call.onHangupLocal();
        try {
            if (imsCall != null) {
                if (rejectCall) {
                    imsCall.reject(504);
                    this.mEventLog.writeOnImsCallReject(imsCall.getSession());
                } else {
                    imsCall.terminate(501);
                    this.mEventLog.writeOnImsCallTerminate(imsCall.getSession());
                }
            } else if (this.mPendingMO != null && call == this.mForegroundCall) {
                this.mPendingMO.update(null, Call.State.DISCONNECTED);
                this.mPendingMO.onDisconnect();
                this.removeConnection(this.mPendingMO);
                this.mPendingMO = null;
                this.updatePhoneState();
                this.removeMessages(20);
            }
        }
        catch (ImsException e) {
            throw new CallStateException(e.getMessage());
        }
        this.mPhone.notifyPreciseCallStateChanged();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$callEndCleanupHandOverCallIfAny() {
        if (this.mHandoverCall.mConnections.size() > 0) {
            this.log("callEndCleanupHandOverCallIfAny, mHandoverCall.mConnections=" + this.mHandoverCall.mConnections);
            this.mHandoverCall.mConnections.clear();
            this.mState = PhoneConstants.State.IDLE;
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$resumeWaitingOrHolding() throws CallStateException {
        this.log("resumeWaitingOrHolding");
        try {
            if (this.mForegroundCall.getState().isAlive()) {
                ImsCall imsCall = this.mForegroundCall.getImsCall();
                if (imsCall != null) {
                    imsCall.resume();
                    this.mEventLog.writeOnImsCallResume(imsCall.getSession());
                }
            } else if (this.mRingingCall.getState() == Call.State.WAITING) {
                ImsCall imsCall = this.mRingingCall.getImsCall();
                if (imsCall != null) {
                    imsCall.accept(ImsCallProfile.getCallTypeFromVideoState(this.mPendingCallVideoState));
                    this.mEventLog.writeOnImsCallAccept(imsCall.getSession());
                }
            } else {
                ImsCall imsCall = this.mBackgroundCall.getImsCall();
                if (imsCall != null) {
                    imsCall.resume();
                    this.mEventLog.writeOnImsCallResume(imsCall.getSession());
                }
            }
        }
        catch (ImsException e) {
            throw new CallStateException(e.getMessage());
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$sendUSSD(String ussdString, Message response) {
        this.log("sendUSSD");
        try {
            if (this.mUssdSession != null) {
                this.mUssdSession.sendUssd(ussdString);
                AsyncResult.forMessage(response, null, null);
                response.sendToTarget();
                return;
            }
            String[] callees = new String[]{ussdString};
            ImsCallProfile profile = this.mImsManager.createCallProfile(this.mServiceId, 1, 2);
            profile.setCallExtraInt("dialstring", 2);
            this.mUssdSession = this.mImsManager.makeCall(this.mServiceId, profile, callees, this.mImsUssdListener);
        }
        catch (ImsException e) {
            this.loge("sendUSSD : " + (Object)((Object)e));
            this.mPhone.sendErrorResponse(response, e);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$cancelUSSD() {
        if (this.mUssdSession == null) {
            return;
        }
        try {
            this.mUssdSession.terminate(501);
        }
        catch (ImsException imsException) {
            // empty catch block
        }
    }

    private final synchronized ImsPhoneConnection $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$findConnection(ImsCall imsCall) {
        for (ImsPhoneConnection conn : this.mConnections) {
            if (conn.getImsCall() != imsCall) continue;
            return conn;
        }
        return null;
    }

    private final synchronized void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$removeConnection(ImsPhoneConnection conn) {
        this.mConnections.remove(conn);
        if (this.mIsInEmergencyCall) {
            boolean isEmergencyCallInList = false;
            for (ImsPhoneConnection imsPhoneConnection : this.mConnections) {
                if (imsPhoneConnection == null || !imsPhoneConnection.isEmergency()) continue;
                isEmergencyCallInList = true;
                break;
            }
            if (!isEmergencyCallInList) {
                this.mIsInEmergencyCall = false;
                this.mPhone.sendEmergencyCallStateChange(false);
            }
        }
    }

    private final synchronized void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$addConnection(ImsPhoneConnection conn) {
        this.mConnections.add(conn);
        if (conn.isEmergency()) {
            this.mIsInEmergencyCall = true;
            this.mPhone.sendEmergencyCallStateChange(true);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$processCallStateChange(ImsCall imsCall, Call.State state, int cause) {
        this.log("processCallStateChange " + imsCall + " state=" + (Object)((Object)state) + " cause=" + cause);
        this.processCallStateChange(imsCall, state, cause, false);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$processCallStateChange(ImsCall imsCall, Call.State state, int cause, boolean ignoreState) {
        this.log("processCallStateChange state=" + (Object)((Object)state) + " cause=" + cause + " ignoreState=" + ignoreState);
        if (imsCall == null) {
            return;
        }
        boolean changed = false;
        ImsPhoneConnection conn = this.findConnection(imsCall);
        if (conn == null) {
            return;
        }
        conn.updateMediaCapabilities(imsCall);
        if (ignoreState) {
            conn.updateAddressDisplay(imsCall);
            conn.updateExtras(imsCall);
            this.maybeSetVideoCallProvider(conn, imsCall);
            return;
        }
        changed = conn.update(imsCall, state);
        if (state == Call.State.DISCONNECTED) {
            changed = conn.onDisconnect(cause) || changed;
            ((ImsPhoneCall)conn.getCall()).detach(conn);
            this.removeConnection(conn);
        }
        if (changed) {
            if (conn.getCall() == this.mHandoverCall) {
                return;
            }
            this.updatePhoneState();
            this.mPhone.notifyPreciseCallStateChanged();
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$maybeSetVideoCallProvider(ImsPhoneConnection conn, ImsCall imsCall) {
        Connection.VideoProvider connVideoProvider = conn.getVideoProvider();
        if (connVideoProvider != null || imsCall.getCallSession().getVideoCallProvider() == null) {
            return;
        }
        try {
            this.setVideoCallProvider(conn, imsCall);
        }
        catch (RemoteException e) {
            this.loge("maybeSetVideoCallProvider: exception " + e);
        }
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getDisconnectCauseFromReasonInfo(ImsReasonInfo reasonInfo) {
        int cause = 36;
        int code = reasonInfo.getCode();
        switch (code) {
            case 337: 
            case 341: {
                return 8;
            }
            case 338: {
                return 4;
            }
            case 501: {
                return 3;
            }
            case 143: {
                return 16;
            }
            case 510: {
                return 2;
            }
            case 321: 
            case 331: 
            case 332: 
            case 340: 
            case 361: 
            case 362: {
                return 12;
            }
            case 333: 
            case 352: 
            case 354: {
                return 9;
            }
            case 106: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 131: 
            case 132: 
            case 144: {
                return 18;
            }
            case 201: 
            case 202: 
            case 203: 
            case 335: {
                return 13;
            }
            case 111: 
            case 112: {
                return 17;
            }
            case 241: {
                return 21;
            }
        }
        return cause;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isPhoneInEcbMode() {
        return SystemProperties.getBoolean("ril.cdma.inecmmode", false);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dialPendingMO() {
        boolean isPhoneInEcmMode = this.isPhoneInEcbMode();
        boolean isEmergencyNumber = this.mPendingMO.isEmergency();
        if (!isPhoneInEcmMode || isPhoneInEcmMode && isEmergencyNumber) {
            this.sendEmptyMessage(20);
        } else {
            this.sendEmptyMessage(21);
        }
    }

    private final ImsUtInterface $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getUtInterface() throws ImsException {
        if (this.mImsManager == null) {
            throw new ImsException("no ims manager", 0);
        }
        ImsUtInterface ut = this.mImsManager.getSupplementaryServiceConfiguration(this.mServiceId);
        return ut;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$transferHandoverConnections(ImsPhoneCall call) {
        if (call.mConnections != null) {
            for (Connection c : call.mConnections) {
                c.mPreHandoverState = call.mState;
                this.log("Connection state before handover is " + (Object)((Object)c.getStateBeforeHandover()));
            }
        }
        if (this.mHandoverCall.mConnections == null) {
            this.mHandoverCall.mConnections = call.mConnections;
        } else {
            this.mHandoverCall.mConnections.addAll(call.mConnections);
        }
        if (this.mHandoverCall.mConnections != null) {
            if (call.getImsCall() != null) {
                call.getImsCall().close();
            }
            for (Connection c : this.mHandoverCall.mConnections) {
                ((ImsPhoneConnection)c).changeParent(this.mHandoverCall);
                ((ImsPhoneConnection)c).releaseWakeLock();
            }
        }
        if (call.getState().isAlive()) {
            this.log("Call is alive and state is " + (Object)((Object)call.mState));
            this.mHandoverCall.mState = call.mState;
        }
        call.mConnections.clear();
        call.mState = Call.State.IDLE;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$notifySrvccState(Call.SrvccState state) {
        this.log("notifySrvccState state=" + (Object)((Object)state));
        this.mSrvccState = state;
        if (this.mSrvccState == Call.SrvccState.COMPLETED) {
            this.transferHandoverConnections(this.mForegroundCall);
            this.transferHandoverConnections(this.mBackgroundCall);
            this.transferHandoverConnections(this.mRingingCall);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handleMessage(Message msg) {
        this.log("handleMessage what=" + msg.what);
        switch (msg.what) {
            case 18: {
                if (this.mPendingMO != null) {
                    this.mPendingMO.onDisconnect();
                    this.removeConnection(this.mPendingMO);
                    this.mPendingMO = null;
                }
                this.mPendingIntentExtras = null;
                this.updatePhoneState();
                this.mPhone.notifyPreciseCallStateChanged();
                break;
            }
            case 19: {
                try {
                    this.resumeWaitingOrHolding();
                }
                catch (CallStateException e) {
                    this.loge("handleMessage EVENT_RESUME_BACKGROUND exception=" + e);
                }
                break;
            }
            case 20: {
                this.dialInternal(this.mPendingMO, this.mClirMode, this.mPendingCallVideoState, this.mPendingIntentExtras);
                this.mPendingIntentExtras = null;
                break;
            }
            case 21: {
                if (this.mPendingMO == null) break;
                try {
                    this.getEcbmInterface().exitEmergencyCallbackMode();
                    this.mPhone.setOnEcbModeExitResponse(this, 14, null);
                    this.pendingCallClirMode = this.mClirMode;
                    this.pendingCallInEcm = true;
                }
                catch (ImsException e) {
                    e.printStackTrace();
                    this.mPendingMO.setDisconnectCause(36);
                    this.sendEmptyMessageDelayed(18, 500L);
                }
                break;
            }
            case 14: {
                if (this.pendingCallInEcm) {
                    this.dialInternal(this.mPendingMO, this.pendingCallClirMode, this.mPendingCallVideoState, this.mPendingIntentExtras);
                    this.mPendingIntentExtras = null;
                    this.pendingCallInEcm = false;
                }
                this.mPhone.unsetOnEcbModeExitResponse(this);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$log(String msg) {
        Rlog.d("ImsPhoneCallTracker", "[ImsPhoneCallTracker] " + msg);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$loge(String msg) {
        Rlog.e("ImsPhoneCallTracker", "[ImsPhoneCallTracker] " + msg);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$logState() {
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("ImsPhoneCallTracker extends:");
        super.dump(fd, pw, args);
        pw.println(" mVoiceCallEndedRegistrants=" + this.mVoiceCallEndedRegistrants);
        pw.println(" mVoiceCallStartedRegistrants=" + this.mVoiceCallStartedRegistrants);
        pw.println(" mRingingCall=" + this.mRingingCall);
        pw.println(" mForegroundCall=" + this.mForegroundCall);
        pw.println(" mBackgroundCall=" + this.mBackgroundCall);
        pw.println(" mHandoverCall=" + this.mHandoverCall);
        pw.println(" mPendingMO=" + this.mPendingMO);
        pw.println(" mPhone=" + this.mPhone);
        pw.println(" mDesiredMute=" + this.mDesiredMute);
        pw.println(" mState=" + (Object)((Object)this.mState));
        for (int i = 0; i < this.mImsFeatureEnabled.length; ++i) {
            pw.println(" " + this.mImsFeatureStrings[i] + ": " + (this.mImsFeatureEnabled[i] ? "enabled" : "disabled"));
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        try {
            if (this.mImsManager != null) {
                this.mImsManager.dump(fd, pw, args);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mConnections != null && this.mConnections.size() > 0) {
            pw.println("mConnections:");
            for (int i = 0; i < this.mConnections.size(); ++i) {
                pw.println("  [" + i + "]: " + this.mConnections.get(i));
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handlePollCalls(AsyncResult ar) {
    }

    private final ImsEcbm $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getEcbmInterface() throws ImsException {
        if (this.mImsManager == null) {
            throw new ImsException("no ims manager", 0);
        }
        ImsEcbm ecbm = this.mImsManager.getEcbmInterface(this.mServiceId);
        return ecbm;
    }

    private final ImsMultiEndpoint $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getMultiEndpointInterface() throws ImsException {
        if (this.mImsManager == null) {
            throw new ImsException("no ims manager", 0);
        }
        ImsMultiEndpoint multiendpoint = this.mImsManager.getMultiEndpointInterface(this.mServiceId);
        return multiendpoint;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isInEmergencyCall() {
        return this.mIsInEmergencyCall;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isVolteEnabled() {
        return this.mImsFeatureEnabled[0];
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isVowifiEnabled() {
        return this.mImsFeatureEnabled[2];
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isVideoCallEnabled() {
        return this.mImsFeatureEnabled[1] || this.mImsFeatureEnabled[3];
    }

    private final PhoneConstants.State $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getState() {
        return this.mState;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$setVideoCallProvider(ImsPhoneConnection conn, ImsCall imsCall) throws RemoteException {
        IImsVideoCallProvider imsVideoCallProvider = imsCall.getCallSession().getVideoCallProvider();
        if (imsVideoCallProvider != null) {
            ImsVideoCallProviderWrapper imsVideoCallProviderWrapper = new ImsVideoCallProviderWrapper(imsVideoCallProvider);
            conn.setVideoProvider((Connection.VideoProvider)imsVideoCallProviderWrapper);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isUtEnabled() {
        return this.mImsFeatureEnabled[4] || this.mImsFeatureEnabled[5];
    }

    private final String $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$cleanseInstantLetteringMessage(String callSubject) {
        String escapedCharacters;
        if (TextUtils.isEmpty(callSubject)) {
            return callSubject;
        }
        CarrierConfigManager configMgr = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
        if (configMgr == null) {
            return callSubject;
        }
        PersistableBundle carrierConfig = configMgr.getConfigForSubId(this.mPhone.getSubId());
        if (carrierConfig == null) {
            return callSubject;
        }
        String invalidCharacters = carrierConfig.getString("carrier_instant_lettering_invalid_chars_string");
        if (!TextUtils.isEmpty(invalidCharacters)) {
            callSubject = callSubject.replaceAll(invalidCharacters, "");
        }
        if (!TextUtils.isEmpty(escapedCharacters = carrierConfig.getString("carrier_instant_lettering_escaped_chars_string"))) {
            callSubject = this.escapeChars(escapedCharacters, callSubject);
        }
        return callSubject;
    }

    private final String $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$escapeChars(String toEscape, String source) {
        StringBuilder escaped = new StringBuilder();
        for (char c : source.toCharArray()) {
            if (toEscape.contains(Character.toString(c))) {
                escaped.append("\\");
            }
            escaped.append(c);
        }
        return escaped.toString();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$pullExternalCall(String number, int videoState) {
        Bundle extras = new Bundle();
        extras.putBoolean("CallPull", true);
        try {
            Connection connection = this.dial(number, videoState, extras);
            this.mPhone.notifyUnknownConnection(connection);
        }
        catch (CallStateException e) {
            this.loge("pullExternalCall failed - " + e);
        }
    }

    private void __constructor__(ImsPhone imsPhone) {
        this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$__constructor__(imsPhone);
    }

    public ImsPhoneCallTracker(ImsPhone imsPhone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$__constructor__(com.android.internal.telephony.imsphone.ImsPhone ), 0, this, imsPhone);
    }

    private PendingIntent createIncomingCallPendingIntent() {
        return InvokeDynamicSupport.bootstrap("createIncomingCallPendingIntent", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$createIncomingCallPendingIntent(), 0, this);
    }

    private void getImsService() {
        InvokeDynamicSupport.bootstrap("getImsService", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getImsService(), 0, this);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dispose(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$finalize(), 0, this);
    }

    @Override
    public void registerForVoiceCallStarted(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForVoiceCallStarted", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$registerForVoiceCallStarted(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForVoiceCallStarted(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForVoiceCallStarted", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$unregisterForVoiceCallStarted(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForVoiceCallEnded(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForVoiceCallEnded", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$registerForVoiceCallEnded(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForVoiceCallEnded(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForVoiceCallEnded", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$unregisterForVoiceCallEnded(android.os.Handler ), 0, this, handler);
    }

    public Connection dial(String string2, int n, Bundle bundle) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dial(java.lang.String int android.os.Bundle ), 0, this, string2, n, bundle);
    }

    synchronized Connection dial(String string2, int n, int n2, Bundle bundle) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dial(java.lang.String int int android.os.Bundle ), 0, this, string2, n, n2, bundle);
    }

    private boolean isEmergencyVtCallAllowed(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmergencyVtCallAllowed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isEmergencyVtCallAllowed(int ), 0, this, n);
    }

    private void handleEcmTimer(int n) {
        InvokeDynamicSupport.bootstrap("handleEcmTimer", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handleEcmTimer(int ), 0, this, n);
    }

    private void dialInternal(ImsPhoneConnection imsPhoneConnection, int n, int n2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dialInternal", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dialInternal(com.android.internal.telephony.imsphone.ImsPhoneConnection int int android.os.Bundle ), 0, this, imsPhoneConnection, n, n2, bundle);
    }

    public void acceptCall(int n) throws CallStateException {
        InvokeDynamicSupport.bootstrap("acceptCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$acceptCall(int ), 0, this, n);
    }

    public void rejectCall() throws CallStateException {
        InvokeDynamicSupport.bootstrap("rejectCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$rejectCall(), 0, this);
    }

    private void switchAfterConferenceSuccess() {
        InvokeDynamicSupport.bootstrap("switchAfterConferenceSuccess", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$switchAfterConferenceSuccess(), 0, this);
    }

    public void switchWaitingOrHoldingAndActive() throws CallStateException {
        InvokeDynamicSupport.bootstrap("switchWaitingOrHoldingAndActive", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$switchWaitingOrHoldingAndActive(), 0, this);
    }

    public void conference() {
        InvokeDynamicSupport.bootstrap("conference", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$conference(), 0, this);
    }

    public void explicitCallTransfer() {
        InvokeDynamicSupport.bootstrap("explicitCallTransfer", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$explicitCallTransfer(), 0, this);
    }

    public void clearDisconnected() {
        InvokeDynamicSupport.bootstrap("clearDisconnected", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$clearDisconnected(), 0, this);
    }

    public boolean canConference() {
        return (boolean)InvokeDynamicSupport.bootstrap("canConference", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$canConference(), 0, this);
    }

    public boolean canDial() {
        return (boolean)InvokeDynamicSupport.bootstrap("canDial", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$canDial(), 0, this);
    }

    public boolean canTransfer() {
        return (boolean)InvokeDynamicSupport.bootstrap("canTransfer", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$canTransfer(), 0, this);
    }

    private void internalClearDisconnected() {
        InvokeDynamicSupport.bootstrap("internalClearDisconnected", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$internalClearDisconnected(), 0, this);
    }

    private void updatePhoneState() {
        InvokeDynamicSupport.bootstrap("updatePhoneState", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$updatePhoneState(), 0, this);
    }

    private void handleRadioNotAvailable() {
        InvokeDynamicSupport.bootstrap("handleRadioNotAvailable", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handleRadioNotAvailable(), 0, this);
    }

    private void dumpState() {
        InvokeDynamicSupport.bootstrap("dumpState", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dumpState(), 0, this);
    }

    public void setUiTTYMode(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setUiTTYMode", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$setUiTTYMode(int android.os.Message ), 0, this, n, message);
    }

    public void setMute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMute", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$setMute(boolean ), 0, this, bl);
    }

    public boolean getMute() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMute", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getMute(), 0, this);
    }

    public void sendDtmf(char c, Message message) {
        InvokeDynamicSupport.bootstrap("sendDtmf", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$sendDtmf(char android.os.Message ), 0, this, c, message);
    }

    public void startDtmf(char c) {
        InvokeDynamicSupport.bootstrap("startDtmf", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$startDtmf(char ), 0, this, c);
    }

    public void stopDtmf() {
        InvokeDynamicSupport.bootstrap("stopDtmf", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$stopDtmf(), 0, this);
    }

    public void hangup(ImsPhoneConnection imsPhoneConnection) throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$hangup(com.android.internal.telephony.imsphone.ImsPhoneConnection ), 0, this, imsPhoneConnection);
    }

    public void hangup(ImsPhoneCall imsPhoneCall) throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$hangup(com.android.internal.telephony.imsphone.ImsPhoneCall ), 0, this, imsPhoneCall);
    }

    void callEndCleanupHandOverCallIfAny() {
        InvokeDynamicSupport.bootstrap("callEndCleanupHandOverCallIfAny", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$callEndCleanupHandOverCallIfAny(), 0, this);
    }

    void resumeWaitingOrHolding() throws CallStateException {
        InvokeDynamicSupport.bootstrap("resumeWaitingOrHolding", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$resumeWaitingOrHolding(), 0, this);
    }

    public void sendUSSD(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendUSSD", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$sendUSSD(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    public void cancelUSSD() {
        InvokeDynamicSupport.bootstrap("cancelUSSD", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$cancelUSSD(), 0, this);
    }

    private synchronized ImsPhoneConnection findConnection(ImsCall imsCall) {
        return InvokeDynamicSupport.bootstrap("findConnection", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$findConnection(com.android.ims.ImsCall ), 0, this, imsCall);
    }

    private synchronized void removeConnection(ImsPhoneConnection imsPhoneConnection) {
        InvokeDynamicSupport.bootstrap("removeConnection", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$removeConnection(com.android.internal.telephony.imsphone.ImsPhoneConnection ), 0, this, imsPhoneConnection);
    }

    private synchronized void addConnection(ImsPhoneConnection imsPhoneConnection) {
        InvokeDynamicSupport.bootstrap("addConnection", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$addConnection(com.android.internal.telephony.imsphone.ImsPhoneConnection ), 0, this, imsPhoneConnection);
    }

    private void processCallStateChange(ImsCall imsCall, Call.State state, int n) {
        InvokeDynamicSupport.bootstrap("processCallStateChange", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$processCallStateChange(com.android.ims.ImsCall com.android.internal.telephony.Call$State int ), 0, this, imsCall, state, n);
    }

    private void processCallStateChange(ImsCall imsCall, Call.State state, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("processCallStateChange", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$processCallStateChange(com.android.ims.ImsCall com.android.internal.telephony.Call$State int boolean ), 0, this, imsCall, state, n, bl);
    }

    private void maybeSetVideoCallProvider(ImsPhoneConnection imsPhoneConnection, ImsCall imsCall) {
        InvokeDynamicSupport.bootstrap("maybeSetVideoCallProvider", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$maybeSetVideoCallProvider(com.android.internal.telephony.imsphone.ImsPhoneConnection com.android.ims.ImsCall ), 0, this, imsPhoneConnection, imsCall);
    }

    private int getDisconnectCauseFromReasonInfo(ImsReasonInfo imsReasonInfo) {
        return (int)InvokeDynamicSupport.bootstrap("getDisconnectCauseFromReasonInfo", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getDisconnectCauseFromReasonInfo(com.android.ims.ImsReasonInfo ), 0, this, imsReasonInfo);
    }

    private boolean isPhoneInEcbMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPhoneInEcbMode", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isPhoneInEcbMode(), 0, this);
    }

    private void dialPendingMO() {
        InvokeDynamicSupport.bootstrap("dialPendingMO", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dialPendingMO(), 0, this);
    }

    public ImsUtInterface getUtInterface() throws ImsException {
        return InvokeDynamicSupport.bootstrap("getUtInterface", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getUtInterface(), 0, this);
    }

    private void transferHandoverConnections(ImsPhoneCall imsPhoneCall) {
        InvokeDynamicSupport.bootstrap("transferHandoverConnections", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$transferHandoverConnections(com.android.internal.telephony.imsphone.ImsPhoneCall ), 0, this, imsPhoneCall);
    }

    void notifySrvccState(Call.SrvccState srvccState) {
        InvokeDynamicSupport.bootstrap("notifySrvccState", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$notifySrvccState(com.android.internal.telephony.Call$SrvccState ), 0, this, srvccState);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handleMessage(android.os.Message ), 0, this, message);
    }

    @Override
    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$log(java.lang.String ), 0, this, string2);
    }

    protected void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$loge(java.lang.String ), 0, this, string2);
    }

    void logState() {
        InvokeDynamicSupport.bootstrap("logState", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$logState(), 0, this);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    @Override
    protected void handlePollCalls(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("handlePollCalls", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handlePollCalls(android.os.AsyncResult ), 0, this, asyncResult);
    }

    ImsEcbm getEcbmInterface() throws ImsException {
        return InvokeDynamicSupport.bootstrap("getEcbmInterface", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getEcbmInterface(), 0, this);
    }

    ImsMultiEndpoint getMultiEndpointInterface() throws ImsException {
        return InvokeDynamicSupport.bootstrap("getMultiEndpointInterface", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getMultiEndpointInterface(), 0, this);
    }

    public boolean isInEmergencyCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInEmergencyCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isInEmergencyCall(), 0, this);
    }

    public boolean isVolteEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVolteEnabled", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isVolteEnabled(), 0, this);
    }

    public boolean isVowifiEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVowifiEnabled", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isVowifiEnabled(), 0, this);
    }

    public boolean isVideoCallEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVideoCallEnabled", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isVideoCallEnabled(), 0, this);
    }

    @Override
    public PhoneConstants.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getState(), 0, this);
    }

    private void setVideoCallProvider(ImsPhoneConnection imsPhoneConnection, ImsCall imsCall) throws RemoteException {
        InvokeDynamicSupport.bootstrap("setVideoCallProvider", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$setVideoCallProvider(com.android.internal.telephony.imsphone.ImsPhoneConnection com.android.ims.ImsCall ), 0, this, imsPhoneConnection, imsCall);
    }

    public boolean isUtEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUtEnabled", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isUtEnabled(), 0, this);
    }

    private String cleanseInstantLetteringMessage(String string2) {
        return InvokeDynamicSupport.bootstrap("cleanseInstantLetteringMessage", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$cleanseInstantLetteringMessage(java.lang.String ), 0, this, string2);
    }

    private String escapeChars(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("escapeChars", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$escapeChars(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public void pullExternalCall(String string2, int n) {
        InvokeDynamicSupport.bootstrap("pullExternalCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$pullExternalCall(java.lang.String int ), 0, this, string2, n);
    }

    public /* synthetic */ ImsPhoneCallTracker() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsPhoneCallTracker)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

