/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.graphics.drawable.VectorDrawable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.TextAppearanceSpan;
import android.util.Log;
import android.util.Pair;
import com.android.internal.util.ImageUtils;
import java.util.Arrays;
import java.util.WeakHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NotificationColorUtil
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "NotificationColorUtil";
    private static boolean DEBUG = false;
    private static Object sLock;
    private static NotificationColorUtil sInstance;
    private ImageUtils mImageUtils;
    private WeakHashMap<Bitmap, Pair<Boolean, Integer>> mGrayscaleBitmapCache;
    private int mGrayscaleIconMaxSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final NotificationColorUtil $$robo$$com_android_internal_util_NotificationColorUtil$getInstance(Context context) {
        Object object = sLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new NotificationColorUtil(context);
            }
            return sInstance;
        }
    }

    private void $$robo$$com_android_internal_util_NotificationColorUtil$__constructor__(Context context) {
        this.mImageUtils = new ImageUtils();
        this.mGrayscaleBitmapCache = new WeakHashMap();
        this.mGrayscaleIconMaxSize = context.getResources().getDimensionPixelSize(0x1050005);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_util_NotificationColorUtil$isGrayscaleIcon(Bitmap bitmap) {
        int generationId;
        boolean result;
        if (bitmap.getWidth() > this.mGrayscaleIconMaxSize || bitmap.getHeight() > this.mGrayscaleIconMaxSize) {
            return false;
        }
        Object object = sLock;
        synchronized (object) {
            Pair<Boolean, Integer> cached = this.mGrayscaleBitmapCache.get(bitmap);
            if (cached != null && ((Integer)cached.second).intValue() == bitmap.getGenerationId()) {
                return (Boolean)cached.first;
            }
        }
        Object object2 = this.mImageUtils;
        synchronized (object2) {
            result = this.mImageUtils.isGrayscale(bitmap);
            generationId = bitmap.getGenerationId();
        }
        object2 = sLock;
        synchronized (object2) {
            this.mGrayscaleBitmapCache.put(bitmap, Pair.create(result, generationId));
        }
        return result;
    }

    private final boolean $$robo$$com_android_internal_util_NotificationColorUtil$isGrayscaleIcon(Drawable d) {
        if (d == null) {
            return false;
        }
        if (d instanceof BitmapDrawable) {
            BitmapDrawable bd = (BitmapDrawable)d;
            return bd.getBitmap() != null && this.isGrayscaleIcon(bd.getBitmap());
        }
        if (d instanceof AnimationDrawable) {
            AnimationDrawable ad = (AnimationDrawable)d;
            int count = ad.getNumberOfFrames();
            return count > 0 && this.isGrayscaleIcon(ad.getFrame(0));
        }
        return d instanceof VectorDrawable;
    }

    private final boolean $$robo$$com_android_internal_util_NotificationColorUtil$isGrayscaleIcon(Context context, Icon icon) {
        if (icon == null) {
            return false;
        }
        switch (icon.getType()) {
            case 1: {
                return this.isGrayscaleIcon(icon.getBitmap());
            }
            case 2: {
                return this.isGrayscaleIcon(context, icon.getResId());
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_util_NotificationColorUtil$isGrayscaleIcon(Context context, int drawableResId) {
        if (drawableResId != 0) {
            try {
                return this.isGrayscaleIcon(context.getDrawable(drawableResId));
            }
            catch (Resources.NotFoundException ex) {
                Log.e("NotificationColorUtil", "Drawable not found: " + drawableResId);
                return false;
            }
        }
        return false;
    }

    private final CharSequence $$robo$$com_android_internal_util_NotificationColorUtil$invertCharSequenceColors(CharSequence charSequence) {
        if (charSequence instanceof Spanned) {
            Spanned ss = (Spanned)charSequence;
            Object[] spans = ss.getSpans(0, ss.length(), Object.class);
            SpannableStringBuilder builder = new SpannableStringBuilder(ss.toString());
            Object[] objectArray = spans;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object span;
                Object resultSpan = span = objectArray[i];
                if (span instanceof TextAppearanceSpan) {
                    resultSpan = this.processTextAppearanceSpan((TextAppearanceSpan)span);
                }
                builder.setSpan(resultSpan, ss.getSpanStart(span), ss.getSpanEnd(span), ss.getSpanFlags(span));
            }
            return builder;
        }
        return charSequence;
    }

    private final TextAppearanceSpan $$robo$$com_android_internal_util_NotificationColorUtil$processTextAppearanceSpan(TextAppearanceSpan span) {
        ColorStateList colorStateList = span.getTextColor();
        if (colorStateList != null) {
            int[] colors = colorStateList.getColors();
            boolean changed = false;
            for (int i = 0; i < colors.length; ++i) {
                if (!ImageUtils.isGrayscale(colors[i])) continue;
                if (!changed) {
                    colors = Arrays.copyOf(colors, colors.length);
                }
                colors[i] = this.processColor(colors[i]);
                changed = true;
            }
            if (changed) {
                return new TextAppearanceSpan(span.getFamily(), span.getTextStyle(), span.getTextSize(), new ColorStateList(colorStateList.getStates(), colors), span.getLinkTextColor());
            }
        }
        return span;
    }

    private final int $$robo$$com_android_internal_util_NotificationColorUtil$processColor(int color2) {
        return Color.argb(Color.alpha(color2), 255 - Color.red(color2), 255 - Color.green(color2), 255 - Color.blue(color2));
    }

    private static final int $$robo$$com_android_internal_util_NotificationColorUtil$findContrastColor(int color2, int other, boolean findFg, double minRatio) {
        int bg;
        int fg = findFg ? color2 : other;
        int n = bg = findFg ? other : color2;
        if (ColorUtilsFromCompat.calculateContrast(fg, bg) >= minRatio) {
            return color2;
        }
        double[] lab = new double[3];
        ColorUtilsFromCompat.colorToLAB(findFg ? fg : bg, lab);
        double low = 0.0;
        double high = lab[0];
        double a = lab[1];
        double b = lab[2];
        for (int i = 0; i < 15 && high - low > 1.0E-5; ++i) {
            double l = (low + high) / 2.0;
            if (findFg) {
                fg = ColorUtilsFromCompat.LABToColor(l, a, b);
            } else {
                bg = ColorUtilsFromCompat.LABToColor(l, a, b);
            }
            if (ColorUtilsFromCompat.calculateContrast(fg, bg) > minRatio) {
                low = l;
                continue;
            }
            high = l;
        }
        return ColorUtilsFromCompat.LABToColor(low, a, b);
    }

    private static final int $$robo$$com_android_internal_util_NotificationColorUtil$ensureLargeTextContrast(int color2, int bg) {
        return NotificationColorUtil.findContrastColor(color2, bg, true, 3.0);
    }

    private static final int $$robo$$com_android_internal_util_NotificationColorUtil$ensureTextContrast(int color2, int bg) {
        return NotificationColorUtil.findContrastColor(color2, bg, true, 4.5);
    }

    private static final int $$robo$$com_android_internal_util_NotificationColorUtil$ensureTextBackgroundColor(int color2, int textColor, int hintColor) {
        color2 = NotificationColorUtil.findContrastColor(color2, hintColor, false, 3.0);
        return NotificationColorUtil.findContrastColor(color2, textColor, false, 4.5);
    }

    private static final String $$robo$$com_android_internal_util_NotificationColorUtil$contrastChange(int colorOld, int colorNew, int bg) {
        return String.format("from %.2f:1 to %.2f:1", ColorUtilsFromCompat.calculateContrast(colorOld, bg), ColorUtilsFromCompat.calculateContrast(colorNew, bg));
    }

    private static final int $$robo$$com_android_internal_util_NotificationColorUtil$resolveColor(Context context, int color2) {
        if (color2 == 0) {
            return context.getColor(17170513);
        }
        return color2;
    }

    private static final int $$robo$$com_android_internal_util_NotificationColorUtil$resolveContrastColor(Context context, int notificationColor) {
        int resolvedColor = NotificationColorUtil.resolveColor(context, notificationColor);
        int actionBg = context.getColor(17170515);
        int notiBg = context.getColor(17170511);
        int color2 = resolvedColor;
        color2 = NotificationColorUtil.ensureLargeTextContrast(color2, actionBg);
        if ((color2 = NotificationColorUtil.ensureTextContrast(color2, notiBg)) != resolvedColor) {
            // empty if block
        }
        return color2;
    }

    static void __staticInitializer__() {
        sLock = new Object();
    }

    public static NotificationColorUtil getInstance(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$com_android_internal_util_NotificationColorUtil$getInstance(android.content.Context ), 0, (Context)context);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_util_NotificationColorUtil$__constructor__(context);
    }

    private NotificationColorUtil(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_NotificationColorUtil$__constructor__(android.content.Context ), 0, this, context);
    }

    public boolean isGrayscaleIcon(Bitmap bitmap) {
        return (boolean)InvokeDynamicSupport.bootstrap("isGrayscaleIcon", $$robo$$com_android_internal_util_NotificationColorUtil$isGrayscaleIcon(android.graphics.Bitmap ), 0, this, bitmap);
    }

    public boolean isGrayscaleIcon(Drawable drawable2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isGrayscaleIcon", $$robo$$com_android_internal_util_NotificationColorUtil$isGrayscaleIcon(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public boolean isGrayscaleIcon(Context context, Icon icon) {
        return (boolean)InvokeDynamicSupport.bootstrap("isGrayscaleIcon", $$robo$$com_android_internal_util_NotificationColorUtil$isGrayscaleIcon(android.content.Context android.graphics.drawable.Icon ), 0, this, context, icon);
    }

    public boolean isGrayscaleIcon(Context context, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isGrayscaleIcon", $$robo$$com_android_internal_util_NotificationColorUtil$isGrayscaleIcon(android.content.Context int ), 0, this, context, n);
    }

    public CharSequence invertCharSequenceColors(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("invertCharSequenceColors", $$robo$$com_android_internal_util_NotificationColorUtil$invertCharSequenceColors(java.lang.CharSequence ), 0, this, charSequence);
    }

    private TextAppearanceSpan processTextAppearanceSpan(TextAppearanceSpan textAppearanceSpan) {
        return InvokeDynamicSupport.bootstrap("processTextAppearanceSpan", $$robo$$com_android_internal_util_NotificationColorUtil$processTextAppearanceSpan(android.text.style.TextAppearanceSpan ), 0, this, textAppearanceSpan);
    }

    private int processColor(int n) {
        return (int)InvokeDynamicSupport.bootstrap("processColor", $$robo$$com_android_internal_util_NotificationColorUtil$processColor(int ), 0, this, n);
    }

    private static int findContrastColor(int n, int n2, boolean bl, double d) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findContrastColor", $$robo$$com_android_internal_util_NotificationColorUtil$findContrastColor(int int boolean double ), 0, (int)n, (int)n2, (boolean)bl, (double)d);
    }

    private static int ensureLargeTextContrast(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("ensureLargeTextContrast", $$robo$$com_android_internal_util_NotificationColorUtil$ensureLargeTextContrast(int int ), 0, (int)n, (int)n2);
    }

    private static int ensureTextContrast(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("ensureTextContrast", $$robo$$com_android_internal_util_NotificationColorUtil$ensureTextContrast(int int ), 0, (int)n, (int)n2);
    }

    public static int ensureTextBackgroundColor(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("ensureTextBackgroundColor", $$robo$$com_android_internal_util_NotificationColorUtil$ensureTextBackgroundColor(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    private static String contrastChange(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrapStatic("contrastChange", $$robo$$com_android_internal_util_NotificationColorUtil$contrastChange(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    public static int resolveColor(Context context, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("resolveColor", $$robo$$com_android_internal_util_NotificationColorUtil$resolveColor(android.content.Context int ), 0, (Context)context, (int)n);
    }

    public static int resolveContrastColor(Context context, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("resolveContrastColor", $$robo$$com_android_internal_util_NotificationColorUtil$resolveContrastColor(android.content.Context int ), 0, (Context)context, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(NotificationColorUtil.class);
    }

    public /* synthetic */ NotificationColorUtil() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotificationColorUtil)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ColorUtilsFromCompat
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static double XYZ_WHITE_REFERENCE_X = 95.047;
        private static double XYZ_WHITE_REFERENCE_Y = 100.0;
        private static double XYZ_WHITE_REFERENCE_Z = 108.883;
        private static double XYZ_EPSILON = 0.008856;
        private static double XYZ_KAPPA = 903.3;
        private static int MIN_ALPHA_SEARCH_MAX_ITERATIONS = 10;
        private static int MIN_ALPHA_SEARCH_PRECISION = 1;
        private static ThreadLocal<double[]> TEMP_ARRAY;

        private void $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$__constructor__() {
        }

        private static final int $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$compositeColors(int foreground, int background) {
            int bgAlpha = Color.alpha(background);
            int fgAlpha = Color.alpha(foreground);
            int a = ColorUtilsFromCompat.compositeAlpha(fgAlpha, bgAlpha);
            int r = ColorUtilsFromCompat.compositeComponent(Color.red(foreground), fgAlpha, Color.red(background), bgAlpha, a);
            int g = ColorUtilsFromCompat.compositeComponent(Color.green(foreground), fgAlpha, Color.green(background), bgAlpha, a);
            int b = ColorUtilsFromCompat.compositeComponent(Color.blue(foreground), fgAlpha, Color.blue(background), bgAlpha, a);
            return Color.argb(a, r, g, b);
        }

        private static final int $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$compositeAlpha(int foregroundAlpha, int backgroundAlpha) {
            return 255 - (255 - backgroundAlpha) * (255 - foregroundAlpha) / 255;
        }

        private static final int $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$compositeComponent(int fgC, int fgA, int bgC, int bgA, int a) {
            if (a == 0) {
                return 0;
            }
            return (255 * fgC * fgA + bgC * bgA * (255 - fgA)) / (a * 255);
        }

        private static final double $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$calculateLuminance(int color2) {
            double[] result = ColorUtilsFromCompat.getTempDouble3Array();
            ColorUtilsFromCompat.colorToXYZ(color2, result);
            return result[1] / 100.0;
        }

        private static final double $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$calculateContrast(int foreground, int background) {
            if (Color.alpha(background) != 255) {
                throw new IllegalArgumentException("background can not be translucent: #" + Integer.toHexString(background));
            }
            if (Color.alpha(foreground) < 255) {
                foreground = ColorUtilsFromCompat.compositeColors(foreground, background);
            }
            double luminance1 = ColorUtilsFromCompat.calculateLuminance(foreground) + 0.05;
            double luminance2 = ColorUtilsFromCompat.calculateLuminance(background) + 0.05;
            return Math.max(luminance1, luminance2) / Math.min(luminance1, luminance2);
        }

        private static final void $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$colorToLAB(int color2, double[] outLab) {
            ColorUtilsFromCompat.RGBToLAB(Color.red(color2), Color.green(color2), Color.blue(color2), outLab);
        }

        private static final void $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$RGBToLAB(int r, int g, int b, double[] outLab) {
            ColorUtilsFromCompat.RGBToXYZ(r, g, b, outLab);
            ColorUtilsFromCompat.XYZToLAB(outLab[0], outLab[1], outLab[2], outLab);
        }

        private static final void $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$colorToXYZ(int color2, double[] outXyz) {
            ColorUtilsFromCompat.RGBToXYZ(Color.red(color2), Color.green(color2), Color.blue(color2), outXyz);
        }

        private static final void $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$RGBToXYZ(int r, int g, int b, double[] outXyz) {
            if (outXyz.length != 3) {
                throw new IllegalArgumentException("outXyz must have a length of 3.");
            }
            double sr = (double)r / 255.0;
            sr = sr < 0.04045 ? sr / 12.92 : Math.pow((sr + 0.055) / 1.055, 2.4);
            double sg = (double)g / 255.0;
            sg = sg < 0.04045 ? sg / 12.92 : Math.pow((sg + 0.055) / 1.055, 2.4);
            double sb = (double)b / 255.0;
            sb = sb < 0.04045 ? sb / 12.92 : Math.pow((sb + 0.055) / 1.055, 2.4);
            outXyz[0] = 100.0 * (sr * 0.4124 + sg * 0.3576 + sb * 0.1805);
            outXyz[1] = 100.0 * (sr * 0.2126 + sg * 0.7152 + sb * 0.0722);
            outXyz[2] = 100.0 * (sr * 0.0193 + sg * 0.1192 + sb * 0.9505);
        }

        private static final void $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$XYZToLAB(double x, double y, double z, double[] outLab) {
            if (outLab.length != 3) {
                throw new IllegalArgumentException("outLab must have a length of 3.");
            }
            x = ColorUtilsFromCompat.pivotXyzComponent(x / 95.047);
            y = ColorUtilsFromCompat.pivotXyzComponent(y / 100.0);
            z = ColorUtilsFromCompat.pivotXyzComponent(z / 108.883);
            outLab[0] = Math.max(0.0, 116.0 * y - 16.0);
            outLab[1] = 500.0 * (x - y);
            outLab[2] = 200.0 * (y - z);
        }

        private static final void $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$LABToXYZ(double l, double a, double b, double[] outXyz) {
            double fy = (l + 16.0) / 116.0;
            double fx = a / 500.0 + fy;
            double fz = fy - b / 200.0;
            double tmp = Math.pow(fx, 3.0);
            double xr = tmp > 0.008856 ? tmp : (116.0 * fx - 16.0) / 903.3;
            double yr = l > 7.9996247999999985 ? Math.pow(fy, 3.0) : l / 903.3;
            tmp = Math.pow(fz, 3.0);
            double zr = tmp > 0.008856 ? tmp : (116.0 * fz - 16.0) / 903.3;
            outXyz[0] = xr * 95.047;
            outXyz[1] = yr * 100.0;
            outXyz[2] = zr * 108.883;
        }

        private static final int $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$XYZToColor(double x, double y, double z) {
            double r = (x * 3.2406 + y * -1.5372 + z * -0.4986) / 100.0;
            double g = (x * -0.9689 + y * 1.8758 + z * 0.0415) / 100.0;
            double b = (x * 0.0557 + y * -0.204 + z * 1.057) / 100.0;
            r = r > 0.0031308 ? 1.055 * Math.pow(r, 0.4166666666666667) - 0.055 : 12.92 * r;
            g = g > 0.0031308 ? 1.055 * Math.pow(g, 0.4166666666666667) - 0.055 : 12.92 * g;
            b = b > 0.0031308 ? 1.055 * Math.pow(b, 0.4166666666666667) - 0.055 : 12.92 * b;
            return Color.rgb(ColorUtilsFromCompat.constrain((int)Math.round(r * 255.0), 0, 255), ColorUtilsFromCompat.constrain((int)Math.round(g * 255.0), 0, 255), ColorUtilsFromCompat.constrain((int)Math.round(b * 255.0), 0, 255));
        }

        private static final int $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$LABToColor(double l, double a, double b) {
            double[] result = ColorUtilsFromCompat.getTempDouble3Array();
            ColorUtilsFromCompat.LABToXYZ(l, a, b, result);
            return ColorUtilsFromCompat.XYZToColor(result[0], result[1], result[2]);
        }

        private static final int $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$constrain(int amount, int low, int high) {
            return amount < low ? low : (amount > high ? high : amount);
        }

        private static final double $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$pivotXyzComponent(double component) {
            return component > 0.008856 ? Math.pow(component, 0.3333333333333333) : (903.3 * component + 16.0) / 116.0;
        }

        private static final double[] $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$getTempDouble3Array() {
            double[] result = TEMP_ARRAY.get();
            if (result == null) {
                result = new double[3];
                TEMP_ARRAY.set(result);
            }
            return result;
        }

        static void __staticInitializer__() {
            TEMP_ARRAY = new ThreadLocal();
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$__constructor__();
        }

        private ColorUtilsFromCompat() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$__constructor__(), 0, this);
        }

        public static int compositeColors(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("compositeColors", $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$compositeColors(int int ), 0, (int)n, (int)n2);
        }

        private static int compositeAlpha(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("compositeAlpha", $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$compositeAlpha(int int ), 0, (int)n, (int)n2);
        }

        private static int compositeComponent(int n, int n2, int n3, int n4, int n5) {
            return (int)InvokeDynamicSupport.bootstrapStatic("compositeComponent", $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$compositeComponent(int int int int int ), 0, (int)n, (int)n2, (int)n3, (int)n4, (int)n5);
        }

        public static double calculateLuminance(int n) {
            return (double)InvokeDynamicSupport.bootstrapStatic("calculateLuminance", $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$calculateLuminance(int ), 0, (int)n);
        }

        public static double calculateContrast(int n, int n2) {
            return (double)InvokeDynamicSupport.bootstrapStatic("calculateContrast", $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$calculateContrast(int int ), 0, (int)n, (int)n2);
        }

        public static void colorToLAB(int n, double[] dArray) {
            InvokeDynamicSupport.bootstrapStatic("colorToLAB", $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$colorToLAB(int double[] ), 0, (int)n, (double[])dArray);
        }

        public static void RGBToLAB(int n, int n2, int n3, double[] dArray) {
            InvokeDynamicSupport.bootstrapStatic("RGBToLAB", $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$RGBToLAB(int int int double[] ), 0, (int)n, (int)n2, (int)n3, (double[])dArray);
        }

        public static void colorToXYZ(int n, double[] dArray) {
            InvokeDynamicSupport.bootstrapStatic("colorToXYZ", $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$colorToXYZ(int double[] ), 0, (int)n, (double[])dArray);
        }

        public static void RGBToXYZ(int n, int n2, int n3, double[] dArray) {
            InvokeDynamicSupport.bootstrapStatic("RGBToXYZ", $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$RGBToXYZ(int int int double[] ), 0, (int)n, (int)n2, (int)n3, (double[])dArray);
        }

        public static void XYZToLAB(double d, double d2, double d3, double[] dArray) {
            InvokeDynamicSupport.bootstrapStatic("XYZToLAB", $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$XYZToLAB(double double double double[] ), 0, (double)d, (double)d2, (double)d3, (double[])dArray);
        }

        public static void LABToXYZ(double d, double d2, double d3, double[] dArray) {
            InvokeDynamicSupport.bootstrapStatic("LABToXYZ", $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$LABToXYZ(double double double double[] ), 0, (double)d, (double)d2, (double)d3, (double[])dArray);
        }

        public static int XYZToColor(double d, double d2, double d3) {
            return (int)InvokeDynamicSupport.bootstrapStatic("XYZToColor", $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$XYZToColor(double double double ), 0, (double)d, (double)d2, (double)d3);
        }

        public static int LABToColor(double d, double d2, double d3) {
            return (int)InvokeDynamicSupport.bootstrapStatic("LABToColor", $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$LABToColor(double double double ), 0, (double)d, (double)d2, (double)d3);
        }

        private static int constrain(int n, int n2, int n3) {
            return (int)InvokeDynamicSupport.bootstrapStatic("constrain", $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$constrain(int int int ), 0, (int)n, (int)n2, (int)n3);
        }

        private static double pivotXyzComponent(double d) {
            return (double)InvokeDynamicSupport.bootstrapStatic("pivotXyzComponent", $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$pivotXyzComponent(double ), 0, (double)d);
        }

        private static double[] getTempDouble3Array() {
            return InvokeDynamicSupport.bootstrapStatic("getTempDouble3Array", $$robo$$com_android_internal_util_NotificationColorUtil_ColorUtilsFromCompat$getTempDouble3Array(), 0);
        }

        static {
            RobolectricInternals.classInitializing(ColorUtilsFromCompat.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ColorUtilsFromCompat)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

