/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.util.IState;
import com.android.internal.util.State;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class StateMachine
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String mName;
    private static int SM_QUIT_CMD = -1;
    private static int SM_INIT_CMD = -2;
    public static boolean HANDLED = true;
    public static boolean NOT_HANDLED = false;
    private SmHandler mSmHandler;
    private HandlerThread mSmThread;

    private final void $$robo$$com_android_internal_util_StateMachine$initStateMachine(String name, Looper looper) {
        this.mName = name;
        this.mSmHandler = new SmHandler(looper, this);
    }

    private void $$robo$$com_android_internal_util_StateMachine$__constructor__(String name) {
        this.mSmThread = new HandlerThread(name);
        this.mSmThread.start();
        Looper looper = this.mSmThread.getLooper();
        this.initStateMachine(name, looper);
    }

    private void $$robo$$com_android_internal_util_StateMachine$__constructor__(String name, Looper looper) {
        this.initStateMachine(name, looper);
    }

    private void $$robo$$com_android_internal_util_StateMachine$__constructor__(String name, Handler handler) {
        this.initStateMachine(name, handler.getLooper());
    }

    private final void $$robo$$com_android_internal_util_StateMachine$onPreHandleMessage(Message msg) {
    }

    private final void $$robo$$com_android_internal_util_StateMachine$onPostHandleMessage(Message msg) {
    }

    private final void $$robo$$com_android_internal_util_StateMachine$addState(State state, State parent) {
        this.mSmHandler.addState(state, parent);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$addState(State state) {
        this.mSmHandler.addState(state, null);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$setInitialState(State initialState) {
        this.mSmHandler.setInitialState(initialState);
    }

    private final Message $$robo$$com_android_internal_util_StateMachine$getCurrentMessage() {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return null;
        }
        return smh.getCurrentMessage();
    }

    private final IState $$robo$$com_android_internal_util_StateMachine$getCurrentState() {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return null;
        }
        return smh.getCurrentState();
    }

    private final void $$robo$$com_android_internal_util_StateMachine$transitionTo(IState destState) {
        this.mSmHandler.transitionTo(destState);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$transitionToHaltingState() {
        this.mSmHandler.transitionTo(this.mSmHandler.mHaltingState);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$deferMessage(Message msg) {
        this.mSmHandler.deferMessage(msg);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$unhandledMessage(Message msg) {
        if (this.mSmHandler.mDbg) {
            this.loge(" - unhandledMessage: msg.what=" + msg.what);
        }
    }

    private final void $$robo$$com_android_internal_util_StateMachine$haltedProcessMessage(Message msg) {
    }

    private final void $$robo$$com_android_internal_util_StateMachine$onHalting() {
    }

    private final void $$robo$$com_android_internal_util_StateMachine$onQuitting() {
    }

    private final String $$robo$$com_android_internal_util_StateMachine$getName() {
        return this.mName;
    }

    private final void $$robo$$com_android_internal_util_StateMachine$setLogRecSize(int maxSize) {
        this.mSmHandler.mLogRecords.setSize(maxSize);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$setLogOnlyTransitions(boolean enable) {
        this.mSmHandler.mLogRecords.setLogOnlyTransitions(enable);
    }

    private final int $$robo$$com_android_internal_util_StateMachine$getLogRecSize() {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return 0;
        }
        return smh.mLogRecords.size();
    }

    private final int $$robo$$com_android_internal_util_StateMachine$getLogRecCount() {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return 0;
        }
        return smh.mLogRecords.count();
    }

    private final LogRec $$robo$$com_android_internal_util_StateMachine$getLogRec(int index) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return null;
        }
        return smh.mLogRecords.get(index);
    }

    private final Collection<LogRec> $$robo$$com_android_internal_util_StateMachine$copyLogRecs() {
        Vector<LogRec> vlr = new Vector<LogRec>();
        SmHandler smh = this.mSmHandler;
        if (smh != null) {
            for (LogRec lr : smh.mLogRecords.mLogRecVector) {
                vlr.add(lr);
            }
        }
        return vlr;
    }

    private final void $$robo$$com_android_internal_util_StateMachine$addLogRec(String string2) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.mLogRecords.add(this, smh.getCurrentMessage(), string2, smh.getCurrentState(), ((SmHandler)smh).mStateStack[((SmHandler)smh).mStateStackTopIndex].state, smh.mDestState);
    }

    private final boolean $$robo$$com_android_internal_util_StateMachine$recordLogRec(Message msg) {
        return true;
    }

    private final String $$robo$$com_android_internal_util_StateMachine$getLogRecString(Message msg) {
        return "";
    }

    private final String $$robo$$com_android_internal_util_StateMachine$getWhatToString(int what) {
        return null;
    }

    private final Handler $$robo$$com_android_internal_util_StateMachine$getHandler() {
        return this.mSmHandler;
    }

    private final Message $$robo$$com_android_internal_util_StateMachine$obtainMessage() {
        return Message.obtain(this.mSmHandler);
    }

    private final Message $$robo$$com_android_internal_util_StateMachine$obtainMessage(int what) {
        return Message.obtain((Handler)this.mSmHandler, what);
    }

    private final Message $$robo$$com_android_internal_util_StateMachine$obtainMessage(int what, Object obj) {
        return Message.obtain(this.mSmHandler, what, obj);
    }

    private final Message $$robo$$com_android_internal_util_StateMachine$obtainMessage(int what, int arg1) {
        return Message.obtain(this.mSmHandler, what, arg1, 0);
    }

    private final Message $$robo$$com_android_internal_util_StateMachine$obtainMessage(int what, int arg1, int arg2) {
        return Message.obtain(this.mSmHandler, what, arg1, arg2);
    }

    private final Message $$robo$$com_android_internal_util_StateMachine$obtainMessage(int what, int arg1, int arg2, Object obj) {
        return Message.obtain(this.mSmHandler, what, arg1, arg2, obj);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$sendMessage(int what) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessage(this.obtainMessage(what));
    }

    private final void $$robo$$com_android_internal_util_StateMachine$sendMessage(int what, Object obj) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessage(this.obtainMessage(what, obj));
    }

    private final void $$robo$$com_android_internal_util_StateMachine$sendMessage(int what, int arg1) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessage(this.obtainMessage(what, arg1));
    }

    private final void $$robo$$com_android_internal_util_StateMachine$sendMessage(int what, int arg1, int arg2) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessage(this.obtainMessage(what, arg1, arg2));
    }

    private final void $$robo$$com_android_internal_util_StateMachine$sendMessage(int what, int arg1, int arg2, Object obj) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessage(this.obtainMessage(what, arg1, arg2, obj));
    }

    private final void $$robo$$com_android_internal_util_StateMachine$sendMessage(Message msg) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessage(msg);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$sendMessageDelayed(int what, long delayMillis) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageDelayed(this.obtainMessage(what), delayMillis);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$sendMessageDelayed(int what, Object obj, long delayMillis) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageDelayed(this.obtainMessage(what, obj), delayMillis);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$sendMessageDelayed(int what, int arg1, long delayMillis) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageDelayed(this.obtainMessage(what, arg1), delayMillis);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$sendMessageDelayed(int what, int arg1, int arg2, long delayMillis) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageDelayed(this.obtainMessage(what, arg1, arg2), delayMillis);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$sendMessageDelayed(int what, int arg1, int arg2, Object obj, long delayMillis) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageDelayed(this.obtainMessage(what, arg1, arg2, obj), delayMillis);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$sendMessageDelayed(Message msg, long delayMillis) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageDelayed(msg, delayMillis);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$sendMessageAtFrontOfQueue(int what) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageAtFrontOfQueue(this.obtainMessage(what));
    }

    private final void $$robo$$com_android_internal_util_StateMachine$sendMessageAtFrontOfQueue(int what, Object obj) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageAtFrontOfQueue(this.obtainMessage(what, obj));
    }

    private final void $$robo$$com_android_internal_util_StateMachine$sendMessageAtFrontOfQueue(int what, int arg1) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageAtFrontOfQueue(this.obtainMessage(what, arg1));
    }

    private final void $$robo$$com_android_internal_util_StateMachine$sendMessageAtFrontOfQueue(int what, int arg1, int arg2) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageAtFrontOfQueue(this.obtainMessage(what, arg1, arg2));
    }

    private final void $$robo$$com_android_internal_util_StateMachine$sendMessageAtFrontOfQueue(int what, int arg1, int arg2, Object obj) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageAtFrontOfQueue(this.obtainMessage(what, arg1, arg2, obj));
    }

    private final void $$robo$$com_android_internal_util_StateMachine$sendMessageAtFrontOfQueue(Message msg) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.sendMessageAtFrontOfQueue(msg);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$removeMessages(int what) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.removeMessages(what);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$removeDeferredMessages(int what) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        Iterator iterator = smh.mDeferredMessages.iterator();
        while (iterator.hasNext()) {
            Message msg = (Message)iterator.next();
            if (msg.what != what) continue;
            iterator.remove();
        }
    }

    private final boolean $$robo$$com_android_internal_util_StateMachine$hasDeferredMessages(int what) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return false;
        }
        for (Message msg : smh.mDeferredMessages) {
            if (msg.what != what) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_util_StateMachine$hasMessages(int what) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return false;
        }
        return smh.hasMessages(what);
    }

    private final boolean $$robo$$com_android_internal_util_StateMachine$isQuit(Message msg) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return msg.what == -1;
        }
        return smh.isQuit(msg);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$quit() {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.quit();
    }

    private final void $$robo$$com_android_internal_util_StateMachine$quitNow() {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.quitNow();
    }

    private final boolean $$robo$$com_android_internal_util_StateMachine$isDbg() {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return false;
        }
        return smh.isDbg();
    }

    private final void $$robo$$com_android_internal_util_StateMachine$setDbg(boolean dbg) {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.setDbg(dbg);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$start() {
        SmHandler smh = this.mSmHandler;
        if (smh == null) {
            return;
        }
        smh.completeConstruction();
    }

    private final void $$robo$$com_android_internal_util_StateMachine$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println(this.getName() + ":");
        pw.println(" total records=" + this.getLogRecCount());
        for (int i = 0; i < this.getLogRecSize(); ++i) {
            pw.println(" rec[" + i + "]: " + this.getLogRec(i).toString());
            pw.flush();
        }
        pw.println("curState=" + this.getCurrentState().getName());
    }

    private final String $$robo$$com_android_internal_util_StateMachine$toString() {
        StringWriter sr = new StringWriter();
        PrintWriter pr = new PrintWriter(sr);
        this.dump(null, pr, null);
        pr.flush();
        pr.close();
        return sr.toString();
    }

    private final void $$robo$$com_android_internal_util_StateMachine$logAndAddLogRec(String s) {
        this.addLogRec(s);
        this.log(s);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$log(String s) {
        Log.d(this.mName, s);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$logd(String s) {
        Log.d(this.mName, s);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$logv(String s) {
        Log.v(this.mName, s);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$logi(String s) {
        Log.i(this.mName, s);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$logw(String s) {
        Log.w(this.mName, s);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$loge(String s) {
        Log.e(this.mName, s);
    }

    private final void $$robo$$com_android_internal_util_StateMachine$loge(String s, Throwable e) {
        Log.e(this.mName, s, e);
    }

    private void initStateMachine(String string2, Looper looper) {
        InvokeDynamicSupport.bootstrap("initStateMachine", $$robo$$com_android_internal_util_StateMachine$initStateMachine(java.lang.String android.os.Looper ), 0, this, string2, looper);
    }

    private void __constructor__(String string2) {
        this.$$robo$$com_android_internal_util_StateMachine$__constructor__(string2);
    }

    protected StateMachine(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_StateMachine$__constructor__(java.lang.String ), 0, this, string2);
    }

    private void __constructor__(String string2, Looper looper) {
        this.$$robo$$com_android_internal_util_StateMachine$__constructor__(string2, looper);
    }

    protected StateMachine(String string2, Looper looper) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_StateMachine$__constructor__(java.lang.String android.os.Looper ), 0, this, string2, looper);
    }

    private void __constructor__(String string2, Handler handler) {
        this.$$robo$$com_android_internal_util_StateMachine$__constructor__(string2, handler);
    }

    protected StateMachine(String string2, Handler handler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_StateMachine$__constructor__(java.lang.String android.os.Handler ), 0, this, string2, handler);
    }

    protected void onPreHandleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("onPreHandleMessage", $$robo$$com_android_internal_util_StateMachine$onPreHandleMessage(android.os.Message ), 0, this, message);
    }

    protected void onPostHandleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("onPostHandleMessage", $$robo$$com_android_internal_util_StateMachine$onPostHandleMessage(android.os.Message ), 0, this, message);
    }

    protected void addState(State state, State state2) {
        InvokeDynamicSupport.bootstrap("addState", $$robo$$com_android_internal_util_StateMachine$addState(com.android.internal.util.State com.android.internal.util.State ), 0, this, state, state2);
    }

    protected void addState(State state) {
        InvokeDynamicSupport.bootstrap("addState", $$robo$$com_android_internal_util_StateMachine$addState(com.android.internal.util.State ), 0, this, state);
    }

    protected void setInitialState(State state) {
        InvokeDynamicSupport.bootstrap("setInitialState", $$robo$$com_android_internal_util_StateMachine$setInitialState(com.android.internal.util.State ), 0, this, state);
    }

    protected Message getCurrentMessage() {
        return InvokeDynamicSupport.bootstrap("getCurrentMessage", $$robo$$com_android_internal_util_StateMachine$getCurrentMessage(), 0, this);
    }

    protected IState getCurrentState() {
        return InvokeDynamicSupport.bootstrap("getCurrentState", $$robo$$com_android_internal_util_StateMachine$getCurrentState(), 0, this);
    }

    protected void transitionTo(IState iState) {
        InvokeDynamicSupport.bootstrap("transitionTo", $$robo$$com_android_internal_util_StateMachine$transitionTo(com.android.internal.util.IState ), 0, this, iState);
    }

    protected void transitionToHaltingState() {
        InvokeDynamicSupport.bootstrap("transitionToHaltingState", $$robo$$com_android_internal_util_StateMachine$transitionToHaltingState(), 0, this);
    }

    protected void deferMessage(Message message) {
        InvokeDynamicSupport.bootstrap("deferMessage", $$robo$$com_android_internal_util_StateMachine$deferMessage(android.os.Message ), 0, this, message);
    }

    protected void unhandledMessage(Message message) {
        InvokeDynamicSupport.bootstrap("unhandledMessage", $$robo$$com_android_internal_util_StateMachine$unhandledMessage(android.os.Message ), 0, this, message);
    }

    protected void haltedProcessMessage(Message message) {
        InvokeDynamicSupport.bootstrap("haltedProcessMessage", $$robo$$com_android_internal_util_StateMachine$haltedProcessMessage(android.os.Message ), 0, this, message);
    }

    protected void onHalting() {
        InvokeDynamicSupport.bootstrap("onHalting", $$robo$$com_android_internal_util_StateMachine$onHalting(), 0, this);
    }

    protected void onQuitting() {
        InvokeDynamicSupport.bootstrap("onQuitting", $$robo$$com_android_internal_util_StateMachine$onQuitting(), 0, this);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$com_android_internal_util_StateMachine$getName(), 0, this);
    }

    public void setLogRecSize(int n) {
        InvokeDynamicSupport.bootstrap("setLogRecSize", $$robo$$com_android_internal_util_StateMachine$setLogRecSize(int ), 0, this, n);
    }

    public void setLogOnlyTransitions(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLogOnlyTransitions", $$robo$$com_android_internal_util_StateMachine$setLogOnlyTransitions(boolean ), 0, this, bl);
    }

    public int getLogRecSize() {
        return (int)InvokeDynamicSupport.bootstrap("getLogRecSize", $$robo$$com_android_internal_util_StateMachine$getLogRecSize(), 0, this);
    }

    public int getLogRecCount() {
        return (int)InvokeDynamicSupport.bootstrap("getLogRecCount", $$robo$$com_android_internal_util_StateMachine$getLogRecCount(), 0, this);
    }

    public LogRec getLogRec(int n) {
        return InvokeDynamicSupport.bootstrap("getLogRec", $$robo$$com_android_internal_util_StateMachine$getLogRec(int ), 0, this, n);
    }

    public Collection<LogRec> copyLogRecs() {
        return InvokeDynamicSupport.bootstrap("copyLogRecs", $$robo$$com_android_internal_util_StateMachine$copyLogRecs(), 0, this);
    }

    protected void addLogRec(String string2) {
        InvokeDynamicSupport.bootstrap("addLogRec", $$robo$$com_android_internal_util_StateMachine$addLogRec(java.lang.String ), 0, this, string2);
    }

    protected boolean recordLogRec(Message message) {
        return (boolean)InvokeDynamicSupport.bootstrap("recordLogRec", $$robo$$com_android_internal_util_StateMachine$recordLogRec(android.os.Message ), 0, this, message);
    }

    protected String getLogRecString(Message message) {
        return InvokeDynamicSupport.bootstrap("getLogRecString", $$robo$$com_android_internal_util_StateMachine$getLogRecString(android.os.Message ), 0, this, message);
    }

    protected String getWhatToString(int n) {
        return InvokeDynamicSupport.bootstrap("getWhatToString", $$robo$$com_android_internal_util_StateMachine$getWhatToString(int ), 0, this, n);
    }

    public Handler getHandler() {
        return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$com_android_internal_util_StateMachine$getHandler(), 0, this);
    }

    public Message obtainMessage() {
        return InvokeDynamicSupport.bootstrap("obtainMessage", $$robo$$com_android_internal_util_StateMachine$obtainMessage(), 0, this);
    }

    public Message obtainMessage(int n) {
        return InvokeDynamicSupport.bootstrap("obtainMessage", $$robo$$com_android_internal_util_StateMachine$obtainMessage(int ), 0, this, n);
    }

    public Message obtainMessage(int n, Object object) {
        return InvokeDynamicSupport.bootstrap("obtainMessage", $$robo$$com_android_internal_util_StateMachine$obtainMessage(int java.lang.Object ), 0, this, n, object);
    }

    public Message obtainMessage(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("obtainMessage", $$robo$$com_android_internal_util_StateMachine$obtainMessage(int int ), 0, this, n, n2);
    }

    public Message obtainMessage(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrap("obtainMessage", $$robo$$com_android_internal_util_StateMachine$obtainMessage(int int int ), 0, this, n, n2, n3);
    }

    public Message obtainMessage(int n, int n2, int n3, Object object) {
        return InvokeDynamicSupport.bootstrap("obtainMessage", $$robo$$com_android_internal_util_StateMachine$obtainMessage(int int int java.lang.Object ), 0, this, n, n2, n3, object);
    }

    public void sendMessage(int n) {
        InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$com_android_internal_util_StateMachine$sendMessage(int ), 0, this, n);
    }

    public void sendMessage(int n, Object object) {
        InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$com_android_internal_util_StateMachine$sendMessage(int java.lang.Object ), 0, this, n, object);
    }

    public void sendMessage(int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$com_android_internal_util_StateMachine$sendMessage(int int ), 0, this, n, n2);
    }

    public void sendMessage(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$com_android_internal_util_StateMachine$sendMessage(int int int ), 0, this, n, n2, n3);
    }

    public void sendMessage(int n, int n2, int n3, Object object) {
        InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$com_android_internal_util_StateMachine$sendMessage(int int int java.lang.Object ), 0, this, n, n2, n3, object);
    }

    public void sendMessage(Message message) {
        InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$com_android_internal_util_StateMachine$sendMessage(android.os.Message ), 0, this, message);
    }

    public void sendMessageDelayed(int n, long l) {
        InvokeDynamicSupport.bootstrap("sendMessageDelayed", $$robo$$com_android_internal_util_StateMachine$sendMessageDelayed(int long ), 0, this, n, l);
    }

    public void sendMessageDelayed(int n, Object object, long l) {
        InvokeDynamicSupport.bootstrap("sendMessageDelayed", $$robo$$com_android_internal_util_StateMachine$sendMessageDelayed(int java.lang.Object long ), 0, this, n, object, l);
    }

    public void sendMessageDelayed(int n, int n2, long l) {
        InvokeDynamicSupport.bootstrap("sendMessageDelayed", $$robo$$com_android_internal_util_StateMachine$sendMessageDelayed(int int long ), 0, this, n, n2, l);
    }

    public void sendMessageDelayed(int n, int n2, int n3, long l) {
        InvokeDynamicSupport.bootstrap("sendMessageDelayed", $$robo$$com_android_internal_util_StateMachine$sendMessageDelayed(int int int long ), 0, this, n, n2, n3, l);
    }

    public void sendMessageDelayed(int n, int n2, int n3, Object object, long l) {
        InvokeDynamicSupport.bootstrap("sendMessageDelayed", $$robo$$com_android_internal_util_StateMachine$sendMessageDelayed(int int int java.lang.Object long ), 0, this, n, n2, n3, object, l);
    }

    public void sendMessageDelayed(Message message, long l) {
        InvokeDynamicSupport.bootstrap("sendMessageDelayed", $$robo$$com_android_internal_util_StateMachine$sendMessageDelayed(android.os.Message long ), 0, this, message, l);
    }

    protected void sendMessageAtFrontOfQueue(int n) {
        InvokeDynamicSupport.bootstrap("sendMessageAtFrontOfQueue", $$robo$$com_android_internal_util_StateMachine$sendMessageAtFrontOfQueue(int ), 0, this, n);
    }

    protected void sendMessageAtFrontOfQueue(int n, Object object) {
        InvokeDynamicSupport.bootstrap("sendMessageAtFrontOfQueue", $$robo$$com_android_internal_util_StateMachine$sendMessageAtFrontOfQueue(int java.lang.Object ), 0, this, n, object);
    }

    protected void sendMessageAtFrontOfQueue(int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendMessageAtFrontOfQueue", $$robo$$com_android_internal_util_StateMachine$sendMessageAtFrontOfQueue(int int ), 0, this, n, n2);
    }

    protected void sendMessageAtFrontOfQueue(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("sendMessageAtFrontOfQueue", $$robo$$com_android_internal_util_StateMachine$sendMessageAtFrontOfQueue(int int int ), 0, this, n, n2, n3);
    }

    protected void sendMessageAtFrontOfQueue(int n, int n2, int n3, Object object) {
        InvokeDynamicSupport.bootstrap("sendMessageAtFrontOfQueue", $$robo$$com_android_internal_util_StateMachine$sendMessageAtFrontOfQueue(int int int java.lang.Object ), 0, this, n, n2, n3, object);
    }

    protected void sendMessageAtFrontOfQueue(Message message) {
        InvokeDynamicSupport.bootstrap("sendMessageAtFrontOfQueue", $$robo$$com_android_internal_util_StateMachine$sendMessageAtFrontOfQueue(android.os.Message ), 0, this, message);
    }

    protected void removeMessages(int n) {
        InvokeDynamicSupport.bootstrap("removeMessages", $$robo$$com_android_internal_util_StateMachine$removeMessages(int ), 0, this, n);
    }

    protected void removeDeferredMessages(int n) {
        InvokeDynamicSupport.bootstrap("removeDeferredMessages", $$robo$$com_android_internal_util_StateMachine$removeDeferredMessages(int ), 0, this, n);
    }

    protected boolean hasDeferredMessages(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasDeferredMessages", $$robo$$com_android_internal_util_StateMachine$hasDeferredMessages(int ), 0, this, n);
    }

    protected boolean hasMessages(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMessages", $$robo$$com_android_internal_util_StateMachine$hasMessages(int ), 0, this, n);
    }

    protected boolean isQuit(Message message) {
        return (boolean)InvokeDynamicSupport.bootstrap("isQuit", $$robo$$com_android_internal_util_StateMachine$isQuit(android.os.Message ), 0, this, message);
    }

    protected void quit() {
        InvokeDynamicSupport.bootstrap("quit", $$robo$$com_android_internal_util_StateMachine$quit(), 0, this);
    }

    protected void quitNow() {
        InvokeDynamicSupport.bootstrap("quitNow", $$robo$$com_android_internal_util_StateMachine$quitNow(), 0, this);
    }

    public boolean isDbg() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDbg", $$robo$$com_android_internal_util_StateMachine$isDbg(), 0, this);
    }

    public void setDbg(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDbg", $$robo$$com_android_internal_util_StateMachine$setDbg(boolean ), 0, this, bl);
    }

    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$com_android_internal_util_StateMachine$start(), 0, this);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_util_StateMachine$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_util_StateMachine$toString(), 0, this);
    }

    protected void logAndAddLogRec(String string2) {
        InvokeDynamicSupport.bootstrap("logAndAddLogRec", $$robo$$com_android_internal_util_StateMachine$logAndAddLogRec(java.lang.String ), 0, this, string2);
    }

    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_util_StateMachine$log(java.lang.String ), 0, this, string2);
    }

    protected void logd(String string2) {
        InvokeDynamicSupport.bootstrap("logd", $$robo$$com_android_internal_util_StateMachine$logd(java.lang.String ), 0, this, string2);
    }

    protected void logv(String string2) {
        InvokeDynamicSupport.bootstrap("logv", $$robo$$com_android_internal_util_StateMachine$logv(java.lang.String ), 0, this, string2);
    }

    protected void logi(String string2) {
        InvokeDynamicSupport.bootstrap("logi", $$robo$$com_android_internal_util_StateMachine$logi(java.lang.String ), 0, this, string2);
    }

    protected void logw(String string2) {
        InvokeDynamicSupport.bootstrap("logw", $$robo$$com_android_internal_util_StateMachine$logw(java.lang.String ), 0, this, string2);
    }

    protected void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_util_StateMachine$loge(java.lang.String ), 0, this, string2);
    }

    protected void loge(String string2, Throwable throwable) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_util_StateMachine$loge(java.lang.String java.lang.Throwable ), 0, this, string2, throwable);
    }

    public /* synthetic */ StateMachine() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StateMachine)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class SmHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private boolean mHasQuit;
        private boolean mDbg;
        private static Object mSmHandlerObj;
        private Message mMsg;
        private LogRecords mLogRecords;
        private boolean mIsConstructionCompleted;
        private StateInfo[] mStateStack;
        private int mStateStackTopIndex;
        private StateInfo[] mTempStateStack;
        private int mTempStateStackCount;
        private HaltingState mHaltingState;
        private QuittingState mQuittingState;
        private StateMachine mSm;
        private HashMap<State, StateInfo> mStateInfo;
        private State mInitialState;
        private State mDestState;
        private ArrayList<Message> mDeferredMessages;

        private final void $$robo$$com_android_internal_util_StateMachine_SmHandler$handleMessage(Message msg) {
            if (!this.mHasQuit) {
                if (this.mSm != null && msg.what != -2 && msg.what != -1) {
                    this.mSm.onPreHandleMessage(msg);
                }
                if (this.mDbg) {
                    this.mSm.log("handleMessage: E msg.what=" + msg.what);
                }
                this.mMsg = msg;
                State msgProcessedState = null;
                if (this.mIsConstructionCompleted) {
                    msgProcessedState = this.processMsg(msg);
                } else if (!this.mIsConstructionCompleted && this.mMsg.what == -2 && this.mMsg.obj == mSmHandlerObj) {
                    this.mIsConstructionCompleted = true;
                    this.invokeEnterMethods(0);
                } else {
                    throw new RuntimeException("StateMachine.handleMessage: The start method not called, received msg: " + msg);
                }
                this.performTransitions(msgProcessedState, msg);
                if (this.mDbg && this.mSm != null) {
                    this.mSm.log("handleMessage: X");
                }
                if (this.mSm != null && msg.what != -2 && msg.what != -1) {
                    this.mSm.onPostHandleMessage(msg);
                }
            }
        }

        private final void $$robo$$com_android_internal_util_StateMachine_SmHandler$performTransitions(State msgProcessedState, Message msg) {
            State destState;
            boolean recordLogMsg;
            State orgState = this.mStateStack[this.mStateStackTopIndex].state;
            boolean bl = recordLogMsg = this.mSm.recordLogRec(this.mMsg) && msg.obj != mSmHandlerObj;
            if (this.mLogRecords.logOnlyTransitions()) {
                if (this.mDestState != null) {
                    this.mLogRecords.add(this.mSm, this.mMsg, this.mSm.getLogRecString(this.mMsg), msgProcessedState, orgState, this.mDestState);
                }
            } else if (recordLogMsg) {
                this.mLogRecords.add(this.mSm, this.mMsg, this.mSm.getLogRecString(this.mMsg), msgProcessedState, orgState, this.mDestState);
            }
            if ((destState = this.mDestState) != null) {
                while (true) {
                    if (this.mDbg) {
                        this.mSm.log("handleMessage: new destination call exit/enter");
                    }
                    StateInfo commonStateInfo = this.setupTempStateStackWithStatesToEnter(destState);
                    this.invokeExitMethods(commonStateInfo);
                    int stateStackEnteringIndex = this.moveTempStateStackToStateStack();
                    this.invokeEnterMethods(stateStackEnteringIndex);
                    this.moveDeferredMessageAtFrontOfQueue();
                    if (destState == this.mDestState) break;
                    destState = this.mDestState;
                }
                this.mDestState = null;
            }
            if (destState != null) {
                if (destState == this.mQuittingState) {
                    this.mSm.onQuitting();
                    this.cleanupAfterQuitting();
                } else if (destState == this.mHaltingState) {
                    this.mSm.onHalting();
                }
            }
        }

        private final void $$robo$$com_android_internal_util_StateMachine_SmHandler$cleanupAfterQuitting() {
            if (this.mSm.mSmThread != null) {
                this.getLooper().quit();
                this.mSm.mSmThread = null;
            }
            this.mSm.mSmHandler = null;
            this.mSm = null;
            this.mMsg = null;
            this.mLogRecords.cleanup();
            this.mStateStack = null;
            this.mTempStateStack = null;
            this.mStateInfo.clear();
            this.mInitialState = null;
            this.mDestState = null;
            this.mDeferredMessages.clear();
            this.mHasQuit = true;
        }

        private final void $$robo$$com_android_internal_util_StateMachine_SmHandler$completeConstruction() {
            if (this.mDbg) {
                this.mSm.log("completeConstruction: E");
            }
            int maxDepth = 0;
            for (StateInfo si : this.mStateInfo.values()) {
                int depth = 0;
                StateInfo i = si;
                while (i != null) {
                    i = i.parentStateInfo;
                    ++depth;
                }
                if (maxDepth >= depth) continue;
                maxDepth = depth;
            }
            if (this.mDbg) {
                this.mSm.log("completeConstruction: maxDepth=" + maxDepth);
            }
            this.mStateStack = new StateInfo[maxDepth];
            this.mTempStateStack = new StateInfo[maxDepth];
            this.setupInitialStateStack();
            this.sendMessageAtFrontOfQueue(this.obtainMessage(-2, mSmHandlerObj));
            if (this.mDbg) {
                this.mSm.log("completeConstruction: X");
            }
        }

        private final State $$robo$$com_android_internal_util_StateMachine_SmHandler$processMsg(Message msg) {
            StateInfo curStateInfo = this.mStateStack[this.mStateStackTopIndex];
            if (this.mDbg) {
                this.mSm.log("processMsg: " + curStateInfo.state.getName());
            }
            if (this.isQuit(msg)) {
                this.transitionTo(this.mQuittingState);
            } else {
                while (!curStateInfo.state.processMessage(msg)) {
                    curStateInfo = curStateInfo.parentStateInfo;
                    if (curStateInfo == null) {
                        this.mSm.unhandledMessage(msg);
                        break;
                    }
                    if (!this.mDbg) continue;
                    this.mSm.log("processMsg: " + curStateInfo.state.getName());
                }
            }
            return curStateInfo != null ? curStateInfo.state : null;
        }

        private final void $$robo$$com_android_internal_util_StateMachine_SmHandler$invokeExitMethods(StateInfo commonStateInfo) {
            while (this.mStateStackTopIndex >= 0 && this.mStateStack[this.mStateStackTopIndex] != commonStateInfo) {
                State curState = this.mStateStack[this.mStateStackTopIndex].state;
                if (this.mDbg) {
                    this.mSm.log("invokeExitMethods: " + curState.getName());
                }
                curState.exit();
                this.mStateStack[this.mStateStackTopIndex].active = false;
                --this.mStateStackTopIndex;
            }
        }

        private final void $$robo$$com_android_internal_util_StateMachine_SmHandler$invokeEnterMethods(int stateStackEnteringIndex) {
            for (int i = stateStackEnteringIndex; i <= this.mStateStackTopIndex; ++i) {
                if (this.mDbg) {
                    this.mSm.log("invokeEnterMethods: " + this.mStateStack[i].state.getName());
                }
                this.mStateStack[i].state.enter();
                this.mStateStack[i].active = true;
            }
        }

        private final void $$robo$$com_android_internal_util_StateMachine_SmHandler$moveDeferredMessageAtFrontOfQueue() {
            for (int i = this.mDeferredMessages.size() - 1; i >= 0; --i) {
                Message curMsg = this.mDeferredMessages.get(i);
                if (this.mDbg) {
                    this.mSm.log("moveDeferredMessageAtFrontOfQueue; what=" + curMsg.what);
                }
                this.sendMessageAtFrontOfQueue(curMsg);
            }
            this.mDeferredMessages.clear();
        }

        private final int $$robo$$com_android_internal_util_StateMachine_SmHandler$moveTempStateStackToStateStack() {
            int startingIndex = this.mStateStackTopIndex + 1;
            int j = startingIndex;
            for (int i = this.mTempStateStackCount - 1; i >= 0; --i) {
                if (this.mDbg) {
                    this.mSm.log("moveTempStackToStateStack: i=" + i + ",j=" + j);
                }
                this.mStateStack[j] = this.mTempStateStack[i];
                ++j;
            }
            this.mStateStackTopIndex = j - 1;
            if (this.mDbg) {
                this.mSm.log("moveTempStackToStateStack: X mStateStackTop=" + this.mStateStackTopIndex + ",startingIndex=" + startingIndex + ",Top=" + this.mStateStack[this.mStateStackTopIndex].state.getName());
            }
            return startingIndex;
        }

        private final StateInfo $$robo$$com_android_internal_util_StateMachine_SmHandler$setupTempStateStackWithStatesToEnter(State destState) {
            this.mTempStateStackCount = 0;
            StateInfo curStateInfo = this.mStateInfo.get(destState);
            do {
                this.mTempStateStack[this.mTempStateStackCount++] = curStateInfo;
            } while ((curStateInfo = curStateInfo.parentStateInfo) != null && !curStateInfo.active);
            if (this.mDbg) {
                this.mSm.log("setupTempStateStackWithStatesToEnter: X mTempStateStackCount=" + this.mTempStateStackCount + ",curStateInfo: " + curStateInfo);
            }
            return curStateInfo;
        }

        private final void $$robo$$com_android_internal_util_StateMachine_SmHandler$setupInitialStateStack() {
            if (this.mDbg) {
                this.mSm.log("setupInitialStateStack: E mInitialState=" + this.mInitialState.getName());
            }
            StateInfo curStateInfo = this.mStateInfo.get(this.mInitialState);
            this.mTempStateStackCount = 0;
            while (curStateInfo != null) {
                this.mTempStateStack[this.mTempStateStackCount] = curStateInfo;
                curStateInfo = curStateInfo.parentStateInfo;
                ++this.mTempStateStackCount;
            }
            this.mStateStackTopIndex = -1;
            this.moveTempStateStackToStateStack();
        }

        private final Message $$robo$$com_android_internal_util_StateMachine_SmHandler$getCurrentMessage() {
            return this.mMsg;
        }

        private final IState $$robo$$com_android_internal_util_StateMachine_SmHandler$getCurrentState() {
            return this.mStateStack[this.mStateStackTopIndex].state;
        }

        private final StateInfo $$robo$$com_android_internal_util_StateMachine_SmHandler$addState(State state, State parent) {
            StateInfo stateInfo;
            if (this.mDbg) {
                this.mSm.log("addStateInternal: E state=" + state.getName() + ",parent=" + (parent == null ? "" : parent.getName()));
            }
            StateInfo parentStateInfo = null;
            if (parent != null && (parentStateInfo = this.mStateInfo.get(parent)) == null) {
                parentStateInfo = this.addState(parent, null);
            }
            if ((stateInfo = this.mStateInfo.get(state)) == null) {
                stateInfo = new StateInfo(this);
                this.mStateInfo.put(state, stateInfo);
            }
            if (stateInfo.parentStateInfo != null && stateInfo.parentStateInfo != parentStateInfo) {
                throw new RuntimeException("state already added");
            }
            stateInfo.state = state;
            stateInfo.parentStateInfo = parentStateInfo;
            stateInfo.active = false;
            if (this.mDbg) {
                this.mSm.log("addStateInternal: X stateInfo: " + stateInfo);
            }
            return stateInfo;
        }

        private void $$robo$$com_android_internal_util_StateMachine_SmHandler$__constructor__(Looper looper, StateMachine sm) {
            this.mHasQuit = false;
            this.mDbg = false;
            this.mLogRecords = new LogRecords();
            this.mStateStackTopIndex = -1;
            this.mHaltingState = new HaltingState(this);
            this.mQuittingState = new QuittingState(this);
            this.mStateInfo = new HashMap();
            this.mDeferredMessages = new ArrayList();
            this.mSm = sm;
            this.addState(this.mHaltingState, null);
            this.addState(this.mQuittingState, null);
        }

        private final void $$robo$$com_android_internal_util_StateMachine_SmHandler$setInitialState(State initialState) {
            if (this.mDbg) {
                this.mSm.log("setInitialState: initialState=" + initialState.getName());
            }
            this.mInitialState = initialState;
        }

        private final void $$robo$$com_android_internal_util_StateMachine_SmHandler$transitionTo(IState destState) {
            this.mDestState = (State)destState;
            if (this.mDbg) {
                this.mSm.log("transitionTo: destState=" + this.mDestState.getName());
            }
        }

        private final void $$robo$$com_android_internal_util_StateMachine_SmHandler$deferMessage(Message msg) {
            if (this.mDbg) {
                this.mSm.log("deferMessage: msg=" + msg.what);
            }
            Message newMsg = this.obtainMessage();
            newMsg.copyFrom(msg);
            this.mDeferredMessages.add(newMsg);
        }

        private final void $$robo$$com_android_internal_util_StateMachine_SmHandler$quit() {
            if (this.mDbg) {
                this.mSm.log("quit:");
            }
            this.sendMessage(this.obtainMessage(-1, mSmHandlerObj));
        }

        private final void $$robo$$com_android_internal_util_StateMachine_SmHandler$quitNow() {
            if (this.mDbg) {
                this.mSm.log("quitNow:");
            }
            this.sendMessageAtFrontOfQueue(this.obtainMessage(-1, mSmHandlerObj));
        }

        private final boolean $$robo$$com_android_internal_util_StateMachine_SmHandler$isQuit(Message msg) {
            return msg.what == -1 && msg.obj == mSmHandlerObj;
        }

        private final boolean $$robo$$com_android_internal_util_StateMachine_SmHandler$isDbg() {
            return this.mDbg;
        }

        private final void $$robo$$com_android_internal_util_StateMachine_SmHandler$setDbg(boolean dbg) {
            this.mDbg = dbg;
        }

        private /* synthetic */ void $$robo$$com_android_internal_util_StateMachine_SmHandler$__constructor__(Looper x0, StateMachine x1, 1 x2) {
        }

        static void __staticInitializer__() {
            mSmHandlerObj = new Object();
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_util_StateMachine_SmHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        private void performTransitions(State state, Message message) {
            InvokeDynamicSupport.bootstrap("performTransitions", $$robo$$com_android_internal_util_StateMachine_SmHandler$performTransitions(com.android.internal.util.State android.os.Message ), 0, this, state, message);
        }

        private void cleanupAfterQuitting() {
            InvokeDynamicSupport.bootstrap("cleanupAfterQuitting", $$robo$$com_android_internal_util_StateMachine_SmHandler$cleanupAfterQuitting(), 0, this);
        }

        private void completeConstruction() {
            InvokeDynamicSupport.bootstrap("completeConstruction", $$robo$$com_android_internal_util_StateMachine_SmHandler$completeConstruction(), 0, this);
        }

        private State processMsg(Message message) {
            return InvokeDynamicSupport.bootstrap("processMsg", $$robo$$com_android_internal_util_StateMachine_SmHandler$processMsg(android.os.Message ), 0, this, message);
        }

        private void invokeExitMethods(StateInfo stateInfo) {
            InvokeDynamicSupport.bootstrap("invokeExitMethods", $$robo$$com_android_internal_util_StateMachine_SmHandler$invokeExitMethods(com.android.internal.util.StateMachine$SmHandler$StateInfo ), 0, this, stateInfo);
        }

        private void invokeEnterMethods(int n) {
            InvokeDynamicSupport.bootstrap("invokeEnterMethods", $$robo$$com_android_internal_util_StateMachine_SmHandler$invokeEnterMethods(int ), 0, this, n);
        }

        private void moveDeferredMessageAtFrontOfQueue() {
            InvokeDynamicSupport.bootstrap("moveDeferredMessageAtFrontOfQueue", $$robo$$com_android_internal_util_StateMachine_SmHandler$moveDeferredMessageAtFrontOfQueue(), 0, this);
        }

        private int moveTempStateStackToStateStack() {
            return (int)InvokeDynamicSupport.bootstrap("moveTempStateStackToStateStack", $$robo$$com_android_internal_util_StateMachine_SmHandler$moveTempStateStackToStateStack(), 0, this);
        }

        private StateInfo setupTempStateStackWithStatesToEnter(State state) {
            return InvokeDynamicSupport.bootstrap("setupTempStateStackWithStatesToEnter", $$robo$$com_android_internal_util_StateMachine_SmHandler$setupTempStateStackWithStatesToEnter(com.android.internal.util.State ), 0, this, state);
        }

        private void setupInitialStateStack() {
            InvokeDynamicSupport.bootstrap("setupInitialStateStack", $$robo$$com_android_internal_util_StateMachine_SmHandler$setupInitialStateStack(), 0, this);
        }

        private Message getCurrentMessage() {
            return InvokeDynamicSupport.bootstrap("getCurrentMessage", $$robo$$com_android_internal_util_StateMachine_SmHandler$getCurrentMessage(), 0, this);
        }

        private IState getCurrentState() {
            return InvokeDynamicSupport.bootstrap("getCurrentState", $$robo$$com_android_internal_util_StateMachine_SmHandler$getCurrentState(), 0, this);
        }

        private StateInfo addState(State state, State state2) {
            return InvokeDynamicSupport.bootstrap("addState", $$robo$$com_android_internal_util_StateMachine_SmHandler$addState(com.android.internal.util.State com.android.internal.util.State ), 0, this, state, state2);
        }

        private void __constructor__(Looper looper, StateMachine stateMachine) {
            this.$$robo$$com_android_internal_util_StateMachine_SmHandler$__constructor__(looper, stateMachine);
        }

        private SmHandler(Looper looper, StateMachine stateMachine) {
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_StateMachine_SmHandler$__constructor__(android.os.Looper com.android.internal.util.StateMachine ), 0, this, looper, stateMachine);
        }

        private void setInitialState(State state) {
            InvokeDynamicSupport.bootstrap("setInitialState", $$robo$$com_android_internal_util_StateMachine_SmHandler$setInitialState(com.android.internal.util.State ), 0, this, state);
        }

        private void transitionTo(IState iState) {
            InvokeDynamicSupport.bootstrap("transitionTo", $$robo$$com_android_internal_util_StateMachine_SmHandler$transitionTo(com.android.internal.util.IState ), 0, this, iState);
        }

        private void deferMessage(Message message) {
            InvokeDynamicSupport.bootstrap("deferMessage", $$robo$$com_android_internal_util_StateMachine_SmHandler$deferMessage(android.os.Message ), 0, this, message);
        }

        private void quit() {
            InvokeDynamicSupport.bootstrap("quit", $$robo$$com_android_internal_util_StateMachine_SmHandler$quit(), 0, this);
        }

        private void quitNow() {
            InvokeDynamicSupport.bootstrap("quitNow", $$robo$$com_android_internal_util_StateMachine_SmHandler$quitNow(), 0, this);
        }

        private boolean isQuit(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("isQuit", $$robo$$com_android_internal_util_StateMachine_SmHandler$isQuit(android.os.Message ), 0, this, message);
        }

        private boolean isDbg() {
            return (boolean)InvokeDynamicSupport.bootstrap("isDbg", $$robo$$com_android_internal_util_StateMachine_SmHandler$isDbg(), 0, this);
        }

        private void setDbg(boolean bl) {
            InvokeDynamicSupport.bootstrap("setDbg", $$robo$$com_android_internal_util_StateMachine_SmHandler$setDbg(boolean ), 0, this, bl);
        }

        private /* synthetic */ void __constructor__(Looper looper, StateMachine stateMachine, 1 var3_3) {
            this.$$robo$$com_android_internal_util_StateMachine_SmHandler$__constructor__(looper, stateMachine, var3_3);
        }

        static {
            RobolectricInternals.classInitializing(SmHandler.class);
        }

        public /* synthetic */ SmHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class QuittingState
        extends State
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SmHandler this$0;

            private void $$robo$$com_android_internal_util_StateMachine_SmHandler_QuittingState$__constructor__(SmHandler smHandler) {
            }

            private final boolean $$robo$$com_android_internal_util_StateMachine_SmHandler_QuittingState$processMessage(Message msg) {
                return false;
            }

            private /* synthetic */ void $$robo$$com_android_internal_util_StateMachine_SmHandler_QuittingState$__constructor__(SmHandler x0, 1 x1) {
            }

            private void __constructor__(SmHandler smHandler) {
                this.$$robo$$com_android_internal_util_StateMachine_SmHandler_QuittingState$__constructor__(smHandler);
            }

            private QuittingState(SmHandler smHandler) {
                this.this$0 = smHandler;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_StateMachine_SmHandler_QuittingState$__constructor__(com.android.internal.util.StateMachine$SmHandler ), 0, this, smHandler);
            }

            @Override
            public boolean processMessage(Message message) {
                return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_util_StateMachine_SmHandler_QuittingState$processMessage(android.os.Message ), 0, this, message);
            }

            private /* synthetic */ void __constructor__(SmHandler smHandler, 1 var2_2) {
                this.$$robo$$com_android_internal_util_StateMachine_SmHandler_QuittingState$__constructor__(smHandler, var2_2);
            }

            public /* synthetic */ QuittingState() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (QuittingState)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        private class HaltingState
        extends State
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SmHandler this$0;

            private void $$robo$$com_android_internal_util_StateMachine_SmHandler_HaltingState$__constructor__(SmHandler smHandler) {
            }

            private final boolean $$robo$$com_android_internal_util_StateMachine_SmHandler_HaltingState$processMessage(Message msg) {
                this.this$0.mSm.haltedProcessMessage(msg);
                return true;
            }

            private /* synthetic */ void $$robo$$com_android_internal_util_StateMachine_SmHandler_HaltingState$__constructor__(SmHandler x0, 1 x1) {
            }

            private void __constructor__(SmHandler smHandler) {
                this.$$robo$$com_android_internal_util_StateMachine_SmHandler_HaltingState$__constructor__(smHandler);
            }

            private HaltingState(SmHandler smHandler) {
                this.this$0 = smHandler;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_StateMachine_SmHandler_HaltingState$__constructor__(com.android.internal.util.StateMachine$SmHandler ), 0, this, smHandler);
            }

            @Override
            public boolean processMessage(Message message) {
                return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_util_StateMachine_SmHandler_HaltingState$processMessage(android.os.Message ), 0, this, message);
            }

            private /* synthetic */ void __constructor__(SmHandler smHandler, 1 var2_2) {
                this.$$robo$$com_android_internal_util_StateMachine_SmHandler_HaltingState$__constructor__(smHandler, var2_2);
            }

            public /* synthetic */ HaltingState() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HaltingState)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        private class StateInfo
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            State state;
            StateInfo parentStateInfo;
            boolean active;
            /* synthetic */ SmHandler this$0;

            private void $$robo$$com_android_internal_util_StateMachine_SmHandler_StateInfo$__constructor__(SmHandler smHandler) {
            }

            private final String $$robo$$com_android_internal_util_StateMachine_SmHandler_StateInfo$toString() {
                return "state=" + this.state.getName() + ",active=" + this.active + ",parent=" + (this.parentStateInfo == null ? "null" : this.parentStateInfo.state.getName());
            }

            private /* synthetic */ void $$robo$$com_android_internal_util_StateMachine_SmHandler_StateInfo$__constructor__(SmHandler x0, 1 x1) {
            }

            private void __constructor__(SmHandler smHandler) {
                this.$$robo$$com_android_internal_util_StateMachine_SmHandler_StateInfo$__constructor__(smHandler);
            }

            private StateInfo(SmHandler smHandler) {
                this.this$0 = smHandler;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_StateMachine_SmHandler_StateInfo$__constructor__(com.android.internal.util.StateMachine$SmHandler ), 0, this, smHandler);
            }

            public String toString() {
                return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_util_StateMachine_SmHandler_StateInfo$toString(), 0, this);
            }

            private /* synthetic */ void __constructor__(SmHandler smHandler, 1 var2_2) {
                this.$$robo$$com_android_internal_util_StateMachine_SmHandler_StateInfo$__constructor__(smHandler, var2_2);
            }

            public /* synthetic */ StateInfo() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StateInfo)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    private static class LogRecords
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int DEFAULT_SIZE = 20;
        private Vector<LogRec> mLogRecVector;
        private int mMaxSize;
        private int mOldestIndex;
        private int mCount;
        private boolean mLogOnlyTransitions;

        private void $$robo$$com_android_internal_util_StateMachine_LogRecords$__constructor__() {
            this.mLogRecVector = new Vector();
            this.mMaxSize = 20;
            this.mOldestIndex = 0;
            this.mCount = 0;
            this.mLogOnlyTransitions = false;
        }

        private final synchronized void $$robo$$com_android_internal_util_StateMachine_LogRecords$setSize(int maxSize) {
            this.mMaxSize = maxSize;
            this.mOldestIndex = 0;
            this.mCount = 0;
            this.mLogRecVector.clear();
        }

        private final synchronized void $$robo$$com_android_internal_util_StateMachine_LogRecords$setLogOnlyTransitions(boolean enable) {
            this.mLogOnlyTransitions = enable;
        }

        private final synchronized boolean $$robo$$com_android_internal_util_StateMachine_LogRecords$logOnlyTransitions() {
            return this.mLogOnlyTransitions;
        }

        private final synchronized int $$robo$$com_android_internal_util_StateMachine_LogRecords$size() {
            return this.mLogRecVector.size();
        }

        private final synchronized int $$robo$$com_android_internal_util_StateMachine_LogRecords$count() {
            return this.mCount;
        }

        private final synchronized void $$robo$$com_android_internal_util_StateMachine_LogRecords$cleanup() {
            this.mLogRecVector.clear();
        }

        private final synchronized LogRec $$robo$$com_android_internal_util_StateMachine_LogRecords$get(int index) {
            int nextIndex = this.mOldestIndex + index;
            if (nextIndex >= this.mMaxSize) {
                nextIndex -= this.mMaxSize;
            }
            if (nextIndex >= this.size()) {
                return null;
            }
            return this.mLogRecVector.get(nextIndex);
        }

        private final synchronized void $$robo$$com_android_internal_util_StateMachine_LogRecords$add(StateMachine sm, Message msg, String messageInfo, IState state, IState orgState, IState transToState) {
            ++this.mCount;
            if (this.mLogRecVector.size() < this.mMaxSize) {
                this.mLogRecVector.add(new LogRec(sm, msg, messageInfo, state, orgState, transToState));
            } else {
                LogRec pmi = this.mLogRecVector.get(this.mOldestIndex);
                ++this.mOldestIndex;
                if (this.mOldestIndex >= this.mMaxSize) {
                    this.mOldestIndex = 0;
                }
                pmi.update(sm, msg, messageInfo, state, orgState, transToState);
            }
        }

        private /* synthetic */ void $$robo$$com_android_internal_util_StateMachine_LogRecords$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_util_StateMachine_LogRecords$__constructor__();
        }

        private LogRecords() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_StateMachine_LogRecords$__constructor__(), 0, this);
        }

        synchronized void setSize(int n) {
            InvokeDynamicSupport.bootstrap("setSize", $$robo$$com_android_internal_util_StateMachine_LogRecords$setSize(int ), 0, this, n);
        }

        synchronized void setLogOnlyTransitions(boolean bl) {
            InvokeDynamicSupport.bootstrap("setLogOnlyTransitions", $$robo$$com_android_internal_util_StateMachine_LogRecords$setLogOnlyTransitions(boolean ), 0, this, bl);
        }

        synchronized boolean logOnlyTransitions() {
            return (boolean)InvokeDynamicSupport.bootstrap("logOnlyTransitions", $$robo$$com_android_internal_util_StateMachine_LogRecords$logOnlyTransitions(), 0, this);
        }

        synchronized int size() {
            return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$com_android_internal_util_StateMachine_LogRecords$size(), 0, this);
        }

        synchronized int count() {
            return (int)InvokeDynamicSupport.bootstrap("count", $$robo$$com_android_internal_util_StateMachine_LogRecords$count(), 0, this);
        }

        synchronized void cleanup() {
            InvokeDynamicSupport.bootstrap("cleanup", $$robo$$com_android_internal_util_StateMachine_LogRecords$cleanup(), 0, this);
        }

        synchronized LogRec get(int n) {
            return InvokeDynamicSupport.bootstrap("get", $$robo$$com_android_internal_util_StateMachine_LogRecords$get(int ), 0, this, n);
        }

        synchronized void add(StateMachine stateMachine, Message message, String string2, IState iState, IState iState2, IState iState3) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_util_StateMachine_LogRecords$add(com.android.internal.util.StateMachine android.os.Message java.lang.String com.android.internal.util.IState com.android.internal.util.IState com.android.internal.util.IState ), 0, this, stateMachine, message, string2, iState, iState2, iState3);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$com_android_internal_util_StateMachine_LogRecords$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LogRecords)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class LogRec
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private StateMachine mSm;
        private long mTime;
        private int mWhat;
        private String mInfo;
        private IState mState;
        private IState mOrgState;
        private IState mDstState;

        private void $$robo$$com_android_internal_util_StateMachine_LogRec$__constructor__(StateMachine sm, Message msg, String info, IState state, IState orgState, IState transToState) {
            this.update(sm, msg, info, state, orgState, transToState);
        }

        private final void $$robo$$com_android_internal_util_StateMachine_LogRec$update(StateMachine sm, Message msg, String info, IState state, IState orgState, IState dstState) {
            this.mSm = sm;
            this.mTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            this.mWhat = msg != null ? msg.what : 0;
            this.mInfo = info;
            this.mState = state;
            this.mOrgState = orgState;
            this.mDstState = dstState;
        }

        private final long $$robo$$com_android_internal_util_StateMachine_LogRec$getTime() {
            return this.mTime;
        }

        private final long $$robo$$com_android_internal_util_StateMachine_LogRec$getWhat() {
            return this.mWhat;
        }

        private final String $$robo$$com_android_internal_util_StateMachine_LogRec$getInfo() {
            return this.mInfo;
        }

        private final IState $$robo$$com_android_internal_util_StateMachine_LogRec$getState() {
            return this.mState;
        }

        private final IState $$robo$$com_android_internal_util_StateMachine_LogRec$getDestState() {
            return this.mDstState;
        }

        private final IState $$robo$$com_android_internal_util_StateMachine_LogRec$getOriginalState() {
            return this.mOrgState;
        }

        private final String $$robo$$com_android_internal_util_StateMachine_LogRec$toString() {
            String what;
            StringBuilder sb = new StringBuilder();
            sb.append("time=");
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(this.mTime);
            sb.append(String.format("%tm-%td %tH:%tM:%tS.%tL", c, c, c, c, c, c));
            sb.append(" processed=");
            sb.append(this.mState == null ? "<null>" : this.mState.getName());
            sb.append(" org=");
            sb.append(this.mOrgState == null ? "<null>" : this.mOrgState.getName());
            sb.append(" dest=");
            sb.append(this.mDstState == null ? "<null>" : this.mDstState.getName());
            sb.append(" what=");
            String string2 = what = this.mSm != null ? this.mSm.getWhatToString(this.mWhat) : "";
            if (TextUtils.isEmpty(what)) {
                sb.append(this.mWhat);
                sb.append("(0x");
                sb.append(Integer.toHexString(this.mWhat));
                sb.append(")");
            } else {
                sb.append(what);
            }
            if (!TextUtils.isEmpty(this.mInfo)) {
                sb.append(" ");
                sb.append(this.mInfo);
            }
            return sb.toString();
        }

        private void __constructor__(StateMachine stateMachine, Message message, String string2, IState iState, IState iState2, IState iState3) {
            this.$$robo$$com_android_internal_util_StateMachine_LogRec$__constructor__(stateMachine, message, string2, iState, iState2, iState3);
        }

        LogRec(StateMachine stateMachine, Message message, String string2, IState iState, IState iState2, IState iState3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_StateMachine_LogRec$__constructor__(com.android.internal.util.StateMachine android.os.Message java.lang.String com.android.internal.util.IState com.android.internal.util.IState com.android.internal.util.IState ), 0, this, stateMachine, message, string2, iState, iState2, iState3);
        }

        public void update(StateMachine stateMachine, Message message, String string2, IState iState, IState iState2, IState iState3) {
            InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_util_StateMachine_LogRec$update(com.android.internal.util.StateMachine android.os.Message java.lang.String com.android.internal.util.IState com.android.internal.util.IState com.android.internal.util.IState ), 0, this, stateMachine, message, string2, iState, iState2, iState3);
        }

        public long getTime() {
            return (long)InvokeDynamicSupport.bootstrap("getTime", $$robo$$com_android_internal_util_StateMachine_LogRec$getTime(), 0, this);
        }

        public long getWhat() {
            return (long)InvokeDynamicSupport.bootstrap("getWhat", $$robo$$com_android_internal_util_StateMachine_LogRec$getWhat(), 0, this);
        }

        public String getInfo() {
            return InvokeDynamicSupport.bootstrap("getInfo", $$robo$$com_android_internal_util_StateMachine_LogRec$getInfo(), 0, this);
        }

        public IState getState() {
            return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_util_StateMachine_LogRec$getState(), 0, this);
        }

        public IState getDestState() {
            return InvokeDynamicSupport.bootstrap("getDestState", $$robo$$com_android_internal_util_StateMachine_LogRec$getDestState(), 0, this);
        }

        public IState getOriginalState() {
            return InvokeDynamicSupport.bootstrap("getOriginalState", $$robo$$com_android_internal_util_StateMachine_LogRec$getOriginalState(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_util_StateMachine_LogRec$toString(), 0, this);
        }

        public /* synthetic */ LogRec() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LogRec)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

