/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.SystemClock;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class BaseSurfaceHolder
implements SurfaceHolder,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BaseSurfaceHolder";
    static boolean DEBUG = false;
    public ArrayList<SurfaceHolder.Callback> mCallbacks;
    SurfaceHolder.Callback[] mGottenCallbacks;
    boolean mHaveGottenCallbacks;
    public ReentrantLock mSurfaceLock;
    public Surface mSurface;
    int mRequestedWidth;
    int mRequestedHeight;
    protected int mRequestedFormat;
    int mRequestedType;
    long mLastLockTime;
    int mType;
    Rect mSurfaceFrame;
    Rect mTmpDirty;

    private void $$robo$$com_android_internal_view_BaseSurfaceHolder$__constructor__() {
        this.mCallbacks = new ArrayList();
        this.mSurfaceLock = new ReentrantLock();
        this.mSurface = new Surface();
        this.mRequestedWidth = -1;
        this.mRequestedHeight = -1;
        this.mRequestedFormat = -1;
        this.mRequestedType = -1;
        this.mLastLockTime = 0L;
        this.mType = -1;
        this.mSurfaceFrame = new Rect();
    }

    public abstract void onUpdateSurface();

    public abstract void onRelayoutContainer();

    public abstract boolean onAllowLockCanvas();

    private final int $$robo$$com_android_internal_view_BaseSurfaceHolder$getRequestedWidth() {
        return this.mRequestedWidth;
    }

    private final int $$robo$$com_android_internal_view_BaseSurfaceHolder$getRequestedHeight() {
        return this.mRequestedHeight;
    }

    private final int $$robo$$com_android_internal_view_BaseSurfaceHolder$getRequestedFormat() {
        return this.mRequestedFormat;
    }

    private final int $$robo$$com_android_internal_view_BaseSurfaceHolder$getRequestedType() {
        return this.mRequestedType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_view_BaseSurfaceHolder$addCallback(SurfaceHolder.Callback callback) {
        ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
        synchronized (arrayList) {
            if (!this.mCallbacks.contains(callback)) {
                this.mCallbacks.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_view_BaseSurfaceHolder$removeCallback(SurfaceHolder.Callback callback) {
        ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
        synchronized (arrayList) {
            this.mCallbacks.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SurfaceHolder.Callback[] $$robo$$com_android_internal_view_BaseSurfaceHolder$getCallbacks() {
        if (this.mHaveGottenCallbacks) {
            return this.mGottenCallbacks;
        }
        ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
        synchronized (arrayList) {
            int N = this.mCallbacks.size();
            if (N > 0) {
                if (this.mGottenCallbacks == null || this.mGottenCallbacks.length != N) {
                    this.mGottenCallbacks = new SurfaceHolder.Callback[N];
                }
                this.mCallbacks.toArray(this.mGottenCallbacks);
            } else {
                this.mGottenCallbacks = null;
            }
            this.mHaveGottenCallbacks = true;
        }
        return this.mGottenCallbacks;
    }

    private final void $$robo$$com_android_internal_view_BaseSurfaceHolder$ungetCallbacks() {
        this.mHaveGottenCallbacks = false;
    }

    private final void $$robo$$com_android_internal_view_BaseSurfaceHolder$setFixedSize(int width, int height) {
        if (this.mRequestedWidth != width || this.mRequestedHeight != height) {
            this.mRequestedWidth = width;
            this.mRequestedHeight = height;
            this.onRelayoutContainer();
        }
    }

    private final void $$robo$$com_android_internal_view_BaseSurfaceHolder$setSizeFromLayout() {
        if (this.mRequestedWidth != -1 || this.mRequestedHeight != -1) {
            this.mRequestedHeight = -1;
            this.mRequestedWidth = -1;
            this.onRelayoutContainer();
        }
    }

    private final void $$robo$$com_android_internal_view_BaseSurfaceHolder$setFormat(int format) {
        if (this.mRequestedFormat != format) {
            this.mRequestedFormat = format;
            this.onUpdateSurface();
        }
    }

    private final void $$robo$$com_android_internal_view_BaseSurfaceHolder$setType(int type) {
        switch (type) {
            case 1: 
            case 2: {
                type = 0;
            }
        }
        switch (type) {
            case 0: 
            case 3: {
                if (this.mRequestedType == type) break;
                this.mRequestedType = type;
                this.onUpdateSurface();
            }
        }
    }

    private final Canvas $$robo$$com_android_internal_view_BaseSurfaceHolder$lockCanvas() {
        return this.internalLockCanvas(null);
    }

    private final Canvas $$robo$$com_android_internal_view_BaseSurfaceHolder$lockCanvas(Rect dirty) {
        return this.internalLockCanvas(dirty);
    }

    private final Canvas $$robo$$com_android_internal_view_BaseSurfaceHolder$internalLockCanvas(Rect dirty) {
        if (this.mType == 3) {
            throw new SurfaceHolder.BadSurfaceTypeException("Surface type is SURFACE_TYPE_PUSH_BUFFERS");
        }
        this.mSurfaceLock.lock();
        Canvas c = null;
        if (this.onAllowLockCanvas()) {
            if (dirty == null) {
                if (this.mTmpDirty == null) {
                    this.mTmpDirty = new Rect();
                }
                this.mTmpDirty.set(this.mSurfaceFrame);
                dirty = this.mTmpDirty;
            }
            try {
                c = this.mSurface.lockCanvas(dirty);
            }
            catch (Exception e) {
                Log.e("BaseSurfaceHolder", "Exception locking surface", e);
            }
        }
        if (c != null) {
            this.mLastLockTime = SystemClock.uptimeMillis();
            return c;
        }
        long nextTime = this.mLastLockTime + 100L;
        long now = SystemClock.uptimeMillis();
        if (nextTime > now) {
            try {
                Thread.sleep(nextTime - now);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            now = SystemClock.uptimeMillis();
        }
        this.mLastLockTime = now;
        this.mSurfaceLock.unlock();
        return null;
    }

    private final void $$robo$$com_android_internal_view_BaseSurfaceHolder$unlockCanvasAndPost(Canvas canvas) {
        this.mSurface.unlockCanvasAndPost(canvas);
        this.mSurfaceLock.unlock();
    }

    private final Surface $$robo$$com_android_internal_view_BaseSurfaceHolder$getSurface() {
        return this.mSurface;
    }

    private final Rect $$robo$$com_android_internal_view_BaseSurfaceHolder$getSurfaceFrame() {
        return this.mSurfaceFrame;
    }

    private final void $$robo$$com_android_internal_view_BaseSurfaceHolder$setSurfaceFrameSize(int width, int height) {
        this.mSurfaceFrame.top = 0;
        this.mSurfaceFrame.left = 0;
        this.mSurfaceFrame.right = width;
        this.mSurfaceFrame.bottom = height;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_view_BaseSurfaceHolder$__constructor__();
    }

    public BaseSurfaceHolder() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_BaseSurfaceHolder$__constructor__(), 0, this);
    }

    public int getRequestedWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedWidth", $$robo$$com_android_internal_view_BaseSurfaceHolder$getRequestedWidth(), 0, this);
    }

    public int getRequestedHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedHeight", $$robo$$com_android_internal_view_BaseSurfaceHolder$getRequestedHeight(), 0, this);
    }

    public int getRequestedFormat() {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedFormat", $$robo$$com_android_internal_view_BaseSurfaceHolder$getRequestedFormat(), 0, this);
    }

    public int getRequestedType() {
        return (int)InvokeDynamicSupport.bootstrap("getRequestedType", $$robo$$com_android_internal_view_BaseSurfaceHolder$getRequestedType(), 0, this);
    }

    @Override
    public void addCallback(SurfaceHolder.Callback callback) {
        InvokeDynamicSupport.bootstrap("addCallback", $$robo$$com_android_internal_view_BaseSurfaceHolder$addCallback(android.view.SurfaceHolder$Callback ), 0, this, callback);
    }

    @Override
    public void removeCallback(SurfaceHolder.Callback callback) {
        InvokeDynamicSupport.bootstrap("removeCallback", $$robo$$com_android_internal_view_BaseSurfaceHolder$removeCallback(android.view.SurfaceHolder$Callback ), 0, this, callback);
    }

    public SurfaceHolder.Callback[] getCallbacks() {
        return InvokeDynamicSupport.bootstrap("getCallbacks", $$robo$$com_android_internal_view_BaseSurfaceHolder$getCallbacks(), 0, this);
    }

    public void ungetCallbacks() {
        InvokeDynamicSupport.bootstrap("ungetCallbacks", $$robo$$com_android_internal_view_BaseSurfaceHolder$ungetCallbacks(), 0, this);
    }

    @Override
    public void setFixedSize(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setFixedSize", $$robo$$com_android_internal_view_BaseSurfaceHolder$setFixedSize(int int ), 0, this, n, n2);
    }

    @Override
    public void setSizeFromLayout() {
        InvokeDynamicSupport.bootstrap("setSizeFromLayout", $$robo$$com_android_internal_view_BaseSurfaceHolder$setSizeFromLayout(), 0, this);
    }

    @Override
    public void setFormat(int n) {
        InvokeDynamicSupport.bootstrap("setFormat", $$robo$$com_android_internal_view_BaseSurfaceHolder$setFormat(int ), 0, this, n);
    }

    @Override
    public void setType(int n) {
        InvokeDynamicSupport.bootstrap("setType", $$robo$$com_android_internal_view_BaseSurfaceHolder$setType(int ), 0, this, n);
    }

    @Override
    public Canvas lockCanvas() {
        return InvokeDynamicSupport.bootstrap("lockCanvas", $$robo$$com_android_internal_view_BaseSurfaceHolder$lockCanvas(), 0, this);
    }

    @Override
    public Canvas lockCanvas(Rect rect) {
        return InvokeDynamicSupport.bootstrap("lockCanvas", $$robo$$com_android_internal_view_BaseSurfaceHolder$lockCanvas(android.graphics.Rect ), 0, this, rect);
    }

    private Canvas internalLockCanvas(Rect rect) {
        return InvokeDynamicSupport.bootstrap("internalLockCanvas", $$robo$$com_android_internal_view_BaseSurfaceHolder$internalLockCanvas(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public void unlockCanvasAndPost(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("unlockCanvasAndPost", $$robo$$com_android_internal_view_BaseSurfaceHolder$unlockCanvasAndPost(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public Surface getSurface() {
        return InvokeDynamicSupport.bootstrap("getSurface", $$robo$$com_android_internal_view_BaseSurfaceHolder$getSurface(), 0, this);
    }

    @Override
    public Rect getSurfaceFrame() {
        return InvokeDynamicSupport.bootstrap("getSurfaceFrame", $$robo$$com_android_internal_view_BaseSurfaceHolder$getSurfaceFrame(), 0, this);
    }

    public void setSurfaceFrameSize(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setSurfaceFrameSize", $$robo$$com_android_internal_view_BaseSurfaceHolder$setSurfaceFrameSize(int int ), 0, this, n, n2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BaseSurfaceHolder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

