/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RemoteViews;
import com.android.internal.R;
import com.android.internal.widget.ImageFloatingTextView;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class MessagingLinearLayout
extends ViewGroup
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int mSpacing;
    private int mMaxHeight;
    private int mIndentLines;
    private int mContractedChildId;

    private void $$robo$$com_android_internal_widget_MessagingLinearLayout$__constructor__(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MessagingLinearLayout, 0, 0);
        int N = a.getIndexCount();
        block4: for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 1: {
                    this.mMaxHeight = a.getDimensionPixelSize(i, 0);
                    continue block4;
                }
                case 0: {
                    this.mSpacing = a.getDimensionPixelSize(i, 0);
                }
            }
        }
        if (this.mMaxHeight <= 0) {
            throw new IllegalStateException("MessagingLinearLayout: Must specify positive maxHeight");
        }
        a.recycle();
    }

    private final void $$robo$$com_android_internal_widget_MessagingLinearLayout$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        switch (View.MeasureSpec.getMode(heightMeasureSpec)) {
            case -2147483648: {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.min(this.mMaxHeight, View.MeasureSpec.getSize(heightMeasureSpec)), Integer.MIN_VALUE);
                break;
            }
            case 0: {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(this.mMaxHeight, Integer.MIN_VALUE);
                break;
            }
        }
        int targetHeight = View.MeasureSpec.getSize(heightMeasureSpec);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            lp.hide = true;
        }
        int totalHeight = this.mPaddingTop + this.mPaddingBottom;
        boolean first = true;
        for (int i = count - 1; i >= 0 && totalHeight < targetHeight; --i) {
            if (this.getChildAt(i).getVisibility() == 8) continue;
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)this.getChildAt(i).getLayoutParams();
            if (child instanceof ImageFloatingTextView) {
                ((ImageFloatingTextView)child).setNumIndentLines(this.mIndentLines);
            }
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            int childHeight = child.getMeasuredHeight();
            int newHeight = Math.max(totalHeight, totalHeight + childHeight + lp.topMargin + lp.bottomMargin + (first ? 0 : this.mSpacing));
            first = false;
            if (newHeight > targetHeight) break;
            totalHeight = newHeight;
            lp.hide = false;
        }
        int measuredWidth = this.mPaddingLeft + this.mPaddingRight;
        int imageLines = this.mIndentLines;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (child.getVisibility() == 8 || lp.hide) continue;
            if (child instanceof ImageFloatingTextView) {
                boolean changed;
                ImageFloatingTextView textChild = (ImageFloatingTextView)child;
                if (imageLines == 2 && textChild.getLineCount() > 2) {
                    imageLines = 3;
                }
                if (changed = textChild.setNumIndentLines(Math.max(0, imageLines))) {
                    this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
                }
                imageLines -= textChild.getLineCount();
            }
            measuredWidth = Math.max(measuredWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin + this.mPaddingLeft + this.mPaddingRight);
        }
        this.setMeasuredDimension(MessagingLinearLayout.resolveSize(Math.max(this.getSuggestedMinimumWidth(), measuredWidth), widthMeasureSpec), MessagingLinearLayout.resolveSize(Math.max(this.getSuggestedMinimumHeight(), totalHeight), heightMeasureSpec));
    }

    private final void $$robo$$com_android_internal_widget_MessagingLinearLayout$onLayout(boolean changed, int left, int top, int right, int bottom) {
        int paddingLeft = this.mPaddingLeft;
        int width = right - left;
        int childRight = width - this.mPaddingRight;
        int layoutDirection = this.getLayoutDirection();
        int count = this.getChildCount();
        int childTop = this.mPaddingTop;
        boolean first = true;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (child.getVisibility() == 8 || lp.hide) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            int childLeft = layoutDirection == 1 ? childRight - childWidth - lp.rightMargin : paddingLeft + lp.leftMargin;
            if (!first) {
                childTop += this.mSpacing;
            }
            child.layout(childLeft, childTop += lp.topMargin, childLeft + childWidth, childTop + childHeight);
            childTop += childHeight + lp.bottomMargin;
            first = false;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_MessagingLinearLayout$drawChild(Canvas canvas, View child, long drawingTime) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp.hide) {
            return true;
        }
        return super.drawChild(canvas, child, drawingTime);
    }

    private final LayoutParams $$robo$$com_android_internal_widget_MessagingLinearLayout$generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.mContext, attrs);
    }

    private final LayoutParams $$robo$$com_android_internal_widget_MessagingLinearLayout$generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2);
    }

    private final LayoutParams $$robo$$com_android_internal_widget_MessagingLinearLayout$generateLayoutParams(ViewGroup.LayoutParams lp) {
        LayoutParams copy = new LayoutParams(lp.width, lp.height);
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            copy.copyMarginsFrom((ViewGroup.MarginLayoutParams)lp);
        }
        return copy;
    }

    @RemotableViewMethod
    private final void $$robo$$com_android_internal_widget_MessagingLinearLayout$setNumIndentLines(int numberLines) {
        this.mIndentLines = numberLines;
    }

    @RemotableViewMethod
    private final void $$robo$$com_android_internal_widget_MessagingLinearLayout$setContractedChildId(int contractedChildId) {
        this.mContractedChildId = contractedChildId;
    }

    private final int $$robo$$com_android_internal_widget_MessagingLinearLayout$getContractedChildId() {
        return this.mContractedChildId;
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_MessagingLinearLayout$__constructor__(context, attributeSet);
    }

    public MessagingLinearLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_MessagingLinearLayout$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_MessagingLinearLayout$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$com_android_internal_widget_MessagingLinearLayout$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @Override
    protected boolean drawChild(Canvas canvas, View view, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("drawChild", $$robo$$com_android_internal_widget_MessagingLinearLayout$drawChild(android.graphics.Canvas android.view.View long ), 0, this, canvas, view, l);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$com_android_internal_widget_MessagingLinearLayout$generateLayoutParams(android.util.AttributeSet ), 0, this, attributeSet);
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateDefaultLayoutParams", $$robo$$com_android_internal_widget_MessagingLinearLayout$generateDefaultLayoutParams(), 0, this);
    }

    @Override
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$com_android_internal_widget_MessagingLinearLayout$generateLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    @RemotableViewMethod
    public void setNumIndentLines(int n) {
        InvokeDynamicSupport.bootstrap("setNumIndentLines", $$robo$$com_android_internal_widget_MessagingLinearLayout$setNumIndentLines(int ), 0, this, n);
    }

    @RemotableViewMethod
    public void setContractedChildId(int n) {
        InvokeDynamicSupport.bootstrap("setContractedChildId", $$robo$$com_android_internal_widget_MessagingLinearLayout$setContractedChildId(int ), 0, this, n);
    }

    public int getContractedChildId() {
        return (int)InvokeDynamicSupport.bootstrap("getContractedChildId", $$robo$$com_android_internal_widget_MessagingLinearLayout$getContractedChildId(), 0, this);
    }

    public /* synthetic */ MessagingLinearLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MessagingLinearLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        boolean hide;

        private void $$robo$$com_android_internal_widget_MessagingLinearLayout_LayoutParams$__constructor__(Context c, AttributeSet attrs) {
            this.hide = false;
        }

        private void $$robo$$com_android_internal_widget_MessagingLinearLayout_LayoutParams$__constructor__(int width, int height) {
            this.hide = false;
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$com_android_internal_widget_MessagingLinearLayout_LayoutParams$__constructor__(context, attributeSet);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_MessagingLinearLayout_LayoutParams$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$com_android_internal_widget_MessagingLinearLayout_LayoutParams$__constructor__(n, n2);
        }

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_MessagingLinearLayout_LayoutParams$__constructor__(int int ), 0, this, n, n2);
        }

        public /* synthetic */ LayoutParams() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

