/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.Resources;
import android.inputmethodservice.Keyboard;
import android.inputmethodservice.KeyboardView;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import com.android.internal.widget.PasswordEntryKeyboard;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PasswordEntryKeyboardHelper
implements KeyboardView.OnKeyboardActionListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int KEYBOARD_MODE_ALPHA = 0;
    public static int KEYBOARD_MODE_NUMERIC = 1;
    private static int KEYBOARD_STATE_NORMAL = 0;
    private static int KEYBOARD_STATE_SHIFTED = 1;
    private static int KEYBOARD_STATE_CAPSLOCK = 2;
    private static String TAG = "PasswordEntryKeyboardHelper";
    private int mKeyboardMode;
    private int mKeyboardState;
    private PasswordEntryKeyboard mQwertyKeyboard;
    private PasswordEntryKeyboard mQwertyKeyboardShifted;
    private PasswordEntryKeyboard mSymbolsKeyboard;
    private PasswordEntryKeyboard mSymbolsKeyboardShifted;
    private PasswordEntryKeyboard mNumericKeyboard;
    private Context mContext;
    private View mTargetView;
    private KeyboardView mKeyboardView;
    private long[] mVibratePattern;
    private boolean mEnableHaptics;
    private static int NUMERIC = 0;
    private static int QWERTY = 1;
    private static int QWERTY_SHIFTED = 2;
    private static int SYMBOLS = 3;
    private static int SYMBOLS_SHIFTED = 4;
    int[] mLayouts;
    private boolean mUsingScreenWidth;

    private void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$__constructor__(Context context, KeyboardView keyboardView, View targetView) {
    }

    private void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$__constructor__(Context context, KeyboardView keyboardView, View targetView, boolean useFullScreenWidth) {
    }

    private void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$__constructor__(Context context, KeyboardView keyboardView, View targetView, boolean useFullScreenWidth, int[] layouts) {
        this.mKeyboardMode = 0;
        this.mKeyboardState = 0;
        this.mEnableHaptics = false;
        this.mLayouts = new int[]{0x1110009, 0x111000B, 0x111000C, 0x111000D, 0x111000E};
        this.mContext = context;
        this.mTargetView = targetView;
        this.mKeyboardView = keyboardView;
        this.mKeyboardView.setOnKeyboardActionListener(this);
        this.mUsingScreenWidth = useFullScreenWidth;
        if (layouts != null) {
            if (layouts.length != this.mLayouts.length) {
                throw new RuntimeException("Wrong number of layouts");
            }
            for (int i = 0; i < this.mLayouts.length; ++i) {
                this.mLayouts[i] = layouts[i];
            }
        }
        this.createKeyboards();
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$createKeyboards() {
        ViewGroup.LayoutParams lp = this.mKeyboardView.getLayoutParams();
        if (this.mUsingScreenWidth || lp.width == -1) {
            this.createKeyboardsWithDefaultWidth();
        } else {
            this.createKeyboardsWithSpecificSize(lp.width, lp.height);
        }
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$setEnableHaptics(boolean enabled) {
        this.mEnableHaptics = enabled;
    }

    private final boolean $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$isAlpha() {
        return this.mKeyboardMode == 0;
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$createKeyboardsWithSpecificSize(int width, int height) {
        this.mNumericKeyboard = new PasswordEntryKeyboard(this.mContext, this.mLayouts[0], width, height);
        this.mQwertyKeyboard = new PasswordEntryKeyboard(this.mContext, this.mLayouts[1], 16909398, width, height);
        this.mQwertyKeyboard.enableShiftLock();
        this.mQwertyKeyboardShifted = new PasswordEntryKeyboard(this.mContext, this.mLayouts[2], 16909398, width, height);
        this.mQwertyKeyboardShifted.enableShiftLock();
        this.mQwertyKeyboardShifted.setShifted(true);
        this.mSymbolsKeyboard = new PasswordEntryKeyboard(this.mContext, this.mLayouts[3], width, height);
        this.mSymbolsKeyboard.enableShiftLock();
        this.mSymbolsKeyboardShifted = new PasswordEntryKeyboard(this.mContext, this.mLayouts[4], width, height);
        this.mSymbolsKeyboardShifted.enableShiftLock();
        this.mSymbolsKeyboardShifted.setShifted(true);
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$createKeyboardsWithDefaultWidth() {
        this.mNumericKeyboard = new PasswordEntryKeyboard(this.mContext, this.mLayouts[0]);
        this.mQwertyKeyboard = new PasswordEntryKeyboard(this.mContext, this.mLayouts[1], 16909398);
        this.mQwertyKeyboard.enableShiftLock();
        this.mQwertyKeyboardShifted = new PasswordEntryKeyboard(this.mContext, this.mLayouts[2], 16909398);
        this.mQwertyKeyboardShifted.enableShiftLock();
        this.mQwertyKeyboardShifted.setShifted(true);
        this.mSymbolsKeyboard = new PasswordEntryKeyboard(this.mContext, this.mLayouts[3]);
        this.mSymbolsKeyboard.enableShiftLock();
        this.mSymbolsKeyboardShifted = new PasswordEntryKeyboard(this.mContext, this.mLayouts[4]);
        this.mSymbolsKeyboardShifted.enableShiftLock();
        this.mSymbolsKeyboardShifted.setShifted(true);
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$setKeyboardMode(int mode) {
        switch (mode) {
            case 0: {
                this.mKeyboardView.setKeyboard(this.mQwertyKeyboard);
                this.mKeyboardState = 0;
                boolean visiblePassword = Settings.System.getInt(this.mContext.getContentResolver(), "show_password", 1) != 0;
                boolean enablePreview = false;
                if (visiblePassword) {
                    // empty if block
                }
                this.mKeyboardView.setPreviewEnabled(false);
                break;
            }
            case 1: {
                this.mKeyboardView.setKeyboard(this.mNumericKeyboard);
                this.mKeyboardState = 0;
                this.mKeyboardView.setPreviewEnabled(false);
            }
        }
        this.mKeyboardMode = mode;
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$sendKeyEventsToTarget(int character) {
        ViewRootImpl viewRootImpl = this.mTargetView.getViewRootImpl();
        KeyEvent[] events = KeyCharacterMap.load(-1).getEvents(new char[]{(char)character});
        if (events != null) {
            for (KeyEvent event : events) {
                event = KeyEvent.changeFlags(event, event.getFlags() | 2 | 4);
                viewRootImpl.dispatchInputEvent(event);
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$sendDownUpKeyEvents(int keyEventCode) {
        long eventTime = SystemClock.uptimeMillis();
        ViewRootImpl viewRootImpl = this.mTargetView.getViewRootImpl();
        viewRootImpl.dispatchKeyFromIme(new KeyEvent(eventTime, eventTime, 0, keyEventCode, 0, 0, -1, 0, 6));
        viewRootImpl.dispatchKeyFromIme(new KeyEvent(eventTime, eventTime, 1, keyEventCode, 0, 0, -1, 0, 6));
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$onKey(int primaryCode, int[] keyCodes) {
        if (primaryCode == -5) {
            this.handleBackspace();
        } else if (primaryCode == -1) {
            this.handleShift();
        } else {
            if (primaryCode == -3) {
                this.handleClose();
                return;
            }
            if (primaryCode == -2 && this.mKeyboardView != null) {
                this.handleModeChange();
            } else {
                this.handleCharacter(primaryCode, keyCodes);
                if (this.mKeyboardState == 1) {
                    this.mKeyboardState = 2;
                    this.handleShift();
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$setVibratePattern(int id2) {
        int[] tmpArray;
        block4: {
            tmpArray = null;
            try {
                tmpArray = this.mContext.getResources().getIntArray(id2);
            }
            catch (Resources.NotFoundException e) {
                if (id2 == 0) break block4;
                Log.e("PasswordEntryKeyboardHelper", "Vibrate pattern missing", e);
            }
        }
        if (tmpArray == null) {
            this.mVibratePattern = null;
            return;
        }
        this.mVibratePattern = new long[tmpArray.length];
        for (int i = 0; i < tmpArray.length; ++i) {
            this.mVibratePattern[i] = tmpArray[i];
        }
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$handleModeChange() {
        Keyboard current = this.mKeyboardView.getKeyboard();
        PasswordEntryKeyboard next = null;
        if (current == this.mQwertyKeyboard || current == this.mQwertyKeyboardShifted) {
            next = this.mSymbolsKeyboard;
        } else if (current == this.mSymbolsKeyboard || current == this.mSymbolsKeyboardShifted) {
            next = this.mQwertyKeyboard;
        }
        if (next != null) {
            this.mKeyboardView.setKeyboard(next);
            this.mKeyboardState = 0;
        }
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$handleBackspace() {
        this.sendDownUpKeyEvents(67);
        this.performHapticFeedback();
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$handleShift() {
        boolean isAlphaMode;
        if (this.mKeyboardView == null) {
            return;
        }
        Keyboard current = this.mKeyboardView.getKeyboard();
        PasswordEntryKeyboard next = null;
        boolean bl = isAlphaMode = current == this.mQwertyKeyboard || current == this.mQwertyKeyboardShifted;
        if (this.mKeyboardState == 0) {
            this.mKeyboardState = isAlphaMode ? 1 : 2;
            next = isAlphaMode ? this.mQwertyKeyboardShifted : this.mSymbolsKeyboardShifted;
        } else if (this.mKeyboardState == 1) {
            this.mKeyboardState = 2;
            next = isAlphaMode ? this.mQwertyKeyboardShifted : this.mSymbolsKeyboardShifted;
        } else if (this.mKeyboardState == 2) {
            this.mKeyboardState = 0;
            PasswordEntryKeyboard passwordEntryKeyboard = next = isAlphaMode ? this.mQwertyKeyboard : this.mSymbolsKeyboard;
        }
        if (next != null) {
            if (next != current) {
                this.mKeyboardView.setKeyboard(next);
            }
            next.setShiftLocked(this.mKeyboardState == 2);
            this.mKeyboardView.setShifted(this.mKeyboardState != 0);
        }
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$handleCharacter(int primaryCode, int[] keyCodes) {
        if (this.mKeyboardView.isShifted() && primaryCode != 32 && primaryCode != 10) {
            primaryCode = Character.toUpperCase(primaryCode);
        }
        this.sendKeyEventsToTarget(primaryCode);
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$handleClose() {
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$onPress(int primaryCode) {
        this.performHapticFeedback();
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$performHapticFeedback() {
        if (this.mEnableHaptics) {
            this.mKeyboardView.performHapticFeedback(1, 3);
        }
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$onRelease(int primaryCode) {
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$onText(CharSequence text) {
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$swipeDown() {
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$swipeLeft() {
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$swipeRight() {
    }

    private final void $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$swipeUp() {
    }

    private void __constructor__(Context context, KeyboardView keyboardView, View view) {
        this.$$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$__constructor__(context, keyboardView, view);
    }

    public PasswordEntryKeyboardHelper(Context context, KeyboardView keyboardView, View view) {
        this(context, keyboardView, view, true, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$__constructor__(android.content.Context android.inputmethodservice.KeyboardView android.view.View ), 0, this, context, keyboardView, view);
    }

    private void __constructor__(Context context, KeyboardView keyboardView, View view, boolean bl) {
        this.$$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$__constructor__(context, keyboardView, view, bl);
    }

    public PasswordEntryKeyboardHelper(Context context, KeyboardView keyboardView, View view, boolean bl) {
        this(context, keyboardView, view, bl, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$__constructor__(android.content.Context android.inputmethodservice.KeyboardView android.view.View boolean ), 0, this, context, keyboardView, view, bl);
    }

    private void __constructor__(Context context, KeyboardView keyboardView, View view, boolean bl, int[] nArray) {
        this.$$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$__constructor__(context, keyboardView, view, bl, nArray);
    }

    public PasswordEntryKeyboardHelper(Context context, KeyboardView keyboardView, View view, boolean bl, int[] nArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$__constructor__(android.content.Context android.inputmethodservice.KeyboardView android.view.View boolean int[] ), 0, this, context, keyboardView, view, bl, nArray);
    }

    public void createKeyboards() {
        InvokeDynamicSupport.bootstrap("createKeyboards", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$createKeyboards(), 0, this);
    }

    public void setEnableHaptics(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnableHaptics", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$setEnableHaptics(boolean ), 0, this, bl);
    }

    public boolean isAlpha() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAlpha", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$isAlpha(), 0, this);
    }

    private void createKeyboardsWithSpecificSize(int n, int n2) {
        InvokeDynamicSupport.bootstrap("createKeyboardsWithSpecificSize", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$createKeyboardsWithSpecificSize(int int ), 0, this, n, n2);
    }

    private void createKeyboardsWithDefaultWidth() {
        InvokeDynamicSupport.bootstrap("createKeyboardsWithDefaultWidth", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$createKeyboardsWithDefaultWidth(), 0, this);
    }

    public void setKeyboardMode(int n) {
        InvokeDynamicSupport.bootstrap("setKeyboardMode", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$setKeyboardMode(int ), 0, this, n);
    }

    private void sendKeyEventsToTarget(int n) {
        InvokeDynamicSupport.bootstrap("sendKeyEventsToTarget", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$sendKeyEventsToTarget(int ), 0, this, n);
    }

    public void sendDownUpKeyEvents(int n) {
        InvokeDynamicSupport.bootstrap("sendDownUpKeyEvents", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$sendDownUpKeyEvents(int ), 0, this, n);
    }

    @Override
    public void onKey(int n, int[] nArray) {
        InvokeDynamicSupport.bootstrap("onKey", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$onKey(int int[] ), 0, this, n, nArray);
    }

    public void setVibratePattern(int n) {
        InvokeDynamicSupport.bootstrap("setVibratePattern", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$setVibratePattern(int ), 0, this, n);
    }

    private void handleModeChange() {
        InvokeDynamicSupport.bootstrap("handleModeChange", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$handleModeChange(), 0, this);
    }

    public void handleBackspace() {
        InvokeDynamicSupport.bootstrap("handleBackspace", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$handleBackspace(), 0, this);
    }

    private void handleShift() {
        InvokeDynamicSupport.bootstrap("handleShift", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$handleShift(), 0, this);
    }

    private void handleCharacter(int n, int[] nArray) {
        InvokeDynamicSupport.bootstrap("handleCharacter", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$handleCharacter(int int[] ), 0, this, n, nArray);
    }

    private void handleClose() {
        InvokeDynamicSupport.bootstrap("handleClose", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$handleClose(), 0, this);
    }

    @Override
    public void onPress(int n) {
        InvokeDynamicSupport.bootstrap("onPress", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$onPress(int ), 0, this, n);
    }

    private void performHapticFeedback() {
        InvokeDynamicSupport.bootstrap("performHapticFeedback", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$performHapticFeedback(), 0, this);
    }

    @Override
    public void onRelease(int n) {
        InvokeDynamicSupport.bootstrap("onRelease", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$onRelease(int ), 0, this, n);
    }

    @Override
    public void onText(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("onText", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$onText(java.lang.CharSequence ), 0, this, charSequence);
    }

    @Override
    public void swipeDown() {
        InvokeDynamicSupport.bootstrap("swipeDown", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$swipeDown(), 0, this);
    }

    @Override
    public void swipeLeft() {
        InvokeDynamicSupport.bootstrap("swipeLeft", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$swipeLeft(), 0, this);
    }

    @Override
    public void swipeRight() {
        InvokeDynamicSupport.bootstrap("swipeRight", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$swipeRight(), 0, this);
    }

    @Override
    public void swipeUp() {
        InvokeDynamicSupport.bootstrap("swipeUp", $$robo$$com_android_internal_widget_PasswordEntryKeyboardHelper$swipeUp(), 0, this);
    }

    public /* synthetic */ PasswordEntryKeyboardHelper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PasswordEntryKeyboardHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

