/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AnimationUtils;
import android.widget.AbsListView;
import android.widget.OverScroller;
import android.widget.ScrollView;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ResolverDrawerLayout
extends ViewGroup
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ResolverDrawerLayout";
    private int mMaxWidth;
    private int mMaxCollapsedHeight;
    private int mMaxCollapsedHeightSmall;
    private boolean mSmallCollapsed;
    private float mCollapseOffset;
    private int mCollapsibleHeight;
    private int mUncollapsibleHeight;
    private int mCollapsibleHeightReserved;
    private int mTopOffset;
    private boolean mIsDragging;
    private boolean mOpenOnClick;
    private boolean mOpenOnLayout;
    private boolean mDismissOnScrollerFinished;
    private int mTouchSlop;
    private float mMinFlingVelocity;
    private OverScroller mScroller;
    private VelocityTracker mVelocityTracker;
    private Drawable mScrollIndicatorDrawable;
    private OnDismissedListener mOnDismissedListener;
    private RunOnDismissedListener mRunOnDismissedListener;
    private float mInitialTouchX;
    private float mInitialTouchY;
    private float mLastTouchY;
    private int mActivePointerId;
    private Rect mTempRect;
    private ViewTreeObserver.OnTouchModeChangeListener mTouchModeChangeListener;

    private void $$robo$$com_android_internal_widget_ResolverDrawerLayout$__constructor__(Context context) {
    }

    private void $$robo$$com_android_internal_widget_ResolverDrawerLayout$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$com_android_internal_widget_ResolverDrawerLayout$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mActivePointerId = -1;
        this.mTempRect = new Rect();
        this.mTouchModeChangeListener = new ViewTreeObserver.OnTouchModeChangeListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ResolverDrawerLayout this$0;

            private void $$robo$$com_android_internal_widget_ResolverDrawerLayout_1$__constructor__(ResolverDrawerLayout this$0) {
            }

            private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout_1$onTouchModeChanged(boolean isInTouchMode) {
                if (!isInTouchMode && this.this$0.hasFocus() && this.this$0.isDescendantClipped(this.this$0.getFocusedChild())) {
                    this.this$0.smoothScrollTo(0, 0.0f);
                }
            }

            private void __constructor__(ResolverDrawerLayout resolverDrawerLayout) {
                this.$$robo$$com_android_internal_widget_ResolverDrawerLayout_1$__constructor__(resolverDrawerLayout);
            }
            {
                this.this$0 = resolverDrawerLayout;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ResolverDrawerLayout_1$__constructor__(com.android.internal.widget.ResolverDrawerLayout ), 0, this, resolverDrawerLayout);
            }

            @Override
            public void onTouchModeChanged(boolean bl) {
                InvokeDynamicSupport.bootstrap("onTouchModeChanged", $$robo$$com_android_internal_widget_ResolverDrawerLayout_1$onTouchModeChanged(boolean ), 0, this, bl);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ResolverDrawerLayout, defStyleAttr, 0);
        this.mMaxWidth = a.getDimensionPixelSize(0, -1);
        this.mMaxCollapsedHeight = a.getDimensionPixelSize(1, 0);
        this.mMaxCollapsedHeightSmall = a.getDimensionPixelSize(2, this.mMaxCollapsedHeight);
        a.recycle();
        this.mScrollIndicatorDrawable = this.mContext.getDrawable(17303107);
        this.mScroller = new OverScroller(context, AnimationUtils.loadInterpolator(context, 17563653));
        this.mVelocityTracker = VelocityTracker.obtain();
        ViewConfiguration vc = ViewConfiguration.get(context);
        this.mTouchSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity();
        this.setImportantForAccessibility(1);
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$setSmallCollapsed(boolean smallCollapsed) {
        this.mSmallCollapsed = smallCollapsed;
        this.requestLayout();
    }

    private final boolean $$robo$$com_android_internal_widget_ResolverDrawerLayout$isSmallCollapsed() {
        return this.mSmallCollapsed;
    }

    private final boolean $$robo$$com_android_internal_widget_ResolverDrawerLayout$isCollapsed() {
        return this.mCollapseOffset > 0.0f;
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$setCollapsed(boolean collapsed) {
        if (!this.isLaidOut()) {
            this.mOpenOnLayout = collapsed;
        } else {
            this.smoothScrollTo(collapsed ? this.mCollapsibleHeight : 0, 0.0f);
        }
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$setCollapsibleHeightReserved(int heightPixels) {
        int oldReserved = this.mCollapsibleHeightReserved;
        this.mCollapsibleHeightReserved = heightPixels;
        int dReserved = this.mCollapsibleHeightReserved - oldReserved;
        if (dReserved != 0 && this.mIsDragging) {
            this.mLastTouchY -= (float)dReserved;
        }
        int oldCollapsibleHeight = this.mCollapsibleHeight;
        this.mCollapsibleHeight = Math.max(this.mCollapsibleHeight, this.getMaxCollapsedHeight());
        if (this.updateCollapseOffset(oldCollapsibleHeight, !this.isDragging())) {
            return;
        }
        this.invalidate();
    }

    private final boolean $$robo$$com_android_internal_widget_ResolverDrawerLayout$isMoving() {
        return this.mIsDragging || !this.mScroller.isFinished();
    }

    private final boolean $$robo$$com_android_internal_widget_ResolverDrawerLayout$isDragging() {
        return this.mIsDragging || this.getNestedScrollAxes() == 2;
    }

    private final boolean $$robo$$com_android_internal_widget_ResolverDrawerLayout$updateCollapseOffset(int oldCollapsibleHeight, boolean remainClosed) {
        if (oldCollapsibleHeight == this.mCollapsibleHeight) {
            return false;
        }
        if (this.isLaidOut()) {
            boolean isCollapsedNew;
            boolean isCollapsedOld = this.mCollapseOffset != 0.0f;
            this.mCollapseOffset = remainClosed && oldCollapsibleHeight < this.mCollapsibleHeight && this.mCollapseOffset == (float)oldCollapsibleHeight ? (float)this.mCollapsibleHeight : Math.min(this.mCollapseOffset, (float)this.mCollapsibleHeight);
            boolean bl = isCollapsedNew = this.mCollapseOffset != 0.0f;
            if (isCollapsedOld != isCollapsedNew) {
                this.onCollapsedChanged(isCollapsedNew);
            }
        } else {
            this.mCollapseOffset = this.mOpenOnLayout ? 0.0f : (float)this.mCollapsibleHeight;
        }
        return true;
    }

    private final int $$robo$$com_android_internal_widget_ResolverDrawerLayout$getMaxCollapsedHeight() {
        return (this.isSmallCollapsed() ? this.mMaxCollapsedHeightSmall : this.mMaxCollapsedHeight) + this.mCollapsibleHeightReserved;
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$setOnDismissedListener(OnDismissedListener listener) {
        this.mOnDismissedListener = listener;
    }

    private final boolean $$robo$$com_android_internal_widget_ResolverDrawerLayout$onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getActionMasked();
        if (action == 0) {
            this.mVelocityTracker.clear();
        }
        this.mVelocityTracker.addMovement(ev);
        switch (action) {
            case 0: {
                float x = ev.getX();
                float y = ev.getY();
                this.mInitialTouchX = x;
                this.mInitialTouchY = this.mLastTouchY = y;
                this.mOpenOnClick = this.isListChildUnderClipped(x, y) && this.mCollapsibleHeight > 0;
                break;
            }
            case 2: {
                float x = ev.getX();
                float y = ev.getY();
                float dy = y - this.mInitialTouchY;
                if (!(Math.abs(dy) > (float)this.mTouchSlop) || this.findChildUnder(x, y) == null || (this.getNestedScrollAxes() & 2) != 0) break;
                this.mActivePointerId = ev.getPointerId(0);
                this.mIsDragging = true;
                this.mLastTouchY = Math.max(this.mLastTouchY - (float)this.mTouchSlop, Math.min(this.mLastTouchY + dy, this.mLastTouchY + (float)this.mTouchSlop));
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                this.resetTouch();
            }
        }
        if (this.mIsDragging) {
            this.abortAnimation();
        }
        return this.mIsDragging || this.mOpenOnClick;
    }

    private final boolean $$robo$$com_android_internal_widget_ResolverDrawerLayout$onTouchEvent(MotionEvent ev) {
        int action = ev.getActionMasked();
        this.mVelocityTracker.addMovement(ev);
        boolean handled = false;
        switch (action) {
            case 0: {
                float x = ev.getX();
                float y = ev.getY();
                this.mInitialTouchX = x;
                this.mInitialTouchY = this.mLastTouchY = y;
                this.mActivePointerId = ev.getPointerId(0);
                boolean hitView = this.findChildUnder(this.mInitialTouchX, this.mInitialTouchY) != null;
                handled = this.mOnDismissedListener != null || this.mCollapsibleHeight > 0;
                this.mIsDragging = hitView && handled;
                this.abortAnimation();
                break;
            }
            case 2: {
                float dy;
                int index = ev.findPointerIndex(this.mActivePointerId);
                if (index < 0) {
                    Log.e("ResolverDrawerLayout", "Bad pointer id " + this.mActivePointerId + ", resetting");
                    index = 0;
                    this.mActivePointerId = ev.getPointerId(0);
                    this.mInitialTouchX = ev.getX();
                    this.mInitialTouchY = this.mLastTouchY = ev.getY();
                }
                float x = ev.getX(index);
                float y = ev.getY(index);
                if (!this.mIsDragging && Math.abs(dy = y - this.mInitialTouchY) > (float)this.mTouchSlop && this.findChildUnder(x, y) != null) {
                    this.mIsDragging = true;
                    handled = true;
                    this.mLastTouchY = Math.max(this.mLastTouchY - (float)this.mTouchSlop, Math.min(this.mLastTouchY + dy, this.mLastTouchY + (float)this.mTouchSlop));
                }
                if (this.mIsDragging) {
                    dy = y - this.mLastTouchY;
                    this.performDrag(dy);
                }
                this.mLastTouchY = y;
                break;
            }
            case 5: {
                int pointerId;
                int pointerIndex = ev.getActionIndex();
                this.mActivePointerId = pointerId = ev.getPointerId(pointerIndex);
                this.mInitialTouchX = ev.getX(pointerIndex);
                this.mInitialTouchY = this.mLastTouchY = ev.getY(pointerIndex);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: {
                boolean wasDragging = this.mIsDragging;
                this.mIsDragging = false;
                if (!wasDragging && this.findChildUnder(this.mInitialTouchX, this.mInitialTouchY) == null && this.findChildUnder(ev.getX(), ev.getY()) == null && this.mOnDismissedListener != null) {
                    this.dispatchOnDismissed();
                    this.resetTouch();
                    return true;
                }
                if (this.mOpenOnClick && Math.abs(ev.getX() - this.mInitialTouchX) < (float)this.mTouchSlop && Math.abs(ev.getY() - this.mInitialTouchY) < (float)this.mTouchSlop) {
                    this.smoothScrollTo(0, 0.0f);
                    return true;
                }
                this.mVelocityTracker.computeCurrentVelocity(1000);
                float yvel = this.mVelocityTracker.getYVelocity(this.mActivePointerId);
                if (Math.abs(yvel) > this.mMinFlingVelocity) {
                    if (this.mOnDismissedListener != null && yvel > 0.0f && this.mCollapseOffset > (float)this.mCollapsibleHeight) {
                        this.smoothScrollTo(this.mCollapsibleHeight + this.mUncollapsibleHeight, yvel);
                        this.mDismissOnScrollerFinished = true;
                    } else {
                        this.smoothScrollTo(yvel < 0.0f ? 0 : this.mCollapsibleHeight, yvel);
                    }
                } else {
                    this.smoothScrollTo(this.mCollapseOffset < (float)(this.mCollapsibleHeight / 2) ? 0 : this.mCollapsibleHeight, 0.0f);
                }
                this.resetTouch();
                break;
            }
            case 3: {
                if (this.mIsDragging) {
                    this.smoothScrollTo(this.mCollapseOffset < (float)(this.mCollapsibleHeight / 2) ? 0 : this.mCollapsibleHeight, 0.0f);
                }
                this.resetTouch();
                return true;
            }
        }
        return handled;
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = ev.getActionIndex();
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mInitialTouchX = ev.getX(newPointerIndex);
            this.mInitialTouchY = this.mLastTouchY = ev.getY(newPointerIndex);
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
        }
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$resetTouch() {
        this.mActivePointerId = -1;
        this.mIsDragging = false;
        this.mOpenOnClick = false;
        this.mLastTouchY = 0.0f;
        this.mInitialTouchY = 0.0f;
        this.mInitialTouchX = 0.0f;
        this.mVelocityTracker.clear();
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$computeScroll() {
        super.computeScroll();
        if (this.mScroller.computeScrollOffset()) {
            boolean keepGoing = !this.mScroller.isFinished();
            this.performDrag((float)this.mScroller.getCurrY() - this.mCollapseOffset);
            if (keepGoing) {
                this.postInvalidateOnAnimation();
            } else if (this.mDismissOnScrollerFinished && this.mOnDismissedListener != null) {
                this.mRunOnDismissedListener = new RunOnDismissedListener(this);
                this.post(this.mRunOnDismissedListener);
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$abortAnimation() {
        this.mScroller.abortAnimation();
        this.mRunOnDismissedListener = null;
        this.mDismissOnScrollerFinished = false;
    }

    private final float $$robo$$com_android_internal_widget_ResolverDrawerLayout$performDrag(float dy) {
        float newPos = Math.max(0.0f, Math.min(this.mCollapseOffset + dy, (float)(this.mCollapsibleHeight + this.mUncollapsibleHeight)));
        if (newPos != this.mCollapseOffset) {
            boolean isCollapsedNew;
            dy = newPos - this.mCollapseOffset;
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp.ignoreOffset) continue;
                child.offsetTopAndBottom((int)dy);
            }
            boolean isCollapsedOld = this.mCollapseOffset != 0.0f;
            this.mCollapseOffset = newPos;
            this.mTopOffset = (int)((float)this.mTopOffset + dy);
            boolean bl = isCollapsedNew = newPos != 0.0f;
            if (isCollapsedOld != isCollapsedNew) {
                this.onCollapsedChanged(isCollapsedNew);
            }
            this.postInvalidateOnAnimation();
            return dy;
        }
        return 0.0f;
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$onCollapsedChanged(boolean isCollapsed) {
        this.notifyViewAccessibilityStateChangedIfNeeded(0);
        if (this.mScrollIndicatorDrawable != null) {
            this.setWillNotDraw(!isCollapsed);
        }
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$dispatchOnDismissed() {
        if (this.mOnDismissedListener != null) {
            this.mOnDismissedListener.onDismissed();
        }
        if (this.mRunOnDismissedListener != null) {
            this.removeCallbacks(this.mRunOnDismissedListener);
            this.mRunOnDismissedListener = null;
        }
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$smoothScrollTo(int yOffset, float velocity) {
        this.abortAnimation();
        int sy = (int)this.mCollapseOffset;
        int dy = yOffset - sy;
        if (dy == 0) {
            return;
        }
        int height = this.getHeight();
        int halfHeight = height / 2;
        float distanceRatio = Math.min(1.0f, 1.0f * (float)Math.abs(dy) / (float)height);
        float distance = (float)halfHeight + (float)halfHeight * this.distanceInfluenceForSnapDuration(distanceRatio);
        int duration = 0;
        if ((velocity = Math.abs(velocity)) > 0.0f) {
            duration = 4 * Math.round(1000.0f * Math.abs(distance / velocity));
        } else {
            float pageDelta = (float)Math.abs(dy) / (float)height;
            duration = (int)((pageDelta + 1.0f) * 100.0f);
        }
        duration = Math.min(duration, 300);
        this.mScroller.startScroll(0, sy, 0, dy, duration);
        this.postInvalidateOnAnimation();
    }

    private final float $$robo$$com_android_internal_widget_ResolverDrawerLayout$distanceInfluenceForSnapDuration(float f) {
        f -= 0.5f;
        f = (float)((double)f * 0.4712389167638204);
        return (float)Math.sin(f);
    }

    private final View $$robo$$com_android_internal_widget_ResolverDrawerLayout$findChildUnder(float x, float y) {
        return ResolverDrawerLayout.findChildUnder(this, x, y);
    }

    private static final View $$robo$$com_android_internal_widget_ResolverDrawerLayout$findChildUnder(ViewGroup parent, float x, float y) {
        int childCount = parent.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            View child = parent.getChildAt(i);
            if (!ResolverDrawerLayout.isChildUnder(child, x, y)) continue;
            return child;
        }
        return null;
    }

    private final View $$robo$$com_android_internal_widget_ResolverDrawerLayout$findListChildUnder(float x, float y) {
        View v = this.findChildUnder(x, y);
        while (v != null) {
            x -= v.getX();
            y -= v.getY();
            if (v instanceof AbsListView) {
                return ResolverDrawerLayout.findChildUnder((ViewGroup)v, x, y);
            }
            v = v instanceof ViewGroup ? ResolverDrawerLayout.findChildUnder((ViewGroup)v, x, y) : null;
        }
        return v;
    }

    private final boolean $$robo$$com_android_internal_widget_ResolverDrawerLayout$isListChildUnderClipped(float x, float y) {
        View listChild = this.findListChildUnder(x, y);
        return listChild != null && this.isDescendantClipped(listChild);
    }

    private final boolean $$robo$$com_android_internal_widget_ResolverDrawerLayout$isDescendantClipped(View child) {
        View directChild;
        this.mTempRect.set(0, 0, child.getWidth(), child.getHeight());
        this.offsetDescendantRectToMyCoords(child, this.mTempRect);
        if (child.getParent() == this) {
            directChild = child;
        } else {
            View v = child;
            ViewParent p = child.getParent();
            while (p != this) {
                v = (View)((Object)p);
                p = v.getParent();
            }
            directChild = v;
        }
        int clipEdge = this.getHeight() - this.getPaddingBottom();
        int childCount = this.getChildCount();
        for (int i = this.indexOfChild(directChild) + 1; i < childCount; ++i) {
            View nextChild = this.getChildAt(i);
            if (nextChild.getVisibility() == 8) continue;
            clipEdge = Math.min(clipEdge, nextChild.getTop());
        }
        return this.mTempRect.bottom > clipEdge;
    }

    private static final boolean $$robo$$com_android_internal_widget_ResolverDrawerLayout$isChildUnder(View child, float x, float y) {
        float left = child.getX();
        float top = child.getY();
        float right = left + (float)child.getWidth();
        float bottom = top + (float)child.getHeight();
        return x >= left && y >= top && x < right && y < bottom;
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$requestChildFocus(View child, View focused) {
        super.requestChildFocus(child, focused);
        if (!this.isInTouchMode() && this.isDescendantClipped(focused)) {
            this.smoothScrollTo(0, 0.0f);
        }
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnTouchModeChangeListener(this.mTouchModeChangeListener);
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.getViewTreeObserver().removeOnTouchModeChangeListener(this.mTouchModeChangeListener);
        this.abortAnimation();
    }

    private final boolean $$robo$$com_android_internal_widget_ResolverDrawerLayout$onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return (nestedScrollAxes & 2) != 0;
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$onNestedScrollAccepted(View child, View target, int axes) {
        super.onNestedScrollAccepted(child, target, axes);
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$onStopNestedScroll(View child) {
        super.onStopNestedScroll(child);
        if (this.mScroller.isFinished()) {
            this.smoothScrollTo(this.mCollapseOffset < (float)(this.mCollapsibleHeight / 2) ? 0 : this.mCollapsibleHeight, 0.0f);
        }
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        if (dyUnconsumed < 0) {
            this.performDrag(-dyUnconsumed);
        }
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        if (dy > 0) {
            consumed[1] = (int)(-this.performDrag(-dy));
        }
    }

    private final boolean $$robo$$com_android_internal_widget_ResolverDrawerLayout$onNestedPreFling(View target, float velocityX, float velocityY) {
        if (velocityY > this.mMinFlingVelocity && this.mCollapseOffset != 0.0f) {
            this.smoothScrollTo(0, velocityY);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_widget_ResolverDrawerLayout$onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        if (!consumed && Math.abs(velocityY) > this.mMinFlingVelocity) {
            if (this.mOnDismissedListener != null && velocityY < 0.0f && this.mCollapseOffset > (float)this.mCollapsibleHeight) {
                this.smoothScrollTo(this.mCollapsibleHeight + this.mUncollapsibleHeight, velocityY);
                this.mDismissOnScrollerFinished = true;
            } else {
                this.smoothScrollTo(velocityY > 0.0f ? 0 : this.mCollapsibleHeight, velocityY);
            }
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_widget_ResolverDrawerLayout$onNestedPrePerformAccessibilityAction(View target, int action, Bundle args) {
        if (super.onNestedPrePerformAccessibilityAction(target, action, args)) {
            return true;
        }
        if (action == 4096 && this.mCollapseOffset != 0.0f) {
            this.smoothScrollTo(0, 0.0f);
            return true;
        }
        return false;
    }

    private final CharSequence $$robo$$com_android_internal_widget_ResolverDrawerLayout$getAccessibilityClassName() {
        return ScrollView.class.getName();
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        if (this.isEnabled() && this.mCollapseOffset != 0.0f) {
            info.addAction(4096);
            info.setScrollable(true);
        }
        info.removeAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_ACCESSIBILITY_FOCUS);
    }

    private final boolean $$robo$$com_android_internal_widget_ResolverDrawerLayout$performAccessibilityActionInternal(int action, Bundle arguments) {
        if (action == AccessibilityNodeInfo.AccessibilityAction.ACTION_ACCESSIBILITY_FOCUS.getId()) {
            return false;
        }
        if (super.performAccessibilityActionInternal(action, arguments)) {
            return true;
        }
        if (action == 4096 && this.mCollapseOffset != 0.0f) {
            this.smoothScrollTo(0, 0.0f);
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$onDrawForeground(Canvas canvas) {
        if (this.mScrollIndicatorDrawable != null) {
            this.mScrollIndicatorDrawable.draw(canvas);
        }
        super.onDrawForeground(canvas);
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int sourceWidth;
        int widthSize = sourceWidth = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        if (this.mMaxWidth >= 0) {
            widthSize = Math.min(widthSize, this.mMaxWidth);
        }
        int widthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, 0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec(heightSize, 0x40000000);
        int widthPadding = this.getPaddingLeft() + this.getPaddingRight();
        int heightUsed = this.getPaddingTop() + this.getPaddingBottom();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (!lp.alwaysShow || child.getVisibility() == 8) continue;
            this.measureChildWithMargins(child, widthSpec, widthPadding, heightSpec, heightUsed);
            heightUsed += this.getHeightUsed(child);
        }
        int alwaysShowHeight = heightUsed;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.alwaysShow || child.getVisibility() == 8) continue;
            this.measureChildWithMargins(child, widthSpec, widthPadding, heightSpec, heightUsed);
            heightUsed += this.getHeightUsed(child);
        }
        int oldCollapsibleHeight = this.mCollapsibleHeight;
        this.mCollapsibleHeight = Math.max(0, heightUsed - alwaysShowHeight - this.getMaxCollapsedHeight());
        this.mUncollapsibleHeight = heightUsed - this.mCollapsibleHeight;
        this.updateCollapseOffset(oldCollapsibleHeight, !this.isDragging());
        this.mTopOffset = Math.max(0, heightSize - heightUsed) + (int)this.mCollapseOffset;
        this.setMeasuredDimension(sourceWidth, heightSize);
    }

    private final int $$robo$$com_android_internal_widget_ResolverDrawerLayout$getHeightUsed(View child) {
        int heightUsed = child.getMeasuredHeight();
        if (child instanceof AbsListView) {
            AbsListView lv = (AbsListView)child;
            int lvPaddingBottom = lv.getPaddingBottom();
            int lowest = 0;
            int N = lv.getChildCount();
            for (int i = 0; i < N; ++i) {
                int bottom = lv.getChildAt(i).getBottom() + lvPaddingBottom;
                if (bottom <= lowest) continue;
                lowest = bottom;
            }
            if (lowest < heightUsed) {
                heightUsed = lowest;
            }
        }
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        return lp.topMargin + heightUsed + lp.bottomMargin;
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$onLayout(boolean changed, int l, int t, int r, int b) {
        int top;
        int width = this.getWidth();
        View indicatorHost = null;
        int ypos = this.mTopOffset;
        int leftEdge = this.getPaddingLeft();
        int rightEdge = width - this.getPaddingRight();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.hasNestedScrollIndicator) {
                indicatorHost = child;
            }
            if (child.getVisibility() == 8) continue;
            top = ypos + lp.topMargin;
            if (lp.ignoreOffset) {
                top = (int)((float)top - this.mCollapseOffset);
            }
            int bottom = top + child.getMeasuredHeight();
            int childWidth = child.getMeasuredWidth();
            int widthAvailable = rightEdge - leftEdge;
            int left = leftEdge + (widthAvailable - childWidth) / 2;
            int right = left + childWidth;
            child.layout(left, top, right, bottom);
            ypos = bottom + lp.bottomMargin;
        }
        if (this.mScrollIndicatorDrawable != null) {
            if (indicatorHost != null) {
                int left = indicatorHost.getLeft();
                int right = indicatorHost.getRight();
                int bottom = indicatorHost.getTop();
                top = bottom - this.mScrollIndicatorDrawable.getIntrinsicHeight();
                this.mScrollIndicatorDrawable.setBounds(left, top, right, bottom);
                this.setWillNotDraw(!this.isCollapsed());
            } else {
                this.mScrollIndicatorDrawable = null;
                this.setWillNotDraw(true);
            }
        }
    }

    private final ViewGroup.LayoutParams $$robo$$com_android_internal_widget_ResolverDrawerLayout$generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    private final ViewGroup.LayoutParams $$robo$$com_android_internal_widget_ResolverDrawerLayout$generateLayoutParams(ViewGroup.LayoutParams p) {
        if (p instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)p);
        }
        if (p instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)p);
        }
        return new LayoutParams(p);
    }

    private final ViewGroup.LayoutParams $$robo$$com_android_internal_widget_ResolverDrawerLayout$generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2);
    }

    private final Parcelable $$robo$$com_android_internal_widget_ResolverDrawerLayout$onSaveInstanceState() {
        SavedState ss = new SavedState(super.onSaveInstanceState());
        ss.open = this.mCollapsibleHeight > 0 && this.mCollapseOffset == 0.0f;
        return ss;
    }

    private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout$onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mOpenOnLayout = ss.open;
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_ResolverDrawerLayout$__constructor__(context);
    }

    public ResolverDrawerLayout(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ResolverDrawerLayout$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_ResolverDrawerLayout$__constructor__(context, attributeSet);
    }

    public ResolverDrawerLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ResolverDrawerLayout$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$com_android_internal_widget_ResolverDrawerLayout$__constructor__(context, attributeSet, n);
    }

    public ResolverDrawerLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ResolverDrawerLayout$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    public void setSmallCollapsed(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSmallCollapsed", $$robo$$com_android_internal_widget_ResolverDrawerLayout$setSmallCollapsed(boolean ), 0, this, bl);
    }

    public boolean isSmallCollapsed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSmallCollapsed", $$robo$$com_android_internal_widget_ResolverDrawerLayout$isSmallCollapsed(), 0, this);
    }

    public boolean isCollapsed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCollapsed", $$robo$$com_android_internal_widget_ResolverDrawerLayout$isCollapsed(), 0, this);
    }

    public void setCollapsed(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCollapsed", $$robo$$com_android_internal_widget_ResolverDrawerLayout$setCollapsed(boolean ), 0, this, bl);
    }

    public void setCollapsibleHeightReserved(int n) {
        InvokeDynamicSupport.bootstrap("setCollapsibleHeightReserved", $$robo$$com_android_internal_widget_ResolverDrawerLayout$setCollapsibleHeightReserved(int ), 0, this, n);
    }

    private boolean isMoving() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMoving", $$robo$$com_android_internal_widget_ResolverDrawerLayout$isMoving(), 0, this);
    }

    private boolean isDragging() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDragging", $$robo$$com_android_internal_widget_ResolverDrawerLayout$isDragging(), 0, this);
    }

    private boolean updateCollapseOffset(int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateCollapseOffset", $$robo$$com_android_internal_widget_ResolverDrawerLayout$updateCollapseOffset(int boolean ), 0, this, n, bl);
    }

    private int getMaxCollapsedHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxCollapsedHeight", $$robo$$com_android_internal_widget_ResolverDrawerLayout$getMaxCollapsedHeight(), 0, this);
    }

    public void setOnDismissedListener(OnDismissedListener onDismissedListener) {
        InvokeDynamicSupport.bootstrap("setOnDismissedListener", $$robo$$com_android_internal_widget_ResolverDrawerLayout$setOnDismissedListener(com.android.internal.widget.ResolverDrawerLayout$OnDismissedListener ), 0, this, onDismissedListener);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$com_android_internal_widget_ResolverDrawerLayout$onInterceptTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$com_android_internal_widget_ResolverDrawerLayout$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("onSecondaryPointerUp", $$robo$$com_android_internal_widget_ResolverDrawerLayout$onSecondaryPointerUp(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void resetTouch() {
        InvokeDynamicSupport.bootstrap("resetTouch", $$robo$$com_android_internal_widget_ResolverDrawerLayout$resetTouch(), 0, this);
    }

    @Override
    public void computeScroll() {
        InvokeDynamicSupport.bootstrap("computeScroll", $$robo$$com_android_internal_widget_ResolverDrawerLayout$computeScroll(), 0, this);
    }

    private void abortAnimation() {
        InvokeDynamicSupport.bootstrap("abortAnimation", $$robo$$com_android_internal_widget_ResolverDrawerLayout$abortAnimation(), 0, this);
    }

    private float performDrag(float f) {
        return (float)InvokeDynamicSupport.bootstrap("performDrag", $$robo$$com_android_internal_widget_ResolverDrawerLayout$performDrag(float ), 0, this, f);
    }

    private void onCollapsedChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onCollapsedChanged", $$robo$$com_android_internal_widget_ResolverDrawerLayout$onCollapsedChanged(boolean ), 0, this, bl);
    }

    void dispatchOnDismissed() {
        InvokeDynamicSupport.bootstrap("dispatchOnDismissed", $$robo$$com_android_internal_widget_ResolverDrawerLayout$dispatchOnDismissed(), 0, this);
    }

    private void smoothScrollTo(int n, float f) {
        InvokeDynamicSupport.bootstrap("smoothScrollTo", $$robo$$com_android_internal_widget_ResolverDrawerLayout$smoothScrollTo(int float ), 0, this, n, f);
    }

    private float distanceInfluenceForSnapDuration(float f) {
        return (float)InvokeDynamicSupport.bootstrap("distanceInfluenceForSnapDuration", $$robo$$com_android_internal_widget_ResolverDrawerLayout$distanceInfluenceForSnapDuration(float ), 0, this, f);
    }

    private View findChildUnder(float f, float f2) {
        return InvokeDynamicSupport.bootstrap("findChildUnder", $$robo$$com_android_internal_widget_ResolverDrawerLayout$findChildUnder(float float ), 0, this, f, f2);
    }

    private static View findChildUnder(ViewGroup viewGroup, float f, float f2) {
        return InvokeDynamicSupport.bootstrapStatic("findChildUnder", $$robo$$com_android_internal_widget_ResolverDrawerLayout$findChildUnder(android.view.ViewGroup float float ), 0, (ViewGroup)viewGroup, (float)f, (float)f2);
    }

    private View findListChildUnder(float f, float f2) {
        return InvokeDynamicSupport.bootstrap("findListChildUnder", $$robo$$com_android_internal_widget_ResolverDrawerLayout$findListChildUnder(float float ), 0, this, f, f2);
    }

    private boolean isListChildUnderClipped(float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isListChildUnderClipped", $$robo$$com_android_internal_widget_ResolverDrawerLayout$isListChildUnderClipped(float float ), 0, this, f, f2);
    }

    private boolean isDescendantClipped(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDescendantClipped", $$robo$$com_android_internal_widget_ResolverDrawerLayout$isDescendantClipped(android.view.View ), 0, this, view);
    }

    private static boolean isChildUnder(View view, float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isChildUnder", $$robo$$com_android_internal_widget_ResolverDrawerLayout$isChildUnder(android.view.View float float ), 0, (View)view, (float)f, (float)f2);
    }

    @Override
    public void requestChildFocus(View view, View view2) {
        InvokeDynamicSupport.bootstrap("requestChildFocus", $$robo$$com_android_internal_widget_ResolverDrawerLayout$requestChildFocus(android.view.View android.view.View ), 0, this, view, view2);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$com_android_internal_widget_ResolverDrawerLayout$onAttachedToWindow(), 0, this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$com_android_internal_widget_ResolverDrawerLayout$onDetachedFromWindow(), 0, this);
    }

    @Override
    public boolean onStartNestedScroll(View view, View view2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStartNestedScroll", $$robo$$com_android_internal_widget_ResolverDrawerLayout$onStartNestedScroll(android.view.View android.view.View int ), 0, this, view, view2, n);
    }

    @Override
    public void onNestedScrollAccepted(View view, View view2, int n) {
        InvokeDynamicSupport.bootstrap("onNestedScrollAccepted", $$robo$$com_android_internal_widget_ResolverDrawerLayout$onNestedScrollAccepted(android.view.View android.view.View int ), 0, this, view, view2, n);
    }

    @Override
    public void onStopNestedScroll(View view) {
        InvokeDynamicSupport.bootstrap("onStopNestedScroll", $$robo$$com_android_internal_widget_ResolverDrawerLayout$onStopNestedScroll(android.view.View ), 0, this, view);
    }

    @Override
    public void onNestedScroll(View view, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onNestedScroll", $$robo$$com_android_internal_widget_ResolverDrawerLayout$onNestedScroll(android.view.View int int int int ), 0, this, view, n, n2, n3, n4);
    }

    @Override
    public void onNestedPreScroll(View view, int n, int n2, int[] nArray) {
        InvokeDynamicSupport.bootstrap("onNestedPreScroll", $$robo$$com_android_internal_widget_ResolverDrawerLayout$onNestedPreScroll(android.view.View int int int[] ), 0, this, view, n, n2, nArray);
    }

    @Override
    public boolean onNestedPreFling(View view, float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onNestedPreFling", $$robo$$com_android_internal_widget_ResolverDrawerLayout$onNestedPreFling(android.view.View float float ), 0, this, view, f, f2);
    }

    @Override
    public boolean onNestedFling(View view, float f, float f2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("onNestedFling", $$robo$$com_android_internal_widget_ResolverDrawerLayout$onNestedFling(android.view.View float float boolean ), 0, this, view, f, f2, bl);
    }

    @Override
    public boolean onNestedPrePerformAccessibilityAction(View view, int n, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("onNestedPrePerformAccessibilityAction", $$robo$$com_android_internal_widget_ResolverDrawerLayout$onNestedPrePerformAccessibilityAction(android.view.View int android.os.Bundle ), 0, this, view, n, bundle);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$com_android_internal_widget_ResolverDrawerLayout$getAccessibilityClassName(), 0, this);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoInternal", $$robo$$com_android_internal_widget_ResolverDrawerLayout$onInitializeAccessibilityNodeInfoInternal(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    @Override
    public boolean performAccessibilityActionInternal(int n, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performAccessibilityActionInternal", $$robo$$com_android_internal_widget_ResolverDrawerLayout$performAccessibilityActionInternal(int android.os.Bundle ), 0, this, n, bundle);
    }

    @Override
    public void onDrawForeground(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDrawForeground", $$robo$$com_android_internal_widget_ResolverDrawerLayout$onDrawForeground(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_ResolverDrawerLayout$onMeasure(int int ), 0, this, n, n2);
    }

    private int getHeightUsed(View view) {
        return (int)InvokeDynamicSupport.bootstrap("getHeightUsed", $$robo$$com_android_internal_widget_ResolverDrawerLayout$getHeightUsed(android.view.View ), 0, this, view);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$com_android_internal_widget_ResolverDrawerLayout$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @Override
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$com_android_internal_widget_ResolverDrawerLayout$generateLayoutParams(android.util.AttributeSet ), 0, this, attributeSet);
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$com_android_internal_widget_ResolverDrawerLayout$generateLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateDefaultLayoutParams", $$robo$$com_android_internal_widget_ResolverDrawerLayout$generateDefaultLayoutParams(), 0, this);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$com_android_internal_widget_ResolverDrawerLayout$onSaveInstanceState(), 0, this);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$com_android_internal_widget_ResolverDrawerLayout$onRestoreInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    public /* synthetic */ ResolverDrawerLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResolverDrawerLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class RunOnDismissedListener
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ResolverDrawerLayout this$0;

        private void $$robo$$com_android_internal_widget_ResolverDrawerLayout_RunOnDismissedListener$__constructor__(ResolverDrawerLayout resolverDrawerLayout) {
        }

        private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout_RunOnDismissedListener$run() {
            this.this$0.dispatchOnDismissed();
        }

        private /* synthetic */ void $$robo$$com_android_internal_widget_ResolverDrawerLayout_RunOnDismissedListener$__constructor__(ResolverDrawerLayout x0, 1 x1) {
        }

        private void __constructor__(ResolverDrawerLayout resolverDrawerLayout) {
            this.$$robo$$com_android_internal_widget_ResolverDrawerLayout_RunOnDismissedListener$__constructor__(resolverDrawerLayout);
        }

        private RunOnDismissedListener(ResolverDrawerLayout resolverDrawerLayout) {
            this.this$0 = resolverDrawerLayout;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ResolverDrawerLayout_RunOnDismissedListener$__constructor__(com.android.internal.widget.ResolverDrawerLayout ), 0, this, resolverDrawerLayout);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_widget_ResolverDrawerLayout_RunOnDismissedListener$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(ResolverDrawerLayout resolverDrawerLayout, 1 var2_2) {
            this.$$robo$$com_android_internal_widget_ResolverDrawerLayout_RunOnDismissedListener$__constructor__(resolverDrawerLayout, var2_2);
        }

        public /* synthetic */ RunOnDismissedListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RunOnDismissedListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnDismissedListener
    extends InstrumentedInterface {
        public void onDismissed();
    }

    public static class SavedState
    extends View.BaseSavedState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        boolean open;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$com_android_internal_widget_ResolverDrawerLayout_SavedState$__constructor__(Parcelable superState) {
        }

        private void $$robo$$com_android_internal_widget_ResolverDrawerLayout_SavedState$__constructor__(Parcel in) {
            this.open = in.readInt() != 0;
        }

        private final void $$robo$$com_android_internal_widget_ResolverDrawerLayout_SavedState$writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.open ? 1 : 0);
        }

        private /* synthetic */ void $$robo$$com_android_internal_widget_ResolverDrawerLayout_SavedState$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$com_android_internal_widget_ResolverDrawerLayout_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$com_android_internal_widget_ResolverDrawerLayout_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in);
                }

                private final SavedState[] $$robo$$com_android_internal_widget_ResolverDrawerLayout_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$com_android_internal_widget_ResolverDrawerLayout_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ResolverDrawerLayout_SavedState_1$__constructor__(), 0, this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$com_android_internal_widget_ResolverDrawerLayout_SavedState_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$com_android_internal_widget_ResolverDrawerLayout_SavedState_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcelable parcelable) {
            this.$$robo$$com_android_internal_widget_ResolverDrawerLayout_SavedState$__constructor__(parcelable);
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ResolverDrawerLayout_SavedState$__constructor__(android.os.Parcelable ), 0, this, parcelable);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$com_android_internal_widget_ResolverDrawerLayout_SavedState$__constructor__(parcel);
        }

        private SavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ResolverDrawerLayout_SavedState$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_widget_ResolverDrawerLayout_SavedState$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$com_android_internal_widget_ResolverDrawerLayout_SavedState$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        public /* synthetic */ SavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public boolean alwaysShow;
        public boolean ignoreOffset;
        public boolean hasNestedScrollIndicator;

        private void $$robo$$com_android_internal_widget_ResolverDrawerLayout_LayoutParams$__constructor__(Context c, AttributeSet attrs) {
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.ResolverDrawerLayout_LayoutParams);
            this.alwaysShow = a.getBoolean(1, false);
            this.ignoreOffset = a.getBoolean(2, false);
            this.hasNestedScrollIndicator = a.getBoolean(3, false);
            a.recycle();
        }

        private void $$robo$$com_android_internal_widget_ResolverDrawerLayout_LayoutParams$__constructor__(int width, int height) {
        }

        private void $$robo$$com_android_internal_widget_ResolverDrawerLayout_LayoutParams$__constructor__(LayoutParams source) {
            this.alwaysShow = source.alwaysShow;
            this.ignoreOffset = source.ignoreOffset;
            this.hasNestedScrollIndicator = source.hasNestedScrollIndicator;
        }

        private void $$robo$$com_android_internal_widget_ResolverDrawerLayout_LayoutParams$__constructor__(ViewGroup.MarginLayoutParams source) {
        }

        private void $$robo$$com_android_internal_widget_ResolverDrawerLayout_LayoutParams$__constructor__(ViewGroup.LayoutParams source) {
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$com_android_internal_widget_ResolverDrawerLayout_LayoutParams$__constructor__(context, attributeSet);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ResolverDrawerLayout_LayoutParams$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$com_android_internal_widget_ResolverDrawerLayout_LayoutParams$__constructor__(n, n2);
        }

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ResolverDrawerLayout_LayoutParams$__constructor__(int int ), 0, this, n, n2);
        }

        private void __constructor__(LayoutParams layoutParams) {
            this.$$robo$$com_android_internal_widget_ResolverDrawerLayout_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ResolverDrawerLayout_LayoutParams$__constructor__(com.android.internal.widget.ResolverDrawerLayout$LayoutParams ), 0, this, layoutParams);
        }

        private void __constructor__(ViewGroup.MarginLayoutParams marginLayoutParams) {
            this.$$robo$$com_android_internal_widget_ResolverDrawerLayout_LayoutParams$__constructor__(marginLayoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ResolverDrawerLayout_LayoutParams$__constructor__(android.view.ViewGroup$MarginLayoutParams ), 0, this, marginLayoutParams);
        }

        private void __constructor__(ViewGroup.LayoutParams layoutParams) {
            this.$$robo$$com_android_internal_widget_ResolverDrawerLayout_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ResolverDrawerLayout_LayoutParams$__constructor__(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
        }

        public /* synthetic */ LayoutParams() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

