/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.ActionBar;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.DecelerateInterpolator;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;
import com.android.internal.view.ActionBarPolicy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ScrollingTabContainerView
extends HorizontalScrollView
implements AdapterView.OnItemClickListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ScrollingTabContainerView";
    Runnable mTabSelector;
    private TabClickListener mTabClickListener;
    private LinearLayout mTabLayout;
    private Spinner mTabSpinner;
    private boolean mAllowCollapse;
    int mMaxTabWidth;
    int mStackedTabMaxWidth;
    private int mContentHeight;
    private int mSelectedTabIndex;
    protected Animator mVisibilityAnim;
    protected VisibilityAnimListener mVisAnimListener;
    private static TimeInterpolator sAlphaInterpolator;
    private static int FADE_DURATION = 200;

    private void $$robo$$com_android_internal_widget_ScrollingTabContainerView$__constructor__(Context context) {
        this.mVisAnimListener = new VisibilityAnimListener(this);
        this.setHorizontalScrollBarEnabled(false);
        ActionBarPolicy abp = ActionBarPolicy.get(context);
        this.setContentHeight(abp.getTabContainerHeight());
        this.mStackedTabMaxWidth = abp.getStackedTabMaxWidth();
        this.mTabLayout = this.createTabLayout();
        this.addView((View)this.mTabLayout, new ViewGroup.LayoutParams(-2, -1));
    }

    private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean canCollapse;
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        boolean lockedExpanded = widthMode == 0x40000000;
        this.setFillViewport(lockedExpanded);
        int childCount = this.mTabLayout.getChildCount();
        if (childCount > 1 && (widthMode == 0x40000000 || widthMode == Integer.MIN_VALUE)) {
            this.mMaxTabWidth = childCount > 2 ? (int)((float)View.MeasureSpec.getSize(widthMeasureSpec) * 0.4f) : View.MeasureSpec.getSize(widthMeasureSpec) / 2;
            this.mMaxTabWidth = Math.min(this.mMaxTabWidth, this.mStackedTabMaxWidth);
        } else {
            this.mMaxTabWidth = -1;
        }
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(this.mContentHeight, 0x40000000);
        boolean bl = canCollapse = !lockedExpanded && this.mAllowCollapse;
        if (canCollapse) {
            this.mTabLayout.measure(0, heightMeasureSpec);
            if (this.mTabLayout.getMeasuredWidth() > View.MeasureSpec.getSize(widthMeasureSpec)) {
                this.performCollapse();
            } else {
                this.performExpand();
            }
        } else {
            this.performExpand();
        }
        int oldWidth = this.getMeasuredWidth();
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int newWidth = this.getMeasuredWidth();
        if (lockedExpanded && oldWidth != newWidth) {
            this.setTabSelected(this.mSelectedTabIndex);
        }
    }

    private final boolean $$robo$$com_android_internal_widget_ScrollingTabContainerView$isCollapsed() {
        return this.mTabSpinner != null && this.mTabSpinner.getParent() == this;
    }

    private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView$setAllowCollapse(boolean allowCollapse) {
        this.mAllowCollapse = allowCollapse;
    }

    private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView$performCollapse() {
        if (this.isCollapsed()) {
            return;
        }
        if (this.mTabSpinner == null) {
            this.mTabSpinner = this.createSpinner();
        }
        this.removeView(this.mTabLayout);
        this.addView((View)this.mTabSpinner, new ViewGroup.LayoutParams(-2, -1));
        if (this.mTabSpinner.getAdapter() == null) {
            TabAdapter adapter = new TabAdapter(this, this.mContext);
            adapter.setDropDownViewContext(this.mTabSpinner.getPopupContext());
            this.mTabSpinner.setAdapter(adapter);
        }
        if (this.mTabSelector != null) {
            this.removeCallbacks(this.mTabSelector);
            this.mTabSelector = null;
        }
        this.mTabSpinner.setSelection(this.mSelectedTabIndex);
    }

    private final boolean $$robo$$com_android_internal_widget_ScrollingTabContainerView$performExpand() {
        if (!this.isCollapsed()) {
            return false;
        }
        this.removeView(this.mTabSpinner);
        this.addView((View)this.mTabLayout, new ViewGroup.LayoutParams(-2, -1));
        this.setTabSelected(this.mTabSpinner.getSelectedItemPosition());
        return false;
    }

    private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView$setTabSelected(int position) {
        this.mSelectedTabIndex = position;
        int tabCount = this.mTabLayout.getChildCount();
        for (int i = 0; i < tabCount; ++i) {
            View child = this.mTabLayout.getChildAt(i);
            boolean isSelected = i == position;
            child.setSelected(isSelected);
            if (!isSelected) continue;
            this.animateToTab(position);
        }
        if (this.mTabSpinner != null && position >= 0) {
            this.mTabSpinner.setSelection(position);
        }
    }

    private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView$setContentHeight(int contentHeight) {
        this.mContentHeight = contentHeight;
        this.requestLayout();
    }

    private final LinearLayout $$robo$$com_android_internal_widget_ScrollingTabContainerView$createTabLayout() {
        LinearLayout tabLayout = new LinearLayout(this.getContext(), null, 16843508);
        tabLayout.setMeasureWithLargestChildEnabled(true);
        tabLayout.setGravity(17);
        tabLayout.setLayoutParams(new LinearLayout.LayoutParams(-2, -1));
        return tabLayout;
    }

    private final Spinner $$robo$$com_android_internal_widget_ScrollingTabContainerView$createSpinner() {
        Spinner spinner = new Spinner(this.getContext(), null, 16843479);
        spinner.setLayoutParams(new LinearLayout.LayoutParams(-2, -1));
        spinner.setOnItemClickListenerInt(this);
        return spinner;
    }

    private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView$onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        ActionBarPolicy abp = ActionBarPolicy.get(this.getContext());
        this.setContentHeight(abp.getTabContainerHeight());
        this.mStackedTabMaxWidth = abp.getStackedTabMaxWidth();
    }

    private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView$animateToVisibility(int visibility) {
        if (this.mVisibilityAnim != null) {
            this.mVisibilityAnim.cancel();
        }
        if (visibility == 0) {
            if (this.getVisibility() != 0) {
                this.setAlpha(0.0f);
            }
            ObjectAnimator anim2 = ObjectAnimator.ofFloat((Object)this, "alpha", 1.0f);
            anim2.setDuration(200L);
            anim2.setInterpolator(sAlphaInterpolator);
            anim2.addListener(this.mVisAnimListener.withFinalVisibility(visibility));
            anim2.start();
        } else {
            ObjectAnimator anim3 = ObjectAnimator.ofFloat((Object)this, "alpha", 0.0f);
            anim3.setDuration(200L);
            anim3.setInterpolator(sAlphaInterpolator);
            anim3.addListener(this.mVisAnimListener.withFinalVisibility(visibility));
            anim3.start();
        }
    }

    private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView$animateToTab(int position) {
        View tabView = this.mTabLayout.getChildAt(position);
        if (this.mTabSelector != null) {
            this.removeCallbacks(this.mTabSelector);
        }
        this.mTabSelector = new Runnable(this, tabView){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ View val$tabView;
            /* synthetic */ ScrollingTabContainerView this$0;

            private void $$robo$$com_android_internal_widget_ScrollingTabContainerView_1$__constructor__(ScrollingTabContainerView this$0, View view) {
            }

            private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView_1$run() {
                int scrollPos = this.val$tabView.getLeft() - (this.this$0.getWidth() - this.val$tabView.getWidth()) / 2;
                this.this$0.smoothScrollTo(scrollPos, 0);
                this.this$0.mTabSelector = null;
            }

            private void __constructor__(ScrollingTabContainerView scrollingTabContainerView, View view) {
                this.$$robo$$com_android_internal_widget_ScrollingTabContainerView_1$__constructor__(scrollingTabContainerView, view);
            }
            {
                this.this$0 = scrollingTabContainerView;
                this.val$tabView = view;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ScrollingTabContainerView_1$__constructor__(com.android.internal.widget.ScrollingTabContainerView android.view.View ), 0, this, scrollingTabContainerView, view);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_widget_ScrollingTabContainerView_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.post(this.mTabSelector);
    }

    private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView$onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mTabSelector != null) {
            this.post(this.mTabSelector);
        }
    }

    private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mTabSelector != null) {
            this.removeCallbacks(this.mTabSelector);
        }
    }

    private final TabView $$robo$$com_android_internal_widget_ScrollingTabContainerView$createTabView(Context context, ActionBar.Tab tab, boolean forAdapter) {
        TabView tabView = new TabView(this, context, tab, forAdapter);
        if (forAdapter) {
            tabView.setBackgroundDrawable(null);
            tabView.setLayoutParams(new AbsListView.LayoutParams(-1, this.mContentHeight));
        } else {
            tabView.setFocusable(true);
            if (this.mTabClickListener == null) {
                this.mTabClickListener = new TabClickListener(this);
            }
            tabView.setOnClickListener(this.mTabClickListener);
        }
        return tabView;
    }

    private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView$addTab(ActionBar.Tab tab, boolean setSelected) {
        TabView tabView = this.createTabView(this.mContext, tab, false);
        this.mTabLayout.addView((View)tabView, new LinearLayout.LayoutParams(0, -1, 1.0f));
        if (this.mTabSpinner != null) {
            ((TabAdapter)this.mTabSpinner.getAdapter()).notifyDataSetChanged();
        }
        if (setSelected) {
            tabView.setSelected(true);
        }
        if (this.mAllowCollapse) {
            this.requestLayout();
        }
    }

    private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView$addTab(ActionBar.Tab tab, int position, boolean setSelected) {
        TabView tabView = this.createTabView(this.mContext, tab, false);
        this.mTabLayout.addView((View)tabView, position, new LinearLayout.LayoutParams(0, -1, 1.0f));
        if (this.mTabSpinner != null) {
            ((TabAdapter)this.mTabSpinner.getAdapter()).notifyDataSetChanged();
        }
        if (setSelected) {
            tabView.setSelected(true);
        }
        if (this.mAllowCollapse) {
            this.requestLayout();
        }
    }

    private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView$updateTab(int position) {
        ((TabView)this.mTabLayout.getChildAt(position)).update();
        if (this.mTabSpinner != null) {
            ((TabAdapter)this.mTabSpinner.getAdapter()).notifyDataSetChanged();
        }
        if (this.mAllowCollapse) {
            this.requestLayout();
        }
    }

    private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView$removeTabAt(int position) {
        this.mTabLayout.removeViewAt(position);
        if (this.mTabSpinner != null) {
            ((TabAdapter)this.mTabSpinner.getAdapter()).notifyDataSetChanged();
        }
        if (this.mAllowCollapse) {
            this.requestLayout();
        }
    }

    private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView$removeAllTabs() {
        this.mTabLayout.removeAllViews();
        if (this.mTabSpinner != null) {
            ((TabAdapter)this.mTabSpinner.getAdapter()).notifyDataSetChanged();
        }
        if (this.mAllowCollapse) {
            this.requestLayout();
        }
    }

    private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView$onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        TabView tabView = (TabView)view;
        tabView.getTab().select();
    }

    static void __staticInitializer__() {
        sAlphaInterpolator = new DecelerateInterpolator();
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_ScrollingTabContainerView$__constructor__(context);
    }

    public ScrollingTabContainerView(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ScrollingTabContainerView$__constructor__(android.content.Context ), 0, this, context);
    }

    @Override
    public void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_ScrollingTabContainerView$onMeasure(int int ), 0, this, n, n2);
    }

    private boolean isCollapsed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCollapsed", $$robo$$com_android_internal_widget_ScrollingTabContainerView$isCollapsed(), 0, this);
    }

    public void setAllowCollapse(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAllowCollapse", $$robo$$com_android_internal_widget_ScrollingTabContainerView$setAllowCollapse(boolean ), 0, this, bl);
    }

    private void performCollapse() {
        InvokeDynamicSupport.bootstrap("performCollapse", $$robo$$com_android_internal_widget_ScrollingTabContainerView$performCollapse(), 0, this);
    }

    private boolean performExpand() {
        return (boolean)InvokeDynamicSupport.bootstrap("performExpand", $$robo$$com_android_internal_widget_ScrollingTabContainerView$performExpand(), 0, this);
    }

    public void setTabSelected(int n) {
        InvokeDynamicSupport.bootstrap("setTabSelected", $$robo$$com_android_internal_widget_ScrollingTabContainerView$setTabSelected(int ), 0, this, n);
    }

    public void setContentHeight(int n) {
        InvokeDynamicSupport.bootstrap("setContentHeight", $$robo$$com_android_internal_widget_ScrollingTabContainerView$setContentHeight(int ), 0, this, n);
    }

    private LinearLayout createTabLayout() {
        return InvokeDynamicSupport.bootstrap("createTabLayout", $$robo$$com_android_internal_widget_ScrollingTabContainerView$createTabLayout(), 0, this);
    }

    private Spinner createSpinner() {
        return InvokeDynamicSupport.bootstrap("createSpinner", $$robo$$com_android_internal_widget_ScrollingTabContainerView$createSpinner(), 0, this);
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$com_android_internal_widget_ScrollingTabContainerView$onConfigurationChanged(android.content.res.Configuration ), 0, this, configuration);
    }

    public void animateToVisibility(int n) {
        InvokeDynamicSupport.bootstrap("animateToVisibility", $$robo$$com_android_internal_widget_ScrollingTabContainerView$animateToVisibility(int ), 0, this, n);
    }

    public void animateToTab(int n) {
        InvokeDynamicSupport.bootstrap("animateToTab", $$robo$$com_android_internal_widget_ScrollingTabContainerView$animateToTab(int ), 0, this, n);
    }

    @Override
    public void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$com_android_internal_widget_ScrollingTabContainerView$onAttachedToWindow(), 0, this);
    }

    @Override
    public void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$com_android_internal_widget_ScrollingTabContainerView$onDetachedFromWindow(), 0, this);
    }

    private TabView createTabView(Context context, ActionBar.Tab tab, boolean bl) {
        return InvokeDynamicSupport.bootstrap("createTabView", $$robo$$com_android_internal_widget_ScrollingTabContainerView$createTabView(android.content.Context android.app.ActionBar$Tab boolean ), 0, this, context, tab, bl);
    }

    public void addTab(ActionBar.Tab tab, boolean bl) {
        InvokeDynamicSupport.bootstrap("addTab", $$robo$$com_android_internal_widget_ScrollingTabContainerView$addTab(android.app.ActionBar$Tab boolean ), 0, this, tab, bl);
    }

    public void addTab(ActionBar.Tab tab, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("addTab", $$robo$$com_android_internal_widget_ScrollingTabContainerView$addTab(android.app.ActionBar$Tab int boolean ), 0, this, tab, n, bl);
    }

    public void updateTab(int n) {
        InvokeDynamicSupport.bootstrap("updateTab", $$robo$$com_android_internal_widget_ScrollingTabContainerView$updateTab(int ), 0, this, n);
    }

    public void removeTabAt(int n) {
        InvokeDynamicSupport.bootstrap("removeTabAt", $$robo$$com_android_internal_widget_ScrollingTabContainerView$removeTabAt(int ), 0, this, n);
    }

    public void removeAllTabs() {
        InvokeDynamicSupport.bootstrap("removeAllTabs", $$robo$$com_android_internal_widget_ScrollingTabContainerView$removeAllTabs(), 0, this);
    }

    @Override
    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        InvokeDynamicSupport.bootstrap("onItemClick", $$robo$$com_android_internal_widget_ScrollingTabContainerView$onItemClick(android.widget.AdapterView<?> android.view.View int long ), 0, this, adapterView, view, n, l);
    }

    static {
        RobolectricInternals.classInitializing(ScrollingTabContainerView.class);
    }

    public /* synthetic */ ScrollingTabContainerView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScrollingTabContainerView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    protected class VisibilityAnimListener
    implements Animator.AnimatorListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private boolean mCanceled;
        private int mFinalVisibility;
        /* synthetic */ ScrollingTabContainerView this$0;

        private void $$robo$$com_android_internal_widget_ScrollingTabContainerView_VisibilityAnimListener$__constructor__(ScrollingTabContainerView this$0) {
            this.mCanceled = false;
        }

        private final VisibilityAnimListener $$robo$$com_android_internal_widget_ScrollingTabContainerView_VisibilityAnimListener$withFinalVisibility(int visibility) {
            this.mFinalVisibility = visibility;
            return this;
        }

        private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView_VisibilityAnimListener$onAnimationStart(Animator animation) {
            this.this$0.setVisibility(0);
            this.this$0.mVisibilityAnim = animation;
            this.mCanceled = false;
        }

        private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView_VisibilityAnimListener$onAnimationEnd(Animator animation) {
            if (this.mCanceled) {
                return;
            }
            this.this$0.mVisibilityAnim = null;
            this.this$0.setVisibility(this.mFinalVisibility);
        }

        private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView_VisibilityAnimListener$onAnimationCancel(Animator animation) {
            this.mCanceled = true;
        }

        private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView_VisibilityAnimListener$onAnimationRepeat(Animator animation) {
        }

        private void __constructor__(ScrollingTabContainerView scrollingTabContainerView) {
            this.$$robo$$com_android_internal_widget_ScrollingTabContainerView_VisibilityAnimListener$__constructor__(scrollingTabContainerView);
        }

        protected VisibilityAnimListener(ScrollingTabContainerView scrollingTabContainerView) {
            this.this$0 = scrollingTabContainerView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ScrollingTabContainerView_VisibilityAnimListener$__constructor__(com.android.internal.widget.ScrollingTabContainerView ), 0, this, scrollingTabContainerView);
        }

        public VisibilityAnimListener withFinalVisibility(int n) {
            return InvokeDynamicSupport.bootstrap("withFinalVisibility", $$robo$$com_android_internal_widget_ScrollingTabContainerView_VisibilityAnimListener$withFinalVisibility(int ), 0, this, n);
        }

        @Override
        public void onAnimationStart(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$com_android_internal_widget_ScrollingTabContainerView_VisibilityAnimListener$onAnimationStart(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationEnd(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_ScrollingTabContainerView_VisibilityAnimListener$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationCancel(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationCancel", $$robo$$com_android_internal_widget_ScrollingTabContainerView_VisibilityAnimListener$onAnimationCancel(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationRepeat(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationRepeat", $$robo$$com_android_internal_widget_ScrollingTabContainerView_VisibilityAnimListener$onAnimationRepeat(android.animation.Animator ), 0, this, animator2);
        }

        public /* synthetic */ VisibilityAnimListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VisibilityAnimListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class TabClickListener
    implements View.OnClickListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ScrollingTabContainerView this$0;

        private void $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabClickListener$__constructor__(ScrollingTabContainerView scrollingTabContainerView) {
        }

        private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabClickListener$onClick(View view) {
            TabView tabView = (TabView)view;
            tabView.getTab().select();
            int tabCount = this.this$0.mTabLayout.getChildCount();
            for (int i = 0; i < tabCount; ++i) {
                View child;
                child.setSelected((child = this.this$0.mTabLayout.getChildAt(i)) == view);
            }
        }

        private /* synthetic */ void $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabClickListener$__constructor__(ScrollingTabContainerView x0, 1 x1) {
        }

        private void __constructor__(ScrollingTabContainerView scrollingTabContainerView) {
            this.$$robo$$com_android_internal_widget_ScrollingTabContainerView_TabClickListener$__constructor__(scrollingTabContainerView);
        }

        private TabClickListener(ScrollingTabContainerView scrollingTabContainerView) {
            this.this$0 = scrollingTabContainerView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabClickListener$__constructor__(com.android.internal.widget.ScrollingTabContainerView ), 0, this, scrollingTabContainerView);
        }

        @Override
        public void onClick(View view) {
            InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabClickListener$onClick(android.view.View ), 0, this, view);
        }

        private /* synthetic */ void __constructor__(ScrollingTabContainerView scrollingTabContainerView, 1 var2_2) {
            this.$$robo$$com_android_internal_widget_ScrollingTabContainerView_TabClickListener$__constructor__(scrollingTabContainerView, var2_2);
        }

        public /* synthetic */ TabClickListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TabClickListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class TabAdapter
    extends BaseAdapter
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Context mDropDownContext;
        /* synthetic */ ScrollingTabContainerView this$0;

        private void $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabAdapter$__constructor__(ScrollingTabContainerView scrollingTabContainerView, Context context) {
            this.setDropDownViewContext(context);
        }

        private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabAdapter$setDropDownViewContext(Context context) {
            this.mDropDownContext = context;
        }

        private final int $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabAdapter$getCount() {
            return this.this$0.mTabLayout.getChildCount();
        }

        private final Object $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabAdapter$getItem(int position) {
            return ((TabView)this.this$0.mTabLayout.getChildAt(position)).getTab();
        }

        private final long $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabAdapter$getItemId(int position) {
            return position;
        }

        private final View $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabAdapter$getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = this.this$0.createTabView(this.this$0.mContext, (ActionBar.Tab)this.getItem(position), true);
            } else {
                ((TabView)convertView).bindTab((ActionBar.Tab)this.getItem(position));
            }
            return convertView;
        }

        private final View $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabAdapter$getDropDownView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = this.this$0.createTabView(this.mDropDownContext, (ActionBar.Tab)this.getItem(position), true);
            } else {
                ((TabView)convertView).bindTab((ActionBar.Tab)this.getItem(position));
            }
            return convertView;
        }

        private void __constructor__(ScrollingTabContainerView scrollingTabContainerView, Context context) {
            this.$$robo$$com_android_internal_widget_ScrollingTabContainerView_TabAdapter$__constructor__(scrollingTabContainerView, context);
        }

        public TabAdapter(ScrollingTabContainerView scrollingTabContainerView, Context context) {
            this.this$0 = scrollingTabContainerView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabAdapter$__constructor__(com.android.internal.widget.ScrollingTabContainerView android.content.Context ), 0, this, scrollingTabContainerView, context);
        }

        public void setDropDownViewContext(Context context) {
            InvokeDynamicSupport.bootstrap("setDropDownViewContext", $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabAdapter$setDropDownViewContext(android.content.Context ), 0, this, context);
        }

        @Override
        public int getCount() {
            return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabAdapter$getCount(), 0, this);
        }

        @Override
        public Object getItem(int n) {
            return InvokeDynamicSupport.bootstrap("getItem", $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabAdapter$getItem(int ), 0, this, n);
        }

        @Override
        public long getItemId(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabAdapter$getItemId(int ), 0, this, n);
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            return InvokeDynamicSupport.bootstrap("getView", $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabAdapter$getView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
        }

        @Override
        public View getDropDownView(int n, View view, ViewGroup viewGroup) {
            return InvokeDynamicSupport.bootstrap("getDropDownView", $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabAdapter$getDropDownView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
        }

        public /* synthetic */ TabAdapter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TabAdapter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class TabView
    extends LinearLayout
    implements View.OnLongClickListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ActionBar.Tab mTab;
        private TextView mTextView;
        private ImageView mIconView;
        private View mCustomView;
        /* synthetic */ ScrollingTabContainerView this$0;

        private void $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabView$__constructor__(ScrollingTabContainerView scrollingTabContainerView, Context context, ActionBar.Tab tab, boolean forList) {
            this.mTab = tab;
            if (forList) {
                this.setGravity(8388627);
            }
            this.update();
        }

        private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabView$bindTab(ActionBar.Tab tab) {
            this.mTab = tab;
            this.update();
        }

        private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabView$setSelected(boolean selected) {
            boolean changed = this.isSelected() != selected;
            super.setSelected(selected);
            if (changed && selected) {
                this.sendAccessibilityEvent(4);
            }
        }

        private final CharSequence $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabView$getAccessibilityClassName() {
            return ActionBar.Tab.class.getName();
        }

        private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if (this.this$0.mMaxTabWidth > 0 && this.getMeasuredWidth() > this.this$0.mMaxTabWidth) {
                super.onMeasure(View.MeasureSpec.makeMeasureSpec(this.this$0.mMaxTabWidth, 0x40000000), heightMeasureSpec);
            }
        }

        private final void $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabView$update() {
            ActionBar.Tab tab = this.mTab;
            View custom = tab.getCustomView();
            if (custom != null) {
                ViewParent customParent = custom.getParent();
                if (customParent != this) {
                    if (customParent != null) {
                        ((ViewGroup)customParent).removeView(custom);
                    }
                    this.addView(custom);
                }
                this.mCustomView = custom;
                if (this.mTextView != null) {
                    this.mTextView.setVisibility(8);
                }
                if (this.mIconView != null) {
                    this.mIconView.setVisibility(8);
                    this.mIconView.setImageDrawable(null);
                }
            } else {
                boolean hasText;
                if (this.mCustomView != null) {
                    this.removeView(this.mCustomView);
                    this.mCustomView = null;
                }
                Drawable icon = tab.getIcon();
                CharSequence text = tab.getText();
                if (icon != null) {
                    if (this.mIconView == null) {
                        ImageView iconView = new ImageView(this.getContext());
                        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
                        lp.gravity = 16;
                        iconView.setLayoutParams(lp);
                        this.addView((View)iconView, 0);
                        this.mIconView = iconView;
                    }
                    this.mIconView.setImageDrawable(icon);
                    this.mIconView.setVisibility(0);
                } else if (this.mIconView != null) {
                    this.mIconView.setVisibility(8);
                    this.mIconView.setImageDrawable(null);
                }
                boolean bl = hasText = !TextUtils.isEmpty(text);
                if (hasText) {
                    if (this.mTextView == null) {
                        TextView textView = new TextView(this.getContext(), null, 16843509);
                        textView.setEllipsize(TextUtils.TruncateAt.END);
                        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
                        lp.gravity = 16;
                        textView.setLayoutParams(lp);
                        this.addView(textView);
                        this.mTextView = textView;
                    }
                    this.mTextView.setText(text);
                    this.mTextView.setVisibility(0);
                } else if (this.mTextView != null) {
                    this.mTextView.setVisibility(8);
                    this.mTextView.setText(null);
                }
                if (this.mIconView != null) {
                    this.mIconView.setContentDescription(tab.getContentDescription());
                }
                if (!hasText && !TextUtils.isEmpty(tab.getContentDescription())) {
                    this.setOnLongClickListener(this);
                } else {
                    this.setOnLongClickListener(null);
                    this.setLongClickable(false);
                }
            }
        }

        private final boolean $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabView$onLongClick(View v) {
            int[] screenPos = new int[2];
            this.getLocationOnScreen(screenPos);
            Context context = this.getContext();
            int width = this.getWidth();
            int height = this.getHeight();
            int screenWidth = context.getResources().getDisplayMetrics().widthPixels;
            Toast cheatSheet = Toast.makeText(context, this.mTab.getContentDescription(), 0);
            cheatSheet.setGravity(49, screenPos[0] + width / 2 - screenWidth / 2, height);
            cheatSheet.show();
            return true;
        }

        private final ActionBar.Tab $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabView$getTab() {
            return this.mTab;
        }

        private void __constructor__(ScrollingTabContainerView scrollingTabContainerView, Context context, ActionBar.Tab tab, boolean bl) {
            this.$$robo$$com_android_internal_widget_ScrollingTabContainerView_TabView$__constructor__(scrollingTabContainerView, context, tab, bl);
        }

        public TabView(ScrollingTabContainerView scrollingTabContainerView, Context context, ActionBar.Tab tab, boolean bl) {
            this.this$0 = scrollingTabContainerView;
            super(context, null, 16843507);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabView$__constructor__(com.android.internal.widget.ScrollingTabContainerView android.content.Context android.app.ActionBar$Tab boolean ), 0, this, scrollingTabContainerView, context, tab, bl);
        }

        public void bindTab(ActionBar.Tab tab) {
            InvokeDynamicSupport.bootstrap("bindTab", $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabView$bindTab(android.app.ActionBar$Tab ), 0, this, tab);
        }

        @Override
        public void setSelected(boolean bl) {
            InvokeDynamicSupport.bootstrap("setSelected", $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabView$setSelected(boolean ), 0, this, bl);
        }

        @Override
        public CharSequence getAccessibilityClassName() {
            return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabView$getAccessibilityClassName(), 0, this);
        }

        @Override
        public void onMeasure(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabView$onMeasure(int int ), 0, this, n, n2);
        }

        public void update() {
            InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabView$update(), 0, this);
        }

        @Override
        public boolean onLongClick(View view) {
            return (boolean)InvokeDynamicSupport.bootstrap("onLongClick", $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabView$onLongClick(android.view.View ), 0, this, view);
        }

        public ActionBar.Tab getTab() {
            return InvokeDynamicSupport.bootstrap("getTab", $$robo$$com_android_internal_widget_ScrollingTabContainerView_TabView$getTab(), 0, this);
        }

        public /* synthetic */ TabView() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TabView)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

