/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SwipeDismissLayout
extends FrameLayout
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SwipeDismissLayout";
    private static float DISMISS_MIN_DRAG_WIDTH_RATIO = 0.33f;
    private boolean mUseDynamicTranslucency;
    private int mSlop;
    private int mMinFlingVelocity;
    private int mActiveTouchId;
    private float mDownX;
    private float mDownY;
    private boolean mSwiping;
    private boolean mDismissed;
    private boolean mDiscardIntercept;
    private VelocityTracker mVelocityTracker;
    private float mTranslationX;
    private OnDismissedListener mDismissedListener;
    private OnSwipeProgressChangedListener mProgressListener;
    private ViewTreeObserver.OnEnterAnimationCompleteListener mOnEnterAnimationCompleteListener;
    private BroadcastReceiver mScreenOffReceiver;
    private IntentFilter mScreenOffFilter;
    private float mLastX;

    private void $$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(Context context) {
        this.mUseDynamicTranslucency = true;
        this.mOnEnterAnimationCompleteListener = new ViewTreeObserver.OnEnterAnimationCompleteListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SwipeDismissLayout this$0;

            private void $$robo$$com_android_internal_widget_SwipeDismissLayout_1$__constructor__(SwipeDismissLayout this$0) {
            }

            private final void $$robo$$com_android_internal_widget_SwipeDismissLayout_1$onEnterAnimationComplete() {
                if (this.this$0.mUseDynamicTranslucency && this.this$0.getContext() instanceof Activity) {
                    ((Activity)this.this$0.getContext()).convertFromTranslucent();
                }
            }

            private void __constructor__(SwipeDismissLayout swipeDismissLayout) {
                this.$$robo$$com_android_internal_widget_SwipeDismissLayout_1$__constructor__(swipeDismissLayout);
            }
            {
                this.this$0 = swipeDismissLayout;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SwipeDismissLayout_1$__constructor__(com.android.internal.widget.SwipeDismissLayout ), 0, this, swipeDismissLayout);
            }

            @Override
            public void onEnterAnimationComplete() {
                InvokeDynamicSupport.bootstrap("onEnterAnimationComplete", $$robo$$com_android_internal_widget_SwipeDismissLayout_1$onEnterAnimationComplete(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mScreenOffReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            private Runnable mRunnable;
            /* synthetic */ SwipeDismissLayout this$0;

            private void $$robo$$com_android_internal_widget_SwipeDismissLayout_2$__constructor__(SwipeDismissLayout this$0) {
                this.mRunnable = new Runnable(this){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ 2 this$1;

                    private void $$robo$$com_android_internal_widget_SwipeDismissLayout_2_1$__constructor__(2 this$1) {
                    }

                    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout_2_1$run() {
                        if (this.this$1.this$0.mDismissed) {
                            this.this$1.this$0.dismiss();
                        } else {
                            this.this$1.this$0.cancel();
                        }
                        this.this$1.this$0.resetMembers();
                    }

                    private void __constructor__(2 var1_1) {
                        this.$$robo$$com_android_internal_widget_SwipeDismissLayout_2_1$__constructor__(var1_1);
                    }
                    {
                        this.this$1 = var1_1;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SwipeDismissLayout_2_1$__constructor__(com.android.internal.widget.SwipeDismissLayout$2 ), 0, this, var1_1);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_widget_SwipeDismissLayout_2_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
            }

            private final void $$robo$$com_android_internal_widget_SwipeDismissLayout_2$onReceive(Context context, Intent intent) {
                this.this$0.post(this.mRunnable);
            }

            private void __constructor__(SwipeDismissLayout swipeDismissLayout) {
                this.$$robo$$com_android_internal_widget_SwipeDismissLayout_2$__constructor__(swipeDismissLayout);
            }
            {
                this.this$0 = swipeDismissLayout;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SwipeDismissLayout_2$__constructor__(com.android.internal.widget.SwipeDismissLayout ), 0, this, swipeDismissLayout);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_widget_SwipeDismissLayout_2$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mScreenOffFilter = new IntentFilter("android.intent.action.SCREEN_OFF");
        this.init(context);
    }

    private void $$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(Context context, AttributeSet attrs) {
        this.mUseDynamicTranslucency = true;
        this.mOnEnterAnimationCompleteListener = new /* invalid duplicate definition of identical inner class */;
        this.mScreenOffReceiver = new /* invalid duplicate definition of identical inner class */;
        this.mScreenOffFilter = new IntentFilter("android.intent.action.SCREEN_OFF");
        this.init(context);
    }

    private void $$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(Context context, AttributeSet attrs, int defStyle) {
        this.mUseDynamicTranslucency = true;
        this.mOnEnterAnimationCompleteListener = new /* invalid duplicate definition of identical inner class */;
        this.mScreenOffReceiver = new /* invalid duplicate definition of identical inner class */;
        this.mScreenOffFilter = new IntentFilter("android.intent.action.SCREEN_OFF");
        this.init(context);
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$init(Context context) {
        ViewConfiguration vc = ViewConfiguration.get(context);
        this.mSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity();
        TypedArray a = context.getTheme().obtainStyledAttributes(R.styleable.Theme);
        this.mUseDynamicTranslucency = !a.hasValue(5);
        a.recycle();
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$setOnDismissedListener(OnDismissedListener listener) {
        this.mDismissedListener = listener;
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$setOnSwipeProgressChangedListener(OnSwipeProgressChangedListener listener) {
        this.mProgressListener = listener;
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.getContext() instanceof Activity) {
            this.getViewTreeObserver().addOnEnterAnimationCompleteListener(this.mOnEnterAnimationCompleteListener);
        }
        this.getContext().registerReceiver(this.mScreenOffReceiver, this.mScreenOffFilter);
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$onDetachedFromWindow() {
        this.getContext().unregisterReceiver(this.mScreenOffReceiver);
        if (this.getContext() instanceof Activity) {
            this.getViewTreeObserver().removeOnEnterAnimationCompleteListener(this.mOnEnterAnimationCompleteListener);
        }
        super.onDetachedFromWindow();
    }

    private final boolean $$robo$$com_android_internal_widget_SwipeDismissLayout$onInterceptTouchEvent(MotionEvent ev) {
        ev.offsetLocation(this.mTranslationX, 0.0f);
        switch (ev.getActionMasked()) {
            case 0: {
                this.resetMembers();
                this.mDownX = ev.getRawX();
                this.mDownY = ev.getRawY();
                this.mActiveTouchId = ev.getPointerId(0);
                this.mVelocityTracker = VelocityTracker.obtain();
                this.mVelocityTracker.addMovement(ev);
                break;
            }
            case 5: {
                int actionIndex = ev.getActionIndex();
                this.mActiveTouchId = ev.getPointerId(actionIndex);
                break;
            }
            case 6: {
                int actionIndex = ev.getActionIndex();
                int pointerId = ev.getPointerId(actionIndex);
                if (pointerId != this.mActiveTouchId) break;
                int newActionIndex = actionIndex == 0 ? 1 : 0;
                this.mActiveTouchId = ev.getPointerId(newActionIndex);
                break;
            }
            case 1: 
            case 3: {
                this.resetMembers();
                break;
            }
            case 2: {
                if (this.mVelocityTracker == null || this.mDiscardIntercept) break;
                int pointerIndex = ev.findPointerIndex(this.mActiveTouchId);
                if (pointerIndex == -1) {
                    Log.e("SwipeDismissLayout", "Invalid pointer index: ignoring.");
                    this.mDiscardIntercept = true;
                    break;
                }
                float dx = ev.getRawX() - this.mDownX;
                float x = ev.getX(pointerIndex);
                float y = ev.getY(pointerIndex);
                if (dx != 0.0f && this.canScroll(this, false, dx, x, y)) {
                    this.mDiscardIntercept = true;
                    break;
                }
                this.updateSwiping(ev);
            }
        }
        return !this.mDiscardIntercept && this.mSwiping;
    }

    private final boolean $$robo$$com_android_internal_widget_SwipeDismissLayout$onTouchEvent(MotionEvent ev) {
        if (this.mVelocityTracker == null) {
            return super.onTouchEvent(ev);
        }
        ev.offsetLocation(this.mTranslationX, 0.0f);
        switch (ev.getActionMasked()) {
            case 1: {
                this.updateDismiss(ev);
                if (this.mDismissed) {
                    this.dismiss();
                } else if (this.mSwiping) {
                    this.cancel();
                }
                this.resetMembers();
                break;
            }
            case 3: {
                this.cancel();
                this.resetMembers();
                break;
            }
            case 2: {
                this.mVelocityTracker.addMovement(ev);
                this.mLastX = ev.getRawX();
                this.updateSwiping(ev);
                if (!this.mSwiping) break;
                if (this.mUseDynamicTranslucency && this.getContext() instanceof Activity) {
                    ((Activity)this.getContext()).convertToTranslucent(null, null);
                }
                this.setProgress(ev.getRawX() - this.mDownX);
            }
        }
        return true;
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$setProgress(float deltaX) {
        this.mTranslationX = deltaX;
        if (this.mProgressListener != null && deltaX >= 0.0f) {
            this.mProgressListener.onSwipeProgressChanged(this, deltaX / (float)this.getWidth(), deltaX);
        }
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$dismiss() {
        if (this.mDismissedListener != null) {
            this.mDismissedListener.onDismissed(this);
        }
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$cancel() {
        if (this.mUseDynamicTranslucency && this.getContext() instanceof Activity) {
            ((Activity)this.getContext()).convertFromTranslucent();
        }
        if (this.mProgressListener != null) {
            this.mProgressListener.onSwipeCancelled(this);
        }
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$resetMembers() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
        }
        this.mVelocityTracker = null;
        this.mTranslationX = 0.0f;
        this.mDownX = 0.0f;
        this.mDownY = 0.0f;
        this.mSwiping = false;
        this.mDismissed = false;
        this.mDiscardIntercept = false;
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$updateSwiping(MotionEvent ev) {
        if (!this.mSwiping) {
            float deltaY;
            float deltaX = ev.getRawX() - this.mDownX;
            this.mSwiping = deltaX * deltaX + (deltaY = ev.getRawY() - this.mDownY) * deltaY > (float)(this.mSlop * this.mSlop) ? deltaX > (float)(this.mSlop * 2) && Math.abs(deltaY) < Math.abs(deltaX) : false;
        }
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$updateDismiss(MotionEvent ev) {
        float deltaX = ev.getRawX() - this.mDownX;
        this.mVelocityTracker.addMovement(ev);
        this.mVelocityTracker.computeCurrentVelocity(1000);
        if (!this.mDismissed && deltaX > (float)this.getWidth() * 0.33f && ev.getRawX() >= this.mLastX) {
            this.mDismissed = true;
        }
        if (this.mDismissed && this.mSwiping && (deltaX < (float)this.getWidth() * 0.33f || this.mVelocityTracker.getXVelocity() < (float)(-this.mMinFlingVelocity))) {
            this.mDismissed = false;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_SwipeDismissLayout$canScroll(View v, boolean checkV, float dx, float x, float y) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int scrollX = v.getScrollX();
            int scrollY = v.getScrollY();
            int count = group.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                if (!(x + (float)scrollX >= (float)child.getLeft()) || !(x + (float)scrollX < (float)child.getRight()) || !(y + (float)scrollY >= (float)child.getTop()) || !(y + (float)scrollY < (float)child.getBottom()) || !this.canScroll(child, true, dx, x + (float)scrollX - (float)child.getLeft(), y + (float)scrollY - (float)child.getTop())) continue;
                return true;
            }
        }
        return checkV && v.canScrollHorizontally((int)(-dx));
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(context);
    }

    public SwipeDismissLayout(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(context, attributeSet);
    }

    public SwipeDismissLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(context, attributeSet, n);
    }

    public SwipeDismissLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void init(Context context) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$com_android_internal_widget_SwipeDismissLayout$init(android.content.Context ), 0, this, context);
    }

    public void setOnDismissedListener(OnDismissedListener onDismissedListener) {
        InvokeDynamicSupport.bootstrap("setOnDismissedListener", $$robo$$com_android_internal_widget_SwipeDismissLayout$setOnDismissedListener(com.android.internal.widget.SwipeDismissLayout$OnDismissedListener ), 0, this, onDismissedListener);
    }

    public void setOnSwipeProgressChangedListener(OnSwipeProgressChangedListener onSwipeProgressChangedListener) {
        InvokeDynamicSupport.bootstrap("setOnSwipeProgressChangedListener", $$robo$$com_android_internal_widget_SwipeDismissLayout$setOnSwipeProgressChangedListener(com.android.internal.widget.SwipeDismissLayout$OnSwipeProgressChangedListener ), 0, this, onSwipeProgressChangedListener);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$com_android_internal_widget_SwipeDismissLayout$onAttachedToWindow(), 0, this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$com_android_internal_widget_SwipeDismissLayout$onDetachedFromWindow(), 0, this);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$com_android_internal_widget_SwipeDismissLayout$onInterceptTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$com_android_internal_widget_SwipeDismissLayout$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void setProgress(float f) {
        InvokeDynamicSupport.bootstrap("setProgress", $$robo$$com_android_internal_widget_SwipeDismissLayout$setProgress(float ), 0, this, f);
    }

    private void dismiss() {
        InvokeDynamicSupport.bootstrap("dismiss", $$robo$$com_android_internal_widget_SwipeDismissLayout$dismiss(), 0, this);
    }

    protected void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$com_android_internal_widget_SwipeDismissLayout$cancel(), 0, this);
    }

    private void resetMembers() {
        InvokeDynamicSupport.bootstrap("resetMembers", $$robo$$com_android_internal_widget_SwipeDismissLayout$resetMembers(), 0, this);
    }

    private void updateSwiping(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("updateSwiping", $$robo$$com_android_internal_widget_SwipeDismissLayout$updateSwiping(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void updateDismiss(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("updateDismiss", $$robo$$com_android_internal_widget_SwipeDismissLayout$updateDismiss(android.view.MotionEvent ), 0, this, motionEvent);
    }

    protected boolean canScroll(View view, boolean bl, float f, float f2, float f3) {
        return (boolean)InvokeDynamicSupport.bootstrap("canScroll", $$robo$$com_android_internal_widget_SwipeDismissLayout$canScroll(android.view.View boolean float float float ), 0, this, view, bl, f, f2, f3);
    }

    public /* synthetic */ SwipeDismissLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SwipeDismissLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnSwipeProgressChangedListener
    extends InstrumentedInterface {
        public void onSwipeProgressChanged(SwipeDismissLayout var1, float var2, float var3);

        public void onSwipeCancelled(SwipeDismissLayout var1);
    }

    public static interface OnDismissedListener
    extends InstrumentedInterface {
        public void onDismissed(SwipeDismissLayout var1);
    }
}

